---
title: "Compiler Error CS1677 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1677"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1677"
ms.assetid: 8c974669-15c6-4010-8b02-21021bed5af9
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1677
Parameter 'number' should not be declared with the 'keyword' keyword  
  
 This error occurs when the parameter type modifier in an anonymous method does not match that used in the declaration of the delegate, to which you are casting the method.  
  
## Example  
 The following sample generates CS1677:  
  
```  
// CS1677.cs  
delegate void D(int i);  
class Errors  
{  
    static void Main()   
    {  
        D d = delegate(out int i) { };   // CS1677  
        // To resolve, use the following line instead:  
        // D d = delegate(int i) { };  
  
        D d = delegate(ref int j){}; // CS1677  
        // To resolve, use the following line instead:  
        // D d = delegate(int j){};  
    }  
}  
```