---
title: "Compiler Error CS1688 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1688"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1688"
ms.assetid: e15672a1-2570-4e65-99fc-7acc190ae643
caps.latest.revision: 12
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1688
Cannot convert anonymous method block without a parameter list to delegate type 'delegate' because it has one or more out parameters  
  
 The compiler allows parameters to be omitted from an anonymous method block in most cases. This error arises when the anonymous method block does not have a parameter list, but the delegate has an `out` parameter. The compiler does not allow this situation because it would need to ignore the presence of the `out` parameter, which is unlikely to be the correct behavior.  
  
## Example  
 The following code generates error CS1688.  
  
```  
// CS1688.cs  
using System;  
delegate void OutParam(out int i);  
class ErrorCS1676  
{  
    static void Main()   
    {  
        OutParam o;  
        o = delegate  // CS1688  
        // Try this instead:  
        // o = delegate(out int i)  
        {   
            Console.WriteLine("");  
        };  
    }  
}  
```