---
title: "Compiler Warning (level 3) CS1717 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1717"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1717"
ms.assetid: 5b150a2c-5d61-4cd8-b4d4-e6c2b93b52c6
caps.latest.revision: 14
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 3) CS1717
Assignment made to same variable; did you mean to assign something else?  
  
 This warning occurs when you assign a variable to itself, such as `a = a`.  
  
 Several common mistakes can generate this warning:  
  
-   Writing `a = a` as the condition of an **if** statement, such as `if (a = a)`. You probably meant to say `if (a == a)`, which is always true, so you could write this more concisely as `if (true)`.  
  
-   Mistyping. You probably meant to say `a = b`.  
  
-   In a constructor where the parameter has the same name as the field, not using the **this** keyword: you probably meant to say `this.a = a`.  
  
## Example  
 The following sample generates CS1717.  
  
```  
// CS1717.cs  
// compile with: /W:3  
public class Test  
{  
   public static void Main()  
   {  
      int x = 0;  
      x = x;   // CS1717  
   }  
}  
```