---
title: "Compiler Error CS1925 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1925"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1925"
ms.assetid: b60806a5-2ccf-47f5-873b-7ac2292fdb54
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1925
Cannot initialize object of type 'type' with a collection initializer.  
  
 Collection initializers are only allowed for collection classes that meet certain criteria. For more information, see [Object and Collection Initializers](../../csharp/programming-guide/classes-and-structs/object-and-collection-initializers.md). This error is also produced when you try to use the short form of an array initializer nested inside a collection initializer.  
  
## To correct this error  
  
1.  Initialize the object by calling its constructors and methods.  
  
## Example  
 The following code generates CS1925:  
  
```  
// cs1925.cs  
public class Student  
{  
    public int[] Scores;  
}  
  
class Test  
{  
    static void Main(string[] args)  
    {  
        Student student = new Student { Scores = { 1, 2, 3 } }; // CS1925  
    }  
}  
```