---
title: "Compiler Warning (level 1) CS3002 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS3002"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS3002"
ms.assetid: 34f19735-76d2-4d78-bd52-45989a86fca4
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 1) CS3002
Return type of 'method' is not CLS-compliant  
  
 A [public](../../csharp/language-reference/keywords/public.md), [protected](../../csharp/language-reference/keywords/protected.md), or `protected``internal` method must return a value whose type is compliant with the Common Language Specification (CLS). For more information on CLS Compliance, see [Writing CLS-Compliant Code](http://msdn.microsoft.com/en-us/4c705105-69a2-4e5e-b24e-0633bc32c7f3) and [Language Independence and Language-Independent Components](https://msdn.microsoft.com/library/12a7a7h3).  
  
## Example  
 The following example generates CS3002:  
  
```  
// CS3002.cs  
  
[assembly:System.CLSCompliant(true)]  
public class a  
{  
    public ushort bad()   // CS3002, public method  
    {  
        ushort a;  
        a = ushort.MaxValue;  
        return a;  
    }  
  
    private ushort OK()   // OK, private method  
    {  
        ushort a;  
        a = ushort.MaxValue;  
        return a;  
    }  
  
    public static void Main()  
    {  
    }  
}  
```