---
title: "Creating XML Trees (C#) | Microsoft Docs"
ms.custom: ""
ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
dev_langs: 
  - "CSharp"
ms.assetid: bccc3e0a-c08c-468e-9d30-e075670fdace
caps.latest.revision: 3
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Creating XML Trees (C#)
One of the most common XML tasks is constructing an XML tree. This section describes several ways to create them.  
  
## In This Section  
  
|Topic|Description|  
|-----------|-----------------|  
|[Functional Construction (LINQ to XML) (C#)](../../../../csharp/programming-guide/concepts/linq/functional-construction-linq-to-xml.md)|Provides an overview of functional construction in [!INCLUDE[sqltecxlinq](../../../../csharp/programming-guide/concepts/linq/includes/sqltecxlinq_md.md)]. Functional construction enables you to create all or part of your XML tree in a single statement. This topic also shows how to embed queries when constructing an XML tree.|  
|[Creating XML Trees in C# (LINQ to XML)](../../../../csharp/programming-guide/concepts/linq/creating-xml-trees-linq-to-xml-2.md)|Shows how to create trees in C#.|  
|[Cloning vs. Attaching (C#)](../../../../csharp/programming-guide/concepts/linq/cloning-vs-attaching.md)|Demonstrates the difference between adding nodes from an existing XML tree (nodes are cloned and then added) and adding nodes with no parent (they are simply attached).|  
|[Parsing XML (C#)](../../../../csharp/programming-guide/concepts/linq/parsing-xml.md)|Shows how to parse XML from a variety of sources. [!INCLUDE[sqltecxlinq](../../../../csharp/programming-guide/concepts/linq/includes/sqltecxlinq_md.md)] is layered on top of <xref:System.Xml.XmlReader>, which is used to parse the XML.|  
|[How to: Populate an XML Tree with an XmlWriter (LINQ to XML) (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-populate-an-xml-tree-with-an-xmlwriter-linq-to-xml.md)|Shows how to populate an XML tree by using an <xref:System.Xml.XmlWriter>.|  
|[How to: Validate Using XSD (LINQ to XML) (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-validate-using-xsd-linq-to-xml.md)|Shows how to validate an XML tree using XSD.|  
|[Valid Content of XElement and XDocument Objects](../../../../csharp/programming-guide/concepts/linq/valid-content-of-xelement-and-xdocument-objects3.md)|Describes the valid arguments that can be passed to the constructors and methods that are used to add content to elements and documents.|  
  
## See Also  
 [Programming Guide (LINQ to XML) (C#)](../../../../csharp/programming-guide/concepts/linq/programming-guide-linq-to-xml.md)