---
title: "Getting Started with LINQ in C# | Microsoft Docs"
ms.custom: ""
ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "LINQ [C#]"
  - "queries [LINQ in C#]"
  - "LINQ, C#"
  - "queries [LINQ], LINQ in C#"
ms.assetid: b8700c1f-05c9-4380-b6eb-e34c4da38e54
caps.latest.revision: 17
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Getting Started with LINQ in C#
This section contains basic background information that will help you understand the rest of the LINQ documentation and samples.  
  
## In This Section  
 [Introduction to LINQ Queries (C#)](../../../../csharp/programming-guide/concepts/linq/introduction-to-linq-queries.md)  
 Describes the three parts of the basic LINQ query operation that are common across all languages and data sources.  
  
 [LINQ and Generic Types (C#)](../../../../csharp/programming-guide/concepts/linq/linq-and-generic-types.md)  
 Provides a brief introduction to generic types as they are used in LINQ.  
  
 [Basic LINQ Query Operations](../../../../csharp/programming-guide/concepts/linq/basic-linq-query-operations.md)  
 Describes the most common types of query operations and how they are expressed in C#.  
  
 [Data Transformations with LINQ (C#)](../../../../csharp/programming-guide/concepts/linq/data-transformations-with-linq.md)  
 Describes the various ways that you can transform data retrieved in queries.  
  
 [Type Relationships in LINQ Query Operations](../../../../csharp/programming-guide/concepts/linq/type-relationships-in-linq-query-operations.md)  
 Describes how types are preserved and/or transformed in the three parts of a LINQ query operation  
  
 [Query Syntax and Method Syntax in LINQ](../../../../csharp/programming-guide/concepts/linq/query-syntax-and-method-syntax-in-linq.md)  
 Compares method syntax and query syntax as two ways to express a LINQ query.  
  
 [C# Features That Support LINQ](../../../../csharp/programming-guide/concepts/linq/features-that-support-linq.md)  
 Describes the language constructs added in C# 3.0 that support LINQ.  
  
 [Walkthrough: Writing Queries in C#](../../../../csharp/programming-guide/concepts/linq/walkthrough-writing-queries-linq.md)  
 Step-by-step instructions for creating a C# LINQ project, adding a simple data source, and performing some basic query operations.  
  
## Related Sections  
 [Language-Integrated Query (LINQ) (C#)](../../../../csharp/programming-guide/concepts/linq/index.md)  
 Provides links to topics that explain the LINQ technologies.  
  
 [LINQ Query Expressions](../../../../csharp/programming-guide/linq-query-expressions/index.md)  
 Includes an overview of queries in LINQ and provides links to additional resources.  
  
 [Visual Studio IDE and Tools Support for LINQ (C#)](../../../../csharp/programming-guide/concepts/linq/visual-studio-ide-and-tools-support-for-linq.md)  
 Describes tools available in the Visual Studio environment for designing, coding, and debugging LINQ-enabled application.  
  
 [Standard Query Operators Overview (C#)](../../../../csharp/programming-guide/concepts/linq/standard-query-operators-overview.md)  
 Introduces the standard methods used in LINQ.  
  
 [Getting Started with LINQ in Visual Basic](../../../../visual-basic/programming-guide/concepts/linq/getting-started-with-linq.md)  
 Provides links to topics about using LINQ with Visual Basic.