---
title: F# Guide
description: F# Guide 
keywords: .NET, .NET Core
author: jackfoxy
ms.author: phcart
ms.date: 06/20/2016
ms.topic: article
ms.prod: .net
ms.technology: devlang-fsharp
ms.devlang: fsharp
ms.assetid: ea27fb37-dad1-4bd4-a3cc-4f5c70767ae9
---

# F# Guide

F# is a cross-platform, open source programming language for .NET which provides first-class support for functional programming, along with support of object-oriented and imperative programming.  The Visual F# compiler and tooling are Microsoft's implementation and tooling for the F# programming language, making F# a first-class member of .NET.

## If You're New to Programming

If you're new to programming, start with the [Tutorials](tutorials/index.md) section.  The tutorials have a beginner's section which show you how to write and run your own F# programs.

Alternatively, if you prefer to get a thematic overview of F# and some of its distinguishing features, check out the [Tour of F#](tour.md).

## If You're New to F# #

If you know how to program, but you're new to F#, begin with the [Tour of F#](tour.md) to get an overview of the language.

It's also recommended that you go through the [Introduction to Functional Progamming](introduction-to-functional-programming/index.md) to learn Functional Programming concepts which are essential to working with F#.

The [Tutorials](tutorials/index.md) also have step-by-step guides for various skill levels and features of the language.

## If You're Experienced with F# #

If you know your way around F#, you'll find a lot of use in the [Language Reference](language-reference/index.md), which documents each aspect of the language thoroughly, supplemented by numerous code samples.  You'll also find a lot of use in the [F# Core Library Reference](https://msdn.microsoft.com/visualfsharpdocs/conceptual/fsharp-core-library-reference).

## The F# Software Foundation

Although Microsoft is the primary developer of the F# language and Visual F# Tooling, F# is also backed by an independent foundation, the F# Software Foundation (FSSF).

The mission of the F# Software Foundation is to promote, protect, and advance the F# programming language, and to support and facilitate the growth of a diverse and international community of F# programmers.

To learn more and get involved, check out [fsharp.org](http://fsharp.org).

## Documentation

* [Tutorials](tutorials/index.md)
* [Introduction to Functional Programming](introduction-to-functional-programming/index.md)
* [Language Reference](language-reference/index.md)
* [F# Core Library Reference](https://msdn.microsoft.com/visualfsharpdocs/conceptual/fsharp-core-library-reference)

## Online Reading Resources

* [F# for Fun and Profit Gitbook](https://swlaschin.gitbooks.io/fsharpforfunandprofit/content/) 
* [F# Programming Wikibook](https://en.wikibooks.org/wiki/F_Sharp_Programming)

## Video Learning Resources

* [Introduction to Programming with F# series on YouTube](https://www.youtube.com/watch?v=Teak30_pXHk&list=PLEoMzSkcN8oNiJ67Hd7oRGgD1d4YBxYGC)
* [Introduction to F# series on FSharpTV](https://fsharp.tv/courses/fsharp-programming-intro/)

## Further Resources

* [F# Learning Resources on fsharp.org](http://fsharp.org/learn.html)
* [F# Snippets Website](http://www.fssnip.net)
* [F# Software Foundation](http://fsharp.org)
