---
title: "Creating, Deleting, and Moving Files and Directories in Visual Basic | Microsoft Docs"
ms.custom: ""
ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "examples [Visual Basic], moving files and directories"
  - "I/O [Visual Basic], deleting folders"
  - "I/O [Visual Basic], moving directories"
  - "I/O [Visual Basic], copying directories"
  - "examples [Visual Basic], creating files and directories"
  - "I/O [Visual Basic], copying folders"
  - "I/O [Visual Basic], moving folders"
  - "examples [Visual Basic], copying files and directories"
  - "I/O [Visual Basic], deleting directories"
  - "I/O [Visual Basic], copying files"
  - "examples [Visual Basic], renaming files and directories"
  - "I/O [Visual Basic], creating folders"
  - "I/O [Visual Basic], renaming files"
  - "I/O [Visual Basic], deleting files"
  - "I/O [Visual Basic], creating directories"
  - "I/O [Visual Basic], creating files"
  - "I/O [Visual Basic], renaming directories"
  - "I/O [Visual Basic], renaming folders"
  - "I/O [Visual Basic], moving files"
ms.assetid: 8f814fcc-4c42-4dbb-a131-005ec445ac9e
caps.latest.revision: 14
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Creating, Deleting, and Moving Files and Directories in Visual Basic
This section lists tasks associated with creating, deleting, moving, and renaming files and directories in Visual Basic.  
  
## In This Section  
 [How to: Copy Files with a Specific Pattern to a Directory](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-copy-files-with-a-specific-pattern-to-a-directory.md)  
 Demonstrates how to copy files with a specific file name pattern, such as only .txt files, to a directory.  
  
 [How to: Create a Copy of a File in the Same Directory](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-create-a-copy-of-a-file-in-the-same-directory.md)  
 Demonstrates how to create a copy of a file in the same directory.  
  
 [How to: Create a Copy of a File in a Different Directory](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-create-a-copy-of-a-file-in-a-different-directory.md)  
 Demonstrates how to copy a file to another directory.  
  
 [How to: Create a File](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-create-a-file.md)  
 Demonstrates how to create a file.  
  
 [How to: Delete a File](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-delete-a-file.md)  
 Demonstrates how to delete a file.  
  
 [How to: Find Files with a Specific Pattern](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-find-files-with-a-specific-pattern.md)  
 Demonstrates how to list only files with a specific file name pattern in a directory.  
  
 [How to: Move a File](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-move-a-file.md)  
 Demonstrates how to move a file to a different directory.  
  
 [How to: Rename a File](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-rename-a-file.md)  
 Demonstrates how to rename a file.  
  
 [How to: Copy a Directory to Another Directory](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-copy-a-directory-to-another-directory.md)  
 Demonstrates how to copy a directory to another location.  
  
 [How to: Create a Directory](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-create-a-directory.md)  
 Demonstrates how to create a directory.  
  
 [How to: Find Subdirectories with a Specific Pattern](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-find-subdirectories-with-a-specific-pattern.md)  
 Demonstrates how to list directories with a specific pattern in their name.  
  
 [How to: Get the Collection of Files in a Directory](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-get-the-collection-of-files-in-a-directory.md)  
 Demonstrates how to list the files in a directory.  
  
 [How to: Retrieve the Contents of the My Documents Directory](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-retrieve-the-contents-of-the-my-documents-directory.md)  
 Demonstrates how to read from special directories.  
  
 [How to: Parse File Paths](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-parse-file-paths.md)  
 Demonstrates how to use `My` methods to combine file paths.  
  
## Reference  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem>  
 Describes the `My.Computer.FileSystem` object and its members.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.CombinePath%2A>  
 Describes the `CombinePath` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.CopyDirectory%2A>  
 Describes the `CopyDirectory` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.CopyFile%2A>  
 Describes the `CopyFile` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.CreateDirectory%2A>  
 Describes the `CreateDirectory` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.DeleteDirectory%2A>  
 Describes the `DeleteDirectory` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.DeleteFile%2A>  
 Describes the `DeleteFile` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.GetParentPath%2A>  
 Describes the `GetParentPath` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.MoveDirectory%2A>  
 Describes the `MoveDirectory` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.MoveFile%2A>  
 Describes the `MoveFile` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.RenameDirectory%2A>  
 Describes the `RenameDirectory` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.RenameFile%2A>  
 Describes the `RenameFile` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.SpecialDirectories>  
 Describes the `SpecialDirectories` object.  
  
## Related Sections  
 [Reading from Files](../../../../visual-basic/developing-apps/programming/drives-directories-files/reading-from-files.md)  
 Lists tasks associated with reading from files.  
  
 [Writing to Files](../../../../visual-basic/developing-apps/programming/drives-directories-files/writing-to-files.md)  
 Lists tasks involving writing to files.