---
title: "Reading from Files in Visual Basic | Microsoft Docs"
ms.custom: ""
ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "data [Visual Basic], reading from files"
  - "I/O [Visual Basic], reading from files"
  - "examples [Visual Basic], reading from files"
  - "files, reading"
  - "reading files"
ms.assetid: ad831a1b-7d01-4f07-a47b-799f3037df19
caps.latest.revision: 16
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Reading from Files in Visual Basic
This section explains how to perform tasks that are associated with reading from files.  
  
## In This Section  
 [How to: Read from Text Files](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-read-from-text-files.md)  
 Demonstrates how to read from a text file.  
  
 [How to: Read From Comma-Delimited Text Files](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-read-from-comma-delimited-text-files.md)  
 Demonstrates how to read from a delimited text file.  
  
 [How to: Read From Fixed-width Text Files](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-read-from-fixed-width-text-files.md)  
 Demonstrates how to read from a fixed-width text file.  
  
 [How to: Read From Text Files with Multiple Formats](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-read-from-text-files-with-multiple-formats.md)  
 Demonstrates how to read from a text file with multiple formats.  
  
 [How to: Read From Binary Files](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-read-from-binary-files.md)  
 Demonstrates how to read from a binary file.  
  
 [How to: Read Text from Files with a StreamReader](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-read-text-from-files-with-a-streamreader.md)  
 Demonstrates how to use a <xref:System.IO.StreamReader> to read from a file.  
  
## Reference  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem>  
 Describes the `My.Computer.FileSystem` object and its members.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.ReadAllText%2A>  
 Describes the `ReadAllText` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.ReadAllBytes%2A>  
 Describes the `ReadAllBytes` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.OpenTextFieldParser%2A>  
 Describes the `OpenTextFieldParser` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.OpenTextFileReader%2A>  
 Describes the `OpenTextFileReader` method.  
  
## Related Sections  
 [Storing Data to and Reading from the Clipboard](../../../../visual-basic/developing-apps/programming/computer-resources/storing-data-to-and-reading-from-the-clipboard.md)  
 Explains how to perform tasks that are associated with `My.Computer.Clipboard`, such as reading data from or writing data to the Clipboard.  
  
 [Parsing Text Files with the TextFieldParser Object](../../../../visual-basic/developing-apps/programming/drives-directories-files/parsing-text-files-with-the-textfieldparser-object.md)  
 Provides an overview of reading text files with the `TextFieldParser` object.  
  
 [Walkthrough: Manipulating Files and Directories in Visual Basic](../../../../visual-basic/developing-apps/programming/drives-directories-files/walkthrough-manipulating-files-and-directories.md)  
 Demonstrates how to use the `My` feature with files and directories.  
  
 [Walkthrough: Manipulating Files by Using .NET Framework Methods](../../../../visual-basic/developing-apps/programming/drives-directories-files/walkthrough-manipulating-files-by-using-net-framework-methods.md)  
 Demonstrates how to use [!INCLUDE[dnprdnshort](../../../../csharp/getting-started/includes/dnprdnshort_md.md)] methods with files and directories.