---
title: "Visual Basic IntelliSense Code Snippets | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net

ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "code library, about code library"
  - "IntelliSense Code Snippets, about IntelliSense Code Snippets"
  - "snippets"
ms.assetid: ffdde4c9-8141-4906-b09b-15181357a643
caps.latest.revision: 21
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Visual Basic IntelliSense Code Snippets
[!INCLUDE[vbprvb](../../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] includes a code library consisting of several hundred pieces of code, called IntelliSense code snippets, that are ready to be inserted in your application. Each snippet performs a complete programming task such as creating a custom exception, sending an e-mail message, or drawing a circle. You can insert a snippet into your source code with a few mouse clicks. You can also create your own snippets that suit your business needs, add them to the library, and then use them when needed. For more information, see [Code Snippets](https://docs.microsoft.com/visualstudio/ide/code-snippets).  
  
## A Productivity Tool for Visual Basic Users  
 These snippets increase your productivity by reducing the amount of time you spend looking for code samples, by reducing the time required to learn to use an unfamiliar feature, and by supporting the reuse of code.  
  
 The code library supports the following features:  
  
-   Insert one of the snippets into the **Code Editor**.  
  
-   Create new tasks that you can reuse in your projects.  
  
-   Create new tasks to share with your workgroup and colleagues.  
  
-   Edit the tasks.  
  
-   Download more tasks from third parties.  
  
 These code blocks are available throughout [!INCLUDE[vsprvs](../../../csharp/includes/vsprvs_md.md)]:  
  
-   You can add them through the shortcut menu of the **Code Editor**.  
  
-   You can drag the XML code files from **File Explorer** onto your source-code file.  
  
## See Also  
 [Code Snippets](https://docs.microsoft.com/visualstudio/ide/code-snippets)