---
title: "Keywords (Visual Basic) | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net

ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "reserved keywords, Visual Basic"
  - "keywords [Visual Basic]"
  - "Members, Visual Basic run-time"
  - "Visual Basic code, keywords"
  - "Visual Basic, language reference"
  - "reserved words, Visual Basic keywords"
  - "Visual Basic, keywords"
ms.assetid: b5a65ef0-c408-4836-afb6-e6828c0771ca
caps.latest.revision: 43
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Keywords (Visual Basic)
The following tables list all [!INCLUDE[vbprvb](../../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] language keywords.  
  
## Reserved Keywords  
 The following keywords are *reserved*, which means that you cannot use them as names for programming elements such as variables or procedures. You can bypass this restriction by enclosing the name in brackets (`[``]`). For more information, see "Escaped Names" in [Declared Element Names](../../../visual-basic/programming-guide/language-features/declared-elements/declared-element-names.md).  
  
> [!NOTE]
>  We do not recommend that you use escaped names, because it can make your code hard to read, and it can lead to subtle errors that can be difficult to find.  
  
|||||  
|---|---|---|---|  
|[AddHandler](../../../visual-basic/language-reference/statements/addhandler-statement.md)|[AddressOf](../../../visual-basic/language-reference/operators/addressof-operator.md)|[Alias](../../../visual-basic/language-reference/statements/alias-clause.md)|[And](../../../visual-basic/language-reference/operators/and-operator.md)|  
|[AndAlso](../../../visual-basic/language-reference/operators/andalso-operator.md)|[As](../../../visual-basic/language-reference/statements/as-clause.md)|[Boolean](../../../visual-basic/language-reference/data-types/boolean-data-type.md)|[ByRef](../../../visual-basic/language-reference/modifiers/byref.md)|  
|[Byte](../../../visual-basic/language-reference/data-types/byte-data-type.md)|[ByVal](../../../visual-basic/language-reference/modifiers/byval.md)|[Call](../../../visual-basic/language-reference/statements/call-statement.md)|[Case](../../../visual-basic/language-reference/statements/select-case-statement.md)|  
|[Catch](../../../visual-basic/language-reference/statements/try-catch-finally-statement.md)|[CBool](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|[CByte](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|[CChar](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|  
|[CDate](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|[CDbl](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|[CDec](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|[Char](../../../visual-basic/language-reference/data-types/char-data-type.md)|  
|[CInt](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|[Class Constraint](../../../visual-basic/language-reference/statements/type-list.md)|[Class Statement](../../../visual-basic/language-reference/statements/class-statement.md)|[CLng](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|  
|[CObj](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|[Const](../../../visual-basic/language-reference/statements/const-statement.md)|[Continue](../../../visual-basic/language-reference/statements/continue-statement.md)|[CSByte](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|  
|[CShort](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|[CSng](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|[CStr](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|[CType](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|  
|[CUInt](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|[CULng](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|[CUShort](../../../visual-basic/language-reference/functions/type-conversion-functions.md)|[Date](../../../visual-basic/language-reference/data-types/date-data-type.md)|  
|[Decimal](../../../visual-basic/language-reference/data-types/decimal-data-type.md)|[Declare](../../../visual-basic/language-reference/statements/declare-statement.md)|[Default](../../../visual-basic/language-reference/modifiers/default.md)|[Delegate](../../../visual-basic/language-reference/statements/delegate-statement.md)|  
|[Dim](../../../visual-basic/language-reference/statements/dim-statement.md)|[DirectCast](../../../visual-basic/language-reference/operators/directcast-operator.md)|[Do](../../../visual-basic/language-reference/statements/do-loop-statement.md)|[Double](../../../visual-basic/language-reference/data-types/double-data-type.md)|  
|[Each](../../../visual-basic/language-reference/statements/for-each-next-statement.md)|[Else](../../../visual-basic/language-reference/statements/else-statement.md)|[ElseIf](../../../visual-basic/language-reference/statements/if-then-else-statement.md)|[End Statement](../../../visual-basic/language-reference/statements/end-statement.md)|  
|[End \<keyword>](../../../visual-basic/language-reference/statements/end-keyword-statement.md)|`EndIf`|[Enum](../../../visual-basic/language-reference/statements/enum-statement.md)|[Erase](../../../visual-basic/language-reference/statements/erase-statement.md)|  
|[Error](../../../visual-basic/language-reference/statements/on-error-statement.md)|[Event](../../../visual-basic/language-reference/statements/event-statement.md)|[Exit](../../../visual-basic/language-reference/statements/exit-statement.md)|[False](../../../visual-basic/language-reference/data-types/boolean-data-type.md)|  
|[Finally](../../../visual-basic/language-reference/statements/try-catch-finally-statement.md)|[For (in For…Next)](../../../visual-basic/language-reference/statements/for-next-statement.md)|[For Each…Next](../../../visual-basic/language-reference/statements/for-each-next-statement.md)|[Friend](../../../visual-basic/language-reference/modifiers/friend.md)|  
|[Function](../../../visual-basic/language-reference/statements/function-statement.md)|[Get](../../../visual-basic/language-reference/statements/get-statement.md)|[GetType](../../../visual-basic/language-reference/operators/gettype-operator.md)|[GetXMLNamespace](../../../visual-basic/language-reference/operators/getxmlnamespace-operator.md)|  
|[Global](../../../visual-basic/programming-guide/program-structure/namespaces.md)|`GoSub`|[GoTo](../../../visual-basic/language-reference/statements/goto-statement.md)|[Handles](../../../visual-basic/language-reference/statements/handles-clause.md)|  
|[If](../../../visual-basic/language-reference/statements/if-then-else-statement.md)|[If()](../../../visual-basic/language-reference/operators/if-operator.md)|[Implements](../../../visual-basic/language-reference/statements/implements-clause.md)|[Implements Statement](../../../visual-basic/language-reference/statements/implements-statement.md)|  
|[Imports (.NET Namespace and Type)](../../../visual-basic/language-reference/statements/imports-statement-net-namespace-and-type.md)|[Imports (XML Namespace)](../../../visual-basic/language-reference/statements/imports-statement-xml-namespace.md)|[In](../../../visual-basic/language-reference/statements/in-clause.md)|[In (Generic Modifier)](../../../visual-basic/language-reference/modifiers/in-generic-modifier.md)|  
|[Inherits](../../../visual-basic/language-reference/statements/inherits-statement.md)|[Integer](../../../visual-basic/language-reference/data-types/integer-data-type.md)|[Interface](../../../visual-basic/language-reference/statements/interface-statement.md)|[Is](../../../visual-basic/language-reference/operators/is-operator.md)|  
|[IsNot](../../../visual-basic/language-reference/operators/isnot-operator.md)|[Let](../../../visual-basic/language-reference/queries/let-clause.md)|[Lib](../../../visual-basic/language-reference/statements/declare-statement.md)|[Like](../../../visual-basic/language-reference/operators/like-operator.md)|  
|[Long](../../../visual-basic/language-reference/data-types/long-data-type.md)|[Loop](../../../visual-basic/language-reference/statements/do-loop-statement.md)|[Me](../../../visual-basic/programming-guide/program-structure/me-my-mybase-and-myclass.md)|[Mod](../../../visual-basic/language-reference/operators/mod-operator.md)|  
|[Module](../../../visual-basic/language-reference/modifiers/module-keyword.md)|[Module Statement](../../../visual-basic/language-reference/statements/module-statement.md)|[MustInherit](../../../visual-basic/language-reference/modifiers/mustinherit.md)|[MustOverride](../../../visual-basic/language-reference/modifiers/mustoverride.md)|  
|[MyBase](../../../visual-basic/programming-guide/language-features/objects-and-classes/inheritance-basics.md)|[MyClass](../../../visual-basic/programming-guide/language-features/objects-and-classes/inheritance-basics.md)|[Namespace](../../../visual-basic/language-reference/statements/namespace-statement.md)|[Narrowing](../../../visual-basic/language-reference/modifiers/narrowing.md)|  
|[New Constraint](../../../visual-basic/language-reference/statements/type-list.md)|[New Operator](../../../visual-basic/language-reference/operators/new-operator.md)|[Next](../../../visual-basic/language-reference/statements/for-next-statement.md)|[Next (in Resume)](../../../visual-basic/language-reference/statements/resume-statement.md)|  
|[Not](../../../visual-basic/language-reference/operators/not-operator.md)|[Nothing](../../../visual-basic/language-reference/nothing.md)|[NotInheritable](../../../visual-basic/language-reference/modifiers/notinheritable.md)|[NotOverridable](../../../visual-basic/language-reference/modifiers/notoverridable.md)|  
|[Object](../../../visual-basic/language-reference/data-types/object-data-type.md)|[Of](../../../visual-basic/language-reference/statements/of-clause.md)|[On](../../../visual-basic/misc/on.md)|[Operator](../../../visual-basic/language-reference/statements/operator-statement.md)|  
|[Option](../../../visual-basic/language-reference/statements/option-keyword-statement.md)|[Optional](../../../visual-basic/language-reference/modifiers/optional.md)|[Or](../../../visual-basic/language-reference/operators/or-operator.md)|[OrElse](../../../visual-basic/language-reference/operators/orelse-operator.md)|  
|[Out (Generic Modifier)](../../../visual-basic/language-reference/modifiers/out-generic-modifier.md)|[Overloads](../../../visual-basic/language-reference/modifiers/overloads.md)|[Overridable](../../../visual-basic/language-reference/modifiers/overridable.md)|[Overrides](../../../visual-basic/language-reference/modifiers/overrides.md)|  
|[ParamArray](../../../visual-basic/language-reference/modifiers/paramarray.md)|[Partial](../../../visual-basic/language-reference/modifiers/partial.md)|[Private](../../../visual-basic/language-reference/modifiers/private.md)|[Property](../../../visual-basic/language-reference/statements/property-statement.md)|  
|[Protected](../../../visual-basic/language-reference/modifiers/protected.md)|[Public](../../../visual-basic/language-reference/modifiers/public.md)|[RaiseEvent](../../../visual-basic/language-reference/statements/raiseevent-statement.md)|[ReadOnly](../../../visual-basic/language-reference/modifiers/readonly.md)|  
|[ReDim](../../../visual-basic/language-reference/statements/redim-statement.md)|[REM](../../../visual-basic/language-reference/statements/rem-statement.md)|[RemoveHandler](../../../visual-basic/language-reference/statements/removehandler-statement.md)|[Resume](../../../visual-basic/language-reference/statements/resume-statement.md)|  
|[Return](../../../visual-basic/language-reference/statements/return-statement.md)|[SByte](../../../visual-basic/language-reference/data-types/sbyte-data-type.md)|[Select](../../../visual-basic/language-reference/statements/select-case-statement.md)|[Set](../../../visual-basic/language-reference/statements/set-statement.md)|  
|[Shadows](../../../visual-basic/language-reference/modifiers/shadows.md)|[Shared](../../../visual-basic/language-reference/modifiers/shared.md)|[Short](../../../visual-basic/language-reference/data-types/short-data-type.md)|[Single](../../../visual-basic/language-reference/data-types/single-data-type.md)|  
|[Static](../../../visual-basic/language-reference/modifiers/static.md)|[Step](../../../visual-basic/language-reference/statements/for-next-statement.md)|[Stop](../../../visual-basic/language-reference/statements/stop-statement.md)|[String](../../../visual-basic/language-reference/data-types/string-data-type.md)|  
|[Structure Constraint](../../../visual-basic/language-reference/statements/type-list.md)|[Structure Statement](../../../visual-basic/language-reference/statements/structure-statement.md)|[Sub](../../../visual-basic/language-reference/statements/sub-statement.md)|[SyncLock](../../../visual-basic/language-reference/statements/synclock-statement.md)|  
|[Then](../../../visual-basic/language-reference/statements/then-statement.md)|[Throw](../../../visual-basic/language-reference/statements/throw-statement.md)|[To](../../../visual-basic/language-reference/statements/for-next-statement.md)|[True](../../../visual-basic/language-reference/data-types/boolean-data-type.md)|  
|[Try](../../../visual-basic/language-reference/statements/try-catch-finally-statement.md)|[TryCast](../../../visual-basic/language-reference/operators/trycast-operator.md)|[TypeOf…Is](../../../visual-basic/language-reference/operators/typeof-operator.md)|[UInteger](../../../visual-basic/language-reference/data-types/uinteger-data-type.md)|  
|[ULong](../../../visual-basic/language-reference/data-types/ulong-data-type.md)|[UShort](../../../visual-basic/language-reference/data-types/ushort-data-type.md)|[Using](../../../visual-basic/language-reference/statements/using-statement.md)|`Variant`|  
|`Wend`|[When](../../../visual-basic/language-reference/statements/try-catch-finally-statement.md)|[While](../../../visual-basic/language-reference/statements/while-end-while-statement.md)|[Widening](../../../visual-basic/language-reference/modifiers/widening.md)|  
|[With](../../../visual-basic/language-reference/statements/with-end-with-statement.md)|[WithEvents](../../../visual-basic/language-reference/modifiers/withevents.md)|[WriteOnly](../../../visual-basic/language-reference/modifiers/writeonly.md)|[Xor](../../../visual-basic/language-reference/operators/xor-operator.md)|  
|[#Const](../../../visual-basic/language-reference/directives/const-directive.md)|[#Else](../../../visual-basic/language-reference/directives/if-then-else-directives.md)|[#ElseIf](../../../visual-basic/language-reference/directives/if-then-else-directives.md)|[#End](../../../visual-basic/language-reference/directives/if-then-else-directives.md)|  
|[#If](../../../visual-basic/language-reference/directives/if-then-else-directives.md)|[=](../../../visual-basic/language-reference/operators/assignment-operator.md)|[&](../../../visual-basic/language-reference/operators/concatenation-operator.md)|[&=](../../../visual-basic/language-reference/operators/and-assignment-operator.md)|  
|[*](../../../visual-basic/language-reference/operators/multiplication-operator.md)|[*=](../../../visual-basic/language-reference/operators/multiplication-assignment-operator.md)|[/](../../../visual-basic/language-reference/operators/floating-point-division-operator.md)|[/=](../../../visual-basic/language-reference/operators/floating-point-division-assignment-operator.md)|  
|[\\](../../../visual-basic/language-reference/operators/integer-division-operator.md)|[\\=](../../../visual-basic/language-reference/operators/integer-division-assignment-operator.md)|[^](../../../visual-basic/language-reference/operators/exponentiation-operator.md)|[^=](../../../visual-basic/language-reference/operators/exponentiation-assignment-operator.md)|  
|[+](../../../visual-basic/language-reference/operators/addition-operator.md)|[+=](../../../visual-basic/language-reference/operators/addition-assignment-operator.md)|[-](../../../visual-basic/language-reference/operators/subtraction-operator.md)|[-=](../../../visual-basic/language-reference/operators/subtraction-assignment-operator.md)|  
|[>> Operator](../../../visual-basic/language-reference/operators/right-shift-operator.md)|[>>= Operator](../../../visual-basic/language-reference/operators/right-shift-assignment-operator.md)|[<<](../../../visual-basic/language-reference/operators/left-shift-operator.md)|[<\<=](../../../visual-basic/language-reference/operators/left-shift-assignment-operator.md)|  
  
> [!NOTE]
>  `EndIf`, `GoSub`, `Variant`, and `Wend` are retained as reserved keywords, although they are no longer used in [!INCLUDE[vbprvb](../../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)]. The meaning of the `Let` keyword has changed. `Let` is now used in LINQ queries. For more information, see [Let Clause](../../../visual-basic/language-reference/queries/let-clause.md).  
  
## Unreserved Keywords  
 The following keywords are not reserved, which means you can use them as names for your programming elements. However, doing this is not recommended, because it can make your code hard to read and can lead to subtle errors that can be difficult to find.  
  
|||||  
|---|---|---|---|  
|[Aggregate](../../../visual-basic/language-reference/queries/aggregate-clause.md)|[Ansi](../../../visual-basic/language-reference/modifiers/ansi.md)|[Assembly](../../../visual-basic/language-reference/modifiers/assembly.md)|[Async](../../../visual-basic/language-reference/modifiers/async.md)|  
|[Auto](../../../visual-basic/language-reference/modifiers/auto.md)|[Await](../../../visual-basic/language-reference/operators/await-operator.md)|[Binary](../../../visual-basic/language-reference/statements/option-compare-statement.md)|[Compare](../../../visual-basic/language-reference/statements/option-compare-statement.md)|  
|[Custom](../../../visual-basic/language-reference/statements/event-statement.md)|[Distinct](../../../visual-basic/language-reference/queries/distinct-clause.md)|[Equals](../../../visual-basic/language-reference/queries/equals-clause.md)|[Explicit](../../../visual-basic/language-reference/statements/option-explicit-statement.md)|  
|[From](../../../visual-basic/language-reference/queries/from-clause.md)|[Group By](../../../visual-basic/language-reference/queries/group-by-clause.md)|[Group Join](../../../visual-basic/language-reference/queries/group-join-clause.md)|[Into](../../../visual-basic/language-reference/statements/into-clause.md)|  
|[IsFalse](../../../visual-basic/language-reference/operators/isfalse-operator.md)|[IsTrue](../../../visual-basic/language-reference/operators/istrue-operator.md)|[Iterator](../../../visual-basic/language-reference/modifiers/iterator.md)|[Join](../../../visual-basic/language-reference/queries/join-clause.md)|  
|[Key](../../../visual-basic/language-reference/modifiers/key.md)|[Mid](../../../visual-basic/language-reference/statements/mid-statement.md)|[Off](../../../visual-basic/misc/off.md)|[Order By](../../../visual-basic/language-reference/queries/order-by-clause.md)|  
|[Preserve](../../../visual-basic/language-reference/statements/redim-statement.md)|[Skip](../../../visual-basic/language-reference/queries/skip-clause.md)|[Skip While](../../../visual-basic/language-reference/queries/skip-while-clause.md)|[Strict](../../../visual-basic/language-reference/statements/option-strict-statement.md)|  
|[Take](../../../visual-basic/language-reference/queries/take-clause.md)|[Take While](../../../visual-basic/language-reference/queries/take-while-clause.md)|[Text](../../../visual-basic/language-reference/statements/option-compare-statement.md)|[Unicode](../../../visual-basic/language-reference/modifiers/unicode.md)|  
|[Until](../../../visual-basic/language-reference/statements/do-loop-statement.md)|[Where](../../../visual-basic/language-reference/queries/where-clause.md)|[Yield](../../../visual-basic/language-reference/statements/yield-statement.md)|[#ExternalSource](../../../visual-basic/language-reference/directives/externalsource-directive.md)|  
|[#Region](../../../visual-basic/language-reference/directives/region-directive.md)||||  
  
## Related Topics  
  
|Title|Description|  
|-----------|-----------------|  
|[Arrays Summary](../../../visual-basic/language-reference/keywords/arrays-summary.md)|Lists language elements that are used to create, define, and use arrays.|  
|[Collection Object Summary](../../../visual-basic/language-reference/keywords/collection-object-summary.md)|Lists language elements that are used for collections.|  
|[Compiler Directive Summary (Visual Basic)](http://msdn.microsoft.com/en-us/874dad02-d4a5-4a9d-8a48-0191a0ac794a)|Lists directives that control compiler behavior.|  
|[Control Flow Summary](../../../visual-basic/language-reference/keywords/control-flow-summary.md)|Lists statements that are used for looping and controlling procedure flow.|  
|[Conversion Summary](../../../visual-basic/language-reference/keywords/conversion-summary.md)|Lists functions that are used to convert numbers, dates, times, and strings.|  
|[Data Types Summary](../../../visual-basic/language-reference/keywords/data-types-summary.md)|Lists data types. Also lists functions that are used to convert between data types and verify data types.|  
|[Dates and Times Summary](../../../visual-basic/language-reference/keywords/dates-and-times-summary.md)|Lists language elements that are used for dates and times.|  
|[Declarations and Constants Summary](../../../visual-basic/language-reference/keywords/declarations-and-constants-summary.md)|Lists statements that are used to declare variables, constants, classes, modules, and other programming elements. Also lists language elements that are used to obtain object information, handle events, and implement inheritance.|  
|[Directories and Files Summary](../../../visual-basic/language-reference/keywords/directories-and-files-summary.md)|Lists functions that are used to control the file system and to process files.|  
|[Errors Summary](../../../visual-basic/language-reference/keywords/errors-summary.md)|Lists language elements that are used to catch and return run-time error values.|  
|[Financial Summary](../../../visual-basic/language-reference/keywords/financial-summary.md)|Lists functions that are used to perform financial calculations.|  
|[Input and Output Summary](../../../visual-basic/language-reference/keywords/input-and-output-summary.md)|Lists functions that are used to read from and write to files, manage files, and print output.|  
|[Information and Interaction Summary](../../../visual-basic/language-reference/keywords/information-and-interaction-summary.md)|Lists functions that are used to run other programs, obtain command-line arguments, manipulate COM objects, retrieve color information, and use control dialog boxes.|  
|[Math Summary](../../../visual-basic/language-reference/keywords/math-summary.md)|Lists functions that are used to perform trigonometric and other mathematical calculations.|  
|[My Reference](../../../visual-basic/language-reference/keywords/my-reference.md)|Lists the objects contained in `My`, a feature that provides access to frequently used methods, properties, and events of the computer on which the application is running, the current application, the application's resources, the application's settings, and so on.|  
|[Operators Summary](../../../visual-basic/language-reference/keywords/operators-summary.md)|Lists assignment and comparison expressions and other operators.|  
|[Registry Summary](../../../visual-basic/language-reference/keywords/registry-summary.md)|Lists functions that are used to read, save, and delete program settings.|  
|[String Manipulation Summary](../../../visual-basic/language-reference/keywords/string-manipulation-summary.md)|Lists functions that are used to manipulate strings.|  
  
## See Also  
 [Visual Basic Runtime Library Members](../../../visual-basic/language-reference/runtime-library-members.md)
