---
title: "My Reference (Visual Basic) | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net

ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "My feature"
  - "My reference"
ms.assetid: 6f803bd7-21ff-4569-b1fe-b00a6678b1e3
caps.latest.revision: 15
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# My Reference (Visual Basic)
The `My` feature makes programming faster and easier by giving you intuitive access to commonly used methods, properties, and events. This table lists the objects contained in `My`, and the actions that can be performed with each.  
  
|**Action**|**Object**|  
|----------------|----------------|  
|Accessing application information and services.|The `My.Application` object consists of the following classes:<br /><br /> <xref:Microsoft.VisualBasic.ApplicationServices.ApplicationBase> provides members that are available in all projects.<br /><br /> <xref:Microsoft.VisualBasic.ApplicationServices.WindowsFormsApplicationBase> provides members available in Windows Forms applications.<br /><br /> <xref:Microsoft.VisualBasic.ApplicationServices.ConsoleApplicationBase> provides members available in console applications.|  
|Accessing the host computer and its resources, services, and data.|`My.Computer` (<xref:Microsoft.VisualBasic.Devices.Computer>)|  
|Accessing the forms in the current project.|[My.Forms Object](../../../visual-basic/language-reference/objects/my-forms-object.md)|  
|Accessing the application log.|`My.Application.Log` (<xref:Microsoft.VisualBasic.ApplicationServices.ApplicationBase.Log%2A>)|  
|Accessing the current web request.|[My.Request Object](../../../visual-basic/language-reference/objects/my-request-object.md)|  
|Accessing resource elements.|[My.Resources Object](../../../visual-basic/language-reference/objects/my-resources-object.md)|  
|Accessing the current web response.|[My.Response Object](../../../visual-basic/language-reference/objects/my-response-object.md)|  
|Accessing user and application level settings.|[My.Settings Object](../../../visual-basic/language-reference/objects/my-settings-object.md)|  
|Accessing the current user's security context.|`My.User` (<xref:Microsoft.VisualBasic.ApplicationServices.User>)|  
|Accessing XML Web services referenced by the current project.|[My.WebServices Object](../../../visual-basic/language-reference/objects/my-webservices-object.md)|  
  
## See Also  
 [Overview of the Visual Basic Application Model](../../../visual-basic/developing-apps/development-with-my/overview-of-the-visual-basic-application-model.md)   
 [Development with My](../../../visual-basic/developing-apps/development-with-my/index.md)