---
title: "No accessible &#39;&lt;procedurename&gt;&#39; is most specific: &lt;signaturelist&gt; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc30794"
  - "BC30794"
helpviewer_keywords: 
  - "BC30794"
ms.assetid: 51d54cbb-b530-4661-9952-5ccc17e4220b
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# No accessible &#39;&lt;procedurename&gt;&#39; is most specific: &lt;signaturelist&gt;
An assignment statement assigns the address of an overloaded procedure to a delegate variable, but the compiler cannot resolve among the overloaded versions.  
  
 When code uses the address of a procedure that is defined in several overloaded versions, the compiler must decide which of the overloads to use. It tries to find a single version with a parameter list that matches the delegate parameter list. For more information, see [Overload Resolution](../../visual-basic/programming-guide/language-features/procedures/overload-resolution.md).  
  
 If the compiler finds more than one version of the procedure with a matching signature, it generates this error. This can happen, for example, if one of the overloads is generic and a type argument is passed to it that gives it a signature identical to that of another overload.  
  
 **Error ID:** BC30794  
  
## To correct this error  
  
-   If the conflict is caused by a generic overload having the same signature as another overload, change the type argument passed to that generic overload.  
  
## See Also  
 [AddressOf Operator](../../visual-basic/language-reference/operators/addressof-operator.md)   
 [Delegate Statement](../../visual-basic/language-reference/statements/delegate-statement.md)   
 [NOT IN BUILD: Delegates and the AddressOf Operator](http://msdn.microsoft.com/en-us/7b2ed932-8598-4355-b2f7-5cedb23ee86f)   
 [Overload Resolution](../../visual-basic/programming-guide/language-features/procedures/overload-resolution.md)   
 [Generic Types in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-types.md)