---
title: "This inheritance causes circular dependencies between &lt;type1&gt; &#39;&lt;typename1&gt;&#39; and its nested &lt;type2&gt; &#39;&lt;typename2&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc30907"
  - "bc30907"
helpviewer_keywords: 
  - "BC30907"
ms.assetid: 17d4f938-5895-4d33-943e-8abf0ceacdc9
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# This inheritance causes circular dependencies between &lt;type1&gt; &#39;&lt;typename1&gt;&#39; and its nested &lt;type2&gt; &#39;&lt;typename2&gt;&#39;
An inheritance structure results in circular dependency among nested classes, that is, two classes inheriting from each other.  
  
 The following code can generate this error message.  
  
```  
Public Class c1  
    Inherits c3.c4  
    Public Class c2  
    End Class  
End Class  
Public Class c3  
    Inherits c1.c2  
    Public Class c4  
    End Class  
End Class  
```  
  
 In the preceding code, class `c1` inherits from class `c4`, but `c4` is nested inside `c3`, which inherits from `c2`, nested inside `c1`.  
  
 **Error ID:** BC30907  
  
## To correct this error  
  
-   Change the inheritance structure so that there is no circular dependency.  
  
## See Also  
 [Inheritance Basics](../../visual-basic/programming-guide/language-features/objects-and-classes/inheritance-basics.md)