---
title: "Base class &#39;&lt;baseclassname1&gt;&#39; specified for class &#39;&lt;partialclassname&gt;&#39; cannot be different from the base class &#39;&lt;baseclassname2&gt;&#39; of one of its other partial types | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "BC30928"
  - "vbc30928"
helpviewer_keywords: 
  - "BC30928"
ms.assetid: da464f09-1016-4dec-beb7-3202cacd8e1e
caps.latest.revision: 10
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Base class &#39;&lt;baseclassname1&gt;&#39; specified for class &#39;&lt;partialclassname&gt;&#39; cannot be different from the base class &#39;&lt;baseclassname2&gt;&#39; of one of its other partial types
A class is defined in two or more partial declarations, which contain more than one [Inherits Statement](../../visual-basic/language-reference/statements/inherits-statement.md) specifying more than one base class.  
  
 When you divide the definition of a class among several partial declarations, the compiler treats the class as the union of all its partial declarations. This applies not only to the members but also to the implementation, inheritance, and access level.  
  
 A class can implement more than one interface, but it cannot inherit from more than one base class. Therefore, all `Inherits` statements must specify the same base class.  
  
 **Error ID:** BC30928  
  
## To correct this error  
  
-   Decide which class should be the base class of your partial class, and remove from its partial declarations any `Inherits` statement that specifies a different base class.  
  
## See Also  
 [Partial](../../visual-basic/language-reference/modifiers/partial.md)   
 [Inherits Statement](../../visual-basic/language-reference/statements/inherits-statement.md)   
 [Inheritance Basics](../../visual-basic/programming-guide/language-features/objects-and-classes/inheritance-basics.md)