---
title: "Property &#39;&lt;propertyname&gt;&#39; cannot be initialized in an object initializer expression because it requires arguments | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc30992"
  - "vbc30992"
helpviewer_keywords: 
  - "BC30992"
ms.assetid: a4d050b2-7366-457a-a852-8eb490c97573
caps.latest.revision: 12
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Property &#39;&lt;propertyname&gt;&#39; cannot be initialized in an object initializer expression because it requires arguments
The members initialized in an object initializer list must be fields or properties, and property members cannot have parameters. For example, default properties require arguments, so they cannot be initialized in an object initializer list. For more information, see [NOT IN BUILD: Default Properties](http://msdn.microsoft.com/en-us/a70f2a27-8176-4858-935e-f25afdd43ab5).  
  
 **Error ID:** BC30992  
  
## To correct this error  
  
-   Remove from the initialization list all properties that have arguments.  
  
## Example  
 The following class contains a default property, `defaultProp`, that requires an integer argument.  
  
```  
Public Class SomeStrings  
    Private myStrings() As String  
    Sub New(ByVal size As Integer)  
        ReDim myStrings(size)  
    End Sub  
    Default Property defaultProp(ByVal index As Integer) As String  
        Get  
            Return myStrings(index)  
        End Get  
        Set(ByVal Value As String)  
            myStrings(index) = Value  
        End Set  
    End Property  
End Class  
```  
  
 Because the default property requires an argument, the following declaration causes an error.  
  
```  
' Dim strs As New SomeStrings(2) With { .defaultProp = "One" }  
```  
  
## See Also  
 [NOT IN BUILD: Default Properties](http://msdn.microsoft.com/en-us/a70f2a27-8176-4858-935e-f25afdd43ab5)   
 [NOT IN BUILD: Properties and Property Procedures](http://msdn.microsoft.com/en-us/23e2a1ec-7e9d-4109-8940-c703d981077b)   
 [Object Initializers: Named and Anonymous Types](../../visual-basic/programming-guide/language-features/objects-and-classes/object-initializers-named-and-anonymous-types.md)