---
title: "&#39;RaiseEvent&#39; method must have the same signature as the containing event&#39;s delegate type &#39;&lt;signature&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc31137"
  - "vbc31137"
helpviewer_keywords: 
  - "BC31137"
ms.assetid: 9db77546-9205-4fd2-baf6-6eb1b46b1f1a
caps.latest.revision: 7
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;RaiseEvent&#39; method must have the same signature as the containing event&#39;s delegate type &#39;&lt;signature&gt;&#39;
A `Custom Event` declaration must have `RaiseEvent` declaration that has the same signature as the delegate type specified by the custom event's `As` clause.  
  
 For the signatures to match, the `RaiseEvent` declaration and the delegate must have the number of parameters, and the parameters types must match.  
  
 **Error ID:** BC31137  
  
## To correct this error  
  
-   Change the parameters of the `RaiseEvent` declaration to match the parameters of the delegate type.  
  
## Example  
 This example shows a custom event with the correct parameter types for the `RaiseEvent` declaration.  
  
 [!code-vb[VbVbalrEventError#2](../../visual-basic/language-reference/error-messages/codesnippet/VisualBasic/bc31137_1.vb)]  
  
## See Also  
 [Event Statement](../../visual-basic/language-reference/statements/event-statement.md)   
 [RaiseEvent - delete](http://msdn.microsoft.com/en-us/7f765da0-5491-40b6-9ed5-24c98f9daad9)   
 [Delegate Statement](../../visual-basic/language-reference/statements/delegate-statement.md)   
 [Events](../../visual-basic/programming-guide/language-features/events/index.md)