---
title: "Expression cannot appear inside a quoted attribute value | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc31155"
  - "vbc31155"
helpviewer_keywords: 
  - "BC31155"
ms.assetid: ed3e618e-de94-4e4e-afaf-72b11073fb1d
caps.latest.revision: 6
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Expression cannot appear inside a quoted attribute value
Expression cannot appear inside a quoted attribute value. Try removing quotes.  
  
 An embedded expression in an attribute value for an XML literal is contained within quotation marks.  
  
 **Error ID:** BC31155  
  
## To correct this error  
  
-   Remove the delimiting quotation marks from the attribute value. The following is an example:  
  
```vb  
' Generates an error.  
Dim elem = <outer attr="<%= value %>" />  
  
' Does not generate an error.  
Dim elem = <outer attr=<%= value %> />  
```  
  
## See Also  
 [Embedded Expressions in XML](../../visual-basic/programming-guide/language-features/xml/embedded-expressions-in-xml.md)   
 [XML Literals](../../visual-basic/language-reference/xml-literals/index.md)   
 [XML](../../visual-basic/programming-guide/language-features/xml/index.md)