---
title: "Type argument &#39;&lt;typeargumentname&gt;&#39; does not inherit from or implement the constraint type &#39;&lt;typeparametername&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc32044"
  - "vbc32044"
helpviewer_keywords: 
  - "BC32044"
ms.assetid: be91f648-c07d-4991-8ed1-28b1327619c4
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Type argument &#39;&lt;typeargumentname&gt;&#39; does not inherit from or implement the constraint type &#39;&lt;typeparametername&gt;&#39;
A type argument supplied to a generic type does not satisfy the inheritance or implementation constraint on its corresponding type parameter.  
  
 A constraint list imposes requirements on the type argument passed to the type parameter. The possible requirements include the following:  
  
-   The type argument must implement one or more interfaces  
  
-   The type argument must inherit from at most one class  
  
 You can combine the preceding requirements for a single type parameter. [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] cannot construct the type unless the code supplies type arguments that satisfy every constraint on every type parameter defined on the generic type.  
  
 **Error ID:** BC32044  
  
## To correct this error  
  
-   Select a type argument of a type that implements every interface specified for the type parameter, and that inherits from the specified class if there is one.  
  
## See Also  
 [Generic Types in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-types.md)   
 [How to: Use a Generic Class](../../visual-basic/programming-guide/language-features/data-types/how-to-use-a-generic-class.md)