---
title: "&#39;System.Nullable&#39; does not satisfy the &#39;Structure&#39; constraint for type parameter &#39;&lt;typeparametername&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc32115"
  - "vbc32115"
helpviewer_keywords: 
  - "BC32115"
ms.assetid: 98053645-fa76-4826-a7c1-f1bdf3511863
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;System.Nullable&#39; does not satisfy the &#39;Structure&#39; constraint for type parameter &#39;&lt;typeparametername&gt;&#39;
A generic type is invoked passing a type argument of <xref:System.Nullable%601> to a type parameter with a `Structure` constraint.  
  
 The common language runtime (CLR) specifically disallows the <xref:System.Nullable%601> structure as a type argument to itself. Even though it is a structure and would otherwise satisfy a `Structure` constraint, using it recursively could lead to awkward constructions such as `Nullable(Of Nullable(Of Nullable))`.  
  
 **Error ID:** BC32115  
  
## To correct this error  
  
-   Either remove the `Structure` constraint from the type parameter, or change the type argument to some value type other than <xref:System.Nullable%601>.  
  
## See Also  
 <xref:System.Nullable%601>   
 [Generic Types in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-types.md)   
 [Structure (Visual Basic)](http://msdn.microsoft.com/en-us/263ce115-ac36-4c05-8cb7-0e0eead5c6d0)