---
title: "Constraint &#39;&lt;constraint1&gt;&#39; conflicts with the constraint &#39;&lt;constraint2&gt;&#39; already specified for type parameter &#39;&lt;typeparametername&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc32119"
  - "bc32119"
helpviewer_keywords: 
  - "BC32119"
ms.assetid: 30e6778d-5c2b-4f2d-a136-4e66fa9fbe4d
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Constraint &#39;&lt;constraint1&gt;&#39; conflicts with the constraint &#39;&lt;constraint2&gt;&#39; already specified for type parameter &#39;&lt;typeparametername&gt;&#39;
A generic type is declared with conflicting constraints on a type parameter.  
  
 The following statement can generate this error.  
  
 `Public Class testClass(Of t As {Structure, Class })`  
  
 The constraints `Structure` and `Class` cause a conflict for type parameter `t`, because the `Structure` constraint requires that the corresponding type argument be a value type, while `Class` requires that it be a reference type.  
  
 **Error ID:** BC32119  
  
## To correct this error  
  
-   Change the type parameter constraints to avoid conflicts.  
  
## See Also  
 [Generic Types in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-types.md)   
 [Type List](../../visual-basic/language-reference/statements/type-list.md)   
 [Structure (Visual Basic)](http://msdn.microsoft.com/en-us/263ce115-ac36-4c05-8cb7-0e0eead5c6d0)   
 [Class (Visual Basic)](http://msdn.microsoft.com/en-us/0777c6e6-46bc-451b-ad70-57b49d4ef4f7)   
 [Value Types and Reference Types](../../visual-basic/programming-guide/language-features/data-types/value-types-and-reference-types.md)