---
title: "&#39;Microsoft.VisualBasic.ComClassAttribute&#39; cannot be applied to &#39;&lt;classname&gt;&#39; because it is not declared &#39;Public&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc32509"
  - "vbc32509"
helpviewer_keywords: 
  - "BC32509"
ms.assetid: ac46851f-53ab-4ce6-87b1-4c4d29508527
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;Microsoft.VisualBasic.ComClassAttribute&#39; cannot be applied to &#39;&lt;classname&gt;&#39; because it is not declared &#39;Public&#39;
A class is declared with <xref:Microsoft.VisualBasic.ComClassAttribute>, but its declaration does not specify `Public`.  
  
 To be eligible for COM interop, a .NET Framework class must satisfy the following requirements:  
  
-   It must be `Public`, all its containers must be `Public`, and it must expose at least one `Public` member.  
  
-   It must not be *abstract*, that is, it must not be declared with `MustInherit`.  
  
-   It must not be generic or be declared within a generic container type.  
  
 **Error ID:** BC32509  
  
## To correct this error  
  
-   Add the `Public` keyword to the class declaration.  
  
     -or-  
  
-   If the class or its containing element cannot be `Public`, then remove <xref:Microsoft.VisualBasic.ComClassAttribute> from the class declaration. You cannot expose it to COM.  
  
## See Also  
 <xref:Microsoft.VisualBasic.ComClassAttribute>   
 [COM Interop](../../visual-basic/programming-guide/com-interop/index.md)   
 [Public](../../visual-basic/language-reference/modifiers/public.md)