---
title: "&lt;type&gt; parameters cannot be declared &#39;ParamArray&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc33009"
  - "vbc33009"
helpviewer_keywords: 
  - "BC33009"
ms.assetid: faba9aef-ca4e-4c4d-934c-a3e3d3fa3c3e
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &lt;type&gt; parameters cannot be declared &#39;ParamArray&#39;
A definition of a delegate, event, or operator declares a [ParamArray](../../visual-basic/language-reference/modifiers/paramarray.md) parameter.  
  
 `ParamArray` parameters are allowed only on `Declare`, `Function`, `Property`, and `Sub` parameters.  
  
 **Error ID:** BC33009  
  
## To correct this error  
  
-   Remove the `ParamArray` keyword from the parameter list.  
  
-   If you are defining an operator, you might be able to achieve the `ParamArray` functionality with a series of overloads.  
  
-   If you are defining a delegate or event, you must rework the overall logic of this part of your application. You cannot use [Optional](../../visual-basic/language-reference/modifiers/optional.md) or `ParamArray` parameters, or overloaded versions, on delegate or event parameters.  
  
## See Also  
 [Overloads](../../visual-basic/language-reference/modifiers/overloads.md)   
 [Operator Procedures](../../visual-basic/programming-guide/language-features/procedures/operator-procedures.md)   
 [Operator Statement](../../visual-basic/language-reference/statements/operator-statement.md)