---
title: "&lt;type&gt; parameters cannot be declared &#39;Optional&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc33010"
  - "vbc33010"
helpviewer_keywords: 
  - "BC33010"
ms.assetid: ec4023e7-9ba6-4532-a6b9-4ae6b4f9063a
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &lt;type&gt; parameters cannot be declared &#39;Optional&#39;
A definition of a delegate, event, or operator declares an [Optional](../../visual-basic/language-reference/modifiers/optional.md) parameter.  
  
 `Optional` parameters are allowed only on `Declare`, `Function`, `Property`, and `Sub` parameters.  
  
 **Error ID:** BC33010  
  
## To correct this error  
  
-   Remove the `Optional` keyword from the parameter list.  
  
-   If you are defining an operator, you might be able to achieve the `Optional` functionality with a series of overloads.  
  
-   If you are defining a delegate or event, you must rework the overall logic of this part of your application. You cannot use `Optional` or [ParamArray](../../visual-basic/language-reference/modifiers/paramarray.md) parameters, or overloaded versions, on delegate or event parameters.  
  
## See Also  
 [Overloads](../../visual-basic/language-reference/modifiers/overloads.md)   
 [Operator Procedures](../../visual-basic/programming-guide/language-features/procedures/operator-procedures.md)   
 [Operator Statement](../../visual-basic/language-reference/statements/operator-statement.md)