---
title: "&#39;If&#39; operands cannot be named arguments | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc33105"
  - "vbc33105"
helpviewer_keywords: 
  - "BC33105"
ms.assetid: 596baeb6-a44f-4d92-beb7-06624b60c00d
caps.latest.revision: 6
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;If&#39; operands cannot be named arguments
Using named arguments in the operands of the `If` operator is not valid. The following example causes this error:  
  
```  
Dim i As Integer  
Dim result As String  
' Not valid.  
' result = (If(i > 0, TruePart:="positive", FalsePart:="not positive")  
```  
  
 This differs from the `IIf` function, which does allow named arguments, as shown in the following code:  
  
```  
' Valid.  
IIf(i > 0, TruePart:="positive", FalsePart:="not positive")  
```  
  
 **Error ID:** BC33105  
  
## To correct this error  
  
-   Remove the name assignments from the operands, as shown in the following code.  
  
    ```  
    result = If(i > 0, "positive", "not positive")  
    ```  
  
## See Also  
 [If Operator](../../visual-basic/language-reference/operators/if-operator.md)   
 [Passing Arguments by Position and by Name](../../visual-basic/programming-guide/language-features/procedures/passing-arguments-by-position-and-by-name.md)