---
title: "Cannot infer a common type for the second and third operands of the &#39;If&#39; operator | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc33106"
  - "bc33106"
helpviewer_keywords: 
  - "BC33106"
ms.assetid: 793eed88-a9f9-43e3-b657-c16795ecbbcc
caps.latest.revision: 7
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Cannot infer a common type for the second and third operands of the &#39;If&#39; operator
Cannot infer a common type for the second and third operands of the 'If' operator. One must have a widening conversion to the other.  
  
 When the `If` operator is called with three arguments, there must be a widening conversion between the second and third arguments. For example, because there is not a widening conversion in either direction between `Integer` and `String`, the following code causes this error.  
  
```vb  
Dim divisor = 3  
' Not valid.  
' Console.WriteLine(If(divisor <> 0, number \ divisor, "Division by zero"))  
```  
  
 **Error ID:** BC33106  
  
## To correct this error  
  
-   Provide an explicit conversion for one of the operands, if that is possible in your code.  
  
-   Use a different condition construction, such as an `If...Then...Else` statement.  
  
## See Also  
 [If Operator](../../visual-basic/language-reference/operators/if-operator.md)   
 [If...Then...Else Statement](../../visual-basic/language-reference/statements/if-then-else-statement.md)   
 [Widening and Narrowing Conversions](../../visual-basic/programming-guide/language-features/data-types/widening-and-narrowing-conversions.md)