---
title: "Cannot infer a common type for the first and second operands of the binary &#39;If&#39; operator | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc33110"
  - "bc33110"
helpviewer_keywords: 
  - "BC33110"
ms.assetid: f46873aa-f6cd-4cc9-9e8e-e668bddf0980
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Cannot infer a common type for the first and second operands of the binary &#39;If&#39; operator
Cannot infer a common type for the first and second operands of the binary 'If' operator. One must have a widening conversion to the other.  
  
 The binary `If` operator requires that there be a widening conversion between one of the arguments and the other argument. For example, because there is not a widening conversion in either direction between `Integer` and `String`, the following code causes this error.  
  
```vb  
Dim first? As Integer  
Dim second As String = "First is Nothing"  
'' Not valid.  
' Console.WriteLine(If(first, second))  
```  
  
 **Error ID:** BC33110  
  
## To correct this error  
  
-   Provide an explicit conversion for one of the operands, if that is possible in your code:  
  
    ```  
    Console.WriteLine(If(first, CInt(second)))   
    ```  
  
-   Rewrite the code by using a different conditional construction.  
  
    ```  
    If first IsNot Nothing Then  
        Console.WriteLine(first)  
    Else  
        Console.WriteLine(second)  
    End If  
    ```  
  
## See Also  
 [If Operator](../../visual-basic/language-reference/operators/if-operator.md)   
 [Widening and Narrowing Conversions](../../visual-basic/programming-guide/language-features/data-types/widening-and-narrowing-conversions.md)   
 [If...Then...Else Statement](../../visual-basic/language-reference/statements/if-then-else-statement.md)