---
title: "Extension method &#39;&lt;methodName&gt;&#39; defined in &#39;&lt;typeName&gt;&#39; does not have the same signature as delegate &#39;&lt;delegateName&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc36580"
  - "vbc36580"
helpviewer_keywords: 
  - "BC36580"
ms.assetid: dc6b6a63-02b0-43d8-b6a7-c1cd397c6ee3
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Extension method &#39;&lt;methodName&gt;&#39; defined in &#39;&lt;typeName&gt;&#39; does not have the same signature as delegate &#39;&lt;delegateName&gt;&#39;
There is a mismatch between the signatures of the extension method and the delegate that you are attempting to use. The `Delegate` statement defines the parameter types and return types of a delegate class. Any procedure with matching parameters, types, and return types can be used to create an instance of this delegate type. This error is reported in the following example because the signature of extension method `Example` is not compatible with the signature of delegate `Del`.  
  
```vb  
' Definition of the delegate, with two parameters.  
Delegate Sub Del(ByVal m As Integer, ByVal s As String)  
```  
  
```vb  
' Definition of the extension method, with one parameter.  
<Extension()> _  
Sub Example(ByVal s As String)  
    ' Body of the Sub.  
End Sub  
```  
  
```vb  
'' This assignment causes the error.  
' Dim exampleDel As Del = AddressOf Example  
```  
  
 **Error ID:** BC36580  
  
## To correct this error  
  
-   Verify that the delegate and the extension method have the same number of parameters.  
  
-   Verify that the order of the parameters is the same in the delegate and the extension method.  
  
-   Compare the data type of each delegate parameter to the data type of the corresponding extension method parameter to make sure they are compatible.  
  
## See Also  
 [Extension Methods](../../visual-basic/programming-guide/language-features/procedures/extension-methods.md)   
 [Delegate Statement](../../visual-basic/language-reference/statements/delegate-statement.md)   
 [Relaxed Delegate Conversion](../../visual-basic/programming-guide/language-features/delegates/relaxed-delegate-conversion.md)