---
title: "&#39;By&#39; expected | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc36605"
  - "bc36605"
helpviewer_keywords: 
  - "BC36605"
ms.assetid: d0397b6e-bfc2-400c-92fc-efe82036cfdb
caps.latest.revision: 4
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;By&#39; expected
An `Order By` or `Group By` clause has been specified without the `By` keyword.  
  
 **Error ID:** BC36605  
  
## To correct this error  
  
1.  Add the `By` keyword to the `Order By` or `Group By` clause. The following is an example:  
  
```vb  
Dim customersByCountry = From cust In customers _  
                         Order By cust.Country, cust.City _  
                         Group By CountryName = cust.Country _  
                         Into RegionalCustomers = Group, Count() _  
                         Order By CountryName  
```  
  
## See Also  
 [How to: Sort Query Results](../../visual-basic/programming-guide/language-features/linq/how-to-sort-query-results-by-using-linq.md)   
 [Order By Clause](../../visual-basic/language-reference/queries/order-by-clause.md)   
 [Group By Clause](../../visual-basic/language-reference/queries/group-by-clause.md)   
 [Introduction to LINQ in Visual Basic](../../visual-basic/programming-guide/language-features/linq/introduction-to-linq.md)   
 [LINQ](../../visual-basic/programming-guide/language-features/linq/index.md)