---
title: "&#39;Into&#39; expected | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc36615"
  - "vbc36615"
helpviewer_keywords: 
  - "BC36615"
ms.assetid: 24062dd9-a973-43b6-88d3-c11adc5a3736
caps.latest.revision: 5
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;Into&#39; expected
An `Aggregate`, `Group By`, or `Group Join` clause has been specified without an `Into` operator. You use the `Into` operator to identify aggregate functions to apply to the query result and to identify the member of the query result type to contain the grouped results (by using the `Group` aggregate function).  
  
 **Error ID:** BC36615  
  
## To correct this error  

1.  Add the `Into` operator to the `Aggregate`, `Group By`, or `Group Join` clause. The following is an example:  

```vb  
Dim orders = From order In orderList _  
             Order By order.OrderDate _  
             Group By OrderDate = order.OrderDate _  
             Into OrdersByDate = Group  
```  
  
## See Also  
 [Aggregate Clause](../../visual-basic/language-reference/queries/aggregate-clause.md)   
 [Group By Clause](../../visual-basic/language-reference/queries/group-by-clause.md)   
 [Group Join Clause](../../visual-basic/language-reference/queries/group-join-clause.md)   
 [Introduction to LINQ in Visual Basic](../../visual-basic/programming-guide/language-features/linq/introduction-to-linq.md)   
 [LINQ](../../visual-basic/programming-guide/language-features/linq/index.md)