---
title: "&#39;On&#39; expected | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc36618"
  - "vbc36618"
helpviewer_keywords: 
  - "BC36618"
ms.assetid: 7cb1b205-c4c3-4485-ae3f-8942425692ff
caps.latest.revision: 5
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;On&#39; expected
A `Join` or `Group Join` clause has been specified without an `On` operator. You use the `On` operator to identify the key field of the range variable for each collection. Key fields are used to match items from each collection.  
  
 **Error ID:** BC36618  
  
## To correct this error  
  
1.  Add the `On` operator and key fields to the `Join` or `Group Join` clause. Following is an example:  
  
```vb  
Dim petOwnersJoin = From pers In people _  
                    Join pet In pets _  
                    On pet.Owner Equals pers _  
                    Select pers.FirstName, PetName = pet.Name  
```  
  
## See Also  
 [How to: Combine Data with Joins](../../visual-basic/programming-guide/language-features/linq/how-to-combine-data-with-linq-by-using-joins.md)   
 [Join Clause](../../visual-basic/language-reference/queries/join-clause.md)   
 [Group Join Clause](../../visual-basic/language-reference/queries/group-join-clause.md)   
 [Introduction to LINQ in Visual Basic](../../visual-basic/programming-guide/language-features/linq/introduction-to-linq.md)   
 [LINQ](../../visual-basic/programming-guide/language-features/linq/index.md)