---
title: "Lambda expression cannot be converted to &#39;&lt;typename&gt;&#39; because &#39;&lt;typename&gt;&#39; is not a delegate type | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc36625"
  - "vbc36625"
helpviewer_keywords: 
  - "BC36625"
ms.assetid: c03634d4-d831-4f8c-b6ab-566465968e4d
caps.latest.revision: 6
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Lambda expression cannot be converted to &#39;&lt;typename&gt;&#39; because &#39;&lt;typename&gt;&#39; is not a delegate type
Lambda expressions can be used where delegates are valid. They can be converted to compatible delegate types, but not to any other type. For example, you can define a delegate type and assign a lambda expression to it, or send a lambda expression as the argument to a <xref:System.Func%601> parameter. These examples are shown in the following code.  
  
```vb  
Module Module1  
  
    Delegate Function FunDel(ByVal m As Integer) As Boolean  
  
    Sub Main()  
  
        ' Assign a lambda expression to a function delegate.  
        Dim negative As FunDel = Function(n As Integer) n < 0  
        Console.WriteLine(negative(-3))  
  
        ' Send a lambda as the argument to a delegate parameter.  
        Dim numbers() As Integer = {3, 4, 2, 8, 1, 0, 9, 13, 42}  
        Dim evens = numbers.Where(Function(n) n Mod 2 = 0)  
  
        For Each even In evens  
            Console.WriteLine(even)  
        Next  
  
    End Sub  
  
End Module  
```  
  
 **Error ID:** BC36625  
  
## See Also  
 [Lambda Expressions](../../visual-basic/programming-guide/language-features/procedures/lambda-expressions.md)