---
title: "&#39;Microsoft.VisualBasic.ComClassAttribute&#39; is specified for class &#39;&lt;classname&gt;&#39; but it has no public members that can be exposed to COM; therefore no COM interfaces are generated | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc40011"
  - "vbc40011"
helpviewer_keywords: 
  - "BC40011"
ms.assetid: 39aed273-bf27-4667-8116-022c4dd8f3c5
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;Microsoft.VisualBasic.ComClassAttribute&#39; is specified for class &#39;&lt;classname&gt;&#39; but it has no public members that can be exposed to COM; therefore no COM interfaces are generated
A class using a `COMClassAttribute` attribute block does not define any `Public` properties or methods. If a class is to be exposed as a COM object, its properties and methods must be declared with `Public` access.  
  
 The message is a warning by default. For more information on hiding warnings or treating warnings as errors, see [Configuring Warnings in Visual Basic](https://docs.microsoft.com/visualstudio/ide/configuring-warnings-in-visual-basic).  
  
 **Error ID:** BC40011  
  
## To correct this error  
  
-   Add the `Public` keyword to one or more properties or methods in the class, or remove the `COMClassAttribute` attribute block.  
  
## See Also  
 [NOT IN BUILD: Attributes Used in Visual Basic](http://msdn.microsoft.com/en-us/22231318-8a40-49af-9245-e0aab723563b)   
 [NOT IN BUILD: Application of Attributes](http://msdn.microsoft.com/en-us/2b1703ed-4437-49b3-bc0b-568094324f47)   
 [Public](../../visual-basic/language-reference/modifiers/public.md)   
 [ComClassAttribute Class](http://msdn.microsoft.com/en-us/5c2f0835-9210-47dc-bc59-5c1769953574)