---
title: "Attribute &#39;&lt;attributename&gt;&#39; cannot be specified more than once in this project, even with identical parameter values | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc41000"
  - "vbc41000"
helpviewer_keywords: 
  - "BC41000"
ms.assetid: 7e846177-7b89-44da-8f17-cdc8606ef148
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Attribute &#39;&lt;attributename&gt;&#39; cannot be specified more than once in this project, even with identical parameter values
A custom attribute is specified more than once on the same programming element, but an <xref:System.AttributeUsageAttribute> is applied to the custom attribute, and its <xref:System.AttributeUsageAttribute.AllowMultiple%2A> property is set to `False`. <xref:System.AttributeUsageAttribute.AllowMultiple%2A> controls whether the attribute is multi-use.  
  
 By default, this message is a warning. For information on hiding warnings or treating warnings as errors, see [Configuring Warnings in Visual Basic](https://docs.microsoft.com/visualstudio/ide/configuring-warnings-in-visual-basic).  
  
 **Error ID:** BC41000  
  
## To correct this error  
  
-   Remove the extra specification of the custom attribute, or set <xref:System.AttributeUsageAttribute.AllowMultiple%2A> to `True` in the <xref:System.AttributeUsageAttribute> applied to it.  
  
## See Also  
 <xref:System.AttributeUsageAttribute>   
 <xref:System.AttributeUsageAttribute.AllowMultiple%2A>   
 [NOT IN BUILD: Application of Attributes](http://msdn.microsoft.com/en-us/2b1703ed-4437-49b3-bc0b-568094324f47)