# [Language-Integrated Query (LINQ)](index.md)
## [Introduction to LINQ](introduction-to-linq.md)
## [Getting Started with LINQ](getting-started-with-linq.md)
### [Writing Your First LINQ Query](writing-your-first-linq-query.md)
### [Basic Query Operations](basic-query-operations.md)
### [Visual Basic Features That Support LINQ](features-that-support-linq.md)
### [Type Relationships in Query Operations](type-relationships-in-query-operations.md)
### [Walkthrough: Writing Queries](walkthrough-writing-queries.md)
### [How to: Create a List of Items](how-to-create-a-list-of-items.md)
## [Standard Query Operators Overview](standard-query-operators-overview.md)
### [Query Expression Syntax for Standard Query Operators](query-expression-syntax-for-standard-query-operators.md)
### [Classification of Standard Query Operators by Manner of Execution](classification-of-standard-query-operators-by-manner-of-execution.md)
### [Sorting Data](sorting-data.md)
### [Set Operations](set-operations.md)
### [Filtering Data](filtering-data.md)
### [Quantifier Operations](quantifier-operations.md)
### [Projection Operations](projection-operations.md)
### [Partitioning Data](partitioning-data.md)
### [Join Operations](join-operations.md)
### [Grouping Data](grouping-data.md)
### [Generation Operations](generation-operations.md)
### [Equality Operations](equality-operations.md)
### [Element Operations](element-operations.md)
### [Converting Data Types](converting-data-types.md)
### [Concatenation Operations](concatenation-operations.md)
### [Aggregation Operations](aggregation-operations.md)

# [LINQ to Objects](linq-to-objects.md)
## [LINQ and Strings](linq-and-strings.md)
### [How to: Count Occurrences of a Word in a String (LINQ)](how-to-count-occurrences-of-a-word-in-a-string-linq.md)
### [How to: Query for Sentences that Contain a Specified Set of Words (LINQ)](how-to-query-for-sentences-that-contain-a-specified-set-of-words.md)
### [How to: Query for Characters in a String (LINQ)](how-to-query-for-characters-in-a-string-linq.md)
### [How to: Combine LINQ Queries with Regular Expressions](how-to-combine-linq-queries-with-regular-expressions.md)
### [How to: Find the Set Difference Between Two Lists (LINQ)](how-to-find-the-set-difference-between-two-lists-linq.md)
### [How to: Sort or Filter Text Data by Any Word or Field (LINQ)](how-to-sort-or-filter-text-data-by-any-word-or-field-linq.md)
### [How to: Reorder the Fields of a Delimited File (LINQ)](how-to-reorder-the-fields-of-a-delimited-file.md)
### [How to: Combine and Compare String Collections (LINQ)](how-to-combine-and-compare-string-collections-linq.md)
### [How to: Populate Object Collections from Multiple Sources (LINQ)](how-to-populate-object-collections-from-multiple-sources-linq.md)
### [How to: Split a File Into Many Files by Using Groups (LINQ)](how-to-split-a-file-into-many-files-by-using-groups-linq.md)
### [How to: Join Content from Dissimilar Files (LINQ)](how-to-join-content-from-dissimilar-files-linq.md)
### [How to: Compute Column Values in a CSV Text File (LINQ)](how-to-compute-column-values-in-a-csv-text-file-linq.md)
## [LINQ and Reflection](linq-and-reflection.md)
### [How to: Query An Assembly's Metadata with Reflection (LINQ)](how-to-query-an-assembly-s-metadata-with-reflection-linq.md)
## [LINQ and File Directories](linq-and-file-directories.md)
### [How to: Query for Files with a Specified Attribute or Name](how-to-query-for-files-with-a-specified-attribute-or-name.md)
### [How to: Group Files by Extension (LINQ)](how-to-group-files-by-extension-linq.md)
### [How to: Query for the Total Number of Bytes in a Set of Folders (LINQ)](how-to-query-for-the-total-number-of-bytes-in-a-set-of-folders.md)
### [How to: Compare the Contents of Two Folders (LINQ)](how-to-compare-the-contents-of-two-folders-linq.md)
### [How to: Query for the Largest File or Files in a Directory Tree (LINQ)](how-to-query-for-the-largest-file-or-files-in-a-directory-tree.md)
### [How to: Query for Duplicate Files in a Directory Tree (LINQ)](how-to-query-for-duplicate-files-in-a-directory-tree-linq.md)
### [How to: Query the Contents of Files in a Folder (LINQ)](how-to-query-the-contents-of-files-in-a-folder-linq.md)
### [How to: Query an ArrayList with LINQ](how-to-query-an-arraylist-with-linq.md)
### [How to: Add Custom Methods for LINQ Queries](how-to-add-custom-methods-for-linq-queries.md)

# [LINQ to XML](linq-to-xml.md)
## [Getting Started (LINQ to XML)](getting-started-linq-to-xml.md)
### [LINQ to XML Overview](linq-to-xml-overview.md)
### [LINQ to XML vs. DOM](linq-to-xml-vs-dom.md)
### [LINQ to XML vs. Other XML Technologies](linq-to-xml-vs-other-xml-technologies.md)

# [Programming Guide (LINQ to XML)](programming-guide-linq-to-xml.md)
## [LINQ to XML Programming Overview](linq-to-xml-programming-overview.md)
## [Functional vs. Procedural Programming (LINQ to XML)](functional-vs-procedural-programming-linq-to-xml.md)
## [LINQ to XML Classes Overview](linq-to-xml-classes-overview.md)
## [XElement Class Overview](xelement-class-overview.md)
## [XAttribute Class Overview](xattribute-class-overview.md)
### [XDocument Class Overview](xdocument-class-overview.md)
### [How to: Build LINQ to XML Examples](how-to-build-linq-to-xml-examples.md)
## [Creating XML Trees](creating-xml-trees.md)
### [Functional Construction (LINQ to XML)](functional-construction-linq-to-xml.md)
### [Introduction to XML Literals](introduction-to-xml-literals.md)
### [Cloning vs. Attaching](cloning-vs-attaching.md)
### [Parsing XML](parsing-xml.md)
#### [How to: Parse a String](how-to-parse-a-string.md)
#### [How to: Load XML from a File](how-to-load-xml-from-a-file.md)
#### [Preserving White Space while Loading or Parsing XML](preserving-white-space-while-loading-or-parsing-xml.md)
#### [How to: Catch Parsing Errors](how-to-catch-parsing-errors.md)
#### [How to: Create a Tree from an XmlReader](how-to-create-a-tree-from-an-xmlreader.md)
#### [How to: Stream XML Fragments from an XmlReader](how-to-stream-xml-fragments-from-an-xmlreader.md)
### [How to: Populate an XML Tree with an XmlWriter (LINQ to XML)](how-to-populate-an-xml-tree-with-an-xmlwriter-linq-to-xml.md)
### [How to: Validate Using XSD (LINQ to XML)](how-to-validate-using-xsd-linq-to-xml.md)
### [Valid Content of XElement and XDocument Objects](valid-content-of-xelement-and-xdocument-objects.md)

# [Working with XML Namespaces](working-with-xml-namespaces.md)
## [Namespaces Overview (LINQ to XML)](namespaces-overview-linq-to-xml.md)
## [How to: Create a Document with Namespaces (LINQ to XML)](how-to-create-a-document-with-namespaces.md)
## [How to: Control Namespace Prefixes (LINQ to XML)](how-to-control-namespace-prefixes-linq-to-xml.md)
## [Scope of Default Namespaces](scope-of-default-namespaces.md)
## [Working with Global Namespaces (LINQ to XML)](working-with-global-namespaces-linq-to-xml.md)
## [Namespaces (LINQ to XML)](namespaces-linq-to-xml.md)
## [How to: Write Queries on XML in Namespaces](how-to-write-queries-on-xml-in-namespaces.md)

# [Serializing XML Trees](serializing-xml-trees.md)
## [Preserving White Space While Serializing](preserving-white-space-while-serializing.md)
## [Serializing with an XML Declaration](serializing-with-an-xml-declaration.md)
## [Serializing to Files, TextWriters, and XmlWriters](serializing-to-files-textwriters-and-xmlwriters.md)
## [Serializing to an XmlReader (Invoking XSLT)](serializing-to-an-xmlreader-invoking-xslt.md)

# [LINQ to XML Axes](linq-to-xml-axes.md)
## [LINQ to XML Axes Overview](linq-to-xml-axes-overview.md)
## [How to: Retrieve a Collection of Elements (LINQ to XML)](how-to-retrieve-a-collection-of-elements-linq-to-xml.md)
## [How to: Retrieve the Value of an Element (LINQ to XML)](how-to-retrieve-the-value-of-an-element-linq-to-xml.md)
## [How to: Filter on Element Names (LINQ to XML)](how-to-filter-on-element-names-linq-to-xml.md)
## [How to: Chain Axis Method Calls (LINQ to XML)](how-to-chain-axis-method-calls-linq-to-xml.md)
## [How to: Retrieve a Single Child Element (LINQ to XML)](how-to-retrieve-a-single-child-element-linq-to-xml.md)
## [How to: Retrieve a Collection of Attributes (LINQ to XML)](how-to-retrieve-a-collection-of-attributes-linq-to-xml.md)
## [How to: Retrieve a Single Attribute (LINQ to XML)](how-to-retrieve-a-single-attribute-linq-to-xml.md)
## [How to: Retrieve the Value of an Attribute (LINQ to XML)](how-to-retrieve-the-value-of-an-attribute-linq-to-xml.md)
## [How to: Retrieve the Shallow Value of an Element](how-to-retrieve-the-shallow-value-of-an-element.md)
## [Language-Integrated Axes (LINQ to XML)](language-integrated-axes.md)

# [Querying XML Trees](querying-xml-trees.md)
## [Basic Queries (LINQ to XML)](basic-queries-linq-to-xml.md)
### [How to: Find an Element with a Specific Attribute](how-to-find-an-element-with-a-specific-attribute.md)
### [How to: Find an Element with a Specific Child Element](how-to-find-an-element-with-a-specific-child-element.md)
### [Querying an XDocument vs. Querying an XElement](querying-an-xdocument-vs-querying-an-xelement.md)
### [How to: Find Descendants with a Specific Element Name](how-to-find-descendants-with-a-specific-element-name.md)
### [How to: Find a Single Descendant Using the Descendants Method](how-to-find-a-single-descendant-using-the-descendants-method.md)
### [How to: Write Queries with Complex Filtering](how-to-write-queries-with-complex-filtering.md)
### [How to: Filter on an Optional Element](how-to-filter-on-an-optional-element.md)
### [How to: Find All Nodes in a Namespace](how-to-find-all-nodes-in-a-namespace.md)
### [How to: Sort Elements](how-to-sort-elements.md)
### [How to: Sort Elements on Multiple Keys](how-to-sort-elements-on-multiple-keys.md)
### [How to: Calculate Intermediate Values](how-to-calculate-intermediate-values.md)
### [How to: Write a Query that Finds Elements Based on Context](how-to-write-a-query-that-finds-elements-based-on-context.md)
### [How to: Debug Empty Query Results Sets](how-to-debug-empty-query-results-sets.md)
## [Projections and Transformations (LINQ to XML)](projections-and-transformations-linq-to-xml.md)
## [How to: Work with Dictionaries Using LINQ to XML](how-to-work-with-dictionaries-using-linq-to-xml.md)
### [How to: Transform the Shape of an XML Tree](how-to-transform-the-shape-of-an-xml-tree.md)
### [How to: Control the Type of a Projection](how-to-control-the-type-of-a-projection.md)
### [How to: Project a New Type (LINQ to XML)](how-to-project-a-new-type-linq-to-xml.md)
### [How to: Project an Object Graph](how-to-project-an-object-graph.md)
### [How to: Project an Anonymous Type](how-to-project-an-anonymous-type.md)
### [How to: Generate Text Files from XML](how-to-generate-text-files-from-xml.md)
### [How to: Generate XML from CSV Files](how-to-generate-xml-from-csv-files.md)
## [Advanced Query Techniques (LINQ to XML)](advanced-query-techniques-linq-to-xml.md)
### [How to: Join Two Collections (LINQ to XML)](how-to-join-two-collections-linq-to-xml.md)
#### [How to: Create Hierarchy Using Grouping](how-to-create-hierarchy-using-grouping.md)
#### [How to: Query LINQ to XML Using XPath](how-to-query-linq-to-xml-using-xpath.md)
#### [How to: Write a LINQ to XML Axis Method](how-to-write-a-linq-to-xml-axis-method.md)
#### [How to: List All Nodes in a Tree](how-to-list-all-nodes-in-a-tree.md)
#### [How to: Retrieve Paragraphs from an Office Open XML Document](how-to-retrieve-paragraphs-from-an-office-open-xml-document.md)
#### [How to: Modify an Office Open XML Document](how-to-modify-an-office-open-xml-document.md)
#### [How to: Populate an XML Tree from the File System](how-to-populate-an-xml-tree-from-the-file-system.md)
## [LINQ to XML for XPath Users](linq-to-xml-for-xpath-users.md)
### [Comparison of XPath and LINQ to XML](comparison-of-xpath-and-linq-to-xml.md)
### [How to: Find a Child Element (XPath-LINQ to XML)](how-to-find-a-child-element-xpath-linq-to-xml.md)
### [How to: Find a List of Child Elements (XPath-LINQ to XML)](how-to-find-a-list-of-child-elements-xpath-linq-to-xml.md)
### [How to: Find the Root Element (XPath-LINQ to XML)](how-to-find-the-root-element-xpath-linq-to-xml.md)
### [How to: Find Descendant Elements (XPath-LINQ to XML)](how-to-find-descendant-elements-xpath-linq-to-xml.md)
### [How to: Filter on an Attribute (XPath-LINQ to XML)](how-to-filter-on-an-attribute-xpath-linq-to-xml.md)
### [How to: Find Related Elements (XPath-LINQ to XML)](how-to-find-related-elements-xpath-linq-to-xml.md)
### [How to: Find Elements in a Namespace (XPath-LINQ to XML)](how-to-find-elements-in-a-namespace.md)
### [How to: Find Preceding Siblings (XPath-LINQ to XML)](how-to-find-preceding-siblings-xpath-linq-to-xml.md)
### [How to: Find Descendants of a Child Element (XPath-LINQ to XML)](how-to-find-descendants-of-a-child-element-xpath-linq-to-xml.md)
### [How to: Find a Union of Two Location Paths (XPath-LINQ to XML)](how-to-find-a-union-of-two-location-paths-xpath.md)
### [How to: Find Sibling Nodes (XPath-LINQ to XML)](how-to-find-sibling-nodes-xpath-linq-to-xml.md)
### [How to: Find an Attribute of the Parent (XPath-LINQ to XML)](how-to-find-an-attribute-of-the-parent-xpath-linq-to-xml.md)
### [How to: Find Attributes of Siblings with a Specific Name (XPath-LINQ to XML)](how-to-find-attributes-of-siblings-with-a-specific-name.md)
### [How to: Find Elements with a Specific Attribute (XPath-LINQ to XML)](how-to-find-elements-with-a-specific-attribute.md)
### [How to: Find Child Elements Based on Position (XPath-LINQ to XML)](how-to-find-child-elements-based-on-position.md)
### [How to: Find the Immediate Preceding Sibling (XPath-LINQ to XML)](how-to-find-the-immediate-preceding-sibling-xpath-linq-to-xml.md)
## [Pure Functional Transformations of XML](pure-functional-transformations-of-xml.md)
### [Introduction to Pure Functional Transformations](introduction-to-pure-functional-transformations.md)
### [Concepts and Terminology (Functional Transformation)](concepts-and-terminology-functional-transformation.md)
### [Functional Programming vs. Imperative Programming](functional-programming-vs-imperative-programming.md)
### [Refactoring Into Pure Functions](refactoring-into-pure-functions.md)
### [Applicability of Functional Transformation](applicability-of-functional-transformation.md)
### [Functional Transformation of XML](functional-transformation-of-xml.md)
### [Tutorial: Deferred Execution](tutorial-deferred-execution.md)
### [Deferred Execution and Lazy Evaluation in LINQ to XML](deferred-execution-and-lazy-evaluation-in-linq-to-xml.md)
### [Deferred Execution Example](deferred-execution-example.md)
### [Tutorial: Manipulating Content in a WordprocessingML Document](tutorial-manipulating-content-in-a-wordprocessingml-document.md)
### [Shape of WordprocessingML Documents](shape-of-wordprocessingml-documents.md)
### [Creating the Source Office Open XML Document](creating-the-source-office-open-xml-document.md)
### [Finding the Default Paragraph Style](finding-the-default-paragraph-style.md)
### [Retrieving the Paragraphs and Their Styles](retrieving-the-paragraphs-and-their-styles.md)
### [Retrieving the Text of the Paragraphs](retrieving-the-text-of-the-paragraphs.md)
### [Refactoring Using an Extension Method](refactoring-using-an-extension-method.md)
### [Refactoring Using a Pure Function](refactoring-using-a-pure-function.md)
### [Projecting XML in a Different Shape](projecting-xml-in-a-different-shape.md)
### [Finding Text in Word Documents](finding-text-in-word-documents.md)
### [Details of Office Open XML WordprocessingML Documents](details-of-office-open-xml-wordprocessingml-documents.md)
### [WordprocessingML Document with Styles](wordprocessingml-document-with-styles.md)
### [Style Part of a WordprocessingML Document](style-part-of-a-wordprocessingml-document.md)
### [Example that Outputs Office Open XML Document Parts](example-that-outputs-office-open-xml-document-parts.md)

# [Modifying XML Trees (LINQ to XML)](modifying-xml-trees-linq-to-xml.md)
## [In-Memory XML Tree Modification vs. Functional Construction (LINQ to XML)](in-memory-xml-tree-modification-vs-functional-construction.md)
## [Adding Elements, Attributes, and Nodes to an XML Tree](adding-elements-attributes-and-nodes-to-an-xml-tree.md)
## [Modifying Elements, Attributes, and Nodes in an XML Tree](modifying-elements-attributes-and-nodes-in-an-xml-tree.md)
## [Removing Elements, Attributes, and Nodes from an XML Tree](removing-elements-attributes-and-nodes-from-an-xml-tree.md)
## [Maintaining Name-Value Pairs](maintaining-name-value-pairs.md)
## [How to: Change the Namespace for an Entire XML Tree](how-to-change-the-namespace-for-an-entire-xml-tree.md)

# [Performance (LINQ to XML)](performance-linq-to-xml.md)
## [Performance of Chained Queries (LINQ to XML)](performance-of-chained-queries-linq-to-xml.md)
## [Atomized XName and XNamespace Objects (LINQ to XML)](atomized-xname-and-xnamespace-objects-linq-to-xml.md)
## [Pre-Atomization of XName Objects (LINQ to XML)](pre-atomization-of-xname-objects-linq-to-xml.md)
## [Statically Compiled Queries (LINQ to XML)](statically-compiled-queries-linq-to-xml.md)

# [Advanced LINQ to XML Programming](advanced-linq-to-xml-programming.md)
## [LINQ to XML Annotations](linq-to-xml-annotations.md)
## [LINQ to XML Events](linq-to-xml-events.md)
## [Programming with Nodes](programming-with-nodes.md)
## [Mixed Declarative Code-Imperative Code Bugs (LINQ to XML)](mixed-declarative-code-imperative-code-bugs-linq-to-xml.md)
## [How to: Stream XML Fragments with Access to Header Information](how-to-stream-xml-fragments-with-access-to-header-information.md)
## [How to: Perform Streaming Transform of Large XML Documents](how-to-perform-streaming-transform-of-large-xml-documents.md)
## [How to: Read and Write an Encoded Document](how-to-read-and-write-an-encoded-document.md)
## [Using XSLT to Transform an XML Tree](using-xslt-to-transform-an-xml-tree.md)
## [How to: Use Annotations to Transform LINQ to XML Trees in an XSLT Style](how-to-use-annotation-trees-to-transform-linq-to-xml-trees-in-an-xslt-style.md)
## [Serializing Object Graphs that Contain XElement Objects](serializing-object-graphs-that-contain-xelement-objects.md)
### [How to: Serialize Using XmlSerializer](how-to-serialize-using-xmlserializer.md)
### [How to: Serialize Using DataContractSerializer](how-to-serialize-using-datacontractserializer.md)
## [LINQ to XML Security](linq-to-xml-security.md)
## [Sample XML Documents (LINQ to XML)](sample-xml-documents-linq-to-xml.md)
### [Sample XML File: Typical Purchase Order (LINQ to XML)](sample-xml-file-typical-purchase-order-linq-to-xml.md)
### [Sample XML File: Typical Purchase Order in a Namespace](sample-xml-file-typical-purchase-order-in-a-namespace.md)
### [Sample XML File: Multiple Purchase Orders (LINQ to XML)](sample-xml-file-multiple-purchase-orders-linq-to-xml.md)
### [Sample XML File: Multiple Purchase Orders in a Namespace](sample-xml-file-multiple-purchase-orders-in-a-namespace.md)
### [Sample XML File: Test Configuration (LINQ to XML)](sample-xml-file-test-configuration-linq-to-xml.md)
### [Sample XML File: Test Configuration in a Namespace](sample-xml-file-test-configuration-in-a-namespace.md)
### [Sample XML File: Customers and Orders (LINQ to XML)](sample-xml-file-customers-and-orders-linq-to-xml.md)
### [Sample XSD File: Customers and Orders](sample-xsd-file-customers-and-orders.md)
### [Sample XML File: Customers and Orders in a Namespace](sample-xml-file-customers-and-orders-in-a-namespace.md)
### [Sample XML File: Numerical Data (LINQ to XML)](sample-xml-file-numerical-data-linq-to-xml.md)
### [Sample XML File: Numerical Data in a Namespace](sample-xml-file-numerical-data-in-a-namespace.md)
### [Sample XML File: Books (LINQ to XML)](sample-xml-file-books-linq-to-xml.md)
### [Sample XML File: Consolidated Purchase Orders](sample-xml-file-consolidated-purchase-orders.md)
### [Reference (LINQ to XML)](reference-linq-to-xml.md)
## [LINQ to ADO.NET (Portal Page)](linq-to-adonet-portal-page.md)
## [Enabling a Data Source for LINQ Querying](enabling-a-data-source-for-linq-querying.md)
## [Visual Studio IDE and Tools Support for LINQ](visual-studio-ide-and-tools-support-for-linq.md)
