# Learning Resources

## API Documentation

The documentation for the latest release can be found on deck.gl's [website](https://deck.gl/docs).

The documentation for previous releases are in the *docs* directory on the `<version-release>` branch in this repo.

## Technical Deep Dive

An in-depth view into the technical details and architectural decisions behind deck.gl. [Google Slides](https://docs.google.com/presentation/d/1qtXUQzMuIa8NYIKUa1RKfSwvgpeccY-wrPrYqsb_8rE/edit#slide=id.g7db7fb98fb_0_45)

## Live Demos

The sources of deck.gl's [website demos](https://deck.gl/examples) can be found in the repo's [examples](https://github.com/visgl/deck.gl/tree/8.4-release/examples) directory. Most of the applications use React, although non-React templates are provided for developers from other ecosystems.

## Prototyping & Sharing

PureJS examples in prototyping environments. These are great templates for feature testing and bug reporting:

* deck.gl's [Codepen demos](https://codepen.io/vis-gl/)
* deck.gl's [Observable demos](https://beta.observablehq.com/@pessimistress)
* [One-page scripting examples](http://deck.gl/showcases/gallery/)

## Community

[vis.gl's Medium blog](https://medium.com/vis-gl) 

Join our [Slack workspace](https://join.slack.com/t/deckgl/shared_invite/zt-7oeoqie8-NQqzSp5SLTFMDeNSPxi7eg) for learning and discussions.
