import * as React from "react";

function SvgJh(props: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      className="JH_svg__card"
      preserveAspectRatio="none"
      viewBox="-106 -164.5 212 329"
      {...props}
    >
      <defs>
        <path id="JH_svg__i" d="M-58-112.5H58v225H-58z" />
      </defs>
      <symbol
        id="JH_svg__h"
        viewBox="-500 -500 1000 1000"
        preserveAspectRatio="xMinYMid"
      >
        <path
          d="M50-460h200m-100 0v710a100 100 0 01-400 0v-30"
          stroke="red"
          strokeWidth={80}
          strokeLinecap="square"
          strokeMiterlimit={1.5}
          fill="none"
        />
      </symbol>
      <symbol
        id="JH_svg__a"
        viewBox="-600 -600 1200 1200"
        preserveAspectRatio="xMinYMid"
      >
        <path
          d="M0-300c0-100 100-200 200-200s200 100 200 250C400 0 0 400 0 500 0 400-400 0-400-250c0-150 100-250 200-250S0-400 0-300z"
          fill="red"
        />
      </symbol>
      <symbol id="JH_svg__b" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#FC4"
          d="M0 27.174v74.783L60 175v479.352l45-31.2V332.344c47.547 13.885 57.732 59.91 59.799 112.822C207.183 366.332 172.25 341.869 155 305c22.435-6.794 44.101-15.652 60-40-19.522-21.34-39.812-27.132-60-35 45.6-69.7 20.41-97.002-2.076-126.053 4.262 33.894 6.383 68.408-47.381 116.953L105 280.75V155zm616.344 92.865c-90.016.021-177.157 15.772-250.18 35.988C314.554 278.493 383.861 375.085 320 480c20-55-81.657-74.736-75 5 1.622 19.425 15.247 28.676 31.951 29.883-4.328-.204-8.267-.745-11.527-1.725l-45.067 31.086-.004-.006L0 696.207v30l235.473-162.394-14.711-19.047L497.5 902.5l.037 17.5H802.5v-17.5c28.548-117.155 72.473-223.814 144.93-319.041l-103.836-76.063c-18.965 21.007-35.782 42.994-50.819 65.793l2.102-3.189H410.283L360 505h-21.818c7.03-2.09 14.314-4.383 21.775-6.81 3.82-.613 7.658-1.203 11.504-1.786L360 505l11.695 15h459.649l12.2-12.578L820 490H412.902c34.86-5.908 68.524-14.106 95.883-32.45 7.353-4.929 12.789-12.426 20.594-17.134 11.293-6.812 22.21-13.53 28.297-25.416l-25.602 9.586 25.207-9.51c8.975-2.712 15.274-10.185 22.719-25.076 60.119-120.238-19.763-129.971 64.36-269.45a751.796 751.796 0 00-28.016-.51zm547.152 344.535c-23.907-.209-52.475 9.66-73.496 25.426-40 30-80 15-75-25-70 30-5 140 65 95 42.196-27.126 105-40 115-5 31.743-65.249 5.791-90.1-31.504-90.426zm-868.371 48.733l-2.736 1.025c-2.77.294-5.484.487-8.118.582 3.569-.215 7.21-.758 10.854-1.607zm497.47 60.156c-65.17 98.935-96.87 213.154-125.156 328.959l-253.982-328.32L422.639 585H785zm226.852 63.707c-52.412 65.676-90.819 136.71-119.543 212.92l21.532 23.418c27.582-79.521 64.959-153.577 116.837-221.973-5.411 26.806-8.273 54.748-8.273 83.465 0 136.64 64.808 255.724 160.738 318.285l-2.595-1.59c-45.753 115.83-115.544 225.868-185.647 304.262l13.85 17.496c72.416-75.9 146.448-187.78 195.84-307.033l-6.268-3.838c29.107 16.624 60.756 28.176 94.082 33.701v-18.47c-143.477-19.162-255-163.615-255-339.008 0-26.57 2.563-52.429 7.404-77.252l-14.015-10.17c.107-.141.211-.283.318-.424zm88.403 64.605l17.75 13.198a299.347 299.347 0 00-.668 20.027c0 122.962 75.11 225.59 175.068 249.656V953.92c-85.541-23.521-149.178-112.607-149.178-218.92 0-.681 0-1.361.01-2.041zm-20.276 13.243c-11.012-.227-20.789 7.228-14.314 26.105-44.412-8.721-25.537 58.643 7.295 29.1 7.514 43.327 68.569-5.007 20.601-20.63 18.918-19.53 1.509-34.265-13.582-34.575zm-254.97 86.537l-29.987 105.49c48.755 35.02 80.42 91.607 80.42 155.455 0 37.016-10.642 71.592-29.088 100.94l67.256 87.81C964.193 1199.896 990 1134.156 990 1062.5c0-112.477-63.586-210.376-157.396-260.945zm276.732 19.517c-12.986-.007-25.24 9.442-13.352 29.03-45.25.959-12.431 62.741 13.338 26.87 16.59 40.726 65.922-19.526 15.725-24.55 12.766-20.62-1.887-31.342-15.711-31.35zm59.832 95.608c-15.415.163-32.128 14.613-11.727 32.826-42.995 14.138 6.443 63.635 20.608 21.8 27.764 34.102 57.34-37.933 7.865-28.072 5.06-19.185-5.497-26.674-16.746-26.554zm92.318 75.375c-17.157-.391-37.538 22.873-8.574 35.959-36.78 26.376 25.225 58.778 26.197 14.62 8.782 5.793 15.838 5.75 20.891 2.679v-35.3c-5.022-2.238-12.218-1.771-21.805 3.481-.718-15.416-8.33-21.248-16.709-21.44z"
        />
      </symbol>
      <symbol id="JH_svg__c" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="red"
          d="M199.648 0l156.055 158.855C484.175 122.112 658.575 97.858 815 150L960.455 0H874.2l-72.256 88.408-2.959-.603c-35.207-7.185-69.718-11.909-103.334-14.809l-5.029-.433L697.581 0h-67.604l-.084 70.975-4.998-.006c-38.885-.036-76.4 2.698-112.475 7.174l-4.649.578L492.77 0h-77.48l32.893 88.25-5.829 1.102c-28.864 5.46-56.358 11.819-82.546 18.523l-3.436.88L283.979 0zm96.344 0l64.801 97.352c23.534-5.972 48.19-11.616 73.916-16.622L404.617 0zM502.95 0l12.903 67.705c33.443-3.997 68.149-6.47 104.052-6.654L619.977 0zm204.674 0l-6.092 63.533c31.424 2.872 63.623 7.331 96.46 13.91L861.282 0zM0 101.957v594.531l60-42.136V175zm434.898 426.797c-6.16 0-12.291 3.65-5.287 10.935a7.5 7.5 0 015.287-2.185 7.5 7.5 0 015.288 2.187c7.006-7.286.873-10.937-5.288-10.937zm5.288 10.937c-.102.106-.18.205-.288.313.108-.108.208-.185.315-.287a7.5 7.5 0 00-.027-.026zm.027.026a7.5 7.5 0 012.185 5.287 7.5 7.5 0 01-2.187 5.287c14.572 14.012 14.573-24.584.002-10.574zm-.002 10.574c-.106-.102-.205-.18-.313-.287.108.108.185.208.287.314a7.5 7.5 0 00.026-.027zm-.026.027a7.5 7.5 0 01-5.287 2.186 7.5 7.5 0 01-5.287-2.188c-14.012 14.573 24.584 14.574 10.574.002zm-10.574-.002c.102-.106.18-.205.287-.312-.108.108-.208.185-.314.287a7.5 7.5 0 00.027.025zm-.027-.025a7.5 7.5 0 01-2.186-5.287 7.5 7.5 0 012.188-5.287c-14.572-14.012-14.574 24.583-.002 10.574zm.002-10.574c.106.102.205.18.312.287-.108-.108-.184-.208-.287-.315a7.5 7.5 0 00-.025.028zm71.816-10.963c-6.16 0-12.291 3.65-5.287 10.935a7.5 7.5 0 015.287-2.185 7.5 7.5 0 015.287 2.187c7.007-7.286.874-10.937-5.287-10.937zm5.287 10.937c-.102.106-.18.205-.287.313.108-.108.208-.185.315-.287a7.5 7.5 0 00-.028-.026zm.028.026a7.5 7.5 0 012.185 5.287 7.5 7.5 0 01-2.187 5.287c14.572 14.012 14.573-24.584.002-10.574zm-.002 10.574c-.106-.102-.205-.18-.313-.287.108.108.185.208.287.314a7.5 7.5 0 00.026-.027zm-.026.027a7.5 7.5 0 01-5.287 2.186 7.5 7.5 0 01-5.287-2.188c-14.012 14.573 24.584 14.574 10.574.002zm-10.574-.002c.102-.106.18-.205.287-.312-.108.108-.208.185-.314.287a7.5 7.5 0 00.027.025zm-.027-.025a7.5 7.5 0 01-2.186-5.287 7.5 7.5 0 012.188-5.287c-14.573-14.012-14.574 24.583-.002 10.574zm.002-10.574c.106.102.205.18.312.287-.108-.108-.185-.208-.287-.315a7.5 7.5 0 00-.025.028zm71.816-10.963c-6.16 0-12.292 3.65-5.287 10.935a7.5 7.5 0 015.287-2.185 7.5 7.5 0 015.287 2.187c7.006-7.286.873-10.937-5.287-10.937zm5.287 10.937c-.102.106-.18.205-.287.313.108-.108.208-.185.315-.287a7.5 7.5 0 00-.028-.026zm.028.026a7.5 7.5 0 012.185 5.287 7.5 7.5 0 01-2.187 5.287c14.572 14.012 14.573-24.584.002-10.574zm-.002 10.574c-.107-.102-.205-.18-.313-.287.108.108.185.208.287.314a7.5 7.5 0 00.026-.027zm-.026.027a7.5 7.5 0 01-5.287 2.186 7.5 7.5 0 01-5.287-2.188c-14.012 14.572 24.584 14.574 10.574.002zm-10.574-.002c.102-.106.18-.205.287-.312-.108.108-.208.184-.314.287a7.5 7.5 0 00.027.025zm-.027-.025a7.5 7.5 0 01-2.186-5.287 7.5 7.5 0 012.188-5.287c-14.573-14.013-14.574 24.583-.002 10.574zm.002-10.574c.106.102.204.179.312.287-.108-.108-.185-.208-.287-.315a7.5 7.5 0 00-.025.028zm71.814-10.963c-6.16 0-12.292 3.65-5.287 10.935a7.5 7.5 0 015.287-2.185 7.5 7.5 0 015.287 2.187c7.006-7.286.873-10.937-5.287-10.937zm5.287 10.937c-.102.106-.18.205-.287.313.108-.108.208-.185.315-.287a7.5 7.5 0 00-.028-.026zm.028.026a7.5 7.5 0 012.185 5.287 7.5 7.5 0 01-2.187 5.287c14.572 14.012 14.573-24.584.002-10.574zm-.002 10.574c-.107-.102-.205-.18-.313-.287.108.108.185.208.287.314a7.5 7.5 0 00.026-.027zm-.026.027a7.5 7.5 0 01-5.287 2.186 7.5 7.5 0 01-5.287-2.188c-14.012 14.572 24.584 14.574 10.574.002zm-10.574-.002c.102-.106.18-.205.287-.312-.108.108-.208.184-.314.287a7.5 7.5 0 00.027.025zm-.027-.025a7.5 7.5 0 01-2.186-5.287 7.5 7.5 0 012.188-5.288c-14.573-14.012-14.574 24.584-.002 10.575zm.002-10.575c.106.102.205.18.312.288-.108-.108-.185-.208-.287-.315a7.5 7.5 0 00-.025.027zm71.816-10.962c-6.16 0-12.292 3.65-5.287 10.935a7.5 7.5 0 015.287-2.185 7.5 7.5 0 015.287 2.187c7.006-7.286.873-10.937-5.287-10.937zm5.287 10.937c-.102.106-.18.205-.287.313.108-.108.208-.185.315-.288a7.5 7.5 0 00-.028-.025zm.027.025a7.5 7.5 0 012.186 5.288 7.5 7.5 0 01-2.187 5.287c14.572 14.012 14.573-24.584.002-10.575zm-.002 10.575c-.106-.102-.204-.18-.312-.287.108.108.185.208.287.314a7.5 7.5 0 00.025-.027zm-.025.027a7.5 7.5 0 01-5.287 2.186 7.5 7.5 0 01-5.287-2.188c-14.012 14.572 24.584 14.573 10.574.002zm-10.574-.002c.102-.106.18-.205.287-.313-.108.108-.208.185-.314.288a7.5 7.5 0 00.027.025zm-.027-.025a7.5 7.5 0 01-2.186-5.288 7.5 7.5 0 012.188-5.287c-14.573-14.012-14.574 24.584-.002 10.575zm.002-10.575c.106.102.204.18.312.287-.108-.108-.185-.208-.287-.314a7.5 7.5 0 00-.025.027zm71.814-10.963c-6.16 0-12.292 3.65-5.287 10.936a7.5 7.5 0 015.287-2.186 7.5 7.5 0 015.287 2.188c7.006-7.286.873-10.938-5.287-10.938zm5.287 10.938c-.102.106-.18.205-.287.312.108-.108.208-.184.314-.287a7.5 7.5 0 00-.027-.025zm.027.025a7.5 7.5 0 012.186 5.287 7.5 7.5 0 01-2.188 5.288c14.573 14.012 14.574-24.584.002-10.575zm-.002 10.575c-.106-.102-.204-.18-.312-.288.108.108.185.208.287.315a7.5 7.5 0 00.025-.027zm-.025.027a7.5 7.5 0 01-5.287 2.185 7.5 7.5 0 01-5.287-2.187c-14.012 14.572 24.583 14.573 10.574.002zm-10.574-.002c.102-.106.18-.205.287-.313-.108.108-.208.185-.315.287a7.5 7.5 0 00.028.026zm-.027-.026a7.5 7.5 0 01-2.186-5.287 7.5 7.5 0 012.187-5.287c-14.572-14.012-14.573 24.584-.002 10.574zm.002-10.574c.106.102.204.18.312.287-.108-.108-.185-.208-.287-.314a7.5 7.5 0 00-.026.027zM470 600l185 240c17.499-85.45 45-165 85-240zm680.832 132.959c-.01.68-.01 1.36-.01 2.041 0 106.313 63.636 195.399 149.178 218.92v-62.346c-46.11-17.785-81.745-62.134-93.36-117.394zM855.346 851.596c-5.123.09-10.463 2.545-15.346 8.404l-19.178 23.014 34.645 30.425L875 890c11.484-13.781-2.921-38.7-19.654-38.404zm48.607 53.824c-3.659.096-7.675 1.344-11.951 4.096l-25.887 16.66 24.733 38.896 25.562-16.45c16.625-10.7 7.3-43.723-12.457-43.202zm-101.336 1.625l-.088 11.303a3 3 0 00-2.574-1.391A3 3 0 00797 920v20a3 3 0 005.346 1.91L802 986.102c42.307 39.722 28.55 84.92 15.53 130.048l36.42 47.29c18.445-29.348 29.087-63.924 29.087-100.94 0-63.848-31.665-120.435-80.42-155.455zm-302.662 9.912A3 3 0 00497 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00512 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00527 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00542 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00557 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00572 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00587 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00602 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00617 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00632 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00647 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00662 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00677 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00692 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00707 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00722 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00737 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00752 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00767 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm15 0A3 3 0 00782 920v20a3 3 0 106 0v-20a3 3 0 00-3.045-3.043zm148.318 54.355c-2.104-.01-4.388.27-6.855.885l-28.98 7.227 12.845 44.303 26.668-6.65c20.958-5.228 21.157-45.65-3.678-45.765zm-20.502 71.096l-.705 46.092 25.528.738c23.42.677 34.5-45.117 1.97-46.056zm-4.398 67.328l-14.518 43.907 28.377 6.9c22.767 5.538 43.137-36.944 11.516-44.635zm-19.982 55.225l-14.916 23.97 25.914 32.993c16.53-3.809 31.378-24.552 12.152-39.256z"
        />
      </symbol>
      <symbol id="JH_svg__d" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#44F"
          d="M1011.237 1309.349l-48.702-63.338C998.863 1193.62 1020 1130.484 1020 1062.5c0-75.31-25.938-144.672-69.62-200.32 21.09-55.64 47.446-108.17 80.685-158.012A453.494 453.494 0 001030 735c0 123.54 52.969 232.746 134.421 299.04-37.025 100.824-93.294 198.03-153.184 275.309zM748 366c20.005-2.57 42.8-23.897 48-29 4.093-4.017 14.922 4.34 14 10-19.782 10.298-48.043 21.628-62 19m-61-142c2.047 3.471 65.668-38.846 77-43 13.905-5.097 26.594 6.692 26 6l2 11s-16.41-11.864-25-9c-9 3-78.944 40.146-80 35zm101 9.5a8.5 15.5 0 01-8.5 15.5 8.5 15.5 0 01-8.5-15.5 8.5 15.5 0 018.5-15.5 8.5 15.5 0 018.5 15.5z"
        />
      </symbol>
      <symbol id="JH_svg__e" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path d="M632.88 93.754c-110.56-.523-210.986 20.512-297.26 44.568l20.083 20.533C484.175 122.112 658.575 97.858 815 150l26.967-28.018c-72.766-19.84-142.75-27.914-209.086-28.228zM265.925 512.605l-3.684 2.356-6.799 22.098 11.08 12.824 48.815-7.51-14.822 44.465 10.316 13.127 46.346-3.861-11.92 51.648 11.389 12.111 45.498-7.582-11.92 55.623 11.422 11.96 44.039-7.34-15.243 49.535 11.08 12.824 49.227-7.574-15.307 49.75L485 830h50.723l-15.121 41.582L530 885h49.47l-7.816 17.195 21.778.42 10.672-23.476L595 865h-50.723l15.121-41.582L550 810h-51.459l16.018-52.059-11.08-12.824-49.227 7.574 15.307-49.75-11.204-12.804-45.498 7.582 11.92-55.623-11.422-11.96-45.25 7.542 11.64-50.43-10.575-12.213-44.889 3.74 15.205-45.613-11.007-13.045-49.227 7.574 3.77-12.25zm627.3 30.627l-44.745 6.885-8.223 12.131 12.752 55.256-55.256 12.752-6.982 13.59 21.154 50.77-50.77 21.154-5.384 13.076 21.675 52.025-42.59 25.555-3.597 13.43 20.896 37.615-43.4 34.72a9.999 9.999 0 00-3.707 9.862l22.803.472 43.396-34.716 2.496-12.664-20.303-36.547 41.706-25.024 4.085-12.42-21.154-50.77 50.77-21.154 5.384-13.076-20.447-49.072 53.465-12.338 7.496-11.992-12.578-54.506 52.484-8.076zM350 550a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm-62.5 7.5a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm605 20a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zM440 585l220 285c24.379-100.968 56.858-199.869 105-285zm387.5 7.5a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zM470 600h270c-40 75-67.501 154.55-85 240zm-137.5 7.5a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm60 0a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm646.01 43.645c-51.91 68.37-89.416 142.62-117.31 222.341C964.095 924.86 990 990.71 990 1062.5c0 71.656-25.806 137.396-68.666 188.766l80.898 104.386c70.369-78.09 140.158-188.125 185.936-304.125-8.049-5.395-15.882-11.065-23.428-17.226-37.345 100.564-93.612 197.77-153.502 275.049l-48.703-63.338c36.328-52.39 57.465-115.528 57.465-183.512 0-4.86-.112-9.692-.326-14.5H1050a3 3 0 100-6h-30.65a322.335 322.335 0 00-2.428-24h45.578a3 3 0 100-6h-46.465a320.373 320.373 0 00-4.726-24H1065a3 3 0 100-6h-55.182a320.523 320.523 0 00-6.181-21H1080a6 6 0 004.396-1.834 380.079 380.079 0 01-6.33-10.166h-78.68a322.919 322.919 0 00-7.413-18H1065a6 6 0 002.568-.545c-2-3.775-3.94-7.594-5.826-11.455h-75.435a326.79 326.79 0 00-9.659-18h76.848a402.114 402.114 0 01-4.908-12h-79.219a331.63 331.63 0 00-12.316-18h84.978a411.36 411.36 0 01-3.822-12h-86.6a860.54 860.54 0 017.121-18h74.454a418.67 418.67 0 01-2.874-12h-66.546a816.478 816.478 0 017.945-18h54.992a425.375 425.375 0 01-1.967-12h-47.416a782.027 782.027 0 018.856-18h36.261a432.84 432.84 0 01-1.103-12h-28.904c11.729-22.086 24.556-43.65 38.629-64.703 1.34-18.056 3.772-35.746 7.453-53.152zM842.5 652.5a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm-465 15a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm60 0a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm345 10a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm-300 45a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm-65 5a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zM805 735a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm-55 30a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm456.824 9.256c11.444 55.19 47.068 99.532 93.176 117.316v-48.914c-31.005-22.778-62.007-45.555-93.176-68.402zM462.5 782.5a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm65 0a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm250 35a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm-270 25a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm65 0a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zM725 845a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5z" />
      </symbol>
      <symbol id="JH_svg__f" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={6}
          fill="none"
          d="M497.5 1097.5v-195h305M497.537 920h304.598m-304.393 20h304.803M497.5 902.5L220.25 544.105M527.5 902.5L239.883 530.703M637.5 902.5L332.043 507.64M667.5 902.5L360 505m483.545 2.421C742.264 619.634 702.256 759.866 667.5 902.5m194.102-381.386C769.05 630.934 730.857 765.611 697.5 902.5m230.267-333.218C849.253 668.405 802.427 779.685 772.5 902.5m174.612-319.436C874.972 678.686 831.048 785.345 802.5 902.5m216.946-265.331c-52.411 65.676-90.817 136.71-119.54 212.92m138.8-199.13c-52.106 68.555-89.611 142.805-117.271 222.55m-88.831-71.955C926.414 852.124 990 950.023 990 1062.5c0 71.656-25.807 137.396-68.796 188.75m-111.74-375.97c62.646 39.588 104.134 108.648 104.134 187.22 0 47.078-14.894 90.74-40.31 126.695m-70.67-282.15c48.754 35.02 80.42 91.607 80.42 155.455 0 37.016-10.644 71.591-29.09 100.939M410.447 570H795.06m-423.364-50h459.648M380 490h440l480 352.653M266.065 512.713L0 696.208m235.472-132.395L0 726.207M950.477 862.55C994.062 917.828 1020 987.191 1020 1062.5c0 67.984-21.137 131.121-57.313 183.425m337.29-149.625C1147.335 1070.987 1030 918.87 1030 735c0-28.79 2.877-56.801 8.315-83.67m261.682 333.334c-99.956-24.068-175.066-126.702-175.066-249.664 0-6.74.226-13.42.67-20.028m174.331 238.937c-85.509-23.549-149.11-112.622-149.11-218.909 0-.681 0-1.361.01-2.041m149.154 158.627c-46.105-17.787-81.731-62.15-93.345-117.406m5.544 292.24c-49.392 119.253-123.424 231.133-195.84 307.034m171.797-321.758c-45.752 115.83-115.542 225.867-185.645 304.261m162.32-321.663c-37.421 100.57-93.69 197.776-153.481 274.922m-48.954-63.12l48.757 63.385m19.875-605.192c-33.188 49.72-59.544 102.25-80.73 157.52M422.639 585H784.9m515.083 492.842C1156.51 1058.675 1045 914.194 1045 738.805c0-26.881 2.62-53.037 7.572-78.126m6.827 80.43c0-.767-.01-1.535-.01-2.304 0-23.564 2.119-46.54 6.143-68.676m12.38 186.235c-8.2-24.99-13.862-51.487-16.612-79.042m79.018 191.77c-20.107-23.634-37.136-50.952-50.307-81.03m151.473 156.424c-31.032-13.014-59.491-32.495-84.226-57.078m142.703 73.235a233.243 233.243 0 01-23.895-4.65m-199.55-337.722a358.968 358.968 0 014.002-37.022m13.192 169.118c-8.155-24.563-13.696-50.687-16.218-77.89m72.541 180.368c-17.576-21.1-32.571-45.234-44.38-71.68m147.018 147.088c-28.584-11.096-54.958-27.99-78.135-49.51M1093.26 715.83a336.361 336.361 0 012.375-23.247m7.264 129.451a327.893 327.893 0 01-6.891-34.376m54.814 137.281c-7.863-10.799-15.053-22.306-21.495-34.43m112.127 111.922c-13.809-6.724-26.972-14.93-39.35-24.455m-92.981-246.44c.214-9.442.844-18.76 1.868-27.93m-1.92 30.736c.013-.937.03-1.872.051-2.807m.243 21.69a319.787 319.787 0 01-.294-18.883m11.772 89.733a304.508 304.508 0 01-8.896-42.388m19.078 71.966a289.884 289.884 0 01-2.965-7.62m38.852 70.849c-8.722-11.416-16.618-23.738-23.575-36.833m46.542 62.922a239.65 239.65 0 01-3.459-3.477m113.556 61.718c-32.013-5.54-61.824-19.135-87.925-38.996m-87.004-109.794c24.758-39.988-53.606-42.759-29.062-2.32-45.25.959-12.432 62.742 13.338 26.872 16.59 40.725 65.92-19.528 15.724-24.552v0m-23.89-102.829c32.723-33.783-43.244-53.216-27.897-8.47-44.411-8.721-25.536 58.643 7.296 29.1 7.514 43.327 68.57-5.008 20.602-20.63v0m84.757 193.64c11.993-45.477-63.761-25.23-28.473 6.273-42.995 14.138 6.444 63.636 20.608 21.802 27.764 34.1 57.339-37.936 7.865-28.075v0m114.22 66.836c-5.027-2.306-12.267-1.873-21.938 3.425-2.191-46.981-68.392-4.957-25.283 14.519-36.78 26.376 25.223 58.779 26.195 14.622 8.812 5.811 15.89 5.757 20.947 2.654m-497.71-4.005c12.292-6.088 37.198-17.855 52.655-21.284 31.902-7.076 33.675 38.555 5 40-14.795.745-43.333 3.13-57.14 4.316m-.601-11.13L835 1045m-31.998-27.773c8.416-9.36 23.833-25.792 34.758-33.279 23.75-16.274 40.204 20.442 17.24 31.052-15.996 7.39-51.487 25.46-51.487 25.46m-.872-9.927l26.992-19.574M802.8 968.572c3.872-6.98 7.984-13.67 11.743-18.34 18.053-22.427 44.39 7.991 25.456 24.768-9.832 8.712-28.329 26.23-37.107 34.582m-.33-15.414l11.981-15.728m-11.863-62.202c12.41.88 23.558 16.505 13.283 30.13-3.496 4.636-8.31 11.292-13.194 18.135m.438 103.301c13.221-1.658 41.624-4.727 57.747-2.804 32.448 3.87 19.034 47.521-8.507 39.404-12.404-3.657-35.107-9.598-49.603-13.34m.272-11.915l30.697 2.832m-30.99 9.45c13.123 3.413 40.07 10.94 54.14 18.569 25.83 14.005 5.327 44.21-15.497 37.286m-30.268-38.778l14.273 7.253m-4.65-232.748L840 860c20.833-25 50 12 35 30l-19.533 23.44m10.648 12.736l25.888-16.661c27.365-17.612 44.11 26.426 24.406 39.106l-25.56 16.45m6.588 14.353l28.98-7.227c31.576-7.875 33.268 39.208 10.533 44.878l-26.667 6.65m2.49 18.683l26.791.774c32.53.94 21.45 46.732-1.97 46.056l-25.527-.738m-3.695 21.236l25.376 6.172c31.62 7.69 11.25 50.173-11.516 44.636l-28.376-6.902m-5.466 11.32l23.151 17.705c19.227 14.704 4.377 35.45-12.153 39.257m-68.767-416.036c8.31 11.195 11.712 25.645 4.933 37.823 33.98-40.776 81.55 19.572 57.085 48.93 44.634-28.725 71.945 43.102 39.809 63.784 51.5-12.844 54.259 63.95 17.179 73.198 53.056 1.532 34.986 76.22-3.214 75.118 51.574 12.544 18.35 81.834-18.783 72.802 29.402 22.487 9.945 53.634-14.82 62.554M0 27.174L105 155v468.153M0 101.956L60 175v479.351m45.543-433.45C171.888 160.994 153.133 122.458 150 80c151.153 128.774 109.829 254.773 15 380-.731-59.309-8.18-112.84-60.466-127.797m48.533-228.21C175.411 133 200.6 160.302 155 230c20.188 7.868 40.478 13.66 60 35-15.899 24.348-37.565 33.206-60 40 17.25 36.87 52.183 61.332 9.94 139.946m921.1 240.608c1.723-14.746 5.188-42.095 8.96-45.554 5.241-4.806 44.33-54.33 50-60 5-5 35-10 40-10s26.73 9.53 30 25c9.58 45.312-10.243 75.366-35 10-10 10-15 10-30 10 42.72 33.895 28.888 60.209-15 80m54.832-125.17c3.706-4.796 8.718-9.813 15.168-14.83 30.749-23.916 77.015-7.611 30 30-6.876 5.5-13.28 9.583-19.093 12.442m15.06-9.207c37.403-11.47 66.809 9.202 8.431 42.197-55.596 31.424-78.104 13.095-54.412-13.082m53.107 13.57c34.28-2.653 54.672 18.516-2.566 38.272-59.976 20.701-76.954-1.871-43.853-22.363m45.822 21.752c34.15-2.053 55.894 22.657.33 36.419-57.162 14.158-68.359-12.308-31.514-28.41m-28.49 76.72c22.273-6.891 50.558-31.936 53.307-46.624m-62.557-34.09c4.879 19.335-15.884 43.747-18.572 42.404m-135-250c-5 40 35 55 75 25 53.815-40.36 157.09-42.075 105 65-10-35-72.804-22.126-115 5-70 45-135-65-65-95v0m0 0c-45.453 52.655 14.216 101.957 90 50 74.272-50.92 112.522 23.688 90 40l-5 15m-16.173-104.722c8.656 16.019 15.13 32.112 16.275 48.387m-39.75-48.355c9.919 11.142 17.945 22.907 22.307 35.877m-62.768-23.221c9.181 6.823 17.741 14.14 24.699 22.41m-58.237-1.766c12.964 2.473 25.084 6.157 35.63 12.093m-62.977-4.685c9.893 7.502 18.578 15.684 25.12 25.074m-54.327-39.752c7.39 15.133 13.117 30.231 14.738 45.245m130.478-2.62c5.593-10.021 4.31-21.725.053-35.11m-23.11 36.61c4.67-10.08 3.387-22.601.018-37.077m-40.833 49.948c4.647-8.76 5.254-20.123 4.458-33.296m-53.32 55.416c7.155-8.407 10.15-21.05 12.29-36.07m-60.044 18.127c6.742-4.077 12.714-10.692 18.646-18.784M807.137 147.068C812.881 165.268 820 189.034 820 195c0 11.18-5 13.128-5 20 0 5 40 70 40 90s-20 20-25 20 0 20 0 25-5 15-5 15 5 7.929 5 15c0 15-30 15-30 15s5 15 5 20 20 0 20 25c0 10-30 35-40 35s-20-10-30-10-25 10-35 10-61.026-20.513-80-30c-10-5-8.577-19.972-25.6-26.568-10.395-4.028-21.739-19.195-30.499-36.124M800 295c-39.021 3.503-15.755 40.282 20 15 8.165-5.773 0 5 0 5-9.083 0-18.017 4.731-25 4m-47 47c20.005-2.57 42.8-23.897 48-29 4.093-4.017 14.922 4.34 14 10-19.782 10.298-48.043 21.628-62 19m36 8c14.112-2.18 28.148-.782 41-10M687 224c2.047 3.471 65.668-38.846 77-43 13.905-5.097 26.594 6.692 26 6l2 11s-16.41-11.864-25-9c-9 3-78.944 40.146-80 35v0m28 21c33.347-2.168 60.226-31.538 87-30m-57.04 21.788C732.526 265.243 785.724 244.615 803 254m17 236l-24.893-18.67M366.449 156.054C314.555 278.493 383.861 375.084 320 480c-9.532 15.66-50 25-55 0-8.825-44.126 50.246-27.892 35-10m88.83-319.798C331.02 274.732 395.789 368.424 340 480c-20 40-91.159 51.01-95 5-6.657-79.736 95-60 75-5m91.713-335.824C348.907 271.727 416.684 366.631 360 480c-12.344 24.689-44.178 38.333-67.644 34.343m141.79-375.057C366.706 269.312 432.406 365.186 375 480c-8.547 17.094-22.772 24.414-38.504 25.976m119.852-370.899C385.291 266.557 453.018 353.963 395 470c-12.344 24.689-36.535 38.99-60 35m143.348-373.579C404.032 264.677 473.553 347.894 415 465c-11.864 23.728-30.05 33.243-52.279 30.405m137.558-367.401C422.839 263.26 494.052 346.896 435 465c-12.344 24.689-26.535 28.99-50 25m136.683-364.427C441.983 262.263 514.405 346.19 455 465c-12.344 24.689-31.535 28.99-55 25m143.015-366.694C461.18 261.18 534.732 335.536 475 455c-12.344 24.689-26.535 33.99-50 30m138.984-363.317C480.602 260.56 554.966 330.067 495 450c-12.344 24.689-26.535 33.99-50 30m139.58-359.308C500.249 260.213 575.11 324.782 515 445c-10.357 20.714-18.493 27.076-34.703 26.232M605 120c-85 140-9.792 189.584-70 310-9.215 18.43-16.672 28.284-29.62 30.438M625 120c-85 140-9.792 179.584-70 300-6.153 12.306-15.25 18.305-25.732 20.732m115.355-320.11C560.237 260.029 640.12 269.762 580 390c-7.445 14.89-13.743 22.365-22.718 25.077M335.618 138.234c138.041-38.401 312.307-69.157 506.308-16.415M199.648 0l156.055 158.855C484.175 122.112 658.575 97.858 815 150L960.455 0"
        />
      </symbol>
      <symbol id="JH_svg__g" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={3}
          fill="none"
          d="M115 211.838v124.197m10-134.865v140.314m10-152.879v160.713m10-177.425v189.582M155 90v292.195m10-288.793V455m10-351.965V446.28m10-332.818v318.725m10-307.416v292.406m10-279.942v263.631m10-249.625v231.977m10-215.399v195.68M1202 680c9.81 8.788 7.628 26.84 4 27m-12-58c9.81 8.788 7.628 26.84 4 27m17-73c-9 5-4 36-4 36m10 9c3.216 4.712 3.826 10.284 4 16m6 18c3.216 4.712 3.826 10.284 4 16M804 254c-2.915-2.551-26.04 5.376-27 11m26-51c-12 3-23-10-37-10-4.123 0-22 8-22 8m41.397 5.99c3.634 2.779 5.513 8.267 5.603 14.51 0 10.217-6.492 18.5-14.5 18.5s-14.5-8.283-14.5-18.5c0-1.545.148-3.046.428-4.48M594.212 400h-19.5m33.457 15h-50.492m70.197 15H548.03m91.748 15H526.273M670 460H510m135 15H474.754"
        />
        <use
          xlinkHref="#JH_svg__a"
          height={100}
          transform="matrix(1 0 0 .793 496 960.35)"
        />
        <use
          xlinkHref="#JH_svg__a"
          height={100}
          transform="matrix(-1 0 0 -.793 665 1039.65)"
        />
        <use
          xlinkHref="#JH_svg__a"
          height={75}
          transform="scale(1 .793) rotate(30 -1296.98 2086.439)"
        />
        <use
          xlinkHref="#JH_svg__a"
          height={75}
          transform="scale(1 .793) rotate(30 -1128.026 2105.168)"
        />
        <use
          xlinkHref="#JH_svg__a"
          height={75}
          transform="scale(1 .793) rotate(30 -955.574 2136.96)"
        />
        <use
          xlinkHref="#JH_svg__a"
          height={75}
          transform="matrix(.5 .68676 -.86603 .3965 233.543 592.92)"
        />
        <use
          xlinkHref="#JH_svg__a"
          height={75}
          transform="matrix(.5 .68676 -.86603 .3965 168.543 687.92)"
        />
        <use
          xlinkHref="#JH_svg__a"
          height={75}
          transform="matrix(.5 .68676 -.86603 .3965 65.543 687.92)"
        />
        <use
          xlinkHref="#JH_svg__a"
          height={75}
          transform="matrix(.5 .68676 -.86603 .3965 109.543 784.92)"
        />
      </symbol>
      <rect
        width={211}
        height={328}
        x={-105.5}
        y={-164}
        rx={12}
        ry={12}
        fill="#fff"
        stroke="#000"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JH_svg__b" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JH_svg__b"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JH_svg__c" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JH_svg__c"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JH_svg__d" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JH_svg__d"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JH_svg__e" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JH_svg__e"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JH_svg__f" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JH_svg__f"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JH_svg__g" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JH_svg__g"
      />
      <use xlinkHref="#JH_svg__h" height={50} x={-104} y={-152.5} />
      <use xlinkHref="#JH_svg__a" height={41.827} x={-99.913} y={-97.5} />
      <use xlinkHref="#JH_svg__a" height={38.6} x={23.834} y={-109.3} />
      <g transform="rotate(180)">
        <use xlinkHref="#JH_svg__h" height={50} x={-104} y={-152.5} />
        <use xlinkHref="#JH_svg__a" height={41.827} x={-99.913} y={-97.5} />
        <use xlinkHref="#JH_svg__a" height={38.6} x={23.834} y={-109.3} />
      </g>
      <use xlinkHref="#JH_svg__i" stroke="#44F" fill="none" />
    </svg>
  );
}

export default SvgJh;
