import * as React from "react";

function SvgKc(props: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      className="KC_svg__card"
      preserveAspectRatio="none"
      viewBox="-106 -164.5 212 329"
      {...props}
    >
      <defs>
        <path id="KC_svg__i" d="M-58-112.5H58v225H-58z" />
      </defs>
      <symbol
        id="KC_svg__h"
        viewBox="-500 -500 1000 1000"
        preserveAspectRatio="xMinYMid"
      >
        <path
          d="M-285-460h200m-100 0v920m-100 0h200M85-460h200m-100 20l-355 595M85 460h200m-100-20L-10-70"
          stroke="green"
          strokeWidth={80}
          strokeLinecap="square"
          strokeMiterlimit={1.5}
          fill="none"
        />
      </symbol>
      <symbol
        id="KC_svg__a"
        viewBox="-600 -600 1200 1200"
        preserveAspectRatio="xMinYMid"
      >
        <path
          d="M30 150c5 235 55 250 100 350h-260c45-100 95-115 100-350a10 10 0 00-20 0 210 210 0 11-74-201 10 10 0 0014-14 230 230 0 11220 0 10 10 0 0014 14 210 210 0 11-74 201 10 10 0 00-20 0z"
          fill="green"
        />
      </symbol>
      <symbol id="KC_svg__b" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#FC4"
          d="M315.885 799.273c-12.563 0-24.692 1.854-36.106 5.372-.482 27.81-.564 55.372-.33 82.757-30.264 3.329-59.226 9.71-87.205 18.668a120.565 120.565 0 00-1.36 18.203c0 19.373 4.408 37.715 12.397 53.82 85.715-21.842 147.417-22.492 227.926-6.011 6.3-14.68 9.678-30.85 9.678-47.809 0-9.418-1.041-18.593-3.1-27.3-28.568-6.29-55.928-10.094-82.244-11.602-1.17-27.086-2.756-54.122-4.695-81.094-11.012-3.261-22.783-5.004-34.961-5.004zM315 865a15 15 0 0115 15 15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15zm-50 45a15 15 0 0115 15 15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15zm100 0a15 15 0 0115 15 15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15zm-79.758-106.8a30.653 27.5 0 01-.01-.7 30.653 27.5 0 0130.653-27.5 30.653 27.5 0 0130.653 27.5 30.653 27.5 0 01-.011.741m-43.191-25.277C300.166 763.716 289.4 725.934 265 730c-23.937 3.99-41.64 59.017-20 70 16.945 8.6 16.09-46.873 35-45 9.353.926 13.58 21.494 14.691 28.027m31.247-6.473c1.508-26.148 5.676-51.77 14.062-76.554l-25-30-25 30c8.45 24.97 12.617 50.79 14.095 77.143m31.47 4.447c1.424-7.679 5.688-25.724 14.435-26.59 18.91-1.873 18.055 53.6 35 45 21.64-10.983 3.937-66.01-20-70-24.002-4-34.812 32.494-38.175 47.247m365.23 188.69c16.95-40.089-11.834-60.111-42.055-60.699-30.221.588-59.004 20.61-42.055 60.7-45-34.548-65.376 2.234-65.636 34.062.26 31.828 20.636 68.61 65.636 34.062-16.95 40.09 11.834 60.112 42.055 60.7 30.221-.588 59.004-20.61 42.055-60.7 45 34.548 65.376-2.234 65.636-34.062-.26-31.828-20.636-68.61-65.636-34.062zm-66.723-55.4c-1.29-7.872-2.6-15.7-3.928-23.484a3706.93 3706.93 0 013.942 23.478zm124.392 49.792l56.495-.442c.753-109.529 18.217-216.806 78.238-318.928l-163.814 78.676-154.502-69.477c-9.748-29.54-20.638-57.824-32.993-84.678l-34.474-2.597c41.32 84.043 67.265 185.872 87.853 299.418-30.211-83.707-76.692-146.8-135.994-190.55-57.095-42.12-124.884-65.966-198.717-76.392-16.482 7.738-33.214 16.435-49.742 25.71 182.002 10.663 321.309 95.861 372.763 308.34C635 890 711.037 893.67 749.724 960.328zM609.779 823.213c.129.657.26 1.311.387 1.969-.128-.658-.259-1.312-.387-1.97zm3.334 17.41c.19 1.013.378 2.032.567 3.047-.19-1.015-.377-2.034-.567-3.047zm2.694 14.621c.35 1.93.7 3.861 1.048 5.797-.347-1.937-.698-3.866-1.048-5.797zm1.722 9.6zm597.39 190.095A25 25 0 011225 1075a25 25 0 01-25 25 25 25 0 01-25-25 25 25 0 0114.28-22.585M1260 1035a47.5 20 0 01-47.5 20 47.5 20 0 01-47.5-20 47.5 20 0 0147.5-20 47.5 20 0 0147.5 20zm-155-175c0-20 40-32.707 40 0 0 7.453-10 7.533-10 0 0-5-9.929-5.124-10 5-.247 35 65-10 75-20 10 10 75.247 55 75 20-.071-10.124-10-10-10-5 0 7.533-10 7.453-10 0 0-32.707 40-20 40 0 0 50-85 27.6-95 15-10 12.6-95 35-95-15zM961.508 538.87l-37.137-.566-204.799 98.606-166.841-75.38c-4.21 1.509-10.029 2.485-17.731 3.47l9.177 25.88L720 670l218.71-105.451a597.147 597.147 0 0122.798-25.678zM330.918 0c45.534 67.912 74.949 115.887 97.158 159.965 187.308-23.752 340.515-19.215 490.885 1.271C936.893 122.396 965.058 75.351 1019.584 0zm475.344 960H748.01l6.217 15h51.22zm-254.3 0h-59.367l-.096 15h52.346z"
        />
      </symbol>
      <symbol id="KC_svg__c" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="red"
          d="M330 835a15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15 15 15 0 0115 15zm0 90a15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15 15 15 0 0115 15zm-95 10a15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15 15 15 0 0115 15zm190-5a15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15 15 15 0 0115 15zm-285.18 15.306c7.62 3.718 15.84 8.658 23.19 14.922l33.177-.048c-3.453-11.246-5.302-23.36-5.302-35.906 0-58.338 39.964-107.342 94.009-121.128l.348.054a23.32 23.32 0 01-.01-.7c0-7.817 3.636-14.872 9.466-19.676-1.117-6.33-5.345-26.898-14.698-27.824-18.91-1.873-18.055 53.6-35 45-21.64-10.983-3.937-66.01 20-70 24.4-4.067 35.167 33.716 38.336 47.964l.76-.82C302.615 750.79 298.448 724.97 290 700l25-30 25 30c-8.386 24.785-12.554 50.406-14.062 76.554l.887.693C330.188 762.494 340.998 726 365 730c23.937 3.99 41.64 59.017 20 70-16.945 8.6-16.09-46.873-35-45-8.747.866-13.011 18.911-14.708 26.302 6.748 4.751 11.246 12.503 11.246 21.198 0 0-.004.494.335.738 54.217 13.901 94.012 62.821 94.012 121.036 0 12.296-1.775 24.178-5.178 35.564l24.589.162-.035-241.332c-67.1-62.058-155.93-91.59-258.1-97.65-21.19 11.91-42.062 24.819-62.295 38.421L140 940zM600.074 1000a20 20 0 01-20 20 20 20 0 01-20-20 20 20 0 0120-20 20 20 0 0120 20zM670 944.17a20 20 0 01-20 20 20 20 0 01-20-20 20 20 0 0120-20 20 20 0 0120 20zm-177.721 30.287c.903 16.641 1.104 34.162 1.149 50.803l53.45-.34c-3.026-7.746-4.5-16.506-4.568-24.92.07-8.615 1.614-17.593 4.745-25.429m402.44-18.974c-40.89 11.85-72.976 43.679-85.452 84.269l-38.424.127c-9.314-175.275 7.103-342.09 153.56-494.674l95.939 35.134C968.125 698.475 943.888 822.19 949.495 955.597zM869.19 535.838l55.182 2.466-204.799 98.606-167.212-75.257c4.802-1.49 8.364-3.585 12.054-6.76C585 580 615 560 615 535c10 30 15 40 39.615 43.97 28.318-1.169 56.271-2.887 77.742-14.417 16.018 6.956 33.705 5.118 42.247-4.035 29.608 4.696 64.647-11.968 69.86-23.703 8.365 1.277 17.09 1.043 24.725-.977zM385.068 83.802c10.924 7.535 23.025 14.09 36.414 17.193 3.266 10.612 6.91 23.054 14.428 36.764 3.726 6.796 8.658 13.439 14.082 19.652 56.069-6.631 109.767-10.662 161.315-12.313 10.983-14.435 19.108-32.141 23.045-52.675 9.534-4.369 17.877-10.464 24.628-17.581 6.334 7.51 14.316 14.094 23.585 19.026 2.55 19.152 8.806 36.11 17.092 50.458 62.52.996 122.87 5.51 182.229 12.897a76.748 76.748 0 003.278-3.56c13.509-15.578 21.044-36.194 22.98-60.172 26.421-5.61 46.23-13.179 61.298-20.946-37.415 57.321-54.087 93.091-66.473 127.903-140.51-18.324-283.074-22.316-457.022-2.241-15.705-36.131-34.098-70.825-60.88-114.405z"
        />
      </symbol>
      <symbol id="KC_svg__d" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#44F"
          d="M1200 135c-.037 15.315 1.717 33.768 1.717 48.768s-15 62.052-15 77.052c0 15 10.484 45.412 10.484 65.412 0 20-16.307 64.104-16.307 84.104s15.56 56.307 15.56 76.307-10.56 45-10.56 65 13.842 48.62 13.842 73.62c0 25-18.842 55.895-18.842 75.895 0 20 9.813 29.178 9.813 54.178 0 23.257-10.175 80.864-10.748 104.863l20.45-14.576c1.907-27.812 7.83-71.454 7.3-90.894-.682-24.991-10.74-33.899-11.285-53.891-.546-19.993 17.448-51.39 16.765-76.381-.682-24.99-15.302-53.224-15.847-73.217-.546-19.992 9.327-45.27 8.781-65.263-.546-19.993-17.089-55.86-17.635-75.852-.545-19.993 14.552-64.527 14.006-84.52-.546-19.992-11.856-50.105-12.266-65.1-.409-14.994 13.302-62.438 12.893-77.433-.41-14.994-2.675-33.393-3.121-48.072zM652.26 294.03a10 17.5 0 00-10 17.5 10 17.5 0 0010 17.5 10 17.5 0 0010-17.5 10 17.5 0 00-10-17.5zm-150.045 5.173a10 17.5 0 00-10 17.5 10 17.5 0 0010 17.5 10 17.5 0 0010-17.5 10 17.5 0 00-10-17.5zM550 420c-30 10-25 25-45 30l-.535.986C519.068 450.964 535 432.1 550 430zm50 0v10c32.317 0 45.72 21.485 67.297 20.986l-.791-.986c-29.558-5-14.408-25-66.506-30zm526 179.06c-110.185 112.445-133.558 223.165-127.121 352.563 49.77 5.739 90.761 41.014 104.746 88.152l33.434.155C1119.776 1025.488 1105 1003.42 1105 970c0-65 45-75 55-75 10.714 0 19.736 7.646 25.88 18.133 3.558-5.198 14.419-10.99 32.491-14.863 66.707-14.295 60.623 22.505 20.53 29.048 36.973-3.506 38.854 15.323 19.52 26.08 21.322 5.563 13.379 23.555-10.728 29.428 31.24 4.096 17.127 31.041-17.062 32.983 17.353 3.767 29.369 10.888 29.369 19.191 0 1.834-.586 3.61-1.627 5.148l41.627-.119V662.668l-55-20.164-.103 230.912c16.05 6.826 30.218 7.928 30.103-8.416-.071-10.124-10-10-10-5 0 7.533-10 7.453-10 0 0-32.707 40-20 40 0 0 50-85 27.6-95 15-4.206 5.3-21.68 12.325-40.516 14.977a121.91 121.91 0 01-4.216.521C1130.54 893.06 1105 887.408 1105 860c0-20 40-32.707 40 0 0 7.453-10 7.533-10 0 0-5-9.929-5.124-10 5-.114 16.128 13.68 15.268 29.783 8.55l.217-264.34zm112.9 328.258c-1.969.187-4.01.42-6.181.739a73.72 73.72 0 006.181-.739zm-778.726-208.73L459.896 960l90.754.072 24.672-30.822c-22.643-93.147-62.25-161.868-115.148-210.662zm362.207 5.328a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zM620 735a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zm48.03 3.283a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zm109.605 1.233a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zm-76.764 15.19a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zm45.154 2.052a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zM52.5 772.5A7.5 7.5 0 0045 780a7.5 7.5 0 007.5 7.5A7.5 7.5 0 0060 780a7.5 7.5 0 00-7.5-7.5zm430 10c6.904 0 12.5 5.596 12.5 12.5s-5.596 12.5-12.5 12.5S470 801.904 470 795s5.596-12.5 12.5-12.5zm144.889 3.402a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zm154.761 2.875a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zm-111.658.82a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zM37.5 790a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm35 2.5A7.5 7.5 0 0065 800a7.5 7.5 0 007.5 7.5A7.5 7.5 0 0080 800a7.5 7.5 0 00-7.5-7.5zM55 805l-25 75 15-15 10 30 5-30 10 15zm648.334 1.018a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zm47.207 0a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zm-373.895 9.003c.997 15.698 1.91 31.455 2.725 47.22 15.947 1.634 32.21 4.045 48.733 7.034a125.276 125.276 0 00-51.458-54.254zm-122.117.417c-24.402 13.713-43.634 35.35-54.459 61.779 17.57-4.566 35.727-8.57 54.344-11.54-.036-16.673.014-33.4.115-50.24zM522.5 827.5c6.904 0 12.5 5.596 12.5 12.5s-5.596 12.5-12.5 12.5S510 846.904 510 840s5.596-12.5 12.5-12.5zm110.227 13a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zm43.103 3.285a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zm108.783 2.463a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zm-75.943 13.957a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zm44.336 3.285a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zM315 865a15 15 0 00-15 15 15 15 0 0015 15 15 15 0 0015-15 15 15 0 00-15-15zm167.5 2.5c6.904 0 12.5 5.596 12.5 12.5s-5.596 12.5-12.5 12.5S470 886.904 470 880s5.596-12.5 12.5-12.5zm-170.459 2.441a6.026 6.074 0 016.027 6.075 6.026 6.074 0 01-6.027 6.074 6.026 6.074 0 01-6.025-6.074 6.026 6.074 0 016.025-6.075zm477.91 22.694a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zm-111.658 6.568a10 10 0 00-9.105 5.867l19.083 4.784a10 10 0 00.022-.65 10 10 0 00-10-10zM537.5 905c6.904 0 12.5 5.596 12.5 12.5s-5.596 12.5-12.5 12.5-12.5-5.596-12.5-12.5 5.596-12.5 12.5-12.5zm220.842 4.877a10 10 0 00-10 10 10 10 0 0010 10 10 10 0 0010-10 10 10 0 00-10-10zM265 910a15 15 0 00-15 15 15 15 0 0015 15 15 15 0 0015-15 15 15 0 00-15-15zm100 0a15 15 0 00-15 15 15 15 0 0015 15 15 15 0 0015-15 15 15 0 00-15-15zm-3.393 4.941a6.026 6.074 0 016.026 6.075 6.026 6.074 0 01-6.026 6.074 6.026 6.074 0 01-6.027-6.074 6.026 6.074 0 016.027-6.075zM261.025 915a6.026 6.074 0 016.028 6.074 6.026 6.074 0 01-6.028 6.074 6.026 6.074 0 01-6.025-6.074 6.026 6.074 0 016.025-6.074zm450.108.623a10 10 0 00-5.623 1.732l15.465 10.043a10 10 0 00.158-1.775 10 10 0 00-10-10zm-385.545 69.748c-33.881.246-68.068 5.053-108.615 14.904 22.598 29.84 58.517 48.998 98.912 48.998 42.75 0 80.488-21.459 102.834-54.234-33.579-6.552-63.236-9.885-93.131-9.668z"
        />
      </symbol>
      <symbol id="KC_svg__e" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path d="M672.932 185.05c-70.695-.11-145.242 4.246-226.6 14.096l10.719 26.286c165.82-19.488 302.234-15.744 436.89 2.144l8.82-26.431c-74.536-10.106-149.708-15.969-229.83-16.094zm-271.56 357.745c-51.872 11.765-101.65 29.67-149.644 52.605 73.92 10.384 141.709 34.23 198.804 76.352 59.302 43.75 105.783 106.842 135.994 190.549-20.588-113.546-46.532-215.375-87.853-299.418L425 555zm537.196 21.969L720 670l-175.822-79.121 21.851 59.182 154.614 69.574 163.99-78.96zm161.953 24.988c-107.836 114.296-132.03 230.929-126.2 361.334l24.765.594c-6.643-129.457 16.73-240.176 127.053-352.534zM1245 642.299v187.726l55-18.357V662.613zM139.914 659.406c-13.638 9.143-39.99 28.348-39.99 28.348L100 900c13.807 0 25 11.193 25 25 0 4.94-1.431 9.543-4.184 13.057 5.065 1.28 12.006 3.796 19.5 7.492L140 940zM1050 787c-4.057-.057-4.057 6.057 0 6h75c4.057.057 4.057-6.057 0-6zm-27.457 25l-1.14 6H1140v-6zm-4.174 23.5l-1.242 9h77.267l7.237-9zm-2.996 25l-.814 9h76.51l-1.036-9zm-1.726 25.5l-.493 18h98.631l-13.719-18zm-.602 31l.133 6h86.402l3.067-6zm.447 20l14.803 6h64.621l1.395-6zm44.559 20l8.865 6h23.383l.357-6zm25.17 20l5.52 6h2.034l-.543-6zm-725.149 6.648a3 3 0 00-1.603.53c-11.457 7.662-25.357 12.095-40.584 12.095-13.727 0-26.375-3.604-37.13-9.927a3 3 0 10-3.04 5.172c11.669 6.86 25.39 10.755 40.17 10.755 16.394 0 31.485-4.793 43.92-13.109a3 3 0 00-1.733-5.516zm33.12 3.672a3 3 0 00-2.297 1.055c-17.731 20.208-43.762 32.898-73.01 32.898-27.389 0-51.952-11.127-69.528-29.136a3 3 0 10-4.294 4.19c18.666 19.126 44.806 30.946 73.822 30.946 30.985 0 58.688-13.478 77.52-34.941a3 3 0 00-2.214-5.012z" />
      </symbol>
      <symbol id="KC_svg__f" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={6}
          fill="none"
          d="M522.9 3.48c9.296 67.906 63.934 63.431 67.753 108.843 3.44 40.92-51.646 45.49-54.872 4.551-2.18-27.669 29.204-29.893 31.355-2.6 1.076 13.646-18.521 15.271-19.597 1.625M522.9 3.48c1.458 68.558-53.17 73.145-49.829 118.597 3.012 40.956 58.098 36.388 54.872-4.551-2.18-27.67-33.506-24.692-31.355 2.6 1.075 13.647 20.672 12.021 19.597-1.625M803.52.008c-1.617 68.432 60.021 74.375 56.2 119.752-3.445 40.92-65.7 35.011-62.012-5.887 2.493-27.641 37.895-23.901 35.436 3.364-1.23 13.633-23.377 11.53-22.147-2.102M803.499.01c-10.65 67.57-72.303 61.812-76.662 107.136-3.931 40.874 58.324 46.784 62.012 5.886 2.493-27.641-32.977-30.629-35.436-3.363-1.229 13.633 20.918 15.735 22.148 2.102m106.2 45.593a85.325 85.325 0 003.403-3.7c13.509-15.579 21.044-36.194 22.98-60.173 26.421-5.61 46.23-13.179 61.856-21.684M840.764 152.61c27.817-11.555 43.905-36.165 40.852-82.081 88.422-13.035 96.24-42.478 134.5-65.724M384.638 83.186c11.354 8.151 23.455 14.705 36.844 17.809 3.266 10.612 6.91 23.054 14.428 36.764 3.726 6.796 8.658 13.439 14.82 19.612m39.927-4.327c-37.886-17.634-37.174-48.547-49.762-77.464C408.942 77.337 370.459 37.367 336.36-.2m275.004 145.38c10.926-14.516 19.051-32.222 22.988-52.756 9.534-4.369 17.877-10.464 24.628-17.581 6.334 7.51 14.316 14.094 23.585 19.026 2.55 19.152 8.806 36.11 17.69 50.523M661.111 0c-6.223 34.596-15.096 66.138-50.99 71.52-2.111 36.653-16.567 59.958-38.31 75.358m162.659-1.506c-16.468-16.293-26.507-38.786-26.526-70.919C672.417 66.93 665.354 34.91 661.11 0c0 0 0 0 0 0m358.307.214c-89.106 123.154-107.6 170.487-125.54 227.524M331.33.603c68.226 101.788 100.048 158.581 125.86 224.922m-10.86-26.378c173.564-21.015 316.128-17.023 456.431 1.998m-445.71 24.287c165.82-19.487 302.233-15.744 436.89 2.144m-465.813-67.541c187.254-23.822 340.462-19.284 490.61 1.876M-.064 771.261C113.128 665.908 248.105 577.56 401.37 542.797M1155 609.634l-195.606-71.563M1300 662.683l-55-20.122M924.37 538.304L719.572 636.91l-167.299-75.284m-8.096 29.254L720 670l218.568-105.237M566.03 650.06l154.613 69.575 163.99-78.959m-306.737 47.621l143.174 64.428 140.143-67.477m-214.159 72.159l78.749 48.386 76.56-47.889m-153.298 50.762l81.47 50.196 74.01-47.518m-153.05 59.26l83.773 41.327 71.53-45.383m-6.209-152.11l7.728 189.335M625.965 709.928l-36.854 20.102m57.944 27.377l-45.62 26.06m47.63 25.2l-37.577 23.997m40.006 37.94l-30.533 14.272m181.402-126.972l28.807 8.172m-24.372 100.472l4.647 2.217m-6.9-57.421l14.644 6.01M605.783 960h-6.5m101.434 0h-6.5M460 960V718.46m-19.115 205.814a125 125 0 01-125 125 125 125 0 01-125-125 125 125 0 01125-125 125 125 0 01125 125v0m520.623-385.403c-145.539 154.928-162.504 326.349-153.32 501.125m17.516-.01c-9.399-175.268 7.018-342.083 153.724-494.567M949.775 955.53c-5.886-133.341 18.35-257.056 125.322-375.043M999.086 951.68c-6.644-129.456 16.73-240.175 127.053-352.533M974.32 951.087c-5.83-130.406 18.365-247.04 126.201-361.336M677.5 1000a27.5 27.5 0 01-27.5 27.5 27.5 27.5 0 01-27.5-27.5 27.5 27.5 0 0127.5-27.5 27.5 27.5 0 0127.5 27.5v0m14.555-34.062c16.95-40.09-11.834-60.112-42.055-60.7-30.221.588-59.004 20.61-42.055 60.7-45-34.548-65.376 2.234-65.636 34.062.26 31.828 20.636 68.61 65.636 34.062-16.95 40.09 11.834 60.112 42.055 60.7 30.221-.588 59.004-20.61 42.055-60.7 45 34.548 65.376-2.234 65.636-34.062-.26-31.828-20.636-68.61-65.636-34.062v0M498.674 562.882c41.32 84.043 67.265 185.873 87.853 299.419-30.211-83.707-76.692-146.8-135.994-190.55-57.095-42.12-124.885-65.967-199.253-76.037M196.201 960h-33.547M140 659.363V940m-40-252.22V900m1114.918 154.94A25 25 0 011225 1075v0a25 25 0 01-25 25 25 25 0 01-25-25 25 25 0 0114.28-22.585m-10.206 9.77c-22.951-7.14-74.074-30.022-74.074-92.185 0-65 45-75 55-75 20 0 34.105 26.642 34.105 46.642 0 40-39.105 33.772-39.105 3.358 0-20 10-30 10-30l-30 20m125 100a47.5 20 0 01-47.5 20 47.5 20 0 01-47.5-20 47.5 20 0 0147.5-20 47.5 20 0 0147.5 20v0m-66.15-95.558c5.602-3.558 14.335-6.91 26.15-9.442v0c70-15 59.845 26.263 15 30-21.683 1.807-36.039-.242-43.223-4.09m66.388-2.42c25.295 6.414 10.023 30.032-24.04 31.152-50.433 1.66-60.462-15.413-33.334-25.698m46.744 23.89c31.398 4.088 17.286 31.033-17.147 32.232-56.677 1.973-59.351-22.55-13.184-30.638m-31.246-70.983c3.48-5.51 14.34-11.303 32.413-15.175v0c70-15 59.845 26.263 15 30-20.954 1.746-35.065-.109-42.474-3.709m-33.8 32.761c5 20-12.097 67.678-12.097 67.678m10-151.572V180l45-45 45 45v693.428M1105 860c0-20 40-32.707 40 0 0 7.453-10 7.533-10 0 0-5-9.929-5.124-10 5-.247 35 65-10 75-20 10 10 75.247 55 75 20-.071-10.124-10-10-10-5 0 7.533-10 7.453-10 0 0-32.707 40-20 40 0 0 50-85 27.6-95 15-10 12.6-95 35-95-15v0m95.408-14.376c1.907-27.812 7.833-71.455 7.302-90.895-.682-24.991-10.74-33.899-11.286-53.891-.546-19.993 17.447-51.39 16.765-76.381-.682-24.99-15.3-53.223-15.846-73.216-.546-19.992 9.326-45.271 8.78-65.264-.545-19.992-17.088-55.86-17.634-75.852-.546-19.993 14.55-64.526 14.005-84.519-.546-19.992-11.856-50.106-12.266-65.1-.409-14.994 13.302-62.439 12.892-77.433-.409-14.995-2.673-33.394-3.12-48.073-.037 15.315 1.716 33.768 1.716 48.768s-15 62.053-15 77.053 10.484 45.41 10.484 65.41-16.305 64.106-16.305 84.106 15.558 56.305 15.558 76.305c0 20-10.558 45-10.558 65s13.842 48.62 13.842 73.62c0 25-18.842 55.896-18.842 75.896s9.811 29.179 9.811 54.179c0 23.256-10.174 80.862-10.747 104.861M203.405 977.834c85.59-21.582 147.293-22.233 227.62-5.818m-151.22-167.301c-.507 27.74-.59 55.303-.357 82.688-30.264 3.329-59.224 9.71-87.14 18.529m158.42-101.64c2.057 26.957 3.642 53.992 4.812 81.079 26.316 1.507 53.677 5.313 82.16 11.718m-220.475 103.075c76.072-18.432 129.859-19.103 201.3-5.165M254.643 815.47c-.216 16.81-.266 33.535-.23 50.209a487.217 487.217 0 00-54.477 11.922m228.236-8.057c-16.592-3.257-32.855-5.668-48.802-7.303-.814-15.764-1.727-31.52-2.813-47.256M330 880a15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15 15 15 0 0115 15v0m0-45a15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15 15 15 0 0115 15v0m0 90a15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15 15 15 0 0115 15v0m-50 0a15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15 15 15 0 0115 15v0m-45 10a15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15 15 15 0 0115 15v0m145-10a15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15 15 15 0 0115 15v0m45 5a15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15 15 15 0 0115 15v0M285.242 803.2a30.653 27.5 0 01-.01-.7 30.653 27.5 0 0130.653-27.5 30.653 27.5 0 0130.653 27.5v0a30.653 27.5 0 01-.011.741m-43.191-25.277C300.166 763.716 289.4 725.934 265 730c-23.937 3.99-41.64 59.017-20 70 16.945 8.6 16.09-46.873 35-45 9.353.926 13.58 21.494 14.691 28.027m9.404-5.884l.001.024m21.842-.613c1.508-26.148 5.676-51.77 14.062-76.554l-25-30-25 30c8.45 24.97 12.617 50.79 14.095 77.143m21.842-.573l.001-.016m9.627 5.036c1.424-7.679 5.688-25.724 14.435-26.59 18.91-1.873 18.055 53.6 35 45 21.64-10.983 3.937-66.01-20-70-24.002-4-34.812 32.494-38.175 47.247M177.595 945h-38.54m37.12-15H140m36.207-15H140m38.04-15H140m41.582-15H140m47.125-15H140m54.607-15H140m64.61-15H140m77.781-15H140m93.264-15H140m82.865-15H140m80.217-15H140m81.762-15H140m86.447-15H140m320 195h-5.826M460 930h-4.406M460 915h-4.436M460 900h-6.271M460 885h-9.813M460 870h-15.338M460 855h-22.81M460 840h-32.813M460 825h-46.006M460 810h-63.174M460 795h-52.885M460 780h-50.217M460 765h-51.762M460 750h-56.447M1300 1040h-41.57M1245 830l55-18.333M865.54 536.833c25.59 3.759 49.27-7.043 49.105-33.284-.15-23.912-23.267-33.144-37.899-27.026m9.148 61.488c25.59 3.76 49.271-7.042 49.106-33.284-.146-23.15-21.819-32.54-36.477-27.563m7.371 60.847c25.59 3.76 49.271-7.042 49.106-33.284-.15-23.911-23.267-33.143-37.9-27.026m3.794 60.31c25.59 3.76 49.271-7.042 49.106-33.284-.144-22.841-21.244-32.287-35.886-27.755m6.78 61.04c25.59 3.758 49.271-7.043 49.106-33.285-.15-23.911-23.267-33.143-37.9-27.026m8.794 60.31c25.59 3.76 49.271-7.042 49.106-33.284-.15-23.911-23.267-33.143-37.9-27.026m8.794 60.31c25.59 3.76 49.271-7.042 49.106-33.284-.15-23.911-23.268-33.143-37.9-27.026M754.94 214.828c58.346 120.263 27.11 213.532 28.094 252.465C785 545 895 560 894.644 503.55 894.424 468.549 845 465 845 495c-.589 16.604 31.333 20.568 25 0m-97.02-279.107c58.233 119.78 37.199 213.163 38.181 251.98.82 32.389 23.432 43.344 49.503 41.02m-69.663-291.94c57.746 119.272 39.18 212.217 40.16 250.92.414 16.366 6.392 27.259 15.57 33.732m-35.697-282.988c47.441 81.937 34.363 176.107 41.472 260.645m-22.431-258.908c47.681 79.353 37.62 170.363 49.93 254.646M848.35 222.124c45.916 80.088 39.247 178.28 59.153 252.778M867.13 224.324c44.888 80.252 39.318 181.402 67.872 251.109m-48.93-248.894c44.623 81.12 39.37 189.05 76.43 250.118M897.634 216.5C949.209 300.14 951.802 432.027 990 475m-215.476 86.152c29.688 4.062 64.727-12.602 70.476-24.1M755 215c91.368 218.51-34.006 227.8-30.938 300.888.846 20.14 10.938 29.112 24.223 33.687m31.67-1.194c21.554 5.252 48.56-2.6 66.068-11.3m-55.578-155.408c-9.302 47.96-51.779 73.173-48.878 123.24.654 11.282 7.62 16.12 11.394 23.114m36.736-131.546c-10.502 31.11-33.464 50.384-31.002 92.876 3.1 53.494 45.332 53.94 77.633 45.162M788.25 411.562c-8.796 19.553-20.033 35.141-18.104 68.44 2.595 44.79 31.606 55.443 59.939 52.572M700 505c-4.579 71.226 80 80 80 40 0-30-50-20-30 5m-67-39c0 30 24.833 77.835 51.13 54.58M666 517c0 35 22.575 70.896 49.356 55.678M649 523c0 30 16 62 46.421 53.226M632 529c5 30 13 56 45.453 49.033M615 535c10 30 15 40 39.615 43.97M575 535c-10 23.797-15.385 26.851-40 30m23-34.76c-5 23.798-15.547 35.286-48 29.76m31-34.519c0 23.797-30.579 41.478-61 34.519m27-44.038c0 23.797-28.117 58.868-54.413 40.422M490 511.204c10 55.525-95 58.796-96.084 14.009C392.943 484.997 450 490 450 520c0 23.643-40.818 30.224-40 5 .266-8.218 10-15 20-10m135 40c20 25 50 5 50-20m-91-14.278c0 20.171-20.534 37.882-45.319 38.572M463.466 224.87C451.463 265.442 470 272.05 470 325c0 55-65 45-65 5 0-30 40-25 40 0 0 18.405-30 20-30 5s15-10 15-10m26.513-100.172c-14.602 44.609-6.855 72.643-11.642 107.215m-15.187 78.65s-15-5-15 10 30 13.404 30-5c0-25-44.105-30.411-44.105-.411 0 40 64.421 44.718 65-5 .298-25.664-5.579-30.282 1.157-67.644-16.736 27.362.164 63.41-22.63 77.773M465 405c18.917 89.457 2.83 125.099-30 135m30-265s20-20 40-20 27.543 6.061 32.537 6.305C543.061 261.575 550 255 555 250v10s-12.053 4.663-17.053 4.663-26.044-5.808-34.179-6.305c-3.973-.243-32.224 8.037-38.768 16.642m275 10s-32.906-33.284-52.906-33.284-49.3 8.524-54.294 8.768c-5.524.27-17.8-.484-22.8-10.484v10s17.39 3.842 22.39 3.842 50.165-9.234 55.935-8.768C704.21 256.356 733.456 276.394 740 285m-185-25s15 15 15 20c0 20-11.716 30.41-11.716 50.41 0 20-13.284 59.59-12.873 68.285C545.646 403.689 560 410 565 410c5 0 5 20 5 20m35-55c25 5 28.974 36.325 10 30-45-15-45 10-12.537-2.463M530 460v10l5-5-5-5v0m115 0v10l-5-5 5-5v0m-110 5c10 0 15-10 25-10s15 5 20 5 16.568-7.126 21.568-7.126S625 465 640 465m-75 20c5.861 12.36 30 15 35 0M470 310c10-5 20-10 35.747-9.179C521.537 301.644 535 325 550 325c-25 0-30 10-45 10s-25-5-35-10m150-10s20-20 35-20 50 20 60 20c-22.347-.05-44.764 15-60 15-20 0-35-15-35-15M495 430c5.82 1.44 15-12.658 0-12.446-22.653.321-14.297 33.469 9.464 33.432C519.068 450.963 535 432.1 550 430v-10c-30 10-25 25-45 30m185-15c-12.38-5-19.673-21.471 2.428-23.217C715 410 710 450 667.297 450.986 645.72 451.484 632.317 430 600 430v-10c52.098 5 36.947 25 66.505 30m91.342 550A107.847 96.548 0 01650 1096.548 107.847 96.548 0 01542.153 1000 107.847 96.548 0 01650 903.452 107.847 96.548 0 01757.847 1000v0M533.15 565.48c44.801 97.376 70.461 213.439 91.431 340.761m96.49-153.516l17.113 191.896M645.54 718.736l7.248 184.842M551.963 960h-116.35m370.649 0H748.01m-.003-.005l59.21-37.006M201.986 621.105c182.606 10.658 322.19 96.312 373.563 309.079M754.227 975h51.22M492.5 975h52.346"
        />
      </symbol>
      <symbol id="KC_svg__g" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={3}
          fill="none"
          d="M1205 585.225v-84.221m0 163.06v-78.84m0 150.844v-72.004m0-187.335V140m30 728.537V170m-10 692.945V160m-10 696.566V150m-10 699.232v-52.507m-10-566.69v-11.123m0 66.799v-55.676m0 140.15v-27.113m0 96.994v-69.88m5.558 533.92c3.887 4.86 4.604 9.571 2.486 23.823M1205 935c3.887 4.861 6.708 14.032 2.537 24.384m-4.127-1.198c3.887 4.861 4.655 15.264.895 23.768m-4.458 7.874c3.887 4.861 3.629 14.443.074 22.537M1240 907.258c1.276 3.844 1.458 7.25 0 10m.616 21.96c1.276 3.844 1.458 7.25 0 10m-2.464 18.285c1.277 3.843 1.458 7.25 0 10m-1.51 16.676c1.276 3.844 1.458 7.25 0 10m-42.793-64.737C1177.135 940 1180 970 1180 970M480 305c5-10 19.189-20 35-20 15 0 30 20 30 20m85 2.11s15.591-23.506 32.587-23.702c16.87-.194 30.733 9.623 34.403 15.199M620 315c5 15 14.81 31.867 40 30m-190-20c-3.264 17.638 35 25 35 25m13.9-44.175c.71 2.408 1.1 5.027 1.1 7.767 0 11.823-7.264 21.408-16.225 21.408-8.961 0-16.226-9.585-16.226-21.408 0-4.157.899-8.038 2.453-11.322m178.257-4.629c1.512 3.253 2.384 7.08 2.384 11.175 0 11.823-7.265 21.408-16.226 21.408-8.96 0-16.225-9.585-16.225-21.408 0-3.679.704-7.141 1.943-10.166M560 515c15-10 35-5 40 0"
        />
        <use
          xlinkHref="#KC_svg__a"
          height={90}
          transform="matrix(.9962 .06911 -.08716 .78998 852.093 820.34)"
        />
        <use
          xlinkHref="#KC_svg__a"
          height={90}
          transform="scale(1 .793) rotate(15 -2796.146 3826.83)"
        />
        <use
          xlinkHref="#KC_svg__a"
          height={90}
          transform="scale(1 .793) rotate(25 -1089.3 2537.261)"
        />
      </symbol>
      <rect
        width={211}
        height={328}
        x={-105.5}
        y={-164}
        rx={12}
        ry={12}
        fill="#fff"
        stroke="#000"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KC_svg__b" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KC_svg__b"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KC_svg__c" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KC_svg__c"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KC_svg__d" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KC_svg__d"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KC_svg__e" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KC_svg__e"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KC_svg__f" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KC_svg__f"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KC_svg__g" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KC_svg__g"
      />
      <use xlinkHref="#KC_svg__h" height={50} x={-104} y={-152.5} />
      <use xlinkHref="#KC_svg__a" height={41.827} x={-99.913} y={-97.5} />
      <use xlinkHref="#KC_svg__a" height={38.6} x={-60.295} y={-109.3} />
      <g transform="rotate(180)">
        <use xlinkHref="#KC_svg__h" height={50} x={-104} y={-152.5} />
        <use xlinkHref="#KC_svg__a" height={41.827} x={-99.913} y={-97.5} />
        <use xlinkHref="#KC_svg__a" height={38.6} x={-60.295} y={-109.3} />
      </g>
      <use xlinkHref="#KC_svg__i" stroke="#44F" fill="none" />
    </svg>
  );
}

export default SvgKc;
