import * as React from "react";

function SvgJc(props) {
  return (
    <svg
      className="JC_svg__card"
      preserveAspectRatio="none"
      viewBox="-106 -164.5 212 329"
      {...props}
    >
      <defs>
        <path id="JC_svg__i" d="M-58-112.5H58v225H-58z" />
      </defs>
      <symbol
        id="JC_svg__h"
        viewBox="-500 -500 1000 1000"
        preserveAspectRatio="xMinYMid"
      >
        <path
          d="M50-460h200m-100 0v710a100 100 0 01-400 0v-30"
          stroke="#000"
          strokeWidth={80}
          strokeLinecap="square"
          strokeMiterlimit={1.5}
          fill="none"
        />
      </symbol>
      <symbol
        id="JC_svg__a"
        viewBox="-600 -600 1200 1200"
        preserveAspectRatio="xMinYMid"
      >
        <path d="M30 150c5 235 55 250 100 350h-260c45-100 95-115 100-350a10 10 0 00-20 0 210 210 0 11-74-201 10 10 0 0014-14 230 230 0 11220 0 10 10 0 0014 14 210 210 0 11-74 201 10 10 0 00-20 0z" />
      </symbol>
      <symbol id="JC_svg__b" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#FC4"
          d="M0 2.5V1660l110-110-.018-126.234c105.297-87.529 180.256-182.164 233.801-282.25a1003.565 1003.565 0 01-5.742 10.634c139.339-34.523 228.763-151.939 326.875-251.218 98.724-99.9 202.374-184.192 377.621-174.983 7.526-8.934 14.813-17.827 21.885-26.592-4.277-.38-8.507-.689-12.711-.964 1.155.06 2.313.123 3.467.181l-.381-234.674a327.883 327.883 0 00-19.758-8.468l.096 242.091 2.074.11c-159.046-6.045-265.296 63.26-356.08 148.363 22.003-20.657 44.856-40.363 69.137-58.226l-.137-180.627c-13.882 7.38-27.814 14.801-41.71 22.193-.637 3.926-2.025 7.877-3.419 10.664 5 10 10.599 34.355-20 20 15 30-10 25-20 20-9.483 4.741-32.455 9.483-22.013-15.623l29.81-16.09C643.527 663.861 614.288 679.411 585 695l-5.035-2.8.258 256.519c-29.078 30.451-58.047 60.053-88.42 86.33 11.695-10.162 23.153-20.85 34.416-31.988-30.274-24.219-62.124-47.483-101.276-67.924a1292.062 1292.062 0 01-22.597 73.062l67.293 44.893.183.16c-34.985 27.602-72.212 50.297-113.845 64.63 95.578-192 116.2-403.262 123.261-622.42-17.428-7.746-13.268-13.827-27.006-26.034.041-.67.072-1.285.118-1.985C431.014 428.206 390 348.455 390 325v-70c0-10-5-30-5-40s10-80 10-80l-10 5c-21.326 60.667-18.827 125.689-24.732 189.611C360 305 310 301.73 310 345c0 37.916 49.696 36.786 71.482 5.906-8.809 15.273-2.758 42.101 1.586 64.871-2.995 47.504-28.271 44.57-38.068 44.223-6.795-.24-10.502-3.35-11.604-7.604C337.372 463.072 362.42 459.76 365 435c3.774-36.204-60-20-55 25 1.226 11.03 7.257 19.357 15.37 24.953 0 0 34.63 25.047 69.63 15.047 5.769-1.648 10.586-4.383 14.627-7.611 15.899-2.121 31.18-4.404 41.86-5.875-10.318 337.82-49.099 647.023-341.487 900.685l-.021 15.73-.12-838.238c-4.802-9.884-4.812-24.568-.006-44.078v-.54C97.595 526.438 97.524 513.806 95 505c0 0-8.695 11.232-18.695 26.232-1.838 2.757-4.228 4.45-6.809 5.268l1.877.395c6.157 2.24 9.932 5.262 9.932 8.59 0 6.903-16.254 12.5-36.305 12.5-20.05 0-36.305-5.597-36.305-12.5 0-6.904 16.254-12.5 36.305-12.5 3.53 0 6.943.172 10.17.495l1.066.225C50.314 529.013 47.518 519.976 55 510c15-20 16.464-26.464 20-30 4.147-4.147 18.62-4.842 34.848-2.11L109.803 160H140zm284.047 43.188C216.752 54.569 232.09 147.181 175 190c93.311 27.993 143.087-35.436 161.516-80.607zM640 125c63.111 116.225 35 199.881 35 305 0 39.694 23.81 56.979 46.227 54.82 43.936-3.505 110.424-43.307 166.375-66.15C905 414.024 920 397.306 920 370c0-10-5-40-39.271-35.008C885.775 268.892 906.967 202.614 865 125zm249.127 293.31l-4.094 2.038.08 296.918a581.442 581.442 0 0120.032-5.891l-.413-290.592a4569.01 4569.01 0 01-15.605-2.472zM340 435c-2.607 2.94-4.409 5.635-5.553 8.07 1.17-2.777 3.047-5.564 5.553-8.07zm-69.898 67.754c-27.606.245-50.727 14.121-75.102 22.246-5.603-.617-10.988-1.7-20 5-1.704 40.187-7.5 76.003-15 110 .007 9.98 6.643 13.344 20 10 25.063 17.576 57.075 51.196 86.773 69.31 4.988-20.198-2.484-46.613-21.773-74.31 12.993 4.354 31.508-2.847 50-10-10.938-17.69-23.686-30.315-44.385-37.537C273.77 597.43 289.967 588.449 300 575c-10.786-14.059-23.418-26.339-45-30 18.668-6.676 33.492-17.007 35-40-6.919-1.633-13.528-2.303-19.898-2.246zM39.142 560A35.858 12.5 0 0175 572.5 35.858 12.5 0 0139.143 585a35.858 12.5 0 01-35.86-12.5 35.858 12.5 0 0135.86-12.5zm-1.884 27.5A32.742 12.5 0 0170 600a32.742 12.5 0 01-32.742 12.5A32.742 12.5 0 014.516 600a32.742 12.5 0 0132.742-12.5zm2.742 25A35 12.5 0 0175 625a35 12.5 0 01-35 12.5A35 12.5 0 015 625a35 12.5 0 0135-12.5zm610.322 108.72c5.069.03 10.928 1.905 14.678 3.78 10-5 35-10 20 20 30-15 25 10 20 20 5 10 10.599 34.355-20 20 15 30-10 25-20 20-10 5-35 10-20-20-30 15-25-10-20-20-5-10-10-35 20-20-9.375-18.75-3.125-23.828 5.322-23.78zm0 125c5.069.03 10.928 1.905 14.678 3.78 3.933-1.966 10.187-3.932 15.414-3.77l-14.746 14.53c.951-.927 1.915-1.84 2.87-2.764a1360.92 1360.92 0 00-14.49 14.22c.147-.145.29-.291.436-.437l-33.261 32.772c.06-5.04 1.918-10.832 3.777-14.551-5-10-10-35 20-20-9.375-18.75-3.125-23.828 5.322-23.78z"
        />
      </symbol>
      <symbol id="JC_svg__c" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="red"
          d="M246.47 0L370 150c180.66-37.466 351.908-15.7 520 10L1023.334 0H246.471zm638.317 420.898L570 580l-91.814-52.258c-.875 19.933-1.787 39.647-2.655 58.81L580 645l305.053-159.79-.053-.81-.213-63.502zm190.268 52.946l.265 213.345c33.76-38.277 71.636-75.149 114.618-110.734l.09-16.514c-34.801-32.653-68.885-62.03-114.973-86.097zm-754.409 25.67l-31.623 9.654-4.378 13.883 38.001-11.602-2-11.935zm3.471 35.115l-54.023 3.178-10.244 7.115 10.877 4.869 54.576-3.209-1.186-11.953zm560.87.486l-114.758 61.469-.315 177.201c34.85-23.34 72.832-43.004 115.188-56.514l-.116-182.156zm-587.778 36.512c-.59 2.677-2.48 10.377-3.662 11.793l31.78 1.986.007-12.021-28.125-1.758zm-3.662 11.793l-.639-.04c.168.376.388.34.639.04zm-35.928 11.47c-6.031.091 10.896 11.592 14.592 14.352l52.041 6.123.475-12.027-61.166-7.195c-2.922-.894-4.825-1.27-5.942-1.252zm33.008 33.079c12.431 3.658-11.979 11.314-6.178 11.207l36.916 5.545 1.469-11.914-32.207-4.838zm181.434 8.52c-5.895 81.122-15.634 160.539-32.645 237.536 45.21 18.345 84.338 42.848 120.355 70.485l.012-262.834-87.722-45.188zM160 640c-16.58 5.56-33.037 6.415-49.69 2.5l-.154 344.1c88.828-105.753 107.279-197.597 126.27-289.582C216.343 680.41 196.64 661.669 180 650c-13.357 3.344-19.993-.02-20-10zm524.895 2.074l-29.963 15.211A19.91 19.91 0 00665 660c10.345 0 18.857-7.855 19.895-17.926zm-437.264 5.832l6.865 13.522 63.545 12.095.897-12.043-71.307-13.574zm14.978 30.313l3.56 13.258 47.112 10.033 2.356-10.035-53.028-13.256zM665 745a20 20 0 00-20 20 20 20 0 0020 20 20 20 0 0020-20 20 20 0 00-20-20z"
        />
      </symbol>
      <symbol id="JC_svg__d" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#44F"
          d="M599.754 695H730.09l-.205 15h-129.72zm0 130h103.858l-15.188 15h-87.85zm305.34-350.896l-.1 41.316 8.055 12.08-8.111 12.168-.1 41.611L940.69 527.5zm129.521-4.565l-38.64 57.961L1035 586.037l-.137-41.668-11.246-16.869 11.135-16.701zm-107.162-44.822l40.881 61.32 29.14-43.71-23.673-5.954-5.467 8.201-7.668-11.506zm40.881 144.246L929.309 627.5l39.025 58.537 19.512-29.267 19.511-29.27-19.511-29.27zm0 41.463l.375.562 11.006 16.512-11.006 16.512-.375.562-11.383-17.074zm-63.348 100.991c6.917-1.744 13.964-3.413 21.508-4.781l-21.22-31.594zm111.296-14.15L1035 668.942l.136 28.572c-6.24-.106-12.53-.21-18.854-.249zm-660.34 420.553c17.996-36.037 33.178-72.46 46.355-109.484l67.413 44.867c-34.97 27.774-72.265 50.526-113.768 64.617zm642.893-335.531c-12.064.256-24.522.617-35.75 2.09l-6.263.822 5.176 36.404 5.926-.548c2.12-.196 4.246-.385 6.381-.564l7.838-13.064c-3.163.24-6.295.505-9.425.77l-1.71-12.023a349.042 349.042 0 0119.417-1.62l25.792-38.154-6.244.032c-35.369.172-67.446 4.464-97.202 11.935l-6.443 1.617 15.004 47.362c-22.248 6.063-42.873 14.283-62.326 24.421l-6.485-10.062c10.007-5.255 20.197-10.13 30.735-14.184l6.453-2.482-16.92-33.457-5.346 2.197c-29.992 12.327-57.417 28.353-83.214 47.127L779 834.713l30.283 38.77c-19.26 14.384-37.967 30.71-56.785 48.675l-8.586-9.092c9.248-8.732 18.515-17.2 27.775-25.191l4.79-4.133-24.512-27.72-4.666 3.933c-23.766 20.027-46.627 42.187-69.653 65.48l-6.052 5.276 36.04 35.894c-19.626 19.929-39.407 41.357-60.193 63.215l-9.138-8.662a1267.085 1267.085 0 0015.857-16.63l4.268-4.567-9.135-8.533-4.266 4.566c-6.535 6.996-13.086 13.999-20.011 20.99l-4.496 4.54 27.386 25.958 4.301-4.496c24.08-25.18 46.478-49.853 68.615-72.064l4.412-4.428-35.529-35.387c20.305-20.457 40.44-39.89 61.05-57.586l8.036 9.088c-9.373 8.222-18.736 16.746-28.057 25.664l-4.486 4.293 25.793 27.317 4.547-4.399c21.802-21.086 43.16-39.847 65.183-55.798l5.25-3.803-30.105-38.541c21.998-15.54 45.136-28.915 70.021-39.631l5.495 10.865c-10.954 4.536-21.63 9.585-31.916 15.238l-5.875 3.229 20.05 31.103 5.096-2.771c21.955-11.94 45.27-21.298 70.961-27.719l6.451-1.611-14.88-46.979c25.176-5.852 52.103-9.35 81.472-9.92l.029 5.028M-10 1670l120-120M340 490c3.26 72.689.133 146.002-10 220l-63.003-16.796c1.771 9.448 1.717 18.248-.224 26.106-10.167-6.202-20.606-14.22-30.632-22.529-18.707 92.222-37.156 184.066-125.984 289.529l.005 225.473C248.84 1085.098 364.64 805.808 350.936 497.821M428.258 260a10 20 0 01-10 20 10 20 0 01-10-20 10 20 0 0110-20 10 20 0 0110 20zm140.871 2.032a10 20 0 01-10 20 10 20 0 01-10-20 10 20 0 0110-20 10 20 0 0110 20z"
        />
      </symbol>
      <symbol id="JC_svg__e" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path d="M585 695l-112.856-59.18c.731-9.553 1.333-18.454 1.722-27.602L580 670l305.039-160.324-.053 25.051zM439.549 873.41c-2.2 11.53-4.911 23.275-7.842 34.768 43.85 19.867 81.12 46.098 116.906 73.456 10.374-10.762 21.013-21.808 31.527-32.625l-.117-256.779-20.258-10.25.006 262.53c-36.017-27.637-75.146-52.14-120.222-71.1zm310.716-85.641l-.604-180.377 20.091-10.554.412 176.78c-6.544 4.53-13.14 9.181-19.899 14.151zm324.92-313.856c-6.31-3.433-13.043-6.743-20.117-9.89l-.189 234.526c2.932.357 6.003.605 9.371 1.009 3.682-3.877 7.134-7.871 10.693-11.942zM330 710c10.133-73.998 13.26-147.311 10-220l-18.949 7.817a492.988 492.988 0 011.597 13.631c6.125 64.647.077 137.84-10.633 193.87zM110.427 966h16.215l9.031-12h-25.04zm-.205-30h38.588l6.19-12h-45.6zm.082-60h72.578l4.926-12h-78.085zm.123 30h56.65l6.158-12h-63.013zm-.123-60h85.714l4.516-12h-90.23zm.58-30H195a6 6 0 100-12h-84.696zm-.87-33H175c4.057.057 4.057-6.057 0-6h-64.986zm0-30H155c4.057.057 4.057-6.057 0-6h-45.567zm145.617-40.064l-1.3 6.197c-17.76 84.66-40.19 174.694-120.991 274.336L132 995.12v163.473l10.682-13.32c76.408-95.293 141.945-241.846 171.152-411.163l.934-5.404zm9.094 14.845L301 737.455c-27.925 157.173-87.591 294.068-157 386.414V999.31c79.262-98.45 103.144-188.696 120.725-271.528zm489.61-174.92l-25.054-53.687-59.849 30.324 25.747 55.171M712.5 530c6.904 0 12.5 5.596 12.5 12.5s-5.596 12.5-12.5 12.5-12.5-5.596-12.5-12.5 5.596-12.5 12.5-12.5zm57.568-51.64l25.16 53.914 59.387-31.313-24.425-52.34zm42.432-.86c6.904 0 12.5 5.596 12.5 12.5s-5.596 12.5-12.5 12.5S800 496.904 800 490s5.596-12.5 12.5-12.5zm-231.775 97.267l26.03 55.778 59.722-30.594-26.014-55.744zM622.5 572.5c6.904 0 12.5 5.596 12.5 12.5s-5.596 12.5-12.5 12.5S610 591.904 610 585s5.596-12.5 12.5-12.5zm-111.572-25.996l-25.942 45.227 58.425 32.917 25.905-45.162zm26.793 31.3c3.974 5.646 2.62 13.443-3.025 17.417-5.646 3.974-13.443 2.62-17.417-3.025-3.974-5.646-2.62-13.443 3.025-17.417 5.646-3.974 13.443-2.62 17.417 3.025zM906.793 139.3l-13.316-2.036c-105.3-16.1-212.93-30.902-324.065-30.362-66.68.325-134.623 6.172-204.082 20.577l-12.118 2.404L370 150c180.66-37.466 351.908-15.7 520 10l16.937-20.325L1040-20" />
      </symbol>
      <symbol id="JC_svg__f" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={6}
          fill="none"
          d="M921.558 121.325l-25.06-3.83c-105.512-16.133-214.303-31.176-327.25-30.61-67.768.34-137.033 6.298-207.98 21.011l-22.184 4.6M425 415c5 25 5 75-30 85s-70-15-70-15m-215-6.552V160M0 1660l110-110V565.476m-.048 858.315c314.127-261.101 358.266-584.624 369.286-928.327M355.727 1118.1c243.05-83.732 335.925-451.871 708.246-418.671m-726.175 453.229c139.583-35.032 229.006-152.448 327.118-251.727 98.724-99.9 202.375-184.191 377.154-174.997M452.012 469.223C442.44 813.792 407.376 1129.21 110 1387.2m965-913.267v213.594m-20-223.447v234.333m-20-242.953v241.937M905 420.772V711.33m-20-293.637V717.28m3.351-299.037c165.336 24.8 232.033 75.753 301.702 142.32m-778.944 424.69c28.189 14.13 52.952 32.588 77.587 51.208m-63.621-101.327c39.019 20.445 70.87 43.71 100.957 67.668m-94.368-94.825c43.893 20.068 81.163 46.299 117.275 73.607M439.2 873.673c45.426 18.698 84.555 43.2 120.343 70.782M475.757 586.08L580 645l305.052-159.79M473.693 607.989L580 670l305.077-159.802m-413.016 126.29L585 695l299.973-159.663M560 682.157v262.408m20-252.538v257.327m20-262.407v240.492m130-309.623v185.676m20-196.247v180.717m20-191.082v176.714M478.285 527.592L570 580l319.196-161.726M685 765a20 20 0 00-20-20 20 20 0 00-20 20 20 20 0 0020 20 20 20 0 0020-20v0m-40-20c-15-30 10-25 20-20 10-5 35-10 20 20 30-15 25 10 20 20 5 10 10.599 34.355-20 20 15 30-10 25-20 20-10 5-35 10-20-20-30 15-25-10-20-20-5-10-10-35 20-20v0m-23.778 159.55c.06-5.038 1.919-10.831 3.778-14.55-5-10-10-35 20-20-15-30 10-25 20-20 3.933-1.966 10.186-3.933 15.413-3.77m-25.48-188.945A19.908 19.908 0 00665 660c10.345 0 18.856-7.855 19.894-17.926m23.576-13.042c-.612 4.025-2.04 8.11-3.47 10.968 5 10 10.599 34.355-20 20 15 30-10 25-20 20-9.483 4.741-32.455 9.483-22.013-15.623M402.493 1008.33l67.145 44.763m435.725-620.048l129.764 194.647m.234-.732l-47.642 71.463m-81.9-64.693l45.682 68.523m68.494-252.244L905.982 621.026m-.432 53.763l21.318 31.977m89.298-9.553l18.834-28.25m-596.075 331.712l12.606-23.725c12.106-20.216 39.572-3.424 28.547 17.13l-14.46 24.478m14.46-24.477c12.105-20.216 37.365-2.357 26.34 18.198l-12.107 20.494m-83.202-47.52l14.082-26.501c12.105-20.216 37.365-2.357 26.34 18.198M70 487.069V200H0m70 366.092v-11.905m0 64.245v-40.025M0 1600l70-70V631.363M0 160h140L0 2.5M0 130h80L0 50m315 845a7.5 7.5 0 01-7.5 7.5 7.5 7.5 0 01-7.5-7.5 7.5 7.5 0 017.5-7.5 7.5 7.5 0 017.5 7.5v0m0 0c30-40 80 5 90-10m-90 15c9.92 49.006 72.409 27.16 75 45m-72.033-48.796C350.854 878.304 400 925 405 885m-15 60c5-30-66.33-20.364-72.418-46.242C342.272 923.29 385 930 395 920m0 0c4.031-20.98-63.4-33.217-80-20m17.448-74.874a7.46 7.5 0 01-7.022 7.916 7.46 7.5 0 01-7.874-7.06 7.46 7.5 0 017.022-7.915 7.46 7.5 0 017.874 7.059v0m0 0c27.52-41.649 79.731.42 88.81-15.126m-88.526 20.118c12.637 48.359 73.452 22.978 77.04 40.641m-74.309-44.601c31.642-19.749 83.102 24.062 85.794-16.158m-11.486 60.759c3.26-30.237-67.029-16.541-74.545-42.029 25.913 23.082 68.727 27.34 78.09 16.784m0 0c2.81-21.176-64.85-29.54-80.584-15.396m14.37-81.813a7.124 7.5 0 01-6.53 8.077 7.124 7.5 0 01-7.673-6.874 7.124 7.5 0 016.53-8.078 7.124 7.5 0 017.672 6.875v0m0 0c25.359-42.278 76.13-1.433 84.456-17.187m-84.075 22.17c13.127 48.053 70.631 21.265 74.444 38.84m-71.923-42.862c29.775-20.479 79.868 22.124 81.554-18.148m-9.631 61.01c2.448-30.304-64.358-14.978-72.093-40.284 25.246 22.472 66.216 25.733 74.922 14.964m0 0c2.219-21.237-62.563-28.025-77.273-13.52m11.128-73.528a6.852 7.5 0 01-5.623 8.638 6.852 7.5 0 01-7.892-6.156 6.852 7.5 0 015.623-8.638 6.852 7.5 0 017.892 6.156v0m0 0c20.982-44.415 72.84-8.312 79.582-24.76m-78.826 29.69c16.35 46.688 69.352 14.8 74.385 31.965m-72.285-36.2c26.925-23.096 78.27 14.82 76.726-25.455m-4.441 61.655c-.032-30.414-62.847-9.104-72.245-33.617 25.955 20.107 65.47 19.652 72.969 8.134m0 0c.46-21.358-62.15-22.264-75.109-6.481m7.302-82.28a6.762 7.5 0 01-5.549 8.638 6.762 7.5 0 01-7.787-6.155 6.762 7.5 0 015.549-8.638 6.762 7.5 0 017.787 6.155v0m0 0c20.705-44.414 71.877-8.31 78.53-24.76m-77.783 29.691c16.133 46.688 68.434 14.8 73.4 31.965m-71.329-36.2c26.57-23.096 77.236 14.82 75.712-25.455m-4.383 61.655c-.031-30.414-62.016-9.104-71.29-33.617 25.613 20.107 64.606 19.652 72.005 8.134m0 0c.453-21.358-61.329-22.264-74.115-6.482m-.617-70.649a6.924 7.5 0 01-5.482 8.79 6.924 7.5 0 01-8.114-5.939 6.924 7.5 0 015.482-8.788 6.924 7.5 0 018.114 5.937v0m0 0c20.172-44.972 73.387-10.296 79.818-26.923m-78.94 31.832c17.59 46.228 70.394 12.902 75.873 29.925m-73.85-34.216c26.666-23.823 79.404 12.68 76.917-27.541m-3.067 61.757c-.732-30.403-63.693-7.386-73.751-31.635 26.682 19.393 66.587 17.859 73.896 6.14m0 0c-.028-21.363-63.293-20.56-76.019-4.43m-75.003 422.41a7.73 8.033 0 01-8.614 6.994 7.73 8.033 0 01-6.73-8.952 7.73 8.033 0 018.614-6.994 7.73 8.033 0 016.73 8.953v0m0 0c35.715-38.606 81.208 15.761 93.322 1.12m-93.95 4.195c3.99 53.393 70.658 38.328 71.067 57.632m-67.555-61.28c35.89-14.734 80.297 41.324 90.438-.546m-22.883 61.826c8.884-31.24-65.294-30.31-68.27-58.615 22.174 29.303 65.04 42.016 76.526 32.69m0 0c6.76-21.777-60.682-43.59-79.323-31.707m-29.438 64.735a7.673 8.013 0 01-8.611 6.894 7.673 8.013 0 01-6.601-8.993 7.673 8.013 0 018.611-6.895 7.673 8.013 0 016.601 8.994v0m0 0c35.786-38.17 80.466 16.492 92.617 2.003m-93.287 3.293c3.494 53.295 69.797 38.9 70.035 58.16m-66.517-61.766c35.752-14.356 79.338 41.981 89.77.313m-23.253 61.452c9.09-31.076-64.543-30.852-67.25-59.113 21.753 29.439 64.189 42.526 75.67 33.333m0 0c6.9-21.658-59.849-44.056-78.455-32.38m-36.445 62.888a7.898 8.152 0 01-9.768 5.591 7.898 8.152 0 01-5.417-10.083 7.898 8.152 0 019.768-5.59 7.898 8.152 0 015.417 10.082v0m0 0c41.975-32.814 79.54 29.179 94.014 16.5m-95.464-11.276c-4.174 54.178 65.425 50.061 62.873 69.478m-58.768-72.556c38.486-8.856 74.693 54.653 91.36 14.353m-32.592 58.203c13.765-29.85-61.244-41.14-59.899-70.002 17.878 33.026 59.188 52.832 72.213 45.377m0 0c10.168-20.716-54.549-53.693-75.187-44.853m-46.547 63.697a8.084 8.122 0 01-10.525 4.484 8.084 8.122 0 01-4.463-10.574 8.084 8.122 0 0110.525-4.484 8.084 8.122 0 014.463 10.574v0m0 0c46.14-27.976 77.917 37.499 93.971 26.5m-95.991-21.48c-9.891 53.224 61.377 56.662 56.757 75.624m-52.258-78.231c40.094-4.618 70.332 62.213 91.492 24.087m-39.234 54.144c17.119-28.087-58.05-47.373-53.675-75.823 14.756 34.651 54.74 58.735 68.773 52.756m0 0c12.507-19.426-49.928-59.087-71.855-52.558m-49.471 52.58a8.414 8.715 0 01-11.224 4.093 8.414 8.715 0 01-3.953-11.625 8.414 8.715 0 0111.225-4.093 8.414 8.715 0 013.952 11.625v0m0 0c49.745-26.853 78.519 45.406 95.909 34.71m-98.333-29.471c-13.72 56.334 60.095 64.816 54.068 84.812m-49.225-87.3c41.951-2.245 69.039 71.363 93.49 31.958m-44.265 55.342c19.603-28.926-57.24-54.644-50.853-84.816 13.087 38.102 53.066 66.587 68.032 61.13m0 0c14.25-19.962-48.045-66.642-71.247-61.126m-13.256-21.474c138.54-127.437 254.35-406.803 240.607-714.842M128.5 1363.393c8.2-9.592-2.313-28.257-18.5-43.393m0 40c7.738 5.04 13.61 4.707 18.5 3.393M110 1385c5.306-6.524 4.355-12.857 1.003-19.872M110 1320c17.69 18.562 31.778 36.964 48.47 14.665m-47.766-38.872c22.17 15.197 35.716 44.345 47.537 38.425m-47.928-347.382c88.672-105.989 107.121-197.833 126.14-289.792M15 200c0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70m2.257 294.906C22.49 653.366 35 670.807 35 690c0 24.267-20 45.733-20 70m1.199-150.676a54.338 54.338 0 00-.988 6.295M15 340c0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 18.667 11.834 35.676 17.296 53.577M15 760c0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 17.992-10.994 34.445-16.68 51.64M30 200c0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70m3.147 297.832C38.78 655.219 50 671.824 50 690c0 24.267-20 45.733-20 70m0-420c0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 18.21 11.261 34.842 16.883 52.264M30 760c0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 8.743-2.596 17.123-5.918 25.4M45 200c0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70m2.774 296.652C53.267 654.469 65 671.413 65 690c0 24.267-20 45.733-20 70m0-420c0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 11.029 4.13 21.479 8.638 31.876M45 760c0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 24.267-20 45.733-20 70 0 24.267 20 45.733 20 70 0 1.502-.077 2.993-.22 4.475M0 115h64.04M0 100h48.85M0 85h35.304M0 70h20.525M140 580c-29.95-.016-40.027-19.94-30-60-12.409 6.549-12.465-6.157-15-15 0 0-8.695 11.232-18.695 26.232S40 530 55 510s16.464-26.464 20-30c5-5 25-5 45 0s55 50 55 50c-1.704 40.187-7.5 76.003-15 110-16.58 5.56-33.036 6.416-49.377 2.902m-39.25-106.008c6.157 2.24 9.932 5.263 9.932 8.59 0 6.904-16.254 12.5-36.305 12.5-20.05 0-36.305-5.596-36.305-12.5 0-6.903 16.254-12.5 36.305-12.5 3.53 0 6.943.174 10.17.497M75 572.5A35.858 12.5 0 0139.142 585a35.858 12.5 0 01-35.858-12.5A35.858 12.5 0 0139.142 560 35.858 12.5 0 0175 572.5v0M70 600a32.742 12.5 0 01-32.742 12.5A32.742 12.5 0 014.516 600a32.742 12.5 0 0132.742-12.5A32.742 12.5 0 0170 600v0m5 25a35 12.5 0 01-35 12.5A35 12.5 0 015 625a35 12.5 0 0135-12.5A35 12.5 0 0175 625v0m100-95c9.012-6.7 14.397-5.617 20-5 6.602 53.925-5.186 88.42-15 125-13.357 3.344-19.993-.02-20-10m35-115c30-10 58.099-28.711 95-20-.465 7.087-2.195 12.971-4.912 17.916-6.1 11.098-17.174 17.466-30.088 22.084 21.582 3.661 34.214 15.941 45 30-10.033 13.45-26.23 22.431-49.384 22.463C271.315 604.685 284.062 617.311 295 635c-18.492 7.153-37.007 14.354-50 10 19.29 27.697 26.76 54.112 21.773 74.31-29.698-18.115-61.71-51.734-86.773-69.31m88.59-147.135c-19.968 23.702-42.548 42.82-71.626 50.534l.314 2.013c27.15 1.82 53.022 6.851 72.722 18.898-24.548 10.717-49.297 15.727-74.99 12.402l-.156 2.754C218.16 598.765 244.968 602.452 260 625c-27.967 3.853-49.066-2.197-70.957-7.73l-1.28 4.911c23.946 23.099 43.122 50.723 57.776 82.638M409.668 492.69c15.885-2.427 31.2-4.717 41.922-6.162M340.523 503.13c2.789-.3 10.017-1.361 19.684-2.831m-71.397 11.03l47.735-19.89 3.637 2.779C343.136 565.525 339.937 637.433 330 710l-62.98-16.795m54.034-195.467c.59 4.567 1.12 9.137 1.594 13.71 6.125 64.647.077 137.84-10.709 193.962m331.864-573.234C701.96 244.697 675 327.057 675 430c0 75 85 70 85 5 0-50-60-45.311-60-5 0 30 45 30 45 10 0-10-5-15-10-20m-65.66-286.734C726.4 245.602 693.068 334.167 700 430m-4.81-294.927c48.26 98.566 16.053 183.258 20.658 266.387m5.503-263.866c45.155 96.517 4.145 179.666 15.029 261.376m11.355-258.233c41.295 93.23-4.038 170.597 9.713 252.602m16.505-249.799c37.353 87.708-1.183 161.464 6.958 238.512m19.498-235.006c33.11 81.81 1.072 151.58 4.616 223.483m22.071-219.178c28.606 75.47 2.72 140.802 2.65 207.296m23.588-203.944c24.95 69.449 4.407 130.388 1.698 191.728m24.67-187.792c21.365 63.523 5.329 120.003 1.027 176.354m-143.53 144.64C760.058 482.814 785 465.21 785 430c0-35.78-30.724-43.554-48.2-30.312m24.594 75.296C783.006 475.603 805 458.064 805 425c0-35.174-29.693-43.284-47.303-30.966m31.793 70.333C808.17 460.965 825 443.922 825 415c0-38.859-36.24-44.685-52.39-26.43m36.808 65.81C828.128 451.01 845 433.96 845 405c0-39.224-36.924-44.792-52.84-25.909m37.675 65.212C848.378 440.754 865 423.743 865 395c0-39-36.504-44.727-52.566-26.23m33.91 70.213C864.27 434.82 880 417.962 880 390c0-34.529-28.614-42.977-46.321-31.623m34.026 70.264C885.06 423.957 900 407.251 900 380c0-39.087-36.667-44.753-52.673-26.106m40.274 64.775C905 414.024 920 397.306 920 370c0-38.91-36.337-44.7-52.455-26.357M393.488 145.734C390.692 165.756 385 207.455 385 215c0 10 5 30 5 40v70c0 30 67.094 152.094 75 160 15 15 63.177 34.874 85 30 15.768-3.522 96.225-30.183 127.66-63.115M382.577 147.228C363.268 207.665 366.103 272.149 360 335c-1.733 17.844-25.582 26.283-30 0m60-5c-10 50-80 60-80 15 0-43.27 50-40 50-15m21.642 21.232c-15 25 12.013 83.235 3.358 103.768-9.923 23.54-55 30-60 0-2.6-15.596 15-20 15-20m42.947-20c-2.874 48.28-28.15 45.347-37.947 45-14.99-.53-15-15-5-25m65.624-61.475c4.03 25.81.438 70.852-.624 81.475-5 50-90 50-95 5s58.774-61.204 55-25c-3.544 33.995-49.455 27.568-25 0m140-5c5 10 20 20 40 10m-55-25l15-5c5 0 5 5 15 5s10-5 20-5 5 5 15 5 15-5 15-5M390 220c11.318-14.134 56.376-43.415 80-10-1.4-1.496 1.277 6.539 0 5-25.008-30.136-66.371-7.783-80 5v0m240 10c-5.438-6.79-22.697-30.54-45-35-25-5-40 0-59.073 15.4 1.4-1.495-1.412 6.417 0 5C560.27 180.948 621.088 207.037 630 230v0m-160-15c18.673 51.658 0 74.505 0 100 0 15-6.095 35.06-5 45 1.595 14.471 15 15 20 25m45-10c-10-10-55-5-20 0s35-7.929 35-15c0-5-5-15-15-15m-5-80s15-20 35-20 45 25 80 25c-30 0-50.011 9.323-70 10-20.5.695-35-15-45-15m-135-10c15-10 25-15 40-10s45 20 45 20m0 0c-20 5-40 15-55 15-14.142 0-30-20-30-20M246.47 0L370 150c180.66-37.466 351.908-15.7 520 10L1023.334 0m-116.54 139.3l-13.317-2.036c-105.3-16.1-212.93-30.902-324.065-30.362-66.68.325-134.623 6.172-204.082 20.577l-12.231 2.537m-69.053-84.328C216.752 54.57 232.09 147.182 175 190c93.311 27.993 143.088-35.437 161.516-80.608M175 190c59.99 9.23 94.425-79.494 134.753-112.881M310 130c3.622-15.522-.587-31.178-6.695-46.867M255 85c18.364-7.903 33.498-4.91 48.503-1.48M240 120c13.663-9.296 27.374-11.325 41.122-10.975M290 155c3.267-4.481-3.393-36.023-7.714-46.574M225 155c11.905-7.533 22.973-11.691 33.555-13.886M260 175c.69-8.732.615-23.442-1.616-34.617M210 170c7.27-1.286 13.646-.613 19.568 1.056M230 185c4.485-6.253 3.934-11.496 1.8-16.426"
        />
      </symbol>
      <symbol id="JC_svg__g" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={3}
          fill="none"
          d="M524.942 513.716L570 540l126.33-61.127M61.131 535.04c-6.953 8.523-6.132 13.187-1.56 20.414m-2.135 7.295c-6.953 8.524-6.132 13.187-1.56 20.414m-1.519 7.5c-6.952 8.524-6.131 13.188-1.559 20.415m8.538 4.422c-6.953 8.523-6.132 13.186-1.56 20.414M35 540c-3.99 5.328-1.136 7.235 0 10m-.821 17.915c-3.99 5.328-1.136 7.234 0 10m-2.668 18.12c-3.99 5.327-1.136 7.234 0 10m-.206 14.63c-3.989 5.328-1.136 7.235 0 10M60 505c5 5-5 25-5 25m340-280c15-20 25-20 40-20s40 20 40 20m60 5c15-20 27.855-25.694 45-25 12.009.486 30 15 30 15m-179.851.272c2.982 3.656 4.851 8.9 4.851 14.728 0 11.046-6.716 20-15 20-8.284 0-15-8.954-15-20 0-6.19 2.11-11.724 5.422-15.392m162.6 5.46c1.259 2.926 1.978 6.317 1.978 9.932 0 11.046-6.716 20-15 20-8.284 0-15.87-6.052-15.87-17.097 0-6.372 2.234-12.049 5.716-15.711M610 510l78.911-37.135M615 500l69.819-32.856M480 460c10.058-6.05 25 0 35 5"
        />
        <use
          xlinkHref="#JC_svg__a"
          height={75}
          transform="matrix(1 0 0 .793 467 698.659)"
        />
        <use
          xlinkHref="#JC_svg__a"
          height={75}
          transform="matrix(1 0 0 .793 467 814.659)"
        />
        <use
          xlinkHref="#JC_svg__a"
          height={75}
          transform="matrix(1 0 0 .793 789 613.659)"
        />
      </symbol>
      <rect
        width={211}
        height={328}
        x={-105.5}
        y={-164}
        rx={12}
        ry={12}
        fill="#fff"
        stroke="#000"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JC_svg__b" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JC_svg__b"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JC_svg__c" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JC_svg__c"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JC_svg__d" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JC_svg__d"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JC_svg__e" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JC_svg__e"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JC_svg__f" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JC_svg__f"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JC_svg__g" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JC_svg__g"
      />
      <use xlinkHref="#JC_svg__h" height={50} x={-104} y={-152.5} />
      <use xlinkHref="#JC_svg__a" height={41.827} x={-99.913} y={-97.5} />
      <use xlinkHref="#JC_svg__a" height={38.6} x={21.695} y={-109.3} />
      <g transform="rotate(180)">
        <use xlinkHref="#JC_svg__h" height={50} x={-104} y={-152.5} />
        <use xlinkHref="#JC_svg__a" height={41.827} x={-99.913} y={-97.5} />
        <use xlinkHref="#JC_svg__a" height={38.6} x={21.695} y={-109.3} />
      </g>
      <use xlinkHref="#JC_svg__i" stroke="#44F" fill="none" />
    </svg>
  );
}

export default SvgJc;
