import * as React from "react";

function SvgJs(props) {
  return (
    <svg
      className="JS_svg__card"
      preserveAspectRatio="none"
      viewBox="-106 -164.5 212 329"
      {...props}
    >
      <defs>
        <path id="JS_svg__i" d="M-58-112.5H58v225H-58z" />
      </defs>
      <symbol
        id="JS_svg__h"
        viewBox="-500 -500 1000 1000"
        preserveAspectRatio="xMinYMid"
      >
        <path
          d="M50-460h200m-100 0v710a100 100 0 01-400 0v-30"
          stroke="#000"
          strokeWidth={80}
          strokeLinecap="square"
          strokeMiterlimit={1.5}
          fill="none"
        />
      </symbol>
      <symbol
        id="JS_svg__a"
        viewBox="-600 -600 1200 1200"
        preserveAspectRatio="xMinYMid"
      >
        <path d="M0-500c100 250 355 400 355 685a150 150 0 01-300 0 10 10 0 00-20 0c0 200 50 215 95 315h-260c45-100 95-115 95-315a10 10 0 00-20 0 150 150 0 01-300 0c0-285 255-435 355-685z" />
      </symbol>
      <symbol id="JS_svg__b" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#FC4"
          d="M1220.03 34.26c-31.412 0-56.876 47.01-56.876 105 .016 40.087 12.395 76.66 31.905 94.26l-45.74 45.74 45.775 45.775c-19.517 17.576-31.91 54.135-31.94 94.225 0 33.251 8.373 62.892 21.438 82.13.936 3.778 47.696 25.614 51.822 18.448 23.424-12.987 40.49-53.103 40.49-100.578-.016-40.088-12.395-76.66-31.904-94.26l45.74-45.74-45.775-45.776c19.517-17.576 31.91-54.135 31.94-94.224 0-57.99-25.465-105-56.876-105zm0 45c17.949 0 32.5 26.863 32.5 60s-14.551 60-32.5 60c-17.95 0-32.5-26.863-32.5-60s14.55-60 32.5-60zm-525.99 89.875c-63.888 6.439-127.843 16.954-191.059 30.263C520.5 262.59 450.952 302.611 460 375c1.818 14.546 11.572 23.142 23.318 26.568-3.254 26.676-20.68 58.987-43.074 53.243 7.569.24 14.738-4.763 14.756-14.811.046-25-50-40.227-50 15 0 26.45 31.97 41.442 60.645 32.246-5.21 1.798-10.494 2.94-15.67 3.631l.078 267.125C439.618 747.053 423.324 740 405 740c-31.5 0-57.035 20.819-57.035 46.5 0 1.034.046 2.068.133 3.1h-.133l-.041 7.125c24.462 30 46.93 62.78 67.724 98.105l334.147.17.205-74.244h-.15c.083-.727.133-1.455.15-2.184 0-18.09-20.147-32.756-45-32.756-9.376.598-16.979 2.632-23.643 5.924 5.908-2.95 12.53-4.939 20.475-5.804l10.533-15.461 64.762 44.113 10.307-14.79-64.47-44.321-6.745 9.341 125.96-184.882 64.362 44.25 9.813-15.131-63.993-43.994-3.302 4.779 51.697-75.883 64.342 44.234 10.62-14.572-57.679-39.656L910 485l-8.746 8.227 3.992-5.86C901.463 489.022 896.383 490 890 490c-25 0-55-5-75-5-9.747 0-27.808-5.939-44.799-11.94-10.374 3.45-27.351 8.728-40.201 11.94-17.632 4.408-50.808-10.615-58.533-14.361-10.538 15.724-24.314 25.314-38.317 29.898 26.182-8.657 51.553-34.883 56.256-86.09C714.146 408.96 735 391.293 735 370c0-55.227-55-45-55-10 0 9.54 3.412 14.963 8.104 17.482-80.307-31.389 38.064-123.362 5.937-208.347zm525.988 80.836l29.29 29.289-29.29 29.289-29.289-29.29zm0 109.289c17.95 0 32.5 26.863 32.5 60s-14.55 60-32.5 60c-17.949 0-32.5-26.863-32.5-60s14.551-60 32.5-60zM485.406 476.125c.02.16.047.315.069.475-.015-.104-.034-.205-.047-.309a47.21 47.21 0 00-1.15.78c.378-.312.755-.623 1.128-.946zm-5.578 4.258L480 515h380L660.043 802.215l-.043 6.488v-9.312h-.158c.088-.936.14-1.872.158-2.81 0-23.296-21.266-42.183-47.5-42.183-24 0-43.843 15.807-47.305 34.868-1.57-25.298-24.09-44.266-51.677-44.266-17.981 0-33.797 8.063-43.002 20.223a48.997 48.997 0 019.39-9.442l-.113-275.375.035-.023zm93.7 3.898c.145.26.306.512.458.768-.108-.178-.22-.353-.326-.533-15.416 16.862-37.059 24.865-55.101 23.093 18.02 1.716 39.625-6.35 54.968-23.328zm407.185 32.014L750 855v40l175.37-257.896-117.825 173.638c36.997 2.218 73.31 9.251 108.228 20.754-34.92-11.474-71.254-18.488-108.285-20.67l-19.681 28.854c62.063 1.184 122.668 16.544 177.816 44.675l6.477 3.377c41.326 22.006 79.451 51.257 112.671 86.998C1164.955 1060.997 1210 1178 1210 1300c0 34.756-3.656 69.106-10.85 102.477a601.333 601.333 0 0025.653 12.511c8.662-37.514 13.082-75.735 13.082-114.988 0-98.303-27.457-193.56-77.514-273.693-.361-.266-.72-.54-1.082-.807 42.156 31.268 89.847 55.215 140.711 70.936V899.504c-51.712-25.693-109.972-86.673-101.29-151.568-35.12-24.628-71.448-48.976-108.84-72.967 74.94 48.013 145.353 97.111 210.13 146.242V708.437c-104.607-68.65-200.637-128.399-299.56-181.966l-.077.113zM335 520l-20 8.48v229.73l20 22.58zm55 18.598c-13.902 0-27.804 8.598-10.607 25.795-34.394-34.394-34.394 55.608 0 21.214-34.394 34.394 55.608 34.394 21.214 0 26.218 26.218 32.802-20.199 18.948-28.246-4.32-2.509-10.627-1.289-18.948 7.032 17.197-17.197 3.295-25.795-10.607-25.795zM480 570v25h324.059L820 570zm518.945 48.588c.295.176.585.355.88.531l-.88-.53zm-609.552 34.404c-13.902 0-27.803 8.598-10.606 25.795-34.393-34.393-34.393 55.606 0 21.213-34.393 34.393 55.606 34.393 21.213 0 26.217 26.217 32.803-20.2 18.95-28.246-4.321-2.51-10.63-1.287-18.95 7.033 17.197-17.197 3.294-25.795-10.607-25.795zm398.22 7.242l-10.24 14.834 64.652 44.45 10.239-14.836zM470.211 765.633zm-8.272 23.836c.023.12.056.23.096.326v.006a1.587 1.587 0 01-.096-.332zm218.415 2.787zm337.206 51.076zm3.083 7.533c.308.733.61 1.468.923 2.2-.312-.732-.615-1.467-.923-2.2zm3.681 8.494c.514 1.147 1.04 2.288 1.565 3.43-.525-1.142-1.051-2.283-1.565-3.43zm3.088 6.707zm2.732 5.684zm5.03 9.93zm2.771 5.191a407.16 407.16 0 005.82 10.358 410.107 410.107 0 009.66 15.775 400.117 400.117 0 01-8.26-13.348c-.476-.805-.93-1.62-1.4-2.427a405.175 405.175 0 01-5.82-10.358zm-243.164 17.867c2.444 7.22 4.944 14.36 7.479 21.45L800 920H430l12.707 24.7 366.205-.3-.236-.65c1.413 3.777 2.836 7.54 4.275 11.275 202.05 4.975 319.656 193.073 296.893 394.81a822.938 822.938 0 0034.775 22.376c-6.506-9.68-6.512-16.274 2.018-18.82a425.017 425.017 0 003.06-69.428c-13.438-10.034-11.803-19.084-1.94-27.594a421.605 421.605 0 00-14.146-73.135c-18.283-13.575-11.454-18.32-7.744-24.162-8.214-23.168-18.448-45.49-30.582-66.658-8.366-4.101-14.68-8.716-9.766-16.145-12.677-19.88-27.104-38.604-43.173-55.892a380.516 380.516 0 00-15.707-15.936c-3.976-2.375-8.1-4.444-10.641-9.793-23.462-20.774-49.104-38.224-76.285-52.068l-5.565-2.773c-27.634-13.472-56.791-23.251-86.816-29.045l-12.717-2.207a350.728 350.728 0 00-39.834-3.817zm259.014 8.832zm-536.111 50.332c-13.902 0-27.803 8.599-10.606 25.795-34.393-34.393-34.393 55.607 0 21.213-34.393 34.394 55.606 34.394 21.213 0 26.218 26.218 32.801-20.2 18.947-28.246-4.32-2.51-10.627-1.287-18.947 7.033 17.197-17.196 3.294-25.795-10.607-25.795zm88.13 0c-13.901 0-27.802 8.599-10.605 25.795-34.393-34.393-34.393 55.607 0 21.213-34.393 34.394 55.606 34.394 21.213 0 26.217 26.218 32.803-20.2 18.95-28.246-4.321-2.51-10.63-1.287-18.95 7.033 17.197-17.196 3.294-25.795-10.608-25.795zm227.352 41.05l17.113 35.029c102.383 30.854 178.31 129.819 182.9 248.609l27.856 24.228c.166-4.25.25-8.523.25-12.818 0-147.049-98.337-269.388-228.119-295.049z"
        />
      </symbol>
      <symbol id="JS_svg__c" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="red"
          d="M339.994 0c47.44 47.6 100.553 102.806 140.34 165.766 119.757-48.485 358.765-76.599 478.27-25.84C1001.155 89.326 1052.45 43.59 1107.316 0zm880.035 79.26a32.5 60 0 00-32.5 60 32.5 60 0 0032.5 60 32.5 60 0 0032.5-60 32.5 60 0 00-32.5-60zm0 170.71l-29.289 29.29 29.29 29.289 29.288-29.29zm0 109.29a32.5 60 0 00-32.5 60 32.5 60 0 0032.5 60 32.5 60 0 0032.5-60 32.5 60 0 00-32.5-60zM988.96 543.563l-20.252 29.54c120.63 70.147 232.406 144.675 331.292 219.343v-47.484c-93.594-69.531-198.437-135.485-311.041-201.399zM280.006 545.2c-47.874 23.233-95.508 47.342-142.25 72.621 53.195 30.119 100.356 65.097 142.42 105.293zm110.213 14.801a15 15 0 00-10.826 4.39 15 15 0 000 21.215 15 15 0 0021.214 0 15 15 0 000-21.214 15 15 0 00-10.388-4.391zM480 635.211l.35 120.244c9.258-6.577 20.694-10.455 33.168-10.455 27.587 0 50.106 18.968 51.677 44.266 3.462-19.06 23.305-34.868 47.305-34.868 26.234 0 47.5 18.887 47.5 42.182-.018.939-.07 1.875-.158 2.81H660l.043 2.97 115.78-166.946zm-90.387 39.184a15 15 0 00-10.826 4.392 15 15 0 000 21.213A15 15 0 00400 700a15 15 0 000-21.213 15 15 0 00-10.387-4.392zm887.897 130.152c-11.906 22.593 8.882 47.772 22.49 59.201v-42.523c-7.336-5.558-14.753-11.115-22.49-16.678zM808.912 944.4c.076.202.153.399.229.6h.382zm-157.629.13L443.35 945l-.643-.3c17.48 34.53 33.433 71.123 47.986 109.847l-.216.453h160.898zM812.941 955l20.225 49.951c129.782 25.661 228.12 148 228.12 295.049 0 4.295-.085 8.568-.25 12.818L1110 1350c22.608-201.901-95-390-297.059-395zm-295.257 8.902c13.901 0 27.804 8.599 10.607 25.795 8.32-8.32 14.627-9.542 18.947-7.033 13.854 8.047 7.27 54.464-18.947 28.246 34.393 34.394-55.606 34.394-21.213 0-34.393 34.394-34.393-55.606 0-21.213-17.197-17.196-3.296-25.795 10.606-25.795zm-10.606 25.795a15 15 0 000 21.213 15 15 0 0021.213 0 15 15 0 000-21.213 15 15 0 00-21.213 0zm98.736-25.795c13.902 0 27.805 8.599 10.608 25.795 8.32-8.32 14.629-9.542 18.95-7.033 13.853 8.047 7.267 54.464-18.95 28.246 34.393 34.394-55.606 34.394-21.213 0-34.393 34.394-34.393-55.606 0-21.213-17.197-17.196-3.296-25.795 10.605-25.795zm-10.605 25.795a15 15 0 000 21.213 15 15 0 0021.213 0 15 15 0 000-21.213 15 15 0 00-21.213 0zm254.875 50.475c47.763 99.005 107.68 181.409 182.805 248.648-4.298-119.019-80.227-217.985-182.805-248.648zm360.389 18.264c35.988 73.868 55.295 156.645 55.295 241.564 0 43.186-4.993 85.818-14.438 127.031a1038.07 1038.07 0 0048.67 19.332V1096.43c-31.215-9.648-61.238-22.384-89.527-37.995z"
        />
      </symbol>
      <symbol id="JS_svg__d" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#44F"
          d="M515 515v55h55v-55zm27.5 10a17.5 17.5 0 0117.5 17.5 17.5 17.5 0 01-17.5 17.5 17.5 17.5 0 01-17.5-17.5 17.5 17.5 0 0117.5-17.5zm92.5-10v55h55v-55zm27.5 10a17.5 17.5 0 0117.5 17.5 17.5 17.5 0 01-17.5 17.5 17.5 17.5 0 01-17.5-17.5 17.5 17.5 0 0117.5-17.5zm92.5-10v55h55v-55zm27.5 10a17.5 17.5 0 0117.5 17.5 17.5 17.5 0 01-17.5 17.5 17.5 17.5 0 01-17.5-17.5 17.5 17.5 0 0117.5-17.5zm-270 245a37.5 37.5 0 00-37.5 37.5 37.5 37.5 0 00.088 2.5H475v85h75v-85h-.125a37.5 37.5 0 00.125-2.5 37.5 37.5 0 00-37.5-37.5zm-107.964 0c-20.71 0-37.5 16.79-37.5 37.5.001.834.03 1.668.088 2.5h-.088v12.25l48.4 72.75h26.6v-85h-.125c.07-.832.111-1.666.125-2.5 0-20.71-16.79-37.5-37.5-37.5zm208.026 17.857A32.438 32.143 0 00580.125 820a32.438 32.143 0 00.076 2.143h-.076V895H645v-72.857h-.108A32.438 32.143 0 00645 820a32.438 32.143 0 00-32.438-32.143zm90 22.143a27.438 25.929 0 00-27.437 25.929 27.438 25.929 0 00.064 1.728h-.064v58.772H730v-58.772h-.091a27.438 25.929 0 00.091-1.728A27.438 25.929 0 00702.562 810zm308.252-253.598l-18.304 30.584 34.25 20.664 18.2-30.412zm63.315 38.625l-17.897 29.903 33.61 21.732 18.304-30.584zm63.057 39.055l-18.586 31.053 33.148 22.504L1171 655.473zm62.392 40.164l-19.252 32.164 32.434 23.697 19.941-33.316zm61.088 42.342l-19.557 32.678 32.56 23.484 19.61-32.764zm-409.548 31.354L875 765c50 35 90-35 50-70l-26.957-17.971zM900 720c8.284 0 15 6.716 15 15 0 8.284-6.716 15-15 15-8.284 0-15-6.716-15-15 0-8.284 6.716-15 15-15zm98.39-101.744l-42.328-24.75-36.535 51.87L940 660c20.554 14.388 39.417 11.032 51.729-.341zM965 615c8.284 0 15 6.716 15 15 0 8.284-6.716 15-15 15-8.284 0-15-6.716-15-15 0-8.284 6.716-15 15-15zM810 810l55.745 7.935C864.146 807.908 859.18 798.032 850 790l-19.35-12.9zm183.336-60.138l-58.954 88.21c39.148 14.881 76.532 35.64 110.85 61.701-27.364-46.311-45.1-97.165-51.896-149.91zM925 395s-15-5-20-5-10 15-20 15-10 5-10 5c-.619.316 22.903 3.625 30-5 3.177-3.861 20.184-2.235 20.184-2.235M850 395c15 0 35.006-26.643 45-27l25-1-4 8s-13 2-18 2-23 23-33 23-15-5-15-5zm62-43c26.021-3.86 44.26-17.774 28-17-21 1-29 11-33 16m2-154l-8 8s-31-12-48-10c-16.167 1.902-78 33-78 33 14-18 87-62 134-31zm-38 50.5a8 17.5 0 01-8 17.5 8 17.5 0 01-8-17.5 8 17.5 0 018-17.5 8 17.5 0 018 17.5"
        />
      </symbol>
      <symbol id="JS_svg__e" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path d="M280 545l35-16.519v229.553l-34.825-34.92zm150.213 375L415 895h376.461l8.589 25zM480 595h324.058l-28.447 40H480zm744.878 820.024c8.586-37.55 13.006-75.771 13.006-115.024 0-98.303-27.456-193.56-77.682-273.819 16.515 12.177 33.745 23.163 50.965 32.635 35.295 73.487 54.601 156.265 54.601 241.184 0 43.186-4.993 85.818-15.428 126.604-9.175-4.023-17.438-7.743-25.462-11.58zm-269.567-568.37L985 800c5.534 23.766 11.843 47.199 18.27 70.58M480.486 166.004C487.465 177.24 493.99 188.501 500 200c143.73-30.414 291.688-46.681 435-30 7.479-10.1 15.302-19.991 23.62-30.093-119.522-50.739-358.528-22.626-478.135 26.097z" />
      </symbol>
      <symbol id="JS_svg__f" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={6}
          fill="none"
          d="M1299.894 708.358C1165.225 619.98 1044.801 546.406 913.66 481.8M778.787 854.444c90.112 301.87 247.362 490.954 521.13 591.897M791.462 895H415.846m384.236 25H430.213m378.08 25H443.35m461.445-457.358L701.696 785.807m279.017-269.513c-76.615 113.242-154.469 225.648-230.844 339.052m-332.676-374.08c-94.148 42.49-187.727 87.113-279.98 136.686M335 520.115v260.673m115-288.905v266.326M280 545.221v178.096m35-194.787v229.68m165-277.793v275.18M480 515h380L660.087 802.68M480 570h340.894M480 595h324.058M480 635h295.611m-375.004-70.607a15 15 0 010 21.214 15 15 0 01-21.214 0 15 15 0 010-21.214 15 15 0 0121.214 0v0m0 0c8.32-8.32 14.628-9.542 18.948-7.032 13.854 8.046 7.27 54.463-18.948 28.246C435 620 345 620 379.393 585.607 345 620 345 530 379.393 564.393 345 530 435 530 400.607 564.393v0M400 678.787A15 15 0 01400 700a15 15 0 01-21.213 0 15 15 0 010-21.213 15 15 0 0121.213 0v0m0 0c8.32-8.32 14.628-9.542 18.948-7.033C432.802 679.8 426.218 726.217 400 700c34.393 34.393-55.607 34.393-21.213 0-34.394 34.393-34.394-55.607 0-21.213-34.394-34.394 55.606-34.394 21.213 0v0M335 620h115m-115 20h115m-43.181 20H450m-115 0h36.84m52.83 20H450m-115 0h19.415m69.965 20H450m-115 0h19.86m51.233 20H450m-115 0h37.857m50.072-160H450m-115 0h22.327m69.085 20H450m-115 0h18.844m54.716 20H450m-115 0h36.26m4.935-100H450m-117.077 20H450m-50.003 20H450m-115 0h44.968M335 740h115m-115 20h22.617M335 780h10.861m182.43 209.697a15 15 0 010 21.213 15 15 0 01-21.213 0 15 15 0 010-21.213 15 15 0 0121.213 0v0m88.13 0a15 15 0 010 21.213 15 15 0 01-21.212 0 15 15 0 010-21.213 15 15 0 0121.213 0v0m-88.131 0c8.32-8.32 14.628-9.543 18.948-7.033 13.854 8.047 7.27 54.463-18.948 28.246 34.393 34.393-55.607 34.393-21.213 0-34.394 34.393-34.394-55.607 0-21.213-34.394-34.394 55.606-34.394 21.213 0v0m88.13 0c8.321-8.32 14.629-9.543 18.95-7.033 13.853 8.047 7.268 54.463-18.95 28.246 34.394 34.393-55.606 34.393-21.212 0-34.394 34.393-34.394-55.607 0-21.213-34.394-34.394 55.606-34.394 21.213 0v0M750 895v-74.245h-.15c.083-.726.133-1.455.15-2.184 0-18.09-20.147-32.755-45-32.755-20.619 1.314-32.663 9.571-45 22.887v-9.312h-.158c.088-.935.14-1.873.158-2.812 0-23.295-21.266-42.18-47.5-42.18-24 0-43.842 15.805-47.304 34.866-1.571-25.298-24.09-44.265-51.678-44.265-28.433 0-51.482 20.147-51.482 44.8-.332-.77-.017-2.522 0-3.3 0-25.681-25.536-46.5-57.036-46.5s-57.036 20.819-57.036 46.5a37.37 37.37 0 00.134 3.1h-.134v7.609m652.667-270.786L750 895m168.036-411.038l57.683 39.657m-198.347 151.45l64.654 44.449m-54.413-59.284l64.782 44.537M842.112 579.89l64.43 44.296m-54.18-59.124l63.99 43.994m-15.757-115.209l64.502 44.346m-252.048 232.34l64.078 44.055m-54.162-59.112l64.74 44.509m168.357-206.48c125.646 72.812 241.832 150.245 344.012 227.75M968.653 572.916c120.717 70.348 232.564 144.902 331.47 219.592M988.787 543.79c112.823 65.736 217.732 131.707 311.364 201.277m-.232 257.836C1170.517 952.17 1080 835.643 1080 700c0-10.247.517-20.385 1.527-30.393m218.43 426.817c-65.947-20.39-126.565-54.605-176.69-100.681C1037.936 917.307 990 810.925 990 700c0-27.631 2.974-54.98 8.76-81.686m301.167 360.378C1187.557 928.802 1110 822.758 1110 700c0-4.01.083-8.004.247-11.977m189.686 272.348C1198.031 911.71 1128.365 813.38 1128.365 700m171.59 358.208c-57.894-18.85-111.088-48.937-155.475-88.738C1064.777 898.002 1020 801.07 1020 700c0-21.892 2.1-43.59 6.202-64.877m5.159 95.16A337.652 337.652 0 011030 700a338.11 338.11 0 015.216-59.138m25.96 201.404c-15.197-33.322-25.059-68.626-29.097-104.85m90.14 197.732c-23.371-26.07-42.629-54.722-57.391-85.124m139.076 154.489c-18.526-11.92-36.048-25.27-52.353-39.97a393.012 393.012 0 01-20.26-19.62m152.656 99.877c-20.095-7.628-39.526-16.684-58.102-27.097M1040.41 716.5a336.584 336.584 0 012.85-63.302m20.698 171.206c-9.889-24.89-16.822-50.779-20.602-77.229m70.834 164.638c-13.523-17.358-25.32-35.698-35.287-54.8m108.73 126.476a394.027 394.027 0 01-31.934-26.549m120.107 76.64a423.462 423.462 0 01-20.863-9.363M972.1 887.733c41.327 22.005 79.451 51.257 112.671 86.998C1164.954 1060.998 1210 1178 1210 1300c0 34.756-3.656 69.106-10.739 102.455M965.623 884.356a415.51 415.51 0 016.478 3.377m-184.346-47.698c62.115.83 122.72 16.19 177.868 44.321m228.866 494.921c-.461 2.807-.949 5.61-1.464 8.411m4.954-34.357a463.57 463.57 0 01-1.084 9.354m3.785-67.731c.017 1.68.026 3.363.026 5.046v0c0 12.67-.43 25.198-1.33 37.618m.537-65.327c.233 4.054.414 8.115.545 12.183m-3.185-42.029a482.946 482.946 0 011.63 15.791m-12.271-73.995a479.886 479.886 0 019.505 49.41m-15.187-70.322a475.95 475.95 0 013.366 11.929m-11.897-37.936a472.504 472.504 0 014.091 11.843m-28.201-67.245a465.416 465.416 0 0119.415 42.93m-30.407-63.03c1.117 1.926 2.22 3.86 3.308 5.804m-18.368-29.998a451.728 451.728 0 016.392 9.858m-48.859-63.962a442.205 442.205 0 0135.164 43.488m-50.706-59.542a432.807 432.807 0 014.695 4.677m-23.156-21.756c1.85 1.613 3.69 3.245 5.516 4.895m-60.291-45.346a416.649 416.649 0 0141.358 29.23m-60.375-40.305c1.44.788 2.877 1.584 4.309 2.39m-25.475-13.176c1.406.666 2.808 1.34 4.208 2.021m-73.854-27.38a397.094 397.094 0 0151.783 17.432m-73.578-22.472c2.775.559 5.544 1.148 8.305 1.766m-33.768-6.024c2.961.395 5.916.824 8.864 1.286M782.442 850c11.823 0 23.594.538 35.285 1.603m373.678 446.018c0 .793.01 1.586.01 2.38a473.38 473.38 0 01-1.404 36.437m-.888-82.929c.06.605.118 1.21.175 1.816m-11.052-66.07a469.208 469.208 0 018.297 43.048m-46.144-145.106a454.978 454.978 0 0118.09 39.846m-85.278-136.456a432.192 432.192 0 0133.34 41.067M985.988 918.367a407.273 407.273 0 0140.176 28.3m-146.232-73.984A388.32 388.32 0 01929.5 889.43m-149.042-29.425a380.46 380.46 0 0135.89 1.509m365.758 435.512a462.6 462.6 0 01-1.506 40.41m-11.656-146.924a458.553 458.553 0 018.564 44.37m-45.975-144.265a444.576 444.576 0 0118.698 41.082m-85.208-135.788l.031.033a422.288 422.288 0 0134.955 42.966M978.964 925.571a397.859 397.859 0 0142.67 29.934m-145.717-73.58a379.487 379.487 0 0151.741 17.462m-142.355-29.376c10.727.083 21.407.629 32.018 1.628m352.64 422.41a448.453 448.453 0 01-1.822 46.772m-11.912-150.994a444.57 444.57 0 019.832 50.85m-47.036-147.39a430.992 430.992 0 0121.226 46.5m-87.586-138.684a409.933 409.933 0 0140.182 49.227M967.721 933.77a385.592 385.592 0 0149.717 34.658m-149.186-75.046a367.96 367.96 0 0159.013 19.86m-138.693-30.155c10.838.184 21.624.857 32.332 2.005m338.98 404.817a436.755 436.755 0 01-2.266 55.663m-12.38-158.047a433.09 433.09 0 0111.564 59.71m-48.926-153.186a419.815 419.815 0 0124.786 54.194m-91.65-144.24a392.41 392.41 0 018.404 8.766 399.959 399.959 0 0138.766 48.895M956.33 939.438c20.77 11.594 40.578 25.287 59.138 40.952m-155.622-77.97c23.807 5.365 47.027 13.183 69.345 23.312M791.056 893.9a351.343 351.343 0 0134.844 2.592m323.798 387.47a425.006 425.006 0 01-3.062 69.428m-13.024-170.155a421.603 421.603 0 0114.145 73.135m-52.47-163.957c12.133 21.168 22.366 43.49 30.58 66.659m-40.348-82.803c.15.234.299.468.447.703m-59.327-72.53a380.471 380.471 0 0115.706 15.935c16.069 17.288 30.496 36.012 43.174 55.892M939.713 942.58c27.181 13.843 52.823 31.294 76.285 52.068m-81.85-54.842c1.862.908 3.717 1.832 5.565 2.774m-92.382-31.819c30.025 5.794 59.183 15.573 86.817 29.045m-139.354-35.031a342.222 342.222 0 0139.822 3.78M812.941 955C1015 960 1132.608 1148.099 1110 1350m-276.834-345.048c129.782 25.66 228.118 148 228.118 295.048 0 4.295-.084 8.568-.25 12.819m-210.755-272.84c102.383 30.855 178.311 129.822 182.901 248.612m126.906-262.496c50.342 80.345 77.798 175.602 77.798 273.905 0 39.253-4.42 77.474-12.884 115M807.783 810.758c85.668 5.133 167.901 36.182 237.422 89.014m165.259 158.688c35.998 73.843 55.304 156.62 55.304 241.54 0 43.186-4.993 85.818-14.635 127.002M1185 1155c1.593 6.717-11.273 15.52-28.738 19.663-17.465 4.142-32.914 2.054-34.507-4.663-1.594-6.717 11.273-15.52 28.738-19.663 17.464-4.142 32.914-2.054 34.507 4.663v0m-60.902 8.634c1.598-6.554 7.381-15.459 15.902-23.634 12.952-12.426 27.327-18.462 32.106-13.48 3.594 3.746 1.32 12.074-5.825 21.547m7.172 20.739c9.837 3.822 14.627 9.135 13.808 13.872-1.175 6.803-16.466 9.84-34.153 6.784-14.642-2.53-26.335-8.441-29.262-14.261M1205 1265c.388 6.893-13.825 13.298-31.746 14.307-17.92 1.009-32.763-3.761-33.151-10.654-.388-6.892 13.825-13.298 31.746-14.307 17.92-1.008 32.763 3.761 33.151 10.654v0m-61.472-2.202c2.725-6.171 9.983-13.921 19.808-20.472 14.934-9.957 30.145-13.372 33.975-7.628 2.88 4.319-.823 12.118-9.52 20.187m3.416 21.677c9.012 5.491 12.793 11.563 11.156 16.083-2.353 6.49-17.94 6.793-34.815.677-13.969-5.063-24.441-12.938-26.3-19.181m62.595 98.78c-1.396 6.76-16.777 9.3-34.356 5.67-17.579-3.629-30.697-12.051-29.301-18.812 1.395-6.761 16.777-9.3 34.356-5.671 17.578 3.629 30.697 12.052 29.301 18.812v0M1145 1355c4.22-5.264 13.224-10.89 24.402-14.696 16.991-5.787 32.57-5.18 34.795 1.356 1.673 4.914-3.908 11.5-14.387 17.064m-48.786 11.226c-.709-1.658-1.1-3.2-1.141-4.574m47.66 15.175c7.299 7.622 9.393 14.462 6.65 18.409M1140 1050c3.732 5.808-5.484 18.382-20.585 28.085-15.1 9.703-30.367 12.86-34.099 7.053-3.732-5.808 5.484-18.382 20.585-28.085 15.1-9.703 30.367-12.86 34.099-7.053v0m-54.586 28.355c-.667-6.713 1.833-17.033 7.158-27.572 8.095-16.02 19.652-26.484 25.814-23.37 4.633 2.34 5.251 10.952 1.655 22.258m13.648 17.184c10.548.341 16.829 3.764 17.629 8.504 1.149 6.807-12.268 14.747-29.967 17.734-14.651 2.472-27.644.775-32.336-3.744M1065 955c4.699 5.058-2.153 19.062-15.303 31.278-13.15 12.217-27.62 18.02-32.319 12.962-4.698-5.058 2.153-19.061 15.303-31.278 13.15-12.216 27.62-18.02 32.319-12.962v0m-48.723 37.547c-1.842-6.49-1.202-17.089 2.178-28.403 5.14-17.198 14.668-29.537 21.282-27.56 4.974 1.486 7.103 9.852 5.56 21.616m16.467 14.505c10.442-1.527 17.229.733 18.853 5.258 2.332 6.497-9.472 16.68-26.366 22.745-13.984 5.02-27.072 5.644-32.488 2.025M970 885c5.8 3.743 2.615 19.004-7.117 34.086-9.731 15.082-22.323 24.275-28.124 20.532-5.8-3.743-2.614-19.004 7.117-34.086C951.608 890.45 964.2 881.257 970 885v0m-37.958 48.403c-3.386-5.836-5.38-16.265-4.894-28.063.74-17.934 6.93-32.242 13.828-31.958 5.187.214 9.313 7.797 10.718 19.579m19.536 9.995c9.743-4.054 16.878-3.538 19.568.446 3.862 5.722-5.066 18.502-19.942 28.545-12.315 8.314-24.845 12.146-30.986 9.974m-86.497-93.96c6.702 1.657 8.642 17.126 4.335 34.55-4.308 17.425-13.233 30.207-19.935 28.55-6.702-1.657-8.643-17.125-4.335-34.55 4.308-17.424 13.233-30.207 19.935-28.55v0m-20.188 58.104c-5.097-4.42-10.37-13.637-13.74-24.954-5.123-17.202-3.912-32.745 2.704-34.716 4.976-1.481 11.34 4.352 16.494 15.039m21.723 3.111c7.9-6.998 14.815-8.825 18.652-5.93 5.511 4.157 1.216 19.143-9.594 33.473-8.949 11.86-19.556 19.554-26.07 19.493m18.844 100.725l14.13-49.456m38.89 73.018l27.277-47.734m15.37 78.286l38.569-42.075m.232 82.579l46.158-31.956m-12.779 85.727l49.922-21.395m-28.928 78.492l51.747-10.35M1060.66 1270h51.088M829.096 994.024l47.183-31 38.94 72.844 81.215-11.523.232 82.579 83.301 32.376-28.928 78.492L1111.67 1270l-42.681 49.562M812.941 955l49.257 57.306 80.297-24.172 15.37 78.286 84.959 8.548-12.779 85.727 72.359 46.824L1060.66 1270l51.462 54.437-16.398 15.71m-23.409-18.553l40.06 2.861M1265 1432.805V1190m15 248.834V1200m15 244.992V1210m-240.23-358.926c36.785-10.586 25.202 47.883 76.034 16.617m-40.826-90.436c-56.953 26.845-5.251 49.721-35.892 72.303m67.304 97.642c29.345-13.894 35.536 40.247 74.977-4.423m-65.228-74.5c-45.772 40.184 4.027 48.74-12.084 76.043m94.257 75.307c22.994-12.037 42.632 30.836 67.862-23.852m-83.348-52.623c-32.86 48.928 10.495 47.177 8.641 72.541m74.702-19.918c-18.662 48.533 6.531 48.678 18.994 60.839m-278.254-320.949c40.802.466 9.283 53.476 67.827 40.607m-9.636-98.793c-62.251 7.22-19.164 46.432-58.298 57.084m20.036-88.99c3.424 15.26 1.5 33.098 38.262 31.71m2.225 59.85c-8.363 2.374-16.843 4.526-27.325 2.867m10-25c.585 17.408 8.793 17.8 16.88 18.462m.506 6.547c-7.606 5.03-16.195 11.522-17.386 19.991m41.53 63.177c-7.902 5.113-15.733 10.297-27.115 11.892m2.268-26.83c6.127 17.898 14.995 13.973 23.58 12.304m1.46 5.205c-6.073 7.244-13.324 16.54-11.905 25.531m67.74 58.068c-2.598 8.29-5.447 16.556-12.575 24.408m-15.428-22.067c15.79 9.606 20.26 1.53 25.613-5.167m4.855 6.358c.153 8.638 1.209 18.249 7.169 23.475m68.812 37.555c-2.295 6.665-5.26 13.265-11.007 19.595m-15.428-22.067c12.148 7.39 17.596 4.315 21.9-.546m8.691 5.311c.41 7.604 1.899 15.387 7.046 19.9m24.975-191.565c-11.672 22.62 9.234 47.843 22.858 59.258m-50.457-80.092c-44.63-8.554-117.28-16.95-109.582-43.703 2.978-8.935 11.278-16.095 17.504-20.425m8.9 46.625c-40.416 31.35-11.981 47.825 107.397 53.163m-93.66-9.982c-27.583 58.676 44.248 32.392 96.167 23.126m-76.708 14.09c-13.217 54.273 30.455 34.16 84.75.155m-63.832 32.548c7.836 58.415 38.305 28.026 73.489-20.866m-44.747 49.476c27.89 70.964 38.938 3.9 50.734-37.555m-17.678 57.736c8.165 16.942 13.815 24.746 17.71 26.21m-406.25-154.399l-1.474 2.175m68.88-101.678l-2.547 3.759M905.39 802.52l-6.753 9.969M973.2 702.418l-8.423 12.433m-44.738 85.805l-17.512 25.85m87.075-128.54l-21.525 31.776m-26.26 58.525l-28.605 42.228m77.166-113.912l-26.448 39.042M950 695c47.07 37.657-7.779 124.057-56.084 104.85-3.006-1.195-5.987-2.8-8.916-4.85m104.667-95.776C976.947 704.41 962.969 704.08 950 695m-65 100c10.822 8.658 16.257 19.893 17.622 31.828M1220.03 359.26c17.95 0 32.5 26.863 32.5 60s-14.55 60-32.5 60c-17.949 0-32.5-26.863-32.5-60s14.551-60 32.5-60v0m0-109.29l29.29 29.29-29.29 29.289-29.289-29.29 29.29-29.288v0m0-170.711c17.949 0 32.5 26.863 32.5 60s-14.551 60-32.5 60c-17.95 0-32.5-26.863-32.5-60s14.55-60 32.5-60v0m16.126 440.72c23.557-12.836 40.748-53.071 40.748-100.72-.016-40.088-12.395-76.66-31.904-94.26l45.74-45.74-45.775-45.776c19.517-17.576 31.91-54.135 31.94-94.224 0-57.99-25.465-105-56.876-105-31.41 0-56.875 47.01-56.875 105 .016 40.087 12.395 76.66 31.905 94.26l-45.74 45.74 45.775 45.775c-19.517 17.576-31.91 54.135-31.94 94.225 0 33.822 8.662 63.91 22.114 83.113m-89.752 77.551c2.218-13.415 11.2-39.855 19.484-44.924 9.53-5.832 45-35 60-35s30 20 60 20c25 0 20 20 0 20s-35-5-35-5c-15.017 16.853-25.13 15.341-35 20-10.11 4.772 15-5 20 5 4.415 8.83-14.557 52.737-19.06 62.898m83.353-87.313C1267.028 537.389 1280 543.16 1280 550c0 8.284-19.028 15-42.5 15s-42.5-6.716-42.5-15c0-4.92 6.713-9.288 17.083-12.023m35.727 26.322c17.824-.295 31.385 3.908 32.19 10.701.975 8.227-17.13 17.135-40.44 19.898-23.308 2.762-42.994-1.667-43.97-9.894C1195.013 580.118 1205 570 1230 565m18.249 29.401c17.824-.295 31.385 3.909 32.19 10.701.975 8.227-17.13 17.135-40.439 19.898-23.309 2.763-42.995-1.667-43.97-9.894-.558-4.71 8.702-14.28 31.76-19.443m19.522 29.435c15.64 1.67 32.736 8.906 32.688 15.612-.059 8.12-16.901 14.81-37.62 14.942-20.717.132-37.465-6.345-37.406-14.466.034-4.65 9.204-12.955 29.969-15.453M930.064 169.335c.049 25.776-10.023 49.913-9.064 55.665 1.644 9.864 49.733 90.172 52 105 4.139 27.071-37.097 27.445-39 31-1.335 2.494 1 19 1 19 0 5-10 20-10 20s0 10 5 15-25 20-25 20 15 20 15 30-5 25-30 25-55-5-75-5-75-25-85-25m-58.418 10.766c7.609 3.62 40.786 18.642 58.418 14.234 12.85-3.212 29.827-8.489 40.324-11.85M925 395s-15-3-20-3-10 13-20 13-10 5-10 5c-.619.316 22.903 3.625 30-5 3.177-3.861 20.184-2.235 20.184-2.235M850 395c15 0 35.006-26.643 45-27l25-1-4 8s-13 2-18 2-23 23-33 23-15-5-15-5v0m62-74c-15.119.102-26.392 34.914 0 31 26.021-3.86 44.26-17.774 28-17-21 1-29 11-33 16m2-154l-8 8s-31-12-48-10c-16.167 1.902-78 33-78 33 14-18 87-62 134-31v0m-114 59c32 5 47-31 103-31m-68 22c-32 29 66 20 66 20m-393.083-67.562C520.498 262.588 450.95 302.611 460 375c5 40 70 35 70 0 0-25-30-20-30-5s10 20 10 20m13.082-194.768c19.866 64.44-51.42 104.548-42.266 177.782 2.366 18.924 15.74 22.625 29.178 17.564m29.675-198.735C564.97 258.151 493.65 297.295 500 370m58.388-181.325c26.985 64.09-37.166 103.385-39.893 168.971m58.214-172.686C607.464 251.85 532.78 303.15 530 370m62.928-187.396c32.856 69.93-46.198 118.31-47.052 184.482C545 435 620 420 620 385s-51.825-36.649-50-5c1.825 31.649 38.517 12.693 30 5m13.388-205.94c28.95 66.231-46.492 117.818-47.34 183.618-.202 15.588 3.849 25.987 10.21 32.334m57.975-218.902c25.537 63.44-43.111 119.56-48.86 181.855m34.673 27.205C650.461 441.037 735 412.87 735 370c0-55.227-55-45-55-10 0 34.65 45 15 25-5m-49.78-181.637C678.04 237.945 610 312.17 610 350c0 5.093 1.283 9.8 2.3 14.215m62.044-193.27C699.588 234.956 628.81 298.091 635 360c5 50 80 42.131 80 15 0-10-10-20-10-20m-11.077-186.137c32.244 85.257-86.126 177.231-5.655 208.706m-202.841 98.306C454.342 503.045 405 487.859 405 455c0-55.227 50.046-40 50-15-.038 20.557-30 20-30-5m84.928-34.41c.924 17.774-1.03 32.522-4.979 44.565m-9.56-42.229C505.677 462.548 425.848 493.313 420 455c-.754-4.943 0-10 5-20m58.387-33.371C480.063 428.243 462.64 460.556 440 455m133.47 29.539C542.263 518.869 485 516.459 485 470c0-30.414 50-35 50-10 0 30-30 20-30 10m86.762-56.23c1.294 7.934 1.676 15.399 1.285 22.381m-16.809-21.91c.742 13.433-.263 38.128-11.238 50.759-29.332 33.759-58.511 14.889-60 5-.76-5.044 1.667-7.214 5-10m53.844-50.537c-5.943 44.407-17.43 71.915-38.679 69.66m27.832-80.489C547.657 421.343 541.957 442.82 535 460m11.472-83.3c-7.367 23.266-17.815 49.94-27.695 67.154m170.61-29.462C678.846 529.449 564.058 518.475 570 465c5-45 48.843-29.973 50-5 1.184 25.56-30 25-30 5m84.25-48.742c-6.68 41.86-47.137 95.079-75.456 62.598m59.84-63.75c-4.815 30.364-15.689 53.831-42.587 59.055m27.323-65.18c-4.079 23.445-14 38.516-23.646 50.383m9.721-61.272c-1.905 17.577-8.151 33.696-15.08 48.142m-8.515-37.784c2.15 9.989 1.73 20.299.14 30.755M339.389-.607C395.396 55.572 459.429 122.37 500 200c143.73-30.414 291.688-46.681 435-30 46.784-63.186 107.047-118.153 172.359-170.041M480.44 165.793c119.65-48.512 358.657-76.625 478.363-26.286"
        />
      </symbol>
      <symbol id="JS_svg__g" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={3}
          fill="none"
          d="M1225 520c0 10 25 10 25 10m-37.917 7.977c6.055 8.81 1.09 22.643 0 22.023m-.033 14.307c6.055 8.81 1.09 22.643 0 22.023m1.51 5.514c6.056 8.81 1.09 22.643 0 22.023m8.49 5.44c6.055 8.81 1.09 22.643 0 22.023M1240 545c2.817 4.39 1.469 7.218 0 10m3.355 20.118c2.817 4.39 1.469 7.218 0 10m0 20c2.817 4.39 1.469 7.218 0 10m0 20c2.817 4.39 1.469 7.218 0 10M934 385c-10.823 1.06-23.081-1.38-33 8m-21-125c-7 1-19 18-19 18m10.437-57.705c2.222 4.098 3.563 9.406 3.563 15.205 0 12.979-6.716 23.5-15 23.5-8.284 0-15-10.521-15-23.5 0-1.889.142-3.726.41-5.485M786 243c28 0 58-31 77-31 11.5 0 12 13 12 13"
        />
        <use
          xlinkHref="#JS_svg__a"
          height={75}
          transform="matrix(.81915 .45485 -.57358 .64959 900.914 505.136)"
        />
        <use
          xlinkHref="#JS_svg__a"
          height={75}
          transform="scale(1 .793) rotate(33 -860.971 1786.543)"
        />
        <use
          xlinkHref="#JS_svg__a"
          height={75}
          transform="scale(1 .793) rotate(33 -1102.073 1738.615)"
        />
      </symbol>
      <rect
        width={211}
        height={328}
        x={-105.5}
        y={-164}
        rx={12}
        ry={12}
        fill="#fff"
        stroke="#000"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JS_svg__b" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JS_svg__b"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JS_svg__c" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JS_svg__c"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JS_svg__d" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JS_svg__d"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JS_svg__e" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JS_svg__e"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JS_svg__f" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JS_svg__f"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#JS_svg__g" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#JS_svg__g"
      />
      <use xlinkHref="#JS_svg__h" height={50} x={-104} y={-152.5} />
      <use xlinkHref="#JS_svg__a" height={41.827} x={-99.913} y={-97.5} />
      <use xlinkHref="#JS_svg__a" height={38.6} x={-63.881} y={-109.3} />
      <g transform="rotate(180)">
        <use xlinkHref="#JS_svg__h" height={50} x={-104} y={-152.5} />
        <use xlinkHref="#JS_svg__a" height={41.827} x={-99.913} y={-97.5} />
        <use xlinkHref="#JS_svg__a" height={38.6} x={-63.881} y={-109.3} />
      </g>
      <use xlinkHref="#JS_svg__i" stroke="#44F" fill="none" />
    </svg>
  );
}

export default SvgJs;
