import * as React from "react";

function SvgKh(props: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      className="KH_svg__card"
      preserveAspectRatio="none"
      viewBox="-106 -164.5 212 329"
      {...props}
    >
      <defs>
        <path id="KH_svg__i" d="M-58-112.5H58v225H-58z" />
      </defs>
      <symbol
        id="KH_svg__h"
        viewBox="-500 -500 1000 1000"
        preserveAspectRatio="xMinYMid"
      >
        <path
          d="M-285-460h200m-100 0v920m-100 0h200M85-460h200m-100 20l-355 595M85 460h200m-100-20L-10-70"
          stroke="red"
          strokeWidth={80}
          strokeLinecap="square"
          strokeMiterlimit={1.5}
          fill="none"
        />
      </symbol>
      <symbol
        id="KH_svg__a"
        viewBox="-600 -600 1200 1200"
        preserveAspectRatio="xMinYMid"
      >
        <path
          d="M0-300c0-100 100-200 200-200s200 100 200 250C400 0 0 400 0 500 0 400-400 0-400-250c0-150 100-250 200-250S0-400 0-300z"
          fill="red"
        />
      </symbol>
      <symbol id="KH_svg__b" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#FC4"
          d="M320.354 0c60.635 94.994 91.192 153.283 115.787 219.86 186.785-16.687 339.961-8.713 490.734 14.792C947.967 174.51 969.461 124.313 1065.727 0zM1090 78.564c-15 .062-30 8.936-30 31.436 0 20 14.992 80.996-5 95 26.055 40.33 25.883 70.236 3.91 91.48 5.286-7.544 3.077-21.749-12.342-23.123C1021.668 271.14 1025 320 1060 320c65.192 0 25-130 25-215 5 20 35 20 35-5 0-12.748-15-21.497-30-21.436zM1230 185c-.633 0-1.266.045-1.897.135.27 16.532-3.98 32.956-13.363 49.256 3.8 6.729 9.38 10.609 15.26 10.609 11.046 0 20-13.431 20-30 0-16.569-8.954-30-20-30zm20 30a22.5 25 0 0022.5 25 22.5 25 0 0022.5-25 22.5 25 0 00-22.5-25 22.5 25 0 00-22.5 25zm-49.88 119.84a25.003 25.003 0 00-11.3 2.799c-35.528 17.764-52.112 17.764-87.64 0a25.003 25.003 0 10-22.36 44.722c28.37 14.185 56.31 19.306 84.367 15.393l-12.595 56.838c-3.547 16.006-9.343 32.203-17.385 48.61-8.742-14.063-15.645-27.996-18.7-43.143l-11.72-58.13-33.434 48.975c-18.028 26.407-34.973 40.588-50.74 47.77-3.208 5.616-19.317 21.99-28.877 29.156l-3.338.309c.225.511.463 1.023.69 1.535-.208.132-.44.295-.637.412.274.006.548.002.822.006C1045.5 660.939 1178.456 800.588 1300 904.242v-40.715c-111.405-98.015-228.001-224.936-280.809-338.261 24.202-8.04 47.877-26.675 70.809-60.266 6.67 33.087 26.021 58.938 45 85 19.905-29.886 33.326-59.885 40-90 28.146 55.001 76.6 70.8 125 86.701v-2.834c-15.518-10.109-29.132-22.122-39.065-37.816-26.512-11.63-48.277-27.342-63.68-57.44l-26.66-52.095c13.47-2.64 26.978-7.351 40.585-14.155a25.003 25.003 0 00-11.06-47.521zM721.126 538.338l-24.783 24.312c-3.44 6.356-9.803 12.743-17.63 17.307L510.769 744.115a1384.969 1384.969 0 0122.34 80.496c15.82-16.562 15.727-42.643-.223-59.049-1.295-1.331-2.677-2.578-3.875-3.986 1.37 1.235 2.578 2.653 3.875 3.987 16.362 16.829 43.268 17.205 60.097.843 16.83-16.362 17.208-43.268.846-60.097-1.366-1.406-2.829-2.714-4.086-4.202 1.45 1.297 2.719 2.795 4.086 4.202 16.362 16.829 43.269 17.207 60.098.845 16.829-16.362 17.208-43.268.845-60.097-1.436-1.478-2.98-2.85-4.294-4.418 1.528 1.357 2.857 2.939 4.294 4.418 16.363 16.829 43.269 17.208 60.098.845 16.83-16.362 17.208-43.27.846-60.1-1.507-1.55-3.131-2.983-4.504-4.632 1.607 1.417 2.995 3.081 4.504 4.633 9.838 10.118 24.057 14.694 37.986 11.795 3.19-15.78 6.683-31.592 10.508-47.438-15.57-3.203-30.436-7.746-43.082-13.822zm-6.258 109.564c-16.829 16.363-17.208 43.269-.846 60.098 1.12 1.151 2.304 2.239 3.35 3.445-1.178-1.08-2.23-2.294-3.35-3.445-16.362-16.83-43.268-17.208-60.097-.846-16.83 16.363-17.208 43.269-.846 60.098 1.19 1.224 2.453 2.376 3.56 3.662-1.254-1.143-2.37-2.438-3.56-3.662-16.362-16.83-43.268-17.208-60.098-.846-16.829 16.362-17.207 43.27-.845 60.1 1.26 1.296 2.601 2.51 3.77 3.877-1.333-1.205-2.51-2.58-3.77-3.877-15.971-16.427-42.08-17.232-59.026-1.881a1372.761 1372.761 0 0117.916 84.4L734.19 729.773a1296.643 1296.643 0 0112.72-93.918c-11.875-.592-23.503 3.747-32.04 12.047zm241.977-69.66l-12.512 22.57a258.88 258.88 0 0126.76 30.346c40.312 53.645 61.406 120.996 61.406 192.37 0 71.373-21.093 138.725-61.406 192.37-23.732 31.58-55.716 59.03-93.498 76.514l45.037 3.34c26.85-17.853 49.977-40.256 68.447-64.834 43.835-58.332 66.42-131.092 66.42-207.39 0-76.3-22.586-149.06-66.42-207.39a283.648 283.648 0 00-34.234-37.896zm-204.823 29.742a1083.337 1083.337 0 00-3.841 20.584 1299.76 1299.76 0 013.841-20.584zm150.88 83.053c-43.345 110.769-55.473 213.145-43.954 308.992 14.996-9.728 28.7-22.9 40.196-38.199 27.3-36.329 43.355-85.002 43.355-138.303 0-50.7-14.527-97.212-39.598-132.49zM1130 741.301V1030h105l15-17.574V944.78l-43.512-53.4 33.828-37.889-43.32-41.572L1160 853.36v-79.35zM570.734 925l-14.627 14.322 4.344 30.227L570 960l20 20 20-20 20 20 20-20 20 20 20-20 20 20 20-20 2.236 2.236L729.818 925zM1160 929.314l39.627 48.631-39.627 39.63zM1090 1010c-21.1 28.415-40.88 57.831-74.309 76.92a15.002 15.002 0 00-8.064-2.76 15.002 15.002 0 00-15.1 18.834c9.715 38.859 9.69 53.517.323 81.62a15.002 15.002 0 0025.97 14.206L1090 1270c3.764-21.35 4.836-44.933-20-90 29.406-9.92 53.114-26.17 70-50-16.654-6.66-39.96-13.326-70-20 22.693-36.974 25.104-69.34 20-100zm-30.66 72.209c-2.399 5.17-5.098 10.453-8.516 16.021l-16.504 26.891 30.8 6.844c12.615 2.803 23.681 5.594 33.68 8.346-10.232 7.616-22.107 13.685-35.991 18.369l-25.506 8.605 12.992 23.574a295.225 295.225 0 018.055 15.67l-23.62-23.619a22.4 22.4 0 00-8.714-5.549c4.888-21.744 4.288-42.222-1.608-69.652.824-.36 1.634-.774 2.428-1.242 12.46-7.113 23.026-15.421 32.504-24.258zM1300 1287.623c-63.402 53.97-136.274 97.473-213.894 136.4l22.382 22.426c68.061-34.6 132.961-73.233 191.512-119.96z"
        />
      </symbol>
      <symbol id="KH_svg__c" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="red"
          d="M667.129 60.605c-7.783 7.604-17.327 14.043-28.16 18.557-4.973 22.292-14.542 41.392-27.149 56.947-57.83.427-118.196 3.301-181.547 8.973-6.181-6.936-11.54-14.351-15.539-21.9-8.068-15.23-11.816-28.962-15.193-40.678-14.958-3.78-28.374-11.3-40.654-20.223 29.074 48.754 48.962 87.641 65.6 127.744 195.865-17.398 355.944-8.977 513.148 15.522 14.905-38.016 34.875-77.296 79.129-139.66-17.868 9.1-40.337 16.83-70.18 22.222-2.84 26.208-11.877 48.573-27.486 65.252a94.42 94.42 0 01-3.928 3.955l-203.953-14.261 203.133 13.8c-65.998-9.5-133.04-16.083-202.99-18.97-9.362-15.969-15.921-34.721-18.256-55.77-10.279-5.665-19.066-13.105-25.975-21.51zM1090 345a15 15 0 00-15 15 15 15 0 0015 15 15 15 0 0015-15 15 15 0 00-15-15zm110 0a15 15 0 00-15 15 15 15 0 0015 15 15 15 0 0015-15 15 15 0 00-15-15zm-55 15a15 15 0 00-15 15 15 15 0 0015 15 15 15 0 0015-15 15 15 0 00-15-15zM747 548l-17.08 16.857a18.33 18.33 0 003.719 5.52c6.943 7.142 17.604 7.291 24.746.348a19.022 19.022 0 002.074-2.377l3.398-16.229zm-199.945 4.58c-13.256 11.369-29.45 19.387-46.059 24.488-15.724 4.83-32.378 7.76-49.045 9.995 18.804 42.607 35.625 86.046 50.39 130.656l111.374-108.91c-23.62-8.164-47.028-26.43-66.66-56.229zm-44.713 165.14l-.016.015.188.496c-.057-.17-.116-.34-.172-.511zm190.193-116.287l-23.44 22.947a18.374 18.374 0 003.6 5.25c6.944 7.142 17.604 7.291 24.746.348 7.142-6.944 7.294-17.605.35-24.747a18.361 18.361 0 00-5.256-3.798zm50.36 59.363c-3.8.369-7.525 2.043-10.598 5.031-7.142 6.944-7.292 17.604-.348 24.746.741.762 2.535 1.95 4.074 2.916zm-111.022.027l-23.59 23.092a18.426 18.426 0 003.469 4.967c6.944 7.142 17.604 7.293 24.746.35 7.142-6.944 7.291-17.607.348-24.749a18.395 18.395 0 00-4.973-3.66zM1300 690.012l-170.836.101c51.65 61.762 111.97 121.61 170.836 173.403zM683.8 719.97c-4.425-.063-8.876 1.635-12.446 5.107-7.142 6.944-7.292 17.604-.348 24.746a18.609 18.609 0 004.008 3.143l24.054-23.551a18.627 18.627 0 00-2.968-3.988c-3.472-3.571-7.873-5.395-12.3-5.457zm-112.593.246l-23.73 23.232a18.487 18.487 0 003.332 4.686c6.943 7.142 17.604 7.291 24.746.347 7.142-6.943 7.291-17.604.347-24.746a18.456 18.456 0 00-4.695-3.52zm331.207 15.656c-12.14 3.718-20.203 15.212-20.203 28.17 0 16.569 13.016 30 29.072 30 2.231 0 4.454-.265 6.766.129-.613.858-1.367.828-2.121.828-16.056 0-29.073 13.431-29.073 30 0 16.569 13.017 30 29.073 30 .615 0 1.23-.02 1.699 1.229-2.547.638-5.02.308-7.504.308-16.056 0-29.072 13.432-29.072 30 0 10.74 5.554 20.471 14.24 25.85a28.887 28.887 0 00-10.133-1.858c-16.056 0-29.072 13.432-29.072 30 0 9.245 4.13 17.973 11.521 23.424C900.532 930.563 920 878.85 920 823.527c0-30.751-6.036-60.829-17.586-87.654zm-171.394 32.18L571.2 924.543l158.576.34c-2.722-51.57-2.412-103.855 1.243-156.83zm429.222 5.037l-.242 78.85 36.947-41.237c-12.348-13.43-24.516-25.885-36.705-37.613zm-537.385 6.133c-4.425-.063-8.876 1.637-12.447 5.109-7.142 6.944-7.293 17.604-.35 24.746a18.552 18.552 0 004.286 3.297l23.927-23.432a18.56 18.56 0 00-3.117-4.263c-3.472-3.571-7.873-5.395-12.299-5.457zm-60.943 59.254c-4.426-.063-8.876 1.635-12.447 5.107-7.142 6.944-7.294 17.604-.35 24.746a18.495 18.495 0 004.557 3.447l23.8-23.302a18.509 18.509 0 00-3.261-4.543c-3.472-3.571-7.873-5.393-12.299-5.455zm678.402 15.015l-33.828 37.889 43.512 53.4v-82.447zm29.49 25.582l.313 150.926H1300V904.26c-10.062-8.522-20.156-17.08-30.193-25.186zM1160 929.314v88.26l39.627-39.629zm90 83.579L1232.318 1030h17.788zm50 17.119l-207.918.24c.98 24.864-4.379 50.904-22.082 79.748 30.04 6.674 53.346 13.34 70 20-4.213 5.945-8.85 11.418-14.428 16.93 68.457-14.52 130.475-70.542 174.428-108.885zm-1.736 164.57l-48.065 35.9 33.17 43.131-28.812 19.615-13.893-15.89 3.092-2.227 7.924 9.961 23.426-14.978-29.79-36.447-48.12 34.863 30.886 43.734-29.664 18.227-13.135-16.522 3.192-2.08 7.45 10.32 24.1-13.867-28.08-37.834-49.14 32.764 28.687 45.504-30.644 16.443-12.147-17.26 3.309-1.89 6.834 10.738 24.869-12.435-25.82-39.413-51.276 30.016 28.875 45.8-30.644 16.444-12.147-17.26 3.309-1.89 6.834 10.738 24.869-12.435-25.75-39.305-49.444 27.469 8.01 9.275 37.508-20.838 12.248 18.695-3.129 1.565-7.166-11.262-24.691 14.11 25.853 36.74 51.356-27.557-29.125-46.2 30.724-17.984 12.178 18.588-3.129 1.565-7.166-11.262-24.691 14.11 25.853 36.74 51.356-27.557-29.313-46.496 29.914-19.947 13.245 17.845-3.034 1.745-7.812-10.823-23.824 15.528 27.957 35.166 49.623-30.49-31.426-44.5 29.352-21.266 14.091 17.242-2.949 1.885-8.309-10.448-23.072 16.625 29.568 33.82 47.481-32.32v-1.254l-32.87-42.74 29.112-21.745 3.758 4.598v-18.961zm.76 25.103l-23.073 16.625 24.049 27.508v-18.232l-6.336-7.248 3.092-2.227 3.244 4.078v-19.275z"
        />
      </symbol>
      <symbol id="KH_svg__d" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#44F"
          d="M603.152 277.127a10 16.642 0 00-10 16.64 10 16.642 0 0010 16.643 10 16.642 0 0010-16.642 10 16.642 0 00-10-16.641zM480 278.357A10 16.642 0 00470 295a10 16.642 0 0010 16.643A10 16.642 0 00490 295a10 16.642 0 00-10-16.643zm720.082 21.563C1184.405 311.755 1162.228 320 1145 320c-16.299 0-32.597-8.856-44.219-17.086l1.633 35.299c34.293 17.189 50.878 17.19 86.406-.574a24.89 24.89 0 0111.239-2.795zM530 420c-10 10-24.607 13.168-25.584 14.406L500 440c8.827-11.184 57.87-5.191 88.768-8.246L580 430c-10 0-20-10-20-10s-6.717 10-16.717 10C530 430 530 420 530 420zm58.768 11.754L605 435l-5-5c-3.328.787-7.126 1.348-11.232 1.754zM1175 460c-6.674 30.115-20.095 60.114-40 90-18.979-26.062-38.33-51.913-45-85-22.902 33.546-46.544 52.183-70.799 60.172 24.822 53.374 63.838 109.79 109.856 164.808l170.943.018V546.701c-48.4-15.9-96.854-31.7-125-86.701zm-188.602 68.139c-5.778 9.181-11.348 18.312-16.767 27.652 15.487 14.084 29.388 29.297 41.435 45.328 47.354 63.015 71.434 141.176 71.434 222.408 0 81.233-24.078 159.394-71.434 222.41-3.338 4.443-6.819 8.822-10.373 13.276 2.7.03 5.287-.139 7.934-.033 1.484.059 2.865.277 4.271.455 22.058-16.13 38.06-38.99 57.032-64.54L1090 1010c1.05 6.306 1.782 12.684 2.055 19.58l37.806.42.66-289.316c-60.506-69.222-113.195-142.192-144.123-212.545zm-71.093 26.615a5 5 0 00-4.364 2.879 5 5 0 002.41 6.646 5 5 0 006.649-2.41 5 5 0 00-2.41-6.646 5 5 0 00-2.285-.47zm-118.52 8.67a5 5 0 00-4.965 4.103 5 5 0 004.024 5.815 5 5 0 005.814-4.024 5 5 0 00-4.023-5.814 5 5 0 00-.85-.08zm96.46 3.09a5 5 0 00-4.364 2.879 5 5 0 002.41 6.646 5 5 0 006.648-2.41 5 5 0 00-2.41-6.647 5 5 0 00-2.285-.468zM826.3 568.8a5 5 0 00-4.967 4.103 5 5 0 004.023 5.815 5 5 0 005.815-4.022 5 5 0 00-4.024-5.816 5 5 0 00-.847-.08zm-15.701 7.23l-20.592 57.235 12.525-12.965 1.334 20.574 6.215-19.957 9.44 17.727zm109.818 3.194a5 5 0 00-4.363 2.879 5 5 0 002.41 6.648 5 5 0 006.648-2.41 5 5 0 00-2.41-6.649 5 5 0 00-2.285-.468zm-15.54 3.171l-34.482 50.11 15.415-9.35-3.946 20.235 11.09-17.717 4.615 19.543zM737.122 609.82a53.17 53.17 0 01-.234 16.674 53.147 53.147 0 0111.787-.38l2.93-15.788c-4.824.493-9.7.323-14.483-.506zm92.875 51.41a5 5 0 00-4.707 3.805 5 5 0 003.662 6.049 5 5 0 006.049-3.662 5 5 0 00-3.662-6.049 5 5 0 00-1.342-.143zm-153.818 7.844a53.14 53.14 0 01-.235 16.674 53.17 53.17 0 0116.674.234c-.8-5.533-.72-11.165.235-16.673a53.14 53.14 0 01-16.674-.235zm134.478 7.998a5 5 0 00-4.707 3.805 5 5 0 003.662 6.049 5 5 0 006.05-3.662 5 5 0 00-3.663-6.05 5 5 0 00-1.342-.142zm29.133 7.16a5 5 0 00-4.707 3.805 5 5 0 003.662 6.049 5 5 0 006.049-3.662 5 5 0 00-3.662-6.049 5 5 0 00-1.342-.143zm-15.611 6.274l-24.033 55.879 13.29-12.18.083 20.615 7.416-19.54 8.343 18.265zm-208.944 37.82a53.14 53.14 0 01-.234 16.674 53.17 53.17 0 0116.674.234c-.8-5.533-.72-11.165.234-16.673a53.14 53.14 0 01-16.674-.235zm147.967 51.856a5 5 0 00-5.203 4.402 5 5 0 004.371 5.557 5 5 0 005.557-4.373 5 5 0 00-4.371-5.557 5 5 0 00-.354-.03zm110.397 2.289c-10.961 44.137-16.844 86.611-18.26 127.847l.193.508c4.284-4.47 9.521-7.995 15.38-10.203a43.246 43.246 0 01-2.36-14.086c0-13.505 6.336-25.728 16.191-33.564-6.465-7.527-10.387-17.353-10.387-27.973 0-10.72 3.993-20.632 10.567-28.186-4.72-3.987-8.568-9.008-11.324-14.343zm-319.307 5.11c.8 5.532.72 11.163-.234 16.67a53.164 53.164 0 0116.673.235c-.8-5.533-.72-11.163.235-16.672a53.14 53.14 0 01-16.674-.234zm275.484 2.724a5 5 0 00-4.705 4.402 5 5 0 004.373 5.557 5 5 0 005.557-4.371 5 5 0 00-4.373-5.559 5 5 0 00-.352-.03 5 5 0 00-.5 0zm-84.338 7.959a5 5 0 00-4.705 4.402 5 5 0 004.373 5.557 5 5 0 005.557-4.373 5 5 0 00-4.371-5.557 5 5 0 00-.354-.03 5 5 0 00-.5 0zm30.145 3.548a5 5 0 00-.355.006 5 5 0 00-4.706 4.403 5 5 0 004.374 5.556 5 5 0 005.556-4.373 5 5 0 00-4.37-5.556 5 5 0 00-.499-.035zm36.93 6.575a5 5 0 00-4.705 4.402 5 5 0 004.373 5.557 5 5 0 005.556-4.371 5 5 0 00-4.373-5.559 5 5 0 00-.351-.03 5 5 0 00-.5 0zM760 810l-17.04 58.393 11.708-13.71 2.596 20.452 4.976-20.301 10.51 17.113zm82.654 1.936a5 5 0 00-.353.006 5 5 0 00-4.705 4.402 5 5 0 004.37 5.557 5 5 0 005.56-4.374 5 5 0 00-4.374-5.556 5 5 0 00-.498-.035zm-15.58 8.187l-17.039 58.393 11.707-13.71 2.596 20.452 4.976-20.301 10.51 17.113zM790 905a5 5 0 00-5 5 5 5 0 005 5 5 5 0 005-5 5 5 0 00-5-5zm-15 20a5 5 0 00-5 5 5 5 0 005 5 5 5 0 005-5 5 5 0 00-5-5zm30 0a5 5 0 00-5 5 5 5 0 005 5 5 5 0 005-5 5 5 0 00-5-5zm-15 10l-10 60 10-15 5 20 2.537-20.748L810 995zm41.168 85.121a5 5 0 00-.5 0 5 5 0 00-4.703 5.281 5 5 0 005.281 4.703 5 5 0 004.703-5.28 5 5 0 00-4.781-4.708zm-70.5 2.992a5 5 0 00-.996.074 5 5 0 00-4.055 5.793 5 5 0 005.793 4.055 5 5 0 004.055-5.793 5 5 0 00-4.797-4.129zM1300 1038.551c-44.498 38.33-106.275 93.932-174.578 108.53-14.742 14.61-33.5 25.524-55.422 32.919 24.836 45.067 23.764 68.65 20 90l-71.174-71.176c-3.786 4.87-10.37 7.082-16.574 5.014-5.29-1.763-8.93-6.182-9.961-11.27-13.782 4.594-43.373 14.458-63.361 21.008 21.407 40.022 46.899 78.808 75.71 116.182 109.286-57.819 212.278-117.477 295.36-193.248zm-307.709 154.017l.766-.254-.916-.597c.04.286.093.569.15.851zm-144.992-153.347a5 5 0 00-.5 0 5 5 0 00-4.703 5.281 5 5 0 005.279 4.703 5 5 0 004.703-5.281 5 5 0 00-4.78-4.707zm-68.383.98a5 5 0 00-.996.074 5 5 0 00-4.055 5.793 5 5 0 005.793 4.055 5 5 0 004.055-5.793 5 5 0 00-4.797-4.129zm38.432.754a5 5 0 00-.5 0 5 5 0 00-4.703 5.28 5 5 0 005.28 4.702 5 5 0 004.704-5.28 5 5 0 00-4.781-4.706zm-67.977 4.461a5 5 0 00-.994.074 5 5 0 00-4.055 5.793 5 5 0 005.793 4.055 5 5 0 004.055-5.793 5 5 0 00-4.799-4.13zm83.03 4.658l-4.727 43.863 21.556-1.671zm-67.514 2.656l.58 60.825 7.24-16.51 8.4 18.828L780 1095l15.01 13.342zm153.299 174.526L915 1245l-12.563-16.346 5.95 20.037-17.711-9.468 42.275 47.04zm-86.875 19.826l-4.45 17.469-11.361-17.203 4.5 20.412-16.986-10.713 38.797 49.95zm117.337 32.783a5 5 0 00-1.943.416 5 5 0 00-2.59 6.58 5 5 0 006.58 2.59 5 5 0 002.59-6.58 5 5 0 00-4.637-3.006zm-27.51 11.969a5 5 0 00-1.943.414 5 5 0 00-2.59 6.58 5 5 0 006.58 2.59 5 5 0 002.59-6.58 5 5 0 00-4.636-3.004zm-63.359 9.897a5 5 0 00-.353 0 5 5 0 00-1.467.279 5 5 0 00-3.055 6.377 5 5 0 006.377 3.055 5 5 0 003.055-6.377 5 5 0 00-4.557-3.336zm85.094 2.459a5 5 0 00-1.943.414 5 5 0 00-2.592 6.58 5 5 0 006.58 2.59 5 5 0 002.59-6.579 5 5 0 00-4.635-3.005zm-113.39 7.507a5 5 0 00-.352 0 5 5 0 00-1.469.28 5 5 0 00-3.055 6.377 5 5 0 006.377 3.054 5 5 0 003.055-6.377 5 5 0 00-4.557-3.336zm82.398.373L910 1330l-13.723-15.385 7.397 19.55-18.354-8.15 45.598 43.829zm-61.606 13.508a5 5 0 00-.353 0 5 5 0 00-1.467.28 5 5 0 00-3.055 6.376 5 5 0 006.377 3.055 5 5 0 003.055-6.377 5 5 0 00-4.557-3.336zm96.33 36.72a5 5 0 00-2.408.573 5 5 0 00-2.101 6.75 5 5 0 006.75 2.104 5 5 0 002.103-6.75 5 5 0 00-4.344-2.676zm-26.562 13.946a5 5 0 00-2.406.572 5 5 0 00-2.104 6.75 5 5 0 006.752 2.104 5 5 0 002.102-6.752 5 5 0 00-4.344-2.674zm83.164 6.662l-1.88 17.93-13.725-15.385L995 1405l-18.354-8.148 45.596 43.826zm-60.586 4.073a5 5 0 00-2.408.572 5 5 0 00-2.102 6.752 5 5 0 006.75 2.103 5 5 0 002.104-6.752 5 5 0 00-4.344-2.675zm-28.383 15.498L910 1420l-11.566-17.064 4.744 20.355-17.114-10.508 18.98 23.838 16.612 5.371zm123.694 30.656a5 5 0 00-2.409.572 5 5 0 00-2.101 6.752 5 5 0 006.75 2.103 5 5 0 002.103-6.751 5 5 0 00-4.343-2.676zm-26.563 13.945a5 5 0 00-2.406.572 5 5 0 00-2.104 6.752 5 5 0 006.75 2.102 5 5 0 002.104-6.75 5 5 0 00-4.344-2.676zm-70.357 9.73a5 5 0 00-1.465.3 5 5 0 00-2.596 2.165l2.543 7.205a5 5 0 003.488.02 5 5 0 002.979-6.412 5 5 0 00-4.45-3.277 5 5 0 00-.5 0zm92.935 1.006a5 5 0 00-2.408.573 5 5 0 00-2.102 6.75 5 5 0 006.75 2.103 5 5 0 002.104-6.75 5 5 0 00-4.344-2.676z"
        />
      </symbol>
      <symbol id="KH_svg__e" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path d="M631.533 181.016c-65.078-.14-133.435 2.914-206.787 9.697l11.316 29.096c186.863-16.635 340.041-8.662 490.852 14.755l10.643-28.699c-98.204-15.511-197.56-24.617-306.024-24.85zm441.235 226.17l-8.416 18.14c49.738 23.015 104.155 24.04 154.31 3.076l-7.596-18.488c-45.316 19.084-93.23 18.174-138.298-2.728zM550 505c-11.907 39.688-58.598 53.443-109.68 57.092 3.89 7.731 7.575 15.85 11.309 24.242 16.989-1.506 33.643-4.436 49.367-9.266 16.608-5.1 32.803-13.12 46.059-24.488 19.632 29.798 43.039 48.065 66.508 56.377L502.245 717.459c2.784 8.362 5.57 17.043 8.428 26.354L678.96 579.81C647.595 599.015 588.798 596.705 550 505zm419.578 51.05l-12.732 22.192a283.648 283.648 0 0134.234 37.897c43.834 58.33 66.42 131.09 66.42 207.388 0 76.3-22.585 149.06-66.42 207.391-18.47 24.578-41.597 46.98-67.844 64.816 28.153 1.637 55.37 3.01 68.64 3.559.2-8.479 7.05-15.48 15.751-15.133 3.496.14 6.72 1.482 8.64 3.213 32.85-19.533 52.63-48.954 73.733-77.373l-20.07-14.904c-18.973 25.549-34.974 48.41-57.032 64.539-1.406-.178-2.787-.396-4.271-.455-2.647-.106-5.234.063-7.87.181 3.49-4.602 6.971-8.981 10.31-13.424 47.355-63.016 71.433-141.177 71.433-222.41 0-81.232-24.08-159.393-71.434-222.408a308.439 308.439 0 00-41.488-45.068zm77.533 20.95l3.727 6H1300v-6zm12.473 20l4.055 6H1300v-6zm12.5 18.5l6.297 9H1300v-9zm16.828 23.5l9.031 12H1300v-12zm17.93 23.5l12.015 15H1300v-15zm-372.664 67.47L551.063 909.272l5.044 30.051 174.946-171.3zM1250 862.335V1030h20V880.371zM570 960l-9.549 9.549 4.422 35.451h171.262l-3.899-42.764L730 960l-20 20-20-20-20 20-20-20-20 20-20-20-20 20zm521.46 89l-1.78 12h184.168l13.994-12zm-3.913 21.5l-2.953 9h166.777l10.963-9zm-5.852 16.5l-2.638 6h154.533l7.908-6zM1300 1136.51c-83.082 75.77-186.077 135.418-295.393 193.078l18.997 23.951c99.8-52.704 195.444-107.903 276.396-177.014z" />
      </symbol>
      <symbol id="KH_svg__f" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={6}
          fill="none"
          d="M520.672.153c16.67 52.963 65.937 55.088 68.644 99.564 2.733 44.917-59.291 48.358-61.783 3.427-1.684-30.367 33.643-31.912 35.304-1.958.83 14.977-21.234 16.2-22.065 1.224M514.21.15c-10.564 54.813-59.517 62.308-57.284 106.91 2.25 44.943 64.274 41.504 61.782-3.427-1.684-30.367-36.965-27.996-35.304 1.958.83 14.977 22.896 13.753 22.065-1.224M832.117.151c6.783 59.167 64.416 69.896 59.33 115.354-5.005 44.72-74.794 36.48-69.518-8.209 3.567-30.204 43.242-25.102 39.725 4.69-1.76 14.897-26.587 11.966-24.828-2.93M826.81.195c-20.59 55.294-78.71 52.502-84.329 97.72-5.548 44.656 64.24 52.897 69.517 8.208 3.567-30.204-36.206-34.484-39.724-4.69-1.759 14.896 23.069 17.827 24.828 2.93m118.068 52.953a94.44 94.44 0 003.928-3.956c15.61-16.679 24.647-39.044 27.486-65.252 29.844-5.393 52.312-13.122 70.105-21.993m-147.452 84.829c31.576-11.865 50.335-38.363 48.176-88.74 91.849-10.838 107.24-38.865 143.197-62.268M358.634 61.953c12.533 9.25 25.95 16.772 40.907 20.552 3.377 11.716 7.126 25.447 15.194 40.677 4 7.549 9.357 14.965 16.11 21.901m44.984-3.605c-42.083-20.39-40.427-54.229-53.771-86.258-27.123.768-57.764-24.581-87.183-55.161m276.804 136.233c12.678-15.588 22.298-34.751 27.29-57.13 10.833-4.513 20.377-10.953 28.16-18.556 6.909 8.405 15.696 15.844 25.974 21.51 2.335 21.048 8.895 39.8 18.479 55.837M666.439.097c-8.125 28.527-21.5 51.555-54.118 55.484-3.388 40.084-20.275 65.198-45.133 81.449M750 140c-18.053-18.314-28.71-43.235-27.843-78.429C690 54.081 679.26 29.526 674.32.086m390.801.688c-95.775 123.77-117.196 173.859-138.283 233.966M320.681.467c60.503 94.809 90.905 152.9 115.537 219.446m-11.472-29.2c195.606-18.087 355.686-9.666 512.811 15.153m-501.494 13.942c186.863-16.634 340.04-8.66 490.85 14.757m-521.538-87.207c211.068-20.772 383.092-11.45 551.221 15.99m-77.583 929.778c-49.154-164.682-27.33-350.915 107.386-564.987 57.772 131.42 191.479 271.967 313.637 376.139m-192.618 541.58c-72.615-72.347-134.279-149.487-178.48-232.4M-.016 673.518c108.131-86.3 237.929-144.972 369.274-201.67m394.895 80.269c-77.421 322.261-23.657 629.834 95.19 885.7M510.827 744.4l168.292-164.786m-65.62 29.264L502.325 717.734m16.563 53.76c76.098-74.51 152.193-149.024 228.29-223.535M557.657 950H731.37m-180.306-40.728l183.115-179.3m4.544-39.44l-193.306 189.28m10.691 59.51l174.945-171.3M729.818 925H570.734M385 505c-10 0-19.402 28.553 5 30 18.973 1.125 40-45 0-45-45 0-40.13 73.839 9.87 73.839C464.79 563.839 535 555 550 505c55 130 150.188 80.355 150 45-.147-27.73-35-30-40-15-6.834 20.501 10 30 25 15M560.451 969.549L570 960l20 20 20-20 20 20 20-20 20 20 20-20 20 20 20-20 2.236 2.236M589.452 702.391a42.5 42.5 0 014.376 3.918 42.5 42.5 0 01-.846 60.098 42.5 42.5 0 01-60.098-.845 42.5 42.5 0 01-3.614-4.242m181.589-177.803a42.5 42.5 0 014.856 4.286 42.5 42.5 0 01-.846 60.099 42.5 42.5 0 01-60.098-.846 42.5 42.5 0 01-3.974-4.732m-.64.63a42.5 42.5 0 014.614 4.102 42.5 42.5 0 01-.845 60.098 42.5 42.5 0 01-60.098-.845 42.5 42.5 0 01-3.796-4.487m-61.28 60.012a42.5 42.5 0 014.132 3.728 42.5 42.5 0 01.162 59.084m-.019.083a42.5 42.5 0 0159.11 1.776 42.5 42.5 0 013.523 4.12m.493-.484a42.5 42.5 0 01-4.016-3.636 42.5 42.5 0 01.845-60.098 42.5 42.5 0 0160.098.845 42.5 42.5 0 013.339 3.876m97.254-171.116a42.5 42.5 0 01-37.958-12.209 42.5 42.5 0 01-4.152-4.979m6.006 128.431a42.5 42.5 0 01-3.545-3.255 42.5 42.5 0 01.845-60.098 42.5 42.5 0 0132.055-11.96M656.86 770.7a42.5 42.5 0 01-3.78-3.447 42.5 42.5 0 01.846-60.098 42.5 42.5 0 0160.098.846 42.5 42.5 0 013.153 3.634m-21.04-148.685l25.117-24.594m-269.51 48.202c16.875-1.73 33.528-4.659 49.252-9.489 16.608-5.1 32.803-13.12 46.059-24.488 19.632 29.798 43.04 48.065 66.573 56.457m335.512-85.78c48.707 15.886 96.192 7.172 140.86-58.257 6.67 33.087 26.021 58.938 45 85 19.905-29.886 33.326-59.885 40-90 28.14 54.988 76.577 70.79 124.966 86.687m.05 316.87c-111.462-98.064-228.128-225.082-280.902-338.452M893.151 717.069A132.614 176.472 0 01920 823.53v0a132.614 176.472 0 01-64.023 151.033m2.616 25.862c15.352-10.124 29.055-23.296 40.552-38.594 27.3-36.329 43.355-85.002 43.355-138.303 0-50.7-14.527-97.213-39.442-132.898m-25.462 401.784c37.782-17.484 69.766-44.935 93.498-76.515 40.313-53.645 61.406-120.997 61.406-192.37 0-71.374-21.094-138.725-61.406-192.37a258.885 258.885 0 00-26.76-30.345m-21.701 494.938c26.85-17.853 49.977-40.255 68.447-64.833 43.835-58.331 66.42-131.092 66.42-207.39 0-76.3-22.586-149.06-66.42-207.39a283.649 283.649 0 00-34.234-37.896m43.783 480.822a306.753 306.753 0 0010.437-13.127c47.356-63.016 71.434-141.177 71.434-222.41 0-81.232-24.08-159.393-71.434-222.408a308.435 308.435 0 00-41.488-45.068m193.615-158.325l-12.601 56.866c-3.547 16.006-9.343 32.203-17.385 48.61-8.742-14.063-15.645-27.996-18.7-43.143l-11.72-58.13-33.434 48.975c-18.028 26.407-34.973 40.59-50.74 47.77m242.323 7.376c-26.513-11.63-48.278-27.34-63.68-57.439l-26.666-52.107M985.512 529.677c52.75-39.677 73.688-93.201 97.756-145.363m116.851-49.474a25.003 25.003 0 00-11.299 2.799c-35.528 17.764-52.112 17.764-87.64 0a25.003 25.003 0 10-22.36 44.722c44.472 22.236 87.888 22.236 132.36 0a25.003 25.003 0 00-11.06-47.521v0m2.129 51.562c25.841 72.738 56.575 130.842 97.73 157.772m.03 743.446c-63.403 53.972-136.28 97.475-213.904 136.404m213.947-247.52c-80.96 69.126-176.631 124.323-276.448 177.035m276.43-217.036c-83.085 75.78-186.103 135.42-295.427 193.084M1092.024 1030H1300m-140-100.686l39.627 48.631-39.627 39.63m0-88.26v0m90 15.466l-43.512-53.4 33.828-37.89m-43.32-41.57L1160 853.36m72.426 176.64l17.574-17.574M1130 741.3V1030m30-255.99V1030m58.49-197.108l-51.424 57.6L1240 980l-50 50m60-167.666V1030m20-149.629V1030m-140.906-340H1300m-292.373 394.16a15.002 15.002 0 00-15.1 18.834c9.715 38.859 9.69 53.517.323 81.62a15.002 15.002 0 1028.459 9.486c10.632-31.898 10.607-57.24.322-98.381a15.002 15.002 0 00-14.004-11.559v0m11.193 114.66L1090 1270c3.764-21.35 4.836-44.933-20-90 29.406-9.92 53.114-26.17 70-50-16.654-6.66-39.96-13.326-70-20 22.693-36.974 25.104-69.34 20-100-21.104 28.419-40.883 57.84-74.32 76.927m285.041-49c-44.55 38.349-106.667 94.503-175.681 109.494m-133.303-47.843c-27.67-1.433-116.826-7.325-142.059-7.325-55 0-78.958 27.747-9.678 27.747m250-110l-20.07-14.904c-18.973 25.549-34.974 48.41-57.032 64.539-1.406-.178-2.787-.396-4.271-.455-2.647-.106-5.234.064-7.869.182M900 1175c-40 0-60 5-80 5-30 0-40 25-10 25h82.857M890 1145c-5 0-60 5-80 5s-45 25 0 30m75-60h-45c-40 0-75 25-35 30m188.056 42.315L910 1220c-15 5-25 10-35.965 16.139C847.496 1250.995 840 1225 855 1215c15-10 25-10 25-10m144.382-97.28c.832-.363 1.652-.78 2.454-1.253 12.46-7.113 23.026-15.421 32.504-24.258-2.399 5.17-5.098 10.453-8.516 16.021l-16.504 26.891 30.8 6.844c12.615 2.803 23.681 5.594 33.68 8.345-10.232 7.617-22.107 13.686-35.991 18.37l-25.506 8.605 12.992 23.574a295.225 295.225 0 018.055 15.67l-23.62-23.619a22.406 22.406 0 00-8.815-5.587m74.733-874.55l3.001 36.016m96.351-38.95v35.009M1085 105c0 85 40.192 215-25 215-35 0-38.333-48.86-13.432-46.642C1065 275 1064.564 294.986 1055 300c25.797-21.415 27.524-52.396 0-95 19.992-14.004 5-75 5-95 0-45 60-35.495 60-10 0 25-30 25-35 5v0m6.905 191.162C1102.49 304.942 1123.745 320 1145 320c30 0 75-25 75-50 0-11.753-4.42-23.507-9.105-32.662m-121.94-73.746c3.17-2.072 8.088-3.592 16.045-3.592 25 0 35 15 40 15 18.229 0 23.951 24.45-5 25-19.996.38-30-20-30-20 6.156 14.159 16.642 29.114 5 40 35.23 6.8 45.444 29.923 45 60m-40.466-117.823c.078-3.881.23-7.94.466-12.177m28.51 49.16c-5.509 37.794-22.847 36.236-27.74-6.066m-20.532-32.75c1.3-12.08 7.921-19.139 19.762-25.344 21.11-11.063 28.913 21.391 29.933 40.77m-9.915-35.647c39.55-34.246 38.251 71.703 34.982 79.877-8.15 20.377-26.266 27.467-29.98-5.804m22.005-71.096c23.913-20.97 40.376 17.032 35.512 51.079-6.248 43.735-27.345 61.842-30.05 31.063m23.194-77.205c21.886-13.738 37.104 22.058 31.555 54.051-7.883 45.456-31.28 48.413-27.637 6.775m28.504-23.728c.63-.09 1.264-.135 1.897-.135 11.046 0 20 13.431 20 30v0c0 16.569-8.954 30-20 30-5.88 0-11.46-3.88-15.26-10.61M1295 215a22.5 25 0 01-22.5 25 22.5 25 0 01-22.5-25 22.5 25 0 0122.5-25 22.5 25 0 0122.5 25v0m-341.742-45h112.004m-151.248 85h160.773M1150 235c14.42 7.861 26.457 17.773 30 35M917.772 854.94a29.072 30 0 01-1.844.06 29.072 30 0 01-29.072-30 29.072 30 0 0129.072-30 29.072 30 0 012.261.09m-.279-1.837a29.072 30 0 01-6.627.79 29.072 30 0 01-29.072-30 29.072 30 0 0119.991-28.5m-1.55 179.359a29.072 30 0 01-19.602-28.364 29.072 30 0 0129.072-30 29.072 30 0 017.362.978m-50.203 106.67a29.072 30 0 01-11.194-23.657 29.072 30 0 0129.072-30 29.072 30 0 0115.406 4.559m-43.942 56.35c.482.465.975.919 1.481 1.362m15.606-190.68a43.011 43.011 0 0011.212 14.693c-6.574 7.554-10.567 17.466-10.567 28.186 0 10.62 3.922 20.446 10.387 27.973-9.855 7.836-16.191 20.06-16.191 33.564 0 4.88.825 9.63 2.36 14.086-5.859 2.208-11.096 5.733-15.38 10.203m41.266-186.62a41.097 41.097 0 00-7.334 3.659M735 485c0-35-35-35-35 5s55 20 55-15c0-50-75-40-75 10 0 64.14 114.105 78.021 179.105 73.021 64.638-4.972 129.54-48.49 130.074-113.317.746-90.608-65.255-127.78-81.056-212.611M707.267 530.174C755.952 531.731 775 510 775.484 463.588 776.263 389.015 710 380 715.528 213.414m5.696 324.97l.095.004m217.015-7.12c22.326-20.788 35.47-55.564 35.726-86.564.752-91.32-65.077-128.36-79.996-214.62m34.43 307.052c20.323-22.527 30.2-62.56 30.446-92.432.758-92.031-64.87-128.934-78.907-216.646m29.508 318.055c22.985-22.02 34.019-69.663 34.28-101.409.763-92.7-64.571-129.467-77.772-218.566m27.903 325.49c23.373-22.23 34.486-74.908 34.75-106.924.768-93.264-64.098-129.913-76.573-220.198m28.431 330.446c22.26-23.704 32.765-78.976 33.022-110.248.773-93.798-63.556-130.33-75.343-221.753m24.5 334.775c24.186-21.868 35.456-80.458 35.724-113.022.777-94.313-62.965-130.73-74.092-223.264m22.102 337.387c25.054-20.935 36.598-80.996 36.87-114.123.781-94.806-62.32-131.11-72.82-224.72m20.733 339.022c25.2-20.769 36.695-81.08 36.968-114.302.784-95.182-61.497-131.396-71.498-225.836m19.976 339.766c24.885-21.108 36.131-80.904 36.403-113.93.787-95.558-60.656-131.681-70.17-226.958m19.776 340.003c24.172-21.849 35.007-80.47 35.275-113.045.79-95.934-59.796-131.964-68.833-228.085m20.088 339.691c23.221-22.885 36.265-79.83 33.625-111.606C815 350 760 325 755.378 215.488m13.21 337.535c27.376-21.005 42.47-72.122 39.16-108.319C800 360 745 355 741.642 214.755m5.537 333.204c34.297-15.474 48.467-62.336 47.09-91.76C790 365 730 375 727.914 214.05m25.919 269.68c3.03-18.431 4.706-21.397 3.976-32.609-4.37-67.102-66.312-43.674-57.35-238.486M685 550c-25 35-75.399 8.408-100-45m75.345 46.462C638.381 543.637 616.831 525.685 605 500m116.224 38.385c-5.457 7.64-12.899 12.661-21.454 15.286m-37.93-21.843C645.219 525.066 629.78 511.233 620 490m86.506 39.951c-26.158.828-55.97-16.223-71.506-49.951m51.413 29.317C672.032 502.229 658.868 489.251 650 470m30.252 12.308c-7.07-6.296-13.187-14.37-17.789-24.36m23.407 5.25c-4.097-5.395-7.768-11.464-10.87-18.198m25.973 3.333C696.834 442.905 693.128 436.79 690 430m29.672 12.515c-5.644-6.262-10.639-13.76-14.672-22.515M385 535c48.677 7.959 64.36-29.036 64.212-70.306C449.06 422.457 425 380 435 340m-42.2 222.915c48.677 7.959 69.286-55.309 69.138-96.579C461.786 424.1 435 400 435 340m4.649 222.422c23.015-15.528 34.298-51.968 36.048-81.286m-14.296 79.033C479.426 542.504 488.451 510.96 490 485m-5.707 70.811C497.096 537.654 503.696 511.849 505 490m1.532 58.498C514.629 532.015 518.969 512.271 520 495m8.437 40.999c3.735-11.97 5.878-24.53 6.563-35.999M435 340s5.983 80.02 5 105c-1.551 39.429-75 77.649-75 0 0-50 60-45 60-5s-45 30-45 5 35-20 35 0m9.54-96.806c-1.9 17.88-8.926 27.048-7.487 40.238C417.889 396.104 425 415 425 440m22.585-222.507C443.343 230.942 435 258.813 435 270c0 15 5 25 5 50 0 40-70 55-70 0 0-45 60-55 60-15s-40 30-40 10 25-20 25-5m21.84-90.784c-5.712 10.94-12.324 26.063-12.324 37.426C424.516 277.258 430 305 430 305m5.41-40.41S450 245 470 245c20 0 30 10 40 10 5 0 15-10 15-10v10c-5 0-9.815 4.889-15 5-5 0-30-15-35-15m195 15s-35-20-45-20c-15 0-35 10-45 10s-25-5-25-5v5c8.447 0 20.18 5.024 25 5 4.955-.025 30-15 45-15m-100 15s10 25 10 30-20 50-20 60-10 35-10 40 15 15 20 15 20-10 30-15c4.472-2.236 10 10-30 15m40-35c25 0 28.892 24.48 11.232 30.895-6.715 2.439-16.724-1.567-18.133-9.111M505 425l-10 20 10-10v-10 0m100 0l5 20-10-15 5-5v0m-105 15l4.415-5.594C505.393 433.167 520 430 530 420c0 0 0 10 13.284 10 10 0 16.716-10 16.716-10s10 10 20 10l25 5-5-5c-28.367 6.712-90-2.67-100 10v0m30 10c16.912 17.225 30 15 45 0M440 295c20 0 30.345-16.238 40.337-15.821C500 280 505 295 515 295c-5 0-15 15-40 15-15 0-15-15-35-15v0m205 0c-20 0-30.345-16.238-40.337-15.821C585 280 580 295 570 295c5 0 15 15 40 15 15 0 15-15 35-15v0m375-110l-25 30 30 25m-49.092-25H995m-35 25l35-55v55"
        />
      </symbol>
      <symbol id="KH_svg__g" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={3}
          fill="none"
          d="M801.772 1151.052c4.937 11.411 3.38 18.269.82 27.537m3.708 3.763c4.938 11.41 3.996 13.137 1.437 22.406m-1.026-79.458c4.937 11.41 3.79 14.368 1.231 23.637M946.25 185h118.228m-125.875 18.333h118.167m-125.18 18.334h132.955M910 240h161.887M1145 215c10.035-1.681 20.034.026 30 5m-52.495-14.373c10.034-1.68 14.697-1.616 24.663 3.358m28.826 11.569c10.035-1.681 10.182-1 20.148 3.973m4.063-.217c10.035-1.68 9.607-2.45 19.572 2.524M1135 170c-5 10 21.253 16.102 24.957 15.288M1185 180c3.035-2.388 6.419-1.983 10 0m15.041 4.31c3.035-2.388 6.419-1.982 10 0m-62.956-11.494c3.035-2.388 6.42-1.982 10 0M840 1130c2.311 4.324 1.48 7.301 0 10m-1.026 17.504c2.311 4.324 1.48 7.301 0 10m4.105 20.583c2.311 4.324 1.48 7.301 0 10M445 295c10 0 15 24.165 35.337 24.59C500 320 520 295 525 295m120.817.406c-10 0-15 24.164-35.337 24.589-19.663.41-39.663-24.59-44.663-24.59M440 295c15 0 23.452-28.016 40-30 12.603-1.51 35 15 35 15m130 0s-29.105-16.413-41.708-14.902c-16.548 1.983-25 30-40 30C570 295 575 320 575 320m-135-20c2.621 18.998 24.184 33.085 25 30m40 70c-15 15-21.764 25.737-30 40m120-50c5 20 33.235 43.592 35 40m-95 60c5-20 25-15 35-5m-76.008-202.265A14.758 20 0 01495 290v0a14.758 20 0 01-10.671 19.218m-6.207.574A14.758 20 0 01465.484 290a14.758 20 0 01.34-4.27m18.505 23.488a14.758 20 0 01-4.087.782 14.758 20 0 01-2.12-.208m138.692-25.54a14.758 20 0 01.928 6.98v0a14.758 20 0 01-9.415 18.643m-13.531-2.005a14.758 20 0 01-6.57-16.638 14.758 20 0 011.104-7.589m18.997 26.232a14.758 20 0 01-5.343 1.357 14.758 20 0 01-8.188-3.362M780 560l-20.952 14.505M780 575l-24.725 17.117M780 590l-28.277 19.576m26.14-3.096l-29.289 20.276m25.926-2.948l-28.955 20.046m25.883-2.92l-28.496 19.729m25.734-2.817l-28.21 19.53m25.597-2.72l-27.772 19.226m25.567-2.7l-27.53 19.059m25.42-2.598l-27.18 18.816m25.423-2.6l-26.909 18.63m25.295-2.512l-26.654 18.453m25.292-2.51l-26.335 18.232m25.187-2.438l-26.166 18.115m25.186-2.436l-25.814 17.871m25.097-2.375l-25.688 17.784m24.763 12.857l-25.237 17.472m25.55-32.689l-25.34 17.542m24.765 12.856l-24.9 17.239m24.966-2.284l-24.824 17.185m24.924-2.255l-24.525 16.979m24.925-2.256l-24.445 16.924m24.894-2.235l-24.183 16.742m24.897-2.236l-24.098 16.683m24.879-2.224l-23.866 16.523m24.88-2.224l-23.78 16.462m24.873-2.22l-23.568 16.317m24.873-2.22l-23.485 16.26m24.877-2.224l-23.292 16.125m24.88-2.224l-23.219 16.075m24.897-2.236l-23.039 15.95m24.897-2.237l-22.974 15.905m24.922-2.254l-22.8 15.786m24.923-2.256l-22.752 15.752m85.11-104.105l29.28 39.317m-30.661-66.735l27.282 36.636m-27.388-62.34l25.407 34.117m-24.552-58.531l23.892 32.082m-22.088-55.223l22.72 30.51m-20.216-52.71l21.66 29.087m-18.525-50.439l20.92 28.092m-17.218-48.684l20.272 27.222m-16.058-47.125l19.704 26.46m-15.029-45.745l19.21 25.796m-14.113-44.514l18.778 25.216m-13.3-43.423l18.402 24.71m-12.576-42.449l18.074 24.27m-11.93-41.582l17.79 23.889M880.22 681.02l17.545 23.559m-10.844-40.123l17.334 23.276m-10.389-39.513l17.264 23.182m-10.094-39.117l17.082 22.94m-9.688-38.572l16.905 22.7m-9.26-37.997l16.803 22.564m-8.983-37.626l16.527 22.193m-8.541-37.032l16.544 22.217m-8.387-36.826l16.435 22.07m-7.963-36.256l16.128 21.659M845.13 1099.827c2.312 4.324 1.481 7.3 0 10m-31.983-13.297c4.937 11.41 3.175 13.548.615 22.816M835 1005l29.279 34.317M840 1035l32.973 37.19m-28.384-4.316l24.014 24M882.183 1230c-7.183-7.504-32.183 5-32.183 5m-99.535-135.997l31.225 28.995m-26.434-4.546l32.021 29.734m-26.656-4.752L793.539 1179m-26.929-5.005l33.92 31.497m-27.253-5.306l35.039 32.536m-27.634-5.66l36.292 33.7m-28.084-6.078l37.697 35.004m-28.606-6.563l39.273 36.468m-29.219-7.132l41.381 38.425m-30.092-7.942l43.045 39.97m-30.326-8.16L870 1410m-23.976-2.264L870 1430m233.343 11.683l-5.248 8.568m-4.79-18.85l-13.468 21.99m3.431-32.271l-13.468 21.989m3.602-32.55l-13.575 22.164m3.768-32.821l-13.576 22.164m3.803-32.877l-13.612 22.223m4.056-33.29l-13.707 22.378m4.152-33.448l-13.708 22.382m4.314-33.713l-13.869 22.643m4.591-34.164l-13.869 22.642m4.618-34.207l-13.895 22.685m4.925-34.71l-14.065 22.964m5.094-34.986l-14.064 22.96m5.315-35.344l-14.284 23.32m5.655-35.9l-14.302 23.348m3.716-39.402l-14.502 23.676m6.25-36.87l-14.59 23.82m6.438-37.18l-14.689 23.98m6.859-37.866l-14.941 24.393m6.721-37.642l-11.436 18.67"
        />
        <use
          xlinkHref="#KH_svg__a"
          height={90}
          transform="scale(1 .793) rotate(85 -10.105 1042.096)"
        />
        <use
          xlinkHref="#KH_svg__a"
          height={90}
          transform="matrix(.5 .68676 -.86603 .3965 974.471 653.253)"
        />
        <use
          xlinkHref="#KH_svg__a"
          height={90}
          transform="matrix(-.34202 .74518 -.9397 -.27122 1032.677 889.672)"
        />
        <use
          xlinkHref="#KH_svg__a"
          height={90}
          transform="scale(-1 -.793) rotate(-50 -1842.956 426.96)"
        />
      </symbol>
      <rect
        width={211}
        height={328}
        x={-105.5}
        y={-164}
        rx={12}
        ry={12}
        fill="#fff"
        stroke="#000"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KH_svg__b" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KH_svg__b"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KH_svg__c" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KH_svg__c"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KH_svg__d" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KH_svg__d"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KH_svg__e" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KH_svg__e"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KH_svg__f" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KH_svg__f"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KH_svg__g" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KH_svg__g"
      />
      <use xlinkHref="#KH_svg__h" height={50} x={-104} y={-152.5} />
      <use xlinkHref="#KH_svg__a" height={41.827} x={-99.913} y={-97.5} />
      <use xlinkHref="#KH_svg__a" height={38.6} x={-62.434} y={-109.3} />
      <g transform="rotate(180)">
        <use xlinkHref="#KH_svg__h" height={50} x={-104} y={-152.5} />
        <use xlinkHref="#KH_svg__a" height={41.827} x={-99.913} y={-97.5} />
        <use xlinkHref="#KH_svg__a" height={38.6} x={-62.434} y={-109.3} />
      </g>
      <use xlinkHref="#KH_svg__i" stroke="#44F" fill="none" />
    </svg>
  );
}

export default SvgKh;
