import * as React from "react";

function SvgKs(props: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      className="KS_svg__card"
      preserveAspectRatio="none"
      viewBox="-106 -164.5 212 329"
      {...props}
    >
      <defs>
        <path id="KS_svg__i" d="M-58-112.5H58v225H-58z" />
      </defs>
      <symbol
        id="KS_svg__h"
        viewBox="-500 -500 1000 1000"
        preserveAspectRatio="xMinYMid"
      >
        <path
          d="M-285-460h200m-100 0v920m-100 0h200M85-460h200m-100 20l-355 595M85 460h200m-100-20L-10-70"
          stroke="#000"
          strokeWidth={80}
          strokeLinecap="square"
          strokeMiterlimit={1.5}
          fill="none"
        />
      </symbol>
      <symbol
        id="KS_svg__a"
        viewBox="-600 -600 1200 1200"
        preserveAspectRatio="xMinYMid"
      >
        <path d="M0-500c100 250 355 400 355 685a150 150 0 01-300 0 10 10 0 00-20 0c0 200 50 215 95 315h-260c45-100 95-115 95-315a10 10 0 00-20 0 150 150 0 01-300 0c0-285 255-435 355-685z" />
      </symbol>
      <symbol id="KS_svg__b" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#FC4"
          d="M332.371 0c88.22 119.616 128.095 183.372 160.656 258.629 185.6-26.833 338.984-27.211 490.813-11.951 18.004-61.954 36.983-113.766 129.2-246.678zM599.64 515.951l-80.883 8.145c28.994 102.605 53.965 208.515 65.23 318.31 45.728 12.112 90.839 10.199 145.258-2.66 18.212-90.03 50.36-181.392 99.776-273.039L825 555l-5 10c-6.315 3.149-12.962 3.442-20.098 5.691-9.127 2.878-18.921 7.52-28.443 10.034-12.15 3.206-24.488 9.021-34.227 5.265-2.956-1.14-6.434 5.099-9.558 5.686-30.626 66.529-53.395 133.098-69.197 198.908C645.8 695 624.1 603.592 599.639 515.951zm464.431 16.25C937.675 700.998 894.134 856.195 889.97 1012.398c-4.019 150.705 31.809 303.815 77.965 460.891l29.755-5.18c-46.286-157.24-81.64-308.365-77.732-454.91 4.08-152.977 46.234-303.127 173.451-470.092zm40.96 22.576c-6.332 12.11-12.94 24.243-2.12 34.828l-.605.928c-7.812-2.064-16.084-3.577-24.594-4.804 4.907 6.63 9.911 13.032 15.139 18.908l.148.162-.133.201c-13.847-2.911-25.317-1.308-31.523 16.498 36.516-9.692 77.407 41.578 93.658 13.662 19.09-26.057-44.254-43.037-49.97-80.383zM922.675 582.87c-52.25 89.741-85.238 178.049-103.754 265.162l.625-3.574c-72.77 24.696-130.935 38.697-187.996 35.686-46.96-2.479-91.36-17.02-139-43.938l6.045 70.266c42.383 19.49 85.215 31.237 129.793 33.59 59.632 3.147 116.435-8.74 179.431-28.579l.366-2.086c-25.803 186.762 10.545 368.227 61.087 546.794l29.702-5.303c-41.414-146.031-72.926-292.295-68.985-440.088 3.66-137.267 37.13-276.21 122.848-420.254zm135.972 48.19c-5.838 12.354-11.953 24.742-.716 34.884l.746 1.245c-8.273-1.914-17.053-3.17-26.08-4.104 5.142 6.395 10.372 12.559 15.677 18.426-14.076-2.122-25.11-.069-30.595 17.972 36.096-11.152 79.018 38.432 94.133 9.885 18.026-26.803-45.951-41.223-53.165-78.308zm-45.416 78.002c-3.708 13.151-7.683 26.384 5.08 34.521l-1.494.975c-7.732-.343-15.77-.114-23.963.408 6.233 5.542 12.515 10.832 18.846 15.681-14.213.13-25.103 3.985-27.52 22.686 33.747-16.986 84.3 24.793 94.47-5.865 13.33-29.422-52.153-33.032-65.419-68.406zM979.792 789.7c-3.12 13.304-6.5 26.7 6.613 34.262L984.811 825c-7.697.009-15.665.594-23.776 1.475 6.798 5.522 13.638 10.767 20.576 15.353l-.756.486c-14.135.626-25.195 4.087-26.777 22.877 32.957-18.471 85.319 21.015 94.113-10.066 12.008-29.987-53.57-30.677-68.398-65.426zM1150 873.262c-25 0-40 28.656-40 50 0 45 60.558 39.404 63.46 16.922 1.54-11.922-18.46-36.922-18.46-36.922 29.5-1.394 55.467 25.08 85 25 17.4-.047 45-15 45-15-.209-10.805 7.894-19.65 0-35-25 10-92.95-5-135-5zm-74.178 62.332c-14.874 145.4 90.63 322.342 169.905 450.613 20.904-10.57 39.29-21.058 54.273-31.178v-100.633c-20.325-34.637-47.214-80.735-61.924-111.625 2.523-.845 5-1.942 7.389-3.318 7.699-4.327 10.438-14.291 6.02-21.945-4.428-7.669-14.459-10.277-22.061-5.737l.076-.045c-5.123 2.958-6.953.96-7.631-.214-.678-1.175-1.492-3.757 3.63-6.715l-.073.043c6.723-3.756 9.28-11.437 7.744-17.752-1.537-6.315-7.336-11.962-15.033-12.21a15.997 15.997 0 00-8.674 2.233c-10.106 5.85-16.822 15.49-19.033 25.885 1.285-7.914 5.43-14.987 11.6-20.396-64.96-8.967-89.069-50.869-70.643-126.3-20.211-6.353-38.718-13.671-55.565-20.706zm-426.513 5.658c-23.724.182-47.177 9.732-42.457 28.648L605 970c-75-75-75 135 0 60l1.926-.188c-10.12 38.448 95.555 38.583 86.252.407L695 1030c75 75 75-135 0-60l-1.61-1.191c3.637-18.553-20.358-27.739-44.081-27.557zm315.712 107.746a33.541 33.541 0 00-12.443 2.363c-18.627 7.36-27 29.555-19.348 48.989 3.147 8.257 12.606 12.434 20.829 9.185 8.235-3.254 12.289-12.794 8.914-20.98l.033.082c-2.173-5.5.068-7.017 1.33-7.516 1.261-.498 3.935-.926 6.11 4.576l-.032-.078c2.729 7.202 9.952 10.857 16.424 10.264 6.472-.593 12.909-5.5 14.283-13.078a16.002 16.002 0 00-.941-8.92c-5.775-14.552-19.179-24.082-33.377-24.838a34.094 34.094 0 00-1.781-.049zm.114 12.004c.393 0 .787.015 1.18.037 9.43.54 18.63 6.935 22.73 17.309a6 6 0 00.033.078c.292.708.373 1.483.236 2.236-.434 2.396-1.798 3.109-3.572 3.271-1.774.163-3.242-.288-4.105-2.566a6 6 0 00-.031-.08c-4-10.121-14.04-14.344-21.678-11.326-7.639 3.018-12.082 12.964-8.082 23.086a6 6 0 00.033.082c.88 2.133-.083 4.398-2.229 5.246-2.145.848-4.396-.147-5.212-2.305a6 6 0 00-.034-.084c-5.465-13.831.527-28.701 12.582-33.465a21.809 21.809 0 018.149-1.52zm252.615 25.87c2.434.077 3.339 1.323 3.76 3.054.42 1.73.19 3.25-1.936 4.437a6 6 0 00-.074.043c-9.425 5.442-12.128 15.993-8.021 23.106 4.106 7.113 14.596 10.047 24.021 4.605a6 6 0 00.076-.045c1.981-1.183 4.364-.562 5.518 1.436 1.153 1.998.497 4.37-1.518 5.494a6 6 0 00-.076.045c-12.88 7.436-28.47 3.69-34.951-7.535-6.481-11.226-1.928-26.6 10.951-34.035a6 6 0 00.072-.043 3.999 3.999 0 012.178-.563zm-186.35 21.32a33.75 33.75 0 00-12.445 2.363c-18.629 7.36-26.998 29.56-19.344 48.994 3.15 8.254 12.605 12.43 20.827 9.182 8.235-3.255 12.288-12.796 8.912-20.983l.033.084c-2.174-5.502.07-7.019 1.332-7.518 1.26-.498 3.933-.925 6.107 4.577l-.029-.078c2.729 7.201 9.95 10.857 16.422 10.263 6.472-.593 12.91-5.5 14.285-13.078a16 16 0 00-.94-8.912c-5.772-14.556-19.177-24.09-33.378-24.846a34.09 34.09 0 00-1.781-.049zm.112 12.003c.393 0 .787.015 1.18.037 9.43.54 18.633 6.935 22.732 17.309a6 6 0 00.03.078c.292.708.374 1.485.237 2.238-.435 2.397-1.797 3.107-3.57 3.27-1.774.162-3.245-.29-4.108-2.567a6 6 0 00-.029-.078c-3.999-10.121-14.04-14.346-21.68-11.328-7.638 3.019-12.08 12.965-8.081 23.086a6 6 0 00.033.084c.88 2.133-.083 4.398-2.229 5.246-2.146.848-4.397-.148-5.213-2.306a6 6 0 00-.03-.082c-5.466-13.832.526-28.703 12.581-33.467a21.806 21.806 0 018.147-1.52zm39.017 63.867a33.548 33.548 0 00-12.445 2.364c-18.63 7.361-27.002 29.562-19.344 48.998 3.15 8.251 12.606 12.426 20.826 9.178 8.236-3.255 12.288-12.796 8.912-20.983l.033.082c-2.173-5.502.07-7.017 1.333-7.516 1.26-.498 3.935-.925 6.109 4.577l-.031-.078c2.729 7.201 9.951 10.856 16.424 10.263 6.472-.593 12.908-5.5 14.283-13.078a16 16 0 00-.94-8.912c-5.772-14.556-19.178-24.09-33.379-24.846a34.09 34.09 0 00-1.78-.049zm.112 12.004c.393 0 .786.015 1.18.037 9.43.54 18.633 6.935 22.732 17.309a6 6 0 00.03.078c.292.708.376 1.485.239 2.238-.435 2.395-1.8 3.107-3.572 3.27-1.774.162-3.245-.29-4.108-2.567a6 6 0 00-.029-.08c-3.999-10.121-14.04-14.344-21.68-11.326-7.638 3.019-12.08 12.965-8.081 23.086a6 6 0 00.033.082c.88 2.133-.083 4.4-2.229 5.248-2.146.848-4.397-.148-5.213-2.306a6 6 0 00-.03-.082c-5.466-13.832.526-28.704 12.581-33.467a21.806 21.806 0 018.147-1.52zm16.986 75.674c-4.162 0-8.367.752-12.445 2.363-18.63 7.362-27.002 29.563-19.344 48.999 3.15 8.251 12.606 12.425 20.826 9.177 8.236-3.254 12.288-12.796 8.912-20.982l.033.082c-2.174-5.502.07-7.017 1.332-7.516 1.261-.498 3.934-.926 6.108 4.576l-.03-.078c2.73 7.202 9.95 10.857 16.423 10.264 6.472-.593 12.91-5.5 14.285-13.078.544-3 .214-6.091-.94-8.912-5.773-14.556-19.178-24.09-33.379-24.846a34.09 34.09 0 00-1.78-.049zm.111 12.004c.394 0 .787.015 1.18.037 9.43.54 18.633 6.935 22.732 17.309a6 6 0 00.031.078c.292.708.373 1.485.237 2.238-.435 2.395-1.797 3.107-3.57 3.27-1.774.162-3.245-.29-4.108-2.567a6 6 0 00-.029-.08c-4-10.121-14.041-14.344-21.68-11.326-7.638 3.018-12.081 12.964-8.082 23.086a6 6 0 00.033.084c.88 2.133-.083 4.398-2.228 5.246-2.146.848-4.397-.148-5.213-2.307a6 6 0 00-.031-.082c-5.465-13.83.526-28.703 12.582-33.466a21.804 21.804 0 018.146-1.52zm-11.049 70.318a33.539 33.539 0 00-12.443 2.364c-18.628 7.36-27 29.555-19.348 48.988 3.147 8.258 12.607 12.437 20.83 9.188 8.236-3.255 12.289-12.796 8.913-20.983l.033.082c-2.174-5.5.068-7.017 1.33-7.516 1.26-.498 3.935-.925 6.11 4.577l-.032-.078c2.73 7.201 9.952 10.856 16.424 10.263 6.472-.593 12.909-5.5 14.283-13.078a16.004 16.004 0 00-.941-8.92c-5.775-14.551-19.179-24.082-33.377-24.838a34.093 34.093 0 00-1.781-.049zm.114 12.004c.393 0 .786.015 1.18.037 9.43.54 18.63 6.935 22.73 17.309a6 6 0 00.033.078c.291.708.373 1.485.236 2.238-.435 2.395-1.799 3.107-3.572 3.27-1.774.162-3.243-.29-4.106-2.567a6 6 0 00-.03-.08c-4-10.121-14.04-14.344-21.678-11.326-7.639 3.019-12.082 12.965-8.082 23.086a6 6 0 00.033.082c.88 2.133-.083 4.4-2.229 5.248-2.146.848-4.397-.148-5.213-2.307a6 6 0 00-.033-.081c-5.465-13.832.527-28.704 12.582-33.467a21.815 21.815 0 018.149-1.52zm-35.864 63.29a33.64 33.64 0 00-12.564 2.359c-13.538 5.35-21.707 18.63-22.17 32.836a5.972 5.972 0 00.236 2.023l11.756-1.635c.323-9.91 5.834-18.605 14.588-22.064 10.645-4.206 23.183.562 29.78 11.27l11.136-3.487a5.972 5.972 0 00-.92-2.808c-7.024-11.403-19.233-18.435-31.842-18.495z"
        />
      </symbol>
      <symbol id="KS_svg__c" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="red"
          d="M1063.855 74.14c-16.796 9.186-38.81 18.127-68.316 25.137-1.408 26.324-9.214 49.148-23.893 66.653-1.202 1.434-2.439 2.822-2.595 4.093-66.403-6.154-134.794-9.184-205.836-8.234-10.058-15.437-17.63-33.803-21.108-54.693-10.571-5.098-19.75-12.047-27.107-20.063-7.357 8.016-16.536 14.965-27.107 20.063-3.766 22.616-12.33 42.275-23.98 58.43-57.34 3.454-117.218 9.573-180.354 18.689-7.012-6.523-12.766-13.635-17.17-20.955-8.886-14.768-13.377-28.275-17.387-39.79-15.141-2.959-28.947-9.738-41.596-17.831 39.72 59.09 64.243 103.531 85.621 152.99 185.6-26.833 338.984-27.211 490.813-11.951 14.163-48.744 28.92-91.214 80.015-172.537zM631.25 517.679c12.857 46.61 24.927 94.429 35.215 143.566a1102.15 1102.15 0 0130.486-74.451C692.254 591.912 686.672 595 680 595c-35 0-35-55-5-55 1.104 0 2.153.047 3.15.139l.032-4.166c-3.097 0-6.747-1.444-10.776-4.926-7.033 2.308-16.951-.168-29.98-10.996l-6.176-2.373zm-112.303 7.236c-3.4 1.443-7.108 1.325-10.445.607-5.154 2.776-11.14 3.815-17.307 3.133-7.1 3.304-14.759 4.815-21.384 4.977-6.126 3.943-13.686 5.475-20.649 5.197-4.962 2.125-10.335 3.31-15.55 3.576l-3.077.727c23.862 84.24 44.58 169.124 57.108 255.08 34.357 21.767 65.384 36.156 96.232 44.166-11.154-109.766-36.124-215.677-64.928-317.463zM882.594 540c.332 1.554.658 3.132.984 4.705a17.665 17.665 0 00-.984-4.705zm.984 4.705c1.647 22.867-39.548 48.846-54.555 21.899-49.419 91.75-81.567 183.112-99.939 273.18 29.59-6.869 61.992-17.033 98.812-29.878 19.534-74.69 50.125-150.34 94.78-227.037L920 580c-4.41-.46-7.89-1.827-10.854-3.994-16.64 13.079-21.019-9.376-25.568-31.3zm54.356 318.344c-9.752 43.517-15.15 87.12-17.202 131.314 61.286 16.615 114.557 51.92 154.989 99.57-16.406-53.788-24.859-108.222-19.383-160.261l1.139-5.83c-51.719-22.576-91.088-43.981-119.543-64.793zm-437.948 77.11c.973 38.662-.274 77.16-4.332 115.915 21.829-6.643 43.462-12.363 64.522-17.142-15.434-18.337-15.07-62.02.71-78.735-20.597-5.083-40.924-11.952-60.9-20.039zm619.356 12.726c.468 11.838 1.41 23.773 2.79 35.781-20.373 17.422-34.992 41.351-17.132 93.002 15.15-13.305 22.607-27.593 25.412-42.473a622.43 622.43 0 006.21 26.528c-17.93 21.262-29.693 47.628-1.622 96.873 12.074-15.399 16.85-30.374 17.139-45.084a788.186 788.186 0 0011.53 31.566c-15.026 21.492-22.595 48.026 6.331 93.004 10.628-15.157 14.751-29.585 14.746-43.549a951.618 951.618 0 0013.697 28.375c-12.855 23.328-17.944 50.77 16.557 92.707 8.569-15.887 11.078-30.367 9.684-43.935a1078.48 1078.48 0 0014.255 24.146c-10.218 21.529-13.17 46.4 14.21 81.26l12.667-6.51c3.03-10.33 3.601-19.996 2.38-29.178a1141 1141 0 0013.81 19.952l10.822-5.489a1114.226 1114.226 0 01-31.312-46.545c13.609 10.764 26.352 14.905 38.484 15.368v-31.22c-15.23-9.97-32.81-15.197-55.041-10.997a1042.886 1042.886 0 01-24.34-43.067c25.411 24.093 48.688 22.655 70.676 16.6-21.216-25.494-44.8-46.759-83.27-40.992a919.54 919.54 0 01-22.51-48.56c27.23 29.25 52.074 28.098 75.48 21.73-21.209-25.643-44.815-47.034-83.526-41.188-8.885-22.267-16.694-44.642-23.25-66.96 12.1 13.392 23.73 20.737 34.97 24.224l4.909-15.29 8.195-10.566c-19.783-2.658-35.776-8.372-47.943-17.17a85.62 85.62 0 00-5.223.516 629.645 629.645 0 01-1.564-6.111c-22.162-20.87-27.655-55.176-16.04-103.27l-12.181-3.478zM650 980a25 20 0 00-25 20 25 20 0 0025 20 25 20 0 0025-20 25 20 0 00-25-20zm315.078 75c-3.458-.01-6.94.615-10.297 1.941-15.349 6.065-22.531 24.613-15.957 41.25a10.001 10.001 0 1018.602-7.35c-3.087-7.81.257-13.541 4.707-15.3 4.45-1.758 10.806.14 13.892 7.951a10.001 10.001 0 0019.194-1.758 10.001 10.001 0 00-.592-5.591c-5.136-12.999-17.199-21.109-29.549-21.143zm252.865 25.875a10.001 10.001 0 00-5.443 1.406c-15.493 8.945-21.398 27.938-13.147 42.23 8.252 14.293 27.654 18.676 43.147 9.731a10.001 10.001 0 10-10-17.32c-7.274 4.2-13.434 1.734-15.826-2.41-2.392-4.144-1.448-10.71 5.826-14.91a10.001 10.001 0 00-4.557-18.727zm-186.486 33.318c-3.458-.01-6.94.615-10.297 1.942-15.349 6.065-22.531 24.614-15.957 41.252a10.001 10.001 0 1018.6-7.352c-3.087-7.812.257-13.542 4.707-15.3 4.45-1.759 10.806.139 13.892 7.95a10.001 10.001 0 0019.194-1.757 10.001 10.001 0 00-.592-5.592c-5.136-12.998-17.197-21.109-29.547-21.143zm-105.71 26.91c9.926 91.34 31.685 184.916 59.03 281.69C1007.052 1392.032 1020 1352.658 1020 1310c0-73.27-38.2-136.853-94.254-168.897zm144.839 48.961c-3.458-.01-6.94.615-10.297 1.942-15.349 6.065-22.531 24.612-15.957 41.25a10.001 10.001 0 1018.6-7.35c-3.087-7.811.256-13.542 4.707-15.3 4.45-1.759 10.808.139 13.894 7.95a10.001 10.001 0 0019.192-1.757 10.001 10.001 0 00-.592-5.592c-5.136-12.998-17.197-21.108-29.547-21.143zm81.713 77.766A328.794 328.794 0 011155 1310c0 42.7-8.201 84.137-23.326 122.363 34.332-11.638 67.211-24.66 96.61-36.662-23.817-37.787-50.71-81.531-75.985-127.87zm-64.615 9.912c-3.458-.01-6.94.615-10.297 1.942-15.35 6.065-22.532 24.614-15.957 41.252a10.001 10.001 0 1018.6-7.352c-3.087-7.812.256-13.542 4.706-15.3 4.45-1.759 10.806.139 13.893 7.95a10.001 10.001 0 0019.193-1.757 10.001 10.001 0 00-.591-5.592c-5.137-12.999-17.197-21.109-29.547-21.143zm-10.938 82.322a27.717 27.717 0 00-10.295 1.942c-15.349 6.065-22.533 24.612-15.959 41.25a10.001 10.001 0 1018.602-7.35c-3.087-7.811.257-13.542 4.707-15.3 4.45-1.759 10.806.139 13.892 7.95a10.001 10.001 0 0019.194-1.757 10.001 10.001 0 00-.592-5.592c-5.136-12.998-17.199-21.108-29.549-21.143zm-35.775 75.291c-3.49-.02-7.003.601-10.39 1.94-11.147 4.404-17.987 15.393-18.38 27.451l55.47-13.748c-5.985-9.717-16.233-15.579-26.7-15.643z"
        />
      </symbol>
      <symbol id="KS_svg__d" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#44F"
          d="M799.328 293.695a11.451 19.017 0 00-11.453 19.016 11.451 19.017 0 0011.453 19.018 11.451 19.017 0 0011.451-19.018 11.451 19.017 0 00-11.45-19.016zm141.42 3.899a11.451 19.017 0 00-11.451 19.017 11.451 19.017 0 0011.451 19.016A11.451 19.017 0 00952.2 316.61a11.451 19.017 0 00-11.45-19.017zm15.084 125.63c-.403-.01-.817-.008-1.242.003C944.593 423.492 940 435 940 435s7.228-7.706 15.049-7.947c15.886-.49-1.401 32.752-15.049 32.947-9.9.141-30-25-50-25v10c20 0 35.734 19.84 50 20 23.033.257 41.22-41.17 15.832-41.775zm-205.832.06c-24.988.769-25.073 52.423 6.025 51.306C783.412 473.606 815 445 860 445v-10c-55 2.54-60.544 24.922-100 32.16-25.561 4.689-26.812-35.184-10-37.16 9.932-1.167 10 17.332 10 17.332.288.046 10-24.665-10-24.049zm-171.355 91.935l-39.819 6.3c1.757 6.234 3.5 12.481 5.227 18.743l19.27-5.219a15.001 15.001 0 0119.001 12.486A15 15 0 01571.164 564l-19.287 5.223c.323 1.219.642 2.441.963 3.662l19.318-4.977a15 15 0 0118.844 12.72c.886 7.535-3.99 14.545-11.361 16.333l-19.33 4.978c.316 1.264.636 2.527.95 3.791l19.489-4.724a15 15 0 0118.662 12.986 15.001 15.001 0 01-11.594 16.17l-19.494 4.725c.268 1.138.528 2.279.793 3.418l19.43-4.387a15.002 15.002 0 116.605 29.264l-19.437 4.388c.257 1.181.512 2.363.767 3.545l19.69-4.08a15.002 15.002 0 116.09 29.375l-19.692 4.082c.24 1.21.49 2.418.729 3.63l19.738-3.698a15 15 0 012.53-.29c7.868-.23 14.577 5.662 15.365 13.495.787 7.833-4.614 14.942-12.371 16.283l-19.74 3.697c.346 1.948.677 3.9 1.017 5.85l19.824-3.256c.837-.15 1.685-.228 2.535-.234 7.875-.059 14.454 5.982 15.067 13.834.612 7.851-4.95 14.84-12.739 16.004l-19.822 3.256c.259 1.674.526 3.345.78 5.021l19.9-2.79c.84-.129 1.69-.187 2.539-.173 7.875.126 14.312 6.321 14.74 14.186.428 7.864-5.3 14.72-13.115 15.699l-19.887 2.787c.171 1.32.327 2.645.494 3.967l20.002-2.309c.843-.11 1.694-.147 2.543-.113 7.866.323 14.143 6.67 14.38 14.539.235 7.869-5.651 14.582-13.483 15.375l-19.996 2.309c.319 3.053.647 6.105.945 9.166l40.555 3.546c-10.704-117.113-36.56-228.626-66.455-335.053zm228.224 50.76c-2.608 1.168-6.12.488-9.408 2.45-5.49 3.276-10.728 8.784-12.809 4.952-5.704 10.459-13.446 8.3-17.004 5.836-6.338 5.023-7.062 5.092-13.25 2.418-43.388 89.803-71.918 179.659-88.082 268.023l27.844-3.664-6.57-1.365c-7.645-1.476-12.89-8.555-12.076-16.299.814-7.743 7.416-13.576 15.2-13.43 1.001.02 1.997.139 2.973.356l19.428 4.033.367-1.64-19.287-4.657a15 15 0 01-11.632-15.933 15.002 15.002 0 0118.675-13.229l19.256 4.65c.286-1.112.57-2.225.86-3.337l-19.098-5.303a15.002 15.002 0 118.027-28.906l19.074 5.296a986.7 986.7 0 011.041-3.525l-18.9-5.943a15.002 15.002 0 119-28.617l18.879 5.935c.333-1.006.675-2.013 1.012-3.02l-18.69-6.56a15.002 15.002 0 119.938-28.307l18.68 6.557c.454-1.238.916-2.475 1.376-3.713l-18.464-7.18a15.002 15.002 0 1110.873-27.96l18.466 7.181c.467-1.15.935-2.3 1.407-3.45l-18.223-7.778a15.002 15.002 0 1111.78-27.59l18.234 7.783c.395-.889.79-1.777 1.187-2.666l-17.969-8.344a15.001 15.001 0 1112.635-27.209l17.986 8.354a1074.637 1074.637 0 0117.264-34.2zM1280 635l-.414 244.9a34.516 34.516 0 005.414-1.638c7.894 15.35-.209 24.195 0 35 0 0-16.38 8.87-31.86 12.967-4.612 1.22-9.145 2.022-13.14 2.033-29.533.08-55.5-26.394-85-25 0 0 5.674 7.092 10.84 15.613 26.603 3.639 36.977 19.387 59.16 19.387 2.37 0 4.672.492 6.818 1.36l19.924-7.48-.115.643c52.27-12.885 60.404 14.8 13.373 30.477a233.42 233.42 0 01-8.041 2.5c45.309.323 44.386 24.242-5.64 32.681-4.86.82-9.39 1.419-13.594 1.819l.105 3.15c60.358-2.457 63.623 25.99 7.922 32.506l-2.727 2.348c48.493-.363 49.542 26.361 1.643 32.652l-3.355 4.795c13.874 5.134 23.687 17.772 23.687 32.549 0 15.64-10.99 28.884-26.633 33.285 13.983 31.05 41.112 77.807 61.633 112.83V648.309l-.012-.495A782.318 782.318 0 001280 635zm-100.041 43.84c-63.681 93.4-92.263 173.702-104.22 256.683 16.803 7.056 35.37 14.398 53.775 20.051-11.66-6.462-19.514-16.105-19.514-32.312 0-21.344 15-50 40-50 8.72 0 18.553.645 29.443 1.658zM503.82 855.87l-9.638 19.036 13.62 6.1-3.667 8.012-5-2.62c-3.58-1.976-6.447 3.498-2.783 5.315l10.605 5.557 8.82-19.268-13.4-6 4.111-8.12c3.42 1.698 6.837 3.378 10.24 4.94 4.102 1.884 8.194 3.62 12.286 5.326l-4.461 10.938-6.791 16.674 2.767 1.136a369.21 369.21 0 0018.063 6.872c6.287 2.205 12.59 4.229 18.922 6.013l2.867.807 5.842-20.162-2.909-.82c-4.977-1.403-9.953-3.059-14.931-4.778l2.918-8.326c4.84 1.682 9.678 3.287 14.511 4.672 4.614 1.321 9.254 2.44 13.903 3.496l-2.631 11.664-3.941 17.568 2.888.68a288.074 288.074 0 0019.42 3.86 288.392 288.392 0 0020.66 2.646l2.973.27 2-20.903-3.004-.271c-5.463-.496-10.89-1.262-16.31-2.106l1.43-8.883c5.233.83 10.475 1.572 15.743 2.067 3.872.363 7.758.65 11.659.855.916.049 1.873.052 2.808.084l-.402 11.934-.596 18.015 2.96.137c6.122.28 12.201.324 18.259.22 6.506.22 14.433-.849 20.162-.948l3.17-.055-1.53-21.098-3 .229c-5.257.398-10.5.58-15.744.699v-9.002c5.017-.145 10.037-.34 15.084-.715 5.647-.419 11.353-1.066 17.088-1.806l1.563 12.097 2.262 17.863 2.966-.365a412.095 412.095 0 0019.809-2.95 466.4 466.4 0 0018.807-3.645l2.923-.63-4.351-20.542-2.944.634c-5.07 1.093-10.075 2.023-15.07 2.916l-1.59-9.046c4.877-.833 9.773-1.726 14.725-2.774 4.77-1.009 9.608-2.148 14.47-3.322l2.887 11.758 4.239 17.517 2.906-.691c6.12-1.455 12.3-3.066 18.531-4.774a677.01 677.01 0 0017.506-5.04l2.857-.868-5.994-20.125-2.884.875c-4.803 1.456-9.48 2.764-14.13 4.033l-2.415-8.78a610.19 610.19 0 0013.898-3.909 966.991 966.991 0 0014.87-4.553l9.589 30.246L810 900l-1.83-5.883-9.555-30.13-2.857.904a963.241 963.241 0 01-17.625 5.398c-5.645 1.669-11.209 3.254-16.645 4.682l-2.935.77 5.605 20.37 2.873-.763c4.681-1.246 9.47-2.645 14.29-4.078l2.572 8.63c-4.869 1.45-9.709 2.863-14.485 4.172-5.207 1.427-10.334 2.726-15.437 3.975l-2.823-11.662-4.31-17.557-2.92.723a511.392 511.392 0 01-17.2 3.949c-5.89 1.246-11.708 2.37-17.423 3.283l-3.008.48 3.676 20.915 2.945-.506c5.059-.87 10.168-1.893 15.297-2.961l1.863 8.803c-5.232 1.09-10.449 2.134-15.629 3.029-5.55.959-11.06 1.744-16.56 2.467l-1.502-11.864-2.33-18.017-3.002.42a303.96 303.96 0 01-19.715 2.084c-5.929.44-11.824.724-17.7.84l-2.94.056v20.975l3.035-.035c5.386-.063 10.769-.362 16.154-.72l.65 8.993c-5.695.292-11.964.934-16.732.77l-.078-.002-.078.002c-5.007.087-10.017-.015-15.034-.184l.397-11.994.61-18.063-3.124.022c-1.82.012-3.675-.068-5.572-.168-3.82-.202-7.622-.48-11.412-.836-6.144-.577-12.242-1.356-18.295-2.402l-2.992-.518-3.336 20.752 2.941.492c5.548.928 11.13 1.585 16.725 2.158l-.858 8.963c-5.775-.59-11.537-1.274-17.27-2.215-5.393-.885-10.75-2.002-16.1-3.199l2.619-11.67 3.94-17.478-2.972-.631c-5.482-1.162-10.96-2.564-16.443-4.135a261.648 261.648 0 01-17.008-5.476l-2.85-1.032-6.892 19.67 2.808 1.004c5.09 1.817 10.185 3.39 15.284 4.889l-2.504 8.642c-5.245-1.539-10.486-3.157-15.725-4.996-4.996-1.753-9.985-3.697-14.972-5.697l4.503-11.059 5.282-12.947a3 3 0 00.545-2.375 3 3 0 00-2.743-2.607 363.195 363.195 0 01-26.695-12.195zm310.932 4.384l-8.547 2.85 4.316 12.949zm105.05 165.312c-.4 26.81.575 53.887 2.667 80.92C997.676 1139.338 1050 1218.98 1050 1310c0 57.227-20.683 109.955-54.734 149.438l2.181 8.9a894.069 894.069 0 0032.34-6.865 982.936 982.936 0 0018.697-4.52c15.352-3.869 30.797-7.91 45.66-12.627 19.678-40.69 30.856-86.571 30.856-134.326 0-131.706-85.022-249.159-205.197-284.434zM965 1050a35 35 0 0135 35 35 35 0 01-35 35 35 35 0 01-35-35 35 35 0 0135-35zm66.531 59.353a35 35 0 0135 35 35 35 0 01-35 35 35 35 0 01-35-35 35 35 0 0135-35zm-82.508 66.819a22.509 22.509 0 00-14.787 5.795l-2.916 2.556 3.512 16.873 9.375-8.222a7.5 7.5 0 00.08-.07 7.493 7.493 0 015.295-1.928c3.766.135 5.835 2.216 6.814 5.03.98 2.813.652 5.73-2.216 8.175a7.5 7.5 0 00-.08.068l-15.756 13.819 6.154 29.564 28.98-12.266a7.5 7.5 0 00.098-.04 7.495 7.495 0 012.686-.63c3.697-.164 6.87 2.275 7.662 5.891.791 3.616-1.073 7.158-4.502 8.553a7.5 7.5 0 00-.098.04l-31.71 13.42 4.952 23.794 35.403-3.987a7.5 7.5 0 00.105-.016 7.498 7.498 0 011.272-.053 7.5 7.5 0 00.004 0c4.006.173 7.066 3.283 7.175 7.291.11 4.008-2.778 7.28-6.769 7.67a7.5 7.5 0 00-.11.012l-34.01 3.832 5.854 28.123 26.885 4.912a7.5 7.5 0 00.098.02c4.215.713 6.897 4.541 6.129 8.746-.769 4.205-4.632 6.837-8.826 6.012a7.5 7.5 0 00-.098-.019l-20.889-3.816 3.3 15.855 14.796 2.703h.002c12.217 2.4 24.232-5.787 26.47-18.035 2.239-12.249-6.107-24.155-18.384-26.23l-24.207-4.424 24.451-2.754c11.688-1.142 20.622-11.268 20.303-23.008-.32-11.738-9.79-21.36-21.522-21.867h-.004a22.74 22.74 0 00-3.81.158l.105-.014-16.04 1.807 14.825-6.275c10.098-4.107 15.834-15.006 13.504-25.655-2.33-10.649-12.094-18.154-22.984-17.668a22.507 22.507 0 00-8.057 1.881h-.004l-20.217 8.557 16.674-14.625-.08.068c7.545-6.432 9.455-16.475 6.652-24.524-2.802-8.049-10.537-14.733-20.445-15.087a23.49 23.49 0 00-1.094-.012zm15.766 169.148l-3.299-15.853-1.287-.235 3.807 15.946zm-9.152-43.976l-3.07-14.75-2.313.26 3.348 14.718zm-8.024-38.543l-3.115-14.969-2.125.898 2.953 15.04zm-9.27-44.533l-3.511-16.872-.793.696 2.934 17.379zm133.1-33.442a35 35 0 0135 35 35 35 0 01-35 35 35 35 0 01-35-35 35 35 0 0135-35zm16.692 87.807a35 35 0 0135 35 35 35 0 01-35 35 35 35 0 01-35-35 35 35 0 0135-35zm-10.885 82.002a35 35 0 0135 35 35 35 0 01-35 35 35 35 0 01-35-35 35 35 0 0135-35zm-35.559 75.472a35 35 0 0131.703 20.17l-66.675 16.211a35 35 0 01-.027-1.38 35 35 0 0135-35z"
        />
      </symbol>
      <symbol id="KS_svg__e" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path d="M781.385 206.543c-93.467.289-192.011 7.453-301.322 23.603l12.884 28.436c185.68-26.785 339.064-27.164 490.926-11.994l9.064-29.236c-69.231-7.1-138.856-11.034-211.552-10.809zm237.762 309.504c.087 1.9.493 4.26.853 6.736 6.883 47.36-5.717 66.844-22.049 67.002l-45.113.76C867.12 734.59 833.65 873.532 829.99 1010.799c-3.94 147.793 27.572 294.056 69.332 440.082 13.358 2.252 23.033 11.293 24.287 27.539 14.603-.938 29.377-2.691 44.418-5.067-46.249-157.14-82.077-310.25-78.058-460.955 4.165-156.203 47.705-311.4 173.904-480.353-14.806-5.45-29.537-10.606-44.727-15.998zm160.72 111.545c-80.898 108.466-117.497 201.146-132.031 295.885l28.402 12.22c11.458-83.154 40.04-163.455 103.68-256.69zM487.635 798.387l4.916 37.818c47.64 26.919 92.04 41.46 139 43.938 57.06 3.01 115.227-10.99 187.996-35.686l8.322-34.613c-150.025 52.625-227.012 59.678-340.234-11.457zm569.834 129.515l-1.131 5.77c-5.476 52.039 2.977 106.472 19.615 160.695l50.691 75.809c10.366 33.171 21.551 66.615 25.633 97.691 24.43 44.717 50.352 87.051 73.817 125.207.83 1.352 19.52-6.437 19.52-6.437-39.167-63.677-84.78-139.163-119.024-216.774-34.969-79.253-58.082-160.723-50.361-234.1zM1000 992a3 3 0 100 6h46.14a383.494 383.494 0 01-.484-6zm-5 12a6 6 0 00-6.008 6.916 312.159 312.159 0 019.186 5.084h49.972a409.082 409.082 0 01-1.443-12zm11.55 17c9 5.566 17.698 11.58 26.083 18h19.234a448.398 448.398 0 01-3.017-18zm33.68 24a326.435 326.435 0 0115.748 13.676 498.064 498.064 0 01-2.945-13.676zm234.756 64a42.555 42.555 0 01-1.931 12H1300v-12zm-8.59 25c-3.538 4.766-8.02 8.84-13.168 12H1300v-12zm-8.644 25a926.39 926.39 0 006.342 12H1300v-12zm13.443 25c2.195 3.971 4.42 7.97 6.688 12H1300v-12zm14.078 25c2.313 4.048 4.59 8.017 6.89 12H1300v-12z" />
      </symbol>
      <symbol id="KS_svg__f" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={6}
          fill="none"
          d="M1111.812 709.367c-15.115 28.547-58.036-21.038-94.132-9.885m40.97-68.424c7.213 37.086 71.188 51.506 53.162 78.31-33.763 4.055-57.282-19.013-79.214-46.284 35.448 3.666 67.08 12.294 79.214 46.283m-53.163-78.309c-5.839 12.354-11.954 24.744-.717 34.886m-40.252 33.538c5.485-18.041 16.52-20.095 30.473-17.743M1155 635.159c-16.25 27.917-57.143-23.354-93.659-13.662m43.688-66.72c5.716 37.345 69.06 54.326 49.971 80.383-33.898 2.695-56.471-21.3-77.289-49.431 35.272 5.088 66.532 14.981 77.289 49.43m-49.971-80.382c-6.331 12.109-12.94 24.243-2.12 34.829m-41.568 31.891c6.207-17.806 17.677-19.408 31.524-16.497m-14.215 172.466c-10.17 30.658-60.722-11.12-94.468 5.866m29.051-74.271c13.266 35.375 78.747 38.983 65.417 68.405-32.622 9.6-59.643-9.246-85.795-32.501 35.565-2.266 68.191.995 85.795 32.5m-65.417-68.404c-3.708 13.151-7.684 26.384 5.08 34.521m-34.131 39.75c2.417-18.7 13.305-22.556 27.455-22.55m36.554 94.342c-8.795 31.08-61.157-8.405-94.113 10.067m25.716-75.492c14.827 34.75 80.404 35.439 68.397 65.425-32.162 11.043-59.995-6.582-87.156-28.65 35.429-3.846 68.167-2.04 87.156 28.65m-68.397-65.425c-3.12 13.304-6.502 26.7 6.612 34.261m-32.328 41.23c1.582-18.79 12.642-22.25 26.778-22.876m129.502-136.307a777.995 777.995 0 014.304-7.391m-6.37 11.007c.683-1.204 1.372-2.41 2.066-3.616m-6.147 10.898a747.31 747.31 0 014.08-7.282m-28.713 56.228c7.295-16.099 15.476-32.39 24.633-48.946m-28.076 56.68a639.04 639.04 0 013.443-7.734m-5.61 12.748c.713-1.669 1.435-3.34 2.167-5.013m-5.78 13.655a620.664 620.664 0 013.613-8.642m-24.595 68.89c5.746-19.923 12.679-39.956 20.983-60.248m-22.878 66.967a580.578 580.578 0 011.895-6.72m-2.226 7.927l.331-1.207m-1.674 6.211c.44-1.668.887-3.336 1.343-5.004m-13.344 61.627c3.07-18.89 7.018-37.721 12.001-56.623m-61.263.193a672.05 672.05 0 00-6.179 28.25m31.343-109.414a676.839 676.839 0 00-10.987 31.106m46.756-110.177a757.55 757.55 0 00-14.887 29.94m60.198-106.104a909.495 909.495 0 00-19.116 29.991m65.28-93.991l-7.748 10.168c-2.971 3.9-5.893 7.787-8.766 11.664m-14.355 101.926c8.25-13.73 17.15-27.632 26.744-41.732m-63.796 111.318a706.057 706.057 0 0118.473-36.926m-48.913 115.71a618.301 618.301 0 0115.465-43.896m-34.174 122.029a621.541 621.541 0 018.947-42.975m-66.39-39.867a704.184 704.184 0 00-11.14 44.834m11.512-46.142c-.125.436-.25.872-.373 1.308m116.835-239.734c-57.628 82.512-94.414 161.26-116.462 238.426m117.636-240.103l-1.174 1.677m28.804-39.29l-2.736 3.591a1069.435 1069.435 0 00-24.894 34.022m62.24 16.191a1088.77 1088.77 0 0110.38-13.85l12.328-16.18m-70.785 101.666a887.474 887.474 0 0124.008-37.547m-62.375 109.252a723.31 723.31 0 0117.207-34.469m-48.11 113.623a637.866 637.866 0 0113.97-39.587m-33.363 118.257a638.303 638.303 0 018.04-38.047m-44.733-4.993a689.717 689.717 0 00-4.498 20.375m10.423-43.59a683.084 683.084 0 00-1.544 5.734m6.902-24.261a685.052 685.052 0 00-1.925 6.435m14.919-44.988a696.147 696.147 0 00-7.013 19.873m17.198-45.82a719.488 719.488 0 00-3.154 7.721m10.875-25.633a734.61 734.61 0 00-3.55 8.071m22.053-46.523a774.705 774.705 0 00-10.697 21.552m23.123-44.708a778.642 778.642 0 00-3.44 6.235m13.366-23.552a855.129 855.129 0 00-4.466 7.675m27.475-44.646a921.378 921.378 0 00-13.09 20.543m26.811-40.897a997.165 997.165 0 00-2.702 3.922m13.151-18.727c-.953 1.325-1.9 2.649-2.842 3.972m25.897-34.906l-5.253 6.895c-2.194 2.88-4.362 5.753-6.504 8.622m20.613 22.561c3.189-4.317 6.44-8.65 9.754-13l10.051-13.192m-68.341 98.33a898.259 898.259 0 0122.063-34.568m-61.71 108.455a740.418 740.418 0 0116.483-33.087m-47.798 112.755a657.219 657.219 0 0112.832-36.333M992.087 896.46a654.96 654.96 0 017.251-33.705M458.36 187.91c209.623-32.235 381.9-32.295 551.274-14.05m-516.686 84.721c185.68-26.785 339.063-27.164 490.926-11.994m-503.81-16.441c194.33-28.712 354.631-29.02 512.874-12.795M332.737.468c88.067 119.424 127.758 182.968 160.37 258.21M1112.592.632c-91.864 132.478-110.776 184.185-128.786 246.135m-181.734-84.97C783.05 144.492 771.05 120.188 770 85c-40.156-7.073-49.115-41.908-55-80-5.885 38.092-14.844 72.927-55 80-1.2 40.209-16.695 66.205-40.63 83.785m44.384-3.16c11.81-16.255 20.373-35.913 24.139-58.53 10.571-5.097 19.75-12.046 27.107-20.062 7.357 8.016 16.536 14.965 27.107 20.063 3.478 20.89 11.05 39.257 21.493 54.749m-235.212 16.357C485.258 160.134 485.068 126.255 470 95c-40.577 3.367-92.268-51.557-135.233-95.174m72.27 105.35c13.018 8.555 26.824 15.335 41.965 18.295 4.01 11.514 8.501 25.021 17.387 39.789 4.404 7.32 10.158 14.433 17.28 20.991m438.06-18.019C952.61 152.665 969.898 125.185 965 75c97.247-16.886 106.476-48.579 146.887-75.026M967.94 170.094a94.442 94.442 0 003.706-4.164c14.679-17.505 22.485-40.329 23.893-66.653 29.506-7.01 51.52-15.95 68.803-25.777M875 .158c-9.716 74.536-79.277 70.206-82.727 120.026-3.109 44.892 67.025 49.32 69.86 4.41 1.917-30.353-38.03-32.46-39.92-2.52-.945 14.97 24.005 16.545 24.95 1.575M875 .158c.264 75.166 69.818 79.619 66.975 129.477-2.562 44.927-72.696 40.5-69.861-4.41 1.916-30.354 41.81-27.42 39.92 2.52-.945 14.97-25.895 13.395-24.95-1.576M559.827 13.348c3.832 75.032-57.398 81.85-52.19 131.516 4.695 44.755 66.44 37.943 61.505-6.785-3.335-30.23-38.435-25.942-35.145 3.877 1.645 14.91 23.61 12.486 21.965-2.423m3.865-126.185c12.618 74.063 73.862 67.368 79.605 116.976 5.176 44.7-56.569 51.514-61.504 6.785-3.335-30.23 31.856-33.696 35.145-3.877 1.645 14.91-20.32 17.333-21.965 2.423M827.87 809.844c-150.025 52.625-227.013 59.678-340.236-11.457m10.962 108.084c42.383 19.49 85.215 31.237 129.793 33.59 59.632 3.147 116.435-8.74 179.431-28.579m-315.27-75.277c47.641 26.918 92.04 41.46 139 43.938 57.062 3.01 115.229-10.99 187.998-35.685m-80.072 116.217c21.317-4.373 42.738-10.027 64.593-16.623m-304.17-4.26c20.063 8.453 40.39 15.322 61.071 20.404m84.13-109.923c-10.65-116.533-36.302-227.518-66.01-333.468m148.585 74.87c-30.626 66.53-53.395 133.1-69.237 199.029m93.77-204.522c-42.162 88.289-70 176.603-85.89 263.476M806.643 566.38c-49.053 93.172-80.854 186.228-98.735 277.803M829.02 566.706c-49.415 91.648-81.564 183.01-99.906 273.002m-70.599-49.243C645.801 695 624.101 603.592 599.638 515.951m4.906 330.775c-10.955-112.453-36.22-220.513-65.564-324.666m44.999 320.23c-11.257-109.68-36.229-215.59-65.223-318.194m478.934 944.013c-46.286-157.24-81.64-308.365-77.733-454.91 4.08-152.977 46.234-303.127 173.45-470.091m-125.473 930.181c-46.155-157.076-81.984-310.186-77.965-460.89 4.165-156.204 47.705-311.4 174.1-480.197M922.676 582.87c-177.287 304.494-132.89 592.491-53.403 873.32m29.702-5.304c-41.413-146.03-72.926-292.294-68.985-440.087 3.66-137.267 37.13-276.21 122.848-420.254M938.203 863.65c40.721 29.128 103.558 60.243 192.782 93.73m-16.323-258.765c17.447-29.584 38.037-60.075 62.264-91.872l3.074-4.035m-26.623 10.475c3.78-5.148 7.65-10.324 11.617-15.53l14.419-18.923m-103.175 356.965c11.458-83.154 40.04-163.455 103.68-256.689m-132.081 244.47c14.533-94.738 51.133-187.42 132.03-295.886m-160.358-111.2c55.302 18.827 109.273 39.16 160.546 62.545M-.311 645.182C77.863 592.386 249.656 531.079 376.9 521.334m548.944 620.112C981.801 1173.147 1020 1236.73 1020 1310c0 42.658-12.948 82.032-34.81 113.743m10.075 35.695c34.05-39.482 54.735-92.21 54.735-149.438 0-91.02-52.325-170.661-127.533-203.722m209.335 326.05C1146.799 1394.137 1155 1352.7 1155 1310c0-146.981-97.167-278.98-234.211-315.21m173.059 449.61A305.485 305.485 0 001125 1310c0-131.706-85.022-249.158-205.117-284.32m156.346-89.916c4.298 166.278 90.225 322.08 168.751 449.84m-7.09-244.143c14.721 31.903 43.294 80.848 63.975 116.104M675 1000a25 20 0 00-25-20 25 20 0 00-25 20 25 20 0 0025 20 25 20 0 0025-20v0m20 30c75 75 75-135 0-60m30 60s5-5 5-10-5-10-5-20 5-15 5-20-5-10-5-10m-120 60c-75 75-75-135 0-60m-30 60s-5-5-5-10 5-10 5-20-5-15-5-20 5-10 5-10m45 20c-65-65 125-65 60 0m-60-30s5-5 10-5 10 5 20 5 15-5 20-5 10 5 10 5m-60 50c-65 65 125 65 60 0m-60 30s5 5 10 5 10-5 20-5 15 5 20 5 10-5 10-5m-87.004-80h14.108m-14.108 80h14.108M500.26 960h60.88m-61.054 20h51.043m-51.582 20h49.203m-50.107 20h52.486m-53.96 20h63.972M1140 933.262c-5-5-12.292-28.711 15-30 29.5-1.394 55.467 25.08 85 25 17.4-.047 45-15 45-15-.209-10.805 7.894-19.65 0-35-25 10-92.95-5-135-5-25 0-40 28.656-40 50 0 45 60.557 39.403 63.46 16.92 1.54-11.92-18.46-36.92-18.46-36.92m-23.21 51.957c-18.828 76.512 5.28 118.415 70.503 127.179m8.13-109.356c-29.58-1.468-25.423-9.78-25.423-9.78 2.216 29.672-8.808 47.205-25 60m5.935-104.296c26.509 3.548 36.882 19.296 59.065 19.296 2.37 0 4.67.491 6.817 1.358m-5.624 28.98c-19.995-4.003-13.582-24.179 16.755-33.417v0c59.932-18.251 71.575 11.571 22.052 28.079-2.98.993-5.826 1.851-8.536 2.583m-25.922 1.874c70.611-10.245 79.336 20.845 20.776 30.725-70.95 11.97-71.377-23.384-20.776-30.725v0m-3.984 36.46c71.04-6.655 78.179 24.837 19.193 31.738-71.465 8.362-70.1-26.968-19.193-31.737v0m1.011 35c63.285-6.656 69.645 24.836 17.098 31.737-63.663 8.362-62.447-26.968-17.098-31.737v0m37.431 69.082a37.5 35 0 01-37.5 35 37.5 35 0 01-37.5-35 37.5 35 0 0137.5-35 37.5 35 0 0137.5 35v0M1180 875V183.262l50-50 50 50V879.8M1000 1085a35 35 0 01-35 35 35 35 0 01-35-35 35 35 0 0135-35 35 35 0 0135 35v0m66.531 59.354a35 35 0 01-35 35 35 35 0 01-35-35 35 35 0 0135-35 35 35 0 0135 35v0m39.913 75.471a35 35 0 01-35 35 35 35 0 01-35-35 35 35 0 0135-35 35 35 0 0135 35v0m16.69 87.808a35 35 0 01-35 35 35 35 0 01-35-35 35 35 0 0135-35 35 35 0 0135 35v0m-10.885 82.002a35 35 0 01-35 35 35 35 0 01-35-35 35 35 0 0135-35 35 35 0 0135 35v0m-105.531 76.854a35 35 0 01-.027-1.382 35 35 0 0135-35 35 35 0 0131.703 20.17m170.998-569.647c-1.544-6.77-5.5-25.097-5.98-37.124-.6-14.987 13.59-35.597 13.19-45.588-.4-9.992-21.582-39.128-22.182-54.115-.599-14.987 12.192-70.567 11.592-85.553-.599-14.987-17.185-54.325-17.784-69.311-.6-14.987 17.786-55.79 16.987-75.772-.799-19.982-17.984-74.306-18.583-89.293-.6-14.987 18.186-45.798 17.387-65.78-.8-19.983-16.986-49.329-17.585-64.316-.6-14.986 3.597-35.178 3.198-45.17-.4-9.99-6.395-34.76-6.794-44.75-.4-9.992 12.191-70.567 12.191-70.567m9.342 747.132c-1.503-6.805-5.326-25.131-5.726-37.145-.5-14.992 13.826-35.48 13.493-45.475-.332-9.994-21.32-39.312-21.82-54.303-.499-14.992 12.662-70.46 12.163-85.453-.5-14.991-16.822-54.47-17.322-69.461-.499-14.992 18.158-55.636 17.493-75.625-.666-19.989-17.488-74.459-17.988-89.45-.499-14.992 18.491-45.641 17.826-65.63-.666-19.989-16.657-49.473-17.156-64.465-.5-14.991 3.832-35.147 3.5-45.141-.333-9.995-6.163-34.814-6.496-44.809-.332-9.994 12.662-70.46 12.662-70.46M1280 635a782.908 782.908 0 0119.989 12.815m-85.956 230.276c-1.454-8.123-4.033-24.056-4.033-34.83 0-15 15-35 15-45s-20-40-20-55 15-70 15-85-15-55-15-70 20-55 20-75-15-75-15-90 20-45 20-65-15-50-15-65 5-35 5-45-5-35-5-45 15-70 15-70m4.4 747.214c-1.464-6.856-5.148-25.146-5.468-37.132-.4-14.995 14.062-35.388 13.795-45.384-.266-9.997-21.059-39.453-21.459-54.447-.4-14.995 13.13-70.375 12.73-85.37-.4-14.995-16.461-54.58-16.861-69.575-.4-14.995 18.527-55.514 17.994-75.507-.534-19.993-16.994-74.573-17.394-89.568-.4-14.995 18.793-45.517 18.26-65.51-.533-19.993-16.327-49.582-16.727-64.577-.4-14.995 4.065-35.121 3.799-45.117-.267-9.997-5.931-34.855-6.198-44.851-.266-9.997 13.129-70.375 13.129-70.375m-77.722 1134.806c24.82 45.434 51.183 88.408 74.943 127.039m-151.268-300.54c-16.639-54.222-25.09-108.656-19.615-160.695l1.132-5.77m-558.143-670.01C416.747 411.143 472.825 422.943 440 500c-14.923 35.033-50 20-41.145-4.224C411.719 460.582 435 475 430 495c-2.044 8.176-14.812 12.956-20 10m105.453-249.236C430.953 410.922 485.205 421.467 455 500c-25 65-64.881 20-56.026-4.224m132.615-242.09C445.469 410.83 500.339 421.117 470 500c-25 65-111.091 67.492-90 0 25-80 72.053-58.46 67.053-23.46M547.64 251.77C460.023 410.748 515.462 420.798 485 500c-10.735 27.912-32.134 41.42-51.388 42.405M563.68 249.89C474.586 410.67 530.582 420.487 500 500c-10.64 27.662-31.882 39.534-51.152 38.845M579.614 248.21C489.196 410.603 545.688 420.21 515 500c-9.27 24.1-27.734 33.87-46.227 33.185m126.77-286.639C503.81 410.538 560.792 419.939 530 500c-8.324 21.643-23.26 29.96-38.705 28.933m120.056-283.83C518.476 410.484 575.883 419.706 545 500c-8.317 21.624-22.471 28.46-36.882 25.467m119.04-281.797C533.144 410.431 590.971 419.474 560 500c-7.433 19.326-19.946 25.749-33.306 23.459M642.83 242.478C547.869 410.388 606.045 419.282 575 500c-6.985 18.162-18.542 23.682-31.11 20.734m114.615-279.448C562.594 410.346 621.12 419.092 590 500c-6.572 17.088-17.667 21.38-30.07 17.197m114.109-276.85C577.377 410.315 636.176 418.942 605 500c-5.63 14.64-14.894 18.894-25.628 15.926m110.202-276.52C592.161 410.284 651.234 418.794 620 500c-5.647 14.68-14.965 18.195-25.765 14.061m110.656-275.21C607.032 410.265 666.267 418.705 635 500c-4.58 11.91-12.345 15.167-21.843 12.129M720 510s-5 85-40 85-35-55-5-55 20 35 0 35c-10 0-6.487-14.546 5-15m53.125-44.375c-5 45-12.347 97.507-41.131 76.148m54.256-70.523c-3.006 41.773-5.322 80.234-28.732 67.929m41.857-62.304c-5 35-1.22 70.48-22.76 58.627M772.5 532.5c-5 35 1.664 59.519-19.875 47.665m33-42.04c-3.563 26.875 3.687 51.505-17.852 39.651m30.977-34.026C795 565 800 580 783.183 573.54m28.692-24.165c-8.183 22.652-1.875 17.825-15.95 18.491M825 555c-4.59 5.854-2.681 12.498-18.678 11.523M660 467.159c1.17 18.151-5.662 54.105-38.133 46.06M672 475.727c5.984 22.538-1.263 65.429-50.133 37.492M684 484.296c4.117 23.47-6.547 69.02-46.575 35.754M696 492.864c-1 12.136-3.95 57.925-28.87 38.27M708 501.432c0 17.84-12.179 71.928-24.04 71.369M825 555c9.565 47.328 66.995 11.25 57.594-15M950 517.241c2.874 77.759 85.436 111.76 70 5.542-10.734-73.86-63.283-43.674-52.43 6.322 6.022 27.74 42.258 49.972 37.916 6.198-4.78-48.18-21.93-35.412-21.258-21.404.772 16.101 4.815 20.09 12.061 25.19m-59.77-17.296C946.018 572.244 959.27 602.013 995 590m-71.962-63.655c8.586 56.052 19.886 69.043 46.141 64.476m-59.622-59.924c5.154 36.467.418 58.26 34.077 56.104m-47.558-51.553c3.457 25.904 6.043 42.688 23.924 44.552m-37.406-40c4.971 23.216 8.718 50.023 26.38 36.026M980 245s10 30 10 40-5 23.087-5 27.808c0 4.72 3.576 62.232 2.685 72.192-2.242 25.054-18.875 100.311-21.32 125.311M985 245c0 20 60.346 42.78 61.593 80 2.165 64.64-42.164 37.785-60.23 18.36m.911-73.36s41.205 35.058 42.726 55c2.536 33.259-30.643 17.892-44.289 9.311M990 292.898s23.36 11.376 25 27.102c2.556 24.502-18.934 14.994-29.44 8.753m1.977-25.88C995 305 1000 320 1000 320c.967 10.742-7.59 4.817-14.59 1.62m1.1 21.897C987.826 380.074 1055 405 1055 450c0 65.462-46.101 41.896-47.592 37.52m-19.58-107.446C990 392.864 1040 425 1040 455c0 39.867-32.401 35.798-35 30m-19.179-84.179c0 10 39.179 34.179 39.179 54.179 0 27.27-27.456 24.286-32.418 23.52m-9.708-58.315C985 430 1010 440 1010 457.512c0 27.609-34.927 8.694-35 7.488m5-30c4.271 6.664 12.855 10 12.816 20-.075 19.265-16.078 5.534-16.995 1.1M715 295s45-35 65-35 55 10 60 10c10 0 10-10 10-10l5 5s-7.923 10-15 10-45-10-60-10c-12.8 0-65 30-65 30v0m265-20s-25-15-35-15-30.015 12.765-35 12.373c-5.914-.466-10-2.373-15-12.373l-5 5s10 10 20 10 30-10 35-10 35 10 35 10v0m-90-10v20c0 5.27-5 10-5 15s30 100 30 105-15 20-20 20c-10 0-15.542-13.768-23.49-13.768-7.947 0-21.51 8.683-26.51 8.768-16.496.28-15.942-24.733 0-25 5-.084 10 5 10 5m5 35c-55 2.54-60.544 24.922-100 32.16-25.561 4.688-26.812-35.184-10-37.16 9.932-1.167 10 17.332 10 17.332.288.045 10-24.664-10-24.048-24.988.77-25.072 52.422 6.026 51.305C783.413 473.606 815 445 860 445v-10 0m30 0v10c20 0 35.734 19.84 50 20 23.399.261 41.795-42.496 14.59-41.773C944.592 423.492 940 435 940 435s7.229-7.707 15.05-7.947c15.885-.49-1.402 32.752-15.05 32.947-9.9.141-30-25-50-25v0m-80 50v7.2l5-4.31-5-2.89v0m110-5v7.685L915 485l5-5v0m-105 7.89c10 2.11 22.11-13.17 34.59-13.17 12.479 0 9.515 5.28 19.515 5.28s10-7.915 20-7.915S905 485 915 485m-75 30c30.388 15.822 50-10 50-20M725 325c25 0 41.557-28.358 67.053-28.358C822.053 296.642 830 320 840 320c-10 0-36.871 12.035-50.41 11.716C774.593 331.362 740 325 725 325v0m166.437-8.227c25 0 21.8-17.23 47.293-17.518 25.646-.29 32.707 17.518 42.707 17.518-10 0-28.877 15.835-42.417 15.516-14.995-.354-32.583-15.516-47.583-15.516v0m-194.454 269.9a1130.48 1130.48 0 00-30.573 74.645m.111-.15c-10.344-49.062-22.413-96.88-35.27-143.49"
        />
      </symbol>
      <symbol id="KS_svg__g" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={3}
          fill="none"
          d="M1212.566 936.722c.423 7.116 2.966 10.17 6.545 11.345M1215 973.262c3.571 8.688 9.21 17.581 0 25m-5.007 9.56c3.571 8.689 9.21 17.582 0 25m.513 12.46c3.571 8.688 9.21 17.581 0 25m34.494-92.02c2.78 6.39 1.183 10.591 0 15m7.44-50.407c2.78 6.39 1.183 10.592 0 15m-10.262 54.53c2.78 6.39 1.183 10.592 0 15m-1.54 20.92c2.78 6.39 1.183 10.591 0 15m-13.58-119.036c3.572 8.689 9.21 17.582 0 25M1240 516.594v-5.344m0 139.916V516.594m0 154.252v-19.68m0 120.354V670.846m0 186.822v-25.03m10 48.717v-75.46m-10 74.978v-23.205m10-65.662V153.262m-10 357.988V143.262m30 737.86v-707.86m-10 708.398V163.262m-29.97 160.453V133.29m0 330v-69.402m0 222.81v-57.742m0 175.441V616.7m0 130.52V734.4M1220 219.25v-33.04M725 325c6.583 1.08 35-45 60-45s35 10 40 20m-79.482 32.838c10.71 8.481 21.007 16.989 34.743 16.85 18.416-.187 36.826-7.646 45.651-18.066m65.525-14.849c10 0 30-30 45-30s30 10 35 15m0 30c-15.33 12.126-33.906 12.95-55 5m-101.854-34.826a28.44 28.44 0 01.828 6.858c0 12.427-7.836 22.5-17.5 22.5-9.665 0-17.5-10.073-17.5-22.5 0-4.058.835-7.866 2.298-11.153m172.028 4.436c1.09 2.934 1.7 6.218 1.7 9.685 0 12.427-7.835 22.5-17.5 22.5s-17.5-10.073-17.5-22.5c0-3.152.504-6.154 1.415-8.878"
        />
        <use
          xlinkHref="#KS_svg__a"
          height={90}
          transform="scale(1 .793) rotate(-10 4423.411 -2163.385)"
        />
        <use
          xlinkHref="#KS_svg__a"
          height={90}
          transform="matrix(.9962 -.06911 .08716 .78998 479.25 718.56)"
        />
        <use
          xlinkHref="#KS_svg__a"
          height={90}
          transform="scale(1 .793) rotate(20 -1718.934 2677.53)"
        />
        <use
          xlinkHref="#KS_svg__a"
          height={90}
          transform="scale(1 .793) rotate(20 -2130.7 2621.488)"
        />
      </symbol>
      <rect
        width={211}
        height={328}
        x={-105.5}
        y={-164}
        rx={12}
        ry={12}
        fill="#fff"
        stroke="#000"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KS_svg__b" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KS_svg__b"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KS_svg__c" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KS_svg__c"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KS_svg__d" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KS_svg__d"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KS_svg__e" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KS_svg__e"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KS_svg__f" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KS_svg__f"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#KS_svg__g" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#KS_svg__g"
      />
      <use xlinkHref="#KS_svg__h" height={50} x={-104} y={-152.5} />
      <use xlinkHref="#KS_svg__a" height={41.827} x={-99.913} y={-97.5} />
      <use xlinkHref="#KS_svg__a" height={38.6} x={-63.881} y={-109.3} />
      <g transform="rotate(180)">
        <use xlinkHref="#KS_svg__h" height={50} x={-104} y={-152.5} />
        <use xlinkHref="#KS_svg__a" height={41.827} x={-99.913} y={-97.5} />
        <use xlinkHref="#KS_svg__a" height={38.6} x={-63.881} y={-109.3} />
      </g>
      <use xlinkHref="#KS_svg__i" stroke="#44F" fill="none" />
    </svg>
  );
}

export default SvgKs;
