import * as React from "react";

function SvgQc(props: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      className="QC_svg__card"
      preserveAspectRatio="none"
      viewBox="-106 -164.5 212 329"
      {...props}
    >
      <defs>
        <path id="QC_svg__i" d="M-58-112.5H58v225H-58z" />
      </defs>
      <symbol
        id="QC_svg__h"
        viewBox="-500 -500 1000 1000"
        preserveAspectRatio="xMinYMid"
      >
        <path
          d="M-260 100c300 0 220 360 520 360M-175 0v-285a175 175 0 01350 0v570a175 175 0 01-350 0z"
          stroke="#000"
          strokeWidth={80}
          strokeLinecap="square"
          strokeMiterlimit={1.5}
          fill="none"
        />
      </symbol>
      <symbol
        id="QC_svg__a"
        viewBox="-600 -600 1200 1200"
        preserveAspectRatio="xMinYMid"
      >
        <path d="M30 150c5 235 55 250 100 350h-260c45-100 95-115 100-350a10 10 0 00-20 0 210 210 0 11-74-201 10 10 0 0014-14 230 230 0 11220 0 10 10 0 0014 14 210 210 0 11-74 201 10 10 0 00-20 0z" />
      </symbol>
      <symbol id="QC_svg__b" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#FC4"
          d="M126.244 0C106.112 115.728 110.677 243.292 30 330c33.589-7.979 66.994-12.36 99.984-9.607L333.643 0zm668.942 480l-510.762.117c-33.066 50.77-73.708 92.458-125.197 119.68l697.925.793c-23.462-43.178-43.98-83.366-61.966-120.59zm322.314 57.5c-16.937 0-33.872 21.077-28.146 63.227A42.5 42.5 0 011117.5 590a42.5 42.5 0 0128.148 10.71c5.72-42.138-11.213-63.21-28.148-63.21zm-260.098 63.127a219.614 219.614 0 00-25.722 35.768c-37.37 64.727-37.814 140.448-7.797 202.08C796.019 884.234 780 937.777 780 995c0 168.447 138.792 305 310 305 80.432 0 153.709-30.138 208.803-79.563l-.692-.515 1.889-2.541v-27.12L923.95 910.626l80.025-114.678L1300 1015.93v-31.15L996.059 758.735 890.79 909.496l-.447-.476 10.658-15.37c-74.41-55.386-96.537-160.12-47.672-244.757a196.268 196.268 0 0120.404-28.98zm213.153 2.594c-68.783-.54-63.724 68.143 15.172 57.425A42.5 42.5 0 011075 632.5a42.5 42.5 0 0110.71-28.148c-5.396-.733-10.45-1.094-15.155-1.131zm93.89 0c-4.71.037-9.769.399-15.172 1.133A42.5 42.5 0 011160 632.5a42.5 42.5 0 01-10.71 28.148c78.88 10.707 83.933-57.967 15.155-57.427zm-754.277 26.498c5.633 161.815 151.47 195.793 164.084 310.258l20.432-.012C587.116 821.02 445.849 791.57 440.176 630.1zm129.957.388c4.04 161.399 104.663 181.69 109.682 309.838l25.025-.002c-4.341-127.984-91.331-143.766-94.73-309.828zm119.986.182c2.786 128.345 57.358 162.203 59.805 309.395h20.014c-2.04-147.192-47.517-181.05-49.838-309.395zM1235 640c-13.07 39.21-55.14 75.15-53.707 109.752-4.37-18.95-8.081-37.984-13.525-55.889l-21.678-2.06c7.35 20 11.636 41.876 16.582 63.76L1185 765c63.58-18.95 58.442-71.175 50-125zm-89.353 24.273A42.5 42.5 0 011117.5 675a42.5 42.5 0 01-28.148-10.71c-4.562 33.61 5.291 53.802 18.058 60.605l-1.682-.106c-21.832 2.077-44.95 12.789-70.728 10.211 17.417 28.272 67.468 31.437 130 25-12.934-21.018-25.869-30.534-39.14-33.959l-.64-.04c13.884-5.478 25.273-26.051 20.427-61.728zm-230.862 270.79l280.145 208.248C1165.324 1163.298 1129.666 1175 1090 1175c-105.024 0-185-80.047-185-180 0-21.157 3.583-40.965 10.252-59.441zm-259.408 29.966l-137.863.032C519.107 978.173 520 991.484 520 1005c0 9.856-.475 19.602-1.41 29.61l136.377.39.015-2.7c-6.289 2.157-15.594-.073-15.582-6.71-7.07 7.097-22.087-7.92-14.99-14.99-10.018.019-10.018-21.219 0-21.2-7.097-7.07 7.92-22.087 14.99-14.99-.013-6.768 9.675-8.967 15.961-6.59zm325.168 18.987A108.263 108.263 0 00980 995c0 58.883 44.645 105 110 105 13.872 0 26.585-2.22 38.178-6.295z"
        />
      </symbol>
      <symbol id="QC_svg__c" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="red"
          d="M333.65 0l-201 316.523 15.657-25.007C127.457 294.209 106.739 298.59 85 290c-11.597 15.062-27.312 25.967-42.447 36.918 29.806-5.92 58.785-8.877 87.48-6.213l.182-.289c17.627 1.978 34.916 5.695 51.924 12.107L393.639 0zm308.795 0c34.353 141.479 46.364 258.031 152.868 480 17.86 37.224 38.378 77.411 62.105 121.18l16.316 18.732C988.885 461.534 744.765 342.3 642.922 0zM260 55c-13.228 10.599-26.504 11.206-35 10 5.287 8.604 6.504 20.651 5 35 9.783 8.146 15.717 18.856 20.777 30.15l41.895-65.763C280.597 63.627 268.99 61.928 260 55zm857.5 565a12.5 12.5 0 00-12.5 12.5 12.5 12.5 0 0012.5 12.5 12.5 12.5 0 0012.5-12.5 12.5 12.5 0 00-12.5-12.5zm-707.178 9.86l-231.312.189 39.63 70.181c144.492 3.719 264.402 105.003 294.227 239.416l61.385.33c-12.614-114.464-158.45-148.442-163.93-310.117zm425.504.02l-145.888.265c2.476 128.49 47.953 162.347 50.021 309.697l44.734.055c7.158-36.616 20.55-70.857 39.243-101.479-30.082-61.535-29.635-137.281 7.744-202.023 1.294-2.243 2.623-4.454 4.146-6.514zM873.631 665l-11.668 25h74.246l-22.627-25zm-19.092 55l-2.121 25h131.875l-21.92-25zm.707 55l7.07 25h103.946l18.031-25zm20.86 55l19.091 25h33.942l17.677-25zm-31.46 122.686a12.5 12.5 0 00-12.554 11.521 12.5 12.5 0 0011.482 13.44 12.5 12.5 0 0013.44-11.485 12.5 12.5 0 00-11.483-13.44 12.5 12.5 0 00-.885-.036zM650 987.5a12.5 12.5 0 00-12.5 12.5 12.5 12.5 0 0012.5 12.5 12.5 12.5 0 0012.5-12.5 12.5 12.5 0 00-12.5-12.5zm355.303 14.95c3.417 41.511 35.468 72.55 84.697 72.55a98.19 98.19 0 0012.059-.723zm-156.135 36.376a12.5 12.5 0 00-2.488.193 12.5 12.5 0 00-10.094 14.512 12.5 12.5 0 0014.512 10.094 12.5 12.5 0 0010.093-14.512 12.5 12.5 0 00-12.023-10.287zm34.365 78.182a12.5 12.5 0 00-4.863 1.008 12.5 12.5 0 00-6.572 16.41 12.5 12.5 0 0016.41 6.574 12.5 12.5 0 006.572-16.41 12.5 12.5 0 00-11.547-7.582zm58.17 60.033a12.5 12.5 0 00-8.887 3.975 12.5 12.5 0 00.621 17.666 12.5 12.5 0 0017.667-.622 12.5 12.5 0 00-.622-17.666 12.5 12.5 0 00-8.779-3.353zm252.178 25.92a12.5 12.5 0 00-4.87.975 12.5 12.5 0 00-6.68 16.367 12.5 12.5 0 0016.366 6.681 12.5 12.5 0 006.68-16.367 12.5 12.5 0 00-11.496-7.656zm-177.215 11.217a12.5 12.5 0 00-12.213 8.931 12.5 12.5 0 008.414 15.547 12.5 12.5 0 0015.547-8.414 12.5 12.5 0 00-8.414-15.547 12.5 12.5 0 00-3.334-.517zm90.916 10.539a12.5 12.5 0 00-12.078 12.908 12.5 12.5 0 0012.908 12.078 12.5 12.5 0 0012.078-12.908 12.5 12.5 0 00-12.908-12.078z"
        />
      </symbol>
      <symbol id="QC_svg__d" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#44F"
          d="M636.568 188.838A13.432 21.162 0 00623.135 210a13.432 21.162 0 0013.433 21.162A13.432 21.162 0 00650 210a13.432 21.162 0 00-13.432-21.162zm-140 1.209a13.432 21.162 0 00-13.433 21.162 13.432 21.162 0 0013.433 21.162A13.432 21.162 0 00510 211.21a13.432 21.162 0 00-13.432-21.162zm-233.324 319.79a382.338 382.338 0 01-10.23 12.75l3.877-4.21c2.036-.069 4.075-.093 6.117-.084 1.932.009 3.867.053 5.803.113.733.023 1.467.057 2.2.086 1.136.045 2.271.087 3.407.143 3.84.187 7.682.421 11.523.648l2.09.121c1.317.076 2.632.143 3.948.21.766.038 1.532.078 2.298.112 1.255.057 2.51.098 3.764.14.775.024 1.55.057 2.324.075l.606.012c1.666.034 3.33.054 4.994.045a19.09 19.09 0 01-.906 1.703c-.048.079-.102.156-.15.234a18.37 18.37 0 01-.958 1.4 19.235 19.235 0 01-.639.797l-.006.009c-.22.261-.451.521-.693.78l-.008.007c-.242.258-.494.513-.758.768l-.01.01a23.58 23.58 0 01-.824.758c-.58.51-1.208 1.015-1.89 1.52a37.317 37.317 0 01-2.215 1.509c-.791.5-1.641 1.001-2.553 1.506l-.012.008a67.366 67.366 0 01-2.95 1.531 94.82 94.82 0 01-3.34 1.557c-.009.003-.015.008-.022.011-5.964 2.643-13.783 5.481-24.08 8.813a834.345 834.345 0 01-13.59 4.254c6.552 3.587 9.914 7.016 11.84 11.12-3.626-.02-7.259.076-10.895.231-10.908.466-21.849 1.468-32.73 1.477l11.787-12.803a330.562 330.562 0 01-25.139 22.447l635.588.327c-1.64-3.08-3.222-6.101-4.824-9.143-.15 0-.299-.007-.448-.008a167.04 167.04 0 01-2.77-.03h-.025c-.083-.001-.166-.007-.25-.01a139.71 139.71 0 01-2.966-.097h-.022c-.18-.008-.36-.023-.54-.031-.85-.042-1.698-.086-2.546-.145-14.05-.963-27.956-4.376-41.523-13.574l.713.193c-.313-.21-.627-.403-.94-.62-2.218.209-4.307.836-6.472 1.495 6.554 3.589 9.906 7.016 11.832 11.121-31.867-.177-64.258 8.6-94.926-12.054-2.161.675-4.421 1.368-6.776 2.086 6.556 3.588 9.91 7.017 11.836 11.123-31.866-.177-64.258 8.6-94.925-12.053a989.52 989.52 0 01-5.706 1.76c6.556 3.588 9.909 7.015 11.834 11.12-28.75-.159-57.927 6.963-85.88-6.808a18.692 18.692 0 013.308 4.875c-31.866-.177-64.258 8.6-94.926-12.052a1010.38 1010.38 0 01-5.705 1.757c6.556 3.59 9.908 7.017 11.834 11.123-31.938-.177-64.403 8.646-95.132-12.187l20.21-7.74c-7.125 2.594-15.91 5.453-26.912 8.804 6.556 3.59 9.908 7.017 11.834 11.123-31.938-.177-64.403 8.646-95.132-12.187l39.308-15.055c2.696.82 5.24 1.607 7.684 2.373l-3.229-1.236c30.73-20.833 63.196-12.01 95.135-12.188-2.698 5.752-8.197 10.172-21.393 15.57l11.803-4.519c2.696.82 5.24 1.607 7.684 2.373l-3.229-1.236c30.73-20.833 63.196-12.01 95.135-12.188-1.783 3.801-4.826 7.02-10.461 10.325a980.99 980.99 0 017.352 2.271l-3.229-1.236c16.325-11.068 33.14-13.767 50.106-13.89 14.97-.11 30.056 1.784 45.027 1.7-2.304 4.912-6.685 8.857-16.117 13.264 2.37.724 4.648 1.429 6.82 2.11L560 535c30.73-20.833 63.194-12.01 95.133-12.188-1.783 3.802-4.825 7.02-10.461 10.325 2.575.784 5.02 1.54 7.363 2.275l-3.238-1.24c30.73-20.833 63.194-12.01 95.133-12.188-1.708 3.642-4.565 6.749-9.754 9.909l.031-.012c2.706.824 5.258 1.614 7.71 2.383l-3.255-1.248a79.355 79.355 0 013.725-2.364 77.41 77.41 0 012.132-1.232c.272-.151.543-.308.815-.455a75.936 75.936 0 012.803-1.445c.22-.108.441-.206.662-.311a75.238 75.238 0 015.43-2.332c.227-.087.455-.18.683-.266a76.674 76.674 0 012.844-.994c.27-.089.541-.172.812-.258a79.01 79.01 0 012.196-.66c.283-.08.567-.162.851-.24.945-.258 1.89-.504 2.836-.727l.154-.035c.95-.221 1.9-.421 2.852-.61.288-.056.577-.11.865-.163.765-.143 1.53-.277 2.295-.4.232-.038.464-.078.695-.114.978-.15 1.957-.286 2.936-.406.193-.024.386-.042.578-.065a107.116 107.116 0 015.664-.515c.215-.014.43-.032.645-.045.177-.01.355-.016.533-.026a135.77 135.77 0 015.078-.19c1.387-.029 2.774-.045 4.162-.038 1.87.009 3.742.051 5.615.11.575.017 1.15.04 1.725.062a341.87 341.87 0 015.691.256c3.714.195 7.43.425 11.145.64-1.715-3.415-3.435-6.836-5.106-10.203zm261.742 35.73c-2.548.8-5.198 1.621-8.023 2.482.215.118.41.236.619.353zM1055 570c0 11.187 2.782 25.153 6.27 33.605 6.977-.643 14.9-.488 23.76.666l-22.151-22.15c-1.932-1.877-.604-5.152 2.09-5.152a3 3 0 012.152.91l22.15 22.15c-1.154-8.859-1.31-16.782-.665-23.76-8.453-3.487-22.42-6.269-33.606-6.269zm125 0c-11.187 0-25.153 2.782-33.605 6.27.644 6.98.49 14.907-.666 23.771l22.162-22.162a3 3 0 012.152-.91c2.694 0 4.022 3.275 2.09 5.152l-22.149 22.149c8.854-1.154 16.772-1.308 23.747-.665 3.487-8.452 6.269-22.418 6.269-33.605zM121.36 618.908C83.23 651.688 42.7 669.22 0 664.048v108.76l1.197 6.754c45.648-40.95 103.78-68.661 168.338-76.603zm963.681 41.82c-8.864 1.157-16.79 1.31-23.771.667-3.488 8.452-6.27 22.418-6.27 33.605 11.187 0 25.153-2.782 33.605-6.27-.643-6.974-.489-14.892.664-23.746l-22.136 22.137c-2.828 2.945-7.187-1.415-4.242-4.242zm64.93 0l22.15 22.15c2.945 2.828-1.415 7.188-4.242 4.243l-22.15-22.15c1.154 8.859 1.31 16.782.666 23.76 8.452 3.487 22.418 6.269 33.605 6.269 0-11.187-2.782-25.153-6.27-33.605-6.977.643-14.9.488-23.76-.666zm-145.996 135.22l-80.026 114.677L1300 1190.262V1015.93z"
        />
      </symbol>
      <symbol id="QC_svg__e" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path d="M393.637 0L0 618.572v45.487C197.24 687.924 347.448 226.477 407.35 0zm252.58 316.484C639.937 347.246 632.342 374.565 625 380c-17.901 13.25-60.727 84.764-70 90-5.433 3.068-11.62 4.193-18.063 4.008l1.24 5.992 173.702-.1c-27.651-61.226-48.883-115.042-65.662-163.416zm-487.22 283.434a281.384 281.384 0 01-33.31 14.807l-4.01 4.462 47.604 83.805C182.286 700.91 196.035 700 210 700c2.95 0 5.888.041 8.793.234L179.01 630.05l656.879-.268c6.402-10.604 13.643-20.259 21.256-29.467zm714.737 19.994a196.268 196.268 0 00-20.404 28.98c-48.865 84.638-26.738 189.372 47.672 244.758l15.146-19.732c-64.205-47.79-83.715-138.13-40.949-212.203a171.565 171.565 0 0115.701-22.768zM512.967 939.855A304.52 304.52 0 01520 1005c0 9.936-.483 19.76-1.422 29.727l66.41.273-.205-70 196.674-.076c.87-8.408 2.041-16.642 3.201-24.844z" />
      </symbol>
      <symbol id="QC_svg__f" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={6}
          fill="none"
          d="M1300 984.779L996.277 759.002m-995.08 20.56C56.29 730.138 129.566 700 210 700c171.208 0 310 136.553 310 305 0 57.29-16.055 110.892-43.98 156.687M1.931 780.02l410.831 305.396M513.054 940H784.32M1300 1190.265L923.935 910.712m71.904-152.243L887.238 914.584m116.51-118.734l-79.783 114.688M857.2 600.858l138.618 157.643M886.75 914.2c-84.962-62.772-110.23-182.27-55.071-277.806a219.61 219.61 0 0125.724-35.766m43.599 293.023c-74.41-55.386-96.537-160.12-47.672-244.758a196.282 196.282 0 0120.404-28.981m130.466 176.13L1300 1015.93M916.148 873.919c-64.205-47.79-83.715-138.13-40.949-212.204a171.568 171.568 0 0115.701-22.767M995.058 760H853.114m95.79-55H857.47m99.563 110h-89.114m-11.03-215H158.867m682.056-30H204.844M810 510H262.997m532.063-30H284.483M642.495.16C676.82 141.572 688.844 258.106 795.312 480c17.86 37.224 38.378 77.412 62.106 121.18M835.988 630H179.392m510.7.29c2.322 128.344 47.798 162.203 49.837 309.394M660.11 630.29c2.786 128.344 57.358 162.203 59.805 309.394m-139.813-309.57c3.4 166.063 90.389 181.846 94.73 309.83M540.125 630.107c4.041 161.398 104.662 181.69 109.68 309.838M440.176 630.1c5.674 161.472 146.941 190.921 154.51 309.865M410.168 629.718C415.8 791.533 561.637 825.511 574.25 939.976M517.651 965h263.766M509.15 925h62.516m-67.084-15h62.916m-68.365-15h62.156m-61.451-15h53.32m-52.351-15h42.537m-41.57-15h30.052m-29.084-15h16.242m220.46 90h48.93m-49.563-15h53.464m-54.566-15h59.408m-60.902-15h58.568m-60.4-15h53.879m-56.23-15h49.706m-52.54-15h46.019m-49.254-15h42.732m-264.986 0h1.69m773.084 385.026C1228.267 1248.566 1162.43 1275 1090 1275c-157.915 0-285-125.286-285-280 0-47.532 11.992-92.13 33.2-131.287m377.734 295.368C1180.984 1184.775 1137.86 1200 1090 1200c-118.247 0-210-91.356-210-205 0-26.728 5.074-51.778 14.4-74.884m207.659 154.16A98.326 98.326 0 011090 1075c-49.23 0-81.28-31.039-84.697-72.551m122.875 91.256c-11.593 4.074-24.306 6.295-38.178 6.295-65.355 0-110-46.117-110-105 0-3.776.184-7.432.545-10.984m214.543 159.189C1165.452 1163.257 1129.736 1175 1090 1175c-105.024 0-185-80.047-185-180 0-21.157 3.582-40.966 10.251-59.442M657.5 981.893c3.536-24.748 35.355 7.072 10.607 10.607 20-15 20 30 0 15 24.748 3.535-7.072 35.355-10.607 10.607 15 20-30 20-15 0-3.536 24.748-35.355-7.072-10.607-10.607-20 15-20-30 0-15-24.748-3.535 7.072-35.355 10.607-10.607-15-20 30-20 15 0v0m5 18.107a12.5 12.5 0 01-12.5 12.5 12.5 12.5 0 01-12.5-12.5 12.5 12.5 0 0112.5-12.5 12.5 12.5 0 0112.5 12.5v0M585 965v70M218.77 700.347l-40.142-70.248m-8.876 73.217l-48.074-84.13M393.636 0L0 618.572m182.285-286.111C132.42 314.002 81.425 317.784 30 330c80.68-86.71 76.097-214.288 96.231-330.019M333.636 0L129.95 320.08M407.504-.494C347.657 225.87 197.332 687.942.002 664.067M437.92-.377c-48.183 224.09-98.68 536.286-312.233 615.102m14.684-311.021l48.889 17.46m-40.186-31.137l48.889 17.46m-39.26-32.593l48.89 17.46m-39.26-32.592l48.89 17.46M191.5 249.464l35.352 12.626m-9.352-21.912l18.98 6.78M41.885 326.783C57.688 315.967 73.403 305.062 85 290c21.74 8.59 42.457 4.21 63.307 1.516m-75.32-25.09c27.732 5.564 57.993 4.791 88.322 3.845m-55.958-116.504c25.887 22.417-3.06 72.378 34.649 91.233 36.056 18.028 59.083-37.958 35-50-20-10-45 25-20 35 14.131 5.652 20.131-28.64 10-20m-59.846-56.655c33.418 11.492 60.155-41.413 96.812-19.505 34.602 20.68-.183 70.226-23.296 56.412-19.193-11.471-3.156-51.381 18.73-35.696 12.37 8.866-13.3 32.383-11.472 19.194m47.025-15.329c-3.78-20.768-8.86-40.451-27.953-48.421 4.185-27.894 1.423-52.339-15-70 17.356-1.619 34.466-1.97 55-20 27.97 9.93 52.531 3.199 77.423-1.913m-71.645 112.064C245.718 118.856 239.783 108.146 230 100c1.504-14.349.287-26.396-5-35 8.496 1.206 21.772.599 35-10 8.99 6.928 20.596 8.627 32.671 9.386m101.824-17.5c13.934-4.564 26.21-13.093 38.204-22.301M387.56 71.24c14.724-4.38 27.57-13.257 40.103-22.878m-46.771 45.55c15.638-5.458 29.215-15.852 42.72-26.42m-50.69 52.46c16.64-3.748 30.812-13.406 44.6-23.982m-51.607 46.988c17.686-4.808 32.63-16.179 47.474-27.792m-55.862 53.275c18.785-2.66 34.356-13.013 49.436-24.542m-57.627 49.312c19.367-5.353 37.923-20.228 54.055-33.012m-62.58 57.627c20.311-4.34 39.846-19.82 56.769-33.234m-65.085 56.598c21.754-5.309 42.553-23.03 60.13-36.835m-68.21 59.166c21.962-8.66 47.288-25.829 63.013-37.795m-72.66 63.264c22.178-7.637 48.957-25.45 65.936-38.21m-75.948 63.53c22.09-6.185 50.267-24.47 68.662-38.076m-78.402 61.753c23.379-6.631 53.475-26.685 71.603-40.397m-82.384 65.53c22.643-4.32 53.99-24.473 73.969-39.227m-84.628 63.1c23.43-4.181 56.539-25.802 76.566-40.791m-85.34 59.673c24.058-6.308 56.529-20.98 74.84-33.277m-86.67 57.494c24.159-6.008 57.732-21.061 76.538-33.655m-89.718 59.146c21.064-3.606 53.839-17.136 75.832-29.886m-88.627 53.231c22.278-4.36 55.94-18.662 77.111-31.55m-91.729 56.474c22.428-4.476 56.123-18.85 77.147-31.73m-90.402 52.679c26.144-6.728 62.615-23.588 79.85-36.518m-96.412 60.66c24.045-5.903 57.634-20.912 76.61-33.53m-95.367 58.145c19.156-4.09 45.852-14.943 66.056-25.885m432.016-353.127c20.527 78.558 49.89 167.389 105.544 285.038m-99.268-366.296C665.263 149.955 660 217.745 660 225c0 15-18.164 142.538-35 155-17.901 13.25-60.727 84.764-70 90-25.806 14.57-68.62-14.676-75-20-40.525 11.388-131.542-97.081-100-115l-23.233-9.957m299.098-60.225c19.063 61.807 45.052 131.477 84.196 215.326M646.267 316.05c16.73 48.809 37.961 102.625 66.08 163.751m23.077-9.8H707.98m20.586-15h-27.271m20.601-15H694.61m20.729-15h-27.11m20.75-15h-26.994m20.737-15h-26.98m20.956-15h-26.806m20.853-15h-26.652m21.127-15H658.4m21.32-15h-26.68m21.18-15h-26.54m21.342-15h-20.006m14.841-15h-12.789M403.081 403.57c-18.422-18.29-35.836-38.597-51.878-61.653m148.444 138.168c-18.847-12.399-37.352-25.483-55.242-39.8m30.36 39.804c-47.3-32.467-91.934-70.275-129.443-122.353m105.179 122.33c-40.394-29.087-78.457-62.841-111.306-107.038m87.88 107.123c-33.897-25.697-65.875-55.24-94.156-92.186m71.145 92.047c-27.67-22.177-53.863-47.313-77.567-77.435m55.644 77.61c-22.013-18.661-42.964-39.45-62.318-63.437m40.674 63.27c-16.626-14.96-32.567-31.29-47.58-49.479m26.999 49.678c-11.772-11.229-23.16-23.225-34.075-36.172m13.697 35.966a452.267 452.267 0 01-21.063-22.871m1.508 22.885a448.413 448.413 0 01-9.163-10.177m82.606-121.223a437.787 437.787 0 01-16.237-22.58M525 480c-11.007-6.987-21.924-14.154-32.698-21.608M400 550c-11.508.084-22.758-3.17-33.797-9.171m-21.337 6.983c30.73 20.833 63.195 12.01 95.134 12.188-4.364-9.305-15.999-15.118-55.824-27.242m59.589-1.052c-11.508-.084-22.758 3.17-33.797 9.172m-21.337-6.984c30.73-20.833 63.195-12.01 95.134-12.188-4.364 9.305-15.999 15.118-55.824 27.242m60.856.223c-11.508.085-22.758-3.17-33.797-9.171m-21.337 6.983c30.73 20.833 63.195 12.011 95.134 12.188-4.365-9.304-15.999-15.118-55.825-27.241m59.59-1.052c-11.508-.085-22.758 3.17-33.797 9.17m-21.337-6.983c30.73-20.832 63.195-12.01 95.134-12.187-4.365 9.304-15.999 15.118-55.825 27.241m54.632 2.987c-11.508.084-22.758-3.17-33.797-9.171m-21.337 6.983c30.73 20.833 63.195 12.01 95.134 12.188-4.365-9.305-15.999-15.118-55.825-27.242m59.59-1.052c-11.508-.084-22.758 3.17-33.797 9.171M560 535c30.73-20.833 63.195-12.01 95.134-12.188-4.365 9.305-15.999 15.118-55.825 27.242m60.856.223c-11.507.085-22.758-3.17-33.796-9.171m-21.337 6.983c30.729 20.833 63.195 12.01 95.133 12.188-4.364-9.305-15.998-15.118-55.824-27.241m59.59-1.053c-11.508-.084-22.759 3.17-33.797 9.172m-21.337-6.984c30.729-20.832 63.195-12.01 95.133-12.188-4.364 9.305-15.998 15.119-55.824 27.242m61.926-.103c-11.508.085-22.758-3.17-33.797-9.17m-21.337 6.983c30.73 20.832 63.195 12.01 95.134 12.187-4.365-9.304-15.999-15.118-55.825-27.241m59.59-1.052c-11.508-.085-22.758 3.17-33.797 9.171m-21.337-6.983c24.743-16.775 50.612-14.323 76.425-12.824m6.442 11.997c-8.332 4.473-21.699 9.226-43.558 15.88M310 550c-11.508.084-22.758-3.17-33.797-9.171m-21.337 6.983c30.73 20.833 63.195 12.01 95.134 12.188-4.364-9.305-15.999-15.118-55.824-27.242m59.589-1.052c-11.508-.084-22.758 3.17-33.797 9.172m-21.337-6.984c30.73-20.833 63.195-12.01 95.134-12.188-4.364 9.305-15.999 15.118-55.824 27.242m-81.051-30.57c16.295-.55 32.754 1.71 49.076 1.62-4.365 9.304-15.999 15.118-55.825 27.241m15.825-17.242c-7.814-.057-15.508 1.425-23.098 4.26m-24.292 25.74c14.509-.011 29.121-1.786 43.625-1.706-2.956-6.3-9.244-11-25.362-17.142m592.724 7.134c-7.888-1.32-15.66-4.163-23.328-8.332m-21.337 6.984c16.734 11.344 33.982 13.895 51.38 13.894m145.15 451.33L930 1020c-2.197 12.537 1.914 18.21 5 25l50.346-16.208m4.7 11.785l-46.358 21.575c1.13 12.677 6.571 17.091 11.312 22.848l43.33-29.894m8.274 10.27l-38.486 35.02c5.78 11.34 12.476 13.403 19.023 16.974l31.678-40.556m15.46 9.975l-23.009 43.889c9.355 8.63 16.35 8.244 23.73 9.322l15.424-46.379m14.7 3.961L1055 1150c11.46 5.538 18.041 3.134 25.415 2.02l2.627-52.328m19.638-.41l5.642 55.094c12.536 2.204 18.212-1.903 25.003-4.985l-12.3-53.516M978.19 982.094l-50.64-7.461c-5.776 11.342-3.51 17.971-2.55 25.367h55.238m-123.224-33.837a12.5 12.5 0 01-13.44 11.483 12.5 12.5 0 01-11.483-13.44 12.5 12.5 0 0113.44-11.483 12.5 12.5 0 0111.483 13.44v0m-25.901 10.505c-26.097 12.998-21.794-41.833 1.956-24.923-12.998-26.097 41.833-21.794 24.923 1.956 26.097-12.998 21.794 41.834-1.956 24.923 12.998 26.098-41.833 21.794-24.923-1.956v0m30.079 72.445a12.5 12.5 0 01-10.094 14.512 12.5 12.5 0 01-14.512-10.093 12.5 12.5 0 0110.093-14.513 12.5 12.5 0 0114.513 10.094v0m-22.397 16.722c-21.955 19.182-31.677-34.952-4.419-24.607-19.183-21.955 34.952-31.676 24.606-4.418 21.956-19.183 31.677 34.951 4.42 24.606 19.182 21.955-34.952 31.676-24.607 4.419v0m56.286 58.754a12.5 12.5 0 01-6.573 16.41 12.5 12.5 0 01-16.41-6.573 12.5 12.5 0 016.572-16.41 12.5 12.5 0 0116.41 6.573v0m-18.064 21.329c-17.08 23.627-38.723-26.936-9.837-22.983-23.628-17.081 26.935-38.723 22.983-9.837 17.08-23.628 38.723 26.935 9.837 22.983 23.627 17.08-26.936 38.723-22.983 9.837v0m73.467 34.476a12.5 12.5 0 01.62 17.667 12.5 12.5 0 01-17.666.62 12.5 12.5 0 01-.62-17.666 12.5 12.5 0 0117.666-.62v0m-7.902 26.81c-6.074 28.515-46.306-8.987-18.288-17.046-28.515-6.074 8.987-46.306 17.046-18.288 6.074-28.515 46.306 8.987 18.288 17.046 28.515 6.074-8.987 46.306-17.046 18.288v0m77.419 7.49a12.5 12.5 0 018.413 15.548 12.5 12.5 0 01-15.547 8.414 12.5 12.5 0 01-8.413-15.547 12.5 12.5 0 0115.547-8.414v0m4.847 27.527c7.242 28.241-45.47 12.547-23.96-7.133-28.242 7.243-12.548-45.47 7.133-23.96-7.243-28.242 45.47-12.548 23.96 7.133 28.241-7.243 12.547 45.47-7.133 23.96v0m82.735-17.506a12.5 12.5 0 0112.908 12.077 12.5 12.5 0 01-12.078 12.909 12.5 12.5 0 01-12.908-12.078 12.5 12.5 0 0112.078-12.908v0m13.324 24.57c15.823 24.488-39.147 26.316-24.986.831-24.488 15.823-26.317-39.146-.832-24.986-15.823-24.487 39.147-26.316 24.987-.831 24.487-15.823 26.315 39.147.83 24.986v0m68.106-45.35a12.5 12.5 0 0116.367 6.68 12.5 12.5 0 01-6.681 16.367 12.5 12.5 0 01-16.367-6.681 12.5 12.5 0 016.681-16.367v0m21.21 18.205c23.514 17.236-27.19 38.545-23.048 9.686-17.236 23.514-38.545-27.19-9.686-23.048-23.514-17.236 27.19-38.545 23.048-9.686 17.236-23.514 38.544 27.19 9.686 23.048v0m-69.045-118.563L1160 1140c9.205-1.875 13.674-5.58 17.47-9.545M642.958.142c101.868 342.195 345.912 461.413 230.776 619.77M1090 605c-15-90 70-90 55 0 90-15 90 70 0 55 15 90-70 90-55 0-90 15-90-70 0-55v0m27.5-37.5c0 60 5 65 65 65-60 0-65 5-65 65 0-60-5-65-65-65 60 0 65-5 65-65v0m12.5 65a12.5 12.5 0 01-12.5 12.5 12.5 12.5 0 01-12.5-12.5 12.5 12.5 0 0112.5-12.5 12.5 12.5 0 0112.5 12.5v0m-68.718-28.86c-3.494-8.45-6.282-22.44-6.282-33.64 11.201 0 25.19 2.788 33.64 6.282m57.72 0c8.45-3.494 22.439-6.282 33.64-6.282 0 11.201-2.788 25.19-6.282 33.64m-112.436 57.72c-3.494 8.45-6.282 22.44-6.282 33.64 11.201 0 25.19-2.788 33.64-6.282m57.72 0c8.45 3.494 22.439 6.282 33.64 6.282 0-11.201-2.788-25.19-6.282-33.64m-93 160.423c1.01-6.686 3.44-15.94 9.282-21.783 10-10 70-40 80-40s20 15 30 15 15 25-5 25-35-10-35-10c1.742 21.62-12.85 27.104-25 35m18.114-12.771c4.683 23.139 1.313 41.743-5.947 58.157M1200 805c75-25 81.847 11.93 10 25-55 10.005-59.523-8.492-10-25v0m-1.8 26.716c70.635-18.93 77.553 15.292 8.552 25.39-52.822 7.73-56.804-12.458-8.552-25.39v0m1.096 28.595c71.882-9.683 74.715 25.171 5.475 26.3-53.004.864-54.577-19.685-5.475-26.3v0m.6-85.086c3.317-3.587 7.775-7.17 13.406-10.444 45.03-26.181 52.14 14.277 7.593 31.666-9.145 3.569-16.143 4.233-20.895 2.949M1185 765c-18.207-39.306 35-80 50-125 8.442 53.825 13.58 106.05-50 125v0m0 0c17.822-26.387 30.237-56.503 45-85m-104.14 46.04c13.272 3.425 26.206 12.942 39.14 33.96-62.532 6.437-112.583 3.272-130-25 25.777 2.578 48.897-8.134 70.729-10.21M1165 760c-24.02-10.251-51.599-16.772-85-17.184m-413.482-608.5c-18.879-6.562-35.786-16.162-50.088-31.494-19.19-20.57-34.207-52.086-41.326-102.76m92.18 123.927c-16.648-6.091-31.147-14.702-43.542-27.989-17.305-18.55-31.528-47.449-38.528-95.88m82.87 113.503c-14.338-5.566-26.503-13.16-37.03-24.443C615.61 72.623 602.197 46.31 595.33.175m67.196 88.792c-6.295-3.644-11.793-8.014-16.845-13.43C633.874 62.881 622.123 41.64 615.573.255m49.737 101.366c-10.353-4.768-19.137-10.896-26.943-19.264-13.611-14.59-26.2-38.348-32.918-82.136m54.002 74.55a64.334 64.334 0 01-6.459-6.056C642.96 57.96 632.065 39.195 625.703.27M511.871.155c-9.112 52.945-27.571 93.811-54.968 123.18-16.31 17.485-34.99 29.932-54.087 38.913M501.725.145c-8.96 50.73-26.61 89.007-52.135 116.369-13.336 14.296-28.342 25.032-43.923 33.185M491.572.122c-8.794 48.479-25.623 84.196-49.294 109.571-10.329 11.072-21.714 19.879-33.646 26.941M481.414.081c-8.613 46.192-24.607 79.376-46.449 102.79a139.304 139.304 0 01-23.16 19.91m11.371-52.895c11.807-16.758 21.41-39.17 27.669-69.743M471.25.019c-8.414 43.869-23.563 74.554-43.598 96.032a129.297 129.297 0 01-12.635 11.848M461.061.045c-8.456 42.736-23.376 71.372-42.434 90.983m236.61-35.342c-7.089-9.922-14.48-26.146-19.421-55.545M401.712 21.587C414.795 16.883 426.445 8.747 437.84 0M420 180c37.87-22.798 75.447-48.05 120-15v5c-60-35-70-10-120 10v0m170-10l-.003 5.472C610 155 635.344 158.686 660 165c-37.171-18.904-54.466-8.26-70 5v0m0 0s-5 15-5 45c0 25 20 85 20 95 0 13.032-12.277 22.123-20 20-4.821-1.326-20 20-20 20m-30-55c-10 0-30 35-5 35 40-15 60-5 0 0m-25 35l-5 10 10-5-5-5v0m95 0l-5 10-5-5 10-5v0m-90 5c10 0 20-5 30-5s15 5 20 5 10-5 15-5 10 5 15 5m-60 25c13.51 3.754 21.865 20.5 45 0m-45-200c-52.197-18.082-74.36 28.531-100 30 40 0 35.054 8.73 50 10 38.304 3.254 50.908-26.427 42.668-42.342M660 200c-35-30-55 20-75 15 29.24 6.592 50 30 75-5m502.673 545.563c-4.947-21.883-9.234-43.761-16.584-63.76M1185 765c-6.227-23.877-10.324-48.418-17.233-71.138m38.081 193.091c-6.148 4.442-17.953 6.432-27.298 7.323M582.36 665h56.466m-50.994 35h55.961m-46.461 35h54.646m-40.238 35h51.09m-32.557 35h43.852m-24.943 35h34.96m-20.456 35h27.431m-19.234 35h23.13M584.552 682.5h54.275c9.762.138 17.75-7.737 17.75-17.5s-7.988-17.638-17.75-17.5H582.36m9.666 70h51.768c9.762.138 17.75-7.737 17.75-17.5s-7.988-17.638-17.75-17.5h-55.961m16.066 70h48.08c9.762.138 17.75-7.737 17.75-17.5s-7.988-17.638-17.75-17.5h-54.646m23.35 70h42.148c9.762.138 17.75-7.737 17.75-17.5s-7.988-17.638-17.75-17.5h-51.09m28.246 70h34.139c9.762.138 17.75-7.737 17.75-17.5s-7.988-17.638-17.75-17.5h-43.852m26.914 70h26.956c9.761.138 17.749-7.737 17.749-17.5s-7.988-17.638-17.75-17.5h-34.96m19.373 70h22.562c9.762.138 17.75-7.737 17.75-17.5s-7.988-17.638-17.75-17.5h-27.431m10.425 70h20.903c9.761.138 17.749-7.737 17.749-17.5s-7.988-17.638-17.75-17.5h-23.13M467.6 665h75.16m-65.219 35h71.77m-53.875 35h65.54m-39.814 35h56.842m-26.58 35h47.914m-19.48 35h40.912m-19.52 35h35.867m-23.322 35h32.81M541.008 647.5H467.6c-9.762-.138-17.75 7.737-17.75 17.5s7.988 17.638 17.75 17.5h75.16m2.69 0h-67.91c-9.762-.138-17.75 7.737-17.75 17.5s7.988 17.638 17.75 17.5h71.77m5.273 0h-59.148c-9.762-.138-17.75 7.737-17.75 17.5s7.988 17.638 17.75 17.5h65.54m7.817 0h-47.63c-9.763-.138-17.75 7.737-17.75 17.5s7.987 17.638 17.75 17.5h56.84m10.364 0h-36.943c-9.762-.138-17.75 7.737-17.75 17.5s7.988 17.638 17.75 17.5h47.914m11.053 0h-30.534c-9.761-.138-17.749 7.737-17.749 17.5s7.988 17.638 17.75 17.5h40.912m9.019 0H601.25c-9.762-.138-17.75 7.737-17.75 17.5s7.988 17.638 17.75 17.5h35.867m5.516 0h-28.838c-9.762-.138-17.75 7.737-17.75 17.5s7.988 17.638 17.75 17.5h32.81"
        />
      </symbol>
      <symbol id="QC_svg__g" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={3}
          fill="none"
          d="M1184.474 767.204c.35 15.415 12.041 16.451 23.906 17.267m-26.929 27.27c3.625 9.318 6.247 17.207 2.045 21.087m-2.697 4.06c3.624 9.318 6.246 17.206 2.045 21.086m-2.045 6.656c3.624 9.318 6.246 17.206 2.045 21.086m30.873-75.44c1.874 2.948 2.833 6.142 2.593 9.658m3.69 17.471c1.457 3.175 1.974 6.47 1.26 9.92m-2.772 20.86c1.483 3.164 2.027 6.454 1.341 9.91M1220 775c1.874 2.948 2.833 6.142 2.593 9.658M435 205c29.854-29.76 89.915-20.22 87.766-12.15M480 250c21.575 13.39 40-25 45-40m65 5c17.561-51.28 55-40 60-25m-142.611.373C512.025 194.95 515 202.04 515 210c0 13.807-8.954 25-20 25s-20-11.193-20-25c0-4.329.88-8.4 2.429-11.95m176.057-2.61c.976 2.946 1.514 6.174 1.514 9.56 0 13.807-8.954 25-20 25s-20-11.193-20-25c0-2.248.237-4.427.683-6.5"
        />
        <use
          xlinkHref="#QC_svg__a"
          height={90}
          transform="matrix(.7071 -.56074 .7071 .56074 953.36 901)"
        />
        <use
          xlinkHref="#QC_svg__a"
          height={90}
          transform="matrix(.7071 -.56074 .7071 .56074 1061.36 978)"
        />
        <use
          xlinkHref="#QC_svg__a"
          height={90}
          transform="matrix(.7071 -.56074 .7071 .56074 1165.36 1060)"
        />
      </symbol>
      <rect
        width={211}
        height={328}
        x={-105.5}
        y={-164}
        rx={12}
        ry={12}
        fill="#fff"
        stroke="#000"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#QC_svg__b" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#QC_svg__b"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#QC_svg__c" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#QC_svg__c"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#QC_svg__d" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#QC_svg__d"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#QC_svg__e" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#QC_svg__e"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#QC_svg__f" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#QC_svg__f"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#QC_svg__g" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#QC_svg__g"
      />
      <use xlinkHref="#QC_svg__h" height={50} x={-104} y={-152.5} />
      <use xlinkHref="#QC_svg__a" height={41.827} x={-99.913} y={-97.5} />
      <use xlinkHref="#QC_svg__a" height={38.6} x={21.695} y={-109.3} />
      <g transform="rotate(180)">
        <use xlinkHref="#QC_svg__h" height={50} x={-104} y={-152.5} />
        <use xlinkHref="#QC_svg__a" height={41.827} x={-99.913} y={-97.5} />
        <use xlinkHref="#QC_svg__a" height={38.6} x={21.695} y={-109.3} />
      </g>
      <use xlinkHref="#QC_svg__i" stroke="#44F" fill="none" />
    </svg>
  );
}

export default SvgQc;
