import * as React from "react";

function SvgQd(props) {
  return (
    <svg
      className="QD_svg__card"
      preserveAspectRatio="none"
      viewBox="-106 -164.5 212 329"
      {...props}
    >
      <defs>
        <path id="QD_svg__i" d="M-58-112.5H58v225H-58z" />
      </defs>
      <symbol
        id="QD_svg__h"
        viewBox="-500 -500 1000 1000"
        preserveAspectRatio="xMinYMid"
      >
        <path
          d="M-260 100c300 0 220 360 520 360M-175 0v-285a175 175 0 01350 0v570a175 175 0 01-350 0z"
          stroke="red"
          strokeWidth={80}
          strokeLinecap="square"
          strokeMiterlimit={1.5}
          fill="none"
        />
      </symbol>
      <symbol
        id="QD_svg__a"
        viewBox="-600 -600 1200 1200"
        preserveAspectRatio="xMinYMid"
      >
        <path
          d="M-400 0C-350 0 0-450 0-500 0-450 350 0 400 0 350 0 0 450 0 500 0 450-350 0-400 0z"
          fill="red"
        />
      </symbol>
      <symbol id="QD_svg__b" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#FC4"
          d="M216.555 0c22.671 33.815 49.204 66.355 53.94 105.508l-25.364 36.035-3.986-4.102c6.32-11.198 5.98-26.775-9.49-42.414C199.507 62.532 146.221 132.374 90 90c50 50-6.776 124.444 29.752 149.355 25.358 17.294 44.433 10.197 53.541-3.55l3.41 3.119c-8.946 12.73-17.892 25.461-26.592 37.853-25.816 4.595-50.6 6.062-70.111-6.777-14.682 26.212-45.302 28.698-70 40 61.376.312 120.483 3.772 154.338 42.287L411.893 0H216.555zm416.918 0l8.816 25.467C760.632 186.749 859.8 286.03 876.721 574.873l31.297 25.848C895.37 279.397 784.08 169.326 660.838 0h-27.365zm49.304 231.158l-3.29 51.135a529.277 529.277 0 0110.33 18.457c24.306 45.579 42.877 96.272 54.718 165.254l34.537 28.36c-15.83-119.84-49.161-192.812-96.295-263.206zm-402.35 171.684l-11.126 27.957c90.347 32.01 178.351 53.163 271.209 57.447-21.405-9.819-42.855-20.98-60.51-18.246-24.29 3.763-48.682-9.915-69.5-29.479-42.951-9.33-86.012-22.163-130.072-37.68zm-11.165 28.033C243.943 488.3 208.577 533.649 166.486 568c116.13 44.757 235.198 76.286 363.186 83.35l-2.276-.018L628.943 861.68l95.983-7.366c-73.626 12.42-154.804 10.872-249.02-14.789l6.092 32.59c160.352 40.145 287.864 12.701 399.988-33.312l-10.918-27.94c-46.131 19.01-94.092 34.636-145.77 43.389l-97.603-202.178-4.16-.031c89.463-3.608 183.635-19.569 284.367-51.379L750.936 471.48l-30.266-24.807c-32.206 5.738-63.265 9.475-93.135 10.875-7.876 11.692-16.5 22.512-25.623 30.974 40.733-.486 83.422-4.828 128.137-12.99-44.724 8.17-87.476 12.572-128.684 13.494C593.907 495.794 586.486 500 580 500c-11.754 0-25.097-5.31-38.824-11.453-93.522-4.586-181.528-25.74-271.914-57.672zm869.035 68.377c-22.784.772-47.828 39.967-8.297 50.748-55 15 15 85 30 30 15 55 85-15 30-30 55-15-15-85-30-30-4.219-15.469-12.788-21.05-21.703-20.748zm136.127 104.445c-23.587-.514-39.81 16.03-54.424 36.303l15 10c24.284-10.693 46.335-22.648 50-45-3.687-.808-7.207-1.23-10.576-1.303zm-221.385 25.215c-17.503.055-35.16 7.582-53.039 26.088 39.672 4.959 54.753 44.346 137.924 20.602l1.693-.938c-28.657-25.18-57.406-45.844-86.578-45.752zm-27.89 68.434l-132.8 160.218c20.037 27.174 39.698 49.955 58.553 71.457C921.952 972.377 905 1023.82 905 1080c0 95.074 48.797 177.617 123.053 226.049l15.675 10.223 53.934-53.58c-1.894-19.38-4.182-37.427-6.965-53.876-4.039 1.088-8.097 1.296-12.236.99C1016.016 1206.1 970 1151.352 970 1090c0-29.304 10.124-57.732 29.367-80.127 3.22-3.856 6.962-7.155 10.533-10.05 42.224 57.385 74.671 127.706 87.983 262.47l170.73-170.865 15.026-14.893-.024-.12 16.385-16.4v-.007l-16.387 16.392c-6.905-37.354-17.927-72.609-39.068-101.388-17.397-23.684-41.763-42.338-74.684-53.196-5.923-4.443-15.715-8.488-29.9-11.015a40 40 0 01-39.156 39.17c11.378 63.779 53.95 39.17 44.195 5.029 14.485 4.138 27.256-1.142 32.21-9.46 22.213 9.907 38.579 24.106 51.218 41.312 14.532 19.783 24.031 44.131 30.224 70.37-16.884-23.369-41.272-2.487-33.642 24.217-18.716-5.347-34.572 5.033-34.543 17.467-19.833-6.863-37.303-16.203-51.385-29.021-25.365-23.089-41.373-57.883-41.193-113.778.443-1.684.886-3.81 1.306-6.148A40 40 0 011060 910a40 40 0 0140-40 40 40 0 0139.97 39.195c63.78-11.378 39.17-53.95 5.03-44.195 9.139-31.986-27.659-55.621-41.988-4.662-6.604-30.946-16.217-61.528-33.072-87.512L1300 962.393V923.54l-274.852-226.195zm-3.782 52.2c10.657 7.85 19.522 17.043 27.06 27.306 11.322 15.412 19.588 33.595 25.202 53.597-13.245-.552-24.066 15.521-18.629 34.551-24.132-6.895-43.51 12.357-30.252 28.37-25.781-7.16-48.3-17.678-65.666-33.485-5.606-5.103-10.756-10.778-15.373-17.135l77.658-93.203zm212.479 9.975l-15.77 2.196c13.8 28.309 34.269 51.3 14.559 106.336l12.414 9.654c12.691-33.117 12.725-58.556 6.767-78.838-4.666-15.888-12.026-28.085-17.97-39.348zM1015 810c-8.284 0-15 6.716-15 15 0 8.284 6.716 15 15 15 8.284 0 15-6.716 15-15 0-8.284-6.716-15-15-15zm-78.44 55.57a129.504 129.504 0 009.06 9.106c24.941 22.704 57.134 35.169 92.028 42.886-33.902 16.09-11.727 45.746 17.352 37.438-6.494 22.727 10.204 41.238 25.162 32.348 4.917 43.822 21.223 75.268 45.457 97.328 27.69 25.205 64.317 37.79 104.244 45.158l36.348-36.025-141.383 141.433c-13.615-111.338-41.96-181.004-78.51-235.687-33.368-49.923-71.292-86.38-109.757-133.985zm-54.247 5.424C771.48 914.7 641.83 940.414 484.707 903.615l.324 30.81c143.122 31.823 266.358 13.765 371.356-21.993l25.926-41.438zM1175 1005a15 15 0 00-15 15 15 15 0 0015 15 15 15 0 0015-15 15 15 0 00-15-15zm-30 130c-8.284 0-15 6.716-15 15 0 8.284 6.716 15 15 15 8.284 0 15-6.716 15-15 0-8.284-6.716-15-15-15z"
        />
      </symbol>
      <symbol id="QD_svg__c" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="red"
          d="M411.893 0L0 586.152V715.77L502.973 0zm230.53 25.78C660.15 77.16 690 165.892 690 180c0 13.049-4.256 34.612-7.219 50.98 47.13 70.573 80.46 143.543 96.291 263.383l97.649 80.51C859.799 286.03 760.633 186.748 642.424 25.779zM1160 445c-22.788 0-45.574 18.414-27.506 55.24 10.8-3.24 22.373.94 27.506 19.76 5.133-18.82 16.705-23 27.506-19.76 18.068-36.826-4.718-55.24-27.506-55.24zm-73.88 70.963c-48.389-.4-40.347 93.172 24.12 61.543-3.24-10.8.94-22.373 19.76-27.506-18.82-5.133-23-16.705-19.76-27.506-9.185-4.506-17.227-6.474-24.12-6.531zm147.76 0c-6.893.057-14.935 2.025-24.12 6.531 3.24 10.8-.94 22.373-19.76 27.506 18.82 5.133 23 16.705 19.76 27.506 64.467 31.629 72.508-61.943 24.12-61.543zM1160 533.664A16.158 16.336 0 001143.842 550 16.158 16.336 0 001160 566.336 16.158 16.336 0 001176.158 550 16.158 16.336 0 001160 533.664zm0 46.336c-5.133 18.82-16.705 23-27.506 19.76-36.135 73.652 91.147 73.652 55.012 0-10.8 3.24-22.373-.94-27.506-19.76zm-277.832 60.62c-72.056 19.599-141.373 32.177-208.139 38.247l81.155 169.358c40.212-8.87 78.642-22.015 115.687-37.704C863.78 788.403 860 764.74 860 740c0-35.877 7.95-69.491 22.168-99.38zm-507.363 20.685c49.626 47.836 85.528 109.62 101.197 178.605 41.477 10.938 80.512 17.569 118.213 20.363L508.072 679.82c-45.301-3.45-89.723-9.771-133.267-18.515zM1100 885a25 25 0 00-25 25 25 25 0 0025 25 25 25 0 0025-25 25 25 0 00-25-25zm-62.447 157.744c-11.378 12.652-17.553 29.63-17.553 47.256 0 37.163 26.967 67.85 61.428 69.79-11.175-48.272-26.047-85.33-43.875-117.046z"
        />
      </symbol>
      <symbol id="QD_svg__d" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          fill="#44F"
          d="M664.824 217.748l-17.85 3.004c-1.752 4.07-2.802 9.262-2.802 14.92 0 13.058 5.596 23.644 12.5 23.644 6.903 0 12.5-10.586 12.5-23.644 0-7.167-1.686-13.588-4.348-17.924zm-152.324.43a12.5 23.644 0 00-12.5 23.644 12.5 23.644 0 0012.5 23.645 12.5 23.644 0 0012.5-23.645 12.5 23.644 0 00-12.5-23.644zM283.738 393.406l-3.31 9.436c44.06 15.516 87.121 28.348 130.32 37.861l-12.828-13.152c-37.73-9.002-75.516-20.527-114.182-34.145zm426.748 44.89c-26.25 4.427-51.715 7.504-76.586 9.327l-6.72 10.434c30.225-1.91 61.284-5.647 93.49-11.385zM137.471 589.21c-23.17 15.07-48.005 27.179-73.742 36.041L0 715.793v181.795l264.234-264.156c-42.968-12.7-85.195-27.608-126.763-44.223zm770.646 11.545C878.406 636.06 860 685.41 860 740c0 44.177 12.055 84.923 32.361 117.592l132.875-160.174zm-346.16 52.008l99.924 208.527c11.205-.632 22.438-1.553 32.84-2.764l-99.953-205.693c-10.825.111-21.598.054-32.811-.07zm-187.164 8.52c43.554 8.765 87.978 15.087 133.482 18.47zM595 677.274a10 10 0 0110 10 10 10 0 01-10 10 10 10 0 01-10-10 10 10 0 0110-10zm22.434 46.684a10 10 0 0110 10 10 10 0 01-10 10 10 10 0 01-10-10 10 10 0 0110-10zm22.431 46.684a10 10 0 0110 10 10 10 0 01-10 10 10 10 0 01-10-10 10 10 0 0110-10zm22.434 46.685a10 10 0 0110 10 10 10 0 01-10 10 10 10 0 01-10-10 10 10 0 0110-10zm255.71 73.764a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm17.15 19.9l-37.386 9.447-5.103 10.116 12.475 30.427-33.979 17.6-3.074 10.357 18.11 31.944-29.548 24.033-.972 10.686 24.937 29.23-23.726 34.486 1.578 10.174 31.504 24.47-15.385 37.474 3.916 9.712 36.086 15.887-5.526 41.418 6.098 8.371 38.596 6.985 3.013 40.162 6.782 6.906 47.527 4.445-2.658 25.438 16.752-15.975 1.613-15.443-6.762-8.246-48.77-4.563-2.974-39.633-6.142-6.818-37.26-6.742 5.324-39.906-4.412-7.856-34.549-15.21 14.772-35.981-2.338-8.772-30.416-23.627 22.976-33.396-.474-9.117-23.688-27.768 28.508-23.187 1.793-9.518-17.395-30.684 33.155-17.172 3.488-9.503-11.797-28.78 33.365-8.431a7.476 7.476 0 003.184-1.637zm-49.991 36.955a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm-19.293 62.192a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm-5.543 67.324a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm9.854 73.893a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm27.093 69.785a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm41.666 58.908a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5zm58.086 52.135a7.5 7.5 0 00-7.5 7.5 7.5 7.5 0 007.5 7.5 7.5 7.5 0 007.5-7.5 7.5 7.5 0 00-7.5-7.5z"
        />
      </symbol>
      <symbol id="QD_svg__e" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path d="M1025.515 697.647l-25.28-20.368C989.952 689.78 980 712.384 980 740c0 3.922.195 7.744.686 11.316zm-91.732 110.09C925.197 788.131 920 765.005 920 740c0-41.103 14.18-77.08 34.055-100.799l-22.996-19.27C906.29 649.49 890 692.155 890 740c0 34.746 8.556 66.77 22.761 93.011m-30.244-193.404c-72.405 20.612-141.721 33.19-208.487 39.26l81.559 169.126-30.274 6.293-97.437-202.308c88.306-4.07 180.998-20.042 280.024-51.314M594.89 860.324L508.073 679.82c-45.302-3.45-89.725-9.772-133.167-18.417-16.41-15.827-34.458-30.224-53.427-42.809 66.752 17.082 134.816 28.6 205.749 32.701l102.104 210.47c-11.04-.031-22.665-.51-34.443-1.442zm287.424 10.67c-110.831 43.705-240.483 69.42-397.607 32.622l-2.707-31.5c160.352 40.144 287.863 12.7 399.987-33.313l10.341 18.76zM-.649 940.649l321.914-322.167c-52.749-13.6-104.258-30.608-155.127-50.2-8.87 7.219-18.128 13.978-28.235 20.645a1309.719 1309.719 0 00126.33 44.505L-.31 897.884m318.977-765.218L310 85l45-5-5-50 44.268-4.919M274.19 195.957L265 150l47.563-8.648m-78.115 111.163L225 210l45.754-9.15m-71.392 101.597L190 265l42.277-9.395m-68.12 96.94L150 310l47.383-4.738m463.18 91.303c4.387-10.108 7.593-19.187 9.437-26.565 6.01-24.04 8.408-58.918 9.425-86.4 3.628 4.784 7.072 10.926 10.391 17.15 24.307 45.579 42.879 96.272 53.035 163.909z" />
      </symbol>
      <symbol id="QD_svg__f" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={6}
          fill="none"
          d="M485.032 934.425c143.122 31.822 266.357 13.765 371.355-21.994m-371.68-8.815c157.123 36.799 286.775 11.083 397.606-32.622M507.871 679.887l87.077 180.374m160.64-12.268l-81.541-168.908M892.372 857.62C872.054 824.923 860 784.177 860 740c0-54.589 18.405-103.939 48.065-139.335m189.597 662.026c-23.93-244.901-111.057-277.296-205.313-405.126l132.972-159.912M1300 923.529L660.366 396.772m-338.909 221.77L.788 939.213M321.114 618.57C419.82 682.947 485 793.909 485 920c0 83.944-28.89 161.184-77.327 222.436M166.038 568.35c222.811 85.351 455.935 122.608 741.864 32.315M674.013 678.65c66.783-5.853 136.1-18.43 208.504-39.043m-507.723 21.675c43.554 8.766 87.977 15.088 133.481 18.47m-370.97-90.4c41.734 16.473 83.96 31.38 126.9 44.2m615.883-55.726c-264.41 78.944-479.531 46.19-688.846-31.994m646.678-2.77C603.554 606.59 413.05 578.63 222.995 509.63m586.32 9.922c-215.428 54.101-390.784 28.357-568.548-35.35m539.58 11.503C583.126 540.992 422.05 516.867 256.16 457.9m284.954 30.687c-93.46-4.626-181.467-25.78-271.814-57.79m481.636 40.681c-52.358 10.79-101.991 16.482-149.863 17.777m-73.676 162.077L628.944 861.68m96.371-7.394l-97.62-202.213m-66.242.795l100.65 208.489m31.963-2.793l-99.313-205.72M475.907 839.526c160.525 43.72 283.216 17.466 395.161-28.663M482 872.115c160.352 40.145 287.863 12.701 399.987-33.312M0 715.769L502.973 0M307.836 277.857c-19.154 191.727-120.843 304.127-244.15 347.624m418.57 339.049c58.999 12.802 114.945 17.45 167.75 16.067m-165.85-36.124c58.493 12.898 113.776 17.574 165.891 16.177m-166.674-6.113c58.685 12.824 114.245 17.478 166.657 16.092m-169.134 3.837c59.417 12.831 115.84 17.498 169.12 16.12m-.024 28.817c-68.6 1.797-131.899 13.776-189.706 31.289m18.904-66.365c59.965 12.916 116.974 17.622 170.823 16.247m-.028-1.148c-65.257 1.666-125.873 12.263-181.487 28.001m181.453 11.923c-72.951 1.954-139.695 15.805-200.345 35.65m200.362-45.629c-70.625 1.869-135.534 14.705-194.666 33.3m194.68-53.257c-66.826 1.729-128.708 12.967-185.354 29.531m12.645-44.8a756.464 756.464 0 0049.427 8.937m.559-.033a775.133 775.133 0 00-55.443 13.072M980.56 751.45a116.88 116.88 0 01-.56-11.451c0-27.616 9.952-50.221 20.043-62.264m-66.26 130.001C925.197 788.131 920 765.005 920 740c0-41.103 14.18-77.08 34.055-100.799m-41.294 193.81C898.556 806.771 890 774.746 890 740c0-47.846 16.291-90.51 41.059-120.068m193.768 615.31c-13.614-111.338-41.958-181.004-78.509-235.687-35.05-52.438-75.124-89.992-115.574-141.244l98.838-118.86m.114.338L1300 962.393m-234.594 332.2l-20.965-13.673C978.336 1237.804 935 1164.735 935 1080c0-47.182 13.333-90.316 36.648-127.134m72.08 363.406l-15.675-10.223C953.797 1257.617 905 1175.074 905 1080c0-56.187 16.956-107.635 46.23-150.684m49.143 430.312l-5.098-3.325C904.72 1297.24 845 1195.75 845 1080c0-74.36 24.612-142.691 66.254-197.867m170.169 277.76A65 70 0 011020 1090a65 70 0 0117.291-47.542m58.6-287.51c2.945-15.558 13.38-62.447 34.109-74.948 25.842-15.585 34.723-11.668 62.036-30.683 31.58-21.984 61.133.186 20 25C1177.547 695.124 1180 690 1165 695c15 35 10 60-10 70m75-82.424c44.022-16.042 67.9 3.138 10 22.424-82.883 27.607-70.718-.297-10-22.424v0m1.724-28.197c39.536-13.043 58.999 5.446 5.112 24.032-28.255 9.746-45.072 12.574-52.426 11.18m52.258 16.396c42.513-16.042 65.571 3.139 9.657 22.424-80.042 27.608-68.294-.297-9.657-22.424v0m9.954 23.802c38.29-14.166 57.679 5.998 7.408 22.818-71.963 24.077-60.22-3.28-7.409-22.818v0m-3.824 46.315c9.16-9.437 15.743-18.45 17.203-25.648m-79.761 74.446c14.707-9.097 34.53-23.214 50.771-37.604m-12.934-25.581c13.8 28.309 34.27 51.3 14.56 106.336m12.413 9.653c12.692-33.117 12.724-58.555 6.767-78.837-4.666-15.888-12.027-28.085-17.971-39.347M1160 520c-15-55-85 15-30 30-55 15 15 85 30 30 15 55 85-15 30-30 55-15-15-85-30-30v0m16.158 30A16.158 16.336 0 011160 566.336 16.158 16.336 0 011143.842 550 16.158 16.336 0 011160 533.664 16.158 16.336 0 011176.158 550v0m-43.625-49.675c-36.29-73.766 91.224-73.766 54.934 0m22.208 22.208c73.767-36.29 73.767 91.224 0 54.934m-22.208 22.209c36.29 73.766-91.224 73.766-54.934 0m-22.208-22.21c-73.767 36.29-73.767-91.223 0-54.933M1130 550h-45m5 0a5 5 0 01-5 5 5 5 0 01-5-5 5 5 0 015-5 5 5 0 015 5v0m70-30v-45m0 5a5 5 0 01-5-5 5 5 0 015-5 5 5 0 015 5 5 5 0 01-5 5v0m30 70h45m-5 0a5 5 0 015-5 5 5 0 015 5 5 5 0 01-5 5 5 5 0 01-5-5v0m-70 30v45m0-5a5 5 0 015 5 5 5 0 01-5 5 5 5 0 01-5-5 5 5 0 015-5v0m11.482-81.482L1185 525m5 0a5 5 0 01-5 5 5 5 0 01-5-5 5 5 0 015-5 5 5 0 015 5v0m-18.522 36.479L1185 575m0 5a5 5 0 01-5-5 5 5 0 015-5 5 5 0 015 5 5 5 0 01-5 5v0m-36.479-41.479L1135 525m-5 0a5 5 0 005 5 5 5 0 005-5 5 5 0 00-5-5 5 5 0 00-5 5v0m18.518 36.482L1135 575m0 5a5 5 0 005-5 5 5 0 00-5-5 5 5 0 00-5 5 5 5 0 005 5v0m35.154 73.59l3.916 6.527m11.885-15.193l3.602 6.005m-50.051 23.785c-31.729-18.3-66.633-26.312-104.506-24.714m104.617 24.663C1093.767 634.375 1047.68 605.651 1000 655c39.672 4.959 54.752 44.346 137.923 20.602M1220 640c16.701-23.17 35.506-41.468 65-35-3.665 22.352-25.716 34.307-50 45M660.962.18c123.195 169.233 234.412 279.322 247.056 600.54M642.289 25.467C760.632 186.748 859.8 286.031 876.722 574.873M682.777 231.16c47.134 70.394 80.466 143.364 96.296 263.205m-99.587-212.07a529.266 529.266 0 0110.33 18.456c24.307 45.579 42.879 96.272 54.72 165.254M0 586.154L411.892 0m221.627.035C646.37 36.81 690 162.945 690 180c0 20-10 60-10 70s0 80-10 120-60 130-90 130-70.354-34.592-100-30c-70.89 10.981-142.669-126.598-130-130 0 0-5.347 10.755-10 10-17.89-2.903-28.811-31.84-34.625-54.087m-141.218 56.632C130.484 313.772 71.376 310.312 10 310c24.698-11.302 55.318-13.788 70-40 19.51 12.84 44.295 11.371 70.358 6.438m-32.463 46.173L344.595 0m-226.7 322.612v0m-67.698-11.416a177.98 177.98 0 004.395-1.785c10.374-4.38 21.25-10.633 30.031-20.346 17.087 6.838 35.606 6.886 53.746 4.514M90 90c50 50-6.776 124.444 29.752 149.356 50.522 34.455 76.102-27.914 47.612-46.78C141.357 175.357 119.228 211.722 140 220c13.525 5.39 20 0 20-10M90 90c56.222 42.374 109.509-27.469 141.655 5.027 36.779 37.179-11.958 74.012-32.409 52.48-22.33-23.512 11.17-52.634 23.5-31.038 8.027 14.062-.294 19.991-9.9 16.875M190 220c17.04-28.965-18.498-48.181-40-70 27.148 10.568 55.142 33.88 80 10m40.122-53.906c-4.394-39.668-30.887-72.24-53.549-106.041m65.772 88.566C274.242 54.85 253.2 26.541 234.71-.08m83.957 132.747L310 85l45-5-5-50 44.268-4.919M274.19 195.957L265 150l47.563-8.648m-78.115 111.163L225 210l45.754-9.15m-71.392 101.597L190 265l42.277-9.395m-68.12 96.94L150 310l47.383-4.738m-33.226 47.283v0m249.73-225.583C495.082 106.918 535.726 55.283 571.734.038m-54.164.03c-16.37 23.324-33.163 42.983-55.437 58.05M535.716.084c-24.8 36.445-50.753 66.711-92.73 85.516M553.765.072c-31.093 46.79-64.663 87.322-126.322 107.456m243.273 2.953C628.164 83.296 600.622 42.847 575.76.031m52.707.041c3.462 5.47 6.958 10.745 10.537 15.817M610.812.125c12.791 20.952 26.051 39.934 41.923 56.083M593.293.18c19.567 32.943 40.446 62.822 69.325 85.45M340 265c10 55-15 45 0 25m85-90c32.57-21.833 65.334-43.275 130 0-2.101-1.048 2.388 5.299.447 3.986C520 180 475.77 168.206 425 200v0m180-5c31.44-37.479 60-20 85-10-25-5-60-20-85 15v-5 0m0 0c-10 90 20.912 95.608 20 150 0 10-30 5-30 20m-35-45c-21.322.138-52.198 34.45-10 35 7.172.093 17.261-10.366 22.04-10.045 38.619 2.596-.876 5.279-12.04 5.045m-35 40v10l5-5-5-5v0m105 0v10l-5-5 5-5v0m-5 5c-5 0-25-5-30-5s-10 5-15 5-15-5-20-5c0 0 5 0 0 0s-20 5-30 5m30 20c5 15 40 15 40 0M435 245c28.544 10.017 49.297-25 75-25 30 0 44.732 33.14 50 30m-95-10c22.444 55 85 0 95 10m125-25c-32.58-22.584-65 15-80 20 15 0 65 35 77.777-13.841M349.18 341.516l-.271-.086m1.795 11.032c-2.867-.892-5.742-1.799-8.623-2.72m68.667 90.961c-43.198-9.513-86.258-22.346-130.319-37.862m38.584-71.279a1528.002 1528.002 0 01-15.961-5.576m28.698 20.405a1436.914 1436.914 0 01-32.048-10.983m55.838 28.985c-19.184-5.81-38.61-12.26-58.427-19.293m64.714 31.584c-22.02-6.45-44.295-13.743-67.042-21.798m74.385 34.288c-25.251-7.109-50.758-15.332-76.825-24.544m85.167 37.182c-28.905-7.77-58.04-17.008-87.836-27.52m97.263 40.29c-33.022-8.41-66.216-18.745-100.176-30.715M397.92 427.55c-37.73-9.002-75.516-20.526-114.181-34.144m436.932 53.266c-32.206 5.737-63.266 9.475-93.492 11.385m41.863-53.992a777.603 777.603 0 01-12.411 1.468m23.035 7.19a789.15 789.15 0 01-28.248 3.382m38.539 5.228a800.242 800.242 0 01-43.868 5.298m54.382 3.187c-20.594 3.274-40.693 5.704-60.397 7.338m70.413 1.142c-26.25 4.426-51.717 7.503-76.587 9.325m-423.34 105.14l15.02-46.562m70.863-66.178l-44.98 126.766m80.302-115.647L294.35 580.02m77.575-117.716L339.45 592.199m68.86-121.386l-20.68 132.355m44.38 8.187c4.337-43.872 6.407-90.011 10.62-134.007m32.883 139.705l3.83-134.086m40.245 138.01l-3.948-134.22m47.898 136.18L547.57 491.203m58.679 131.648l-26.883-122.894m72.415 120.678l-45.255-131.65m83.503 128.173l-50.298-129.937m96.05 123.74l-59.415-127.32m106.108 118.816l-73.99-123.316m127.934 110.785l-98.807-115.992M245.96 365.751c1.55 37.591-1.767 78.673-6.764 120.96m21.894-142.46c1.211 36.592-2.044 76.388-6.877 117.315m21.833-138.6c1.176 32.637-1.242 67.853-5.193 104.168m-41.305-38.012c1.682 37.378-1.517 78.258-6.441 120.375m-8.505-99.123c1.533 36.48-1.531 76.259-6.276 117.242m-8.672-95.952c1.354 34.733-1.41 72.422-5.793 111.27m-9.158-89.98c1.167 32.45-1.218 67.448-5.13 103.542m-9.823-82.176c.975 29.706-.99 61.521-4.35 94.338m-10.779-72.824c1.08 26.37-.233 54.456-2.839 83.47m-12.317-61.925c1.112 22.583.414 46.466-1.393 71.143m-13.548-49.915c.87 18.798.498 38.487-.71 58.776m-17.706-32.575c.439 13.78.247 28.01-.42 42.584m-14.54-21.282c.266 9.207.254 18.612.01 28.185M290.999 301.73c.944 24.246-.119 49.931-2.337 76.446m809 884.514c-23.93-244.901-111.057-277.296-205.313-405.126l132.972-159.912m8.653 435.71l-58.091 42.569c-8.064 7.699-8.277 20.504-.473 28.467 7.803 7.963 20.61 8.008 28.47.101l48.17-54.161m-35.357-140.99l-31.076-22.708a20.002 20.002 0 10-23.602 32.297l64.792 39.877m0 0l-59.602-27.54a20.004 20.004 0 00-5.908-.906c-9.998-.022-18.477 7.342-19.855 17.245-1.378 9.903 4.768 19.302 14.392 22.011l64.382 14.675m0 0l-61.17-4.64c-11.113.667-19.543 10.282-18.751 21.388.791 11.106 10.5 19.428 21.596 18.512l60.53-10.633m0 0l-61.284 15.983c-10.332 4.216-15.216 16.071-10.852 26.342 4.364 10.27 16.288 14.984 26.494 10.473l57.195-28.361m18.075 16.975l-46.82 73.927c-4.814 10.067-.459 22.127 9.678 26.796 10.136 4.668 22.132.139 26.653-10.064l29.287-82.678m0 0l-25.173 104.776c-1.469 11.067 6.407 21.195 17.496 22.497 11.088 1.302 21.096-6.726 22.23-17.833l6.325-53.888M1145 955c10 35-35 60-45-10-10 70-55 45-45 10-35 10-60-35 10-45-70-10-45-55-10-45-10-35 35-60 45 10 10-70 55-45 45-10 35-10 60 35-10 45 70 10 45 55 10 45v0m125.01 136.44c-10-70-55-45-45-10-35-10-60 35 10 45m-44.514-27.444c-19.862-6.953-37.332-16.293-51.414-29.111-25.365-23.089-41.373-57.883-41.07-114.582m-18.137 32.134c5.204 43.733 21.51 75.18 45.744 97.239 27.69 25.205 64.317 37.791 104.245 45.159m53.774-53.3c-6.904-37.404-17.927-72.709-39.093-101.523-17.397-23.684-41.763-42.338-75.113-53.48m7.7 24.01c22.292 9.905 38.657 24.104 51.296 41.31 14.532 19.783 24.032 44.131 30.678 71.048M936.395 865.388a129.36 129.36 0 009.224 9.288c24.942 22.704 57.134 35.168 92.458 42.803m-13.309-23.995c-25.802-7.274-48.32-17.792-65.686-33.6a112.539 112.539 0 01-15.385-17.151m77.568-93.263c10.703 7.867 19.6 17.086 27.163 27.382 11.32 15.412 19.588 33.594 25.831 53.604m28.46 31.244c-6.313-32.318-15.93-62.91-32.795-88.9M1030 825a15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15 15 15 0 0115 15v0m160 195a15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15 15 15 0 0115 15v0m-30 130a15 15 0 01-15 15 15 15 0 01-15-15 15 15 0 0115-15 15 15 0 0115 15v0m70.86-24.341l-3.262 3.712m40.808-46.453l-37.547 42.74m50.989-58.04l-13.442 15.3m31.595-35.964l-18.153 20.664m-71.037 58.135l-87.43 99.522M1300 1024.228l-22.258 25.336m-83.073 71.836l-74.117 84.37M1257 1050.444l-2.124 2.418m45.122-51.363l-27.22 30.986m-134.827 130.747l-20.608 23.459m61.914-70.477l-22.05 25.1m67.128-76.414l-13.608 15.49m41.116-46.803l-11.84 13.478M1300 978.772l-33.032 37.6m-136.945 133.16l-16.314 18.57m50.954-58.002l-22.05 25.1m103.213-117.49l-67.278 76.585m118.216-134.567l-36.49 41.537m-109.318 101.71l-41.304 47.018m129.06-146.91l-74.222 84.486m120.69-137.382l-32.536 37.035m-114.437 107.538l-33.009 37.575m125.233-142.555l-78.938 89.857m122.101-138.99l-29.59 33.683m-117.526 111.053l-26.269 29.903m70.98-80.796l-31.514 35.871m81.28-92.522l-32.072 36.508m73.126-83.24l-27.736 31.572m-118.388 112.035l-20.95 23.849m65.587-74.66l-31.34 35.674m81.295-92.538l-33.481 38.112m73.429-83.586l-26.857 30.572m-117.056 110.52l-17.55 19.976m109.757-124.938l-78.614 89.488m118.735-135.158l-27.031 30.77m-113.467 106.434l-15.566 17.719m102.957-117.199l-73.25 83.383m114.772-130.647l-28.3 32.213m-107.528 99.675l-15.528 17.675m55.428-63.095l-24.923 28.37m53.992-61.46l-14.944 17.012m70.218-79.931l-30.549 34.775m-99.296 90.303l-17.134 19.503m46.94-53.432l-13.686 15.578m68.36-77.814l-.192.217m33.972-38.67l-33.78 38.453m-88.495 78.007l-20.74 23.61m45.983-52.344l-7.888 8.978m93.335-106.244l-36.164 41.166m-85.29 74.36l-18.155 20.666m45.224-51.48l-1.266 1.44m4.923-5.602l-3.657 4.162m43.82-49.881l-1.966 2.238m40.947-46.61l-6.16 7.011m-116.45 109.829l-13.84 15.756m124.865-142.136l-8.309 9.457m-107.31 99.425l-18.12 20.627m122.154-139.05l-11.49 13.08m-105.783 97.686l-14.063 16.008m119.75-136.314l-3.764 4.285m-116.218 109.566l-9.15 10.416m44.474-50.627l-1.384 1.576m42.156-47.987l-3.742 4.26m36.044-41.03l-4.064 4.626m-108.88 101.212l-14.25 16.221m23.579-26.84l-9.329 10.62m13.392-15.245l-4.063 4.625m92.03-104.76l-24.24 27.594m-80.042 68.385l-21.139 24.063m113.837-129.582l-17.25 19.637m-91.07 80.938l-15.41 17.541m33.638-38.29l-3.725 4.24m36.559-41.616l-12.538 14.272m31.7-36.084l-2.544 2.895m29.055-33.073l-11.271 12.83m-100.322 91.47l-10.514 11.968m89.707-102.115l-65.154 74.166m85.968-97.86l-6.13 6.98M974.34 894.92l-6.587 7.498m92.781-105.614l-72.596 82.637m88.713-100.983l-1.972 2.244M961.39 886.937l-3.555 4.045m47.731-54.333l-30.882 35.154m77.883-88.656l-27.236 31.003m-75.91 63.683l-1.411 1.606m53.44-60.832l-38.858 44.232m44.357-50.492l-5.5 6.26m42.108-47.93l-36.608 41.67m-68.435 55.174l-.148.168m94.9-108.027l-81.545 92.824M264.263 633.311L.001 897.573"
        />
      </symbol>
      <symbol id="QD_svg__g" preserveAspectRatio="none" viewBox="0 0 1300 2000">
        <path
          stroke="#44F"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={3}
          fill="none"
          d="M1200 695c4.412 6.183 6.949 12.697 5 20m-.665 4.982c4.412 6.184 6.95 12.697 5 20m6.832 2.981c4.412 6.184 6.949 12.697 5 20M1195 650c1.03 15.056 40.209.06 35-5M550 455c15.323-7.56 30.583-14.284 45-10m-50-175c-8.282 10.548-23.954 12.98-40 15m140-10c16.677 2.2 19.875-1.846 25-5m-225-45c25 0 48.602-42.4 90 0m68.006 3.103C615 225 647.5 177.5 685 220m-157.484 4.238c1.583 3.945 2.484 8.481 2.484 13.307 0 15.213-8.954 27.545-20 27.545s-20-12.332-20-27.545c0-4.515.789-8.776 2.187-12.537m181.449-5.028c.88 3.106 1.364 6.485 1.364 10.02 0 15.213-8.954 27.545-20 27.545S635 245.213 635 230c0-1.304.066-2.587.193-3.843m138.92 362.787a1092.016 1092.016 0 0051.246-11.594M602.93 608.195a938.738 938.738 0 0043.732-1.988m-127.554.058a932.542 932.542 0 0042.558 1.925m-128.37-11.69a978.48 978.48 0 0042.62 5.826M342.999 578a1094.748 1094.748 0 0046.89 10.631M256.4 552.918a1311.06 1311.06 0 0042.046 13.025m470.232 13.898a1079.943 1079.943 0 0049.442-10.993m-217.342 29.457a926.35 926.35 0 0042.549-1.842M518.82 596.3a920.078 920.078 0 0041.648 1.934M434.16 586.58a966.447 966.447 0 0042.05 5.79m-130.791-24.037a1084.322 1084.322 0 0046.009 10.46m-131.68-35.295a1307.578 1307.578 0 0041.486 12.86m53.863-26.69a1148.614 1148.614 0 01-42.72-11.65m124.801 28.8a969.172 969.172 0 01-39.594-7.38m120.089 16.996a886.685 886.685 0 01-40.32-3.9m114.84 6.181a867.531 867.531 0 01-36.508-.317M746.96 543.32a970.937 970.937 0 01-39.732 6.474m28.687-24.63a991.003 991.003 0 0038.597-7.655M587.826 539.1a850.524 850.524 0 0035.439-1.031m-106.208-1.358a846.283 846.283 0 0036.19 1.965M438.61 527.16a894.329 894.329 0 0039.286 5.68M359.87 510.566A1014.409 1014.409 0 00400.62 520m-120.884-32.874a1251.577 1251.577 0 0038.134 11.924m51.683-27.175a1084.702 1084.702 0 01-40.539-11.187m112.76 26.664a899.822 899.822 0 01-34.989-6.753m109.11 16.162c-12.36-1-24.635-2.28-36.844-3.829m92.97 6.382a793.873 793.873 0 01-23.6-.59m165.439-10.357a889.26 889.26 0 01-33.226 4.732m82.617 77.629a1069.357 1069.357 0 0047.643-10.404m-212.267 28.09a913.916 913.916 0 0041.367-1.698m-121.462-.38a907.632 907.632 0 0040.738 1.944M435 576.656a954.488 954.488 0 0041.495 5.758M347.84 558.667a1073.43 1073.43 0 0045.128 10.288m-129.876-34.879a1302.175 1302.175 0 0040.926 12.697m48.66-7.44A1157.118 1157.118 0 01309.59 527.6m86.454 21.675a1053.188 1053.188 0 01-43.368-9.943m83.774 17.43a980.192 980.192 0 01-40.406-7.487M517.959 566.4a898.942 898.942 0 01-40.888-3.906m117.265 6.122c-12.586.181-25.07.092-37.458-.257M752.42 552.46a983.56 983.56 0 01-40.827 6.781m18.794-43.251a978.177 978.177 0 0036.725-7.111m-181.458 20.29a838.285 838.285 0 0034.243-.906m-103.13-1.538a834.046 834.046 0 0035.272 1.966m-112.713-11.494a882.638 882.638 0 0038.858 5.668m-115.893-21.971a1004.27 1004.27 0 0039.871 9.257M283.079 477.7a1246.943 1246.943 0 0037.577 11.758m-47.525 16.355a1457.958 1457.958 0 01-37.97-13.056m57.947-43.33a1397.452 1397.452 0 01-27.986-9.571m4.661 75.377A1464.405 1464.405 0 01229.2 501.24m60.566-42.386a1399.617 1399.617 0 01-28.999-9.93m106.367 32.624a1092.728 1092.728 0 01-40.905-11.27m114.704 27.019a910.626 910.626 0 01-35.688-6.847m110.942 16.3a825.836 825.836 0 01-37.423-3.84m102.56 6.386a806.24 806.24 0 01-31.697-.58m134.815 94.136a987.715 987.715 0 0044.61-5.886m-48.33-3.73a975.771 975.771 0 0043.957-5.69m-58.862-32.83a895.365 895.365 0 01-35.787 2.712m28.393-21.835a897.388 897.388 0 0039.914-4.53m-54.902-34.212a817.781 817.781 0 01-33.61 1.947M677 583.615a963.68 963.68 0 0043.312-5.495m-50.764-13.767a908.096 908.096 0 01-36.199 2.843m21.332-41.277a885.3 885.3 0 0039.222-4.332m-46.717-15.04a830.573 830.573 0 01-34.008 2.081m106.18-11.038a902.132 902.132 0 01-34.308 5.014m133.616 24.86c-9.882 2.544-19.68 4.92-29.4 7.136m-28.6-55.02a978.337 978.337 0 01-15.643 3.206m83.316 52.489a1104.58 1104.58 0 01-31.853 7.918m-25.903-55.537a995.447 995.447 0 01-18.217 3.86m-552.199 44.868c4.75 1.497 9.505 2.966 14.266 4.407m-6.618-12.48c3.225 1.003 6.452 1.995 9.682 2.973m-2.672-11.258c1.91.589 3.823 1.173 5.736 1.753M0 686.133l164.641-234.298M.001 651.346L145 445M0 616.559l125.61-178.751m696.013-37.814c10.75 42.962 18.64 91.657 23.212 148.629m-32.09-28.447l-3.93-29.74c-5.164-39.086-12.284-73.743-21.15-105.17m104.848 202.685l-.818-13.955c-3.354-57.247-9.988-107.304-19.374-151.998m-33.663-14.634c10.513 44.62 18.077 95.134 22.168 153.983m-64.918-54.077l-1.965-14.872c-5.748-43.519-13.867-81.212-24.117-114.957m-36.631-15.904c12.135 34.014 21.74 72.391 28.672 118.272m42.525-87.355c10.975 41.17 19.186 87.859 24.237 142.696"
        />
        <use
          xlinkHref="#QD_svg__a"
          height={100}
          transform="matrix(1 0 0 .793 600 960.35)"
          stroke="#44F"
          strokeWidth={72}
          strokeLinejoin="round"
          strokeLinecap="round"
        />
        <use
          xlinkHref="#QD_svg__a"
          height={100}
          transform="matrix(1 0 0 .793 530 965.35)"
          stroke="#44F"
          strokeWidth={72}
          strokeLinejoin="round"
          strokeLinecap="round"
        />
        <use
          xlinkHref="#QD_svg__a"
          height={100}
          transform="matrix(1 0 0 .793 460 970.35)"
          stroke="#44F"
          strokeWidth={72}
          strokeLinejoin="round"
          strokeLinecap="round"
        />
      </symbol>
      <rect
        width={211}
        height={328}
        x={-105.5}
        y={-164}
        rx={12}
        ry={12}
        fill="#fff"
        stroke="#000"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#QD_svg__b" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#QD_svg__b"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#QD_svg__c" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#QD_svg__c"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#QD_svg__d" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#QD_svg__d"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#QD_svg__e" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#QD_svg__e"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#QD_svg__f" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#QD_svg__f"
      />
      <use width={116} height={225} x={-58} y={-112.5} xlinkHref="#QD_svg__g" />
      <use
        transform="rotate(180)"
        width={116}
        height={225}
        x={-58}
        y={-112.5}
        xlinkHref="#QD_svg__g"
      />
      <use xlinkHref="#QD_svg__h" height={50} x={-104} y={-152.5} />
      <use xlinkHref="#QD_svg__a" height={41.827} x={-99.913} y={-97.5} />
      <use xlinkHref="#QD_svg__a" height={38.6} x={23.834} y={-109.3} />
      <g transform="rotate(180)">
        <use xlinkHref="#QD_svg__h" height={50} x={-104} y={-152.5} />
        <use xlinkHref="#QD_svg__a" height={41.827} x={-99.913} y={-97.5} />
        <use xlinkHref="#QD_svg__a" height={38.6} x={23.834} y={-109.3} />
      </g>
      <use xlinkHref="#QD_svg__i" stroke="#44F" fill="none" />
    </svg>
  );
}

export default SvgQd;
