package io.playground;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

@Path("/hello")
public class HelloResource {

    @Inject
    MyData myData;

    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public String hello() {
        return "hello " + myData.getMessage();
    }

    @Path("jpa")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public String jpa() {
        return MyEntity_.FIELD;
    }
}
