package io.quarkus.hibernate.validator.runtime;

import org.hibernate.validator.metadata.BeanMetaDataClassNormalizer;

import io.quarkus.arc.Subclass;

/**
 * In the case of a proxy generated by Arc, return the parent class.
 */
public class ArcProxyBeanMetaDataClassNormalizer implements BeanMetaDataClassNormalizer {

    @Override
    public <T> Class<? super T> normalize(Class<T> beanClass) {
        if (Subclass.class.isAssignableFrom(beanClass)) {
            return beanClass.getSuperclass();
        }

        return beanClass;
    }

}
