use crate as pg_sys;
#[cfg(any(feature = "pg12", feature = "pg13", feature = "pg14"))]
use crate::NullableDatum;
use crate::{Datum, PgNode};
#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
#[repr(C)]
pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
impl<T> __BindgenUnionField<T> {
    #[inline]
    pub const fn new() -> Self {
        __BindgenUnionField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ref(&self) -> &T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut(&mut self) -> &mut T {
        ::std::mem::transmute(self)
    }
}
impl<T> ::std::default::Default for __BindgenUnionField<T> {
    #[inline]
    fn default() -> Self {
        Self::new()
    }
}
impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__BindgenUnionField")
    }
}
impl<T> ::std::hash::Hash for __BindgenUnionField<T> {
    fn hash<H: ::std::hash::Hasher>(&self, _state: &mut H) {}
}
impl<T> ::std::cmp::PartialEq for __BindgenUnionField<T> {
    fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
        true
    }
}
impl<T> ::std::cmp::Eq for __BindgenUnionField<T> {}
pub const PG_DIAG_SEVERITY: u8 = 83u8;
pub const PG_DIAG_SEVERITY_NONLOCALIZED: u8 = 86u8;
pub const PG_DIAG_SQLSTATE: u8 = 67u8;
pub const PG_DIAG_MESSAGE_PRIMARY: u8 = 77u8;
pub const PG_DIAG_MESSAGE_DETAIL: u8 = 68u8;
pub const PG_DIAG_MESSAGE_HINT: u8 = 72u8;
pub const PG_DIAG_STATEMENT_POSITION: u8 = 80u8;
pub const PG_DIAG_INTERNAL_POSITION: u8 = 112u8;
pub const PG_DIAG_INTERNAL_QUERY: u8 = 113u8;
pub const PG_DIAG_CONTEXT: u8 = 87u8;
pub const PG_DIAG_SCHEMA_NAME: u8 = 115u8;
pub const PG_DIAG_TABLE_NAME: u8 = 116u8;
pub const PG_DIAG_COLUMN_NAME: u8 = 99u8;
pub const PG_DIAG_DATATYPE_NAME: u8 = 100u8;
pub const PG_DIAG_CONSTRAINT_NAME: u8 = 110u8;
pub const PG_DIAG_SOURCE_FILE: u8 = 70u8;
pub const PG_DIAG_SOURCE_LINE: u8 = 76u8;
pub const PG_DIAG_SOURCE_FUNCTION: u8 = 82u8;
pub const ALIGNOF_DOUBLE: u32 = 8;
pub const ALIGNOF_INT: u32 = 4;
pub const ALIGNOF_LONG: u32 = 8;
pub const ALIGNOF_PG_INT128_TYPE: u32 = 16;
pub const ALIGNOF_SHORT: u32 = 2;
pub const BLCKSZ: u32 = 8192;
pub const DEF_PGPORT: u32 = 28812;
pub const DEF_PGPORT_STR: &[u8; 6usize] = b"28812\0";
pub const ENABLE_THREAD_SAFETY: u32 = 1;
pub const HAVE_APPEND_HISTORY: u32 = 1;
pub const HAVE_ATOMICS: u32 = 1;
pub const HAVE_CBRT: u32 = 1;
pub const HAVE_CLOCK_GETTIME: u32 = 1;
pub const HAVE_COMPUTED_GOTO: u32 = 1;
pub const HAVE_CRYPT: u32 = 1;
pub const HAVE_CRYPT_H: u32 = 1;
pub const HAVE_DECL_FDATASYNC: u32 = 1;
pub const HAVE_DECL_F_FULLFSYNC: u32 = 0;
pub const HAVE_DECL_POSIX_FADVISE: u32 = 1;
pub const HAVE_DECL_RTLD_GLOBAL: u32 = 1;
pub const HAVE_DECL_RTLD_NOW: u32 = 1;
pub const HAVE_DECL_STRLCAT: u32 = 0;
pub const HAVE_DECL_STRLCPY: u32 = 0;
pub const HAVE_DECL_STRNLEN: u32 = 1;
pub const HAVE_DECL_STRTOLL: u32 = 1;
pub const HAVE_DECL_STRTOULL: u32 = 1;
pub const HAVE_DLOPEN: u32 = 1;
pub const HAVE_FDATASYNC: u32 = 1;
pub const HAVE_FSEEKO: u32 = 1;
pub const HAVE_FUNCNAME__FUNC: u32 = 1;
pub const HAVE_GCC__ATOMIC_INT32_CAS: u32 = 1;
pub const HAVE_GCC__ATOMIC_INT64_CAS: u32 = 1;
pub const HAVE_GCC__SYNC_CHAR_TAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT32_CAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT32_TAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT64_CAS: u32 = 1;
pub const HAVE_GETADDRINFO: u32 = 1;
pub const HAVE_GETHOSTBYNAME_R: u32 = 1;
pub const HAVE_GETIFADDRS: u32 = 1;
pub const HAVE_GETOPT: u32 = 1;
pub const HAVE_GETOPT_H: u32 = 1;
pub const HAVE_GETOPT_LONG: u32 = 1;
pub const HAVE_GETPWUID_R: u32 = 1;
pub const HAVE_GETRLIMIT: u32 = 1;
pub const HAVE_GETRUSAGE: u32 = 1;
pub const HAVE_HISTORY_TRUNCATE_FILE: u32 = 1;
pub const HAVE_IFADDRS_H: u32 = 1;
pub const HAVE_INET_ATON: u32 = 1;
pub const HAVE_INTPTR_T: u32 = 1;
pub const HAVE_INTTYPES_H: u32 = 1;
pub const HAVE_INT_OPTERR: u32 = 1;
pub const HAVE_INT_TIMEZONE: u32 = 1;
pub const HAVE_IPV6: u32 = 1;
pub const HAVE_ISINF: u32 = 1;
pub const HAVE_LANGINFO_H: u32 = 1;
pub const HAVE_LIBM: u32 = 1;
pub const HAVE_LIBREADLINE: u32 = 1;
pub const HAVE_LIBZ: u32 = 1;
pub const HAVE_LOCALE_T: u32 = 1;
pub const HAVE_LONG_INT_64: u32 = 1;
pub const HAVE_LONG_LONG_INT: u32 = 1;
pub const HAVE_MEMMOVE: u32 = 1;
pub const HAVE_MEMORY_H: u32 = 1;
pub const HAVE_MKDTEMP: u32 = 1;
pub const HAVE_NETINET_TCP_H: u32 = 1;
pub const HAVE_NET_IF_H: u32 = 1;
pub const HAVE_POLL: u32 = 1;
pub const HAVE_POLL_H: u32 = 1;
pub const HAVE_POSIX_FADVISE: u32 = 1;
pub const HAVE_POSIX_FALLOCATE: u32 = 1;
pub const HAVE_PPOLL: u32 = 1;
pub const HAVE_PREAD: u32 = 1;
pub const HAVE_PTHREAD: u32 = 1;
pub const HAVE_PTHREAD_PRIO_INHERIT: u32 = 1;
pub const HAVE_PWRITE: u32 = 1;
pub const HAVE_RANDOM: u32 = 1;
pub const HAVE_READLINE_HISTORY_H: u32 = 1;
pub const HAVE_READLINE_READLINE_H: u32 = 1;
pub const HAVE_READLINK: u32 = 1;
pub const HAVE_RINT: u32 = 1;
pub const HAVE_RL_COMPLETION_APPEND_CHARACTER: u32 = 1;
pub const HAVE_RL_COMPLETION_MATCHES: u32 = 1;
pub const HAVE_RL_FILENAME_COMPLETION_FUNCTION: u32 = 1;
pub const HAVE_RL_RESET_SCREEN_SIZE: u32 = 1;
pub const HAVE_SETENV: u32 = 1;
pub const HAVE_SETSID: u32 = 1;
pub const HAVE_SHM_OPEN: u32 = 1;
pub const HAVE_SPINLOCKS: u32 = 1;
pub const HAVE_SRANDOM: u32 = 1;
pub const HAVE_STDBOOL_H: u32 = 1;
pub const HAVE_STDINT_H: u32 = 1;
pub const HAVE_STDLIB_H: u32 = 1;
pub const HAVE_STRCHRNUL: u32 = 1;
pub const HAVE_STRERROR_R: u32 = 1;
pub const HAVE_STRINGS_H: u32 = 1;
pub const HAVE_STRING_H: u32 = 1;
pub const HAVE_STRNLEN: u32 = 1;
pub const HAVE_STRSIGNAL: u32 = 1;
pub const HAVE_STRTOF: u32 = 1;
pub const HAVE_STRTOLL: u32 = 1;
pub const HAVE_STRTOULL: u32 = 1;
pub const HAVE_STRUCT_ADDRINFO: u32 = 1;
pub const HAVE_STRUCT_OPTION: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_STORAGE: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_STORAGE_SS_FAMILY: u32 = 1;
pub const HAVE_STRUCT_TM_TM_ZONE: u32 = 1;
pub const HAVE_SYMLINK: u32 = 1;
pub const HAVE_SYNC_FILE_RANGE: u32 = 1;
pub const HAVE_SYSLOG: u32 = 1;
pub const HAVE_SYS_EPOLL_H: u32 = 1;
pub const HAVE_SYS_IPC_H: u32 = 1;
pub const HAVE_SYS_PRCTL_H: u32 = 1;
pub const HAVE_SYS_RESOURCE_H: u32 = 1;
pub const HAVE_SYS_SELECT_H: u32 = 1;
pub const HAVE_SYS_SEM_H: u32 = 1;
pub const HAVE_SYS_SHM_H: u32 = 1;
pub const HAVE_SYS_STAT_H: u32 = 1;
pub const HAVE_SYS_TYPES_H: u32 = 1;
pub const HAVE_SYS_UN_H: u32 = 1;
pub const HAVE_TERMIOS_H: u32 = 1;
pub const HAVE_TM_ZONE: u32 = 1;
pub const HAVE_TYPEOF: u32 = 1;
pub const HAVE_TZNAME: u32 = 1;
pub const HAVE_UINTPTR_T: u32 = 1;
pub const HAVE_UNISTD_H: u32 = 1;
pub const HAVE_UNIX_SOCKETS: u32 = 1;
pub const HAVE_UNSETENV: u32 = 1;
pub const HAVE_UNSIGNED_LONG_LONG_INT: u32 = 1;
pub const HAVE_USELOCALE: u32 = 1;
pub const HAVE_UTIME: u32 = 1;
pub const HAVE_UTIMES: u32 = 1;
pub const HAVE_UTIME_H: u32 = 1;
pub const HAVE_WCHAR_H: u32 = 1;
pub const HAVE_WCTYPE_H: u32 = 1;
pub const HAVE_X86_64_POPCNTQ: u32 = 1;
pub const HAVE__BOOL: u32 = 1;
pub const HAVE__BUILTIN_BSWAP16: u32 = 1;
pub const HAVE__BUILTIN_BSWAP32: u32 = 1;
pub const HAVE__BUILTIN_BSWAP64: u32 = 1;
pub const HAVE__BUILTIN_CLZ: u32 = 1;
pub const HAVE__BUILTIN_CONSTANT_P: u32 = 1;
pub const HAVE__BUILTIN_CTZ: u32 = 1;
pub const HAVE__BUILTIN_FRAME_ADDRESS: u32 = 1;
pub const HAVE__BUILTIN_OP_OVERFLOW: u32 = 1;
pub const HAVE__BUILTIN_POPCOUNT: u32 = 1;
pub const HAVE__BUILTIN_TYPES_COMPATIBLE_P: u32 = 1;
pub const HAVE__BUILTIN_UNREACHABLE: u32 = 1;
pub const HAVE__GET_CPUID: u32 = 1;
pub const HAVE__STATIC_ASSERT: u32 = 1;
pub const INT64_MODIFIER: &[u8; 2usize] = b"l\0";
pub const MAXIMUM_ALIGNOF: u32 = 8;
pub const MEMSET_LOOP_LIMIT: u32 = 1024;
pub const PACKAGE_BUGREPORT: &[u8; 32usize] = b"pgsql-bugs@lists.postgresql.org\0";
pub const PACKAGE_NAME: &[u8; 11usize] = b"PostgreSQL\0";
pub const PACKAGE_STRING: &[u8; 17usize] = b"PostgreSQL 12.12\0";
pub const PACKAGE_TARNAME: &[u8; 11usize] = b"postgresql\0";
pub const PACKAGE_URL: &[u8; 1usize] = b"\0";
pub const PACKAGE_VERSION: &[u8; 6usize] = b"12.12\0";
pub const PG_KRB_SRVNAM: &[u8; 9usize] = b"postgres\0";
pub const PG_MAJORVERSION: &[u8; 3usize] = b"12\0";
pub const PG_VERSION: &[u8; 6usize] = b"12.12\0";
pub const PG_VERSION_NUM: u32 = 120012;
pub const PG_VERSION_STR: &[u8; 78usize] =
    b"PostgreSQL 12.12 on x86_64-pc-linux-gnu, compiled by gcc (GCC) 12.2.0, 64-bit\0";
pub const RELSEG_SIZE: u32 = 131072;
pub const SIZEOF_BOOL: u32 = 1;
pub const SIZEOF_LONG: u32 = 8;
pub const SIZEOF_OFF_T: u32 = 8;
pub const SIZEOF_SIZE_T: u32 = 8;
pub const SIZEOF_VOID_P: u32 = 8;
pub const STDC_HEADERS: u32 = 1;
pub const USE_ASSERT_CHECKING: u32 = 1;
pub const USE_DEV_URANDOM: u32 = 1;
pub const USE_FLOAT4_BYVAL: u32 = 1;
pub const USE_FLOAT8_BYVAL: u32 = 1;
pub const USE_SSE42_CRC32C_WITH_RUNTIME_CHECK: u32 = 1;
pub const USE_SYSV_SHARED_MEMORY: u32 = 1;
pub const USE_UNNAMED_POSIX_SEMAPHORES: u32 = 1;
pub const XLOG_BLCKSZ: u32 = 8192;
pub const DEFAULT_XLOG_SEG_SIZE: u32 = 16777216;
pub const NAMEDATALEN: u32 = 64;
pub const FUNC_MAX_ARGS: u32 = 100;
pub const INDEX_MAX_KEYS: u32 = 32;
pub const PARTITION_MAX_KEYS: u32 = 32;
pub const NUM_SPINLOCK_SEMAPHORES: u32 = 128;
pub const NUM_ATOMICS_SEMAPHORES: u32 = 64;
pub const MAXPGPATH: u32 = 1024;
pub const PG_SOMAXCONN: u32 = 10000;
pub const BITS_PER_BYTE: u32 = 8;
pub const ALIGNOF_BUFFER: u32 = 32;
pub const HAVE_WORKING_LINK: u32 = 1;
pub const DEFAULT_BACKEND_FLUSH_AFTER: u32 = 0;
pub const DEFAULT_BGWRITER_FLUSH_AFTER: u32 = 64;
pub const DEFAULT_CHECKPOINT_FLUSH_AFTER: u32 = 32;
pub const WRITEBACK_MAX_PENDING_FLUSHES: u32 = 256;
pub const DEFAULT_PGSOCKET_DIR: &[u8; 5usize] = b"/tmp\0";
pub const DEFAULT_EVENT_SOURCE: &[u8; 11usize] = b"PostgreSQL\0";
pub const PG_CACHE_LINE_SIZE: u32 = 128;
pub const TRACE_SORT: u32 = 1;
pub const _STDIO_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2X: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __TIMESIZE: u32 = 64;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_60559_BFP__: u32 = 201404;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_IEC_60559_COMPLEX__: u32 = 201404;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 36;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __LDOUBLE_REDIRECTS_TO_FLOAT128_ABI: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const __GNUC_VA_LIST: u32 = 1;
pub const _BITS_TYPES_H: u32 = 1;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __KERNEL_OLD_TIMEVAL_MATCHES_TIMEVAL64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const _____fpos_t_defined: u32 = 1;
pub const ____mbstate_t_defined: u32 = 1;
pub const _____fpos64_t_defined: u32 = 1;
pub const ____FILE_defined: u32 = 1;
pub const __FILE_defined: u32 = 1;
pub const __struct_FILE_defined: u32 = 1;
pub const _IO_EOF_SEEN: u32 = 16;
pub const _IO_ERR_SEEN: u32 = 32;
pub const _IO_USER_LOCK: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 8192;
pub const EOF: i32 = -1;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const P_tmpdir: &[u8; 5usize] = b"/tmp\0";
pub const _BITS_STDIO_LIM_H: u32 = 1;
pub const L_tmpnam: u32 = 20;
pub const TMP_MAX: u32 = 238328;
pub const FILENAME_MAX: u32 = 4096;
pub const L_ctermid: u32 = 9;
pub const FOPEN_MAX: u32 = 16;
pub const __HAVE_FLOAT128: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT128: u32 = 0;
pub const __HAVE_FLOAT64X: u32 = 1;
pub const __HAVE_FLOAT64X_LONG_DOUBLE: u32 = 1;
pub const __HAVE_FLOAT16: u32 = 0;
pub const __HAVE_FLOAT32: u32 = 1;
pub const __HAVE_FLOAT64: u32 = 1;
pub const __HAVE_FLOAT32X: u32 = 1;
pub const __HAVE_FLOAT128X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT16: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT32: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT64: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT32X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT64X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT128X: u32 = 0;
pub const __HAVE_FLOATN_NOT_TYPEDEF: u32 = 0;
pub const _STDLIB_H: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WSTOPPED: u32 = 2;
pub const WEXITED: u32 = 4;
pub const WCONTINUED: u32 = 8;
pub const WNOWAIT: u32 = 16777216;
pub const __WNOTHREAD: u32 = 536870912;
pub const __WALL: u32 = 1073741824;
pub const __WCLONE: u32 = 2147483648;
pub const __W_CONTINUED: u32 = 65535;
pub const __WCOREFLAG: u32 = 128;
pub const __ldiv_t_defined: u32 = 1;
pub const __lldiv_t_defined: u32 = 1;
pub const RAND_MAX: u32 = 2147483647;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const _SYS_TYPES_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _ENDIAN_H: u32 = 1;
pub const _BITS_ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const _BITS_ENDIANNESS_H: u32 = 1;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const _BITS_UINTN_IDENTITY_H: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __sigset_t_defined: u32 = 1;
pub const __timeval_defined: u32 = 1;
pub const _STRUCT_TIMESPEC: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _BITS_PTHREADTYPES_COMMON_H: u32 = 1;
pub const _THREAD_SHARED_TYPES_H: u32 = 1;
pub const _BITS_PTHREADTYPES_ARCH_H: u32 = 1;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const _THREAD_MUTEX_INTERNAL_H: u32 = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const __have_pthread_attr_t: u32 = 1;
pub const _ALLOCA_H: u32 = 1;
pub const _STRING_H: u32 = 1;
pub const _BITS_TYPES_LOCALE_T_H: u32 = 1;
pub const _BITS_TYPES___LOCALE_T_H: u32 = 1;
pub const _STRINGS_H: u32 = 1;
pub const _STDINT_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const _ERRNO_H: u32 = 1;
pub const _BITS_ERRNO_H: u32 = 1;
pub const EPERM: u32 = 1;
pub const ENOENT: u32 = 2;
pub const ESRCH: u32 = 3;
pub const EINTR: u32 = 4;
pub const EIO: u32 = 5;
pub const ENXIO: u32 = 6;
pub const E2BIG: u32 = 7;
pub const ENOEXEC: u32 = 8;
pub const EBADF: u32 = 9;
pub const ECHILD: u32 = 10;
pub const EAGAIN: u32 = 11;
pub const ENOMEM: u32 = 12;
pub const EACCES: u32 = 13;
pub const EFAULT: u32 = 14;
pub const ENOTBLK: u32 = 15;
pub const EBUSY: u32 = 16;
pub const EEXIST: u32 = 17;
pub const EXDEV: u32 = 18;
pub const ENODEV: u32 = 19;
pub const ENOTDIR: u32 = 20;
pub const EISDIR: u32 = 21;
pub const EINVAL: u32 = 22;
pub const ENFILE: u32 = 23;
pub const EMFILE: u32 = 24;
pub const ENOTTY: u32 = 25;
pub const ETXTBSY: u32 = 26;
pub const EFBIG: u32 = 27;
pub const ENOSPC: u32 = 28;
pub const ESPIPE: u32 = 29;
pub const EROFS: u32 = 30;
pub const EMLINK: u32 = 31;
pub const EPIPE: u32 = 32;
pub const EDOM: u32 = 33;
pub const ERANGE: u32 = 34;
pub const EDEADLK: u32 = 35;
pub const ENAMETOOLONG: u32 = 36;
pub const ENOLCK: u32 = 37;
pub const ENOSYS: u32 = 38;
pub const ENOTEMPTY: u32 = 39;
pub const ELOOP: u32 = 40;
pub const EWOULDBLOCK: u32 = 11;
pub const ENOMSG: u32 = 42;
pub const EIDRM: u32 = 43;
pub const ECHRNG: u32 = 44;
pub const EL2NSYNC: u32 = 45;
pub const EL3HLT: u32 = 46;
pub const EL3RST: u32 = 47;
pub const ELNRNG: u32 = 48;
pub const EUNATCH: u32 = 49;
pub const ENOCSI: u32 = 50;
pub const EL2HLT: u32 = 51;
pub const EBADE: u32 = 52;
pub const EBADR: u32 = 53;
pub const EXFULL: u32 = 54;
pub const ENOANO: u32 = 55;
pub const EBADRQC: u32 = 56;
pub const EBADSLT: u32 = 57;
pub const EDEADLOCK: u32 = 35;
pub const EBFONT: u32 = 59;
pub const ENOSTR: u32 = 60;
pub const ENODATA: u32 = 61;
pub const ETIME: u32 = 62;
pub const ENOSR: u32 = 63;
pub const ENONET: u32 = 64;
pub const ENOPKG: u32 = 65;
pub const EREMOTE: u32 = 66;
pub const ENOLINK: u32 = 67;
pub const EADV: u32 = 68;
pub const ESRMNT: u32 = 69;
pub const ECOMM: u32 = 70;
pub const EPROTO: u32 = 71;
pub const EMULTIHOP: u32 = 72;
pub const EDOTDOT: u32 = 73;
pub const EBADMSG: u32 = 74;
pub const EOVERFLOW: u32 = 75;
pub const ENOTUNIQ: u32 = 76;
pub const EBADFD: u32 = 77;
pub const EREMCHG: u32 = 78;
pub const ELIBACC: u32 = 79;
pub const ELIBBAD: u32 = 80;
pub const ELIBSCN: u32 = 81;
pub const ELIBMAX: u32 = 82;
pub const ELIBEXEC: u32 = 83;
pub const EILSEQ: u32 = 84;
pub const ERESTART: u32 = 85;
pub const ESTRPIPE: u32 = 86;
pub const EUSERS: u32 = 87;
pub const ENOTSOCK: u32 = 88;
pub const EDESTADDRREQ: u32 = 89;
pub const EMSGSIZE: u32 = 90;
pub const EPROTOTYPE: u32 = 91;
pub const ENOPROTOOPT: u32 = 92;
pub const EPROTONOSUPPORT: u32 = 93;
pub const ESOCKTNOSUPPORT: u32 = 94;
pub const EOPNOTSUPP: u32 = 95;
pub const EPFNOSUPPORT: u32 = 96;
pub const EAFNOSUPPORT: u32 = 97;
pub const EADDRINUSE: u32 = 98;
pub const EADDRNOTAVAIL: u32 = 99;
pub const ENETDOWN: u32 = 100;
pub const ENETUNREACH: u32 = 101;
pub const ENETRESET: u32 = 102;
pub const ECONNABORTED: u32 = 103;
pub const ECONNRESET: u32 = 104;
pub const ENOBUFS: u32 = 105;
pub const EISCONN: u32 = 106;
pub const ENOTCONN: u32 = 107;
pub const ESHUTDOWN: u32 = 108;
pub const ETOOMANYREFS: u32 = 109;
pub const ETIMEDOUT: u32 = 110;
pub const ECONNREFUSED: u32 = 111;
pub const EHOSTDOWN: u32 = 112;
pub const EHOSTUNREACH: u32 = 113;
pub const EALREADY: u32 = 114;
pub const EINPROGRESS: u32 = 115;
pub const ESTALE: u32 = 116;
pub const EUCLEAN: u32 = 117;
pub const ENOTNAM: u32 = 118;
pub const ENAVAIL: u32 = 119;
pub const EISNAM: u32 = 120;
pub const EREMOTEIO: u32 = 121;
pub const EDQUOT: u32 = 122;
pub const ENOMEDIUM: u32 = 123;
pub const EMEDIUMTYPE: u32 = 124;
pub const ECANCELED: u32 = 125;
pub const ENOKEY: u32 = 126;
pub const EKEYEXPIRED: u32 = 127;
pub const EKEYREVOKED: u32 = 128;
pub const EKEYREJECTED: u32 = 129;
pub const EOWNERDEAD: u32 = 130;
pub const ENOTRECOVERABLE: u32 = 131;
pub const ERFKILL: u32 = 132;
pub const EHWPOISON: u32 = 133;
pub const ENOTSUP: u32 = 95;
pub const _LOCALE_H: u32 = 1;
pub const _BITS_LOCALE_H: u32 = 1;
pub const __LC_CTYPE: u32 = 0;
pub const __LC_NUMERIC: u32 = 1;
pub const __LC_TIME: u32 = 2;
pub const __LC_COLLATE: u32 = 3;
pub const __LC_MONETARY: u32 = 4;
pub const __LC_MESSAGES: u32 = 5;
pub const __LC_ALL: u32 = 6;
pub const __LC_PAPER: u32 = 7;
pub const __LC_NAME: u32 = 8;
pub const __LC_ADDRESS: u32 = 9;
pub const __LC_TELEPHONE: u32 = 10;
pub const __LC_MEASUREMENT: u32 = 11;
pub const __LC_IDENTIFICATION: u32 = 12;
pub const LC_CTYPE: u32 = 0;
pub const LC_NUMERIC: u32 = 1;
pub const LC_TIME: u32 = 2;
pub const LC_COLLATE: u32 = 3;
pub const LC_MONETARY: u32 = 4;
pub const LC_MESSAGES: u32 = 5;
pub const LC_ALL: u32 = 6;
pub const LC_PAPER: u32 = 7;
pub const LC_NAME: u32 = 8;
pub const LC_ADDRESS: u32 = 9;
pub const LC_TELEPHONE: u32 = 10;
pub const LC_MEASUREMENT: u32 = 11;
pub const LC_IDENTIFICATION: u32 = 12;
pub const LC_CTYPE_MASK: u32 = 1;
pub const LC_NUMERIC_MASK: u32 = 2;
pub const LC_TIME_MASK: u32 = 4;
pub const LC_COLLATE_MASK: u32 = 8;
pub const LC_MONETARY_MASK: u32 = 16;
pub const LC_MESSAGES_MASK: u32 = 32;
pub const LC_PAPER_MASK: u32 = 128;
pub const LC_NAME_MASK: u32 = 256;
pub const LC_ADDRESS_MASK: u32 = 512;
pub const LC_TELEPHONE_MASK: u32 = 1024;
pub const LC_MEASUREMENT_MASK: u32 = 2048;
pub const LC_IDENTIFICATION_MASK: u32 = 4096;
pub const LC_ALL_MASK: u32 = 8127;
pub const HAVE_PG_ATTRIBUTE_NORETURN: u32 = 1;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const __bool_true_false_are_defined: u32 = 1;
pub const USE_STDBOOL: u32 = 1;
pub const INT64_FORMAT: &[u8; 4usize] = b"%ld\0";
pub const UINT64_FORMAT: &[u8; 4usize] = b"%lu\0";
pub const HAVE_INT128: u32 = 1;
pub const PG_INT8_MIN: i32 = -128;
pub const PG_INT8_MAX: u32 = 127;
pub const PG_UINT8_MAX: u32 = 255;
pub const PG_INT16_MIN: i32 = -32768;
pub const PG_INT16_MAX: u32 = 32767;
pub const PG_UINT16_MAX: u32 = 65535;
pub const PG_INT32_MIN: i32 = -2147483648;
pub const PG_INT32_MAX: u32 = 2147483647;
pub const PG_UINT32_MAX: u32 = 4294967295;
pub const MAXDIM: u32 = 6;
pub const HIGHBIT: u32 = 128;
pub const ESCAPE_STRING_SYNTAX: u8 = 69u8;
pub const STATUS_OK: u32 = 0;
pub const STATUS_ERROR: i32 = -1;
pub const STATUS_EOF: i32 = -2;
pub const STATUS_FOUND: u32 = 1;
pub const STATUS_WAITING: u32 = 2;
pub const PG_BINARY: u32 = 0;
pub const PG_BINARY_A: &[u8; 2usize] = b"a\0";
pub const PG_BINARY_R: &[u8; 2usize] = b"r\0";
pub const PG_BINARY_W: &[u8; 2usize] = b"w\0";
pub const _CTYPE_H: u32 = 1;
pub const _NETDB_H: u32 = 1;
pub const _NETINET_IN_H: u32 = 1;
pub const _SYS_SOCKET_H: u32 = 1;
pub const __iovec_defined: u32 = 1;
pub const PF_UNSPEC: u32 = 0;
pub const PF_LOCAL: u32 = 1;
pub const PF_UNIX: u32 = 1;
pub const PF_FILE: u32 = 1;
pub const PF_INET: u32 = 2;
pub const PF_AX25: u32 = 3;
pub const PF_IPX: u32 = 4;
pub const PF_APPLETALK: u32 = 5;
pub const PF_NETROM: u32 = 6;
pub const PF_BRIDGE: u32 = 7;
pub const PF_ATMPVC: u32 = 8;
pub const PF_X25: u32 = 9;
pub const PF_INET6: u32 = 10;
pub const PF_ROSE: u32 = 11;
pub const PF_DECnet: u32 = 12;
pub const PF_NETBEUI: u32 = 13;
pub const PF_SECURITY: u32 = 14;
pub const PF_KEY: u32 = 15;
pub const PF_NETLINK: u32 = 16;
pub const PF_ROUTE: u32 = 16;
pub const PF_PACKET: u32 = 17;
pub const PF_ASH: u32 = 18;
pub const PF_ECONET: u32 = 19;
pub const PF_ATMSVC: u32 = 20;
pub const PF_RDS: u32 = 21;
pub const PF_SNA: u32 = 22;
pub const PF_IRDA: u32 = 23;
pub const PF_PPPOX: u32 = 24;
pub const PF_WANPIPE: u32 = 25;
pub const PF_LLC: u32 = 26;
pub const PF_IB: u32 = 27;
pub const PF_MPLS: u32 = 28;
pub const PF_CAN: u32 = 29;
pub const PF_TIPC: u32 = 30;
pub const PF_BLUETOOTH: u32 = 31;
pub const PF_IUCV: u32 = 32;
pub const PF_RXRPC: u32 = 33;
pub const PF_ISDN: u32 = 34;
pub const PF_PHONET: u32 = 35;
pub const PF_IEEE802154: u32 = 36;
pub const PF_CAIF: u32 = 37;
pub const PF_ALG: u32 = 38;
pub const PF_NFC: u32 = 39;
pub const PF_VSOCK: u32 = 40;
pub const PF_KCM: u32 = 41;
pub const PF_QIPCRTR: u32 = 42;
pub const PF_SMC: u32 = 43;
pub const PF_XDP: u32 = 44;
pub const PF_MCTP: u32 = 45;
pub const PF_MAX: u32 = 46;
pub const AF_UNSPEC: u32 = 0;
pub const AF_LOCAL: u32 = 1;
pub const AF_UNIX: u32 = 1;
pub const AF_FILE: u32 = 1;
pub const AF_INET: u32 = 2;
pub const AF_AX25: u32 = 3;
pub const AF_IPX: u32 = 4;
pub const AF_APPLETALK: u32 = 5;
pub const AF_NETROM: u32 = 6;
pub const AF_BRIDGE: u32 = 7;
pub const AF_ATMPVC: u32 = 8;
pub const AF_X25: u32 = 9;
pub const AF_INET6: u32 = 10;
pub const AF_ROSE: u32 = 11;
pub const AF_DECnet: u32 = 12;
pub const AF_NETBEUI: u32 = 13;
pub const AF_SECURITY: u32 = 14;
pub const AF_KEY: u32 = 15;
pub const AF_NETLINK: u32 = 16;
pub const AF_ROUTE: u32 = 16;
pub const AF_PACKET: u32 = 17;
pub const AF_ASH: u32 = 18;
pub const AF_ECONET: u32 = 19;
pub const AF_ATMSVC: u32 = 20;
pub const AF_RDS: u32 = 21;
pub const AF_SNA: u32 = 22;
pub const AF_IRDA: u32 = 23;
pub const AF_PPPOX: u32 = 24;
pub const AF_WANPIPE: u32 = 25;
pub const AF_LLC: u32 = 26;
pub const AF_IB: u32 = 27;
pub const AF_MPLS: u32 = 28;
pub const AF_CAN: u32 = 29;
pub const AF_TIPC: u32 = 30;
pub const AF_BLUETOOTH: u32 = 31;
pub const AF_IUCV: u32 = 32;
pub const AF_RXRPC: u32 = 33;
pub const AF_ISDN: u32 = 34;
pub const AF_PHONET: u32 = 35;
pub const AF_IEEE802154: u32 = 36;
pub const AF_CAIF: u32 = 37;
pub const AF_ALG: u32 = 38;
pub const AF_NFC: u32 = 39;
pub const AF_VSOCK: u32 = 40;
pub const AF_KCM: u32 = 41;
pub const AF_QIPCRTR: u32 = 42;
pub const AF_SMC: u32 = 43;
pub const AF_XDP: u32 = 44;
pub const AF_MCTP: u32 = 45;
pub const AF_MAX: u32 = 46;
pub const SOL_RAW: u32 = 255;
pub const SOL_DECNET: u32 = 261;
pub const SOL_X25: u32 = 262;
pub const SOL_PACKET: u32 = 263;
pub const SOL_ATM: u32 = 264;
pub const SOL_AAL: u32 = 265;
pub const SOL_IRDA: u32 = 266;
pub const SOL_NETBEUI: u32 = 267;
pub const SOL_LLC: u32 = 268;
pub const SOL_DCCP: u32 = 269;
pub const SOL_NETLINK: u32 = 270;
pub const SOL_TIPC: u32 = 271;
pub const SOL_RXRPC: u32 = 272;
pub const SOL_PPPOL2TP: u32 = 273;
pub const SOL_BLUETOOTH: u32 = 274;
pub const SOL_PNPIPE: u32 = 275;
pub const SOL_RDS: u32 = 276;
pub const SOL_IUCV: u32 = 277;
pub const SOL_CAIF: u32 = 278;
pub const SOL_ALG: u32 = 279;
pub const SOL_NFC: u32 = 280;
pub const SOL_KCM: u32 = 281;
pub const SOL_TLS: u32 = 282;
pub const SOL_XDP: u32 = 283;
pub const SOL_MPTCP: u32 = 284;
pub const SOL_MCTP: u32 = 285;
pub const SOL_SMC: u32 = 286;
pub const SOMAXCONN: u32 = 4096;
pub const _BITS_SOCKADDR_H: u32 = 1;
pub const _SS_SIZE: u32 = 128;
pub const __BITS_PER_LONG: u32 = 64;
pub const FIOSETOWN: u32 = 35073;
pub const SIOCSPGRP: u32 = 35074;
pub const FIOGETOWN: u32 = 35075;
pub const SIOCGPGRP: u32 = 35076;
pub const SIOCATMARK: u32 = 35077;
pub const SIOCGSTAMP_OLD: u32 = 35078;
pub const SIOCGSTAMPNS_OLD: u32 = 35079;
pub const SOL_SOCKET: u32 = 1;
pub const SO_DEBUG: u32 = 1;
pub const SO_REUSEADDR: u32 = 2;
pub const SO_TYPE: u32 = 3;
pub const SO_ERROR: u32 = 4;
pub const SO_DONTROUTE: u32 = 5;
pub const SO_BROADCAST: u32 = 6;
pub const SO_SNDBUF: u32 = 7;
pub const SO_RCVBUF: u32 = 8;
pub const SO_SNDBUFFORCE: u32 = 32;
pub const SO_RCVBUFFORCE: u32 = 33;
pub const SO_KEEPALIVE: u32 = 9;
pub const SO_OOBINLINE: u32 = 10;
pub const SO_NO_CHECK: u32 = 11;
pub const SO_PRIORITY: u32 = 12;
pub const SO_LINGER: u32 = 13;
pub const SO_BSDCOMPAT: u32 = 14;
pub const SO_REUSEPORT: u32 = 15;
pub const SO_PASSCRED: u32 = 16;
pub const SO_PEERCRED: u32 = 17;
pub const SO_RCVLOWAT: u32 = 18;
pub const SO_SNDLOWAT: u32 = 19;
pub const SO_RCVTIMEO_OLD: u32 = 20;
pub const SO_SNDTIMEO_OLD: u32 = 21;
pub const SO_SECURITY_AUTHENTICATION: u32 = 22;
pub const SO_SECURITY_ENCRYPTION_TRANSPORT: u32 = 23;
pub const SO_SECURITY_ENCRYPTION_NETWORK: u32 = 24;
pub const SO_BINDTODEVICE: u32 = 25;
pub const SO_ATTACH_FILTER: u32 = 26;
pub const SO_DETACH_FILTER: u32 = 27;
pub const SO_GET_FILTER: u32 = 26;
pub const SO_PEERNAME: u32 = 28;
pub const SO_ACCEPTCONN: u32 = 30;
pub const SO_PEERSEC: u32 = 31;
pub const SO_PASSSEC: u32 = 34;
pub const SO_MARK: u32 = 36;
pub const SO_PROTOCOL: u32 = 38;
pub const SO_DOMAIN: u32 = 39;
pub const SO_RXQ_OVFL: u32 = 40;
pub const SO_WIFI_STATUS: u32 = 41;
pub const SCM_WIFI_STATUS: u32 = 41;
pub const SO_PEEK_OFF: u32 = 42;
pub const SO_NOFCS: u32 = 43;
pub const SO_LOCK_FILTER: u32 = 44;
pub const SO_SELECT_ERR_QUEUE: u32 = 45;
pub const SO_BUSY_POLL: u32 = 46;
pub const SO_MAX_PACING_RATE: u32 = 47;
pub const SO_BPF_EXTENSIONS: u32 = 48;
pub const SO_INCOMING_CPU: u32 = 49;
pub const SO_ATTACH_BPF: u32 = 50;
pub const SO_DETACH_BPF: u32 = 27;
pub const SO_ATTACH_REUSEPORT_CBPF: u32 = 51;
pub const SO_ATTACH_REUSEPORT_EBPF: u32 = 52;
pub const SO_CNX_ADVICE: u32 = 53;
pub const SCM_TIMESTAMPING_OPT_STATS: u32 = 54;
pub const SO_MEMINFO: u32 = 55;
pub const SO_INCOMING_NAPI_ID: u32 = 56;
pub const SO_COOKIE: u32 = 57;
pub const SCM_TIMESTAMPING_PKTINFO: u32 = 58;
pub const SO_PEERGROUPS: u32 = 59;
pub const SO_ZEROCOPY: u32 = 60;
pub const SO_TXTIME: u32 = 61;
pub const SCM_TXTIME: u32 = 61;
pub const SO_BINDTOIFINDEX: u32 = 62;
pub const SO_TIMESTAMP_OLD: u32 = 29;
pub const SO_TIMESTAMPNS_OLD: u32 = 35;
pub const SO_TIMESTAMPING_OLD: u32 = 37;
pub const SO_TIMESTAMP_NEW: u32 = 63;
pub const SO_TIMESTAMPNS_NEW: u32 = 64;
pub const SO_TIMESTAMPING_NEW: u32 = 65;
pub const SO_RCVTIMEO_NEW: u32 = 66;
pub const SO_SNDTIMEO_NEW: u32 = 67;
pub const SO_DETACH_REUSEPORT_BPF: u32 = 68;
pub const SO_PREFER_BUSY_POLL: u32 = 69;
pub const SO_BUSY_POLL_BUDGET: u32 = 70;
pub const SO_NETNS_COOKIE: u32 = 71;
pub const SO_BUF_LOCK: u32 = 72;
pub const SO_RESERVE_MEM: u32 = 73;
pub const SO_TXREHASH: u32 = 74;
pub const SO_TIMESTAMP: u32 = 29;
pub const SO_TIMESTAMPNS: u32 = 35;
pub const SO_TIMESTAMPING: u32 = 37;
pub const SO_RCVTIMEO: u32 = 20;
pub const SO_SNDTIMEO: u32 = 21;
pub const SCM_TIMESTAMP: u32 = 29;
pub const SCM_TIMESTAMPNS: u32 = 35;
pub const SCM_TIMESTAMPING: u32 = 37;
pub const __osockaddr_defined: u32 = 1;
pub const __USE_KERNEL_IPV6_DEFS: u32 = 0;
pub const IP_OPTIONS: u32 = 4;
pub const IP_HDRINCL: u32 = 3;
pub const IP_TOS: u32 = 1;
pub const IP_TTL: u32 = 2;
pub const IP_RECVOPTS: u32 = 6;
pub const IP_RETOPTS: u32 = 7;
pub const IP_MULTICAST_IF: u32 = 32;
pub const IP_MULTICAST_TTL: u32 = 33;
pub const IP_MULTICAST_LOOP: u32 = 34;
pub const IP_ADD_MEMBERSHIP: u32 = 35;
pub const IP_DROP_MEMBERSHIP: u32 = 36;
pub const IP_UNBLOCK_SOURCE: u32 = 37;
pub const IP_BLOCK_SOURCE: u32 = 38;
pub const IP_ADD_SOURCE_MEMBERSHIP: u32 = 39;
pub const IP_DROP_SOURCE_MEMBERSHIP: u32 = 40;
pub const IP_MSFILTER: u32 = 41;
pub const MCAST_JOIN_GROUP: u32 = 42;
pub const MCAST_BLOCK_SOURCE: u32 = 43;
pub const MCAST_UNBLOCK_SOURCE: u32 = 44;
pub const MCAST_LEAVE_GROUP: u32 = 45;
pub const MCAST_JOIN_SOURCE_GROUP: u32 = 46;
pub const MCAST_LEAVE_SOURCE_GROUP: u32 = 47;
pub const MCAST_MSFILTER: u32 = 48;
pub const IP_MULTICAST_ALL: u32 = 49;
pub const IP_UNICAST_IF: u32 = 50;
pub const MCAST_EXCLUDE: u32 = 0;
pub const MCAST_INCLUDE: u32 = 1;
pub const IP_ROUTER_ALERT: u32 = 5;
pub const IP_PKTINFO: u32 = 8;
pub const IP_PKTOPTIONS: u32 = 9;
pub const IP_PMTUDISC: u32 = 10;
pub const IP_MTU_DISCOVER: u32 = 10;
pub const IP_RECVERR: u32 = 11;
pub const IP_RECVTTL: u32 = 12;
pub const IP_RECVTOS: u32 = 13;
pub const IP_MTU: u32 = 14;
pub const IP_FREEBIND: u32 = 15;
pub const IP_IPSEC_POLICY: u32 = 16;
pub const IP_XFRM_POLICY: u32 = 17;
pub const IP_PASSSEC: u32 = 18;
pub const IP_TRANSPARENT: u32 = 19;
pub const IP_ORIGDSTADDR: u32 = 20;
pub const IP_RECVORIGDSTADDR: u32 = 20;
pub const IP_MINTTL: u32 = 21;
pub const IP_NODEFRAG: u32 = 22;
pub const IP_CHECKSUM: u32 = 23;
pub const IP_BIND_ADDRESS_NO_PORT: u32 = 24;
pub const IP_RECVFRAGSIZE: u32 = 25;
pub const IP_RECVERR_RFC4884: u32 = 26;
pub const IP_PMTUDISC_DONT: u32 = 0;
pub const IP_PMTUDISC_WANT: u32 = 1;
pub const IP_PMTUDISC_DO: u32 = 2;
pub const IP_PMTUDISC_PROBE: u32 = 3;
pub const IP_PMTUDISC_INTERFACE: u32 = 4;
pub const IP_PMTUDISC_OMIT: u32 = 5;
pub const SOL_IP: u32 = 0;
pub const IP_DEFAULT_MULTICAST_TTL: u32 = 1;
pub const IP_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IP_MAX_MEMBERSHIPS: u32 = 20;
pub const IPV6_ADDRFORM: u32 = 1;
pub const IPV6_2292PKTINFO: u32 = 2;
pub const IPV6_2292HOPOPTS: u32 = 3;
pub const IPV6_2292DSTOPTS: u32 = 4;
pub const IPV6_2292RTHDR: u32 = 5;
pub const IPV6_2292PKTOPTIONS: u32 = 6;
pub const IPV6_CHECKSUM: u32 = 7;
pub const IPV6_2292HOPLIMIT: u32 = 8;
pub const IPV6_NEXTHOP: u32 = 9;
pub const IPV6_AUTHHDR: u32 = 10;
pub const IPV6_UNICAST_HOPS: u32 = 16;
pub const IPV6_MULTICAST_IF: u32 = 17;
pub const IPV6_MULTICAST_HOPS: u32 = 18;
pub const IPV6_MULTICAST_LOOP: u32 = 19;
pub const IPV6_JOIN_GROUP: u32 = 20;
pub const IPV6_LEAVE_GROUP: u32 = 21;
pub const IPV6_ROUTER_ALERT: u32 = 22;
pub const IPV6_MTU_DISCOVER: u32 = 23;
pub const IPV6_MTU: u32 = 24;
pub const IPV6_RECVERR: u32 = 25;
pub const IPV6_V6ONLY: u32 = 26;
pub const IPV6_JOIN_ANYCAST: u32 = 27;
pub const IPV6_LEAVE_ANYCAST: u32 = 28;
pub const IPV6_MULTICAST_ALL: u32 = 29;
pub const IPV6_ROUTER_ALERT_ISOLATE: u32 = 30;
pub const IPV6_RECVERR_RFC4884: u32 = 31;
pub const IPV6_IPSEC_POLICY: u32 = 34;
pub const IPV6_XFRM_POLICY: u32 = 35;
pub const IPV6_HDRINCL: u32 = 36;
pub const IPV6_RECVPKTINFO: u32 = 49;
pub const IPV6_PKTINFO: u32 = 50;
pub const IPV6_RECVHOPLIMIT: u32 = 51;
pub const IPV6_HOPLIMIT: u32 = 52;
pub const IPV6_RECVHOPOPTS: u32 = 53;
pub const IPV6_HOPOPTS: u32 = 54;
pub const IPV6_RTHDRDSTOPTS: u32 = 55;
pub const IPV6_RECVRTHDR: u32 = 56;
pub const IPV6_RTHDR: u32 = 57;
pub const IPV6_RECVDSTOPTS: u32 = 58;
pub const IPV6_DSTOPTS: u32 = 59;
pub const IPV6_RECVPATHMTU: u32 = 60;
pub const IPV6_PATHMTU: u32 = 61;
pub const IPV6_DONTFRAG: u32 = 62;
pub const IPV6_RECVTCLASS: u32 = 66;
pub const IPV6_TCLASS: u32 = 67;
pub const IPV6_AUTOFLOWLABEL: u32 = 70;
pub const IPV6_ADDR_PREFERENCES: u32 = 72;
pub const IPV6_MINHOPCOUNT: u32 = 73;
pub const IPV6_ORIGDSTADDR: u32 = 74;
pub const IPV6_RECVORIGDSTADDR: u32 = 74;
pub const IPV6_TRANSPARENT: u32 = 75;
pub const IPV6_UNICAST_IF: u32 = 76;
pub const IPV6_RECVFRAGSIZE: u32 = 77;
pub const IPV6_FREEBIND: u32 = 78;
pub const IPV6_ADD_MEMBERSHIP: u32 = 20;
pub const IPV6_DROP_MEMBERSHIP: u32 = 21;
pub const IPV6_RXHOPOPTS: u32 = 54;
pub const IPV6_RXDSTOPTS: u32 = 59;
pub const IPV6_PMTUDISC_DONT: u32 = 0;
pub const IPV6_PMTUDISC_WANT: u32 = 1;
pub const IPV6_PMTUDISC_DO: u32 = 2;
pub const IPV6_PMTUDISC_PROBE: u32 = 3;
pub const IPV6_PMTUDISC_INTERFACE: u32 = 4;
pub const IPV6_PMTUDISC_OMIT: u32 = 5;
pub const SOL_IPV6: u32 = 41;
pub const SOL_ICMPV6: u32 = 58;
pub const IPV6_RTHDR_LOOSE: u32 = 0;
pub const IPV6_RTHDR_STRICT: u32 = 1;
pub const IPV6_RTHDR_TYPE_0: u32 = 0;
pub const IN_CLASSA_NET: u32 = 4278190080;
pub const IN_CLASSA_NSHIFT: u32 = 24;
pub const IN_CLASSA_HOST: u32 = 16777215;
pub const IN_CLASSA_MAX: u32 = 128;
pub const IN_CLASSB_NET: u32 = 4294901760;
pub const IN_CLASSB_NSHIFT: u32 = 16;
pub const IN_CLASSB_HOST: u32 = 65535;
pub const IN_CLASSB_MAX: u32 = 65536;
pub const IN_CLASSC_NET: u32 = 4294967040;
pub const IN_CLASSC_NSHIFT: u32 = 8;
pub const IN_CLASSC_HOST: u32 = 255;
pub const IN_LOOPBACKNET: u32 = 127;
pub const INET_ADDRSTRLEN: u32 = 16;
pub const INET6_ADDRSTRLEN: u32 = 46;
pub const _RPC_NETDB_H: u32 = 1;
pub const _PATH_HEQUIV: &[u8; 17usize] = b"/etc/hosts.equiv\0";
pub const _PATH_HOSTS: &[u8; 11usize] = b"/etc/hosts\0";
pub const _PATH_NETWORKS: &[u8; 14usize] = b"/etc/networks\0";
pub const _PATH_NSSWITCH_CONF: &[u8; 19usize] = b"/etc/nsswitch.conf\0";
pub const _PATH_PROTOCOLS: &[u8; 15usize] = b"/etc/protocols\0";
pub const _PATH_SERVICES: &[u8; 14usize] = b"/etc/services\0";
pub const HOST_NOT_FOUND: u32 = 1;
pub const TRY_AGAIN: u32 = 2;
pub const NO_RECOVERY: u32 = 3;
pub const NO_DATA: u32 = 4;
pub const NETDB_INTERNAL: i32 = -1;
pub const NETDB_SUCCESS: u32 = 0;
pub const NO_ADDRESS: u32 = 4;
pub const AI_PASSIVE: u32 = 1;
pub const AI_CANONNAME: u32 = 2;
pub const AI_NUMERICHOST: u32 = 4;
pub const AI_V4MAPPED: u32 = 8;
pub const AI_ALL: u32 = 16;
pub const AI_ADDRCONFIG: u32 = 32;
pub const AI_NUMERICSERV: u32 = 1024;
pub const EAI_BADFLAGS: i32 = -1;
pub const EAI_NONAME: i32 = -2;
pub const EAI_AGAIN: i32 = -3;
pub const EAI_FAIL: i32 = -4;
pub const EAI_FAMILY: i32 = -6;
pub const EAI_SOCKTYPE: i32 = -7;
pub const EAI_SERVICE: i32 = -8;
pub const EAI_MEMORY: i32 = -10;
pub const EAI_SYSTEM: i32 = -11;
pub const EAI_OVERFLOW: i32 = -12;
pub const NI_MAXHOST: u32 = 1025;
pub const NI_MAXSERV: u32 = 32;
pub const NI_NUMERICHOST: u32 = 1;
pub const NI_NUMERICSERV: u32 = 2;
pub const NI_NOFQDN: u32 = 4;
pub const NI_NAMEREQD: u32 = 8;
pub const NI_DGRAM: u32 = 16;
pub const _PWD_H: u32 = 1;
pub const NSS_BUFLEN_PASSWD: u32 = 1024;
pub const PGINVALID_SOCKET: i32 = -1;
pub const PG_BACKEND_VERSIONSTR: &[u8; 29usize] = b"postgres (PostgreSQL) 12.12\n\0";
pub const EXE: &[u8; 1usize] = b"\0";
pub const DEVNULL: &[u8; 10usize] = b"/dev/null\0";
pub const USE_REPL_SNPRINTF: u32 = 1;
pub const PG_STRERROR_R_BUFLEN: u32 = 256;
pub const PG_IOLBF: u32 = 1;
pub const _MATH_H: u32 = 1;
pub const _BITS_LIBM_SIMD_DECL_STUBS_H: u32 = 1;
pub const __FP_LOGB0_IS_MIN: u32 = 1;
pub const __FP_LOGBNAN_IS_MIN: u32 = 1;
pub const FP_ILOGB0: i32 = -2147483648;
pub const FP_ILOGBNAN: i32 = -2147483648;
pub const __MATH_DECLARING_DOUBLE: u32 = 1;
pub const __MATH_DECLARING_FLOATN: u32 = 0;
pub const __MATH_DECLARE_LDOUBLE: u32 = 1;
pub const MATH_ERRNO: u32 = 1;
pub const MATH_ERREXCEPT: u32 = 2;
pub const math_errhandling: u32 = 3;
pub const M_E: f64 = 2.718281828459045;
pub const M_LOG2E: f64 = 1.4426950408889634;
pub const M_LOG10E: f64 = 0.4342944819032518;
pub const M_LN2: f64 = 0.6931471805599453;
pub const M_LN10: f64 = 2.302585092994046;
pub const M_PI: f64 = 3.141592653589793;
pub const M_PI_2: f64 = 1.5707963267948966;
pub const M_PI_4: f64 = 0.7853981633974483;
pub const M_1_PI: f64 = 0.3183098861837907;
pub const M_2_PI: f64 = 0.6366197723675814;
pub const M_2_SQRTPI: f64 = 1.1283791670955126;
pub const M_SQRT2: f64 = 1.4142135623730951;
pub const M_SQRT1_2: f64 = 0.7071067811865476;
pub const _SETJMP_H: u32 = 1;
pub const _BITS_SETJMP_H: u32 = 1;
pub const __jmp_buf_tag_defined: u32 = 1;
pub const DEBUG5: u32 = 10;
pub const DEBUG4: u32 = 11;
pub const DEBUG3: u32 = 12;
pub const DEBUG2: u32 = 13;
pub const DEBUG1: u32 = 14;
pub const LOG: u32 = 15;
pub const LOG_SERVER_ONLY: u32 = 16;
pub const COMMERROR: u32 = 16;
pub const INFO: u32 = 17;
pub const NOTICE: u32 = 18;
pub const WARNING: u32 = 19;
pub const ERROR: u32 = 20;
pub const FATAL: u32 = 21;
pub const PANIC: u32 = 22;
pub const LOG_DESTINATION_STDERR: u32 = 1;
pub const LOG_DESTINATION_SYSLOG: u32 = 2;
pub const LOG_DESTINATION_EVENTLOG: u32 = 4;
pub const LOG_DESTINATION_CSVLOG: u32 = 8;
pub const MCXT_ALLOC_HUGE: u32 = 1;
pub const MCXT_ALLOC_NO_OOM: u32 = 2;
pub const MCXT_ALLOC_ZERO: u32 = 4;
pub const VARATT_SHORT_MAX: u32 = 127;
pub const FIELDNO_NULLABLE_DATUM_DATUM: u32 = 0;
pub const FIELDNO_NULLABLE_DATUM_ISNULL: u32 = 1;
pub const SIZEOF_DATUM: u32 = 8;
pub const FLOAT4PASSBYVAL: u32 = 1;
pub const FLOAT8PASSBYVAL: u32 = 1;
pub const FIELDNO_FUNCTIONCALLINFODATA_ISNULL: u32 = 4;
pub const FIELDNO_FUNCTIONCALLINFODATA_ARGS: u32 = 6;
pub const PG_MAGIC_FUNCTION_NAME_STRING: &[u8; 14usize] = b"Pg_magic_func\0";
pub const AGG_CONTEXT_AGGREGATE: u32 = 1;
pub const AGG_CONTEXT_WINDOW: u32 = 2;
pub const InvalidAttrNumber: u32 = 0;
pub const MaxAttrNumber: u32 = 32767;
pub const AttributeRelationId: u32 = 1249;
pub const AttributeRelation_Rowtype_Id: u32 = 75;
pub const Anum_pg_attribute_attrelid: u32 = 1;
pub const Anum_pg_attribute_attname: u32 = 2;
pub const Anum_pg_attribute_atttypid: u32 = 3;
pub const Anum_pg_attribute_attstattarget: u32 = 4;
pub const Anum_pg_attribute_attlen: u32 = 5;
pub const Anum_pg_attribute_attnum: u32 = 6;
pub const Anum_pg_attribute_attndims: u32 = 7;
pub const Anum_pg_attribute_attcacheoff: u32 = 8;
pub const Anum_pg_attribute_atttypmod: u32 = 9;
pub const Anum_pg_attribute_attbyval: u32 = 10;
pub const Anum_pg_attribute_attstorage: u32 = 11;
pub const Anum_pg_attribute_attalign: u32 = 12;
pub const Anum_pg_attribute_attnotnull: u32 = 13;
pub const Anum_pg_attribute_atthasdef: u32 = 14;
pub const Anum_pg_attribute_atthasmissing: u32 = 15;
pub const Anum_pg_attribute_attidentity: u32 = 16;
pub const Anum_pg_attribute_attgenerated: u32 = 17;
pub const Anum_pg_attribute_attisdropped: u32 = 18;
pub const Anum_pg_attribute_attislocal: u32 = 19;
pub const Anum_pg_attribute_attinhcount: u32 = 20;
pub const Anum_pg_attribute_attcollation: u32 = 21;
pub const Anum_pg_attribute_attacl: u32 = 22;
pub const Anum_pg_attribute_attoptions: u32 = 23;
pub const Anum_pg_attribute_attfdwoptions: u32 = 24;
pub const Anum_pg_attribute_attmissingval: u32 = 25;
pub const Natts_pg_attribute: u32 = 25;
pub const ATTRIBUTE_IDENTITY_ALWAYS: u8 = 97u8;
pub const ATTRIBUTE_IDENTITY_BY_DEFAULT: u8 = 100u8;
pub const ATTRIBUTE_GENERATED_STORED: u8 = 115u8;
pub const AGGSPLITOP_COMBINE: u32 = 1;
pub const AGGSPLITOP_SKIPFINAL: u32 = 2;
pub const AGGSPLITOP_SERIALIZE: u32 = 4;
pub const AGGSPLITOP_DESERIALIZE: u32 = 8;
pub const LP_UNUSED: u32 = 0;
pub const LP_NORMAL: u32 = 1;
pub const LP_REDIRECT: u32 = 2;
pub const LP_DEAD: u32 = 3;
pub const OffsetNumberMask: u32 = 65535;
pub const SpecTokenOffsetNumber: u32 = 65534;
pub const MovedPartitionsOffsetNumber: u32 = 65533;
pub const FIELDNO_HEAPTUPLEDATA_DATA: u32 = 3;
pub const SelfItemPointerAttributeNumber: i32 = -1;
pub const MinTransactionIdAttributeNumber: i32 = -2;
pub const MinCommandIdAttributeNumber: i32 = -3;
pub const MaxTransactionIdAttributeNumber: i32 = -4;
pub const MaxCommandIdAttributeNumber: i32 = -5;
pub const TableOidAttributeNumber: i32 = -6;
pub const FirstLowInvalidHeapAttributeNumber: i32 = -7;
pub const _FCNTL_H: u32 = 1;
pub const __O_LARGEFILE: u32 = 0;
pub const F_GETLK64: u32 = 5;
pub const F_SETLK64: u32 = 6;
pub const F_SETLKW64: u32 = 7;
pub const O_ACCMODE: u32 = 3;
pub const O_RDONLY: u32 = 0;
pub const O_WRONLY: u32 = 1;
pub const O_RDWR: u32 = 2;
pub const O_CREAT: u32 = 64;
pub const O_EXCL: u32 = 128;
pub const O_NOCTTY: u32 = 256;
pub const O_TRUNC: u32 = 512;
pub const O_APPEND: u32 = 1024;
pub const O_NONBLOCK: u32 = 2048;
pub const O_NDELAY: u32 = 2048;
pub const O_SYNC: u32 = 1052672;
pub const O_FSYNC: u32 = 1052672;
pub const O_ASYNC: u32 = 8192;
pub const __O_DIRECTORY: u32 = 65536;
pub const __O_NOFOLLOW: u32 = 131072;
pub const __O_CLOEXEC: u32 = 524288;
pub const __O_DIRECT: u32 = 16384;
pub const __O_NOATIME: u32 = 262144;
pub const __O_PATH: u32 = 2097152;
pub const __O_DSYNC: u32 = 4096;
pub const __O_TMPFILE: u32 = 4259840;
pub const F_GETLK: u32 = 5;
pub const F_SETLK: u32 = 6;
pub const F_SETLKW: u32 = 7;
pub const O_DIRECTORY: u32 = 65536;
pub const O_NOFOLLOW: u32 = 131072;
pub const O_CLOEXEC: u32 = 524288;
pub const O_DSYNC: u32 = 4096;
pub const O_RSYNC: u32 = 1052672;
pub const F_DUPFD: u32 = 0;
pub const F_GETFD: u32 = 1;
pub const F_SETFD: u32 = 2;
pub const F_GETFL: u32 = 3;
pub const F_SETFL: u32 = 4;
pub const __F_SETOWN: u32 = 8;
pub const __F_GETOWN: u32 = 9;
pub const F_SETOWN: u32 = 8;
pub const F_GETOWN: u32 = 9;
pub const __F_SETSIG: u32 = 10;
pub const __F_GETSIG: u32 = 11;
pub const __F_SETOWN_EX: u32 = 15;
pub const __F_GETOWN_EX: u32 = 16;
pub const F_DUPFD_CLOEXEC: u32 = 1030;
pub const FD_CLOEXEC: u32 = 1;
pub const F_RDLCK: u32 = 0;
pub const F_WRLCK: u32 = 1;
pub const F_UNLCK: u32 = 2;
pub const F_EXLCK: u32 = 4;
pub const F_SHLCK: u32 = 8;
pub const LOCK_SH: u32 = 1;
pub const LOCK_EX: u32 = 2;
pub const LOCK_NB: u32 = 4;
pub const LOCK_UN: u32 = 8;
pub const FAPPEND: u32 = 1024;
pub const FFSYNC: u32 = 1052672;
pub const FASYNC: u32 = 8192;
pub const FNONBLOCK: u32 = 2048;
pub const FNDELAY: u32 = 2048;
pub const __POSIX_FADV_DONTNEED: u32 = 4;
pub const __POSIX_FADV_NOREUSE: u32 = 5;
pub const POSIX_FADV_NORMAL: u32 = 0;
pub const POSIX_FADV_RANDOM: u32 = 1;
pub const POSIX_FADV_SEQUENTIAL: u32 = 2;
pub const POSIX_FADV_WILLNEED: u32 = 3;
pub const POSIX_FADV_DONTNEED: u32 = 4;
pub const POSIX_FADV_NOREUSE: u32 = 5;
pub const _BITS_STAT_H: u32 = 1;
pub const _BITS_STRUCT_STAT_H: u32 = 1;
pub const __S_IFMT: u32 = 61440;
pub const __S_IFDIR: u32 = 16384;
pub const __S_IFCHR: u32 = 8192;
pub const __S_IFBLK: u32 = 24576;
pub const __S_IFREG: u32 = 32768;
pub const __S_IFIFO: u32 = 4096;
pub const __S_IFLNK: u32 = 40960;
pub const __S_IFSOCK: u32 = 49152;
pub const __S_ISUID: u32 = 2048;
pub const __S_ISGID: u32 = 1024;
pub const __S_ISVTX: u32 = 512;
pub const __S_IREAD: u32 = 256;
pub const __S_IWRITE: u32 = 128;
pub const __S_IEXEC: u32 = 64;
pub const UTIME_NOW: u32 = 1073741823;
pub const UTIME_OMIT: u32 = 1073741822;
pub const S_IFMT: u32 = 61440;
pub const S_IFDIR: u32 = 16384;
pub const S_IFCHR: u32 = 8192;
pub const S_IFBLK: u32 = 24576;
pub const S_IFREG: u32 = 32768;
pub const S_IFIFO: u32 = 4096;
pub const S_IFLNK: u32 = 40960;
pub const S_IFSOCK: u32 = 49152;
pub const S_ISUID: u32 = 2048;
pub const S_ISGID: u32 = 1024;
pub const S_ISVTX: u32 = 512;
pub const S_IRUSR: u32 = 256;
pub const S_IWUSR: u32 = 128;
pub const S_IXUSR: u32 = 64;
pub const S_IRWXU: u32 = 448;
pub const S_IRGRP: u32 = 32;
pub const S_IWGRP: u32 = 16;
pub const S_IXGRP: u32 = 8;
pub const S_IRWXG: u32 = 56;
pub const S_IROTH: u32 = 4;
pub const S_IWOTH: u32 = 2;
pub const S_IXOTH: u32 = 1;
pub const S_IRWXO: u32 = 7;
pub const R_OK: u32 = 4;
pub const W_OK: u32 = 2;
pub const X_OK: u32 = 1;
pub const F_OK: u32 = 0;
pub const AT_FDCWD: i32 = -100;
pub const AT_SYMLINK_NOFOLLOW: u32 = 256;
pub const AT_REMOVEDIR: u32 = 512;
pub const AT_SYMLINK_FOLLOW: u32 = 1024;
pub const AT_EACCESS: u32 = 512;
pub const F_ULOCK: u32 = 0;
pub const F_LOCK: u32 = 1;
pub const F_TLOCK: u32 = 2;
pub const F_TEST: u32 = 3;
pub const InvalidXLogRecPtr: u32 = 0;
pub const PG_O_DIRECT: u32 = 0;
pub const OPEN_SYNC_FLAG: u32 = 1052672;
pub const OPEN_DATASYNC_FLAG: u32 = 4096;
pub const FirstGenbkiObjectId: u32 = 10000;
pub const FirstBootstrapObjectId: u32 = 12000;
pub const FirstNormalObjectId: u32 = 16384;
pub const PD_HAS_FREE_LINES: u32 = 1;
pub const PD_PAGE_FULL: u32 = 2;
pub const PD_ALL_VISIBLE: u32 = 4;
pub const PD_VALID_FLAG_BITS: u32 = 7;
pub const PG_PAGE_LAYOUT_VERSION: u32 = 4;
pub const PG_DATA_CHECKSUM_VERSION: u32 = 1;
pub const PAI_OVERWRITE: u32 = 1;
pub const PAI_IS_HEAP: u32 = 2;
pub const PIV_LOG_WARNING: u32 = 1;
pub const PIV_REPORT_STAT: u32 = 2;
pub const MaxTupleAttributeNumber: u32 = 1664;
pub const MaxHeapAttributeNumber: u32 = 1600;
pub const FIELDNO_HEAPTUPLEHEADERDATA_INFOMASK2: u32 = 2;
pub const FIELDNO_HEAPTUPLEHEADERDATA_INFOMASK: u32 = 3;
pub const FIELDNO_HEAPTUPLEHEADERDATA_HOFF: u32 = 4;
pub const FIELDNO_HEAPTUPLEHEADERDATA_BITS: u32 = 5;
pub const HEAP_HASNULL: u32 = 1;
pub const HEAP_HASVARWIDTH: u32 = 2;
pub const HEAP_HASEXTERNAL: u32 = 4;
pub const HEAP_HASOID_OLD: u32 = 8;
pub const HEAP_XMAX_KEYSHR_LOCK: u32 = 16;
pub const HEAP_COMBOCID: u32 = 32;
pub const HEAP_XMAX_EXCL_LOCK: u32 = 64;
pub const HEAP_XMAX_LOCK_ONLY: u32 = 128;
pub const HEAP_XMAX_SHR_LOCK: u32 = 80;
pub const HEAP_LOCK_MASK: u32 = 80;
pub const HEAP_XMIN_COMMITTED: u32 = 256;
pub const HEAP_XMIN_INVALID: u32 = 512;
pub const HEAP_XMIN_FROZEN: u32 = 768;
pub const HEAP_XMAX_COMMITTED: u32 = 1024;
pub const HEAP_XMAX_INVALID: u32 = 2048;
pub const HEAP_XMAX_IS_MULTI: u32 = 4096;
pub const HEAP_UPDATED: u32 = 8192;
pub const HEAP_MOVED_OFF: u32 = 16384;
pub const HEAP_MOVED_IN: u32 = 32768;
pub const HEAP_MOVED: u32 = 49152;
pub const HEAP_XACT_MASK: u32 = 65520;
pub const HEAP_XMAX_BITS: u32 = 7376;
pub const HEAP_NATTS_MASK: u32 = 2047;
pub const HEAP_KEYS_UPDATED: u32 = 8192;
pub const HEAP_HOT_UPDATED: u32 = 16384;
pub const HEAP_ONLY_TUPLE: u32 = 32768;
pub const HEAP2_XACT_MASK: u32 = 57344;
pub const HEAP_TUPLE_HAS_MATCH: u32 = 32768;
pub const MaxAttrSize: u32 = 10485760;
pub const InvalidBuffer: u32 = 0;
pub const TTS_FLAG_EMPTY: u32 = 2;
pub const TTS_FLAG_SHOULDFREE: u32 = 4;
pub const TTS_FLAG_SLOW: u32 = 8;
pub const TTS_FLAG_FIXED: u32 = 16;
pub const FIELDNO_TUPLETABLESLOT_FLAGS: u32 = 1;
pub const FIELDNO_TUPLETABLESLOT_NVALID: u32 = 2;
pub const FIELDNO_TUPLETABLESLOT_TUPLEDESCRIPTOR: u32 = 4;
pub const FIELDNO_TUPLETABLESLOT_VALUES: u32 = 5;
pub const FIELDNO_TUPLETABLESLOT_ISNULL: u32 = 6;
pub const FIELDNO_HEAPTUPLETABLESLOT_TUPLE: u32 = 1;
pub const FIELDNO_HEAPTUPLETABLESLOT_OFF: u32 = 2;
pub const FIELDNO_MINIMALTUPLETABLESLOT_TUPLE: u32 = 1;
pub const FIELDNO_MINIMALTUPLETABLESLOT_OFF: u32 = 4;
pub const BITS_PER_BITMAPWORD: u32 = 64;
pub const _TIME_H: u32 = 1;
pub const _BITS_TIME_H: u32 = 1;
pub const CLOCK_REALTIME: u32 = 0;
pub const CLOCK_MONOTONIC: u32 = 1;
pub const CLOCK_PROCESS_CPUTIME_ID: u32 = 2;
pub const CLOCK_THREAD_CPUTIME_ID: u32 = 3;
pub const CLOCK_MONOTONIC_RAW: u32 = 4;
pub const CLOCK_REALTIME_COARSE: u32 = 5;
pub const CLOCK_MONOTONIC_COARSE: u32 = 6;
pub const CLOCK_BOOTTIME: u32 = 7;
pub const CLOCK_REALTIME_ALARM: u32 = 8;
pub const CLOCK_BOOTTIME_ALARM: u32 = 9;
pub const CLOCK_TAI: u32 = 11;
pub const TIMER_ABSTIME: u32 = 1;
pub const __struct_tm_defined: u32 = 1;
pub const __itimerspec_defined: u32 = 1;
pub const TIME_UTC: u32 = 1;
pub const PG_INSTR_CLOCK: u32 = 1;
pub const PARAM_FLAG_CONST: u32 = 1;
pub const BTLessStrategyNumber: u32 = 1;
pub const BTLessEqualStrategyNumber: u32 = 2;
pub const BTEqualStrategyNumber: u32 = 3;
pub const BTGreaterEqualStrategyNumber: u32 = 4;
pub const BTGreaterStrategyNumber: u32 = 5;
pub const BTMaxStrategyNumber: u32 = 5;
pub const HTEqualStrategyNumber: u32 = 1;
pub const HTMaxStrategyNumber: u32 = 1;
pub const RTLeftStrategyNumber: u32 = 1;
pub const RTOverLeftStrategyNumber: u32 = 2;
pub const RTOverlapStrategyNumber: u32 = 3;
pub const RTOverRightStrategyNumber: u32 = 4;
pub const RTRightStrategyNumber: u32 = 5;
pub const RTSameStrategyNumber: u32 = 6;
pub const RTContainsStrategyNumber: u32 = 7;
pub const RTContainedByStrategyNumber: u32 = 8;
pub const RTOverBelowStrategyNumber: u32 = 9;
pub const RTBelowStrategyNumber: u32 = 10;
pub const RTAboveStrategyNumber: u32 = 11;
pub const RTOverAboveStrategyNumber: u32 = 12;
pub const RTOldContainsStrategyNumber: u32 = 13;
pub const RTOldContainedByStrategyNumber: u32 = 14;
pub const RTKNNSearchStrategyNumber: u32 = 15;
pub const RTContainsElemStrategyNumber: u32 = 16;
pub const RTAdjacentStrategyNumber: u32 = 17;
pub const RTEqualStrategyNumber: u32 = 18;
pub const RTNotEqualStrategyNumber: u32 = 19;
pub const RTLessStrategyNumber: u32 = 20;
pub const RTLessEqualStrategyNumber: u32 = 21;
pub const RTGreaterStrategyNumber: u32 = 22;
pub const RTGreaterEqualStrategyNumber: u32 = 23;
pub const RTSubStrategyNumber: u32 = 24;
pub const RTSubEqualStrategyNumber: u32 = 25;
pub const RTSuperStrategyNumber: u32 = 26;
pub const RTSuperEqualStrategyNumber: u32 = 27;
pub const RTPrefixStrategyNumber: u32 = 28;
pub const RTMaxStrategyNumber: u32 = 28;
pub const INNER_VAR: u32 = 65000;
pub const OUTER_VAR: u32 = 65001;
pub const INDEX_VAR: u32 = 65002;
pub const PRS2_OLD_VARNO: u32 = 1;
pub const PRS2_NEW_VARNO: u32 = 2;
pub const HASH_PARTITION: u32 = 1;
pub const HASH_SEGMENT: u32 = 2;
pub const HASH_DIRSIZE: u32 = 4;
pub const HASH_FFACTOR: u32 = 8;
pub const HASH_ELEM: u32 = 16;
pub const HASH_BLOBS: u32 = 32;
pub const HASH_FUNCTION: u32 = 64;
pub const HASH_COMPARE: u32 = 128;
pub const HASH_KEYCOPY: u32 = 256;
pub const HASH_ALLOC: u32 = 512;
pub const HASH_CONTEXT: u32 = 1024;
pub const HASH_SHARED_MEM: u32 = 2048;
pub const HASH_ATTACH: u32 = 4096;
pub const HASH_FIXED_SIZE: u32 = 8192;
pub const NO_MAX_DSIZE: i32 = -1;
pub const _DIRENT_H: u32 = 1;
pub const _DIRENT_MATCHES_DIRENT64: u32 = 1;
pub const _BITS_POSIX1_LIM_H: u32 = 1;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const NR_OPEN: u32 = 1024;
pub const NGROUPS_MAX: u32 = 65536;
pub const ARG_MAX: u32 = 131072;
pub const LINK_MAX: u32 = 127;
pub const MAX_CANON: u32 = 255;
pub const MAX_INPUT: u32 = 255;
pub const NAME_MAX: u32 = 255;
pub const PATH_MAX: u32 = 4096;
pub const PIPE_BUF: u32 = 4096;
pub const XATTR_NAME_MAX: u32 = 255;
pub const XATTR_SIZE_MAX: u32 = 65536;
pub const XATTR_LIST_MAX: u32 = 65536;
pub const RTSIG_MAX: u32 = 32;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const PTHREAD_KEYS_MAX: u32 = 1024;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const AIO_PRIO_DELTA_MAX: u32 = 20;
pub const PTHREAD_STACK_MIN: u32 = 16384;
pub const DELAYTIMER_MAX: u32 = 2147483647;
pub const TTY_NAME_MAX: u32 = 32;
pub const LOGIN_NAME_MAX: u32 = 256;
pub const HOST_NAME_MAX: u32 = 64;
pub const MQ_PRIO_MAX: u32 = 32768;
pub const SEM_VALUE_MAX: u32 = 2147483647;
pub const MAXNAMLEN: u32 = 255;
pub const PG_TEMP_FILES_DIR: &[u8; 10usize] = b"pgsql_tmp\0";
pub const PG_TEMP_FILE_PREFIX: &[u8; 10usize] = b"pgsql_tmp\0";
pub const DSM_IMPL_POSIX: u32 = 1;
pub const DSM_IMPL_SYSV: u32 = 2;
pub const DSM_IMPL_WINDOWS: u32 = 3;
pub const DSM_IMPL_MMAP: u32 = 4;
pub const DEFAULT_DYNAMIC_SHARED_MEMORY_TYPE: u32 = 1;
pub const PG_DYNSHMEM_DIR: &[u8; 12usize] = b"pg_dynshmem\0";
pub const PG_DYNSHMEM_MMAP_FILE_PREFIX: &[u8; 6usize] = b"mmap.\0";
pub const DSM_CREATE_NULL_IF_MAXSEGMENTS: u32 = 1;
pub const DSM_HANDLE_INVALID: u32 = 0;
pub const DEFAULT_SPINS_PER_DELAY: u32 = 100;
pub const SHARED_TUPLESTORE_SINGLE_PASS: u32 = 1;
pub const MAX_TIMESTAMP_PRECISION: u32 = 6;
pub const MAX_INTERVAL_PRECISION: u32 = 6;
pub const TS_PREC_INV: f64 = 1000000.0;
pub const DAYS_PER_YEAR: f64 = 365.25;
pub const MONTHS_PER_YEAR: u32 = 12;
pub const DAYS_PER_MONTH: u32 = 30;
pub const HOURS_PER_DAY: u32 = 24;
pub const SECS_PER_YEAR: u32 = 31557600;
pub const SECS_PER_DAY: u32 = 86400;
pub const SECS_PER_HOUR: u32 = 3600;
pub const SECS_PER_MINUTE: u32 = 60;
pub const MINS_PER_HOUR: u32 = 60;
pub const MAX_TZDISP_HOUR: u32 = 15;
pub const TZDISP_LIMIT: u32 = 57600;
pub const JULIAN_MINYEAR: i32 = -4713;
pub const JULIAN_MINMONTH: u32 = 11;
pub const JULIAN_MINDAY: u32 = 24;
pub const JULIAN_MAXYEAR: u32 = 5874898;
pub const JULIAN_MAXMONTH: u32 = 6;
pub const JULIAN_MAXDAY: u32 = 3;
pub const UNIX_EPOCH_JDATE: u32 = 2440588;
pub const POSTGRES_EPOCH_JDATE: u32 = 2451545;
pub const DATETIME_MIN_JULIAN: u32 = 0;
pub const DATE_END_JULIAN: u32 = 2147483494;
pub const TIMESTAMP_END_JULIAN: u32 = 109203528;
pub const RELCACHE_INIT_FILENAME: &[u8; 17usize] = b"pg_internal.init\0";
pub const INDEX_SIZE_MASK: u32 = 8191;
pub const INDEX_AM_RESERVED_BIT: u32 = 8192;
pub const INDEX_VAR_MASK: u32 = 16384;
pub const INDEX_NULL_MASK: u32 = 32768;
pub const _LIBC_LIMITS_H_: u32 = 1;
pub const MB_LEN_MAX: u32 = 16;
pub const _BITS_POSIX2_LIM_H: u32 = 1;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const COLL_WEIGHTS_MAX: u32 = 255;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const CHARCLASS_NAME_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 32767;
pub const SIZEOF_DSA_POINTER: u32 = 8;
pub const DSA_POINTER_FORMAT: &[u8; 7usize] = b"%016lx\0";
pub const DSA_ALLOC_HUGE: u32 = 1;
pub const DSA_ALLOC_NO_OOM: u32 = 2;
pub const DSA_ALLOC_ZERO: u32 = 4;
pub const EEO_FLAG_IS_QUAL: u32 = 1;
pub const FIELDNO_EXPRSTATE_RESNULL: u32 = 2;
pub const FIELDNO_EXPRSTATE_RESVALUE: u32 = 3;
pub const FIELDNO_EXPRSTATE_RESULTSLOT: u32 = 4;
pub const FIELDNO_EXPRCONTEXT_SCANTUPLE: u32 = 1;
pub const FIELDNO_EXPRCONTEXT_INNERTUPLE: u32 = 2;
pub const FIELDNO_EXPRCONTEXT_OUTERTUPLE: u32 = 3;
pub const FIELDNO_EXPRCONTEXT_AGGVALUES: u32 = 8;
pub const FIELDNO_EXPRCONTEXT_AGGNULLS: u32 = 9;
pub const FIELDNO_EXPRCONTEXT_CASEDATUM: u32 = 10;
pub const FIELDNO_EXPRCONTEXT_CASENULL: u32 = 11;
pub const FIELDNO_EXPRCONTEXT_DOMAINDATUM: u32 = 12;
pub const FIELDNO_EXPRCONTEXT_DOMAINNULL: u32 = 13;
pub const FIELDNO_AGGSTATE_CURAGGCONTEXT: u32 = 14;
pub const FIELDNO_AGGSTATE_CURPERTRANS: u32 = 16;
pub const FIELDNO_AGGSTATE_CURRENT_SET: u32 = 20;
pub const FIELDNO_AGGSTATE_ALL_PERGROUPS: u32 = 34;
pub const COMPLETION_TAG_BUFSIZE: u32 = 64;
pub const ACL_INSERT: u32 = 1;
pub const ACL_SELECT: u32 = 2;
pub const ACL_UPDATE: u32 = 4;
pub const ACL_DELETE: u32 = 8;
pub const ACL_TRUNCATE: u32 = 16;
pub const ACL_REFERENCES: u32 = 32;
pub const ACL_TRIGGER: u32 = 64;
pub const ACL_EXECUTE: u32 = 128;
pub const ACL_USAGE: u32 = 256;
pub const ACL_CREATE: u32 = 512;
pub const ACL_CREATE_TEMP: u32 = 1024;
pub const ACL_CONNECT: u32 = 2048;
pub const N_ACL_RIGHTS: u32 = 12;
pub const ACL_NO_RIGHTS: u32 = 0;
pub const ACL_SELECT_FOR_UPDATE: u32 = 4;
pub const FRAMEOPTION_NONDEFAULT: u32 = 1;
pub const FRAMEOPTION_RANGE: u32 = 2;
pub const FRAMEOPTION_ROWS: u32 = 4;
pub const FRAMEOPTION_GROUPS: u32 = 8;
pub const FRAMEOPTION_BETWEEN: u32 = 16;
pub const FRAMEOPTION_START_UNBOUNDED_PRECEDING: u32 = 32;
pub const FRAMEOPTION_END_UNBOUNDED_PRECEDING: u32 = 64;
pub const FRAMEOPTION_START_UNBOUNDED_FOLLOWING: u32 = 128;
pub const FRAMEOPTION_END_UNBOUNDED_FOLLOWING: u32 = 256;
pub const FRAMEOPTION_START_CURRENT_ROW: u32 = 512;
pub const FRAMEOPTION_END_CURRENT_ROW: u32 = 1024;
pub const FRAMEOPTION_START_OFFSET_PRECEDING: u32 = 2048;
pub const FRAMEOPTION_END_OFFSET_PRECEDING: u32 = 4096;
pub const FRAMEOPTION_START_OFFSET_FOLLOWING: u32 = 8192;
pub const FRAMEOPTION_END_OFFSET_FOLLOWING: u32 = 16384;
pub const FRAMEOPTION_EXCLUDE_CURRENT_ROW: u32 = 32768;
pub const FRAMEOPTION_EXCLUDE_GROUP: u32 = 65536;
pub const FRAMEOPTION_EXCLUDE_TIES: u32 = 131072;
pub const FRAMEOPTION_START_OFFSET: u32 = 10240;
pub const FRAMEOPTION_END_OFFSET: u32 = 20480;
pub const FRAMEOPTION_EXCLUSION: u32 = 229376;
pub const FRAMEOPTION_DEFAULTS: u32 = 1058;
pub const PARTITION_STRATEGY_HASH: u8 = 104u8;
pub const PARTITION_STRATEGY_LIST: u8 = 108u8;
pub const PARTITION_STRATEGY_RANGE: u8 = 114u8;
pub const FKCONSTR_ACTION_NOACTION: u8 = 97u8;
pub const FKCONSTR_ACTION_RESTRICT: u8 = 114u8;
pub const FKCONSTR_ACTION_CASCADE: u8 = 99u8;
pub const FKCONSTR_ACTION_SETNULL: u8 = 110u8;
pub const FKCONSTR_ACTION_SETDEFAULT: u8 = 100u8;
pub const FKCONSTR_MATCH_FULL: u8 = 102u8;
pub const FKCONSTR_MATCH_PARTIAL: u8 = 112u8;
pub const FKCONSTR_MATCH_SIMPLE: u8 = 115u8;
pub const OPCLASS_ITEM_OPERATOR: u32 = 1;
pub const OPCLASS_ITEM_FUNCTION: u32 = 2;
pub const OPCLASS_ITEM_STORAGETYPE: u32 = 3;
pub const CURSOR_OPT_BINARY: u32 = 1;
pub const CURSOR_OPT_SCROLL: u32 = 2;
pub const CURSOR_OPT_NO_SCROLL: u32 = 4;
pub const CURSOR_OPT_INSENSITIVE: u32 = 8;
pub const CURSOR_OPT_HOLD: u32 = 16;
pub const CURSOR_OPT_FAST_PLAN: u32 = 32;
pub const CURSOR_OPT_GENERIC_PLAN: u32 = 64;
pub const CURSOR_OPT_CUSTOM_PLAN: u32 = 128;
pub const CURSOR_OPT_PARALLEL_OK: u32 = 256;
pub const REINDEXOPT_VERBOSE: u32 = 1;
pub const REINDEXOPT_REPORT_PROGRESS: u32 = 2;
pub const MaxAllocHugeSize: u32 = 0;
pub const ALLOCSET_DEFAULT_MINSIZE: u32 = 0;
pub const ALLOCSET_DEFAULT_INITSIZE: u32 = 8192;
pub const ALLOCSET_DEFAULT_MAXSIZE: u32 = 8388608;
pub const ALLOCSET_SMALL_MINSIZE: u32 = 0;
pub const ALLOCSET_SMALL_INITSIZE: u32 = 1024;
pub const ALLOCSET_SMALL_MAXSIZE: u32 = 8192;
pub const ALLOCSET_SEPARATE_THRESHOLD: u32 = 8192;
pub const SLAB_DEFAULT_BLOCK_SIZE: u32 = 8192;
pub const SLAB_LARGE_BLOCK_SIZE: u32 = 8388608;
pub const EXEC_FLAG_EXPLAIN_ONLY: u32 = 1;
pub const EXEC_FLAG_REWIND: u32 = 2;
pub const EXEC_FLAG_BACKWARD: u32 = 4;
pub const EXEC_FLAG_MARK: u32 = 8;
pub const EXEC_FLAG_SKIP_TRIGGERS: u32 = 16;
pub const EXEC_FLAG_WITH_NO_DATA: u32 = 32;
pub const _BITS_SIGNUM_GENERIC_H: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGILL: u32 = 4;
pub const SIGABRT: u32 = 6;
pub const SIGFPE: u32 = 8;
pub const SIGSEGV: u32 = 11;
pub const SIGTERM: u32 = 15;
pub const SIGHUP: u32 = 1;
pub const SIGQUIT: u32 = 3;
pub const SIGTRAP: u32 = 5;
pub const SIGKILL: u32 = 9;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGIOT: u32 = 6;
pub const _BITS_SIGNUM_ARCH_H: u32 = 1;
pub const SIGSTKFLT: u32 = 16;
pub const SIGPWR: u32 = 30;
pub const SIGBUS: u32 = 7;
pub const SIGSYS: u32 = 31;
pub const SIGURG: u32 = 23;
pub const SIGSTOP: u32 = 19;
pub const SIGTSTP: u32 = 20;
pub const SIGCONT: u32 = 18;
pub const SIGCHLD: u32 = 17;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGPOLL: u32 = 29;
pub const SIGXFSZ: u32 = 25;
pub const SIGXCPU: u32 = 24;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGUSR1: u32 = 10;
pub const SIGUSR2: u32 = 12;
pub const SIGWINCH: u32 = 28;
pub const SIGIO: u32 = 29;
pub const SIGCLD: u32 = 17;
pub const __SIGRTMIN: u32 = 32;
pub const __SIGRTMAX: u32 = 64;
pub const _NSIG: u32 = 65;
pub const __sig_atomic_t_defined: u32 = 1;
pub const __siginfo_t_defined: u32 = 1;
pub const __SI_MAX_SIZE: u32 = 128;
pub const _BITS_SIGINFO_ARCH_H: u32 = 1;
pub const __SI_ERRNO_THEN_CODE: u32 = 1;
pub const __SI_HAVE_SIGSYS: u32 = 1;
pub const _BITS_SIGINFO_CONSTS_H: u32 = 1;
pub const __SI_ASYNCIO_AFTER_SIGIO: u32 = 1;
pub const __sigevent_t_defined: u32 = 1;
pub const __SIGEV_MAX_SIZE: u32 = 64;
pub const _BITS_SIGEVENT_CONSTS_H: u32 = 1;
pub const NSIG: u32 = 65;
pub const _BITS_SIGACTION_H: u32 = 1;
pub const SA_NOCLDSTOP: u32 = 1;
pub const SA_NOCLDWAIT: u32 = 2;
pub const SA_SIGINFO: u32 = 4;
pub const SA_ONSTACK: u32 = 134217728;
pub const SA_RESTART: u32 = 268435456;
pub const SA_NODEFER: u32 = 1073741824;
pub const SA_RESETHAND: u32 = 2147483648;
pub const SA_INTERRUPT: u32 = 536870912;
pub const SA_NOMASK: u32 = 1073741824;
pub const SA_ONESHOT: u32 = 2147483648;
pub const SA_STACK: u32 = 134217728;
pub const SIG_BLOCK: u32 = 0;
pub const SIG_UNBLOCK: u32 = 1;
pub const SIG_SETMASK: u32 = 2;
pub const _BITS_SIGCONTEXT_H: u32 = 1;
pub const FP_XSTATE_MAGIC1: u32 = 1179670611;
pub const FP_XSTATE_MAGIC2: u32 = 1179670597;
pub const __stack_t_defined: u32 = 1;
pub const _SYS_UCONTEXT_H: u32 = 1;
pub const __NGREG: u32 = 23;
pub const NGREG: u32 = 23;
pub const _BITS_SIGSTACK_H: u32 = 1;
pub const MINSIGSTKSZ: u32 = 2048;
pub const SIGSTKSZ: u32 = 8192;
pub const _BITS_SS_FLAGS_H: u32 = 1;
pub const __sigstack_defined: u32 = 1;
pub const _BITS_SIGTHREAD_H: u32 = 1;
pub const TZ_STRLEN_MAX: u32 = 255;
pub const InvalidPid: i32 = -1;
pub const USE_POSTGRES_DATES: u32 = 0;
pub const USE_ISO_DATES: u32 = 1;
pub const USE_SQL_DATES: u32 = 2;
pub const USE_GERMAN_DATES: u32 = 3;
pub const USE_XSD_DATES: u32 = 4;
pub const DATEORDER_YMD: u32 = 0;
pub const DATEORDER_DMY: u32 = 1;
pub const DATEORDER_MDY: u32 = 2;
pub const INTSTYLE_POSTGRES: u32 = 0;
pub const INTSTYLE_POSTGRES_VERBOSE: u32 = 1;
pub const INTSTYLE_SQL_STANDARD: u32 = 2;
pub const INTSTYLE_ISO_8601: u32 = 3;
pub const MAXTZLEN: u32 = 10;
pub const SECURITY_LOCAL_USERID_CHANGE: u32 = 1;
pub const SECURITY_RESTRICTED_OPERATION: u32 = 2;
pub const SECURITY_NOFORCE_RLS: u32 = 4;
pub const _SYS_UN_H: u32 = 1;
pub const SM_DATABASE: u32 = 64;
pub const SM_USER: u32 = 32;
pub const SM_DATABASE_USER: u32 = 97;
pub const SM_OPTIONS: u32 = 64;
pub const SM_UNUSED: u32 = 64;
pub const SM_TTY: u32 = 64;
pub const MAX_STARTUP_PACKET_LENGTH: u32 = 10000;
pub const AUTH_REQ_OK: u32 = 0;
pub const AUTH_REQ_KRB4: u32 = 1;
pub const AUTH_REQ_KRB5: u32 = 2;
pub const AUTH_REQ_PASSWORD: u32 = 3;
pub const AUTH_REQ_CRYPT: u32 = 4;
pub const AUTH_REQ_MD5: u32 = 5;
pub const AUTH_REQ_SCM_CREDS: u32 = 6;
pub const AUTH_REQ_GSS: u32 = 7;
pub const AUTH_REQ_GSS_CONT: u32 = 8;
pub const AUTH_REQ_SSPI: u32 = 9;
pub const AUTH_REQ_SASL: u32 = 10;
pub const AUTH_REQ_SASL_CONT: u32 = 11;
pub const AUTH_REQ_SASL_FIN: u32 = 12;
pub const MIN_XFN_CHARS: u32 = 16;
pub const MAX_XFN_CHARS: u32 = 40;
pub const VALID_XFN_CHARS: &[u8; 40usize] = b"0123456789ABCDEF.history.backup.partial\0";
pub const CATALOG_VERSION_NO: u32 = 201909212;
pub const OIDCHARS: u32 = 10;
pub const FORKNAMECHARS: u32 = 4;
pub const InvalidBackendId: i32 = -1;
pub const XLR_INFO_MASK: u32 = 15;
pub const XLR_RMGR_INFO_MASK: u32 = 240;
pub const XLR_SPECIAL_REL_UPDATE: u32 = 1;
pub const XLR_CHECK_CONSISTENCY: u32 = 2;
pub const BKPIMAGE_HAS_HOLE: u32 = 1;
pub const BKPIMAGE_IS_COMPRESSED: u32 = 2;
pub const BKPIMAGE_APPLY: u32 = 4;
pub const BKPBLOCK_FORK_MASK: u32 = 15;
pub const BKPBLOCK_FLAG_MASK: u32 = 240;
pub const BKPBLOCK_HAS_IMAGE: u32 = 16;
pub const BKPBLOCK_HAS_DATA: u32 = 32;
pub const BKPBLOCK_WILL_INIT: u32 = 64;
pub const BKPBLOCK_SAME_REL: u32 = 128;
pub const XLR_MAX_BLOCK_ID: u32 = 32;
pub const XLR_BLOCK_ID_DATA_SHORT: u32 = 255;
pub const XLR_BLOCK_ID_DATA_LONG: u32 = 254;
pub const XLR_BLOCK_ID_ORIGIN: u32 = 253;
pub const TRANSACTION_STATUS_IN_PROGRESS: u32 = 0;
pub const TRANSACTION_STATUS_COMMITTED: u32 = 1;
pub const TRANSACTION_STATUS_ABORTED: u32 = 2;
pub const TRANSACTION_STATUS_SUB_COMMITTED: u32 = 3;
pub const CLOG_ZEROPAGE: u32 = 0;
pub const CLOG_TRUNCATE: u32 = 16;
pub const WL_LATCH_SET: u32 = 1;
pub const WL_SOCKET_READABLE: u32 = 2;
pub const WL_SOCKET_WRITEABLE: u32 = 4;
pub const WL_TIMEOUT: u32 = 8;
pub const WL_POSTMASTER_DEATH: u32 = 16;
pub const WL_EXIT_ON_PM_DEATH: u32 = 32;
pub const WL_SOCKET_CONNECTED: u32 = 4;
pub const WL_SOCKET_MASK: u32 = 6;
pub const NoLock: u32 = 0;
pub const AccessShareLock: u32 = 1;
pub const RowShareLock: u32 = 2;
pub const RowExclusiveLock: u32 = 3;
pub const ShareUpdateExclusiveLock: u32 = 4;
pub const ShareLock: u32 = 5;
pub const ShareRowExclusiveLock: u32 = 6;
pub const ExclusiveLock: u32 = 7;
pub const AccessExclusiveLock: u32 = 8;
pub const MaxLockMode: u32 = 8;
pub const LWLOCK_PADDED_SIZE: u32 = 128;
pub const NUM_INDIVIDUAL_LWLOCKS: u32 = 48;
pub const NUM_BUFFER_PARTITIONS: u32 = 128;
pub const LOG2_NUM_LOCK_PARTITIONS: u32 = 4;
pub const NUM_LOCK_PARTITIONS: u32 = 16;
pub const LOG2_NUM_PREDICATELOCK_PARTITIONS: u32 = 4;
pub const NUM_PREDICATELOCK_PARTITIONS: u32 = 16;
pub const BUFFER_MAPPING_LWLOCK_OFFSET: u32 = 48;
pub const LOCK_MANAGER_LWLOCK_OFFSET: u32 = 176;
pub const PREDICATELOCK_MANAGER_LWLOCK_OFFSET: u32 = 192;
pub const NUM_FIXED_LWLOCKS: u32 = 208;
pub const SHMEM_INDEX_KEYSIZE: u32 = 48;
pub const SHMEM_INDEX_SIZE: u32 = 64;
pub const InvalidLocalTransactionId: u32 = 0;
pub const MAX_LOCKMODES: u32 = 10;
pub const DEFAULT_LOCKMETHOD: u32 = 1;
pub const USER_LOCKMETHOD: u32 = 2;
pub const PGPROC_MAX_CACHED_SUBXIDS: u32 = 64;
pub const PROC_IS_AUTOVACUUM: u32 = 1;
pub const PROC_IN_VACUUM: u32 = 2;
pub const PROC_IN_ANALYZE: u32 = 4;
pub const PROC_VACUUM_FOR_WRAPAROUND: u32 = 8;
pub const PROC_IN_LOGICAL_DECODING: u32 = 16;
pub const PROC_RESERVED: u32 = 32;
pub const PROC_VACUUM_STATE_MASK: u32 = 14;
pub const FP_LOCK_SLOTS_PER_BACKEND: u32 = 16;
pub const INVALID_PGPROCNO: u32 = 2147483647;
pub const DELAY_CHKPT_START: u32 = 1;
pub const DELAY_CHKPT_COMPLETE: u32 = 2;
pub const NUM_AUXILIARY_PROCS: u32 = 4;
pub const PGSTAT_STAT_PERMANENT_DIRECTORY: &[u8; 8usize] = b"pg_stat\0";
pub const PGSTAT_STAT_PERMANENT_FILENAME: &[u8; 20usize] = b"pg_stat/global.stat\0";
pub const PGSTAT_STAT_PERMANENT_TMPFILE: &[u8; 19usize] = b"pg_stat/global.tmp\0";
pub const PG_STAT_TMP_DIR: &[u8; 12usize] = b"pg_stat_tmp\0";
pub const PGSTAT_MAX_MSG_SIZE: u32 = 1000;
pub const PGSTAT_FILE_FORMAT_ID: u32 = 27638941;
pub const PG_WAIT_LWLOCK: u32 = 16777216;
pub const PG_WAIT_LOCK: u32 = 50331648;
pub const PG_WAIT_BUFFER_PIN: u32 = 67108864;
pub const PG_WAIT_ACTIVITY: u32 = 83886080;
pub const PG_WAIT_CLIENT: u32 = 100663296;
pub const PG_WAIT_EXTENSION: u32 = 117440512;
pub const PG_WAIT_IPC: u32 = 134217728;
pub const PG_WAIT_TIMEOUT: u32 = 150994944;
pub const PG_WAIT_IO: u32 = 167772160;
pub const PGSTAT_NUM_PROGRESS_PARAM: u32 = 20;
pub const SK_ISNULL: u32 = 1;
pub const SK_UNARY: u32 = 2;
pub const SK_ROW_HEADER: u32 = 4;
pub const SK_ROW_MEMBER: u32 = 8;
pub const SK_ROW_END: u32 = 16;
pub const SK_SEARCHARRAY: u32 = 32;
pub const SK_SEARCHNULL: u32 = 64;
pub const SK_SEARCHNOTNULL: u32 = 128;
pub const SK_ORDER_BY: u32 = 256;
pub const GIN_COMPARE_PROC: u32 = 1;
pub const GIN_EXTRACTVALUE_PROC: u32 = 2;
pub const GIN_EXTRACTQUERY_PROC: u32 = 3;
pub const GIN_CONSISTENT_PROC: u32 = 4;
pub const GIN_COMPARE_PARTIAL_PROC: u32 = 5;
pub const GIN_TRICONSISTENT_PROC: u32 = 6;
pub const GINNProcs: u32 = 6;
pub const GIN_SEARCH_MODE_DEFAULT: u32 = 0;
pub const GIN_SEARCH_MODE_INCLUDE_EMPTY: u32 = 1;
pub const GIN_SEARCH_MODE_ALL: u32 = 2;
pub const GIN_SEARCH_MODE_EVERYTHING: u32 = 3;
pub const GIN_FALSE: u32 = 0;
pub const GIN_TRUE: u32 = 1;
pub const GIN_MAYBE: u32 = 2;
pub const XLR_NORMAL_MAX_BLOCK_ID: u32 = 4;
pub const XLR_NORMAL_RDATAS: u32 = 20;
pub const REGBUF_FORCE_IMAGE: u32 = 1;
pub const REGBUF_NO_IMAGE: u32 = 2;
pub const REGBUF_WILL_INIT: u32 = 6;
pub const REGBUF_STANDARD: u32 = 8;
pub const REGBUF_KEEP_DATA: u32 = 16;
pub const SYNC_METHOD_FSYNC: u32 = 0;
pub const SYNC_METHOD_FDATASYNC: u32 = 1;
pub const SYNC_METHOD_OPEN: u32 = 2;
pub const SYNC_METHOD_FSYNC_WRITETHROUGH: u32 = 3;
pub const SYNC_METHOD_OPEN_DSYNC: u32 = 4;
pub const CHECKPOINT_IS_SHUTDOWN: u32 = 1;
pub const CHECKPOINT_END_OF_RECOVERY: u32 = 2;
pub const CHECKPOINT_IMMEDIATE: u32 = 4;
pub const CHECKPOINT_FORCE: u32 = 8;
pub const CHECKPOINT_FLUSH_ALL: u32 = 16;
pub const CHECKPOINT_WAIT: u32 = 32;
pub const CHECKPOINT_REQUESTED: u32 = 64;
pub const CHECKPOINT_CAUSE_XLOG: u32 = 128;
pub const CHECKPOINT_CAUSE_TIME: u32 = 256;
pub const XLOG_INCLUDE_ORIGIN: u32 = 1;
pub const XLOG_MARK_UNIMPORTANT: u32 = 2;
pub const RECOVERY_SIGNAL_FILE: &[u8; 16usize] = b"recovery.signal\0";
pub const STANDBY_SIGNAL_FILE: &[u8; 15usize] = b"standby.signal\0";
pub const BACKUP_LABEL_FILE: &[u8; 13usize] = b"backup_label\0";
pub const BACKUP_LABEL_OLD: &[u8; 17usize] = b"backup_label.old\0";
pub const TABLESPACE_MAP: &[u8; 15usize] = b"tablespace_map\0";
pub const TABLESPACE_MAP_OLD: &[u8; 19usize] = b"tablespace_map.old\0";
pub const PROMOTE_SIGNAL_FILE: &[u8; 8usize] = b"promote\0";
pub const FALLBACK_PROMOTE_SIGNAL_FILE: &[u8; 17usize] = b"fallback_promote\0";
pub const GIST_CONSISTENT_PROC: u32 = 1;
pub const GIST_UNION_PROC: u32 = 2;
pub const GIST_COMPRESS_PROC: u32 = 3;
pub const GIST_DECOMPRESS_PROC: u32 = 4;
pub const GIST_PENALTY_PROC: u32 = 5;
pub const GIST_PICKSPLIT_PROC: u32 = 6;
pub const GIST_EQUAL_PROC: u32 = 7;
pub const GIST_DISTANCE_PROC: u32 = 8;
pub const GIST_FETCH_PROC: u32 = 9;
pub const GISTNProcs: u32 = 9;
pub const F_LEAF: u32 = 1;
pub const F_DELETED: u32 = 2;
pub const F_TUPLES_DELETED: u32 = 4;
pub const F_FOLLOW_RIGHT: u32 = 8;
pub const F_HAS_GARBAGE: u32 = 16;
pub const GIST_PAGE_ID: u32 = 65409;
pub const EOH_HEADER_MAGIC: i32 = -1;
pub const EA_MAGIC: u32 = 689375833;
pub const PG_AUTOCONF_FILENAME: &[u8; 21usize] = b"postgresql.auto.conf\0";
pub const GUC_QUALIFIER_SEPARATOR: u8 = 46u8;
pub const GUC_LIST_INPUT: u32 = 1;
pub const GUC_LIST_QUOTE: u32 = 2;
pub const GUC_NO_SHOW_ALL: u32 = 4;
pub const GUC_NO_RESET_ALL: u32 = 8;
pub const GUC_REPORT: u32 = 16;
pub const GUC_NOT_IN_SAMPLE: u32 = 32;
pub const GUC_DISALLOW_IN_FILE: u32 = 64;
pub const GUC_CUSTOM_PLACEHOLDER: u32 = 128;
pub const GUC_SUPERUSER_ONLY: u32 = 256;
pub const GUC_IS_NAME: u32 = 512;
pub const GUC_NOT_WHILE_SEC_REST: u32 = 1024;
pub const GUC_DISALLOW_IN_AUTO_FILE: u32 = 2048;
pub const GUC_UNIT_KB: u32 = 4096;
pub const GUC_UNIT_BLOCKS: u32 = 8192;
pub const GUC_UNIT_XBLOCKS: u32 = 12288;
pub const GUC_UNIT_MB: u32 = 16384;
pub const GUC_UNIT_BYTE: u32 = 32768;
pub const GUC_UNIT_MEMORY: u32 = 61440;
pub const GUC_UNIT_MS: u32 = 65536;
pub const GUC_UNIT_S: u32 = 131072;
pub const GUC_UNIT_MIN: u32 = 196608;
pub const GUC_UNIT_TIME: u32 = 983040;
pub const GUC_EXPLAIN: u32 = 1048576;
pub const GUC_UNIT: u32 = 1044480;
pub const RelationRelationId: u32 = 1259;
pub const RelationRelation_Rowtype_Id: u32 = 83;
pub const Anum_pg_class_oid: u32 = 1;
pub const Anum_pg_class_relname: u32 = 2;
pub const Anum_pg_class_relnamespace: u32 = 3;
pub const Anum_pg_class_reltype: u32 = 4;
pub const Anum_pg_class_reloftype: u32 = 5;
pub const Anum_pg_class_relowner: u32 = 6;
pub const Anum_pg_class_relam: u32 = 7;
pub const Anum_pg_class_relfilenode: u32 = 8;
pub const Anum_pg_class_reltablespace: u32 = 9;
pub const Anum_pg_class_relpages: u32 = 10;
pub const Anum_pg_class_reltuples: u32 = 11;
pub const Anum_pg_class_relallvisible: u32 = 12;
pub const Anum_pg_class_reltoastrelid: u32 = 13;
pub const Anum_pg_class_relhasindex: u32 = 14;
pub const Anum_pg_class_relisshared: u32 = 15;
pub const Anum_pg_class_relpersistence: u32 = 16;
pub const Anum_pg_class_relkind: u32 = 17;
pub const Anum_pg_class_relnatts: u32 = 18;
pub const Anum_pg_class_relchecks: u32 = 19;
pub const Anum_pg_class_relhasrules: u32 = 20;
pub const Anum_pg_class_relhastriggers: u32 = 21;
pub const Anum_pg_class_relhassubclass: u32 = 22;
pub const Anum_pg_class_relrowsecurity: u32 = 23;
pub const Anum_pg_class_relforcerowsecurity: u32 = 24;
pub const Anum_pg_class_relispopulated: u32 = 25;
pub const Anum_pg_class_relreplident: u32 = 26;
pub const Anum_pg_class_relispartition: u32 = 27;
pub const Anum_pg_class_relrewrite: u32 = 28;
pub const Anum_pg_class_relfrozenxid: u32 = 29;
pub const Anum_pg_class_relminmxid: u32 = 30;
pub const Anum_pg_class_relacl: u32 = 31;
pub const Anum_pg_class_reloptions: u32 = 32;
pub const Anum_pg_class_relpartbound: u32 = 33;
pub const Natts_pg_class: u32 = 33;
pub const RELKIND_RELATION: u8 = 114u8;
pub const RELKIND_INDEX: u8 = 105u8;
pub const RELKIND_SEQUENCE: u8 = 83u8;
pub const RELKIND_TOASTVALUE: u8 = 116u8;
pub const RELKIND_VIEW: u8 = 118u8;
pub const RELKIND_MATVIEW: u8 = 109u8;
pub const RELKIND_COMPOSITE_TYPE: u8 = 99u8;
pub const RELKIND_FOREIGN_TABLE: u8 = 102u8;
pub const RELKIND_PARTITIONED_TABLE: u8 = 112u8;
pub const RELKIND_PARTITIONED_INDEX: u8 = 73u8;
pub const RELPERSISTENCE_PERMANENT: u8 = 112u8;
pub const RELPERSISTENCE_UNLOGGED: u8 = 117u8;
pub const RELPERSISTENCE_TEMP: u8 = 116u8;
pub const REPLICA_IDENTITY_DEFAULT: u8 = 100u8;
pub const REPLICA_IDENTITY_NOTHING: u8 = 110u8;
pub const REPLICA_IDENTITY_FULL: u8 = 102u8;
pub const REPLICA_IDENTITY_INDEX: u8 = 105u8;
pub const IndexRelationId: u32 = 2610;
pub const Anum_pg_index_indexrelid: u32 = 1;
pub const Anum_pg_index_indrelid: u32 = 2;
pub const Anum_pg_index_indnatts: u32 = 3;
pub const Anum_pg_index_indnkeyatts: u32 = 4;
pub const Anum_pg_index_indisunique: u32 = 5;
pub const Anum_pg_index_indisprimary: u32 = 6;
pub const Anum_pg_index_indisexclusion: u32 = 7;
pub const Anum_pg_index_indimmediate: u32 = 8;
pub const Anum_pg_index_indisclustered: u32 = 9;
pub const Anum_pg_index_indisvalid: u32 = 10;
pub const Anum_pg_index_indcheckxmin: u32 = 11;
pub const Anum_pg_index_indisready: u32 = 12;
pub const Anum_pg_index_indislive: u32 = 13;
pub const Anum_pg_index_indisreplident: u32 = 14;
pub const Anum_pg_index_indkey: u32 = 15;
pub const Anum_pg_index_indcollation: u32 = 16;
pub const Anum_pg_index_indclass: u32 = 17;
pub const Anum_pg_index_indoption: u32 = 18;
pub const Anum_pg_index_indexprs: u32 = 19;
pub const Anum_pg_index_indpred: u32 = 20;
pub const Natts_pg_index: u32 = 20;
pub const INDOPTION_DESC: u32 = 1;
pub const INDOPTION_NULLS_FIRST: u32 = 2;
pub const PublicationRelationId: u32 = 6104;
pub const Anum_pg_publication_oid: u32 = 1;
pub const Anum_pg_publication_pubname: u32 = 2;
pub const Anum_pg_publication_pubowner: u32 = 3;
pub const Anum_pg_publication_puballtables: u32 = 4;
pub const Anum_pg_publication_pubinsert: u32 = 5;
pub const Anum_pg_publication_pubupdate: u32 = 6;
pub const Anum_pg_publication_pubdelete: u32 = 7;
pub const Anum_pg_publication_pubtruncate: u32 = 8;
pub const Natts_pg_publication: u32 = 8;
pub const ACL_ID_PUBLIC: u32 = 0;
pub const ACL_MODECHG_ADD: u32 = 1;
pub const ACL_MODECHG_DEL: u32 = 2;
pub const ACL_MODECHG_EQL: u32 = 3;
pub const ACL_INSERT_CHR: u8 = 97u8;
pub const ACL_SELECT_CHR: u8 = 114u8;
pub const ACL_UPDATE_CHR: u8 = 119u8;
pub const ACL_DELETE_CHR: u8 = 100u8;
pub const ACL_TRUNCATE_CHR: u8 = 68u8;
pub const ACL_REFERENCES_CHR: u8 = 120u8;
pub const ACL_TRIGGER_CHR: u8 = 116u8;
pub const ACL_EXECUTE_CHR: u8 = 88u8;
pub const ACL_USAGE_CHR: u8 = 85u8;
pub const ACL_CREATE_CHR: u8 = 67u8;
pub const ACL_CREATE_TEMP_CHR: u8 = 84u8;
pub const ACL_CONNECT_CHR: u8 = 99u8;
pub const ACL_ALL_RIGHTS_STR: &[u8; 13usize] = b"arwdDxtXUCTc\0";
pub const ACL_ALL_RIGHTS_COLUMN: u32 = 39;
pub const ACL_ALL_RIGHTS_RELATION: u32 = 127;
pub const ACL_ALL_RIGHTS_SEQUENCE: u32 = 262;
pub const ACL_ALL_RIGHTS_DATABASE: u32 = 3584;
pub const ACL_ALL_RIGHTS_FDW: u32 = 256;
pub const ACL_ALL_RIGHTS_FOREIGN_SERVER: u32 = 256;
pub const ACL_ALL_RIGHTS_FUNCTION: u32 = 128;
pub const ACL_ALL_RIGHTS_LANGUAGE: u32 = 256;
pub const ACL_ALL_RIGHTS_LARGEOBJECT: u32 = 6;
pub const ACL_ALL_RIGHTS_SCHEMA: u32 = 768;
pub const ACL_ALL_RIGHTS_TABLESPACE: u32 = 512;
pub const ACL_ALL_RIGHTS_TYPE: u32 = 256;
pub const HEAP_MIN_FILLFACTOR: u32 = 10;
pub const HEAP_DEFAULT_FILLFACTOR: u32 = 100;
pub const DEFAULT_TABLE_ACCESS_METHOD: &[u8; 5usize] = b"heap\0";
pub const TABLE_INSERT_SKIP_WAL: u32 = 1;
pub const TABLE_INSERT_SKIP_FSM: u32 = 2;
pub const TABLE_INSERT_FROZEN: u32 = 4;
pub const TABLE_INSERT_NO_LOGICAL: u32 = 8;
pub const TUPLE_LOCK_FLAG_LOCK_UPDATE_IN_PROGRESS: u32 = 1;
pub const TUPLE_LOCK_FLAG_FIND_LAST_VERSION: u32 = 2;
pub const HEAP_INSERT_SKIP_WAL: u32 = 1;
pub const HEAP_INSERT_SKIP_FSM: u32 = 2;
pub const HEAP_INSERT_FROZEN: u32 = 4;
pub const HEAP_INSERT_NO_LOGICAL: u32 = 8;
pub const HEAP_INSERT_SPECULATIVE: u32 = 16;
pub const SHAREDINVALCATALOG_ID: i32 = -1;
pub const SHAREDINVALRELCACHE_ID: i32 = -2;
pub const SHAREDINVALSMGR_ID: i32 = -3;
pub const SHAREDINVALRELMAP_ID: i32 = -4;
pub const SHAREDINVALSNAPSHOT_ID: i32 = -5;
pub const INTERVAL_FULL_RANGE: u32 = 32767;
pub const INTERVAL_RANGE_MASK: u32 = 32767;
pub const INTERVAL_FULL_PRECISION: u32 = 65535;
pub const INTERVAL_PRECISION_MASK: u32 = 65535;
pub const DAGO: &[u8; 4usize] = b"ago\0";
pub const DCURRENT: &[u8; 8usize] = b"current\0";
pub const EPOCH: &[u8; 6usize] = b"epoch\0";
pub const INVALID: &[u8; 8usize] = b"invalid\0";
pub const EARLY: &[u8; 10usize] = b"-infinity\0";
pub const LATE: &[u8; 9usize] = b"infinity\0";
pub const NOW: &[u8; 4usize] = b"now\0";
pub const TODAY: &[u8; 6usize] = b"today\0";
pub const TOMORROW: &[u8; 9usize] = b"tomorrow\0";
pub const YESTERDAY: &[u8; 10usize] = b"yesterday\0";
pub const ZULU: &[u8; 5usize] = b"zulu\0";
pub const DMICROSEC: &[u8; 8usize] = b"usecond\0";
pub const DMILLISEC: &[u8; 8usize] = b"msecond\0";
pub const DSECOND: &[u8; 7usize] = b"second\0";
pub const DMINUTE: &[u8; 7usize] = b"minute\0";
pub const DHOUR: &[u8; 5usize] = b"hour\0";
pub const DDAY: &[u8; 4usize] = b"day\0";
pub const DWEEK: &[u8; 5usize] = b"week\0";
pub const DMONTH: &[u8; 6usize] = b"month\0";
pub const DQUARTER: &[u8; 8usize] = b"quarter\0";
pub const DYEAR: &[u8; 5usize] = b"year\0";
pub const DDECADE: &[u8; 7usize] = b"decade\0";
pub const DCENTURY: &[u8; 8usize] = b"century\0";
pub const DMILLENNIUM: &[u8; 11usize] = b"millennium\0";
pub const DA_D: &[u8; 3usize] = b"ad\0";
pub const DB_C: &[u8; 3usize] = b"bc\0";
pub const DTIMEZONE: &[u8; 9usize] = b"timezone\0";
pub const AM: u32 = 0;
pub const PM: u32 = 1;
pub const HR24: u32 = 2;
pub const AD: u32 = 0;
pub const BC: u32 = 1;
pub const RESERV: u32 = 0;
pub const MONTH: u32 = 1;
pub const YEAR: u32 = 2;
pub const DAY: u32 = 3;
pub const JULIAN: u32 = 4;
pub const TZ: u32 = 5;
pub const DTZ: u32 = 6;
pub const DYNTZ: u32 = 7;
pub const IGNORE_DTF: u32 = 8;
pub const AMPM: u32 = 9;
pub const HOUR: u32 = 10;
pub const MINUTE: u32 = 11;
pub const SECOND: u32 = 12;
pub const MILLISECOND: u32 = 13;
pub const MICROSECOND: u32 = 14;
pub const DOY: u32 = 15;
pub const DOW: u32 = 16;
pub const UNITS: u32 = 17;
pub const ADBC: u32 = 18;
pub const AGO: u32 = 19;
pub const ABS_BEFORE: u32 = 20;
pub const ABS_AFTER: u32 = 21;
pub const ISODATE: u32 = 22;
pub const ISOTIME: u32 = 23;
pub const WEEK: u32 = 24;
pub const DECADE: u32 = 25;
pub const CENTURY: u32 = 26;
pub const MILLENNIUM: u32 = 27;
pub const DTZMOD: u32 = 28;
pub const UNKNOWN_FIELD: u32 = 31;
pub const DTK_NUMBER: u32 = 0;
pub const DTK_STRING: u32 = 1;
pub const DTK_DATE: u32 = 2;
pub const DTK_TIME: u32 = 3;
pub const DTK_TZ: u32 = 4;
pub const DTK_AGO: u32 = 5;
pub const DTK_SPECIAL: u32 = 6;
pub const DTK_EARLY: u32 = 9;
pub const DTK_LATE: u32 = 10;
pub const DTK_EPOCH: u32 = 11;
pub const DTK_NOW: u32 = 12;
pub const DTK_YESTERDAY: u32 = 13;
pub const DTK_TODAY: u32 = 14;
pub const DTK_TOMORROW: u32 = 15;
pub const DTK_ZULU: u32 = 16;
pub const DTK_DELTA: u32 = 17;
pub const DTK_SECOND: u32 = 18;
pub const DTK_MINUTE: u32 = 19;
pub const DTK_HOUR: u32 = 20;
pub const DTK_DAY: u32 = 21;
pub const DTK_WEEK: u32 = 22;
pub const DTK_MONTH: u32 = 23;
pub const DTK_QUARTER: u32 = 24;
pub const DTK_YEAR: u32 = 25;
pub const DTK_DECADE: u32 = 26;
pub const DTK_CENTURY: u32 = 27;
pub const DTK_MILLENNIUM: u32 = 28;
pub const DTK_MILLISEC: u32 = 29;
pub const DTK_MICROSEC: u32 = 30;
pub const DTK_JULIAN: u32 = 31;
pub const DTK_DOW: u32 = 32;
pub const DTK_DOY: u32 = 33;
pub const DTK_TZ_HOUR: u32 = 34;
pub const DTK_TZ_MINUTE: u32 = 35;
pub const DTK_ISOYEAR: u32 = 36;
pub const DTK_ISODOW: u32 = 37;
pub const MAXDATELEN: u32 = 128;
pub const MAXDATEFIELDS: u32 = 25;
pub const TOKMAXLEN: u32 = 10;
pub const DTERR_BAD_FORMAT: i32 = -1;
pub const DTERR_FIELD_OVERFLOW: i32 = -2;
pub const DTERR_MD_FIELD_OVERFLOW: i32 = -3;
pub const DTERR_INTERVAL_OVERFLOW: i32 = -4;
pub const DTERR_TZDISP_OVERFLOW: i32 = -5;
pub const GIDSIZE: u32 = 200;
pub const XACT_READ_UNCOMMITTED: u32 = 0;
pub const XACT_READ_COMMITTED: u32 = 1;
pub const XACT_REPEATABLE_READ: u32 = 2;
pub const XACT_SERIALIZABLE: u32 = 3;
pub const XACT_FLAGS_ACCESSEDTEMPNAMESPACE: u32 = 1;
pub const XACT_FLAGS_ACQUIREDACCESSEXCLUSIVELOCK: u32 = 2;
pub const XACT_FLAGS_NEEDIMMEDIATECOMMIT: u32 = 4;
pub const XLOG_XACT_COMMIT: u32 = 0;
pub const XLOG_XACT_PREPARE: u32 = 16;
pub const XLOG_XACT_ABORT: u32 = 32;
pub const XLOG_XACT_COMMIT_PREPARED: u32 = 48;
pub const XLOG_XACT_ABORT_PREPARED: u32 = 64;
pub const XLOG_XACT_ASSIGNMENT: u32 = 80;
pub const XLOG_XACT_OPMASK: u32 = 112;
pub const XLOG_XACT_HAS_INFO: u32 = 128;
pub const XACT_XINFO_HAS_DBINFO: u32 = 1;
pub const XACT_XINFO_HAS_SUBXACTS: u32 = 2;
pub const XACT_XINFO_HAS_RELFILENODES: u32 = 4;
pub const XACT_XINFO_HAS_INVALS: u32 = 8;
pub const XACT_XINFO_HAS_TWOPHASE: u32 = 16;
pub const XACT_XINFO_HAS_ORIGIN: u32 = 32;
pub const XACT_XINFO_HAS_AE_LOCKS: u32 = 64;
pub const XACT_XINFO_HAS_GID: u32 = 128;
pub const XACT_COMPLETION_APPLY_FEEDBACK: u32 = 536870912;
pub const XACT_COMPLETION_UPDATE_RELCACHE_FILE: u32 = 1073741824;
pub const XACT_COMPLETION_FORCE_SYNC_COMMIT: u32 = 2147483648;
pub const PERFORM_DELETION_INTERNAL: u32 = 1;
pub const PERFORM_DELETION_CONCURRENTLY: u32 = 2;
pub const PERFORM_DELETION_QUIETLY: u32 = 4;
pub const PERFORM_DELETION_SKIP_ORIGINAL: u32 = 8;
pub const PERFORM_DELETION_SKIP_EXTENSIONS: u32 = 16;
pub const PERFORM_DELETION_CONCURRENT_LOCK: u32 = 32;
pub const DEFAULT_INDEX_TYPE: &[u8; 6usize] = b"btree\0";
pub const INDEX_CREATE_IS_PRIMARY: u32 = 1;
pub const INDEX_CREATE_ADD_CONSTRAINT: u32 = 2;
pub const INDEX_CREATE_SKIP_BUILD: u32 = 4;
pub const INDEX_CREATE_CONCURRENT: u32 = 8;
pub const INDEX_CREATE_IF_NOT_EXISTS: u32 = 16;
pub const INDEX_CREATE_PARTITIONED: u32 = 32;
pub const INDEX_CREATE_INVALID: u32 = 64;
pub const INDEX_CONSTR_CREATE_MARK_AS_PRIMARY: u32 = 1;
pub const INDEX_CONSTR_CREATE_DEFERRABLE: u32 = 2;
pub const INDEX_CONSTR_CREATE_INIT_DEFERRED: u32 = 4;
pub const INDEX_CONSTR_CREATE_UPDATE_INDEX: u32 = 8;
pub const INDEX_CONSTR_CREATE_REMOVE_OLD_DEPS: u32 = 16;
pub const REINDEX_REL_PROCESS_TOAST: u32 = 1;
pub const REINDEX_REL_SUPPRESS_INDEX_USE: u32 = 2;
pub const REINDEX_REL_CHECK_CONSTRAINTS: u32 = 4;
pub const REINDEX_REL_FORCE_INDEXES_UNLOGGED: u32 = 8;
pub const REINDEX_REL_FORCE_INDEXES_PERMANENT: u32 = 16;
pub const AuthIdRelationId: u32 = 1260;
pub const AuthIdRelation_Rowtype_Id: u32 = 2842;
pub const Anum_pg_authid_oid: u32 = 1;
pub const Anum_pg_authid_rolname: u32 = 2;
pub const Anum_pg_authid_rolsuper: u32 = 3;
pub const Anum_pg_authid_rolinherit: u32 = 4;
pub const Anum_pg_authid_rolcreaterole: u32 = 5;
pub const Anum_pg_authid_rolcreatedb: u32 = 6;
pub const Anum_pg_authid_rolcanlogin: u32 = 7;
pub const Anum_pg_authid_rolreplication: u32 = 8;
pub const Anum_pg_authid_rolbypassrls: u32 = 9;
pub const Anum_pg_authid_rolconnlimit: u32 = 10;
pub const Anum_pg_authid_rolpassword: u32 = 11;
pub const Anum_pg_authid_rolvaliduntil: u32 = 12;
pub const Natts_pg_authid: u32 = 12;
pub const BOOTSTRAP_SUPERUSERID: u32 = 10;
pub const DEFAULT_ROLE_MONITOR: u32 = 3373;
pub const DEFAULT_ROLE_READ_ALL_SETTINGS: u32 = 3374;
pub const DEFAULT_ROLE_READ_ALL_STATS: u32 = 3375;
pub const DEFAULT_ROLE_STAT_SCAN_TABLES: u32 = 3377;
pub const DEFAULT_ROLE_READ_SERVER_FILES: u32 = 4569;
pub const DEFAULT_ROLE_WRITE_SERVER_FILES: u32 = 4570;
pub const DEFAULT_ROLE_EXECUTE_SERVER_PROGRAM: u32 = 4571;
pub const DEFAULT_ROLE_SIGNAL_BACKENDID: u32 = 4200;
pub const EnumRelationId: u32 = 3501;
pub const Anum_pg_enum_oid: u32 = 1;
pub const Anum_pg_enum_enumtypid: u32 = 2;
pub const Anum_pg_enum_enumsortorder: u32 = 3;
pub const Anum_pg_enum_enumlabel: u32 = 4;
pub const Natts_pg_enum: u32 = 4;
pub const OperatorRelationId: u32 = 2617;
pub const Anum_pg_operator_oid: u32 = 1;
pub const Anum_pg_operator_oprname: u32 = 2;
pub const Anum_pg_operator_oprnamespace: u32 = 3;
pub const Anum_pg_operator_oprowner: u32 = 4;
pub const Anum_pg_operator_oprkind: u32 = 5;
pub const Anum_pg_operator_oprcanmerge: u32 = 6;
pub const Anum_pg_operator_oprcanhash: u32 = 7;
pub const Anum_pg_operator_oprleft: u32 = 8;
pub const Anum_pg_operator_oprright: u32 = 9;
pub const Anum_pg_operator_oprresult: u32 = 10;
pub const Anum_pg_operator_oprcom: u32 = 11;
pub const Anum_pg_operator_oprnegate: u32 = 12;
pub const Anum_pg_operator_oprcode: u32 = 13;
pub const Anum_pg_operator_oprrest: u32 = 14;
pub const Anum_pg_operator_oprjoin: u32 = 15;
pub const Natts_pg_operator: u32 = 15;
pub const BooleanNotEqualOperator: u32 = 85;
pub const BooleanEqualOperator: u32 = 91;
pub const Int4EqualOperator: u32 = 96;
pub const Int4LessOperator: u32 = 97;
pub const TextEqualOperator: u32 = 98;
pub const TIDEqualOperator: u32 = 387;
pub const TIDLessOperator: u32 = 2799;
pub const Int8LessOperator: u32 = 412;
pub const OID_NAME_REGEXEQ_OP: u32 = 639;
pub const OID_TEXT_REGEXEQ_OP: u32 = 641;
pub const Float8LessOperator: u32 = 672;
pub const OID_BPCHAR_REGEXEQ_OP: u32 = 1055;
pub const ARRAY_EQ_OP: u32 = 1070;
pub const ARRAY_LT_OP: u32 = 1072;
pub const ARRAY_GT_OP: u32 = 1073;
pub const OID_NAME_LIKE_OP: u32 = 1207;
pub const OID_TEXT_LIKE_OP: u32 = 1209;
pub const OID_BPCHAR_LIKE_OP: u32 = 1211;
pub const OID_NAME_ICREGEXEQ_OP: u32 = 1226;
pub const OID_TEXT_ICREGEXEQ_OP: u32 = 1228;
pub const OID_BPCHAR_ICREGEXEQ_OP: u32 = 1234;
pub const OID_INET_SUB_OP: u32 = 931;
pub const OID_INET_SUBEQ_OP: u32 = 932;
pub const OID_INET_SUP_OP: u32 = 933;
pub const OID_INET_SUPEQ_OP: u32 = 934;
pub const OID_INET_OVERLAP_OP: u32 = 3552;
pub const OID_NAME_ICLIKE_OP: u32 = 1625;
pub const OID_TEXT_ICLIKE_OP: u32 = 1627;
pub const OID_BPCHAR_ICLIKE_OP: u32 = 1629;
pub const OID_BYTEA_LIKE_OP: u32 = 2016;
pub const OID_ARRAY_OVERLAP_OP: u32 = 2750;
pub const OID_ARRAY_CONTAINS_OP: u32 = 2751;
pub const OID_ARRAY_CONTAINED_OP: u32 = 2752;
pub const RECORD_EQ_OP: u32 = 2988;
pub const RECORD_LT_OP: u32 = 2990;
pub const RECORD_GT_OP: u32 = 2991;
pub const OID_RANGE_LESS_OP: u32 = 3884;
pub const OID_RANGE_LESS_EQUAL_OP: u32 = 3885;
pub const OID_RANGE_GREATER_EQUAL_OP: u32 = 3886;
pub const OID_RANGE_GREATER_OP: u32 = 3887;
pub const OID_RANGE_OVERLAP_OP: u32 = 3888;
pub const OID_RANGE_CONTAINS_ELEM_OP: u32 = 3889;
pub const OID_RANGE_CONTAINS_OP: u32 = 3890;
pub const OID_RANGE_ELEM_CONTAINED_OP: u32 = 3891;
pub const OID_RANGE_CONTAINED_OP: u32 = 3892;
pub const OID_RANGE_LEFT_OP: u32 = 3893;
pub const OID_RANGE_RIGHT_OP: u32 = 3894;
pub const OID_RANGE_OVERLAPS_LEFT_OP: u32 = 3895;
pub const OID_RANGE_OVERLAPS_RIGHT_OP: u32 = 3896;
pub const ProcedureRelationId: u32 = 1255;
pub const ProcedureRelation_Rowtype_Id: u32 = 81;
pub const Anum_pg_proc_oid: u32 = 1;
pub const Anum_pg_proc_proname: u32 = 2;
pub const Anum_pg_proc_pronamespace: u32 = 3;
pub const Anum_pg_proc_proowner: u32 = 4;
pub const Anum_pg_proc_prolang: u32 = 5;
pub const Anum_pg_proc_procost: u32 = 6;
pub const Anum_pg_proc_prorows: u32 = 7;
pub const Anum_pg_proc_provariadic: u32 = 8;
pub const Anum_pg_proc_prosupport: u32 = 9;
pub const Anum_pg_proc_prokind: u32 = 10;
pub const Anum_pg_proc_prosecdef: u32 = 11;
pub const Anum_pg_proc_proleakproof: u32 = 12;
pub const Anum_pg_proc_proisstrict: u32 = 13;
pub const Anum_pg_proc_proretset: u32 = 14;
pub const Anum_pg_proc_provolatile: u32 = 15;
pub const Anum_pg_proc_proparallel: u32 = 16;
pub const Anum_pg_proc_pronargs: u32 = 17;
pub const Anum_pg_proc_pronargdefaults: u32 = 18;
pub const Anum_pg_proc_prorettype: u32 = 19;
pub const Anum_pg_proc_proargtypes: u32 = 20;
pub const Anum_pg_proc_proallargtypes: u32 = 21;
pub const Anum_pg_proc_proargmodes: u32 = 22;
pub const Anum_pg_proc_proargnames: u32 = 23;
pub const Anum_pg_proc_proargdefaults: u32 = 24;
pub const Anum_pg_proc_protrftypes: u32 = 25;
pub const Anum_pg_proc_prosrc: u32 = 26;
pub const Anum_pg_proc_probin: u32 = 27;
pub const Anum_pg_proc_proconfig: u32 = 28;
pub const Anum_pg_proc_proacl: u32 = 29;
pub const Natts_pg_proc: u32 = 29;
pub const PROKIND_FUNCTION: u8 = 102u8;
pub const PROKIND_AGGREGATE: u8 = 97u8;
pub const PROKIND_WINDOW: u8 = 119u8;
pub const PROKIND_PROCEDURE: u8 = 112u8;
pub const PROVOLATILE_IMMUTABLE: u8 = 105u8;
pub const PROVOLATILE_STABLE: u8 = 115u8;
pub const PROVOLATILE_VOLATILE: u8 = 118u8;
pub const PROPARALLEL_SAFE: u8 = 115u8;
pub const PROPARALLEL_RESTRICTED: u8 = 114u8;
pub const PROPARALLEL_UNSAFE: u8 = 117u8;
pub const PROARGMODE_IN: u8 = 105u8;
pub const PROARGMODE_OUT: u8 = 111u8;
pub const PROARGMODE_INOUT: u8 = 98u8;
pub const PROARGMODE_VARIADIC: u8 = 118u8;
pub const PROARGMODE_TABLE: u8 = 116u8;
pub const HEAP_TABLE_AM_HANDLER_OID: u32 = 3;
pub const TriggerRelationId: u32 = 2620;
pub const Anum_pg_trigger_oid: u32 = 1;
pub const Anum_pg_trigger_tgrelid: u32 = 2;
pub const Anum_pg_trigger_tgname: u32 = 3;
pub const Anum_pg_trigger_tgfoid: u32 = 4;
pub const Anum_pg_trigger_tgtype: u32 = 5;
pub const Anum_pg_trigger_tgenabled: u32 = 6;
pub const Anum_pg_trigger_tgisinternal: u32 = 7;
pub const Anum_pg_trigger_tgconstrrelid: u32 = 8;
pub const Anum_pg_trigger_tgconstrindid: u32 = 9;
pub const Anum_pg_trigger_tgconstraint: u32 = 10;
pub const Anum_pg_trigger_tgdeferrable: u32 = 11;
pub const Anum_pg_trigger_tginitdeferred: u32 = 12;
pub const Anum_pg_trigger_tgnargs: u32 = 13;
pub const Anum_pg_trigger_tgattr: u32 = 14;
pub const Anum_pg_trigger_tgargs: u32 = 15;
pub const Anum_pg_trigger_tgqual: u32 = 16;
pub const Anum_pg_trigger_tgoldtable: u32 = 17;
pub const Anum_pg_trigger_tgnewtable: u32 = 18;
pub const Natts_pg_trigger: u32 = 18;
pub const TRIGGER_TYPE_ROW: u32 = 1;
pub const TRIGGER_TYPE_BEFORE: u32 = 2;
pub const TRIGGER_TYPE_INSERT: u32 = 4;
pub const TRIGGER_TYPE_DELETE: u32 = 8;
pub const TRIGGER_TYPE_UPDATE: u32 = 16;
pub const TRIGGER_TYPE_TRUNCATE: u32 = 32;
pub const TRIGGER_TYPE_INSTEAD: u32 = 64;
pub const TRIGGER_TYPE_LEVEL_MASK: u32 = 1;
pub const TRIGGER_TYPE_STATEMENT: u32 = 0;
pub const TRIGGER_TYPE_TIMING_MASK: u32 = 66;
pub const TRIGGER_TYPE_AFTER: u32 = 0;
pub const TRIGGER_TYPE_EVENT_MASK: u32 = 60;
pub const TypeRelationId: u32 = 1247;
pub const TypeRelation_Rowtype_Id: u32 = 71;
pub const Anum_pg_type_oid: u32 = 1;
pub const Anum_pg_type_typname: u32 = 2;
pub const Anum_pg_type_typnamespace: u32 = 3;
pub const Anum_pg_type_typowner: u32 = 4;
pub const Anum_pg_type_typlen: u32 = 5;
pub const Anum_pg_type_typbyval: u32 = 6;
pub const Anum_pg_type_typtype: u32 = 7;
pub const Anum_pg_type_typcategory: u32 = 8;
pub const Anum_pg_type_typispreferred: u32 = 9;
pub const Anum_pg_type_typisdefined: u32 = 10;
pub const Anum_pg_type_typdelim: u32 = 11;
pub const Anum_pg_type_typrelid: u32 = 12;
pub const Anum_pg_type_typelem: u32 = 13;
pub const Anum_pg_type_typarray: u32 = 14;
pub const Anum_pg_type_typinput: u32 = 15;
pub const Anum_pg_type_typoutput: u32 = 16;
pub const Anum_pg_type_typreceive: u32 = 17;
pub const Anum_pg_type_typsend: u32 = 18;
pub const Anum_pg_type_typmodin: u32 = 19;
pub const Anum_pg_type_typmodout: u32 = 20;
pub const Anum_pg_type_typanalyze: u32 = 21;
pub const Anum_pg_type_typalign: u32 = 22;
pub const Anum_pg_type_typstorage: u32 = 23;
pub const Anum_pg_type_typnotnull: u32 = 24;
pub const Anum_pg_type_typbasetype: u32 = 25;
pub const Anum_pg_type_typtypmod: u32 = 26;
pub const Anum_pg_type_typndims: u32 = 27;
pub const Anum_pg_type_typcollation: u32 = 28;
pub const Anum_pg_type_typdefaultbin: u32 = 29;
pub const Anum_pg_type_typdefault: u32 = 30;
pub const Anum_pg_type_typacl: u32 = 31;
pub const Natts_pg_type: u32 = 31;
pub const TYPTYPE_BASE: u8 = 98u8;
pub const TYPTYPE_COMPOSITE: u8 = 99u8;
pub const TYPTYPE_DOMAIN: u8 = 100u8;
pub const TYPTYPE_ENUM: u8 = 101u8;
pub const TYPTYPE_PSEUDO: u8 = 112u8;
pub const TYPTYPE_RANGE: u8 = 114u8;
pub const TYPCATEGORY_INVALID: u8 = 0u8;
pub const TYPCATEGORY_ARRAY: u8 = 65u8;
pub const TYPCATEGORY_BOOLEAN: u8 = 66u8;
pub const TYPCATEGORY_COMPOSITE: u8 = 67u8;
pub const TYPCATEGORY_DATETIME: u8 = 68u8;
pub const TYPCATEGORY_ENUM: u8 = 69u8;
pub const TYPCATEGORY_GEOMETRIC: u8 = 71u8;
pub const TYPCATEGORY_NETWORK: u8 = 73u8;
pub const TYPCATEGORY_NUMERIC: u8 = 78u8;
pub const TYPCATEGORY_PSEUDOTYPE: u8 = 80u8;
pub const TYPCATEGORY_RANGE: u8 = 82u8;
pub const TYPCATEGORY_STRING: u8 = 83u8;
pub const TYPCATEGORY_TIMESPAN: u8 = 84u8;
pub const TYPCATEGORY_USER: u8 = 85u8;
pub const TYPCATEGORY_BITSTRING: u8 = 86u8;
pub const TYPCATEGORY_UNKNOWN: u8 = 88u8;
pub const BOOLOID: u32 = 16;
pub const BYTEAOID: u32 = 17;
pub const CHAROID: u32 = 18;
pub const NAMEOID: u32 = 19;
pub const INT8OID: u32 = 20;
pub const INT2OID: u32 = 21;
pub const INT2VECTOROID: u32 = 22;
pub const INT4OID: u32 = 23;
pub const REGPROCOID: u32 = 24;
pub const TEXTOID: u32 = 25;
pub const OIDOID: u32 = 26;
pub const TIDOID: u32 = 27;
pub const XIDOID: u32 = 28;
pub const CIDOID: u32 = 29;
pub const OIDVECTOROID: u32 = 30;
pub const JSONOID: u32 = 114;
pub const XMLOID: u32 = 142;
pub const PGNODETREEOID: u32 = 194;
pub const PGNDISTINCTOID: u32 = 3361;
pub const PGDEPENDENCIESOID: u32 = 3402;
pub const PGMCVLISTOID: u32 = 5017;
pub const PGDDLCOMMANDOID: u32 = 32;
pub const POINTOID: u32 = 600;
pub const LSEGOID: u32 = 601;
pub const PATHOID: u32 = 602;
pub const BOXOID: u32 = 603;
pub const POLYGONOID: u32 = 604;
pub const LINEOID: u32 = 628;
pub const FLOAT4OID: u32 = 700;
pub const FLOAT8OID: u32 = 701;
pub const UNKNOWNOID: u32 = 705;
pub const CIRCLEOID: u32 = 718;
pub const CASHOID: u32 = 790;
pub const MACADDROID: u32 = 829;
pub const INETOID: u32 = 869;
pub const CIDROID: u32 = 650;
pub const MACADDR8OID: u32 = 774;
pub const ACLITEMOID: u32 = 1033;
pub const BPCHAROID: u32 = 1042;
pub const VARCHAROID: u32 = 1043;
pub const DATEOID: u32 = 1082;
pub const TIMEOID: u32 = 1083;
pub const TIMESTAMPOID: u32 = 1114;
pub const TIMESTAMPTZOID: u32 = 1184;
pub const INTERVALOID: u32 = 1186;
pub const TIMETZOID: u32 = 1266;
pub const BITOID: u32 = 1560;
pub const VARBITOID: u32 = 1562;
pub const NUMERICOID: u32 = 1700;
pub const REFCURSOROID: u32 = 1790;
pub const REGPROCEDUREOID: u32 = 2202;
pub const REGOPEROID: u32 = 2203;
pub const REGOPERATOROID: u32 = 2204;
pub const REGCLASSOID: u32 = 2205;
pub const REGTYPEOID: u32 = 2206;
pub const REGROLEOID: u32 = 4096;
pub const REGNAMESPACEOID: u32 = 4089;
pub const UUIDOID: u32 = 2950;
pub const LSNOID: u32 = 3220;
pub const TSVECTOROID: u32 = 3614;
pub const GTSVECTOROID: u32 = 3642;
pub const TSQUERYOID: u32 = 3615;
pub const REGCONFIGOID: u32 = 3734;
pub const REGDICTIONARYOID: u32 = 3769;
pub const JSONBOID: u32 = 3802;
pub const JSONPATHOID: u32 = 4072;
pub const TXID_SNAPSHOTOID: u32 = 2970;
pub const INT4RANGEOID: u32 = 3904;
pub const NUMRANGEOID: u32 = 3906;
pub const TSRANGEOID: u32 = 3908;
pub const TSTZRANGEOID: u32 = 3910;
pub const DATERANGEOID: u32 = 3912;
pub const INT8RANGEOID: u32 = 3926;
pub const RECORDOID: u32 = 2249;
pub const RECORDARRAYOID: u32 = 2287;
pub const CSTRINGOID: u32 = 2275;
pub const ANYOID: u32 = 2276;
pub const ANYARRAYOID: u32 = 2277;
pub const VOIDOID: u32 = 2278;
pub const TRIGGEROID: u32 = 2279;
pub const EVTTRIGGEROID: u32 = 3838;
pub const LANGUAGE_HANDLEROID: u32 = 2280;
pub const INTERNALOID: u32 = 2281;
pub const OPAQUEOID: u32 = 2282;
pub const ANYELEMENTOID: u32 = 2283;
pub const ANYNONARRAYOID: u32 = 2776;
pub const ANYENUMOID: u32 = 3500;
pub const FDW_HANDLEROID: u32 = 3115;
pub const INDEX_AM_HANDLEROID: u32 = 325;
pub const TSM_HANDLEROID: u32 = 3310;
pub const TABLE_AM_HANDLEROID: u32 = 269;
pub const ANYRANGEOID: u32 = 3831;
pub const BOOLARRAYOID: u32 = 1000;
pub const BYTEAARRAYOID: u32 = 1001;
pub const CHARARRAYOID: u32 = 1002;
pub const NAMEARRAYOID: u32 = 1003;
pub const INT8ARRAYOID: u32 = 1016;
pub const INT2ARRAYOID: u32 = 1005;
pub const INT2VECTORARRAYOID: u32 = 1006;
pub const INT4ARRAYOID: u32 = 1007;
pub const REGPROCARRAYOID: u32 = 1008;
pub const TEXTARRAYOID: u32 = 1009;
pub const OIDARRAYOID: u32 = 1028;
pub const TIDARRAYOID: u32 = 1010;
pub const XIDARRAYOID: u32 = 1011;
pub const CIDARRAYOID: u32 = 1012;
pub const OIDVECTORARRAYOID: u32 = 1013;
pub const JSONARRAYOID: u32 = 199;
pub const XMLARRAYOID: u32 = 143;
pub const POINTARRAYOID: u32 = 1017;
pub const LSEGARRAYOID: u32 = 1018;
pub const PATHARRAYOID: u32 = 1019;
pub const BOXARRAYOID: u32 = 1020;
pub const POLYGONARRAYOID: u32 = 1027;
pub const LINEARRAYOID: u32 = 629;
pub const FLOAT4ARRAYOID: u32 = 1021;
pub const FLOAT8ARRAYOID: u32 = 1022;
pub const CIRCLEARRAYOID: u32 = 719;
pub const MONEYARRAYOID: u32 = 791;
pub const MACADDRARRAYOID: u32 = 1040;
pub const INETARRAYOID: u32 = 1041;
pub const CIDRARRAYOID: u32 = 651;
pub const MACADDR8ARRAYOID: u32 = 775;
pub const ACLITEMARRAYOID: u32 = 1034;
pub const BPCHARARRAYOID: u32 = 1014;
pub const VARCHARARRAYOID: u32 = 1015;
pub const DATEARRAYOID: u32 = 1182;
pub const TIMEARRAYOID: u32 = 1183;
pub const TIMESTAMPARRAYOID: u32 = 1115;
pub const TIMESTAMPTZARRAYOID: u32 = 1185;
pub const INTERVALARRAYOID: u32 = 1187;
pub const TIMETZARRAYOID: u32 = 1270;
pub const BITARRAYOID: u32 = 1561;
pub const VARBITARRAYOID: u32 = 1563;
pub const NUMERICARRAYOID: u32 = 1231;
pub const REFCURSORARRAYOID: u32 = 2201;
pub const REGPROCEDUREARRAYOID: u32 = 2207;
pub const REGOPERARRAYOID: u32 = 2208;
pub const REGOPERATORARRAYOID: u32 = 2209;
pub const REGCLASSARRAYOID: u32 = 2210;
pub const REGTYPEARRAYOID: u32 = 2211;
pub const REGROLEARRAYOID: u32 = 4097;
pub const REGNAMESPACEARRAYOID: u32 = 4090;
pub const UUIDARRAYOID: u32 = 2951;
pub const PG_LSNARRAYOID: u32 = 3221;
pub const TSVECTORARRAYOID: u32 = 3643;
pub const GTSVECTORARRAYOID: u32 = 3644;
pub const TSQUERYARRAYOID: u32 = 3645;
pub const REGCONFIGARRAYOID: u32 = 3735;
pub const REGDICTIONARYARRAYOID: u32 = 3770;
pub const JSONBARRAYOID: u32 = 3807;
pub const JSONPATHARRAYOID: u32 = 4073;
pub const TXID_SNAPSHOTARRAYOID: u32 = 2949;
pub const INT4RANGEARRAYOID: u32 = 3905;
pub const NUMRANGEARRAYOID: u32 = 3907;
pub const TSRANGEARRAYOID: u32 = 3909;
pub const TSTZRANGEARRAYOID: u32 = 3911;
pub const DATERANGEARRAYOID: u32 = 3913;
pub const INT8RANGEARRAYOID: u32 = 3927;
pub const CSTRINGARRAYOID: u32 = 1263;
pub const EventTriggerRelationId: u32 = 3466;
pub const Anum_pg_event_trigger_oid: u32 = 1;
pub const Anum_pg_event_trigger_evtname: u32 = 2;
pub const Anum_pg_event_trigger_evtevent: u32 = 3;
pub const Anum_pg_event_trigger_evtowner: u32 = 4;
pub const Anum_pg_event_trigger_evtfoid: u32 = 5;
pub const Anum_pg_event_trigger_evtenabled: u32 = 6;
pub const Anum_pg_event_trigger_evttags: u32 = 7;
pub const Natts_pg_event_trigger: u32 = 7;
pub const AT_REWRITE_ALTER_PERSISTENCE: u32 = 1;
pub const AT_REWRITE_DEFAULT_VAL: u32 = 2;
pub const AT_REWRITE_COLUMN_REWRITE: u32 = 4;
pub const TRIGGER_EVENT_INSERT: u32 = 0;
pub const TRIGGER_EVENT_DELETE: u32 = 1;
pub const TRIGGER_EVENT_UPDATE: u32 = 2;
pub const TRIGGER_EVENT_TRUNCATE: u32 = 3;
pub const TRIGGER_EVENT_OPMASK: u32 = 3;
pub const TRIGGER_EVENT_ROW: u32 = 4;
pub const TRIGGER_EVENT_BEFORE: u32 = 8;
pub const TRIGGER_EVENT_AFTER: u32 = 0;
pub const TRIGGER_EVENT_INSTEAD: u32 = 16;
pub const TRIGGER_EVENT_TIMINGMASK: u32 = 24;
pub const AFTER_TRIGGER_DEFERRABLE: u32 = 32;
pub const AFTER_TRIGGER_INITDEFERRED: u32 = 64;
pub const SESSION_REPLICATION_ROLE_ORIGIN: u32 = 0;
pub const SESSION_REPLICATION_ROLE_REPLICA: u32 = 1;
pub const SESSION_REPLICATION_ROLE_LOCAL: u32 = 2;
pub const TRIGGER_FIRES_ON_ORIGIN: u8 = 79u8;
pub const TRIGGER_FIRES_ALWAYS: u8 = 65u8;
pub const TRIGGER_FIRES_ON_REPLICA: u8 = 82u8;
pub const TRIGGER_DISABLED: u8 = 68u8;
pub const RI_TRIGGER_PK: u32 = 1;
pub const RI_TRIGGER_FK: u32 = 2;
pub const RI_TRIGGER_NONE: u32 = 0;
pub const StatisticRelationId: u32 = 2619;
pub const Anum_pg_statistic_starelid: u32 = 1;
pub const Anum_pg_statistic_staattnum: u32 = 2;
pub const Anum_pg_statistic_stainherit: u32 = 3;
pub const Anum_pg_statistic_stanullfrac: u32 = 4;
pub const Anum_pg_statistic_stawidth: u32 = 5;
pub const Anum_pg_statistic_stadistinct: u32 = 6;
pub const Anum_pg_statistic_stakind1: u32 = 7;
pub const Anum_pg_statistic_stakind2: u32 = 8;
pub const Anum_pg_statistic_stakind3: u32 = 9;
pub const Anum_pg_statistic_stakind4: u32 = 10;
pub const Anum_pg_statistic_stakind5: u32 = 11;
pub const Anum_pg_statistic_staop1: u32 = 12;
pub const Anum_pg_statistic_staop2: u32 = 13;
pub const Anum_pg_statistic_staop3: u32 = 14;
pub const Anum_pg_statistic_staop4: u32 = 15;
pub const Anum_pg_statistic_staop5: u32 = 16;
pub const Anum_pg_statistic_stacoll1: u32 = 17;
pub const Anum_pg_statistic_stacoll2: u32 = 18;
pub const Anum_pg_statistic_stacoll3: u32 = 19;
pub const Anum_pg_statistic_stacoll4: u32 = 20;
pub const Anum_pg_statistic_stacoll5: u32 = 21;
pub const Anum_pg_statistic_stanumbers1: u32 = 22;
pub const Anum_pg_statistic_stanumbers2: u32 = 23;
pub const Anum_pg_statistic_stanumbers3: u32 = 24;
pub const Anum_pg_statistic_stanumbers4: u32 = 25;
pub const Anum_pg_statistic_stanumbers5: u32 = 26;
pub const Anum_pg_statistic_stavalues1: u32 = 27;
pub const Anum_pg_statistic_stavalues2: u32 = 28;
pub const Anum_pg_statistic_stavalues3: u32 = 29;
pub const Anum_pg_statistic_stavalues4: u32 = 30;
pub const Anum_pg_statistic_stavalues5: u32 = 31;
pub const Natts_pg_statistic: u32 = 31;
pub const STATISTIC_KIND_MCV: u32 = 1;
pub const STATISTIC_KIND_HISTOGRAM: u32 = 2;
pub const STATISTIC_KIND_CORRELATION: u32 = 3;
pub const STATISTIC_KIND_MCELEM: u32 = 4;
pub const STATISTIC_KIND_DECHIST: u32 = 5;
pub const STATISTIC_KIND_RANGE_LENGTH_HISTOGRAM: u32 = 6;
pub const STATISTIC_KIND_BOUNDS_HISTOGRAM: u32 = 7;
pub const STATISTIC_NUM_SLOTS: u32 = 5;
pub const CACHEDPLANSOURCE_MAGIC: u32 = 195726186;
pub const CACHEDPLAN_MAGIC: u32 = 953717834;
pub const CACHEDEXPR_MAGIC: u32 = 838275847;
pub const SPI_ERROR_CONNECT: i32 = -1;
pub const SPI_ERROR_COPY: i32 = -2;
pub const SPI_ERROR_OPUNKNOWN: i32 = -3;
pub const SPI_ERROR_UNCONNECTED: i32 = -4;
pub const SPI_ERROR_CURSOR: i32 = -5;
pub const SPI_ERROR_ARGUMENT: i32 = -6;
pub const SPI_ERROR_PARAM: i32 = -7;
pub const SPI_ERROR_TRANSACTION: i32 = -8;
pub const SPI_ERROR_NOATTRIBUTE: i32 = -9;
pub const SPI_ERROR_NOOUTFUNC: i32 = -10;
pub const SPI_ERROR_TYPUNKNOWN: i32 = -11;
pub const SPI_ERROR_REL_DUPLICATE: i32 = -12;
pub const SPI_ERROR_REL_NOT_FOUND: i32 = -13;
pub const SPI_OK_CONNECT: u32 = 1;
pub const SPI_OK_FINISH: u32 = 2;
pub const SPI_OK_FETCH: u32 = 3;
pub const SPI_OK_UTILITY: u32 = 4;
pub const SPI_OK_SELECT: u32 = 5;
pub const SPI_OK_SELINTO: u32 = 6;
pub const SPI_OK_INSERT: u32 = 7;
pub const SPI_OK_DELETE: u32 = 8;
pub const SPI_OK_UPDATE: u32 = 9;
pub const SPI_OK_CURSOR: u32 = 10;
pub const SPI_OK_INSERT_RETURNING: u32 = 11;
pub const SPI_OK_DELETE_RETURNING: u32 = 12;
pub const SPI_OK_UPDATE_RETURNING: u32 = 13;
pub const SPI_OK_REWRITTEN: u32 = 14;
pub const SPI_OK_REL_REGISTER: u32 = 15;
pub const SPI_OK_REL_UNREGISTER: u32 = 16;
pub const SPI_OK_TD_REGISTER: u32 = 17;
pub const SPI_OPT_NONATOMIC: u32 = 1;
pub const BGWORKER_SHMEM_ACCESS: u32 = 1;
pub const BGWORKER_BACKEND_DATABASE_CONNECTION: u32 = 2;
pub const BGWORKER_CLASS_PARALLEL: u32 = 16;
pub const BGW_DEFAULT_RESTART_INTERVAL: u32 = 60;
pub const BGW_NEVER_RESTART: i32 = -1;
pub const BGW_MAXLEN: u32 = 96;
pub const BGW_EXTRALEN: u32 = 128;
pub const BGWORKER_BYPASS_ALLOWCONN: u32 = 1;
pub const HAVE_PLANNERINFO_TYPEDEF: u32 = 1;
pub const HAVE_INDEXOPTINFO_TYPEDEF: u32 = 1;
pub const HAVE_SPECIALJOININFO_TYPEDEF: u32 = 1;
pub const GROUPING_CAN_USE_SORT: u32 = 1;
pub const GROUPING_CAN_USE_HASH: u32 = 2;
pub const GROUPING_CAN_PARTIAL_AGG: u32 = 4;
pub const FSV_MISSING_OK: u32 = 1;
pub const FDW_MISSING_OK: u32 = 1;
pub const MAX_MULTIBYTE_CHAR_LEN: u32 = 4;
pub const SS2: u32 = 142;
pub const SS3: u32 = 143;
pub const LC_ISO8859_1: u32 = 129;
pub const LC_ISO8859_2: u32 = 130;
pub const LC_ISO8859_3: u32 = 131;
pub const LC_ISO8859_4: u32 = 132;
pub const LC_TIS620: u32 = 133;
pub const LC_ISO8859_7: u32 = 134;
pub const LC_ISO8859_6: u32 = 135;
pub const LC_ISO8859_8: u32 = 136;
pub const LC_JISX0201K: u32 = 137;
pub const LC_JISX0201R: u32 = 138;
pub const LC_KOI8_R: u32 = 139;
pub const LC_ISO8859_5: u32 = 140;
pub const LC_ISO8859_9: u32 = 141;
pub const LC_ISO8859_15: u32 = 142;
pub const LC_JISX0208_1978: u32 = 144;
pub const LC_GB2312_80: u32 = 145;
pub const LC_JISX0208: u32 = 146;
pub const LC_KS5601: u32 = 147;
pub const LC_JISX0212: u32 = 148;
pub const LC_CNS11643_1: u32 = 149;
pub const LC_CNS11643_2: u32 = 150;
pub const LC_JISX0213_1: u32 = 151;
pub const LC_BIG5_1: u32 = 152;
pub const LC_BIG5_2: u32 = 153;
pub const LCPRV1_A: u32 = 154;
pub const LCPRV1_B: u32 = 155;
pub const LCPRV2_A: u32 = 156;
pub const LCPRV2_B: u32 = 157;
pub const LC_SISHENG: u32 = 160;
pub const LC_IPA: u32 = 161;
pub const LC_VISCII_LOWER: u32 = 162;
pub const LC_VISCII_UPPER: u32 = 163;
pub const LC_ARABIC_DIGIT: u32 = 164;
pub const LC_ARABIC_1_COLUMN: u32 = 165;
pub const LC_ASCII_RIGHT_TO_LEFT: u32 = 166;
pub const LC_LAO: u32 = 167;
pub const LC_ARABIC_2_COLUMN: u32 = 168;
pub const LC_INDIAN_1_COLUMN: u32 = 240;
pub const LC_TIBETAN_1_COLUMN: u32 = 241;
pub const LC_UNICODE_SUBSET_2: u32 = 242;
pub const LC_UNICODE_SUBSET_3: u32 = 243;
pub const LC_UNICODE_SUBSET: u32 = 244;
pub const LC_ETHIOPIC: u32 = 245;
pub const LC_CNS11643_3: u32 = 246;
pub const LC_CNS11643_4: u32 = 247;
pub const LC_CNS11643_5: u32 = 248;
pub const LC_CNS11643_6: u32 = 249;
pub const LC_CNS11643_7: u32 = 250;
pub const LC_INDIAN_2_COLUMN: u32 = 251;
pub const LC_TIBETAN: u32 = 252;
pub const MAX_CONVERSION_GROWTH: u32 = 4;
pub const EXTNODENAME_MAX_LEN: u32 = 64;
pub const CUSTOMPATH_SUPPORT_BACKWARD_SCAN: u32 = 1;
pub const CUSTOMPATH_SUPPORT_MARK_RESTORE: u32 = 2;
pub const QTW_IGNORE_RT_SUBQUERIES: u32 = 1;
pub const QTW_IGNORE_CTE_SUBQUERIES: u32 = 2;
pub const QTW_IGNORE_RC_SUBQUERIES: u32 = 3;
pub const QTW_IGNORE_JOINALIASES: u32 = 4;
pub const QTW_IGNORE_RANGE_TABLE: u32 = 8;
pub const QTW_EXAMINE_RTES_BEFORE: u32 = 16;
pub const QTW_EXAMINE_RTES_AFTER: u32 = 32;
pub const QTW_DONT_COPY_QUERY: u32 = 64;
pub const QTW_EXAMINE_SORTGROUP: u32 = 128;
pub const DEFAULT_SEQ_PAGE_COST: f64 = 1.0;
pub const DEFAULT_RANDOM_PAGE_COST: f64 = 4.0;
pub const DEFAULT_CPU_TUPLE_COST: f64 = 0.01;
pub const DEFAULT_CPU_INDEX_TUPLE_COST: f64 = 0.005;
pub const DEFAULT_CPU_OPERATOR_COST: f64 = 0.0025;
pub const DEFAULT_PARALLEL_TUPLE_COST: f64 = 0.1;
pub const DEFAULT_PARALLEL_SETUP_COST: f64 = 1000.0;
pub const DEFAULT_EFFECTIVE_CACHE_SIZE: u32 = 524288;
pub const PVC_INCLUDE_AGGREGATES: u32 = 1;
pub const PVC_RECURSE_AGGREGATES: u32 = 2;
pub const PVC_INCLUDE_WINDOWFUNCS: u32 = 4;
pub const PVC_RECURSE_WINDOWFUNCS: u32 = 8;
pub const PVC_INCLUDE_PLACEHOLDERS: u32 = 16;
pub const PVC_RECURSE_PLACEHOLDERS: u32 = 32;
pub const DEFAULT_CURSOR_TUPLE_FRACTION: f64 = 0.1;
pub const OLD_SNAPSHOT_PADDING_ENTRIES: u32 = 10;
pub const MAX_IO_CONCURRENCY: u32 = 1000;
pub const BUFFER_LOCK_UNLOCK: u32 = 0;
pub const BUFFER_LOCK_SHARE: u32 = 1;
pub const BUFFER_LOCK_EXCLUSIVE: u32 = 2;
pub const XLOG_STANDBY_LOCK: u32 = 0;
pub const XLOG_RUNNING_XACTS: u32 = 16;
pub const XLOG_INVALIDATIONS: u32 = 32;
pub const PROCARRAY_VACUUM_FLAG: u32 = 2;
pub const PROCARRAY_ANALYZE_FLAG: u32 = 4;
pub const PROCARRAY_LOGICAL_DECODING_FLAG: u32 = 16;
pub const PROCARRAY_SLOTS_XMIN: u32 = 32;
pub const PROCARRAY_PROC_FLAGS_MASK: u32 = 22;
pub const PROCARRAY_FLAGS_DEFAULT: u32 = 16;
pub const PROCARRAY_FLAGS_VACUUM: u32 = 18;
pub const PROCARRAY_FLAGS_ANALYZE: u32 = 20;
pub const PROCARRAY_FLAGS_VACUUM_ANALYZE: u32 = 22;
pub const MAXSTRLEN: u32 = 2047;
pub const MAXSTRPOS: u32 = 1048575;
pub const MAXENTRYPOS: u32 = 16384;
pub const MAXNUMPOS: u32 = 256;
pub const QI_VAL: u32 = 1;
pub const QI_OPR: u32 = 2;
pub const QI_VALSTOP: u32 = 3;
pub const OP_NOT: u32 = 1;
pub const OP_AND: u32 = 2;
pub const OP_OR: u32 = 3;
pub const OP_PHRASE: u32 = 4;
pub const OP_COUNT: u32 = 4;
pub const TSL_ADDPOS: u32 = 1;
pub const TSL_PREFIX: u32 = 2;
pub const TSL_FILTER: u32 = 4;
pub const P_TSV_OPR_IS_DELIM: u32 = 1;
pub const P_TSV_IS_TSQUERY: u32 = 2;
pub const P_TSV_IS_WEB: u32 = 4;
pub const P_TSQ_PLAIN: u32 = 1;
pub const P_TSQ_WEB: u32 = 2;
pub const TS_EXEC_EMPTY: u32 = 0;
pub const TS_EXEC_CALC_NOT: u32 = 1;
pub const TS_EXEC_PHRASE_NO_POS: u32 = 2;
pub const TSearchStrategyNumber: u32 = 1;
pub const TSearchWithClassStrategyNumber: u32 = 2;
pub const QTN_NEEDFREE: u32 = 1;
pub const QTN_NOCHANGE: u32 = 2;
pub const QTN_WORDFREE: u32 = 4;
pub const STACK_DEPTH_SLOP: u32 = 524288;
pub const FORMAT_TYPE_TYPEMOD_GIVEN: u32 = 1;
pub const FORMAT_TYPE_ALLOW_INVALID: u32 = 2;
pub const FORMAT_TYPE_FORCE_QUALIFY: u32 = 4;
pub const MAX_TIME_PRECISION: u32 = 6;
pub const RADIANS_PER_DEGREE: f64 = 0.017453292519943295;
pub const NUMERIC_MAX_PRECISION: u32 = 1000;
pub const NUMERIC_MAX_DISPLAY_SCALE: u32 = 1000;
pub const NUMERIC_MIN_DISPLAY_SCALE: u32 = 0;
pub const NUMERIC_MAX_RESULT_SCALE: u32 = 2000;
pub const NUMERIC_MIN_SIG_DIGITS: u32 = 16;
pub const JsonbContainsStrategyNumber: u32 = 7;
pub const JsonbExistsStrategyNumber: u32 = 9;
pub const JsonbExistsAnyStrategyNumber: u32 = 10;
pub const JsonbExistsAllStrategyNumber: u32 = 11;
pub const JsonbJsonpathExistsStrategyNumber: u32 = 15;
pub const JsonbJsonpathPredicateStrategyNumber: u32 = 16;
pub const JGINFLAG_KEY: u32 = 1;
pub const JGINFLAG_NULL: u32 = 2;
pub const JGINFLAG_BOOL: u32 = 3;
pub const JGINFLAG_NUM: u32 = 4;
pub const JGINFLAG_STR: u32 = 5;
pub const JGINFLAG_HASHED: u32 = 16;
pub const JGIN_MAXLENGTH: u32 = 125;
pub const JENTRY_OFFLENMASK: u32 = 268435455;
pub const JENTRY_TYPEMASK: u32 = 1879048192;
pub const JENTRY_HAS_OFF: u32 = 2147483648;
pub const JENTRY_ISSTRING: u32 = 0;
pub const JENTRY_ISNUMERIC: u32 = 268435456;
pub const JENTRY_ISBOOL_FALSE: u32 = 536870912;
pub const JENTRY_ISBOOL_TRUE: u32 = 805306368;
pub const JENTRY_ISNULL: u32 = 1073741824;
pub const JENTRY_ISCONTAINER: u32 = 1342177280;
pub const JB_OFFSET_STRIDE: u32 = 32;
pub const JB_CMASK: u32 = 268435455;
pub const JB_FSCALAR: u32 = 268435456;
pub const JB_FOBJECT: u32 = 536870912;
pub const JB_FARRAY: u32 = 1073741824;
pub const ATTSTATSSLOT_VALUES: u32 = 1;
pub const ATTSTATSSLOT_NUMBERS: u32 = 2;
pub const DEFAULT_EQ_SEL: f64 = 0.005;
pub const DEFAULT_INEQ_SEL: f64 = 0.3333333333333333;
pub const DEFAULT_RANGE_INEQ_SEL: f64 = 0.005;
pub const DEFAULT_MATCH_SEL: f64 = 0.005;
pub const DEFAULT_NUM_DISTINCT: u32 = 200;
pub const DEFAULT_UNK_SEL: f64 = 0.005;
pub const DEFAULT_NOT_UNK_SEL: f64 = 0.995;
pub const TYPECACHE_EQ_OPR: u32 = 1;
pub const TYPECACHE_LT_OPR: u32 = 2;
pub const TYPECACHE_GT_OPR: u32 = 4;
pub const TYPECACHE_CMP_PROC: u32 = 8;
pub const TYPECACHE_HASH_PROC: u32 = 16;
pub const TYPECACHE_EQ_OPR_FINFO: u32 = 32;
pub const TYPECACHE_CMP_PROC_FINFO: u32 = 64;
pub const TYPECACHE_HASH_PROC_FINFO: u32 = 128;
pub const TYPECACHE_TUPDESC: u32 = 256;
pub const TYPECACHE_BTREE_OPFAMILY: u32 = 512;
pub const TYPECACHE_HASH_OPFAMILY: u32 = 1024;
pub const TYPECACHE_RANGE_INFO: u32 = 2048;
pub const TYPECACHE_DOMAIN_BASE_INFO: u32 = 4096;
pub const TYPECACHE_DOMAIN_CONSTR_INFO: u32 = 8192;
pub const TYPECACHE_HASH_EXTENDED_PROC: u32 = 16384;
pub const TYPECACHE_HASH_EXTENDED_PROC_FINFO: u32 = 32768;
pub const RANGE_EMPTY: u32 = 1;
pub const RANGE_LB_INC: u32 = 2;
pub const RANGE_UB_INC: u32 = 4;
pub const RANGE_LB_INF: u32 = 8;
pub const RANGE_UB_INF: u32 = 16;
pub const RANGE_LB_NULL: u32 = 32;
pub const RANGE_UB_NULL: u32 = 64;
pub const RANGE_CONTAIN_EMPTY: u32 = 128;
pub const RANGESTRAT_BEFORE: u32 = 1;
pub const RANGESTRAT_OVERLEFT: u32 = 2;
pub const RANGESTRAT_OVERLAPS: u32 = 3;
pub const RANGESTRAT_OVERRIGHT: u32 = 4;
pub const RANGESTRAT_AFTER: u32 = 5;
pub const RANGESTRAT_ADJACENT: u32 = 6;
pub const RANGESTRAT_CONTAINS: u32 = 7;
pub const RANGESTRAT_CONTAINED_BY: u32 = 8;
pub const RANGESTRAT_CONTAINS_ELEM: u32 = 16;
pub const RANGESTRAT_EQ: u32 = 18;
pub type Oid = ::std::os::raw::c_uint;
pub type pg_int64 = ::std::os::raw::c_long;
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __intmax_t = ::std::os::raw::c_long;
pub type __uintmax_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __suseconds64_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __mbstate_t {
    pub __count: ::std::os::raw::c_int,
    pub __value: __mbstate_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t__bindgen_ty_1 {
    pub __wch: ::std::os::raw::c_uint,
    pub __wchb: [::std::os::raw::c_char; 4usize],
}
impl Default for __mbstate_t__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for __mbstate_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos_t {
    pub __pos: __off_t,
    pub __state: __mbstate_t,
}
impl Default for _G_fpos_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __fpos_t = _G_fpos_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos64_t {
    pub __pos: __off64_t,
    pub __state: __mbstate_t,
}
impl Default for _G_fpos64_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __fpos64_t = _G_fpos64_t;
pub type __FILE = _IO_FILE;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: usize,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
impl Default for _IO_FILE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type off_t = __off_t;
pub type fpos_t = __fpos_t;
extern "C" {
    pub static mut stdin: *mut FILE;
}
extern "C" {
    pub static mut stdout: *mut FILE;
}
extern "C" {
    pub static mut stderr: *mut FILE;
}
pub unsafe fn remove(arg___filename: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn remove(arg___filename: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        remove(arg___filename)
    })
}
pub unsafe fn rename(
    arg___old: *const ::std::os::raw::c_char,
    arg___new: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rename(
                arg___old: *const ::std::os::raw::c_char,
                arg___new: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        rename(arg___old, arg___new)
    })
}
pub unsafe fn renameat(
    arg___oldfd: ::std::os::raw::c_int,
    arg___old: *const ::std::os::raw::c_char,
    arg___newfd: ::std::os::raw::c_int,
    arg___new: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn renameat(
                arg___oldfd: ::std::os::raw::c_int,
                arg___old: *const ::std::os::raw::c_char,
                arg___newfd: ::std::os::raw::c_int,
                arg___new: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        renameat(arg___oldfd, arg___old, arg___newfd, arg___new)
    })
}
pub unsafe fn fclose(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fclose(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        fclose(arg___stream)
    })
}
pub unsafe fn tmpfile() -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tmpfile() -> *mut FILE;
        }
        tmpfile()
    })
}
pub unsafe fn tmpnam(arg_arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tmpnam(arg_arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        tmpnam(arg_arg1)
    })
}
pub unsafe fn tmpnam_r(arg___s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tmpnam_r(arg___s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        tmpnam_r(arg___s)
    })
}
pub unsafe fn tempnam(
    arg___dir: *const ::std::os::raw::c_char,
    arg___pfx: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tempnam(
                arg___dir: *const ::std::os::raw::c_char,
                arg___pfx: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        tempnam(arg___dir, arg___pfx)
    })
}
pub unsafe fn fflush(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fflush(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        fflush(arg___stream)
    })
}
pub unsafe fn fflush_unlocked(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fflush_unlocked(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        fflush_unlocked(arg___stream)
    })
}
pub unsafe fn fopen(
    arg___filename: *const ::std::os::raw::c_char,
    arg___modes: *const ::std::os::raw::c_char,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fopen(
                arg___filename: *const ::std::os::raw::c_char,
                arg___modes: *const ::std::os::raw::c_char,
            ) -> *mut FILE;
        }
        fopen(arg___filename, arg___modes)
    })
}
pub unsafe fn freopen(
    arg___filename: *const ::std::os::raw::c_char,
    arg___modes: *const ::std::os::raw::c_char,
    arg___stream: *mut FILE,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn freopen(
                arg___filename: *const ::std::os::raw::c_char,
                arg___modes: *const ::std::os::raw::c_char,
                arg___stream: *mut FILE,
            ) -> *mut FILE;
        }
        freopen(arg___filename, arg___modes, arg___stream)
    })
}
pub unsafe fn fdopen(
    arg___fd: ::std::os::raw::c_int,
    arg___modes: *const ::std::os::raw::c_char,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fdopen(
                arg___fd: ::std::os::raw::c_int,
                arg___modes: *const ::std::os::raw::c_char,
            ) -> *mut FILE;
        }
        fdopen(arg___fd, arg___modes)
    })
}
pub unsafe fn fmemopen(
    arg___s: *mut ::std::os::raw::c_void,
    arg___len: usize,
    arg___modes: *const ::std::os::raw::c_char,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmemopen(
                arg___s: *mut ::std::os::raw::c_void,
                arg___len: usize,
                arg___modes: *const ::std::os::raw::c_char,
            ) -> *mut FILE;
        }
        fmemopen(arg___s, arg___len, arg___modes)
    })
}
pub unsafe fn open_memstream(
    arg___bufloc: *mut *mut ::std::os::raw::c_char,
    arg___sizeloc: *mut usize,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn open_memstream(
                arg___bufloc: *mut *mut ::std::os::raw::c_char,
                arg___sizeloc: *mut usize,
            ) -> *mut FILE;
        }
        open_memstream(arg___bufloc, arg___sizeloc)
    })
}
pub unsafe fn setbuf(arg___stream: *mut FILE, arg___buf: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setbuf(arg___stream: *mut FILE, arg___buf: *mut ::std::os::raw::c_char);
        }
        setbuf(arg___stream, arg___buf)
    })
}
pub unsafe fn setvbuf(
    arg___stream: *mut FILE,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___modes: ::std::os::raw::c_int,
    arg___n: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setvbuf(
                arg___stream: *mut FILE,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___modes: ::std::os::raw::c_int,
                arg___n: usize,
            ) -> ::std::os::raw::c_int;
        }
        setvbuf(arg___stream, arg___buf, arg___modes, arg___n)
    })
}
pub unsafe fn setbuffer(
    arg___stream: *mut FILE,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___size: usize,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setbuffer(
                arg___stream: *mut FILE,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___size: usize,
            );
        }
        setbuffer(arg___stream, arg___buf, arg___size)
    })
}
pub unsafe fn setlinebuf(arg___stream: *mut FILE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setlinebuf(arg___stream: *mut FILE);
        }
        setlinebuf(arg___stream)
    })
}
pub unsafe fn fprintf(
    arg___stream: *mut FILE,
    arg___format: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fprintf(
                arg___stream: *mut FILE,
                arg___format: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        fprintf(arg___stream, arg___format)
    })
}
pub unsafe fn printf(arg___format: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn printf(arg___format: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        printf(arg___format)
    })
}
pub unsafe fn sprintf(
    arg___s: *mut ::std::os::raw::c_char,
    arg___format: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sprintf(
                arg___s: *mut ::std::os::raw::c_char,
                arg___format: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        sprintf(arg___s, arg___format)
    })
}
pub unsafe fn vfprintf(
    arg___s: *mut FILE,
    arg___format: *const ::std::os::raw::c_char,
    arg___arg: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vfprintf(
                arg___s: *mut FILE,
                arg___format: *const ::std::os::raw::c_char,
                arg___arg: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        vfprintf(arg___s, arg___format, arg___arg)
    })
}
pub unsafe fn vprintf(
    arg___format: *const ::std::os::raw::c_char,
    arg___arg: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vprintf(
                arg___format: *const ::std::os::raw::c_char,
                arg___arg: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        vprintf(arg___format, arg___arg)
    })
}
pub unsafe fn vsprintf(
    arg___s: *mut ::std::os::raw::c_char,
    arg___format: *const ::std::os::raw::c_char,
    arg___arg: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vsprintf(
                arg___s: *mut ::std::os::raw::c_char,
                arg___format: *const ::std::os::raw::c_char,
                arg___arg: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        vsprintf(arg___s, arg___format, arg___arg)
    })
}
pub unsafe fn snprintf(
    arg___s: *mut ::std::os::raw::c_char,
    arg___maxlen: ::std::os::raw::c_ulong,
    arg___format: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn snprintf(
                arg___s: *mut ::std::os::raw::c_char,
                arg___maxlen: ::std::os::raw::c_ulong,
                arg___format: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        snprintf(arg___s, arg___maxlen, arg___format)
    })
}
pub unsafe fn vsnprintf(
    arg___s: *mut ::std::os::raw::c_char,
    arg___maxlen: ::std::os::raw::c_ulong,
    arg___format: *const ::std::os::raw::c_char,
    arg___arg: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vsnprintf(
                arg___s: *mut ::std::os::raw::c_char,
                arg___maxlen: ::std::os::raw::c_ulong,
                arg___format: *const ::std::os::raw::c_char,
                arg___arg: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        vsnprintf(arg___s, arg___maxlen, arg___format, arg___arg)
    })
}
pub unsafe fn vdprintf(
    arg___fd: ::std::os::raw::c_int,
    arg___fmt: *const ::std::os::raw::c_char,
    arg___arg: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vdprintf(
                arg___fd: ::std::os::raw::c_int,
                arg___fmt: *const ::std::os::raw::c_char,
                arg___arg: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        vdprintf(arg___fd, arg___fmt, arg___arg)
    })
}
pub unsafe fn dprintf(
    arg___fd: ::std::os::raw::c_int,
    arg___fmt: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dprintf(
                arg___fd: ::std::os::raw::c_int,
                arg___fmt: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        dprintf(arg___fd, arg___fmt)
    })
}
pub unsafe fn fscanf(
    arg___stream: *mut FILE,
    arg___format: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fscanf(
                arg___stream: *mut FILE,
                arg___format: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        fscanf(arg___stream, arg___format)
    })
}
pub unsafe fn scanf(arg___format: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scanf(arg___format: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        scanf(arg___format)
    })
}
pub unsafe fn sscanf(
    arg___s: *const ::std::os::raw::c_char,
    arg___format: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sscanf(
                arg___s: *const ::std::os::raw::c_char,
                arg___format: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        sscanf(arg___s, arg___format)
    })
}
pub type _Float32 = f32;
pub type _Float64 = f64;
pub type _Float32x = f64;
pub type _Float64x = u128;
pub unsafe fn fscanf1(
    arg___stream: *mut FILE,
    arg___format: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fscanf1(
                arg___stream: *mut FILE,
                arg___format: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        fscanf1(arg___stream, arg___format)
    })
}
pub unsafe fn scanf1(arg___format: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scanf1(arg___format: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        scanf1(arg___format)
    })
}
pub unsafe fn sscanf1(
    arg___s: *const ::std::os::raw::c_char,
    arg___format: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sscanf1(
                arg___s: *const ::std::os::raw::c_char,
                arg___format: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        sscanf1(arg___s, arg___format)
    })
}
pub unsafe fn vfscanf(
    arg___s: *mut FILE,
    arg___format: *const ::std::os::raw::c_char,
    arg___arg: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vfscanf(
                arg___s: *mut FILE,
                arg___format: *const ::std::os::raw::c_char,
                arg___arg: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        vfscanf(arg___s, arg___format, arg___arg)
    })
}
pub unsafe fn vscanf(
    arg___format: *const ::std::os::raw::c_char,
    arg___arg: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vscanf(
                arg___format: *const ::std::os::raw::c_char,
                arg___arg: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        vscanf(arg___format, arg___arg)
    })
}
pub unsafe fn vsscanf(
    arg___s: *const ::std::os::raw::c_char,
    arg___format: *const ::std::os::raw::c_char,
    arg___arg: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vsscanf(
                arg___s: *const ::std::os::raw::c_char,
                arg___format: *const ::std::os::raw::c_char,
                arg___arg: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        vsscanf(arg___s, arg___format, arg___arg)
    })
}
pub unsafe fn vfscanf1(
    arg___s: *mut FILE,
    arg___format: *const ::std::os::raw::c_char,
    arg___arg: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vfscanf1(
                arg___s: *mut FILE,
                arg___format: *const ::std::os::raw::c_char,
                arg___arg: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        vfscanf1(arg___s, arg___format, arg___arg)
    })
}
pub unsafe fn vscanf1(
    arg___format: *const ::std::os::raw::c_char,
    arg___arg: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vscanf1(
                arg___format: *const ::std::os::raw::c_char,
                arg___arg: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        vscanf1(arg___format, arg___arg)
    })
}
pub unsafe fn vsscanf1(
    arg___s: *const ::std::os::raw::c_char,
    arg___format: *const ::std::os::raw::c_char,
    arg___arg: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn vsscanf1(
                arg___s: *const ::std::os::raw::c_char,
                arg___format: *const ::std::os::raw::c_char,
                arg___arg: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        vsscanf1(arg___s, arg___format, arg___arg)
    })
}
pub unsafe fn fgetc(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fgetc(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        fgetc(arg___stream)
    })
}
pub unsafe fn getc(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getc(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        getc(arg___stream)
    })
}
pub unsafe fn getchar() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getchar() -> ::std::os::raw::c_int;
        }
        getchar()
    })
}
pub unsafe fn getc_unlocked(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getc_unlocked(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        getc_unlocked(arg___stream)
    })
}
pub unsafe fn getchar_unlocked() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getchar_unlocked() -> ::std::os::raw::c_int;
        }
        getchar_unlocked()
    })
}
pub unsafe fn fgetc_unlocked(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fgetc_unlocked(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        fgetc_unlocked(arg___stream)
    })
}
pub unsafe fn fputc(
    arg___c: ::std::os::raw::c_int,
    arg___stream: *mut FILE,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fputc(
                arg___c: ::std::os::raw::c_int,
                arg___stream: *mut FILE,
            ) -> ::std::os::raw::c_int;
        }
        fputc(arg___c, arg___stream)
    })
}
pub unsafe fn putc(
    arg___c: ::std::os::raw::c_int,
    arg___stream: *mut FILE,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn putc(
                arg___c: ::std::os::raw::c_int,
                arg___stream: *mut FILE,
            ) -> ::std::os::raw::c_int;
        }
        putc(arg___c, arg___stream)
    })
}
pub unsafe fn putchar(arg___c: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn putchar(arg___c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        putchar(arg___c)
    })
}
pub unsafe fn fputc_unlocked(
    arg___c: ::std::os::raw::c_int,
    arg___stream: *mut FILE,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fputc_unlocked(
                arg___c: ::std::os::raw::c_int,
                arg___stream: *mut FILE,
            ) -> ::std::os::raw::c_int;
        }
        fputc_unlocked(arg___c, arg___stream)
    })
}
pub unsafe fn putc_unlocked(
    arg___c: ::std::os::raw::c_int,
    arg___stream: *mut FILE,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn putc_unlocked(
                arg___c: ::std::os::raw::c_int,
                arg___stream: *mut FILE,
            ) -> ::std::os::raw::c_int;
        }
        putc_unlocked(arg___c, arg___stream)
    })
}
pub unsafe fn putchar_unlocked(arg___c: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn putchar_unlocked(arg___c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        putchar_unlocked(arg___c)
    })
}
pub unsafe fn getw(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getw(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        getw(arg___stream)
    })
}
pub unsafe fn putw(
    arg___w: ::std::os::raw::c_int,
    arg___stream: *mut FILE,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn putw(
                arg___w: ::std::os::raw::c_int,
                arg___stream: *mut FILE,
            ) -> ::std::os::raw::c_int;
        }
        putw(arg___w, arg___stream)
    })
}
pub unsafe fn fgets(
    arg___s: *mut ::std::os::raw::c_char,
    arg___n: ::std::os::raw::c_int,
    arg___stream: *mut FILE,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fgets(
                arg___s: *mut ::std::os::raw::c_char,
                arg___n: ::std::os::raw::c_int,
                arg___stream: *mut FILE,
            ) -> *mut ::std::os::raw::c_char;
        }
        fgets(arg___s, arg___n, arg___stream)
    })
}
pub unsafe fn __getdelim(
    arg___lineptr: *mut *mut ::std::os::raw::c_char,
    arg___n: *mut usize,
    arg___delimiter: ::std::os::raw::c_int,
    arg___stream: *mut FILE,
) -> __ssize_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __getdelim(
                arg___lineptr: *mut *mut ::std::os::raw::c_char,
                arg___n: *mut usize,
                arg___delimiter: ::std::os::raw::c_int,
                arg___stream: *mut FILE,
            ) -> __ssize_t;
        }
        __getdelim(arg___lineptr, arg___n, arg___delimiter, arg___stream)
    })
}
pub unsafe fn getdelim(
    arg___lineptr: *mut *mut ::std::os::raw::c_char,
    arg___n: *mut usize,
    arg___delimiter: ::std::os::raw::c_int,
    arg___stream: *mut FILE,
) -> __ssize_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getdelim(
                arg___lineptr: *mut *mut ::std::os::raw::c_char,
                arg___n: *mut usize,
                arg___delimiter: ::std::os::raw::c_int,
                arg___stream: *mut FILE,
            ) -> __ssize_t;
        }
        getdelim(arg___lineptr, arg___n, arg___delimiter, arg___stream)
    })
}
pub unsafe fn getline(
    arg___lineptr: *mut *mut ::std::os::raw::c_char,
    arg___n: *mut usize,
    arg___stream: *mut FILE,
) -> __ssize_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getline(
                arg___lineptr: *mut *mut ::std::os::raw::c_char,
                arg___n: *mut usize,
                arg___stream: *mut FILE,
            ) -> __ssize_t;
        }
        getline(arg___lineptr, arg___n, arg___stream)
    })
}
pub unsafe fn fputs(
    arg___s: *const ::std::os::raw::c_char,
    arg___stream: *mut FILE,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fputs(
                arg___s: *const ::std::os::raw::c_char,
                arg___stream: *mut FILE,
            ) -> ::std::os::raw::c_int;
        }
        fputs(arg___s, arg___stream)
    })
}
pub unsafe fn puts(arg___s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn puts(arg___s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        puts(arg___s)
    })
}
pub unsafe fn ungetc(
    arg___c: ::std::os::raw::c_int,
    arg___stream: *mut FILE,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ungetc(
                arg___c: ::std::os::raw::c_int,
                arg___stream: *mut FILE,
            ) -> ::std::os::raw::c_int;
        }
        ungetc(arg___c, arg___stream)
    })
}
pub unsafe fn fread(
    arg___ptr: *mut ::std::os::raw::c_void,
    arg___size: ::std::os::raw::c_ulong,
    arg___n: ::std::os::raw::c_ulong,
    arg___stream: *mut FILE,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fread(
                arg___ptr: *mut ::std::os::raw::c_void,
                arg___size: ::std::os::raw::c_ulong,
                arg___n: ::std::os::raw::c_ulong,
                arg___stream: *mut FILE,
            ) -> ::std::os::raw::c_ulong;
        }
        fread(arg___ptr, arg___size, arg___n, arg___stream)
    })
}
pub unsafe fn fwrite(
    arg___ptr: *const ::std::os::raw::c_void,
    arg___size: ::std::os::raw::c_ulong,
    arg___n: ::std::os::raw::c_ulong,
    arg___s: *mut FILE,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fwrite(
                arg___ptr: *const ::std::os::raw::c_void,
                arg___size: ::std::os::raw::c_ulong,
                arg___n: ::std::os::raw::c_ulong,
                arg___s: *mut FILE,
            ) -> ::std::os::raw::c_ulong;
        }
        fwrite(arg___ptr, arg___size, arg___n, arg___s)
    })
}
pub unsafe fn fread_unlocked(
    arg___ptr: *mut ::std::os::raw::c_void,
    arg___size: usize,
    arg___n: usize,
    arg___stream: *mut FILE,
) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fread_unlocked(
                arg___ptr: *mut ::std::os::raw::c_void,
                arg___size: usize,
                arg___n: usize,
                arg___stream: *mut FILE,
            ) -> usize;
        }
        fread_unlocked(arg___ptr, arg___size, arg___n, arg___stream)
    })
}
pub unsafe fn fwrite_unlocked(
    arg___ptr: *const ::std::os::raw::c_void,
    arg___size: usize,
    arg___n: usize,
    arg___stream: *mut FILE,
) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fwrite_unlocked(
                arg___ptr: *const ::std::os::raw::c_void,
                arg___size: usize,
                arg___n: usize,
                arg___stream: *mut FILE,
            ) -> usize;
        }
        fwrite_unlocked(arg___ptr, arg___size, arg___n, arg___stream)
    })
}
pub unsafe fn fseek(
    arg___stream: *mut FILE,
    arg___off: ::std::os::raw::c_long,
    arg___whence: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fseek(
                arg___stream: *mut FILE,
                arg___off: ::std::os::raw::c_long,
                arg___whence: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        fseek(arg___stream, arg___off, arg___whence)
    })
}
pub unsafe fn ftell(arg___stream: *mut FILE) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ftell(arg___stream: *mut FILE) -> ::std::os::raw::c_long;
        }
        ftell(arg___stream)
    })
}
pub unsafe fn rewind(arg___stream: *mut FILE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rewind(arg___stream: *mut FILE);
        }
        rewind(arg___stream)
    })
}
pub unsafe fn fseeko(
    arg___stream: *mut FILE,
    arg___off: __off_t,
    arg___whence: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fseeko(
                arg___stream: *mut FILE,
                arg___off: __off_t,
                arg___whence: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        fseeko(arg___stream, arg___off, arg___whence)
    })
}
pub unsafe fn ftello(arg___stream: *mut FILE) -> __off_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ftello(arg___stream: *mut FILE) -> __off_t;
        }
        ftello(arg___stream)
    })
}
pub unsafe fn fgetpos(arg___stream: *mut FILE, arg___pos: *mut fpos_t) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fgetpos(arg___stream: *mut FILE, arg___pos: *mut fpos_t) -> ::std::os::raw::c_int;
        }
        fgetpos(arg___stream, arg___pos)
    })
}
pub unsafe fn fsetpos(arg___stream: *mut FILE, arg___pos: *const fpos_t) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fsetpos(arg___stream: *mut FILE, arg___pos: *const fpos_t) -> ::std::os::raw::c_int;
        }
        fsetpos(arg___stream, arg___pos)
    })
}
pub unsafe fn clearerr(arg___stream: *mut FILE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clearerr(arg___stream: *mut FILE);
        }
        clearerr(arg___stream)
    })
}
pub unsafe fn feof(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn feof(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        feof(arg___stream)
    })
}
pub unsafe fn ferror(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ferror(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        ferror(arg___stream)
    })
}
pub unsafe fn clearerr_unlocked(arg___stream: *mut FILE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clearerr_unlocked(arg___stream: *mut FILE);
        }
        clearerr_unlocked(arg___stream)
    })
}
pub unsafe fn feof_unlocked(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn feof_unlocked(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        feof_unlocked(arg___stream)
    })
}
pub unsafe fn ferror_unlocked(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ferror_unlocked(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        ferror_unlocked(arg___stream)
    })
}
pub unsafe fn perror(arg___s: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn perror(arg___s: *const ::std::os::raw::c_char);
        }
        perror(arg___s)
    })
}
pub unsafe fn fileno(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fileno(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        fileno(arg___stream)
    })
}
pub unsafe fn fileno_unlocked(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fileno_unlocked(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        fileno_unlocked(arg___stream)
    })
}
pub unsafe fn pclose(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pclose(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        pclose(arg___stream)
    })
}
pub unsafe fn popen(
    arg___command: *const ::std::os::raw::c_char,
    arg___modes: *const ::std::os::raw::c_char,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn popen(
                arg___command: *const ::std::os::raw::c_char,
                arg___modes: *const ::std::os::raw::c_char,
            ) -> *mut FILE;
        }
        popen(arg___command, arg___modes)
    })
}
pub unsafe fn ctermid(arg___s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ctermid(arg___s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        ctermid(arg___s)
    })
}
pub unsafe fn flockfile(arg___stream: *mut FILE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn flockfile(arg___stream: *mut FILE);
        }
        flockfile(arg___stream)
    })
}
pub unsafe fn ftrylockfile(arg___stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ftrylockfile(arg___stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        ftrylockfile(arg___stream)
    })
}
pub unsafe fn funlockfile(arg___stream: *mut FILE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn funlockfile(arg___stream: *mut FILE);
        }
        funlockfile(arg___stream)
    })
}
pub unsafe fn __uflow(arg_arg1: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __uflow(arg_arg1: *mut FILE) -> ::std::os::raw::c_int;
        }
        __uflow(arg_arg1)
    })
}
pub unsafe fn __overflow(
    arg_arg1: *mut FILE,
    arg_arg2: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __overflow(
                arg_arg1: *mut FILE,
                arg_arg2: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        __overflow(arg_arg1, arg_arg2)
    })
}
pub type wchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
pub unsafe fn __ctype_get_mb_cur_max() -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ctype_get_mb_cur_max() -> usize;
        }
        __ctype_get_mb_cur_max()
    })
}
pub unsafe fn atof(arg___nptr: *const ::std::os::raw::c_char) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atof(arg___nptr: *const ::std::os::raw::c_char) -> f64;
        }
        atof(arg___nptr)
    })
}
pub unsafe fn atoi(arg___nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atoi(arg___nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        atoi(arg___nptr)
    })
}
pub unsafe fn atol(arg___nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atol(arg___nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
        }
        atol(arg___nptr)
    })
}
pub unsafe fn atoll(arg___nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atoll(arg___nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
        }
        atoll(arg___nptr)
    })
}
pub unsafe fn strtod(
    arg___nptr: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtod(
                arg___nptr: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
            ) -> f64;
        }
        strtod(arg___nptr, arg___endptr)
    })
}
pub unsafe fn strtof(
    arg___nptr: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtof(
                arg___nptr: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
            ) -> f32;
        }
        strtof(arg___nptr, arg___endptr)
    })
}
pub unsafe fn strtold(
    arg___nptr: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtold(
                arg___nptr: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
            ) -> u128;
        }
        strtold(arg___nptr, arg___endptr)
    })
}
pub unsafe fn strtol(
    arg___nptr: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
    arg___base: ::std::os::raw::c_int,
) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtol(
                arg___nptr: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
                arg___base: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_long;
        }
        strtol(arg___nptr, arg___endptr, arg___base)
    })
}
pub unsafe fn strtoul(
    arg___nptr: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
    arg___base: ::std::os::raw::c_int,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtoul(
                arg___nptr: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
                arg___base: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_ulong;
        }
        strtoul(arg___nptr, arg___endptr, arg___base)
    })
}
pub unsafe fn strtoq(
    arg___nptr: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
    arg___base: ::std::os::raw::c_int,
) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtoq(
                arg___nptr: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
                arg___base: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_longlong;
        }
        strtoq(arg___nptr, arg___endptr, arg___base)
    })
}
pub unsafe fn strtouq(
    arg___nptr: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
    arg___base: ::std::os::raw::c_int,
) -> ::std::os::raw::c_ulonglong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtouq(
                arg___nptr: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
                arg___base: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_ulonglong;
        }
        strtouq(arg___nptr, arg___endptr, arg___base)
    })
}
pub unsafe fn strtoll(
    arg___nptr: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
    arg___base: ::std::os::raw::c_int,
) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtoll(
                arg___nptr: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
                arg___base: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_longlong;
        }
        strtoll(arg___nptr, arg___endptr, arg___base)
    })
}
pub unsafe fn strtoull(
    arg___nptr: *const ::std::os::raw::c_char,
    arg___endptr: *mut *mut ::std::os::raw::c_char,
    arg___base: ::std::os::raw::c_int,
) -> ::std::os::raw::c_ulonglong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtoull(
                arg___nptr: *const ::std::os::raw::c_char,
                arg___endptr: *mut *mut ::std::os::raw::c_char,
                arg___base: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_ulonglong;
        }
        strtoull(arg___nptr, arg___endptr, arg___base)
    })
}
pub unsafe fn l64a(arg___n: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn l64a(arg___n: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
        }
        l64a(arg___n)
    })
}
pub unsafe fn a64l(arg___s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn a64l(arg___s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
        }
        a64l(arg___s)
    })
}
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type clockid_t = __clockid_t;
pub type time_t = __time_t;
pub type timer_t = __timer_t;
pub type ulong = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_int8_t = __uint8_t;
pub type u_int16_t = __uint16_t;
pub type u_int32_t = __uint32_t;
pub type u_int64_t = __uint64_t;
pub type register_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
pub type fd_mask = __fd_mask;
pub unsafe fn select(
    arg___nfds: ::std::os::raw::c_int,
    arg___readfds: *mut fd_set,
    arg___writefds: *mut fd_set,
    arg___exceptfds: *mut fd_set,
    arg___timeout: *mut timeval,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn select(
                arg___nfds: ::std::os::raw::c_int,
                arg___readfds: *mut fd_set,
                arg___writefds: *mut fd_set,
                arg___exceptfds: *mut fd_set,
                arg___timeout: *mut timeval,
            ) -> ::std::os::raw::c_int;
        }
        select(
            arg___nfds,
            arg___readfds,
            arg___writefds,
            arg___exceptfds,
            arg___timeout,
        )
    })
}
pub unsafe fn pselect(
    arg___nfds: ::std::os::raw::c_int,
    arg___readfds: *mut fd_set,
    arg___writefds: *mut fd_set,
    arg___exceptfds: *mut fd_set,
    arg___timeout: *const timespec,
    arg___sigmask: *const __sigset_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pselect(
                arg___nfds: ::std::os::raw::c_int,
                arg___readfds: *mut fd_set,
                arg___writefds: *mut fd_set,
                arg___exceptfds: *mut fd_set,
                arg___timeout: *const timespec,
                arg___sigmask: *const __sigset_t,
            ) -> ::std::os::raw::c_int;
        }
        pselect(
            arg___nfds,
            arg___readfds,
            arg___writefds,
            arg___exceptfds,
            arg___timeout,
            arg___sigmask,
        )
    })
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __atomic_wide_counter {
    pub __value64: ::std::os::raw::c_ulonglong,
    pub __value32: __atomic_wide_counter__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __atomic_wide_counter__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
impl Default for __atomic_wide_counter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
impl Default for __pthread_internal_list {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_slist {
    pub __next: *mut __pthread_internal_slist,
}
impl Default for __pthread_internal_slist {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __pthread_slist_t = __pthread_internal_slist;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
impl Default for __pthread_mutex_s {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __pthread_rwlock_arch_t {
    pub __readers: ::std::os::raw::c_uint,
    pub __writers: ::std::os::raw::c_uint,
    pub __wrphase_futex: ::std::os::raw::c_uint,
    pub __writers_futex: ::std::os::raw::c_uint,
    pub __pad3: ::std::os::raw::c_uint,
    pub __pad4: ::std::os::raw::c_uint,
    pub __cur_writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __wseq: __atomic_wide_counter,
    pub __g1_start: __atomic_wide_counter,
    pub __g_refs: [::std::os::raw::c_uint; 2usize],
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
impl Default for __pthread_cond_s {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __tss_t = ::std::os::raw::c_uint;
pub type __thrd_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __once_flag {
    pub __data: ::std::os::raw::c_int,
}
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
impl Default for pthread_mutexattr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
impl Default for pthread_condattr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_attr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_mutex_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
impl Default for pthread_cond_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: __pthread_rwlock_arch_t,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_rwlock_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::std::os::raw::c_char; 8usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_rwlockattr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_barrier_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
impl Default for pthread_barrierattr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn random() -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn random() -> ::std::os::raw::c_long;
        }
        random()
    })
}
pub unsafe fn srandom(arg___seed: ::std::os::raw::c_uint) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn srandom(arg___seed: ::std::os::raw::c_uint);
        }
        srandom(arg___seed)
    })
}
pub unsafe fn initstate(
    arg___seed: ::std::os::raw::c_uint,
    arg___statebuf: *mut ::std::os::raw::c_char,
    arg___statelen: usize,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn initstate(
                arg___seed: ::std::os::raw::c_uint,
                arg___statebuf: *mut ::std::os::raw::c_char,
                arg___statelen: usize,
            ) -> *mut ::std::os::raw::c_char;
        }
        initstate(arg___seed, arg___statebuf, arg___statelen)
    })
}
pub unsafe fn setstate(arg___statebuf: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setstate(arg___statebuf: *mut ::std::os::raw::c_char)
                -> *mut ::std::os::raw::c_char;
        }
        setstate(arg___statebuf)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct random_data {
    pub fptr: *mut i32,
    pub rptr: *mut i32,
    pub state: *mut i32,
    pub rand_type: ::std::os::raw::c_int,
    pub rand_deg: ::std::os::raw::c_int,
    pub rand_sep: ::std::os::raw::c_int,
    pub end_ptr: *mut i32,
}
impl Default for random_data {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn random_r(
    arg___buf: *mut random_data,
    arg___result: *mut i32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn random_r(
                arg___buf: *mut random_data,
                arg___result: *mut i32,
            ) -> ::std::os::raw::c_int;
        }
        random_r(arg___buf, arg___result)
    })
}
pub unsafe fn srandom_r(
    arg___seed: ::std::os::raw::c_uint,
    arg___buf: *mut random_data,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn srandom_r(
                arg___seed: ::std::os::raw::c_uint,
                arg___buf: *mut random_data,
            ) -> ::std::os::raw::c_int;
        }
        srandom_r(arg___seed, arg___buf)
    })
}
pub unsafe fn initstate_r(
    arg___seed: ::std::os::raw::c_uint,
    arg___statebuf: *mut ::std::os::raw::c_char,
    arg___statelen: usize,
    arg___buf: *mut random_data,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn initstate_r(
                arg___seed: ::std::os::raw::c_uint,
                arg___statebuf: *mut ::std::os::raw::c_char,
                arg___statelen: usize,
                arg___buf: *mut random_data,
            ) -> ::std::os::raw::c_int;
        }
        initstate_r(arg___seed, arg___statebuf, arg___statelen, arg___buf)
    })
}
pub unsafe fn setstate_r(
    arg___statebuf: *mut ::std::os::raw::c_char,
    arg___buf: *mut random_data,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setstate_r(
                arg___statebuf: *mut ::std::os::raw::c_char,
                arg___buf: *mut random_data,
            ) -> ::std::os::raw::c_int;
        }
        setstate_r(arg___statebuf, arg___buf)
    })
}
pub unsafe fn rand() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rand() -> ::std::os::raw::c_int;
        }
        rand()
    })
}
pub unsafe fn srand(arg___seed: ::std::os::raw::c_uint) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn srand(arg___seed: ::std::os::raw::c_uint);
        }
        srand(arg___seed)
    })
}
pub unsafe fn rand_r(arg___seed: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rand_r(arg___seed: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
        }
        rand_r(arg___seed)
    })
}
pub unsafe fn drand48() -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn drand48() -> f64;
        }
        drand48()
    })
}
pub unsafe fn erand48(arg___xsubi: *mut ::std::os::raw::c_ushort) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erand48(arg___xsubi: *mut ::std::os::raw::c_ushort) -> f64;
        }
        erand48(arg___xsubi)
    })
}
pub unsafe fn lrand48() -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lrand48() -> ::std::os::raw::c_long;
        }
        lrand48()
    })
}
pub unsafe fn nrand48(arg___xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nrand48(arg___xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
        }
        nrand48(arg___xsubi)
    })
}
pub unsafe fn mrand48() -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mrand48() -> ::std::os::raw::c_long;
        }
        mrand48()
    })
}
pub unsafe fn jrand48(arg___xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn jrand48(arg___xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
        }
        jrand48(arg___xsubi)
    })
}
pub unsafe fn srand48(arg___seedval: ::std::os::raw::c_long) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn srand48(arg___seedval: ::std::os::raw::c_long);
        }
        srand48(arg___seedval)
    })
}
pub unsafe fn seed48(
    arg___seed16v: *mut ::std::os::raw::c_ushort,
) -> *mut ::std::os::raw::c_ushort {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn seed48(
                arg___seed16v: *mut ::std::os::raw::c_ushort,
            ) -> *mut ::std::os::raw::c_ushort;
        }
        seed48(arg___seed16v)
    })
}
pub unsafe fn lcong48(arg___param: *mut ::std::os::raw::c_ushort) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lcong48(arg___param: *mut ::std::os::raw::c_ushort);
        }
        lcong48(arg___param)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drand48_data {
    pub __x: [::std::os::raw::c_ushort; 3usize],
    pub __old_x: [::std::os::raw::c_ushort; 3usize],
    pub __c: ::std::os::raw::c_ushort,
    pub __init: ::std::os::raw::c_ushort,
    pub __a: ::std::os::raw::c_ulonglong,
}
pub unsafe fn drand48_r(
    arg___buffer: *mut drand48_data,
    arg___result: *mut f64,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn drand48_r(
                arg___buffer: *mut drand48_data,
                arg___result: *mut f64,
            ) -> ::std::os::raw::c_int;
        }
        drand48_r(arg___buffer, arg___result)
    })
}
pub unsafe fn erand48_r(
    arg___xsubi: *mut ::std::os::raw::c_ushort,
    arg___buffer: *mut drand48_data,
    arg___result: *mut f64,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erand48_r(
                arg___xsubi: *mut ::std::os::raw::c_ushort,
                arg___buffer: *mut drand48_data,
                arg___result: *mut f64,
            ) -> ::std::os::raw::c_int;
        }
        erand48_r(arg___xsubi, arg___buffer, arg___result)
    })
}
pub unsafe fn lrand48_r(
    arg___buffer: *mut drand48_data,
    arg___result: *mut ::std::os::raw::c_long,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lrand48_r(
                arg___buffer: *mut drand48_data,
                arg___result: *mut ::std::os::raw::c_long,
            ) -> ::std::os::raw::c_int;
        }
        lrand48_r(arg___buffer, arg___result)
    })
}
pub unsafe fn nrand48_r(
    arg___xsubi: *mut ::std::os::raw::c_ushort,
    arg___buffer: *mut drand48_data,
    arg___result: *mut ::std::os::raw::c_long,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nrand48_r(
                arg___xsubi: *mut ::std::os::raw::c_ushort,
                arg___buffer: *mut drand48_data,
                arg___result: *mut ::std::os::raw::c_long,
            ) -> ::std::os::raw::c_int;
        }
        nrand48_r(arg___xsubi, arg___buffer, arg___result)
    })
}
pub unsafe fn mrand48_r(
    arg___buffer: *mut drand48_data,
    arg___result: *mut ::std::os::raw::c_long,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mrand48_r(
                arg___buffer: *mut drand48_data,
                arg___result: *mut ::std::os::raw::c_long,
            ) -> ::std::os::raw::c_int;
        }
        mrand48_r(arg___buffer, arg___result)
    })
}
pub unsafe fn jrand48_r(
    arg___xsubi: *mut ::std::os::raw::c_ushort,
    arg___buffer: *mut drand48_data,
    arg___result: *mut ::std::os::raw::c_long,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn jrand48_r(
                arg___xsubi: *mut ::std::os::raw::c_ushort,
                arg___buffer: *mut drand48_data,
                arg___result: *mut ::std::os::raw::c_long,
            ) -> ::std::os::raw::c_int;
        }
        jrand48_r(arg___xsubi, arg___buffer, arg___result)
    })
}
pub unsafe fn srand48_r(
    arg___seedval: ::std::os::raw::c_long,
    arg___buffer: *mut drand48_data,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn srand48_r(
                arg___seedval: ::std::os::raw::c_long,
                arg___buffer: *mut drand48_data,
            ) -> ::std::os::raw::c_int;
        }
        srand48_r(arg___seedval, arg___buffer)
    })
}
pub unsafe fn seed48_r(
    arg___seed16v: *mut ::std::os::raw::c_ushort,
    arg___buffer: *mut drand48_data,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn seed48_r(
                arg___seed16v: *mut ::std::os::raw::c_ushort,
                arg___buffer: *mut drand48_data,
            ) -> ::std::os::raw::c_int;
        }
        seed48_r(arg___seed16v, arg___buffer)
    })
}
pub unsafe fn lcong48_r(
    arg___param: *mut ::std::os::raw::c_ushort,
    arg___buffer: *mut drand48_data,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lcong48_r(
                arg___param: *mut ::std::os::raw::c_ushort,
                arg___buffer: *mut drand48_data,
            ) -> ::std::os::raw::c_int;
        }
        lcong48_r(arg___param, arg___buffer)
    })
}
pub unsafe fn arc4random() -> __uint32_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn arc4random() -> __uint32_t;
        }
        arc4random()
    })
}
pub unsafe fn arc4random_buf(arg___buf: *mut ::std::os::raw::c_void, arg___size: usize) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn arc4random_buf(arg___buf: *mut ::std::os::raw::c_void, arg___size: usize);
        }
        arc4random_buf(arg___buf, arg___size)
    })
}
pub unsafe fn arc4random_uniform(arg___upper_bound: __uint32_t) -> __uint32_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn arc4random_uniform(arg___upper_bound: __uint32_t) -> __uint32_t;
        }
        arc4random_uniform(arg___upper_bound)
    })
}
pub unsafe fn malloc(arg___size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn malloc(arg___size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
        }
        malloc(arg___size)
    })
}
pub unsafe fn calloc(
    arg___nmemb: ::std::os::raw::c_ulong,
    arg___size: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn calloc(
                arg___nmemb: ::std::os::raw::c_ulong,
                arg___size: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        calloc(arg___nmemb, arg___size)
    })
}
pub unsafe fn realloc(
    arg___ptr: *mut ::std::os::raw::c_void,
    arg___size: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn realloc(
                arg___ptr: *mut ::std::os::raw::c_void,
                arg___size: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        realloc(arg___ptr, arg___size)
    })
}
pub unsafe fn free(arg___ptr: *mut ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn free(arg___ptr: *mut ::std::os::raw::c_void);
        }
        free(arg___ptr)
    })
}
pub unsafe fn reallocarray(
    arg___ptr: *mut ::std::os::raw::c_void,
    arg___nmemb: usize,
    arg___size: usize,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn reallocarray(
                arg___ptr: *mut ::std::os::raw::c_void,
                arg___nmemb: usize,
                arg___size: usize,
            ) -> *mut ::std::os::raw::c_void;
        }
        reallocarray(arg___ptr, arg___nmemb, arg___size)
    })
}
pub unsafe fn alloca(arg___size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn alloca(arg___size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
        }
        alloca(arg___size)
    })
}
pub unsafe fn valloc(arg___size: usize) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn valloc(arg___size: usize) -> *mut ::std::os::raw::c_void;
        }
        valloc(arg___size)
    })
}
pub unsafe fn posix_memalign(
    arg___memptr: *mut *mut ::std::os::raw::c_void,
    arg___alignment: usize,
    arg___size: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn posix_memalign(
                arg___memptr: *mut *mut ::std::os::raw::c_void,
                arg___alignment: usize,
                arg___size: usize,
            ) -> ::std::os::raw::c_int;
        }
        posix_memalign(arg___memptr, arg___alignment, arg___size)
    })
}
pub unsafe fn aligned_alloc(
    arg___alignment: ::std::os::raw::c_ulong,
    arg___size: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn aligned_alloc(
                arg___alignment: ::std::os::raw::c_ulong,
                arg___size: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        aligned_alloc(arg___alignment, arg___size)
    })
}
pub unsafe fn abort() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn abort();
        }
        abort()
    })
}
pub unsafe fn atexit(
    arg___func: ::std::option::Option<unsafe extern "C" fn()>,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atexit(
                arg___func: ::std::option::Option<unsafe extern "C" fn()>,
            ) -> ::std::os::raw::c_int;
        }
        atexit(arg___func)
    })
}
pub unsafe fn at_quick_exit(
    arg___func: ::std::option::Option<unsafe extern "C" fn()>,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn at_quick_exit(
                arg___func: ::std::option::Option<unsafe extern "C" fn()>,
            ) -> ::std::os::raw::c_int;
        }
        at_quick_exit(arg___func)
    })
}
pub unsafe fn on_exit(
    arg___func: ::std::option::Option<
        unsafe extern "C" fn(__status: ::std::os::raw::c_int, __arg: *mut ::std::os::raw::c_void),
    >,
    arg___arg: *mut ::std::os::raw::c_void,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn on_exit(
                arg___func: ::std::option::Option<
                    unsafe extern "C" fn(
                        __status: ::std::os::raw::c_int,
                        __arg: *mut ::std::os::raw::c_void,
                    ),
                >,
                arg___arg: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int;
        }
        on_exit(arg___func, arg___arg)
    })
}
pub unsafe fn exit(arg___status: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn exit(arg___status: ::std::os::raw::c_int);
        }
        exit(arg___status)
    })
}
pub unsafe fn quick_exit(arg___status: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn quick_exit(arg___status: ::std::os::raw::c_int);
        }
        quick_exit(arg___status)
    })
}
pub unsafe fn _Exit(arg___status: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn _Exit(arg___status: ::std::os::raw::c_int);
        }
        _Exit(arg___status)
    })
}
pub unsafe fn getenv(arg___name: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getenv(arg___name: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        getenv(arg___name)
    })
}
pub unsafe fn putenv(arg___string: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn putenv(arg___string: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        putenv(arg___string)
    })
}
pub unsafe fn setenv(
    arg___name: *const ::std::os::raw::c_char,
    arg___value: *const ::std::os::raw::c_char,
    arg___replace: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setenv(
                arg___name: *const ::std::os::raw::c_char,
                arg___value: *const ::std::os::raw::c_char,
                arg___replace: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        setenv(arg___name, arg___value, arg___replace)
    })
}
pub unsafe fn unsetenv(arg___name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn unsetenv(arg___name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        unsetenv(arg___name)
    })
}
pub unsafe fn clearenv() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clearenv() -> ::std::os::raw::c_int;
        }
        clearenv()
    })
}
pub unsafe fn mktemp(arg___template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mktemp(arg___template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        mktemp(arg___template)
    })
}
pub unsafe fn mkstemp(arg___template: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mkstemp(arg___template: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        mkstemp(arg___template)
    })
}
pub unsafe fn mkstemps(
    arg___template: *mut ::std::os::raw::c_char,
    arg___suffixlen: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mkstemps(
                arg___template: *mut ::std::os::raw::c_char,
                arg___suffixlen: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        mkstemps(arg___template, arg___suffixlen)
    })
}
pub unsafe fn mkdtemp(arg___template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mkdtemp(arg___template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        mkdtemp(arg___template)
    })
}
pub unsafe fn system(arg___command: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn system(arg___command: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        system(arg___command)
    })
}
pub unsafe fn realpath(
    arg___name: *const ::std::os::raw::c_char,
    arg___resolved: *mut ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn realpath(
                arg___name: *const ::std::os::raw::c_char,
                arg___resolved: *mut ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        realpath(arg___name, arg___resolved)
    })
}
pub type __compar_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub unsafe fn bsearch(
    arg___key: *const ::std::os::raw::c_void,
    arg___base: *const ::std::os::raw::c_void,
    arg___nmemb: usize,
    arg___size: usize,
    arg___compar: __compar_fn_t,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bsearch(
                arg___key: *const ::std::os::raw::c_void,
                arg___base: *const ::std::os::raw::c_void,
                arg___nmemb: usize,
                arg___size: usize,
                arg___compar: __compar_fn_t,
            ) -> *mut ::std::os::raw::c_void;
        }
        bsearch(arg___key, arg___base, arg___nmemb, arg___size, arg___compar)
    })
}
pub unsafe fn qsort(
    arg___base: *mut ::std::os::raw::c_void,
    arg___nmemb: usize,
    arg___size: usize,
    arg___compar: __compar_fn_t,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn qsort(
                arg___base: *mut ::std::os::raw::c_void,
                arg___nmemb: usize,
                arg___size: usize,
                arg___compar: __compar_fn_t,
            );
        }
        qsort(arg___base, arg___nmemb, arg___size, arg___compar)
    })
}
pub unsafe fn abs(arg___x: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn abs(arg___x: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        abs(arg___x)
    })
}
pub unsafe fn labs(arg___x: ::std::os::raw::c_long) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn labs(arg___x: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
        }
        labs(arg___x)
    })
}
pub unsafe fn llabs(arg___x: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn llabs(arg___x: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
        }
        llabs(arg___x)
    })
}
pub unsafe fn div(arg___numer: ::std::os::raw::c_int, arg___denom: ::std::os::raw::c_int) -> div_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn div(arg___numer: ::std::os::raw::c_int, arg___denom: ::std::os::raw::c_int)
                -> div_t;
        }
        div(arg___numer, arg___denom)
    })
}
pub unsafe fn ldiv(
    arg___numer: ::std::os::raw::c_long,
    arg___denom: ::std::os::raw::c_long,
) -> ldiv_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ldiv(
                arg___numer: ::std::os::raw::c_long,
                arg___denom: ::std::os::raw::c_long,
            ) -> ldiv_t;
        }
        ldiv(arg___numer, arg___denom)
    })
}
pub unsafe fn lldiv(
    arg___numer: ::std::os::raw::c_longlong,
    arg___denom: ::std::os::raw::c_longlong,
) -> lldiv_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lldiv(
                arg___numer: ::std::os::raw::c_longlong,
                arg___denom: ::std::os::raw::c_longlong,
            ) -> lldiv_t;
        }
        lldiv(arg___numer, arg___denom)
    })
}
pub unsafe fn ecvt(
    arg___value: f64,
    arg___ndigit: ::std::os::raw::c_int,
    arg___decpt: *mut ::std::os::raw::c_int,
    arg___sign: *mut ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ecvt(
                arg___value: f64,
                arg___ndigit: ::std::os::raw::c_int,
                arg___decpt: *mut ::std::os::raw::c_int,
                arg___sign: *mut ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        ecvt(arg___value, arg___ndigit, arg___decpt, arg___sign)
    })
}
pub unsafe fn fcvt(
    arg___value: f64,
    arg___ndigit: ::std::os::raw::c_int,
    arg___decpt: *mut ::std::os::raw::c_int,
    arg___sign: *mut ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fcvt(
                arg___value: f64,
                arg___ndigit: ::std::os::raw::c_int,
                arg___decpt: *mut ::std::os::raw::c_int,
                arg___sign: *mut ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        fcvt(arg___value, arg___ndigit, arg___decpt, arg___sign)
    })
}
pub unsafe fn gcvt(
    arg___value: f64,
    arg___ndigit: ::std::os::raw::c_int,
    arg___buf: *mut ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gcvt(
                arg___value: f64,
                arg___ndigit: ::std::os::raw::c_int,
                arg___buf: *mut ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        gcvt(arg___value, arg___ndigit, arg___buf)
    })
}
pub unsafe fn qecvt(
    arg___value: u128,
    arg___ndigit: ::std::os::raw::c_int,
    arg___decpt: *mut ::std::os::raw::c_int,
    arg___sign: *mut ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn qecvt(
                arg___value: u128,
                arg___ndigit: ::std::os::raw::c_int,
                arg___decpt: *mut ::std::os::raw::c_int,
                arg___sign: *mut ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        qecvt(arg___value, arg___ndigit, arg___decpt, arg___sign)
    })
}
pub unsafe fn qfcvt(
    arg___value: u128,
    arg___ndigit: ::std::os::raw::c_int,
    arg___decpt: *mut ::std::os::raw::c_int,
    arg___sign: *mut ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn qfcvt(
                arg___value: u128,
                arg___ndigit: ::std::os::raw::c_int,
                arg___decpt: *mut ::std::os::raw::c_int,
                arg___sign: *mut ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        qfcvt(arg___value, arg___ndigit, arg___decpt, arg___sign)
    })
}
pub unsafe fn qgcvt(
    arg___value: u128,
    arg___ndigit: ::std::os::raw::c_int,
    arg___buf: *mut ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn qgcvt(
                arg___value: u128,
                arg___ndigit: ::std::os::raw::c_int,
                arg___buf: *mut ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        qgcvt(arg___value, arg___ndigit, arg___buf)
    })
}
pub unsafe fn ecvt_r(
    arg___value: f64,
    arg___ndigit: ::std::os::raw::c_int,
    arg___decpt: *mut ::std::os::raw::c_int,
    arg___sign: *mut ::std::os::raw::c_int,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___len: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ecvt_r(
                arg___value: f64,
                arg___ndigit: ::std::os::raw::c_int,
                arg___decpt: *mut ::std::os::raw::c_int,
                arg___sign: *mut ::std::os::raw::c_int,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___len: usize,
            ) -> ::std::os::raw::c_int;
        }
        ecvt_r(
            arg___value,
            arg___ndigit,
            arg___decpt,
            arg___sign,
            arg___buf,
            arg___len,
        )
    })
}
pub unsafe fn fcvt_r(
    arg___value: f64,
    arg___ndigit: ::std::os::raw::c_int,
    arg___decpt: *mut ::std::os::raw::c_int,
    arg___sign: *mut ::std::os::raw::c_int,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___len: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fcvt_r(
                arg___value: f64,
                arg___ndigit: ::std::os::raw::c_int,
                arg___decpt: *mut ::std::os::raw::c_int,
                arg___sign: *mut ::std::os::raw::c_int,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___len: usize,
            ) -> ::std::os::raw::c_int;
        }
        fcvt_r(
            arg___value,
            arg___ndigit,
            arg___decpt,
            arg___sign,
            arg___buf,
            arg___len,
        )
    })
}
pub unsafe fn qecvt_r(
    arg___value: u128,
    arg___ndigit: ::std::os::raw::c_int,
    arg___decpt: *mut ::std::os::raw::c_int,
    arg___sign: *mut ::std::os::raw::c_int,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___len: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn qecvt_r(
                arg___value: u128,
                arg___ndigit: ::std::os::raw::c_int,
                arg___decpt: *mut ::std::os::raw::c_int,
                arg___sign: *mut ::std::os::raw::c_int,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___len: usize,
            ) -> ::std::os::raw::c_int;
        }
        qecvt_r(
            arg___value,
            arg___ndigit,
            arg___decpt,
            arg___sign,
            arg___buf,
            arg___len,
        )
    })
}
pub unsafe fn qfcvt_r(
    arg___value: u128,
    arg___ndigit: ::std::os::raw::c_int,
    arg___decpt: *mut ::std::os::raw::c_int,
    arg___sign: *mut ::std::os::raw::c_int,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___len: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn qfcvt_r(
                arg___value: u128,
                arg___ndigit: ::std::os::raw::c_int,
                arg___decpt: *mut ::std::os::raw::c_int,
                arg___sign: *mut ::std::os::raw::c_int,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___len: usize,
            ) -> ::std::os::raw::c_int;
        }
        qfcvt_r(
            arg___value,
            arg___ndigit,
            arg___decpt,
            arg___sign,
            arg___buf,
            arg___len,
        )
    })
}
pub unsafe fn mblen(
    arg___s: *const ::std::os::raw::c_char,
    arg___n: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mblen(
                arg___s: *const ::std::os::raw::c_char,
                arg___n: usize,
            ) -> ::std::os::raw::c_int;
        }
        mblen(arg___s, arg___n)
    })
}
pub unsafe fn mbtowc(
    arg___pwc: *mut wchar_t,
    arg___s: *const ::std::os::raw::c_char,
    arg___n: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mbtowc(
                arg___pwc: *mut wchar_t,
                arg___s: *const ::std::os::raw::c_char,
                arg___n: usize,
            ) -> ::std::os::raw::c_int;
        }
        mbtowc(arg___pwc, arg___s, arg___n)
    })
}
pub unsafe fn wctomb(
    arg___s: *mut ::std::os::raw::c_char,
    arg___wchar: wchar_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wctomb(
                arg___s: *mut ::std::os::raw::c_char,
                arg___wchar: wchar_t,
            ) -> ::std::os::raw::c_int;
        }
        wctomb(arg___s, arg___wchar)
    })
}
pub unsafe fn mbstowcs(
    arg___pwcs: *mut wchar_t,
    arg___s: *const ::std::os::raw::c_char,
    arg___n: usize,
) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mbstowcs(
                arg___pwcs: *mut wchar_t,
                arg___s: *const ::std::os::raw::c_char,
                arg___n: usize,
            ) -> usize;
        }
        mbstowcs(arg___pwcs, arg___s, arg___n)
    })
}
pub unsafe fn wcstombs(
    arg___s: *mut ::std::os::raw::c_char,
    arg___pwcs: *const wchar_t,
    arg___n: usize,
) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wcstombs(
                arg___s: *mut ::std::os::raw::c_char,
                arg___pwcs: *const wchar_t,
                arg___n: usize,
            ) -> usize;
        }
        wcstombs(arg___s, arg___pwcs, arg___n)
    })
}
pub unsafe fn rpmatch(arg___response: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rpmatch(arg___response: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        rpmatch(arg___response)
    })
}
pub unsafe fn getsubopt(
    arg___optionp: *mut *mut ::std::os::raw::c_char,
    arg___tokens: *const *mut ::std::os::raw::c_char,
    arg___valuep: *mut *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getsubopt(
                arg___optionp: *mut *mut ::std::os::raw::c_char,
                arg___tokens: *const *mut ::std::os::raw::c_char,
                arg___valuep: *mut *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        getsubopt(arg___optionp, arg___tokens, arg___valuep)
    })
}
pub unsafe fn getloadavg(
    arg___loadavg: *mut f64,
    arg___nelem: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getloadavg(
                arg___loadavg: *mut f64,
                arg___nelem: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        getloadavg(arg___loadavg, arg___nelem)
    })
}
pub unsafe fn memcpy(
    arg___dest: *mut ::std::os::raw::c_void,
    arg___src: *const ::std::os::raw::c_void,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memcpy(
                arg___dest: *mut ::std::os::raw::c_void,
                arg___src: *const ::std::os::raw::c_void,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        memcpy(arg___dest, arg___src, arg___n)
    })
}
pub unsafe fn memmove(
    arg___dest: *mut ::std::os::raw::c_void,
    arg___src: *const ::std::os::raw::c_void,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memmove(
                arg___dest: *mut ::std::os::raw::c_void,
                arg___src: *const ::std::os::raw::c_void,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        memmove(arg___dest, arg___src, arg___n)
    })
}
pub unsafe fn memccpy(
    arg___dest: *mut ::std::os::raw::c_void,
    arg___src: *const ::std::os::raw::c_void,
    arg___c: ::std::os::raw::c_int,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memccpy(
                arg___dest: *mut ::std::os::raw::c_void,
                arg___src: *const ::std::os::raw::c_void,
                arg___c: ::std::os::raw::c_int,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        memccpy(arg___dest, arg___src, arg___c, arg___n)
    })
}
pub unsafe fn memset(
    arg___s: *mut ::std::os::raw::c_void,
    arg___c: ::std::os::raw::c_int,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memset(
                arg___s: *mut ::std::os::raw::c_void,
                arg___c: ::std::os::raw::c_int,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        memset(arg___s, arg___c, arg___n)
    })
}
pub unsafe fn memcmp(
    arg___s1: *const ::std::os::raw::c_void,
    arg___s2: *const ::std::os::raw::c_void,
    arg___n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memcmp(
                arg___s1: *const ::std::os::raw::c_void,
                arg___s2: *const ::std::os::raw::c_void,
                arg___n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        memcmp(arg___s1, arg___s2, arg___n)
    })
}
pub unsafe fn __memcmpeq(
    arg___s1: *const ::std::os::raw::c_void,
    arg___s2: *const ::std::os::raw::c_void,
    arg___n: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __memcmpeq(
                arg___s1: *const ::std::os::raw::c_void,
                arg___s2: *const ::std::os::raw::c_void,
                arg___n: usize,
            ) -> ::std::os::raw::c_int;
        }
        __memcmpeq(arg___s1, arg___s2, arg___n)
    })
}
pub unsafe fn memchr(
    arg___s: *const ::std::os::raw::c_void,
    arg___c: ::std::os::raw::c_int,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn memchr(
                arg___s: *const ::std::os::raw::c_void,
                arg___c: ::std::os::raw::c_int,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_void;
        }
        memchr(arg___s, arg___c, arg___n)
    })
}
pub unsafe fn strcpy(
    arg___dest: *mut ::std::os::raw::c_char,
    arg___src: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcpy(
                arg___dest: *mut ::std::os::raw::c_char,
                arg___src: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strcpy(arg___dest, arg___src)
    })
}
pub unsafe fn strncpy(
    arg___dest: *mut ::std::os::raw::c_char,
    arg___src: *const ::std::os::raw::c_char,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strncpy(
                arg___dest: *mut ::std::os::raw::c_char,
                arg___src: *const ::std::os::raw::c_char,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_char;
        }
        strncpy(arg___dest, arg___src, arg___n)
    })
}
pub unsafe fn strcat(
    arg___dest: *mut ::std::os::raw::c_char,
    arg___src: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcat(
                arg___dest: *mut ::std::os::raw::c_char,
                arg___src: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strcat(arg___dest, arg___src)
    })
}
pub unsafe fn strncat(
    arg___dest: *mut ::std::os::raw::c_char,
    arg___src: *const ::std::os::raw::c_char,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strncat(
                arg___dest: *mut ::std::os::raw::c_char,
                arg___src: *const ::std::os::raw::c_char,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_char;
        }
        strncat(arg___dest, arg___src, arg___n)
    })
}
pub unsafe fn strcmp(
    arg___s1: *const ::std::os::raw::c_char,
    arg___s2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcmp(
                arg___s1: *const ::std::os::raw::c_char,
                arg___s2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        strcmp(arg___s1, arg___s2)
    })
}
pub unsafe fn strncmp(
    arg___s1: *const ::std::os::raw::c_char,
    arg___s2: *const ::std::os::raw::c_char,
    arg___n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strncmp(
                arg___s1: *const ::std::os::raw::c_char,
                arg___s2: *const ::std::os::raw::c_char,
                arg___n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        strncmp(arg___s1, arg___s2, arg___n)
    })
}
pub unsafe fn strcoll(
    arg___s1: *const ::std::os::raw::c_char,
    arg___s2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcoll(
                arg___s1: *const ::std::os::raw::c_char,
                arg___s2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        strcoll(arg___s1, arg___s2)
    })
}
pub unsafe fn strxfrm(
    arg___dest: *mut ::std::os::raw::c_char,
    arg___src: *const ::std::os::raw::c_char,
    arg___n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strxfrm(
                arg___dest: *mut ::std::os::raw::c_char,
                arg___src: *const ::std::os::raw::c_char,
                arg___n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_ulong;
        }
        strxfrm(arg___dest, arg___src, arg___n)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_struct {
    pub __locales: [*mut __locale_data; 13usize],
    pub __ctype_b: *const ::std::os::raw::c_ushort,
    pub __ctype_tolower: *const ::std::os::raw::c_int,
    pub __ctype_toupper: *const ::std::os::raw::c_int,
    pub __names: [*const ::std::os::raw::c_char; 13usize],
}
impl Default for __locale_struct {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __locale_t = *mut __locale_struct;
pub type locale_t = __locale_t;
pub unsafe fn strcoll_l(
    arg___s1: *const ::std::os::raw::c_char,
    arg___s2: *const ::std::os::raw::c_char,
    arg___l: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcoll_l(
                arg___s1: *const ::std::os::raw::c_char,
                arg___s2: *const ::std::os::raw::c_char,
                arg___l: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        strcoll_l(arg___s1, arg___s2, arg___l)
    })
}
pub unsafe fn strxfrm_l(
    arg___dest: *mut ::std::os::raw::c_char,
    arg___src: *const ::std::os::raw::c_char,
    arg___n: usize,
    arg___l: locale_t,
) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strxfrm_l(
                arg___dest: *mut ::std::os::raw::c_char,
                arg___src: *const ::std::os::raw::c_char,
                arg___n: usize,
                arg___l: locale_t,
            ) -> usize;
        }
        strxfrm_l(arg___dest, arg___src, arg___n, arg___l)
    })
}
pub unsafe fn strdup(arg___s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strdup(arg___s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        strdup(arg___s)
    })
}
pub unsafe fn strndup(
    arg___string: *const ::std::os::raw::c_char,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strndup(
                arg___string: *const ::std::os::raw::c_char,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_char;
        }
        strndup(arg___string, arg___n)
    })
}
pub unsafe fn strchr(
    arg___s: *const ::std::os::raw::c_char,
    arg___c: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strchr(
                arg___s: *const ::std::os::raw::c_char,
                arg___c: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        strchr(arg___s, arg___c)
    })
}
pub unsafe fn strrchr(
    arg___s: *const ::std::os::raw::c_char,
    arg___c: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strrchr(
                arg___s: *const ::std::os::raw::c_char,
                arg___c: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        strrchr(arg___s, arg___c)
    })
}
pub unsafe fn strcspn(
    arg___s: *const ::std::os::raw::c_char,
    arg___reject: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcspn(
                arg___s: *const ::std::os::raw::c_char,
                arg___reject: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_ulong;
        }
        strcspn(arg___s, arg___reject)
    })
}
pub unsafe fn strspn(
    arg___s: *const ::std::os::raw::c_char,
    arg___accept: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strspn(
                arg___s: *const ::std::os::raw::c_char,
                arg___accept: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_ulong;
        }
        strspn(arg___s, arg___accept)
    })
}
pub unsafe fn strpbrk(
    arg___s: *const ::std::os::raw::c_char,
    arg___accept: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strpbrk(
                arg___s: *const ::std::os::raw::c_char,
                arg___accept: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strpbrk(arg___s, arg___accept)
    })
}
pub unsafe fn strstr(
    arg___haystack: *const ::std::os::raw::c_char,
    arg___needle: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strstr(
                arg___haystack: *const ::std::os::raw::c_char,
                arg___needle: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strstr(arg___haystack, arg___needle)
    })
}
pub unsafe fn strtok(
    arg___s: *mut ::std::os::raw::c_char,
    arg___delim: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtok(
                arg___s: *mut ::std::os::raw::c_char,
                arg___delim: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strtok(arg___s, arg___delim)
    })
}
pub unsafe fn __strtok_r(
    arg___s: *mut ::std::os::raw::c_char,
    arg___delim: *const ::std::os::raw::c_char,
    arg___save_ptr: *mut *mut ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __strtok_r(
                arg___s: *mut ::std::os::raw::c_char,
                arg___delim: *const ::std::os::raw::c_char,
                arg___save_ptr: *mut *mut ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        __strtok_r(arg___s, arg___delim, arg___save_ptr)
    })
}
pub unsafe fn strtok_r(
    arg___s: *mut ::std::os::raw::c_char,
    arg___delim: *const ::std::os::raw::c_char,
    arg___save_ptr: *mut *mut ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strtok_r(
                arg___s: *mut ::std::os::raw::c_char,
                arg___delim: *const ::std::os::raw::c_char,
                arg___save_ptr: *mut *mut ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strtok_r(arg___s, arg___delim, arg___save_ptr)
    })
}
pub unsafe fn strlen(arg___s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strlen(arg___s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
        }
        strlen(arg___s)
    })
}
pub unsafe fn strnlen(arg___string: *const ::std::os::raw::c_char, arg___maxlen: usize) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strnlen(arg___string: *const ::std::os::raw::c_char, arg___maxlen: usize) -> usize;
        }
        strnlen(arg___string, arg___maxlen)
    })
}
pub unsafe fn strerror(arg___errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strerror(arg___errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
        }
        strerror(arg___errnum)
    })
}
pub unsafe fn strerror_r(
    arg___errnum: ::std::os::raw::c_int,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strerror_r(
                arg___errnum: ::std::os::raw::c_int,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
            ) -> ::std::os::raw::c_int;
        }
        strerror_r(arg___errnum, arg___buf, arg___buflen)
    })
}
pub unsafe fn strerror_l(
    arg___errnum: ::std::os::raw::c_int,
    arg___l: locale_t,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strerror_l(
                arg___errnum: ::std::os::raw::c_int,
                arg___l: locale_t,
            ) -> *mut ::std::os::raw::c_char;
        }
        strerror_l(arg___errnum, arg___l)
    })
}
pub unsafe fn bcmp(
    arg___s1: *const ::std::os::raw::c_void,
    arg___s2: *const ::std::os::raw::c_void,
    arg___n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bcmp(
                arg___s1: *const ::std::os::raw::c_void,
                arg___s2: *const ::std::os::raw::c_void,
                arg___n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        bcmp(arg___s1, arg___s2, arg___n)
    })
}
pub unsafe fn bcopy(
    arg___src: *const ::std::os::raw::c_void,
    arg___dest: *mut ::std::os::raw::c_void,
    arg___n: usize,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bcopy(
                arg___src: *const ::std::os::raw::c_void,
                arg___dest: *mut ::std::os::raw::c_void,
                arg___n: usize,
            );
        }
        bcopy(arg___src, arg___dest, arg___n)
    })
}
pub unsafe fn bzero(arg___s: *mut ::std::os::raw::c_void, arg___n: ::std::os::raw::c_ulong) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bzero(arg___s: *mut ::std::os::raw::c_void, arg___n: ::std::os::raw::c_ulong);
        }
        bzero(arg___s, arg___n)
    })
}
pub unsafe fn index(
    arg___s: *const ::std::os::raw::c_char,
    arg___c: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index(
                arg___s: *const ::std::os::raw::c_char,
                arg___c: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        index(arg___s, arg___c)
    })
}
pub unsafe fn rindex(
    arg___s: *const ::std::os::raw::c_char,
    arg___c: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rindex(
                arg___s: *const ::std::os::raw::c_char,
                arg___c: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        rindex(arg___s, arg___c)
    })
}
pub unsafe fn ffs(arg___i: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ffs(arg___i: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        ffs(arg___i)
    })
}
pub unsafe fn ffsl(arg___l: ::std::os::raw::c_long) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ffsl(arg___l: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
        }
        ffsl(arg___l)
    })
}
pub unsafe fn ffsll(arg___ll: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ffsll(arg___ll: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
        }
        ffsll(arg___ll)
    })
}
pub unsafe fn strcasecmp(
    arg___s1: *const ::std::os::raw::c_char,
    arg___s2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcasecmp(
                arg___s1: *const ::std::os::raw::c_char,
                arg___s2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        strcasecmp(arg___s1, arg___s2)
    })
}
pub unsafe fn strncasecmp(
    arg___s1: *const ::std::os::raw::c_char,
    arg___s2: *const ::std::os::raw::c_char,
    arg___n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strncasecmp(
                arg___s1: *const ::std::os::raw::c_char,
                arg___s2: *const ::std::os::raw::c_char,
                arg___n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        strncasecmp(arg___s1, arg___s2, arg___n)
    })
}
pub unsafe fn strcasecmp_l(
    arg___s1: *const ::std::os::raw::c_char,
    arg___s2: *const ::std::os::raw::c_char,
    arg___loc: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strcasecmp_l(
                arg___s1: *const ::std::os::raw::c_char,
                arg___s2: *const ::std::os::raw::c_char,
                arg___loc: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        strcasecmp_l(arg___s1, arg___s2, arg___loc)
    })
}
pub unsafe fn strncasecmp_l(
    arg___s1: *const ::std::os::raw::c_char,
    arg___s2: *const ::std::os::raw::c_char,
    arg___n: usize,
    arg___loc: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strncasecmp_l(
                arg___s1: *const ::std::os::raw::c_char,
                arg___s2: *const ::std::os::raw::c_char,
                arg___n: usize,
                arg___loc: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        strncasecmp_l(arg___s1, arg___s2, arg___n, arg___loc)
    })
}
pub unsafe fn explicit_bzero(arg___s: *mut ::std::os::raw::c_void, arg___n: usize) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn explicit_bzero(arg___s: *mut ::std::os::raw::c_void, arg___n: usize);
        }
        explicit_bzero(arg___s, arg___n)
    })
}
pub unsafe fn strsep(
    arg___stringp: *mut *mut ::std::os::raw::c_char,
    arg___delim: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strsep(
                arg___stringp: *mut *mut ::std::os::raw::c_char,
                arg___delim: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        strsep(arg___stringp, arg___delim)
    })
}
pub unsafe fn strsignal(arg___sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strsignal(arg___sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
        }
        strsignal(arg___sig)
    })
}
pub unsafe fn __stpcpy(
    arg___dest: *mut ::std::os::raw::c_char,
    arg___src: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __stpcpy(
                arg___dest: *mut ::std::os::raw::c_char,
                arg___src: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        __stpcpy(arg___dest, arg___src)
    })
}
pub unsafe fn stpcpy(
    arg___dest: *mut ::std::os::raw::c_char,
    arg___src: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn stpcpy(
                arg___dest: *mut ::std::os::raw::c_char,
                arg___src: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        stpcpy(arg___dest, arg___src)
    })
}
pub unsafe fn __stpncpy(
    arg___dest: *mut ::std::os::raw::c_char,
    arg___src: *const ::std::os::raw::c_char,
    arg___n: usize,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __stpncpy(
                arg___dest: *mut ::std::os::raw::c_char,
                arg___src: *const ::std::os::raw::c_char,
                arg___n: usize,
            ) -> *mut ::std::os::raw::c_char;
        }
        __stpncpy(arg___dest, arg___src, arg___n)
    })
}
pub unsafe fn stpncpy(
    arg___dest: *mut ::std::os::raw::c_char,
    arg___src: *const ::std::os::raw::c_char,
    arg___n: ::std::os::raw::c_ulong,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn stpncpy(
                arg___dest: *mut ::std::os::raw::c_char,
                arg___src: *const ::std::os::raw::c_char,
                arg___n: ::std::os::raw::c_ulong,
            ) -> *mut ::std::os::raw::c_char;
        }
        stpncpy(arg___dest, arg___src, arg___n)
    })
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Default, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
pub unsafe fn __errno_location() -> *mut ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __errno_location() -> *mut ::std::os::raw::c_int;
        }
        __errno_location()
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lconv {
    pub decimal_point: *mut ::std::os::raw::c_char,
    pub thousands_sep: *mut ::std::os::raw::c_char,
    pub grouping: *mut ::std::os::raw::c_char,
    pub int_curr_symbol: *mut ::std::os::raw::c_char,
    pub currency_symbol: *mut ::std::os::raw::c_char,
    pub mon_decimal_point: *mut ::std::os::raw::c_char,
    pub mon_thousands_sep: *mut ::std::os::raw::c_char,
    pub mon_grouping: *mut ::std::os::raw::c_char,
    pub positive_sign: *mut ::std::os::raw::c_char,
    pub negative_sign: *mut ::std::os::raw::c_char,
    pub int_frac_digits: ::std::os::raw::c_char,
    pub frac_digits: ::std::os::raw::c_char,
    pub p_cs_precedes: ::std::os::raw::c_char,
    pub p_sep_by_space: ::std::os::raw::c_char,
    pub n_cs_precedes: ::std::os::raw::c_char,
    pub n_sep_by_space: ::std::os::raw::c_char,
    pub p_sign_posn: ::std::os::raw::c_char,
    pub n_sign_posn: ::std::os::raw::c_char,
    pub int_p_cs_precedes: ::std::os::raw::c_char,
    pub int_p_sep_by_space: ::std::os::raw::c_char,
    pub int_n_cs_precedes: ::std::os::raw::c_char,
    pub int_n_sep_by_space: ::std::os::raw::c_char,
    pub int_p_sign_posn: ::std::os::raw::c_char,
    pub int_n_sign_posn: ::std::os::raw::c_char,
}
impl Default for lconv {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn setlocale(
    arg___category: ::std::os::raw::c_int,
    arg___locale: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setlocale(
                arg___category: ::std::os::raw::c_int,
                arg___locale: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        setlocale(arg___category, arg___locale)
    })
}
pub unsafe fn localeconv() -> *mut lconv {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn localeconv() -> *mut lconv;
        }
        localeconv()
    })
}
pub unsafe fn newlocale(
    arg___category_mask: ::std::os::raw::c_int,
    arg___locale: *const ::std::os::raw::c_char,
    arg___base: locale_t,
) -> locale_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn newlocale(
                arg___category_mask: ::std::os::raw::c_int,
                arg___locale: *const ::std::os::raw::c_char,
                arg___base: locale_t,
            ) -> locale_t;
        }
        newlocale(arg___category_mask, arg___locale, arg___base)
    })
}
pub unsafe fn duplocale(arg___dataset: locale_t) -> locale_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn duplocale(arg___dataset: locale_t) -> locale_t;
        }
        duplocale(arg___dataset)
    })
}
pub unsafe fn freelocale(arg___dataset: locale_t) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn freelocale(arg___dataset: locale_t);
        }
        freelocale(arg___dataset)
    })
}
pub unsafe fn uselocale(arg___dataset: locale_t) -> locale_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn uselocale(arg___dataset: locale_t) -> locale_t;
        }
        uselocale(arg___dataset)
    })
}
pub type Pointer = *mut ::std::os::raw::c_char;
pub type int8 = ::std::os::raw::c_schar;
pub type int16 = ::std::os::raw::c_short;
pub type int32 = ::std::os::raw::c_int;
pub type uint8 = ::std::os::raw::c_uchar;
pub type uint16 = ::std::os::raw::c_ushort;
pub type uint32 = ::std::os::raw::c_uint;
pub type bits8 = uint8;
pub type bits16 = uint16;
pub type bits32 = uint32;
pub type int64 = ::std::os::raw::c_long;
pub type uint64 = ::std::os::raw::c_ulong;
pub type int128 = i128;
pub type uint128 = u128;
pub type Size = usize;
pub type Index = ::std::os::raw::c_uint;
pub type Offset = ::std::os::raw::c_int;
pub type float4 = f32;
pub type float8 = f64;
pub type regproc = Oid;
pub type RegProcedure = regproc;
pub type TransactionId = uint32;
pub type LocalTransactionId = uint32;
pub type SubTransactionId = uint32;
pub type MultiXactId = TransactionId;
pub type MultiXactOffset = uint32;
pub type CommandId = uint32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IntArray {
    pub indx: [::std::os::raw::c_int; 6usize],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varlena {
    pub vl_len_: [::std::os::raw::c_char; 4usize],
    pub vl_dat: __IncompleteArrayField<::std::os::raw::c_char>,
}
pub type bytea = varlena;
pub type text = varlena;
pub type BpChar = varlena;
pub type VarChar = varlena;
#[repr(C)]
#[derive(Debug, Default)]
pub struct int2vector {
    pub vl_len_: int32,
    pub ndim: ::std::os::raw::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
    pub dim1: ::std::os::raw::c_int,
    pub lbound1: ::std::os::raw::c_int,
    pub values: __IncompleteArrayField<int16>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct oidvector {
    pub vl_len_: int32,
    pub ndim: ::std::os::raw::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
    pub dim1: ::std::os::raw::c_int,
    pub lbound1: ::std::os::raw::c_int,
    pub values: __IncompleteArrayField<Oid>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nameData {
    pub data: [::std::os::raw::c_char; 64usize],
}
impl Default for nameData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type NameData = nameData;
pub type Name = *mut NameData;
pub unsafe fn ExceptionalCondition(
    arg_conditionName: *const ::std::os::raw::c_char,
    arg_errorType: *const ::std::os::raw::c_char,
    arg_fileName: *const ::std::os::raw::c_char,
    arg_lineNumber: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExceptionalCondition(
                arg_conditionName: *const ::std::os::raw::c_char,
                arg_errorType: *const ::std::os::raw::c_char,
                arg_fileName: *const ::std::os::raw::c_char,
                arg_lineNumber: ::std::os::raw::c_int,
            );
        }
        ExceptionalCondition(
            arg_conditionName,
            arg_errorType,
            arg_fileName,
            arg_lineNumber,
        )
    })
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PGAlignedBlock {
    pub data: [::std::os::raw::c_char; 8192usize],
    pub force_align_d: f64,
    pub force_align_i64: int64,
}
impl Default for PGAlignedBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PGAlignedXLogBlock {
    pub data: [::std::os::raw::c_char; 8192usize],
    pub force_align_d: f64,
    pub force_align_i64: int64,
}
impl Default for PGAlignedXLogBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const _ISupper: ::std::os::raw::c_uint = 256;
pub const _ISlower: ::std::os::raw::c_uint = 512;
pub const _ISalpha: ::std::os::raw::c_uint = 1024;
pub const _ISdigit: ::std::os::raw::c_uint = 2048;
pub const _ISxdigit: ::std::os::raw::c_uint = 4096;
pub const _ISspace: ::std::os::raw::c_uint = 8192;
pub const _ISprint: ::std::os::raw::c_uint = 16384;
pub const _ISgraph: ::std::os::raw::c_uint = 32768;
pub const _ISblank: ::std::os::raw::c_uint = 1;
pub const _IScntrl: ::std::os::raw::c_uint = 2;
pub const _ISpunct: ::std::os::raw::c_uint = 4;
pub const _ISalnum: ::std::os::raw::c_uint = 8;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
pub unsafe fn __ctype_b_loc() -> *mut *const ::std::os::raw::c_ushort {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ctype_b_loc() -> *mut *const ::std::os::raw::c_ushort;
        }
        __ctype_b_loc()
    })
}
pub unsafe fn __ctype_tolower_loc() -> *mut *const __int32_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ctype_tolower_loc() -> *mut *const __int32_t;
        }
        __ctype_tolower_loc()
    })
}
pub unsafe fn __ctype_toupper_loc() -> *mut *const __int32_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ctype_toupper_loc() -> *mut *const __int32_t;
        }
        __ctype_toupper_loc()
    })
}
pub unsafe fn isalnum(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isalnum(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        isalnum(arg_arg1)
    })
}
pub unsafe fn isalpha(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isalpha(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        isalpha(arg_arg1)
    })
}
pub unsafe fn iscntrl(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn iscntrl(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        iscntrl(arg_arg1)
    })
}
pub unsafe fn isdigit(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isdigit(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        isdigit(arg_arg1)
    })
}
pub unsafe fn islower(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn islower(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        islower(arg_arg1)
    })
}
pub unsafe fn isgraph(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isgraph(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        isgraph(arg_arg1)
    })
}
pub unsafe fn isprint(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isprint(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        isprint(arg_arg1)
    })
}
pub unsafe fn ispunct(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ispunct(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        ispunct(arg_arg1)
    })
}
pub unsafe fn isspace(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isspace(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        isspace(arg_arg1)
    })
}
pub unsafe fn isupper(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isupper(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        isupper(arg_arg1)
    })
}
pub unsafe fn isxdigit(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isxdigit(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        isxdigit(arg_arg1)
    })
}
pub unsafe fn tolower(arg___c: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tolower(arg___c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        tolower(arg___c)
    })
}
pub unsafe fn toupper(arg___c: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn toupper(arg___c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        toupper(arg___c)
    })
}
pub unsafe fn isblank(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isblank(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        isblank(arg_arg1)
    })
}
pub unsafe fn isascii(arg___c: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isascii(arg___c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        isascii(arg___c)
    })
}
pub unsafe fn toascii(arg___c: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn toascii(arg___c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        toascii(arg___c)
    })
}
pub unsafe fn _toupper(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn _toupper(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        _toupper(arg_arg1)
    })
}
pub unsafe fn _tolower(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn _tolower(arg_arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        _tolower(arg_arg1)
    })
}
pub unsafe fn isalnum_l(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isalnum_l(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        isalnum_l(arg_arg1, arg_arg2)
    })
}
pub unsafe fn isalpha_l(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isalpha_l(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        isalpha_l(arg_arg1, arg_arg2)
    })
}
pub unsafe fn iscntrl_l(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn iscntrl_l(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        iscntrl_l(arg_arg1, arg_arg2)
    })
}
pub unsafe fn isdigit_l(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isdigit_l(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        isdigit_l(arg_arg1, arg_arg2)
    })
}
pub unsafe fn islower_l(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn islower_l(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        islower_l(arg_arg1, arg_arg2)
    })
}
pub unsafe fn isgraph_l(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isgraph_l(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        isgraph_l(arg_arg1, arg_arg2)
    })
}
pub unsafe fn isprint_l(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isprint_l(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        isprint_l(arg_arg1, arg_arg2)
    })
}
pub unsafe fn ispunct_l(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ispunct_l(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        ispunct_l(arg_arg1, arg_arg2)
    })
}
pub unsafe fn isspace_l(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isspace_l(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        isspace_l(arg_arg1, arg_arg2)
    })
}
pub unsafe fn isupper_l(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isupper_l(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        isupper_l(arg_arg1, arg_arg2)
    })
}
pub unsafe fn isxdigit_l(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isxdigit_l(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        isxdigit_l(arg_arg1, arg_arg2)
    })
}
pub unsafe fn isblank_l(
    arg_arg1: ::std::os::raw::c_int,
    arg_arg2: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isblank_l(
                arg_arg1: ::std::os::raw::c_int,
                arg_arg2: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        isblank_l(arg_arg1, arg_arg2)
    })
}
pub unsafe fn __tolower_l(
    arg___c: ::std::os::raw::c_int,
    arg___l: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __tolower_l(
                arg___c: ::std::os::raw::c_int,
                arg___l: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        __tolower_l(arg___c, arg___l)
    })
}
pub unsafe fn tolower_l(
    arg___c: ::std::os::raw::c_int,
    arg___l: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tolower_l(
                arg___c: ::std::os::raw::c_int,
                arg___l: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        tolower_l(arg___c, arg___l)
    })
}
pub unsafe fn __toupper_l(
    arg___c: ::std::os::raw::c_int,
    arg___l: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __toupper_l(
                arg___c: ::std::os::raw::c_int,
                arg___l: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        __toupper_l(arg___c, arg___l)
    })
}
pub unsafe fn toupper_l(
    arg___c: ::std::os::raw::c_int,
    arg___l: locale_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn toupper_l(
                arg___c: ::std::os::raw::c_int,
                arg___l: locale_t,
            ) -> ::std::os::raw::c_int;
        }
        toupper_l(arg___c, arg___l)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iovec {
    pub iov_base: *mut ::std::os::raw::c_void,
    pub iov_len: usize,
}
impl Default for iovec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type socklen_t = __socklen_t;
pub const __socket_type_SOCK_STREAM: __socket_type = 1;
pub const __socket_type_SOCK_DGRAM: __socket_type = 2;
pub const __socket_type_SOCK_RAW: __socket_type = 3;
pub const __socket_type_SOCK_RDM: __socket_type = 4;
pub const __socket_type_SOCK_SEQPACKET: __socket_type = 5;
pub const __socket_type_SOCK_DCCP: __socket_type = 6;
pub const __socket_type_SOCK_PACKET: __socket_type = 10;
pub const __socket_type_SOCK_CLOEXEC: __socket_type = 524288;
pub const __socket_type_SOCK_NONBLOCK: __socket_type = 2048;
pub type __socket_type = ::std::os::raw::c_uint;
pub type sa_family_t = ::std::os::raw::c_ushort;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sockaddr {
    pub sa_family: sa_family_t,
    pub sa_data: [::std::os::raw::c_char; 14usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_storage {
    pub ss_family: sa_family_t,
    pub __ss_padding: [::std::os::raw::c_char; 118usize],
    pub __ss_align: ::std::os::raw::c_ulong,
}
impl Default for sockaddr_storage {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const MSG_OOB: ::std::os::raw::c_uint = 1;
pub const MSG_PEEK: ::std::os::raw::c_uint = 2;
pub const MSG_DONTROUTE: ::std::os::raw::c_uint = 4;
pub const MSG_CTRUNC: ::std::os::raw::c_uint = 8;
pub const MSG_PROXY: ::std::os::raw::c_uint = 16;
pub const MSG_TRUNC: ::std::os::raw::c_uint = 32;
pub const MSG_DONTWAIT: ::std::os::raw::c_uint = 64;
pub const MSG_EOR: ::std::os::raw::c_uint = 128;
pub const MSG_WAITALL: ::std::os::raw::c_uint = 256;
pub const MSG_FIN: ::std::os::raw::c_uint = 512;
pub const MSG_SYN: ::std::os::raw::c_uint = 1024;
pub const MSG_CONFIRM: ::std::os::raw::c_uint = 2048;
pub const MSG_RST: ::std::os::raw::c_uint = 4096;
pub const MSG_ERRQUEUE: ::std::os::raw::c_uint = 8192;
pub const MSG_NOSIGNAL: ::std::os::raw::c_uint = 16384;
pub const MSG_MORE: ::std::os::raw::c_uint = 32768;
pub const MSG_WAITFORONE: ::std::os::raw::c_uint = 65536;
pub const MSG_BATCH: ::std::os::raw::c_uint = 262144;
pub const MSG_ZEROCOPY: ::std::os::raw::c_uint = 67108864;
pub const MSG_FASTOPEN: ::std::os::raw::c_uint = 536870912;
pub const MSG_CMSG_CLOEXEC: ::std::os::raw::c_uint = 1073741824;
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct msghdr {
    pub msg_name: *mut ::std::os::raw::c_void,
    pub msg_namelen: socklen_t,
    pub msg_iov: *mut iovec,
    pub msg_iovlen: usize,
    pub msg_control: *mut ::std::os::raw::c_void,
    pub msg_controllen: usize,
    pub msg_flags: ::std::os::raw::c_int,
}
impl Default for msghdr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct cmsghdr {
    pub cmsg_len: usize,
    pub cmsg_level: ::std::os::raw::c_int,
    pub cmsg_type: ::std::os::raw::c_int,
    pub __cmsg_data: __IncompleteArrayField<::std::os::raw::c_uchar>,
}
pub unsafe fn __cmsg_nxthdr(arg___mhdr: *mut msghdr, arg___cmsg: *mut cmsghdr) -> *mut cmsghdr {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __cmsg_nxthdr(arg___mhdr: *mut msghdr, arg___cmsg: *mut cmsghdr) -> *mut cmsghdr;
        }
        __cmsg_nxthdr(arg___mhdr, arg___cmsg)
    })
}
pub const SCM_RIGHTS: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_3 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __kernel_fd_set {
    pub fds_bits: [::std::os::raw::c_ulong; 16usize],
}
pub type __kernel_sighandler_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type __kernel_key_t = ::std::os::raw::c_int;
pub type __kernel_mqd_t = ::std::os::raw::c_int;
pub type __kernel_old_uid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_gid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_dev_t = ::std::os::raw::c_ulong;
pub type __kernel_long_t = ::std::os::raw::c_long;
pub type __kernel_ulong_t = ::std::os::raw::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_mode_t = ::std::os::raw::c_uint;
pub type __kernel_pid_t = ::std::os::raw::c_int;
pub type __kernel_ipc_pid_t = ::std::os::raw::c_int;
pub type __kernel_uid_t = ::std::os::raw::c_uint;
pub type __kernel_gid_t = ::std::os::raw::c_uint;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = ::std::os::raw::c_int;
pub type __kernel_uid32_t = ::std::os::raw::c_uint;
pub type __kernel_gid32_t = ::std::os::raw::c_uint;
pub type __kernel_size_t = __kernel_ulong_t;
pub type __kernel_ssize_t = __kernel_long_t;
pub type __kernel_ptrdiff_t = __kernel_long_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __kernel_fsid_t {
    pub val: [::std::os::raw::c_int; 2usize],
}
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = ::std::os::raw::c_longlong;
pub type __kernel_old_time_t = __kernel_long_t;
pub type __kernel_time_t = __kernel_long_t;
pub type __kernel_time64_t = ::std::os::raw::c_longlong;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = ::std::os::raw::c_int;
pub type __kernel_clockid_t = ::std::os::raw::c_int;
pub type __kernel_caddr_t = *mut ::std::os::raw::c_char;
pub type __kernel_uid16_t = ::std::os::raw::c_ushort;
pub type __kernel_gid16_t = ::std::os::raw::c_ushort;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct linger {
    pub l_onoff: ::std::os::raw::c_int,
    pub l_linger: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct osockaddr {
    pub sa_family: ::std::os::raw::c_ushort,
    pub sa_data: [::std::os::raw::c_uchar; 14usize],
}
pub const SHUT_RD: ::std::os::raw::c_uint = 0;
pub const SHUT_WR: ::std::os::raw::c_uint = 1;
pub const SHUT_RDWR: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_4 = ::std::os::raw::c_uint;
pub unsafe fn socket(
    arg___domain: ::std::os::raw::c_int,
    arg___type: ::std::os::raw::c_int,
    arg___protocol: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn socket(
                arg___domain: ::std::os::raw::c_int,
                arg___type: ::std::os::raw::c_int,
                arg___protocol: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        socket(arg___domain, arg___type, arg___protocol)
    })
}
pub unsafe fn socketpair(
    arg___domain: ::std::os::raw::c_int,
    arg___type: ::std::os::raw::c_int,
    arg___protocol: ::std::os::raw::c_int,
    arg___fds: *mut ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn socketpair(
                arg___domain: ::std::os::raw::c_int,
                arg___type: ::std::os::raw::c_int,
                arg___protocol: ::std::os::raw::c_int,
                arg___fds: *mut ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        socketpair(arg___domain, arg___type, arg___protocol, arg___fds)
    })
}
pub unsafe fn bind(
    arg___fd: ::std::os::raw::c_int,
    arg___addr: *const sockaddr,
    arg___len: socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bind(
                arg___fd: ::std::os::raw::c_int,
                arg___addr: *const sockaddr,
                arg___len: socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        bind(arg___fd, arg___addr, arg___len)
    })
}
pub unsafe fn getsockname(
    arg___fd: ::std::os::raw::c_int,
    arg___addr: *mut sockaddr,
    arg___len: *mut socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getsockname(
                arg___fd: ::std::os::raw::c_int,
                arg___addr: *mut sockaddr,
                arg___len: *mut socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        getsockname(arg___fd, arg___addr, arg___len)
    })
}
pub unsafe fn connect(
    arg___fd: ::std::os::raw::c_int,
    arg___addr: *const sockaddr,
    arg___len: socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn connect(
                arg___fd: ::std::os::raw::c_int,
                arg___addr: *const sockaddr,
                arg___len: socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        connect(arg___fd, arg___addr, arg___len)
    })
}
pub unsafe fn getpeername(
    arg___fd: ::std::os::raw::c_int,
    arg___addr: *mut sockaddr,
    arg___len: *mut socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpeername(
                arg___fd: ::std::os::raw::c_int,
                arg___addr: *mut sockaddr,
                arg___len: *mut socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        getpeername(arg___fd, arg___addr, arg___len)
    })
}
pub unsafe fn send(
    arg___fd: ::std::os::raw::c_int,
    arg___buf: *const ::std::os::raw::c_void,
    arg___n: usize,
    arg___flags: ::std::os::raw::c_int,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn send(
                arg___fd: ::std::os::raw::c_int,
                arg___buf: *const ::std::os::raw::c_void,
                arg___n: usize,
                arg___flags: ::std::os::raw::c_int,
            ) -> isize;
        }
        send(arg___fd, arg___buf, arg___n, arg___flags)
    })
}
pub unsafe fn recv(
    arg___fd: ::std::os::raw::c_int,
    arg___buf: *mut ::std::os::raw::c_void,
    arg___n: usize,
    arg___flags: ::std::os::raw::c_int,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn recv(
                arg___fd: ::std::os::raw::c_int,
                arg___buf: *mut ::std::os::raw::c_void,
                arg___n: usize,
                arg___flags: ::std::os::raw::c_int,
            ) -> isize;
        }
        recv(arg___fd, arg___buf, arg___n, arg___flags)
    })
}
pub unsafe fn sendto(
    arg___fd: ::std::os::raw::c_int,
    arg___buf: *const ::std::os::raw::c_void,
    arg___n: usize,
    arg___flags: ::std::os::raw::c_int,
    arg___addr: *const sockaddr,
    arg___addr_len: socklen_t,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sendto(
                arg___fd: ::std::os::raw::c_int,
                arg___buf: *const ::std::os::raw::c_void,
                arg___n: usize,
                arg___flags: ::std::os::raw::c_int,
                arg___addr: *const sockaddr,
                arg___addr_len: socklen_t,
            ) -> isize;
        }
        sendto(
            arg___fd,
            arg___buf,
            arg___n,
            arg___flags,
            arg___addr,
            arg___addr_len,
        )
    })
}
pub unsafe fn recvfrom(
    arg___fd: ::std::os::raw::c_int,
    arg___buf: *mut ::std::os::raw::c_void,
    arg___n: usize,
    arg___flags: ::std::os::raw::c_int,
    arg___addr: *mut sockaddr,
    arg___addr_len: *mut socklen_t,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn recvfrom(
                arg___fd: ::std::os::raw::c_int,
                arg___buf: *mut ::std::os::raw::c_void,
                arg___n: usize,
                arg___flags: ::std::os::raw::c_int,
                arg___addr: *mut sockaddr,
                arg___addr_len: *mut socklen_t,
            ) -> isize;
        }
        recvfrom(
            arg___fd,
            arg___buf,
            arg___n,
            arg___flags,
            arg___addr,
            arg___addr_len,
        )
    })
}
pub unsafe fn sendmsg(
    arg___fd: ::std::os::raw::c_int,
    arg___message: *const msghdr,
    arg___flags: ::std::os::raw::c_int,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sendmsg(
                arg___fd: ::std::os::raw::c_int,
                arg___message: *const msghdr,
                arg___flags: ::std::os::raw::c_int,
            ) -> isize;
        }
        sendmsg(arg___fd, arg___message, arg___flags)
    })
}
pub unsafe fn recvmsg(
    arg___fd: ::std::os::raw::c_int,
    arg___message: *mut msghdr,
    arg___flags: ::std::os::raw::c_int,
) -> isize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn recvmsg(
                arg___fd: ::std::os::raw::c_int,
                arg___message: *mut msghdr,
                arg___flags: ::std::os::raw::c_int,
            ) -> isize;
        }
        recvmsg(arg___fd, arg___message, arg___flags)
    })
}
pub unsafe fn getsockopt(
    arg___fd: ::std::os::raw::c_int,
    arg___level: ::std::os::raw::c_int,
    arg___optname: ::std::os::raw::c_int,
    arg___optval: *mut ::std::os::raw::c_void,
    arg___optlen: *mut socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getsockopt(
                arg___fd: ::std::os::raw::c_int,
                arg___level: ::std::os::raw::c_int,
                arg___optname: ::std::os::raw::c_int,
                arg___optval: *mut ::std::os::raw::c_void,
                arg___optlen: *mut socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        getsockopt(
            arg___fd,
            arg___level,
            arg___optname,
            arg___optval,
            arg___optlen,
        )
    })
}
pub unsafe fn setsockopt(
    arg___fd: ::std::os::raw::c_int,
    arg___level: ::std::os::raw::c_int,
    arg___optname: ::std::os::raw::c_int,
    arg___optval: *const ::std::os::raw::c_void,
    arg___optlen: socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setsockopt(
                arg___fd: ::std::os::raw::c_int,
                arg___level: ::std::os::raw::c_int,
                arg___optname: ::std::os::raw::c_int,
                arg___optval: *const ::std::os::raw::c_void,
                arg___optlen: socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        setsockopt(
            arg___fd,
            arg___level,
            arg___optname,
            arg___optval,
            arg___optlen,
        )
    })
}
pub unsafe fn listen(
    arg___fd: ::std::os::raw::c_int,
    arg___n: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn listen(
                arg___fd: ::std::os::raw::c_int,
                arg___n: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        listen(arg___fd, arg___n)
    })
}
pub unsafe fn accept(
    arg___fd: ::std::os::raw::c_int,
    arg___addr: *mut sockaddr,
    arg___addr_len: *mut socklen_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn accept(
                arg___fd: ::std::os::raw::c_int,
                arg___addr: *mut sockaddr,
                arg___addr_len: *mut socklen_t,
            ) -> ::std::os::raw::c_int;
        }
        accept(arg___fd, arg___addr, arg___addr_len)
    })
}
pub unsafe fn shutdown(
    arg___fd: ::std::os::raw::c_int,
    arg___how: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn shutdown(
                arg___fd: ::std::os::raw::c_int,
                arg___how: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        shutdown(arg___fd, arg___how)
    })
}
pub unsafe fn sockatmark(arg___fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sockatmark(arg___fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        sockatmark(arg___fd)
    })
}
pub unsafe fn isfdtype(
    arg___fd: ::std::os::raw::c_int,
    arg___fdtype: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isfdtype(
                arg___fd: ::std::os::raw::c_int,
                arg___fdtype: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        isfdtype(arg___fd, arg___fdtype)
    })
}
pub type in_addr_t = u32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct in_addr {
    pub s_addr: in_addr_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_opts {
    pub ip_dst: in_addr,
    pub ip_opts: [::std::os::raw::c_char; 40usize],
}
impl Default for ip_opts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreqn {
    pub imr_multiaddr: in_addr,
    pub imr_address: in_addr,
    pub imr_ifindex: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct in_pktinfo {
    pub ipi_ifindex: ::std::os::raw::c_int,
    pub ipi_spec_dst: in_addr,
    pub ipi_addr: in_addr,
}
pub const IPPROTO_IP: ::std::os::raw::c_uint = 0;
pub const IPPROTO_ICMP: ::std::os::raw::c_uint = 1;
pub const IPPROTO_IGMP: ::std::os::raw::c_uint = 2;
pub const IPPROTO_IPIP: ::std::os::raw::c_uint = 4;
pub const IPPROTO_TCP: ::std::os::raw::c_uint = 6;
pub const IPPROTO_EGP: ::std::os::raw::c_uint = 8;
pub const IPPROTO_PUP: ::std::os::raw::c_uint = 12;
pub const IPPROTO_UDP: ::std::os::raw::c_uint = 17;
pub const IPPROTO_IDP: ::std::os::raw::c_uint = 22;
pub const IPPROTO_TP: ::std::os::raw::c_uint = 29;
pub const IPPROTO_DCCP: ::std::os::raw::c_uint = 33;
pub const IPPROTO_IPV6: ::std::os::raw::c_uint = 41;
pub const IPPROTO_RSVP: ::std::os::raw::c_uint = 46;
pub const IPPROTO_GRE: ::std::os::raw::c_uint = 47;
pub const IPPROTO_ESP: ::std::os::raw::c_uint = 50;
pub const IPPROTO_AH: ::std::os::raw::c_uint = 51;
pub const IPPROTO_MTP: ::std::os::raw::c_uint = 92;
pub const IPPROTO_BEETPH: ::std::os::raw::c_uint = 94;
pub const IPPROTO_ENCAP: ::std::os::raw::c_uint = 98;
pub const IPPROTO_PIM: ::std::os::raw::c_uint = 103;
pub const IPPROTO_COMP: ::std::os::raw::c_uint = 108;
pub const IPPROTO_SCTP: ::std::os::raw::c_uint = 132;
pub const IPPROTO_UDPLITE: ::std::os::raw::c_uint = 136;
pub const IPPROTO_MPLS: ::std::os::raw::c_uint = 137;
pub const IPPROTO_ETHERNET: ::std::os::raw::c_uint = 143;
pub const IPPROTO_RAW: ::std::os::raw::c_uint = 255;
pub const IPPROTO_MPTCP: ::std::os::raw::c_uint = 262;
pub const IPPROTO_MAX: ::std::os::raw::c_uint = 263;
pub type _bindgen_ty_5 = ::std::os::raw::c_uint;
pub const IPPROTO_HOPOPTS: ::std::os::raw::c_uint = 0;
pub const IPPROTO_ROUTING: ::std::os::raw::c_uint = 43;
pub const IPPROTO_FRAGMENT: ::std::os::raw::c_uint = 44;
pub const IPPROTO_ICMPV6: ::std::os::raw::c_uint = 58;
pub const IPPROTO_NONE: ::std::os::raw::c_uint = 59;
pub const IPPROTO_DSTOPTS: ::std::os::raw::c_uint = 60;
pub const IPPROTO_MH: ::std::os::raw::c_uint = 135;
pub type _bindgen_ty_6 = ::std::os::raw::c_uint;
pub type in_port_t = u16;
pub const IPPORT_ECHO: ::std::os::raw::c_uint = 7;
pub const IPPORT_DISCARD: ::std::os::raw::c_uint = 9;
pub const IPPORT_SYSTAT: ::std::os::raw::c_uint = 11;
pub const IPPORT_DAYTIME: ::std::os::raw::c_uint = 13;
pub const IPPORT_NETSTAT: ::std::os::raw::c_uint = 15;
pub const IPPORT_FTP: ::std::os::raw::c_uint = 21;
pub const IPPORT_TELNET: ::std::os::raw::c_uint = 23;
pub const IPPORT_SMTP: ::std::os::raw::c_uint = 25;
pub const IPPORT_TIMESERVER: ::std::os::raw::c_uint = 37;
pub const IPPORT_NAMESERVER: ::std::os::raw::c_uint = 42;
pub const IPPORT_WHOIS: ::std::os::raw::c_uint = 43;
pub const IPPORT_MTP: ::std::os::raw::c_uint = 57;
pub const IPPORT_TFTP: ::std::os::raw::c_uint = 69;
pub const IPPORT_RJE: ::std::os::raw::c_uint = 77;
pub const IPPORT_FINGER: ::std::os::raw::c_uint = 79;
pub const IPPORT_TTYLINK: ::std::os::raw::c_uint = 87;
pub const IPPORT_SUPDUP: ::std::os::raw::c_uint = 95;
pub const IPPORT_EXECSERVER: ::std::os::raw::c_uint = 512;
pub const IPPORT_LOGINSERVER: ::std::os::raw::c_uint = 513;
pub const IPPORT_CMDSERVER: ::std::os::raw::c_uint = 514;
pub const IPPORT_EFSSERVER: ::std::os::raw::c_uint = 520;
pub const IPPORT_BIFFUDP: ::std::os::raw::c_uint = 512;
pub const IPPORT_WHOSERVER: ::std::os::raw::c_uint = 513;
pub const IPPORT_ROUTESERVER: ::std::os::raw::c_uint = 520;
pub const IPPORT_RESERVED: ::std::os::raw::c_uint = 1024;
pub const IPPORT_USERRESERVED: ::std::os::raw::c_uint = 5000;
pub type _bindgen_ty_7 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_addr {
    pub __in6_u: in6_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union in6_addr__bindgen_ty_1 {
    pub __u6_addr8: [u8; 16usize],
    pub __u6_addr16: [u16; 8usize],
    pub __u6_addr32: [u32; 4usize],
}
impl Default for in6_addr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for in6_addr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static in6addr_any: in6_addr;
}
extern "C" {
    pub static in6addr_loopback: in6_addr;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sockaddr_in {
    pub sin_family: sa_family_t,
    pub sin_port: in_port_t,
    pub sin_addr: in_addr,
    pub sin_zero: [::std::os::raw::c_uchar; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_in6 {
    pub sin6_family: sa_family_t,
    pub sin6_port: in_port_t,
    pub sin6_flowinfo: u32,
    pub sin6_addr: in6_addr,
    pub sin6_scope_id: u32,
}
impl Default for sockaddr_in6 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreq {
    pub imr_multiaddr: in_addr,
    pub imr_interface: in_addr,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreq_source {
    pub imr_multiaddr: in_addr,
    pub imr_interface: in_addr,
    pub imr_sourceaddr: in_addr,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ipv6_mreq {
    pub ipv6mr_multiaddr: in6_addr,
    pub ipv6mr_interface: ::std::os::raw::c_uint,
}
impl Default for ipv6_mreq {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct group_req {
    pub gr_interface: u32,
    pub gr_group: sockaddr_storage,
}
impl Default for group_req {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct group_source_req {
    pub gsr_interface: u32,
    pub gsr_group: sockaddr_storage,
    pub gsr_source: sockaddr_storage,
}
impl Default for group_source_req {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_msfilter {
    pub imsf_multiaddr: in_addr,
    pub imsf_interface: in_addr,
    pub imsf_fmode: u32,
    pub imsf_numsrc: u32,
    pub imsf_slist: [in_addr; 1usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct group_filter {
    pub gf_interface: u32,
    pub gf_group: sockaddr_storage,
    pub gf_fmode: u32,
    pub gf_numsrc: u32,
    pub gf_slist: [sockaddr_storage; 1usize],
}
impl Default for group_filter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn ntohl(arg___netlong: u32) -> u32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ntohl(arg___netlong: u32) -> u32;
        }
        ntohl(arg___netlong)
    })
}
pub unsafe fn ntohs(arg___netshort: u16) -> u16 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ntohs(arg___netshort: u16) -> u16;
        }
        ntohs(arg___netshort)
    })
}
pub unsafe fn htonl(arg___hostlong: u32) -> u32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn htonl(arg___hostlong: u32) -> u32;
        }
        htonl(arg___hostlong)
    })
}
pub unsafe fn htons(arg___hostshort: u16) -> u16 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn htons(arg___hostshort: u16) -> u16;
        }
        htons(arg___hostshort)
    })
}
pub unsafe fn bindresvport(
    arg___sockfd: ::std::os::raw::c_int,
    arg___sock_in: *mut sockaddr_in,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bindresvport(
                arg___sockfd: ::std::os::raw::c_int,
                arg___sock_in: *mut sockaddr_in,
            ) -> ::std::os::raw::c_int;
        }
        bindresvport(arg___sockfd, arg___sock_in)
    })
}
pub unsafe fn bindresvport6(
    arg___sockfd: ::std::os::raw::c_int,
    arg___sock_in: *mut sockaddr_in6,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bindresvport6(
                arg___sockfd: ::std::os::raw::c_int,
                arg___sock_in: *mut sockaddr_in6,
            ) -> ::std::os::raw::c_int;
        }
        bindresvport6(arg___sockfd, arg___sock_in)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rpcent {
    pub r_name: *mut ::std::os::raw::c_char,
    pub r_aliases: *mut *mut ::std::os::raw::c_char,
    pub r_number: ::std::os::raw::c_int,
}
impl Default for rpcent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn setrpcent(arg___stayopen: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setrpcent(arg___stayopen: ::std::os::raw::c_int);
        }
        setrpcent(arg___stayopen)
    })
}
pub unsafe fn endrpcent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn endrpcent();
        }
        endrpcent()
    })
}
pub unsafe fn getrpcbyname(arg___name: *const ::std::os::raw::c_char) -> *mut rpcent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getrpcbyname(arg___name: *const ::std::os::raw::c_char) -> *mut rpcent;
        }
        getrpcbyname(arg___name)
    })
}
pub unsafe fn getrpcbynumber(arg___number: ::std::os::raw::c_int) -> *mut rpcent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getrpcbynumber(arg___number: ::std::os::raw::c_int) -> *mut rpcent;
        }
        getrpcbynumber(arg___number)
    })
}
pub unsafe fn getrpcent() -> *mut rpcent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getrpcent() -> *mut rpcent;
        }
        getrpcent()
    })
}
pub unsafe fn getrpcbyname_r(
    arg___name: *const ::std::os::raw::c_char,
    arg___result_buf: *mut rpcent,
    arg___buffer: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut rpcent,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getrpcbyname_r(
                arg___name: *const ::std::os::raw::c_char,
                arg___result_buf: *mut rpcent,
                arg___buffer: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut rpcent,
            ) -> ::std::os::raw::c_int;
        }
        getrpcbyname_r(
            arg___name,
            arg___result_buf,
            arg___buffer,
            arg___buflen,
            arg___result,
        )
    })
}
pub unsafe fn getrpcbynumber_r(
    arg___number: ::std::os::raw::c_int,
    arg___result_buf: *mut rpcent,
    arg___buffer: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut rpcent,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getrpcbynumber_r(
                arg___number: ::std::os::raw::c_int,
                arg___result_buf: *mut rpcent,
                arg___buffer: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut rpcent,
            ) -> ::std::os::raw::c_int;
        }
        getrpcbynumber_r(
            arg___number,
            arg___result_buf,
            arg___buffer,
            arg___buflen,
            arg___result,
        )
    })
}
pub unsafe fn getrpcent_r(
    arg___result_buf: *mut rpcent,
    arg___buffer: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut rpcent,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getrpcent_r(
                arg___result_buf: *mut rpcent,
                arg___buffer: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut rpcent,
            ) -> ::std::os::raw::c_int;
        }
        getrpcent_r(arg___result_buf, arg___buffer, arg___buflen, arg___result)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct netent {
    pub n_name: *mut ::std::os::raw::c_char,
    pub n_aliases: *mut *mut ::std::os::raw::c_char,
    pub n_addrtype: ::std::os::raw::c_int,
    pub n_net: u32,
}
impl Default for netent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn __h_errno_location() -> *mut ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __h_errno_location() -> *mut ::std::os::raw::c_int;
        }
        __h_errno_location()
    })
}
pub unsafe fn herror(arg___str: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn herror(arg___str: *const ::std::os::raw::c_char);
        }
        herror(arg___str)
    })
}
pub unsafe fn hstrerror(arg___err_num: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hstrerror(arg___err_num: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
        }
        hstrerror(arg___err_num)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hostent {
    pub h_name: *mut ::std::os::raw::c_char,
    pub h_aliases: *mut *mut ::std::os::raw::c_char,
    pub h_addrtype: ::std::os::raw::c_int,
    pub h_length: ::std::os::raw::c_int,
    pub h_addr_list: *mut *mut ::std::os::raw::c_char,
}
impl Default for hostent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn sethostent(arg___stay_open: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sethostent(arg___stay_open: ::std::os::raw::c_int);
        }
        sethostent(arg___stay_open)
    })
}
pub unsafe fn endhostent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn endhostent();
        }
        endhostent()
    })
}
pub unsafe fn gethostent() -> *mut hostent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gethostent() -> *mut hostent;
        }
        gethostent()
    })
}
pub unsafe fn gethostbyaddr(
    arg___addr: *const ::std::os::raw::c_void,
    arg___len: __socklen_t,
    arg___type: ::std::os::raw::c_int,
) -> *mut hostent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gethostbyaddr(
                arg___addr: *const ::std::os::raw::c_void,
                arg___len: __socklen_t,
                arg___type: ::std::os::raw::c_int,
            ) -> *mut hostent;
        }
        gethostbyaddr(arg___addr, arg___len, arg___type)
    })
}
pub unsafe fn gethostbyname(arg___name: *const ::std::os::raw::c_char) -> *mut hostent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gethostbyname(arg___name: *const ::std::os::raw::c_char) -> *mut hostent;
        }
        gethostbyname(arg___name)
    })
}
pub unsafe fn gethostbyname2(
    arg___name: *const ::std::os::raw::c_char,
    arg___af: ::std::os::raw::c_int,
) -> *mut hostent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gethostbyname2(
                arg___name: *const ::std::os::raw::c_char,
                arg___af: ::std::os::raw::c_int,
            ) -> *mut hostent;
        }
        gethostbyname2(arg___name, arg___af)
    })
}
pub unsafe fn gethostent_r(
    arg___result_buf: *mut hostent,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut hostent,
    arg___h_errnop: *mut ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gethostent_r(
                arg___result_buf: *mut hostent,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut hostent,
                arg___h_errnop: *mut ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        gethostent_r(
            arg___result_buf,
            arg___buf,
            arg___buflen,
            arg___result,
            arg___h_errnop,
        )
    })
}
pub unsafe fn gethostbyaddr_r(
    arg___addr: *const ::std::os::raw::c_void,
    arg___len: __socklen_t,
    arg___type: ::std::os::raw::c_int,
    arg___result_buf: *mut hostent,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut hostent,
    arg___h_errnop: *mut ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gethostbyaddr_r(
                arg___addr: *const ::std::os::raw::c_void,
                arg___len: __socklen_t,
                arg___type: ::std::os::raw::c_int,
                arg___result_buf: *mut hostent,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut hostent,
                arg___h_errnop: *mut ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        gethostbyaddr_r(
            arg___addr,
            arg___len,
            arg___type,
            arg___result_buf,
            arg___buf,
            arg___buflen,
            arg___result,
            arg___h_errnop,
        )
    })
}
pub unsafe fn gethostbyname_r(
    arg___name: *const ::std::os::raw::c_char,
    arg___result_buf: *mut hostent,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut hostent,
    arg___h_errnop: *mut ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gethostbyname_r(
                arg___name: *const ::std::os::raw::c_char,
                arg___result_buf: *mut hostent,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut hostent,
                arg___h_errnop: *mut ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        gethostbyname_r(
            arg___name,
            arg___result_buf,
            arg___buf,
            arg___buflen,
            arg___result,
            arg___h_errnop,
        )
    })
}
pub unsafe fn gethostbyname2_r(
    arg___name: *const ::std::os::raw::c_char,
    arg___af: ::std::os::raw::c_int,
    arg___result_buf: *mut hostent,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut hostent,
    arg___h_errnop: *mut ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gethostbyname2_r(
                arg___name: *const ::std::os::raw::c_char,
                arg___af: ::std::os::raw::c_int,
                arg___result_buf: *mut hostent,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut hostent,
                arg___h_errnop: *mut ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        gethostbyname2_r(
            arg___name,
            arg___af,
            arg___result_buf,
            arg___buf,
            arg___buflen,
            arg___result,
            arg___h_errnop,
        )
    })
}
pub unsafe fn setnetent(arg___stay_open: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setnetent(arg___stay_open: ::std::os::raw::c_int);
        }
        setnetent(arg___stay_open)
    })
}
pub unsafe fn endnetent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn endnetent();
        }
        endnetent()
    })
}
pub unsafe fn getnetent() -> *mut netent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getnetent() -> *mut netent;
        }
        getnetent()
    })
}
pub unsafe fn getnetbyaddr(arg___net: u32, arg___type: ::std::os::raw::c_int) -> *mut netent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getnetbyaddr(arg___net: u32, arg___type: ::std::os::raw::c_int) -> *mut netent;
        }
        getnetbyaddr(arg___net, arg___type)
    })
}
pub unsafe fn getnetbyname(arg___name: *const ::std::os::raw::c_char) -> *mut netent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getnetbyname(arg___name: *const ::std::os::raw::c_char) -> *mut netent;
        }
        getnetbyname(arg___name)
    })
}
pub unsafe fn getnetent_r(
    arg___result_buf: *mut netent,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut netent,
    arg___h_errnop: *mut ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getnetent_r(
                arg___result_buf: *mut netent,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut netent,
                arg___h_errnop: *mut ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        getnetent_r(
            arg___result_buf,
            arg___buf,
            arg___buflen,
            arg___result,
            arg___h_errnop,
        )
    })
}
pub unsafe fn getnetbyaddr_r(
    arg___net: u32,
    arg___type: ::std::os::raw::c_int,
    arg___result_buf: *mut netent,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut netent,
    arg___h_errnop: *mut ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getnetbyaddr_r(
                arg___net: u32,
                arg___type: ::std::os::raw::c_int,
                arg___result_buf: *mut netent,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut netent,
                arg___h_errnop: *mut ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        getnetbyaddr_r(
            arg___net,
            arg___type,
            arg___result_buf,
            arg___buf,
            arg___buflen,
            arg___result,
            arg___h_errnop,
        )
    })
}
pub unsafe fn getnetbyname_r(
    arg___name: *const ::std::os::raw::c_char,
    arg___result_buf: *mut netent,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut netent,
    arg___h_errnop: *mut ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getnetbyname_r(
                arg___name: *const ::std::os::raw::c_char,
                arg___result_buf: *mut netent,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut netent,
                arg___h_errnop: *mut ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        getnetbyname_r(
            arg___name,
            arg___result_buf,
            arg___buf,
            arg___buflen,
            arg___result,
            arg___h_errnop,
        )
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct servent {
    pub s_name: *mut ::std::os::raw::c_char,
    pub s_aliases: *mut *mut ::std::os::raw::c_char,
    pub s_port: ::std::os::raw::c_int,
    pub s_proto: *mut ::std::os::raw::c_char,
}
impl Default for servent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn setservent(arg___stay_open: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setservent(arg___stay_open: ::std::os::raw::c_int);
        }
        setservent(arg___stay_open)
    })
}
pub unsafe fn endservent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn endservent();
        }
        endservent()
    })
}
pub unsafe fn getservent() -> *mut servent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getservent() -> *mut servent;
        }
        getservent()
    })
}
pub unsafe fn getservbyname(
    arg___name: *const ::std::os::raw::c_char,
    arg___proto: *const ::std::os::raw::c_char,
) -> *mut servent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getservbyname(
                arg___name: *const ::std::os::raw::c_char,
                arg___proto: *const ::std::os::raw::c_char,
            ) -> *mut servent;
        }
        getservbyname(arg___name, arg___proto)
    })
}
pub unsafe fn getservbyport(
    arg___port: ::std::os::raw::c_int,
    arg___proto: *const ::std::os::raw::c_char,
) -> *mut servent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getservbyport(
                arg___port: ::std::os::raw::c_int,
                arg___proto: *const ::std::os::raw::c_char,
            ) -> *mut servent;
        }
        getservbyport(arg___port, arg___proto)
    })
}
pub unsafe fn getservent_r(
    arg___result_buf: *mut servent,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut servent,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getservent_r(
                arg___result_buf: *mut servent,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut servent,
            ) -> ::std::os::raw::c_int;
        }
        getservent_r(arg___result_buf, arg___buf, arg___buflen, arg___result)
    })
}
pub unsafe fn getservbyname_r(
    arg___name: *const ::std::os::raw::c_char,
    arg___proto: *const ::std::os::raw::c_char,
    arg___result_buf: *mut servent,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut servent,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getservbyname_r(
                arg___name: *const ::std::os::raw::c_char,
                arg___proto: *const ::std::os::raw::c_char,
                arg___result_buf: *mut servent,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut servent,
            ) -> ::std::os::raw::c_int;
        }
        getservbyname_r(
            arg___name,
            arg___proto,
            arg___result_buf,
            arg___buf,
            arg___buflen,
            arg___result,
        )
    })
}
pub unsafe fn getservbyport_r(
    arg___port: ::std::os::raw::c_int,
    arg___proto: *const ::std::os::raw::c_char,
    arg___result_buf: *mut servent,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut servent,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getservbyport_r(
                arg___port: ::std::os::raw::c_int,
                arg___proto: *const ::std::os::raw::c_char,
                arg___result_buf: *mut servent,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut servent,
            ) -> ::std::os::raw::c_int;
        }
        getservbyport_r(
            arg___port,
            arg___proto,
            arg___result_buf,
            arg___buf,
            arg___buflen,
            arg___result,
        )
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct protoent {
    pub p_name: *mut ::std::os::raw::c_char,
    pub p_aliases: *mut *mut ::std::os::raw::c_char,
    pub p_proto: ::std::os::raw::c_int,
}
impl Default for protoent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn setprotoent(arg___stay_open: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setprotoent(arg___stay_open: ::std::os::raw::c_int);
        }
        setprotoent(arg___stay_open)
    })
}
pub unsafe fn endprotoent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn endprotoent();
        }
        endprotoent()
    })
}
pub unsafe fn getprotoent() -> *mut protoent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getprotoent() -> *mut protoent;
        }
        getprotoent()
    })
}
pub unsafe fn getprotobyname(arg___name: *const ::std::os::raw::c_char) -> *mut protoent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getprotobyname(arg___name: *const ::std::os::raw::c_char) -> *mut protoent;
        }
        getprotobyname(arg___name)
    })
}
pub unsafe fn getprotobynumber(arg___proto: ::std::os::raw::c_int) -> *mut protoent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getprotobynumber(arg___proto: ::std::os::raw::c_int) -> *mut protoent;
        }
        getprotobynumber(arg___proto)
    })
}
pub unsafe fn getprotoent_r(
    arg___result_buf: *mut protoent,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut protoent,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getprotoent_r(
                arg___result_buf: *mut protoent,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut protoent,
            ) -> ::std::os::raw::c_int;
        }
        getprotoent_r(arg___result_buf, arg___buf, arg___buflen, arg___result)
    })
}
pub unsafe fn getprotobyname_r(
    arg___name: *const ::std::os::raw::c_char,
    arg___result_buf: *mut protoent,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut protoent,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getprotobyname_r(
                arg___name: *const ::std::os::raw::c_char,
                arg___result_buf: *mut protoent,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut protoent,
            ) -> ::std::os::raw::c_int;
        }
        getprotobyname_r(
            arg___name,
            arg___result_buf,
            arg___buf,
            arg___buflen,
            arg___result,
        )
    })
}
pub unsafe fn getprotobynumber_r(
    arg___proto: ::std::os::raw::c_int,
    arg___result_buf: *mut protoent,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut protoent,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getprotobynumber_r(
                arg___proto: ::std::os::raw::c_int,
                arg___result_buf: *mut protoent,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut protoent,
            ) -> ::std::os::raw::c_int;
        }
        getprotobynumber_r(
            arg___proto,
            arg___result_buf,
            arg___buf,
            arg___buflen,
            arg___result,
        )
    })
}
pub unsafe fn setnetgrent(arg___netgroup: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setnetgrent(arg___netgroup: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        setnetgrent(arg___netgroup)
    })
}
pub unsafe fn endnetgrent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn endnetgrent();
        }
        endnetgrent()
    })
}
pub unsafe fn getnetgrent(
    arg___hostp: *mut *mut ::std::os::raw::c_char,
    arg___userp: *mut *mut ::std::os::raw::c_char,
    arg___domainp: *mut *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getnetgrent(
                arg___hostp: *mut *mut ::std::os::raw::c_char,
                arg___userp: *mut *mut ::std::os::raw::c_char,
                arg___domainp: *mut *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        getnetgrent(arg___hostp, arg___userp, arg___domainp)
    })
}
pub unsafe fn innetgr(
    arg___netgroup: *const ::std::os::raw::c_char,
    arg___host: *const ::std::os::raw::c_char,
    arg___user: *const ::std::os::raw::c_char,
    arg___domain: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn innetgr(
                arg___netgroup: *const ::std::os::raw::c_char,
                arg___host: *const ::std::os::raw::c_char,
                arg___user: *const ::std::os::raw::c_char,
                arg___domain: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        innetgr(arg___netgroup, arg___host, arg___user, arg___domain)
    })
}
pub unsafe fn getnetgrent_r(
    arg___hostp: *mut *mut ::std::os::raw::c_char,
    arg___userp: *mut *mut ::std::os::raw::c_char,
    arg___domainp: *mut *mut ::std::os::raw::c_char,
    arg___buffer: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getnetgrent_r(
                arg___hostp: *mut *mut ::std::os::raw::c_char,
                arg___userp: *mut *mut ::std::os::raw::c_char,
                arg___domainp: *mut *mut ::std::os::raw::c_char,
                arg___buffer: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
            ) -> ::std::os::raw::c_int;
        }
        getnetgrent_r(
            arg___hostp,
            arg___userp,
            arg___domainp,
            arg___buffer,
            arg___buflen,
        )
    })
}
pub unsafe fn rcmd(
    arg___ahost: *mut *mut ::std::os::raw::c_char,
    arg___rport: ::std::os::raw::c_ushort,
    arg___locuser: *const ::std::os::raw::c_char,
    arg___remuser: *const ::std::os::raw::c_char,
    arg___cmd: *const ::std::os::raw::c_char,
    arg___fd2p: *mut ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rcmd(
                arg___ahost: *mut *mut ::std::os::raw::c_char,
                arg___rport: ::std::os::raw::c_ushort,
                arg___locuser: *const ::std::os::raw::c_char,
                arg___remuser: *const ::std::os::raw::c_char,
                arg___cmd: *const ::std::os::raw::c_char,
                arg___fd2p: *mut ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        rcmd(
            arg___ahost,
            arg___rport,
            arg___locuser,
            arg___remuser,
            arg___cmd,
            arg___fd2p,
        )
    })
}
pub unsafe fn rcmd_af(
    arg___ahost: *mut *mut ::std::os::raw::c_char,
    arg___rport: ::std::os::raw::c_ushort,
    arg___locuser: *const ::std::os::raw::c_char,
    arg___remuser: *const ::std::os::raw::c_char,
    arg___cmd: *const ::std::os::raw::c_char,
    arg___fd2p: *mut ::std::os::raw::c_int,
    arg___af: sa_family_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rcmd_af(
                arg___ahost: *mut *mut ::std::os::raw::c_char,
                arg___rport: ::std::os::raw::c_ushort,
                arg___locuser: *const ::std::os::raw::c_char,
                arg___remuser: *const ::std::os::raw::c_char,
                arg___cmd: *const ::std::os::raw::c_char,
                arg___fd2p: *mut ::std::os::raw::c_int,
                arg___af: sa_family_t,
            ) -> ::std::os::raw::c_int;
        }
        rcmd_af(
            arg___ahost,
            arg___rport,
            arg___locuser,
            arg___remuser,
            arg___cmd,
            arg___fd2p,
            arg___af,
        )
    })
}
pub unsafe fn rexec(
    arg___ahost: *mut *mut ::std::os::raw::c_char,
    arg___rport: ::std::os::raw::c_int,
    arg___name: *const ::std::os::raw::c_char,
    arg___pass: *const ::std::os::raw::c_char,
    arg___cmd: *const ::std::os::raw::c_char,
    arg___fd2p: *mut ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rexec(
                arg___ahost: *mut *mut ::std::os::raw::c_char,
                arg___rport: ::std::os::raw::c_int,
                arg___name: *const ::std::os::raw::c_char,
                arg___pass: *const ::std::os::raw::c_char,
                arg___cmd: *const ::std::os::raw::c_char,
                arg___fd2p: *mut ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        rexec(
            arg___ahost,
            arg___rport,
            arg___name,
            arg___pass,
            arg___cmd,
            arg___fd2p,
        )
    })
}
pub unsafe fn rexec_af(
    arg___ahost: *mut *mut ::std::os::raw::c_char,
    arg___rport: ::std::os::raw::c_int,
    arg___name: *const ::std::os::raw::c_char,
    arg___pass: *const ::std::os::raw::c_char,
    arg___cmd: *const ::std::os::raw::c_char,
    arg___fd2p: *mut ::std::os::raw::c_int,
    arg___af: sa_family_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rexec_af(
                arg___ahost: *mut *mut ::std::os::raw::c_char,
                arg___rport: ::std::os::raw::c_int,
                arg___name: *const ::std::os::raw::c_char,
                arg___pass: *const ::std::os::raw::c_char,
                arg___cmd: *const ::std::os::raw::c_char,
                arg___fd2p: *mut ::std::os::raw::c_int,
                arg___af: sa_family_t,
            ) -> ::std::os::raw::c_int;
        }
        rexec_af(
            arg___ahost,
            arg___rport,
            arg___name,
            arg___pass,
            arg___cmd,
            arg___fd2p,
            arg___af,
        )
    })
}
pub unsafe fn ruserok(
    arg___rhost: *const ::std::os::raw::c_char,
    arg___suser: ::std::os::raw::c_int,
    arg___remuser: *const ::std::os::raw::c_char,
    arg___locuser: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ruserok(
                arg___rhost: *const ::std::os::raw::c_char,
                arg___suser: ::std::os::raw::c_int,
                arg___remuser: *const ::std::os::raw::c_char,
                arg___locuser: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        ruserok(arg___rhost, arg___suser, arg___remuser, arg___locuser)
    })
}
pub unsafe fn ruserok_af(
    arg___rhost: *const ::std::os::raw::c_char,
    arg___suser: ::std::os::raw::c_int,
    arg___remuser: *const ::std::os::raw::c_char,
    arg___locuser: *const ::std::os::raw::c_char,
    arg___af: sa_family_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ruserok_af(
                arg___rhost: *const ::std::os::raw::c_char,
                arg___suser: ::std::os::raw::c_int,
                arg___remuser: *const ::std::os::raw::c_char,
                arg___locuser: *const ::std::os::raw::c_char,
                arg___af: sa_family_t,
            ) -> ::std::os::raw::c_int;
        }
        ruserok_af(
            arg___rhost,
            arg___suser,
            arg___remuser,
            arg___locuser,
            arg___af,
        )
    })
}
pub unsafe fn iruserok(
    arg___raddr: u32,
    arg___suser: ::std::os::raw::c_int,
    arg___remuser: *const ::std::os::raw::c_char,
    arg___locuser: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn iruserok(
                arg___raddr: u32,
                arg___suser: ::std::os::raw::c_int,
                arg___remuser: *const ::std::os::raw::c_char,
                arg___locuser: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        iruserok(arg___raddr, arg___suser, arg___remuser, arg___locuser)
    })
}
pub unsafe fn iruserok_af(
    arg___raddr: *const ::std::os::raw::c_void,
    arg___suser: ::std::os::raw::c_int,
    arg___remuser: *const ::std::os::raw::c_char,
    arg___locuser: *const ::std::os::raw::c_char,
    arg___af: sa_family_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn iruserok_af(
                arg___raddr: *const ::std::os::raw::c_void,
                arg___suser: ::std::os::raw::c_int,
                arg___remuser: *const ::std::os::raw::c_char,
                arg___locuser: *const ::std::os::raw::c_char,
                arg___af: sa_family_t,
            ) -> ::std::os::raw::c_int;
        }
        iruserok_af(
            arg___raddr,
            arg___suser,
            arg___remuser,
            arg___locuser,
            arg___af,
        )
    })
}
pub unsafe fn rresvport(arg___alport: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rresvport(arg___alport: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        rresvport(arg___alport)
    })
}
pub unsafe fn rresvport_af(
    arg___alport: *mut ::std::os::raw::c_int,
    arg___af: sa_family_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rresvport_af(
                arg___alport: *mut ::std::os::raw::c_int,
                arg___af: sa_family_t,
            ) -> ::std::os::raw::c_int;
        }
        rresvport_af(arg___alport, arg___af)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct addrinfo {
    pub ai_flags: ::std::os::raw::c_int,
    pub ai_family: ::std::os::raw::c_int,
    pub ai_socktype: ::std::os::raw::c_int,
    pub ai_protocol: ::std::os::raw::c_int,
    pub ai_addrlen: socklen_t,
    pub ai_addr: *mut sockaddr,
    pub ai_canonname: *mut ::std::os::raw::c_char,
    pub ai_next: *mut addrinfo,
}
impl Default for addrinfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn getaddrinfo(
    arg___name: *const ::std::os::raw::c_char,
    arg___service: *const ::std::os::raw::c_char,
    arg___req: *const addrinfo,
    arg___pai: *mut *mut addrinfo,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getaddrinfo(
                arg___name: *const ::std::os::raw::c_char,
                arg___service: *const ::std::os::raw::c_char,
                arg___req: *const addrinfo,
                arg___pai: *mut *mut addrinfo,
            ) -> ::std::os::raw::c_int;
        }
        getaddrinfo(arg___name, arg___service, arg___req, arg___pai)
    })
}
pub unsafe fn freeaddrinfo(arg___ai: *mut addrinfo) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn freeaddrinfo(arg___ai: *mut addrinfo);
        }
        freeaddrinfo(arg___ai)
    })
}
pub unsafe fn gai_strerror(arg___ecode: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gai_strerror(arg___ecode: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
        }
        gai_strerror(arg___ecode)
    })
}
pub unsafe fn getnameinfo(
    arg___sa: *const sockaddr,
    arg___salen: socklen_t,
    arg___host: *mut ::std::os::raw::c_char,
    arg___hostlen: socklen_t,
    arg___serv: *mut ::std::os::raw::c_char,
    arg___servlen: socklen_t,
    arg___flags: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getnameinfo(
                arg___sa: *const sockaddr,
                arg___salen: socklen_t,
                arg___host: *mut ::std::os::raw::c_char,
                arg___hostlen: socklen_t,
                arg___serv: *mut ::std::os::raw::c_char,
                arg___servlen: socklen_t,
                arg___flags: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        getnameinfo(
            arg___sa,
            arg___salen,
            arg___host,
            arg___hostlen,
            arg___serv,
            arg___servlen,
            arg___flags,
        )
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct passwd {
    pub pw_name: *mut ::std::os::raw::c_char,
    pub pw_passwd: *mut ::std::os::raw::c_char,
    pub pw_uid: __uid_t,
    pub pw_gid: __gid_t,
    pub pw_gecos: *mut ::std::os::raw::c_char,
    pub pw_dir: *mut ::std::os::raw::c_char,
    pub pw_shell: *mut ::std::os::raw::c_char,
}
impl Default for passwd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn setpwent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setpwent();
        }
        setpwent()
    })
}
pub unsafe fn endpwent() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn endpwent();
        }
        endpwent()
    })
}
pub unsafe fn getpwent() -> *mut passwd {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpwent() -> *mut passwd;
        }
        getpwent()
    })
}
pub unsafe fn fgetpwent(arg___stream: *mut FILE) -> *mut passwd {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fgetpwent(arg___stream: *mut FILE) -> *mut passwd;
        }
        fgetpwent(arg___stream)
    })
}
pub unsafe fn putpwent(arg___p: *const passwd, arg___f: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn putpwent(arg___p: *const passwd, arg___f: *mut FILE) -> ::std::os::raw::c_int;
        }
        putpwent(arg___p, arg___f)
    })
}
pub unsafe fn getpwuid(arg___uid: __uid_t) -> *mut passwd {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpwuid(arg___uid: __uid_t) -> *mut passwd;
        }
        getpwuid(arg___uid)
    })
}
pub unsafe fn getpwnam(arg___name: *const ::std::os::raw::c_char) -> *mut passwd {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpwnam(arg___name: *const ::std::os::raw::c_char) -> *mut passwd;
        }
        getpwnam(arg___name)
    })
}
pub unsafe fn getpwent_r(
    arg___resultbuf: *mut passwd,
    arg___buffer: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut passwd,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpwent_r(
                arg___resultbuf: *mut passwd,
                arg___buffer: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut passwd,
            ) -> ::std::os::raw::c_int;
        }
        getpwent_r(arg___resultbuf, arg___buffer, arg___buflen, arg___result)
    })
}
pub unsafe fn getpwuid_r(
    arg___uid: __uid_t,
    arg___resultbuf: *mut passwd,
    arg___buffer: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut passwd,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpwuid_r(
                arg___uid: __uid_t,
                arg___resultbuf: *mut passwd,
                arg___buffer: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut passwd,
            ) -> ::std::os::raw::c_int;
        }
        getpwuid_r(
            arg___uid,
            arg___resultbuf,
            arg___buffer,
            arg___buflen,
            arg___result,
        )
    })
}
pub unsafe fn getpwnam_r(
    arg___name: *const ::std::os::raw::c_char,
    arg___resultbuf: *mut passwd,
    arg___buffer: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut passwd,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpwnam_r(
                arg___name: *const ::std::os::raw::c_char,
                arg___resultbuf: *mut passwd,
                arg___buffer: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut passwd,
            ) -> ::std::os::raw::c_int;
        }
        getpwnam_r(
            arg___name,
            arg___resultbuf,
            arg___buffer,
            arg___buflen,
            arg___result,
        )
    })
}
pub unsafe fn fgetpwent_r(
    arg___stream: *mut FILE,
    arg___resultbuf: *mut passwd,
    arg___buffer: *mut ::std::os::raw::c_char,
    arg___buflen: usize,
    arg___result: *mut *mut passwd,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fgetpwent_r(
                arg___stream: *mut FILE,
                arg___resultbuf: *mut passwd,
                arg___buffer: *mut ::std::os::raw::c_char,
                arg___buflen: usize,
                arg___result: *mut *mut passwd,
            ) -> ::std::os::raw::c_int;
        }
        fgetpwent_r(
            arg___stream,
            arg___resultbuf,
            arg___buffer,
            arg___buflen,
            arg___result,
        )
    })
}
pub type pgsocket = ::std::os::raw::c_int;
pub unsafe fn pg_set_noblock(arg_sock: pgsocket) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_set_noblock(arg_sock: pgsocket) -> bool;
        }
        pg_set_noblock(arg_sock)
    })
}
pub unsafe fn pg_set_block(arg_sock: pgsocket) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_set_block(arg_sock: pgsocket) -> bool;
        }
        pg_set_block(arg_sock)
    })
}
pub unsafe fn has_drive_prefix(arg_filename: *const ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn has_drive_prefix(arg_filename: *const ::std::os::raw::c_char) -> bool;
        }
        has_drive_prefix(arg_filename)
    })
}
pub unsafe fn first_dir_separator(
    arg_filename: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn first_dir_separator(
                arg_filename: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        first_dir_separator(arg_filename)
    })
}
pub unsafe fn last_dir_separator(
    arg_filename: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn last_dir_separator(
                arg_filename: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        last_dir_separator(arg_filename)
    })
}
pub unsafe fn first_path_var_separator(
    arg_pathlist: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn first_path_var_separator(
                arg_pathlist: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        first_path_var_separator(arg_pathlist)
    })
}
pub unsafe fn join_path_components(
    arg_ret_path: *mut ::std::os::raw::c_char,
    arg_head: *const ::std::os::raw::c_char,
    arg_tail: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn join_path_components(
                arg_ret_path: *mut ::std::os::raw::c_char,
                arg_head: *const ::std::os::raw::c_char,
                arg_tail: *const ::std::os::raw::c_char,
            );
        }
        join_path_components(arg_ret_path, arg_head, arg_tail)
    })
}
pub unsafe fn canonicalize_path(arg_path: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn canonicalize_path(arg_path: *mut ::std::os::raw::c_char);
        }
        canonicalize_path(arg_path)
    })
}
pub unsafe fn make_native_path(arg_path: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn make_native_path(arg_path: *mut ::std::os::raw::c_char);
        }
        make_native_path(arg_path)
    })
}
pub unsafe fn cleanup_path(arg_path: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cleanup_path(arg_path: *mut ::std::os::raw::c_char);
        }
        cleanup_path(arg_path)
    })
}
pub unsafe fn path_contains_parent_reference(arg_path: *const ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn path_contains_parent_reference(arg_path: *const ::std::os::raw::c_char) -> bool;
        }
        path_contains_parent_reference(arg_path)
    })
}
pub unsafe fn path_is_relative_and_below_cwd(arg_path: *const ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn path_is_relative_and_below_cwd(arg_path: *const ::std::os::raw::c_char) -> bool;
        }
        path_is_relative_and_below_cwd(arg_path)
    })
}
pub unsafe fn path_is_prefix_of_path(
    arg_path1: *const ::std::os::raw::c_char,
    arg_path2: *const ::std::os::raw::c_char,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn path_is_prefix_of_path(
                arg_path1: *const ::std::os::raw::c_char,
                arg_path2: *const ::std::os::raw::c_char,
            ) -> bool;
        }
        path_is_prefix_of_path(arg_path1, arg_path2)
    })
}
pub unsafe fn make_absolute_path(
    arg_path: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn make_absolute_path(
                arg_path: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        make_absolute_path(arg_path)
    })
}
pub unsafe fn get_progname(
    arg_argv0: *const ::std::os::raw::c_char,
) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_progname(
                arg_argv0: *const ::std::os::raw::c_char,
            ) -> *const ::std::os::raw::c_char;
        }
        get_progname(arg_argv0)
    })
}
pub unsafe fn get_share_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_share_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_share_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_etc_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_etc_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_etc_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_include_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_include_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_include_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_pkginclude_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_pkginclude_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_pkginclude_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_includeserver_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_includeserver_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_includeserver_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_lib_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_lib_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_lib_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_pkglib_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_pkglib_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_pkglib_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_locale_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_locale_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_locale_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_doc_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_doc_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_doc_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_html_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_html_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_html_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_man_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_man_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_man_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_home_path(arg_ret_path: *mut ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_home_path(arg_ret_path: *mut ::std::os::raw::c_char) -> bool;
        }
        get_home_path(arg_ret_path)
    })
}
pub unsafe fn get_parent_directory(arg_path: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_parent_directory(arg_path: *mut ::std::os::raw::c_char);
        }
        get_parent_directory(arg_path)
    })
}
pub unsafe fn pgfnames(
    arg_path: *const ::std::os::raw::c_char,
) -> *mut *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgfnames(
                arg_path: *const ::std::os::raw::c_char,
            ) -> *mut *mut ::std::os::raw::c_char;
        }
        pgfnames(arg_path)
    })
}
pub unsafe fn pgfnames_cleanup(arg_filenames: *mut *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgfnames_cleanup(arg_filenames: *mut *mut ::std::os::raw::c_char);
        }
        pgfnames_cleanup(arg_filenames)
    })
}
pub unsafe fn set_pglocale_pgservice(
    arg_argv0: *const ::std::os::raw::c_char,
    arg_app: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_pglocale_pgservice(
                arg_argv0: *const ::std::os::raw::c_char,
                arg_app: *const ::std::os::raw::c_char,
            );
        }
        set_pglocale_pgservice(arg_argv0, arg_app)
    })
}
pub unsafe fn find_my_exec(
    arg_argv0: *const ::std::os::raw::c_char,
    arg_retpath: *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn find_my_exec(
                arg_argv0: *const ::std::os::raw::c_char,
                arg_retpath: *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        find_my_exec(arg_argv0, arg_retpath)
    })
}
pub unsafe fn find_other_exec(
    arg_argv0: *const ::std::os::raw::c_char,
    arg_target: *const ::std::os::raw::c_char,
    arg_versionstr: *const ::std::os::raw::c_char,
    arg_retpath: *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn find_other_exec(
                arg_argv0: *const ::std::os::raw::c_char,
                arg_target: *const ::std::os::raw::c_char,
                arg_versionstr: *const ::std::os::raw::c_char,
                arg_retpath: *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        find_other_exec(arg_argv0, arg_target, arg_versionstr, arg_retpath)
    })
}
pub unsafe fn pg_usleep(arg_microsec: ::std::os::raw::c_long) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_usleep(arg_microsec: ::std::os::raw::c_long);
        }
        pg_usleep(arg_microsec)
    })
}
pub unsafe fn pg_strcasecmp(
    arg_s1: *const ::std::os::raw::c_char,
    arg_s2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strcasecmp(
                arg_s1: *const ::std::os::raw::c_char,
                arg_s2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        pg_strcasecmp(arg_s1, arg_s2)
    })
}
pub unsafe fn pg_strncasecmp(
    arg_s1: *const ::std::os::raw::c_char,
    arg_s2: *const ::std::os::raw::c_char,
    arg_n: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strncasecmp(
                arg_s1: *const ::std::os::raw::c_char,
                arg_s2: *const ::std::os::raw::c_char,
                arg_n: usize,
            ) -> ::std::os::raw::c_int;
        }
        pg_strncasecmp(arg_s1, arg_s2, arg_n)
    })
}
pub unsafe fn pg_toupper(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_toupper(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
        }
        pg_toupper(arg_ch)
    })
}
pub unsafe fn pg_tolower(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_tolower(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
        }
        pg_tolower(arg_ch)
    })
}
pub unsafe fn pg_ascii_toupper(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_ascii_toupper(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
        }
        pg_ascii_toupper(arg_ch)
    })
}
pub unsafe fn pg_ascii_tolower(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_ascii_tolower(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
        }
        pg_ascii_tolower(arg_ch)
    })
}
pub unsafe fn pg_vsnprintf(
    arg_str_: *mut ::std::os::raw::c_char,
    arg_count: usize,
    arg_fmt: *const ::std::os::raw::c_char,
    arg_args: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_vsnprintf(
                arg_str_: *mut ::std::os::raw::c_char,
                arg_count: usize,
                arg_fmt: *const ::std::os::raw::c_char,
                arg_args: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        pg_vsnprintf(arg_str_, arg_count, arg_fmt, arg_args)
    })
}
pub unsafe fn pg_snprintf(
    arg_str_: *mut ::std::os::raw::c_char,
    arg_count: usize,
    arg_fmt: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_snprintf(
                arg_str_: *mut ::std::os::raw::c_char,
                arg_count: usize,
                arg_fmt: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        pg_snprintf(arg_str_, arg_count, arg_fmt)
    })
}
pub unsafe fn pg_vsprintf(
    arg_str_: *mut ::std::os::raw::c_char,
    arg_fmt: *const ::std::os::raw::c_char,
    arg_args: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_vsprintf(
                arg_str_: *mut ::std::os::raw::c_char,
                arg_fmt: *const ::std::os::raw::c_char,
                arg_args: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        pg_vsprintf(arg_str_, arg_fmt, arg_args)
    })
}
pub unsafe fn pg_sprintf(
    arg_str_: *mut ::std::os::raw::c_char,
    arg_fmt: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_sprintf(
                arg_str_: *mut ::std::os::raw::c_char,
                arg_fmt: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        pg_sprintf(arg_str_, arg_fmt)
    })
}
pub unsafe fn pg_vfprintf(
    arg_stream: *mut FILE,
    arg_fmt: *const ::std::os::raw::c_char,
    arg_args: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_vfprintf(
                arg_stream: *mut FILE,
                arg_fmt: *const ::std::os::raw::c_char,
                arg_args: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        pg_vfprintf(arg_stream, arg_fmt, arg_args)
    })
}
pub unsafe fn pg_fprintf(
    arg_stream: *mut FILE,
    arg_fmt: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fprintf(
                arg_stream: *mut FILE,
                arg_fmt: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        pg_fprintf(arg_stream, arg_fmt)
    })
}
pub unsafe fn pg_vprintf(
    arg_fmt: *const ::std::os::raw::c_char,
    arg_args: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_vprintf(
                arg_fmt: *const ::std::os::raw::c_char,
                arg_args: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        pg_vprintf(arg_fmt, arg_args)
    })
}
pub unsafe fn pg_printf(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_printf(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        pg_printf(arg_fmt)
    })
}
pub unsafe fn pg_strfromd(
    arg_str_: *mut ::std::os::raw::c_char,
    arg_count: usize,
    arg_precision: ::std::os::raw::c_int,
    arg_value: f64,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strfromd(
                arg_str_: *mut ::std::os::raw::c_char,
                arg_count: usize,
                arg_precision: ::std::os::raw::c_int,
                arg_value: f64,
            ) -> ::std::os::raw::c_int;
        }
        pg_strfromd(arg_str_, arg_count, arg_precision, arg_value)
    })
}
pub unsafe fn pg_strerror(arg_errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strerror(arg_errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
        }
        pg_strerror(arg_errnum)
    })
}
pub unsafe fn pg_strerror_r(
    arg_errnum: ::std::os::raw::c_int,
    arg_buf: *mut ::std::os::raw::c_char,
    arg_buflen: usize,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strerror_r(
                arg_errnum: ::std::os::raw::c_int,
                arg_buf: *mut ::std::os::raw::c_char,
                arg_buflen: usize,
            ) -> *mut ::std::os::raw::c_char;
        }
        pg_strerror_r(arg_errnum, arg_buf, arg_buflen)
    })
}
pub unsafe fn pg_strsignal(arg_signum: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strsignal(arg_signum: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
        }
        pg_strsignal(arg_signum)
    })
}
pub unsafe fn simple_prompt(
    arg_prompt: *const ::std::os::raw::c_char,
    arg_destination: *mut ::std::os::raw::c_char,
    arg_destlen: usize,
    arg_echo: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn simple_prompt(
                arg_prompt: *const ::std::os::raw::c_char,
                arg_destination: *mut ::std::os::raw::c_char,
                arg_destlen: usize,
                arg_echo: bool,
            );
        }
        simple_prompt(arg_prompt, arg_destination, arg_destlen, arg_echo)
    })
}
pub unsafe fn pclose_check(arg_stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pclose_check(arg_stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        pclose_check(arg_stream)
    })
}
pub unsafe fn rmtree(arg_path: *const ::std::os::raw::c_char, arg_rmtopdir: bool) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rmtree(arg_path: *const ::std::os::raw::c_char, arg_rmtopdir: bool) -> bool;
        }
        rmtree(arg_path, arg_rmtopdir)
    })
}
pub unsafe fn pg_erand48(arg_xseed: *mut ::std::os::raw::c_ushort) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_erand48(arg_xseed: *mut ::std::os::raw::c_ushort) -> f64;
        }
        pg_erand48(arg_xseed)
    })
}
pub unsafe fn pg_lrand48() -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_lrand48() -> ::std::os::raw::c_long;
        }
        pg_lrand48()
    })
}
pub unsafe fn pg_jrand48(arg_xseed: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_jrand48(arg_xseed: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
        }
        pg_jrand48(arg_xseed)
    })
}
pub unsafe fn pg_srand48(arg_seed: ::std::os::raw::c_long) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_srand48(arg_seed: ::std::os::raw::c_long);
        }
        pg_srand48(arg_seed)
    })
}
pub unsafe fn fls(arg_mask: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fls(arg_mask: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        fls(arg_mask)
    })
}
pub unsafe fn getpeereid(
    arg_sock: ::std::os::raw::c_int,
    arg_uid: *mut uid_t,
    arg_gid: *mut gid_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpeereid(
                arg_sock: ::std::os::raw::c_int,
                arg_uid: *mut uid_t,
                arg_gid: *mut gid_t,
            ) -> ::std::os::raw::c_int;
        }
        getpeereid(arg_sock, arg_uid, arg_gid)
    })
}
pub type float_t = f32;
pub type double_t = f64;
pub unsafe fn __fpclassify(arg___value: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fpclassify(arg___value: f64) -> ::std::os::raw::c_int;
        }
        __fpclassify(arg___value)
    })
}
pub unsafe fn __signbit(arg___value: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __signbit(arg___value: f64) -> ::std::os::raw::c_int;
        }
        __signbit(arg___value)
    })
}
pub unsafe fn __isinf(arg___value: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __isinf(arg___value: f64) -> ::std::os::raw::c_int;
        }
        __isinf(arg___value)
    })
}
pub unsafe fn __finite(arg___value: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __finite(arg___value: f64) -> ::std::os::raw::c_int;
        }
        __finite(arg___value)
    })
}
pub unsafe fn __isnan(arg___value: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __isnan(arg___value: f64) -> ::std::os::raw::c_int;
        }
        __isnan(arg___value)
    })
}
pub unsafe fn __iseqsig(arg___x: f64, arg___y: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __iseqsig(arg___x: f64, arg___y: f64) -> ::std::os::raw::c_int;
        }
        __iseqsig(arg___x, arg___y)
    })
}
pub unsafe fn __issignaling(arg___value: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __issignaling(arg___value: f64) -> ::std::os::raw::c_int;
        }
        __issignaling(arg___value)
    })
}
pub unsafe fn acos(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn acos(arg___x: f64) -> f64;
        }
        acos(arg___x)
    })
}
pub unsafe fn __acos(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __acos(arg___x: f64) -> f64;
        }
        __acos(arg___x)
    })
}
pub unsafe fn asin(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asin(arg___x: f64) -> f64;
        }
        asin(arg___x)
    })
}
pub unsafe fn __asin(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __asin(arg___x: f64) -> f64;
        }
        __asin(arg___x)
    })
}
pub unsafe fn atan(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atan(arg___x: f64) -> f64;
        }
        atan(arg___x)
    })
}
pub unsafe fn __atan(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __atan(arg___x: f64) -> f64;
        }
        __atan(arg___x)
    })
}
pub unsafe fn atan2(arg___y: f64, arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atan2(arg___y: f64, arg___x: f64) -> f64;
        }
        atan2(arg___y, arg___x)
    })
}
pub unsafe fn __atan2(arg___y: f64, arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __atan2(arg___y: f64, arg___x: f64) -> f64;
        }
        __atan2(arg___y, arg___x)
    })
}
pub unsafe fn cos(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cos(arg___x: f64) -> f64;
        }
        cos(arg___x)
    })
}
pub unsafe fn __cos(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __cos(arg___x: f64) -> f64;
        }
        __cos(arg___x)
    })
}
pub unsafe fn sin(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sin(arg___x: f64) -> f64;
        }
        sin(arg___x)
    })
}
pub unsafe fn __sin(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sin(arg___x: f64) -> f64;
        }
        __sin(arg___x)
    })
}
pub unsafe fn tan(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tan(arg___x: f64) -> f64;
        }
        tan(arg___x)
    })
}
pub unsafe fn __tan(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __tan(arg___x: f64) -> f64;
        }
        __tan(arg___x)
    })
}
pub unsafe fn cosh(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cosh(arg___x: f64) -> f64;
        }
        cosh(arg___x)
    })
}
pub unsafe fn __cosh(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __cosh(arg___x: f64) -> f64;
        }
        __cosh(arg___x)
    })
}
pub unsafe fn sinh(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sinh(arg___x: f64) -> f64;
        }
        sinh(arg___x)
    })
}
pub unsafe fn __sinh(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sinh(arg___x: f64) -> f64;
        }
        __sinh(arg___x)
    })
}
pub unsafe fn tanh(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tanh(arg___x: f64) -> f64;
        }
        tanh(arg___x)
    })
}
pub unsafe fn __tanh(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __tanh(arg___x: f64) -> f64;
        }
        __tanh(arg___x)
    })
}
pub unsafe fn acosh(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn acosh(arg___x: f64) -> f64;
        }
        acosh(arg___x)
    })
}
pub unsafe fn __acosh(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __acosh(arg___x: f64) -> f64;
        }
        __acosh(arg___x)
    })
}
pub unsafe fn asinh(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asinh(arg___x: f64) -> f64;
        }
        asinh(arg___x)
    })
}
pub unsafe fn __asinh(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __asinh(arg___x: f64) -> f64;
        }
        __asinh(arg___x)
    })
}
pub unsafe fn atanh(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atanh(arg___x: f64) -> f64;
        }
        atanh(arg___x)
    })
}
pub unsafe fn __atanh(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __atanh(arg___x: f64) -> f64;
        }
        __atanh(arg___x)
    })
}
pub unsafe fn exp(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn exp(arg___x: f64) -> f64;
        }
        exp(arg___x)
    })
}
pub unsafe fn __exp(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __exp(arg___x: f64) -> f64;
        }
        __exp(arg___x)
    })
}
pub unsafe fn frexp(arg___x: f64, arg___exponent: *mut ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn frexp(arg___x: f64, arg___exponent: *mut ::std::os::raw::c_int) -> f64;
        }
        frexp(arg___x, arg___exponent)
    })
}
pub unsafe fn __frexp(arg___x: f64, arg___exponent: *mut ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __frexp(arg___x: f64, arg___exponent: *mut ::std::os::raw::c_int) -> f64;
        }
        __frexp(arg___x, arg___exponent)
    })
}
pub unsafe fn ldexp(arg___x: f64, arg___exponent: ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ldexp(arg___x: f64, arg___exponent: ::std::os::raw::c_int) -> f64;
        }
        ldexp(arg___x, arg___exponent)
    })
}
pub unsafe fn __ldexp(arg___x: f64, arg___exponent: ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ldexp(arg___x: f64, arg___exponent: ::std::os::raw::c_int) -> f64;
        }
        __ldexp(arg___x, arg___exponent)
    })
}
pub unsafe fn log(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log(arg___x: f64) -> f64;
        }
        log(arg___x)
    })
}
pub unsafe fn __log(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __log(arg___x: f64) -> f64;
        }
        __log(arg___x)
    })
}
pub unsafe fn log10(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log10(arg___x: f64) -> f64;
        }
        log10(arg___x)
    })
}
pub unsafe fn __log10(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __log10(arg___x: f64) -> f64;
        }
        __log10(arg___x)
    })
}
pub unsafe fn modf(arg___x: f64, arg___iptr: *mut f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn modf(arg___x: f64, arg___iptr: *mut f64) -> f64;
        }
        modf(arg___x, arg___iptr)
    })
}
pub unsafe fn __modf(arg___x: f64, arg___iptr: *mut f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __modf(arg___x: f64, arg___iptr: *mut f64) -> f64;
        }
        __modf(arg___x, arg___iptr)
    })
}
pub unsafe fn expm1(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn expm1(arg___x: f64) -> f64;
        }
        expm1(arg___x)
    })
}
pub unsafe fn __expm1(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __expm1(arg___x: f64) -> f64;
        }
        __expm1(arg___x)
    })
}
pub unsafe fn log1p(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log1p(arg___x: f64) -> f64;
        }
        log1p(arg___x)
    })
}
pub unsafe fn __log1p(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __log1p(arg___x: f64) -> f64;
        }
        __log1p(arg___x)
    })
}
pub unsafe fn logb(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn logb(arg___x: f64) -> f64;
        }
        logb(arg___x)
    })
}
pub unsafe fn __logb(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __logb(arg___x: f64) -> f64;
        }
        __logb(arg___x)
    })
}
pub unsafe fn exp2(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn exp2(arg___x: f64) -> f64;
        }
        exp2(arg___x)
    })
}
pub unsafe fn __exp2(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __exp2(arg___x: f64) -> f64;
        }
        __exp2(arg___x)
    })
}
pub unsafe fn log2(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log2(arg___x: f64) -> f64;
        }
        log2(arg___x)
    })
}
pub unsafe fn __log2(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __log2(arg___x: f64) -> f64;
        }
        __log2(arg___x)
    })
}
pub unsafe fn pow(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pow(arg___x: f64, arg___y: f64) -> f64;
        }
        pow(arg___x, arg___y)
    })
}
pub unsafe fn __pow(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __pow(arg___x: f64, arg___y: f64) -> f64;
        }
        __pow(arg___x, arg___y)
    })
}
pub unsafe fn sqrt(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sqrt(arg___x: f64) -> f64;
        }
        sqrt(arg___x)
    })
}
pub unsafe fn __sqrt(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sqrt(arg___x: f64) -> f64;
        }
        __sqrt(arg___x)
    })
}
pub unsafe fn hypot(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hypot(arg___x: f64, arg___y: f64) -> f64;
        }
        hypot(arg___x, arg___y)
    })
}
pub unsafe fn __hypot(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __hypot(arg___x: f64, arg___y: f64) -> f64;
        }
        __hypot(arg___x, arg___y)
    })
}
pub unsafe fn cbrt(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cbrt(arg___x: f64) -> f64;
        }
        cbrt(arg___x)
    })
}
pub unsafe fn __cbrt(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __cbrt(arg___x: f64) -> f64;
        }
        __cbrt(arg___x)
    })
}
pub unsafe fn ceil(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ceil(arg___x: f64) -> f64;
        }
        ceil(arg___x)
    })
}
pub unsafe fn __ceil(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ceil(arg___x: f64) -> f64;
        }
        __ceil(arg___x)
    })
}
pub unsafe fn fabs(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fabs(arg___x: f64) -> f64;
        }
        fabs(arg___x)
    })
}
pub unsafe fn __fabs(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fabs(arg___x: f64) -> f64;
        }
        __fabs(arg___x)
    })
}
pub unsafe fn floor(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn floor(arg___x: f64) -> f64;
        }
        floor(arg___x)
    })
}
pub unsafe fn __floor(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __floor(arg___x: f64) -> f64;
        }
        __floor(arg___x)
    })
}
pub unsafe fn fmod(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmod(arg___x: f64, arg___y: f64) -> f64;
        }
        fmod(arg___x, arg___y)
    })
}
pub unsafe fn __fmod(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fmod(arg___x: f64, arg___y: f64) -> f64;
        }
        __fmod(arg___x, arg___y)
    })
}
pub unsafe fn isinf(arg___value: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isinf(arg___value: f64) -> ::std::os::raw::c_int;
        }
        isinf(arg___value)
    })
}
pub unsafe fn finite(arg___value: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn finite(arg___value: f64) -> ::std::os::raw::c_int;
        }
        finite(arg___value)
    })
}
pub unsafe fn drem(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn drem(arg___x: f64, arg___y: f64) -> f64;
        }
        drem(arg___x, arg___y)
    })
}
pub unsafe fn __drem(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __drem(arg___x: f64, arg___y: f64) -> f64;
        }
        __drem(arg___x, arg___y)
    })
}
pub unsafe fn significand(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn significand(arg___x: f64) -> f64;
        }
        significand(arg___x)
    })
}
pub unsafe fn __significand(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __significand(arg___x: f64) -> f64;
        }
        __significand(arg___x)
    })
}
pub unsafe fn copysign(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn copysign(arg___x: f64, arg___y: f64) -> f64;
        }
        copysign(arg___x, arg___y)
    })
}
pub unsafe fn __copysign(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __copysign(arg___x: f64, arg___y: f64) -> f64;
        }
        __copysign(arg___x, arg___y)
    })
}
pub unsafe fn nan(arg___tagb: *const ::std::os::raw::c_char) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nan(arg___tagb: *const ::std::os::raw::c_char) -> f64;
        }
        nan(arg___tagb)
    })
}
pub unsafe fn __nan(arg___tagb: *const ::std::os::raw::c_char) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __nan(arg___tagb: *const ::std::os::raw::c_char) -> f64;
        }
        __nan(arg___tagb)
    })
}
pub unsafe fn isnan(arg___value: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isnan(arg___value: f64) -> ::std::os::raw::c_int;
        }
        isnan(arg___value)
    })
}
pub unsafe fn j0(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn j0(arg_arg1: f64) -> f64;
        }
        j0(arg_arg1)
    })
}
pub unsafe fn __j0(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __j0(arg_arg1: f64) -> f64;
        }
        __j0(arg_arg1)
    })
}
pub unsafe fn j1(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn j1(arg_arg1: f64) -> f64;
        }
        j1(arg_arg1)
    })
}
pub unsafe fn __j1(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __j1(arg_arg1: f64) -> f64;
        }
        __j1(arg_arg1)
    })
}
pub unsafe fn jn(arg_arg1: ::std::os::raw::c_int, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn jn(arg_arg1: ::std::os::raw::c_int, arg_arg2: f64) -> f64;
        }
        jn(arg_arg1, arg_arg2)
    })
}
pub unsafe fn __jn(arg_arg1: ::std::os::raw::c_int, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __jn(arg_arg1: ::std::os::raw::c_int, arg_arg2: f64) -> f64;
        }
        __jn(arg_arg1, arg_arg2)
    })
}
pub unsafe fn y0(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn y0(arg_arg1: f64) -> f64;
        }
        y0(arg_arg1)
    })
}
pub unsafe fn __y0(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __y0(arg_arg1: f64) -> f64;
        }
        __y0(arg_arg1)
    })
}
pub unsafe fn y1(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn y1(arg_arg1: f64) -> f64;
        }
        y1(arg_arg1)
    })
}
pub unsafe fn __y1(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __y1(arg_arg1: f64) -> f64;
        }
        __y1(arg_arg1)
    })
}
pub unsafe fn yn(arg_arg1: ::std::os::raw::c_int, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn yn(arg_arg1: ::std::os::raw::c_int, arg_arg2: f64) -> f64;
        }
        yn(arg_arg1, arg_arg2)
    })
}
pub unsafe fn __yn(arg_arg1: ::std::os::raw::c_int, arg_arg2: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __yn(arg_arg1: ::std::os::raw::c_int, arg_arg2: f64) -> f64;
        }
        __yn(arg_arg1, arg_arg2)
    })
}
pub unsafe fn erf(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erf(arg_arg1: f64) -> f64;
        }
        erf(arg_arg1)
    })
}
pub unsafe fn __erf(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __erf(arg_arg1: f64) -> f64;
        }
        __erf(arg_arg1)
    })
}
pub unsafe fn erfc(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erfc(arg_arg1: f64) -> f64;
        }
        erfc(arg_arg1)
    })
}
pub unsafe fn __erfc(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __erfc(arg_arg1: f64) -> f64;
        }
        __erfc(arg_arg1)
    })
}
pub unsafe fn lgamma(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lgamma(arg_arg1: f64) -> f64;
        }
        lgamma(arg_arg1)
    })
}
pub unsafe fn __lgamma(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __lgamma(arg_arg1: f64) -> f64;
        }
        __lgamma(arg_arg1)
    })
}
pub unsafe fn tgamma(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tgamma(arg_arg1: f64) -> f64;
        }
        tgamma(arg_arg1)
    })
}
pub unsafe fn __tgamma(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __tgamma(arg_arg1: f64) -> f64;
        }
        __tgamma(arg_arg1)
    })
}
pub unsafe fn gamma(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gamma(arg_arg1: f64) -> f64;
        }
        gamma(arg_arg1)
    })
}
pub unsafe fn __gamma(arg_arg1: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __gamma(arg_arg1: f64) -> f64;
        }
        __gamma(arg_arg1)
    })
}
pub unsafe fn lgamma_r(arg_arg1: f64, arg___signgamp: *mut ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lgamma_r(arg_arg1: f64, arg___signgamp: *mut ::std::os::raw::c_int) -> f64;
        }
        lgamma_r(arg_arg1, arg___signgamp)
    })
}
pub unsafe fn __lgamma_r(arg_arg1: f64, arg___signgamp: *mut ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __lgamma_r(arg_arg1: f64, arg___signgamp: *mut ::std::os::raw::c_int) -> f64;
        }
        __lgamma_r(arg_arg1, arg___signgamp)
    })
}
pub unsafe fn rint(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rint(arg___x: f64) -> f64;
        }
        rint(arg___x)
    })
}
pub unsafe fn __rint(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __rint(arg___x: f64) -> f64;
        }
        __rint(arg___x)
    })
}
pub unsafe fn nextafter(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nextafter(arg___x: f64, arg___y: f64) -> f64;
        }
        nextafter(arg___x, arg___y)
    })
}
pub unsafe fn __nextafter(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __nextafter(arg___x: f64, arg___y: f64) -> f64;
        }
        __nextafter(arg___x, arg___y)
    })
}
pub unsafe fn nexttoward(arg___x: f64, arg___y: u128) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nexttoward(arg___x: f64, arg___y: u128) -> f64;
        }
        nexttoward(arg___x, arg___y)
    })
}
pub unsafe fn __nexttoward(arg___x: f64, arg___y: u128) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __nexttoward(arg___x: f64, arg___y: u128) -> f64;
        }
        __nexttoward(arg___x, arg___y)
    })
}
pub unsafe fn remainder(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn remainder(arg___x: f64, arg___y: f64) -> f64;
        }
        remainder(arg___x, arg___y)
    })
}
pub unsafe fn __remainder(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __remainder(arg___x: f64, arg___y: f64) -> f64;
        }
        __remainder(arg___x, arg___y)
    })
}
pub unsafe fn scalbn(arg___x: f64, arg___n: ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalbn(arg___x: f64, arg___n: ::std::os::raw::c_int) -> f64;
        }
        scalbn(arg___x, arg___n)
    })
}
pub unsafe fn __scalbn(arg___x: f64, arg___n: ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __scalbn(arg___x: f64, arg___n: ::std::os::raw::c_int) -> f64;
        }
        __scalbn(arg___x, arg___n)
    })
}
pub unsafe fn ilogb(arg___x: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ilogb(arg___x: f64) -> ::std::os::raw::c_int;
        }
        ilogb(arg___x)
    })
}
pub unsafe fn __ilogb(arg___x: f64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ilogb(arg___x: f64) -> ::std::os::raw::c_int;
        }
        __ilogb(arg___x)
    })
}
pub unsafe fn scalbln(arg___x: f64, arg___n: ::std::os::raw::c_long) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalbln(arg___x: f64, arg___n: ::std::os::raw::c_long) -> f64;
        }
        scalbln(arg___x, arg___n)
    })
}
pub unsafe fn __scalbln(arg___x: f64, arg___n: ::std::os::raw::c_long) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __scalbln(arg___x: f64, arg___n: ::std::os::raw::c_long) -> f64;
        }
        __scalbln(arg___x, arg___n)
    })
}
pub unsafe fn nearbyint(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nearbyint(arg___x: f64) -> f64;
        }
        nearbyint(arg___x)
    })
}
pub unsafe fn __nearbyint(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __nearbyint(arg___x: f64) -> f64;
        }
        __nearbyint(arg___x)
    })
}
pub unsafe fn round(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn round(arg___x: f64) -> f64;
        }
        round(arg___x)
    })
}
pub unsafe fn __round(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __round(arg___x: f64) -> f64;
        }
        __round(arg___x)
    })
}
pub unsafe fn trunc(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn trunc(arg___x: f64) -> f64;
        }
        trunc(arg___x)
    })
}
pub unsafe fn __trunc(arg___x: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __trunc(arg___x: f64) -> f64;
        }
        __trunc(arg___x)
    })
}
pub unsafe fn remquo(arg___x: f64, arg___y: f64, arg___quo: *mut ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn remquo(arg___x: f64, arg___y: f64, arg___quo: *mut ::std::os::raw::c_int) -> f64;
        }
        remquo(arg___x, arg___y, arg___quo)
    })
}
pub unsafe fn __remquo(arg___x: f64, arg___y: f64, arg___quo: *mut ::std::os::raw::c_int) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __remquo(arg___x: f64, arg___y: f64, arg___quo: *mut ::std::os::raw::c_int) -> f64;
        }
        __remquo(arg___x, arg___y, arg___quo)
    })
}
pub unsafe fn lrint(arg___x: f64) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lrint(arg___x: f64) -> ::std::os::raw::c_long;
        }
        lrint(arg___x)
    })
}
pub unsafe fn __lrint(arg___x: f64) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __lrint(arg___x: f64) -> ::std::os::raw::c_long;
        }
        __lrint(arg___x)
    })
}
pub unsafe fn llrint(arg___x: f64) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn llrint(arg___x: f64) -> ::std::os::raw::c_longlong;
        }
        llrint(arg___x)
    })
}
pub unsafe fn __llrint(arg___x: f64) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __llrint(arg___x: f64) -> ::std::os::raw::c_longlong;
        }
        __llrint(arg___x)
    })
}
pub unsafe fn lround(arg___x: f64) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lround(arg___x: f64) -> ::std::os::raw::c_long;
        }
        lround(arg___x)
    })
}
pub unsafe fn __lround(arg___x: f64) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __lround(arg___x: f64) -> ::std::os::raw::c_long;
        }
        __lround(arg___x)
    })
}
pub unsafe fn llround(arg___x: f64) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn llround(arg___x: f64) -> ::std::os::raw::c_longlong;
        }
        llround(arg___x)
    })
}
pub unsafe fn __llround(arg___x: f64) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __llround(arg___x: f64) -> ::std::os::raw::c_longlong;
        }
        __llround(arg___x)
    })
}
pub unsafe fn fdim(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fdim(arg___x: f64, arg___y: f64) -> f64;
        }
        fdim(arg___x, arg___y)
    })
}
pub unsafe fn __fdim(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fdim(arg___x: f64, arg___y: f64) -> f64;
        }
        __fdim(arg___x, arg___y)
    })
}
pub unsafe fn fmax(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmax(arg___x: f64, arg___y: f64) -> f64;
        }
        fmax(arg___x, arg___y)
    })
}
pub unsafe fn __fmax(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fmax(arg___x: f64, arg___y: f64) -> f64;
        }
        __fmax(arg___x, arg___y)
    })
}
pub unsafe fn fmin(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmin(arg___x: f64, arg___y: f64) -> f64;
        }
        fmin(arg___x, arg___y)
    })
}
pub unsafe fn __fmin(arg___x: f64, arg___y: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fmin(arg___x: f64, arg___y: f64) -> f64;
        }
        __fmin(arg___x, arg___y)
    })
}
pub unsafe fn fma(arg___x: f64, arg___y: f64, arg___z: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fma(arg___x: f64, arg___y: f64, arg___z: f64) -> f64;
        }
        fma(arg___x, arg___y, arg___z)
    })
}
pub unsafe fn __fma(arg___x: f64, arg___y: f64, arg___z: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fma(arg___x: f64, arg___y: f64, arg___z: f64) -> f64;
        }
        __fma(arg___x, arg___y, arg___z)
    })
}
pub unsafe fn scalb(arg___x: f64, arg___n: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalb(arg___x: f64, arg___n: f64) -> f64;
        }
        scalb(arg___x, arg___n)
    })
}
pub unsafe fn __scalb(arg___x: f64, arg___n: f64) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __scalb(arg___x: f64, arg___n: f64) -> f64;
        }
        __scalb(arg___x, arg___n)
    })
}
pub unsafe fn __fpclassifyf(arg___value: f32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fpclassifyf(arg___value: f32) -> ::std::os::raw::c_int;
        }
        __fpclassifyf(arg___value)
    })
}
pub unsafe fn __signbitf(arg___value: f32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __signbitf(arg___value: f32) -> ::std::os::raw::c_int;
        }
        __signbitf(arg___value)
    })
}
pub unsafe fn __isinff(arg___value: f32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __isinff(arg___value: f32) -> ::std::os::raw::c_int;
        }
        __isinff(arg___value)
    })
}
pub unsafe fn __finitef(arg___value: f32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __finitef(arg___value: f32) -> ::std::os::raw::c_int;
        }
        __finitef(arg___value)
    })
}
pub unsafe fn __isnanf(arg___value: f32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __isnanf(arg___value: f32) -> ::std::os::raw::c_int;
        }
        __isnanf(arg___value)
    })
}
pub unsafe fn __iseqsigf(arg___x: f32, arg___y: f32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __iseqsigf(arg___x: f32, arg___y: f32) -> ::std::os::raw::c_int;
        }
        __iseqsigf(arg___x, arg___y)
    })
}
pub unsafe fn __issignalingf(arg___value: f32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __issignalingf(arg___value: f32) -> ::std::os::raw::c_int;
        }
        __issignalingf(arg___value)
    })
}
pub unsafe fn acosf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn acosf(arg___x: f32) -> f32;
        }
        acosf(arg___x)
    })
}
pub unsafe fn __acosf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __acosf(arg___x: f32) -> f32;
        }
        __acosf(arg___x)
    })
}
pub unsafe fn asinf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asinf(arg___x: f32) -> f32;
        }
        asinf(arg___x)
    })
}
pub unsafe fn __asinf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __asinf(arg___x: f32) -> f32;
        }
        __asinf(arg___x)
    })
}
pub unsafe fn atanf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atanf(arg___x: f32) -> f32;
        }
        atanf(arg___x)
    })
}
pub unsafe fn __atanf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __atanf(arg___x: f32) -> f32;
        }
        __atanf(arg___x)
    })
}
pub unsafe fn atan2f(arg___y: f32, arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atan2f(arg___y: f32, arg___x: f32) -> f32;
        }
        atan2f(arg___y, arg___x)
    })
}
pub unsafe fn __atan2f(arg___y: f32, arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __atan2f(arg___y: f32, arg___x: f32) -> f32;
        }
        __atan2f(arg___y, arg___x)
    })
}
pub unsafe fn cosf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cosf(arg___x: f32) -> f32;
        }
        cosf(arg___x)
    })
}
pub unsafe fn __cosf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __cosf(arg___x: f32) -> f32;
        }
        __cosf(arg___x)
    })
}
pub unsafe fn sinf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sinf(arg___x: f32) -> f32;
        }
        sinf(arg___x)
    })
}
pub unsafe fn __sinf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sinf(arg___x: f32) -> f32;
        }
        __sinf(arg___x)
    })
}
pub unsafe fn tanf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tanf(arg___x: f32) -> f32;
        }
        tanf(arg___x)
    })
}
pub unsafe fn __tanf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __tanf(arg___x: f32) -> f32;
        }
        __tanf(arg___x)
    })
}
pub unsafe fn coshf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn coshf(arg___x: f32) -> f32;
        }
        coshf(arg___x)
    })
}
pub unsafe fn __coshf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __coshf(arg___x: f32) -> f32;
        }
        __coshf(arg___x)
    })
}
pub unsafe fn sinhf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sinhf(arg___x: f32) -> f32;
        }
        sinhf(arg___x)
    })
}
pub unsafe fn __sinhf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sinhf(arg___x: f32) -> f32;
        }
        __sinhf(arg___x)
    })
}
pub unsafe fn tanhf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tanhf(arg___x: f32) -> f32;
        }
        tanhf(arg___x)
    })
}
pub unsafe fn __tanhf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __tanhf(arg___x: f32) -> f32;
        }
        __tanhf(arg___x)
    })
}
pub unsafe fn acoshf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn acoshf(arg___x: f32) -> f32;
        }
        acoshf(arg___x)
    })
}
pub unsafe fn __acoshf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __acoshf(arg___x: f32) -> f32;
        }
        __acoshf(arg___x)
    })
}
pub unsafe fn asinhf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asinhf(arg___x: f32) -> f32;
        }
        asinhf(arg___x)
    })
}
pub unsafe fn __asinhf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __asinhf(arg___x: f32) -> f32;
        }
        __asinhf(arg___x)
    })
}
pub unsafe fn atanhf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atanhf(arg___x: f32) -> f32;
        }
        atanhf(arg___x)
    })
}
pub unsafe fn __atanhf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __atanhf(arg___x: f32) -> f32;
        }
        __atanhf(arg___x)
    })
}
pub unsafe fn expf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn expf(arg___x: f32) -> f32;
        }
        expf(arg___x)
    })
}
pub unsafe fn __expf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __expf(arg___x: f32) -> f32;
        }
        __expf(arg___x)
    })
}
pub unsafe fn frexpf(arg___x: f32, arg___exponent: *mut ::std::os::raw::c_int) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn frexpf(arg___x: f32, arg___exponent: *mut ::std::os::raw::c_int) -> f32;
        }
        frexpf(arg___x, arg___exponent)
    })
}
pub unsafe fn __frexpf(arg___x: f32, arg___exponent: *mut ::std::os::raw::c_int) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __frexpf(arg___x: f32, arg___exponent: *mut ::std::os::raw::c_int) -> f32;
        }
        __frexpf(arg___x, arg___exponent)
    })
}
pub unsafe fn ldexpf(arg___x: f32, arg___exponent: ::std::os::raw::c_int) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ldexpf(arg___x: f32, arg___exponent: ::std::os::raw::c_int) -> f32;
        }
        ldexpf(arg___x, arg___exponent)
    })
}
pub unsafe fn __ldexpf(arg___x: f32, arg___exponent: ::std::os::raw::c_int) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ldexpf(arg___x: f32, arg___exponent: ::std::os::raw::c_int) -> f32;
        }
        __ldexpf(arg___x, arg___exponent)
    })
}
pub unsafe fn logf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn logf(arg___x: f32) -> f32;
        }
        logf(arg___x)
    })
}
pub unsafe fn __logf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __logf(arg___x: f32) -> f32;
        }
        __logf(arg___x)
    })
}
pub unsafe fn log10f(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log10f(arg___x: f32) -> f32;
        }
        log10f(arg___x)
    })
}
pub unsafe fn __log10f(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __log10f(arg___x: f32) -> f32;
        }
        __log10f(arg___x)
    })
}
pub unsafe fn modff(arg___x: f32, arg___iptr: *mut f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn modff(arg___x: f32, arg___iptr: *mut f32) -> f32;
        }
        modff(arg___x, arg___iptr)
    })
}
pub unsafe fn __modff(arg___x: f32, arg___iptr: *mut f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __modff(arg___x: f32, arg___iptr: *mut f32) -> f32;
        }
        __modff(arg___x, arg___iptr)
    })
}
pub unsafe fn expm1f(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn expm1f(arg___x: f32) -> f32;
        }
        expm1f(arg___x)
    })
}
pub unsafe fn __expm1f(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __expm1f(arg___x: f32) -> f32;
        }
        __expm1f(arg___x)
    })
}
pub unsafe fn log1pf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log1pf(arg___x: f32) -> f32;
        }
        log1pf(arg___x)
    })
}
pub unsafe fn __log1pf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __log1pf(arg___x: f32) -> f32;
        }
        __log1pf(arg___x)
    })
}
pub unsafe fn logbf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn logbf(arg___x: f32) -> f32;
        }
        logbf(arg___x)
    })
}
pub unsafe fn __logbf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __logbf(arg___x: f32) -> f32;
        }
        __logbf(arg___x)
    })
}
pub unsafe fn exp2f(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn exp2f(arg___x: f32) -> f32;
        }
        exp2f(arg___x)
    })
}
pub unsafe fn __exp2f(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __exp2f(arg___x: f32) -> f32;
        }
        __exp2f(arg___x)
    })
}
pub unsafe fn log2f(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log2f(arg___x: f32) -> f32;
        }
        log2f(arg___x)
    })
}
pub unsafe fn __log2f(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __log2f(arg___x: f32) -> f32;
        }
        __log2f(arg___x)
    })
}
pub unsafe fn powf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn powf(arg___x: f32, arg___y: f32) -> f32;
        }
        powf(arg___x, arg___y)
    })
}
pub unsafe fn __powf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __powf(arg___x: f32, arg___y: f32) -> f32;
        }
        __powf(arg___x, arg___y)
    })
}
pub unsafe fn sqrtf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sqrtf(arg___x: f32) -> f32;
        }
        sqrtf(arg___x)
    })
}
pub unsafe fn __sqrtf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sqrtf(arg___x: f32) -> f32;
        }
        __sqrtf(arg___x)
    })
}
pub unsafe fn hypotf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hypotf(arg___x: f32, arg___y: f32) -> f32;
        }
        hypotf(arg___x, arg___y)
    })
}
pub unsafe fn __hypotf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __hypotf(arg___x: f32, arg___y: f32) -> f32;
        }
        __hypotf(arg___x, arg___y)
    })
}
pub unsafe fn cbrtf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cbrtf(arg___x: f32) -> f32;
        }
        cbrtf(arg___x)
    })
}
pub unsafe fn __cbrtf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __cbrtf(arg___x: f32) -> f32;
        }
        __cbrtf(arg___x)
    })
}
pub unsafe fn ceilf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ceilf(arg___x: f32) -> f32;
        }
        ceilf(arg___x)
    })
}
pub unsafe fn __ceilf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ceilf(arg___x: f32) -> f32;
        }
        __ceilf(arg___x)
    })
}
pub unsafe fn fabsf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fabsf(arg___x: f32) -> f32;
        }
        fabsf(arg___x)
    })
}
pub unsafe fn __fabsf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fabsf(arg___x: f32) -> f32;
        }
        __fabsf(arg___x)
    })
}
pub unsafe fn floorf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn floorf(arg___x: f32) -> f32;
        }
        floorf(arg___x)
    })
}
pub unsafe fn __floorf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __floorf(arg___x: f32) -> f32;
        }
        __floorf(arg___x)
    })
}
pub unsafe fn fmodf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmodf(arg___x: f32, arg___y: f32) -> f32;
        }
        fmodf(arg___x, arg___y)
    })
}
pub unsafe fn __fmodf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fmodf(arg___x: f32, arg___y: f32) -> f32;
        }
        __fmodf(arg___x, arg___y)
    })
}
pub unsafe fn isinff(arg___value: f32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isinff(arg___value: f32) -> ::std::os::raw::c_int;
        }
        isinff(arg___value)
    })
}
pub unsafe fn finitef(arg___value: f32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn finitef(arg___value: f32) -> ::std::os::raw::c_int;
        }
        finitef(arg___value)
    })
}
pub unsafe fn dremf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dremf(arg___x: f32, arg___y: f32) -> f32;
        }
        dremf(arg___x, arg___y)
    })
}
pub unsafe fn __dremf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __dremf(arg___x: f32, arg___y: f32) -> f32;
        }
        __dremf(arg___x, arg___y)
    })
}
pub unsafe fn significandf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn significandf(arg___x: f32) -> f32;
        }
        significandf(arg___x)
    })
}
pub unsafe fn __significandf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __significandf(arg___x: f32) -> f32;
        }
        __significandf(arg___x)
    })
}
pub unsafe fn copysignf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn copysignf(arg___x: f32, arg___y: f32) -> f32;
        }
        copysignf(arg___x, arg___y)
    })
}
pub unsafe fn __copysignf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __copysignf(arg___x: f32, arg___y: f32) -> f32;
        }
        __copysignf(arg___x, arg___y)
    })
}
pub unsafe fn nanf(arg___tagb: *const ::std::os::raw::c_char) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nanf(arg___tagb: *const ::std::os::raw::c_char) -> f32;
        }
        nanf(arg___tagb)
    })
}
pub unsafe fn __nanf(arg___tagb: *const ::std::os::raw::c_char) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __nanf(arg___tagb: *const ::std::os::raw::c_char) -> f32;
        }
        __nanf(arg___tagb)
    })
}
pub unsafe fn isnanf(arg___value: f32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isnanf(arg___value: f32) -> ::std::os::raw::c_int;
        }
        isnanf(arg___value)
    })
}
pub unsafe fn j0f(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn j0f(arg_arg1: f32) -> f32;
        }
        j0f(arg_arg1)
    })
}
pub unsafe fn __j0f(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __j0f(arg_arg1: f32) -> f32;
        }
        __j0f(arg_arg1)
    })
}
pub unsafe fn j1f(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn j1f(arg_arg1: f32) -> f32;
        }
        j1f(arg_arg1)
    })
}
pub unsafe fn __j1f(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __j1f(arg_arg1: f32) -> f32;
        }
        __j1f(arg_arg1)
    })
}
pub unsafe fn jnf(arg_arg1: ::std::os::raw::c_int, arg_arg2: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn jnf(arg_arg1: ::std::os::raw::c_int, arg_arg2: f32) -> f32;
        }
        jnf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn __jnf(arg_arg1: ::std::os::raw::c_int, arg_arg2: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __jnf(arg_arg1: ::std::os::raw::c_int, arg_arg2: f32) -> f32;
        }
        __jnf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn y0f(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn y0f(arg_arg1: f32) -> f32;
        }
        y0f(arg_arg1)
    })
}
pub unsafe fn __y0f(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __y0f(arg_arg1: f32) -> f32;
        }
        __y0f(arg_arg1)
    })
}
pub unsafe fn y1f(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn y1f(arg_arg1: f32) -> f32;
        }
        y1f(arg_arg1)
    })
}
pub unsafe fn __y1f(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __y1f(arg_arg1: f32) -> f32;
        }
        __y1f(arg_arg1)
    })
}
pub unsafe fn ynf(arg_arg1: ::std::os::raw::c_int, arg_arg2: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ynf(arg_arg1: ::std::os::raw::c_int, arg_arg2: f32) -> f32;
        }
        ynf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn __ynf(arg_arg1: ::std::os::raw::c_int, arg_arg2: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ynf(arg_arg1: ::std::os::raw::c_int, arg_arg2: f32) -> f32;
        }
        __ynf(arg_arg1, arg_arg2)
    })
}
pub unsafe fn erff(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erff(arg_arg1: f32) -> f32;
        }
        erff(arg_arg1)
    })
}
pub unsafe fn __erff(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __erff(arg_arg1: f32) -> f32;
        }
        __erff(arg_arg1)
    })
}
pub unsafe fn erfcf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erfcf(arg_arg1: f32) -> f32;
        }
        erfcf(arg_arg1)
    })
}
pub unsafe fn __erfcf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __erfcf(arg_arg1: f32) -> f32;
        }
        __erfcf(arg_arg1)
    })
}
pub unsafe fn lgammaf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lgammaf(arg_arg1: f32) -> f32;
        }
        lgammaf(arg_arg1)
    })
}
pub unsafe fn __lgammaf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __lgammaf(arg_arg1: f32) -> f32;
        }
        __lgammaf(arg_arg1)
    })
}
pub unsafe fn tgammaf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tgammaf(arg_arg1: f32) -> f32;
        }
        tgammaf(arg_arg1)
    })
}
pub unsafe fn __tgammaf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __tgammaf(arg_arg1: f32) -> f32;
        }
        __tgammaf(arg_arg1)
    })
}
pub unsafe fn gammaf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gammaf(arg_arg1: f32) -> f32;
        }
        gammaf(arg_arg1)
    })
}
pub unsafe fn __gammaf(arg_arg1: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __gammaf(arg_arg1: f32) -> f32;
        }
        __gammaf(arg_arg1)
    })
}
pub unsafe fn lgammaf_r(arg_arg1: f32, arg___signgamp: *mut ::std::os::raw::c_int) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lgammaf_r(arg_arg1: f32, arg___signgamp: *mut ::std::os::raw::c_int) -> f32;
        }
        lgammaf_r(arg_arg1, arg___signgamp)
    })
}
pub unsafe fn __lgammaf_r(arg_arg1: f32, arg___signgamp: *mut ::std::os::raw::c_int) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __lgammaf_r(arg_arg1: f32, arg___signgamp: *mut ::std::os::raw::c_int) -> f32;
        }
        __lgammaf_r(arg_arg1, arg___signgamp)
    })
}
pub unsafe fn rintf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rintf(arg___x: f32) -> f32;
        }
        rintf(arg___x)
    })
}
pub unsafe fn __rintf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __rintf(arg___x: f32) -> f32;
        }
        __rintf(arg___x)
    })
}
pub unsafe fn nextafterf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nextafterf(arg___x: f32, arg___y: f32) -> f32;
        }
        nextafterf(arg___x, arg___y)
    })
}
pub unsafe fn __nextafterf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __nextafterf(arg___x: f32, arg___y: f32) -> f32;
        }
        __nextafterf(arg___x, arg___y)
    })
}
pub unsafe fn nexttowardf(arg___x: f32, arg___y: u128) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nexttowardf(arg___x: f32, arg___y: u128) -> f32;
        }
        nexttowardf(arg___x, arg___y)
    })
}
pub unsafe fn __nexttowardf(arg___x: f32, arg___y: u128) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __nexttowardf(arg___x: f32, arg___y: u128) -> f32;
        }
        __nexttowardf(arg___x, arg___y)
    })
}
pub unsafe fn remainderf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn remainderf(arg___x: f32, arg___y: f32) -> f32;
        }
        remainderf(arg___x, arg___y)
    })
}
pub unsafe fn __remainderf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __remainderf(arg___x: f32, arg___y: f32) -> f32;
        }
        __remainderf(arg___x, arg___y)
    })
}
pub unsafe fn scalbnf(arg___x: f32, arg___n: ::std::os::raw::c_int) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalbnf(arg___x: f32, arg___n: ::std::os::raw::c_int) -> f32;
        }
        scalbnf(arg___x, arg___n)
    })
}
pub unsafe fn __scalbnf(arg___x: f32, arg___n: ::std::os::raw::c_int) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __scalbnf(arg___x: f32, arg___n: ::std::os::raw::c_int) -> f32;
        }
        __scalbnf(arg___x, arg___n)
    })
}
pub unsafe fn ilogbf(arg___x: f32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ilogbf(arg___x: f32) -> ::std::os::raw::c_int;
        }
        ilogbf(arg___x)
    })
}
pub unsafe fn __ilogbf(arg___x: f32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ilogbf(arg___x: f32) -> ::std::os::raw::c_int;
        }
        __ilogbf(arg___x)
    })
}
pub unsafe fn scalblnf(arg___x: f32, arg___n: ::std::os::raw::c_long) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalblnf(arg___x: f32, arg___n: ::std::os::raw::c_long) -> f32;
        }
        scalblnf(arg___x, arg___n)
    })
}
pub unsafe fn __scalblnf(arg___x: f32, arg___n: ::std::os::raw::c_long) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __scalblnf(arg___x: f32, arg___n: ::std::os::raw::c_long) -> f32;
        }
        __scalblnf(arg___x, arg___n)
    })
}
pub unsafe fn nearbyintf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nearbyintf(arg___x: f32) -> f32;
        }
        nearbyintf(arg___x)
    })
}
pub unsafe fn __nearbyintf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __nearbyintf(arg___x: f32) -> f32;
        }
        __nearbyintf(arg___x)
    })
}
pub unsafe fn roundf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn roundf(arg___x: f32) -> f32;
        }
        roundf(arg___x)
    })
}
pub unsafe fn __roundf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __roundf(arg___x: f32) -> f32;
        }
        __roundf(arg___x)
    })
}
pub unsafe fn truncf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn truncf(arg___x: f32) -> f32;
        }
        truncf(arg___x)
    })
}
pub unsafe fn __truncf(arg___x: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __truncf(arg___x: f32) -> f32;
        }
        __truncf(arg___x)
    })
}
pub unsafe fn remquof(arg___x: f32, arg___y: f32, arg___quo: *mut ::std::os::raw::c_int) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn remquof(arg___x: f32, arg___y: f32, arg___quo: *mut ::std::os::raw::c_int) -> f32;
        }
        remquof(arg___x, arg___y, arg___quo)
    })
}
pub unsafe fn __remquof(arg___x: f32, arg___y: f32, arg___quo: *mut ::std::os::raw::c_int) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __remquof(arg___x: f32, arg___y: f32, arg___quo: *mut ::std::os::raw::c_int) -> f32;
        }
        __remquof(arg___x, arg___y, arg___quo)
    })
}
pub unsafe fn lrintf(arg___x: f32) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lrintf(arg___x: f32) -> ::std::os::raw::c_long;
        }
        lrintf(arg___x)
    })
}
pub unsafe fn __lrintf(arg___x: f32) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __lrintf(arg___x: f32) -> ::std::os::raw::c_long;
        }
        __lrintf(arg___x)
    })
}
pub unsafe fn llrintf(arg___x: f32) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn llrintf(arg___x: f32) -> ::std::os::raw::c_longlong;
        }
        llrintf(arg___x)
    })
}
pub unsafe fn __llrintf(arg___x: f32) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __llrintf(arg___x: f32) -> ::std::os::raw::c_longlong;
        }
        __llrintf(arg___x)
    })
}
pub unsafe fn lroundf(arg___x: f32) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lroundf(arg___x: f32) -> ::std::os::raw::c_long;
        }
        lroundf(arg___x)
    })
}
pub unsafe fn __lroundf(arg___x: f32) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __lroundf(arg___x: f32) -> ::std::os::raw::c_long;
        }
        __lroundf(arg___x)
    })
}
pub unsafe fn llroundf(arg___x: f32) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn llroundf(arg___x: f32) -> ::std::os::raw::c_longlong;
        }
        llroundf(arg___x)
    })
}
pub unsafe fn __llroundf(arg___x: f32) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __llroundf(arg___x: f32) -> ::std::os::raw::c_longlong;
        }
        __llroundf(arg___x)
    })
}
pub unsafe fn fdimf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fdimf(arg___x: f32, arg___y: f32) -> f32;
        }
        fdimf(arg___x, arg___y)
    })
}
pub unsafe fn __fdimf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fdimf(arg___x: f32, arg___y: f32) -> f32;
        }
        __fdimf(arg___x, arg___y)
    })
}
pub unsafe fn fmaxf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmaxf(arg___x: f32, arg___y: f32) -> f32;
        }
        fmaxf(arg___x, arg___y)
    })
}
pub unsafe fn __fmaxf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fmaxf(arg___x: f32, arg___y: f32) -> f32;
        }
        __fmaxf(arg___x, arg___y)
    })
}
pub unsafe fn fminf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fminf(arg___x: f32, arg___y: f32) -> f32;
        }
        fminf(arg___x, arg___y)
    })
}
pub unsafe fn __fminf(arg___x: f32, arg___y: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fminf(arg___x: f32, arg___y: f32) -> f32;
        }
        __fminf(arg___x, arg___y)
    })
}
pub unsafe fn fmaf(arg___x: f32, arg___y: f32, arg___z: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmaf(arg___x: f32, arg___y: f32, arg___z: f32) -> f32;
        }
        fmaf(arg___x, arg___y, arg___z)
    })
}
pub unsafe fn __fmaf(arg___x: f32, arg___y: f32, arg___z: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fmaf(arg___x: f32, arg___y: f32, arg___z: f32) -> f32;
        }
        __fmaf(arg___x, arg___y, arg___z)
    })
}
pub unsafe fn scalbf(arg___x: f32, arg___n: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalbf(arg___x: f32, arg___n: f32) -> f32;
        }
        scalbf(arg___x, arg___n)
    })
}
pub unsafe fn __scalbf(arg___x: f32, arg___n: f32) -> f32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __scalbf(arg___x: f32, arg___n: f32) -> f32;
        }
        __scalbf(arg___x, arg___n)
    })
}
pub unsafe fn __fpclassifyl(arg___value: u128) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fpclassifyl(arg___value: u128) -> ::std::os::raw::c_int;
        }
        __fpclassifyl(arg___value)
    })
}
pub unsafe fn __signbitl(arg___value: u128) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __signbitl(arg___value: u128) -> ::std::os::raw::c_int;
        }
        __signbitl(arg___value)
    })
}
pub unsafe fn __isinfl(arg___value: u128) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __isinfl(arg___value: u128) -> ::std::os::raw::c_int;
        }
        __isinfl(arg___value)
    })
}
pub unsafe fn __finitel(arg___value: u128) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __finitel(arg___value: u128) -> ::std::os::raw::c_int;
        }
        __finitel(arg___value)
    })
}
pub unsafe fn __isnanl(arg___value: u128) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __isnanl(arg___value: u128) -> ::std::os::raw::c_int;
        }
        __isnanl(arg___value)
    })
}
pub unsafe fn __iseqsigl(arg___x: u128, arg___y: u128) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __iseqsigl(arg___x: u128, arg___y: u128) -> ::std::os::raw::c_int;
        }
        __iseqsigl(arg___x, arg___y)
    })
}
pub unsafe fn __issignalingl(arg___value: u128) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __issignalingl(arg___value: u128) -> ::std::os::raw::c_int;
        }
        __issignalingl(arg___value)
    })
}
pub unsafe fn acosl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn acosl(arg___x: u128) -> u128;
        }
        acosl(arg___x)
    })
}
pub unsafe fn __acosl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __acosl(arg___x: u128) -> u128;
        }
        __acosl(arg___x)
    })
}
pub unsafe fn asinl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asinl(arg___x: u128) -> u128;
        }
        asinl(arg___x)
    })
}
pub unsafe fn __asinl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __asinl(arg___x: u128) -> u128;
        }
        __asinl(arg___x)
    })
}
pub unsafe fn atanl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atanl(arg___x: u128) -> u128;
        }
        atanl(arg___x)
    })
}
pub unsafe fn __atanl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __atanl(arg___x: u128) -> u128;
        }
        __atanl(arg___x)
    })
}
pub unsafe fn atan2l(arg___y: u128, arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atan2l(arg___y: u128, arg___x: u128) -> u128;
        }
        atan2l(arg___y, arg___x)
    })
}
pub unsafe fn __atan2l(arg___y: u128, arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __atan2l(arg___y: u128, arg___x: u128) -> u128;
        }
        __atan2l(arg___y, arg___x)
    })
}
pub unsafe fn cosl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cosl(arg___x: u128) -> u128;
        }
        cosl(arg___x)
    })
}
pub unsafe fn __cosl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __cosl(arg___x: u128) -> u128;
        }
        __cosl(arg___x)
    })
}
pub unsafe fn sinl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sinl(arg___x: u128) -> u128;
        }
        sinl(arg___x)
    })
}
pub unsafe fn __sinl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sinl(arg___x: u128) -> u128;
        }
        __sinl(arg___x)
    })
}
pub unsafe fn tanl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tanl(arg___x: u128) -> u128;
        }
        tanl(arg___x)
    })
}
pub unsafe fn __tanl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __tanl(arg___x: u128) -> u128;
        }
        __tanl(arg___x)
    })
}
pub unsafe fn coshl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn coshl(arg___x: u128) -> u128;
        }
        coshl(arg___x)
    })
}
pub unsafe fn __coshl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __coshl(arg___x: u128) -> u128;
        }
        __coshl(arg___x)
    })
}
pub unsafe fn sinhl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sinhl(arg___x: u128) -> u128;
        }
        sinhl(arg___x)
    })
}
pub unsafe fn __sinhl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sinhl(arg___x: u128) -> u128;
        }
        __sinhl(arg___x)
    })
}
pub unsafe fn tanhl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tanhl(arg___x: u128) -> u128;
        }
        tanhl(arg___x)
    })
}
pub unsafe fn __tanhl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __tanhl(arg___x: u128) -> u128;
        }
        __tanhl(arg___x)
    })
}
pub unsafe fn acoshl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn acoshl(arg___x: u128) -> u128;
        }
        acoshl(arg___x)
    })
}
pub unsafe fn __acoshl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __acoshl(arg___x: u128) -> u128;
        }
        __acoshl(arg___x)
    })
}
pub unsafe fn asinhl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asinhl(arg___x: u128) -> u128;
        }
        asinhl(arg___x)
    })
}
pub unsafe fn __asinhl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __asinhl(arg___x: u128) -> u128;
        }
        __asinhl(arg___x)
    })
}
pub unsafe fn atanhl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn atanhl(arg___x: u128) -> u128;
        }
        atanhl(arg___x)
    })
}
pub unsafe fn __atanhl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __atanhl(arg___x: u128) -> u128;
        }
        __atanhl(arg___x)
    })
}
pub unsafe fn expl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn expl(arg___x: u128) -> u128;
        }
        expl(arg___x)
    })
}
pub unsafe fn __expl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __expl(arg___x: u128) -> u128;
        }
        __expl(arg___x)
    })
}
pub unsafe fn frexpl(arg___x: u128, arg___exponent: *mut ::std::os::raw::c_int) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn frexpl(arg___x: u128, arg___exponent: *mut ::std::os::raw::c_int) -> u128;
        }
        frexpl(arg___x, arg___exponent)
    })
}
pub unsafe fn __frexpl(arg___x: u128, arg___exponent: *mut ::std::os::raw::c_int) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __frexpl(arg___x: u128, arg___exponent: *mut ::std::os::raw::c_int) -> u128;
        }
        __frexpl(arg___x, arg___exponent)
    })
}
pub unsafe fn ldexpl(arg___x: u128, arg___exponent: ::std::os::raw::c_int) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ldexpl(arg___x: u128, arg___exponent: ::std::os::raw::c_int) -> u128;
        }
        ldexpl(arg___x, arg___exponent)
    })
}
pub unsafe fn __ldexpl(arg___x: u128, arg___exponent: ::std::os::raw::c_int) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ldexpl(arg___x: u128, arg___exponent: ::std::os::raw::c_int) -> u128;
        }
        __ldexpl(arg___x, arg___exponent)
    })
}
pub unsafe fn logl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn logl(arg___x: u128) -> u128;
        }
        logl(arg___x)
    })
}
pub unsafe fn __logl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __logl(arg___x: u128) -> u128;
        }
        __logl(arg___x)
    })
}
pub unsafe fn log10l(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log10l(arg___x: u128) -> u128;
        }
        log10l(arg___x)
    })
}
pub unsafe fn __log10l(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __log10l(arg___x: u128) -> u128;
        }
        __log10l(arg___x)
    })
}
pub unsafe fn modfl(arg___x: u128, arg___iptr: *mut u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn modfl(arg___x: u128, arg___iptr: *mut u128) -> u128;
        }
        modfl(arg___x, arg___iptr)
    })
}
pub unsafe fn __modfl(arg___x: u128, arg___iptr: *mut u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __modfl(arg___x: u128, arg___iptr: *mut u128) -> u128;
        }
        __modfl(arg___x, arg___iptr)
    })
}
pub unsafe fn expm1l(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn expm1l(arg___x: u128) -> u128;
        }
        expm1l(arg___x)
    })
}
pub unsafe fn __expm1l(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __expm1l(arg___x: u128) -> u128;
        }
        __expm1l(arg___x)
    })
}
pub unsafe fn log1pl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log1pl(arg___x: u128) -> u128;
        }
        log1pl(arg___x)
    })
}
pub unsafe fn __log1pl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __log1pl(arg___x: u128) -> u128;
        }
        __log1pl(arg___x)
    })
}
pub unsafe fn logbl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn logbl(arg___x: u128) -> u128;
        }
        logbl(arg___x)
    })
}
pub unsafe fn __logbl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __logbl(arg___x: u128) -> u128;
        }
        __logbl(arg___x)
    })
}
pub unsafe fn exp2l(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn exp2l(arg___x: u128) -> u128;
        }
        exp2l(arg___x)
    })
}
pub unsafe fn __exp2l(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __exp2l(arg___x: u128) -> u128;
        }
        __exp2l(arg___x)
    })
}
pub unsafe fn log2l(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn log2l(arg___x: u128) -> u128;
        }
        log2l(arg___x)
    })
}
pub unsafe fn __log2l(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __log2l(arg___x: u128) -> u128;
        }
        __log2l(arg___x)
    })
}
pub unsafe fn powl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn powl(arg___x: u128, arg___y: u128) -> u128;
        }
        powl(arg___x, arg___y)
    })
}
pub unsafe fn __powl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __powl(arg___x: u128, arg___y: u128) -> u128;
        }
        __powl(arg___x, arg___y)
    })
}
pub unsafe fn sqrtl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sqrtl(arg___x: u128) -> u128;
        }
        sqrtl(arg___x)
    })
}
pub unsafe fn __sqrtl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sqrtl(arg___x: u128) -> u128;
        }
        __sqrtl(arg___x)
    })
}
pub unsafe fn hypotl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hypotl(arg___x: u128, arg___y: u128) -> u128;
        }
        hypotl(arg___x, arg___y)
    })
}
pub unsafe fn __hypotl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __hypotl(arg___x: u128, arg___y: u128) -> u128;
        }
        __hypotl(arg___x, arg___y)
    })
}
pub unsafe fn cbrtl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cbrtl(arg___x: u128) -> u128;
        }
        cbrtl(arg___x)
    })
}
pub unsafe fn __cbrtl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __cbrtl(arg___x: u128) -> u128;
        }
        __cbrtl(arg___x)
    })
}
pub unsafe fn ceill(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ceill(arg___x: u128) -> u128;
        }
        ceill(arg___x)
    })
}
pub unsafe fn __ceill(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ceill(arg___x: u128) -> u128;
        }
        __ceill(arg___x)
    })
}
pub unsafe fn fabsl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fabsl(arg___x: u128) -> u128;
        }
        fabsl(arg___x)
    })
}
pub unsafe fn __fabsl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fabsl(arg___x: u128) -> u128;
        }
        __fabsl(arg___x)
    })
}
pub unsafe fn floorl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn floorl(arg___x: u128) -> u128;
        }
        floorl(arg___x)
    })
}
pub unsafe fn __floorl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __floorl(arg___x: u128) -> u128;
        }
        __floorl(arg___x)
    })
}
pub unsafe fn fmodl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmodl(arg___x: u128, arg___y: u128) -> u128;
        }
        fmodl(arg___x, arg___y)
    })
}
pub unsafe fn __fmodl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fmodl(arg___x: u128, arg___y: u128) -> u128;
        }
        __fmodl(arg___x, arg___y)
    })
}
pub unsafe fn isinfl(arg___value: u128) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isinfl(arg___value: u128) -> ::std::os::raw::c_int;
        }
        isinfl(arg___value)
    })
}
pub unsafe fn finitel(arg___value: u128) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn finitel(arg___value: u128) -> ::std::os::raw::c_int;
        }
        finitel(arg___value)
    })
}
pub unsafe fn dreml(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dreml(arg___x: u128, arg___y: u128) -> u128;
        }
        dreml(arg___x, arg___y)
    })
}
pub unsafe fn __dreml(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __dreml(arg___x: u128, arg___y: u128) -> u128;
        }
        __dreml(arg___x, arg___y)
    })
}
pub unsafe fn significandl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn significandl(arg___x: u128) -> u128;
        }
        significandl(arg___x)
    })
}
pub unsafe fn __significandl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __significandl(arg___x: u128) -> u128;
        }
        __significandl(arg___x)
    })
}
pub unsafe fn copysignl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn copysignl(arg___x: u128, arg___y: u128) -> u128;
        }
        copysignl(arg___x, arg___y)
    })
}
pub unsafe fn __copysignl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __copysignl(arg___x: u128, arg___y: u128) -> u128;
        }
        __copysignl(arg___x, arg___y)
    })
}
pub unsafe fn nanl(arg___tagb: *const ::std::os::raw::c_char) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nanl(arg___tagb: *const ::std::os::raw::c_char) -> u128;
        }
        nanl(arg___tagb)
    })
}
pub unsafe fn __nanl(arg___tagb: *const ::std::os::raw::c_char) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __nanl(arg___tagb: *const ::std::os::raw::c_char) -> u128;
        }
        __nanl(arg___tagb)
    })
}
pub unsafe fn isnanl(arg___value: u128) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn isnanl(arg___value: u128) -> ::std::os::raw::c_int;
        }
        isnanl(arg___value)
    })
}
pub unsafe fn j0l(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn j0l(arg_arg1: u128) -> u128;
        }
        j0l(arg_arg1)
    })
}
pub unsafe fn __j0l(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __j0l(arg_arg1: u128) -> u128;
        }
        __j0l(arg_arg1)
    })
}
pub unsafe fn j1l(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn j1l(arg_arg1: u128) -> u128;
        }
        j1l(arg_arg1)
    })
}
pub unsafe fn __j1l(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __j1l(arg_arg1: u128) -> u128;
        }
        __j1l(arg_arg1)
    })
}
pub unsafe fn jnl(arg_arg1: ::std::os::raw::c_int, arg_arg2: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn jnl(arg_arg1: ::std::os::raw::c_int, arg_arg2: u128) -> u128;
        }
        jnl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn __jnl(arg_arg1: ::std::os::raw::c_int, arg_arg2: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __jnl(arg_arg1: ::std::os::raw::c_int, arg_arg2: u128) -> u128;
        }
        __jnl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn y0l(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn y0l(arg_arg1: u128) -> u128;
        }
        y0l(arg_arg1)
    })
}
pub unsafe fn __y0l(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __y0l(arg_arg1: u128) -> u128;
        }
        __y0l(arg_arg1)
    })
}
pub unsafe fn y1l(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn y1l(arg_arg1: u128) -> u128;
        }
        y1l(arg_arg1)
    })
}
pub unsafe fn __y1l(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __y1l(arg_arg1: u128) -> u128;
        }
        __y1l(arg_arg1)
    })
}
pub unsafe fn ynl(arg_arg1: ::std::os::raw::c_int, arg_arg2: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ynl(arg_arg1: ::std::os::raw::c_int, arg_arg2: u128) -> u128;
        }
        ynl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn __ynl(arg_arg1: ::std::os::raw::c_int, arg_arg2: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ynl(arg_arg1: ::std::os::raw::c_int, arg_arg2: u128) -> u128;
        }
        __ynl(arg_arg1, arg_arg2)
    })
}
pub unsafe fn erfl(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erfl(arg_arg1: u128) -> u128;
        }
        erfl(arg_arg1)
    })
}
pub unsafe fn __erfl(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __erfl(arg_arg1: u128) -> u128;
        }
        __erfl(arg_arg1)
    })
}
pub unsafe fn erfcl(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn erfcl(arg_arg1: u128) -> u128;
        }
        erfcl(arg_arg1)
    })
}
pub unsafe fn __erfcl(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __erfcl(arg_arg1: u128) -> u128;
        }
        __erfcl(arg_arg1)
    })
}
pub unsafe fn lgammal(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lgammal(arg_arg1: u128) -> u128;
        }
        lgammal(arg_arg1)
    })
}
pub unsafe fn __lgammal(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __lgammal(arg_arg1: u128) -> u128;
        }
        __lgammal(arg_arg1)
    })
}
pub unsafe fn tgammal(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tgammal(arg_arg1: u128) -> u128;
        }
        tgammal(arg_arg1)
    })
}
pub unsafe fn __tgammal(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __tgammal(arg_arg1: u128) -> u128;
        }
        __tgammal(arg_arg1)
    })
}
pub unsafe fn gammal(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gammal(arg_arg1: u128) -> u128;
        }
        gammal(arg_arg1)
    })
}
pub unsafe fn __gammal(arg_arg1: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __gammal(arg_arg1: u128) -> u128;
        }
        __gammal(arg_arg1)
    })
}
pub unsafe fn lgammal_r(arg_arg1: u128, arg___signgamp: *mut ::std::os::raw::c_int) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lgammal_r(arg_arg1: u128, arg___signgamp: *mut ::std::os::raw::c_int) -> u128;
        }
        lgammal_r(arg_arg1, arg___signgamp)
    })
}
pub unsafe fn __lgammal_r(arg_arg1: u128, arg___signgamp: *mut ::std::os::raw::c_int) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __lgammal_r(arg_arg1: u128, arg___signgamp: *mut ::std::os::raw::c_int) -> u128;
        }
        __lgammal_r(arg_arg1, arg___signgamp)
    })
}
pub unsafe fn rintl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rintl(arg___x: u128) -> u128;
        }
        rintl(arg___x)
    })
}
pub unsafe fn __rintl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __rintl(arg___x: u128) -> u128;
        }
        __rintl(arg___x)
    })
}
pub unsafe fn nextafterl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nextafterl(arg___x: u128, arg___y: u128) -> u128;
        }
        nextafterl(arg___x, arg___y)
    })
}
pub unsafe fn __nextafterl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __nextafterl(arg___x: u128, arg___y: u128) -> u128;
        }
        __nextafterl(arg___x, arg___y)
    })
}
pub unsafe fn nexttowardl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nexttowardl(arg___x: u128, arg___y: u128) -> u128;
        }
        nexttowardl(arg___x, arg___y)
    })
}
pub unsafe fn __nexttowardl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __nexttowardl(arg___x: u128, arg___y: u128) -> u128;
        }
        __nexttowardl(arg___x, arg___y)
    })
}
pub unsafe fn remainderl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn remainderl(arg___x: u128, arg___y: u128) -> u128;
        }
        remainderl(arg___x, arg___y)
    })
}
pub unsafe fn __remainderl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __remainderl(arg___x: u128, arg___y: u128) -> u128;
        }
        __remainderl(arg___x, arg___y)
    })
}
pub unsafe fn scalbnl(arg___x: u128, arg___n: ::std::os::raw::c_int) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalbnl(arg___x: u128, arg___n: ::std::os::raw::c_int) -> u128;
        }
        scalbnl(arg___x, arg___n)
    })
}
pub unsafe fn __scalbnl(arg___x: u128, arg___n: ::std::os::raw::c_int) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __scalbnl(arg___x: u128, arg___n: ::std::os::raw::c_int) -> u128;
        }
        __scalbnl(arg___x, arg___n)
    })
}
pub unsafe fn ilogbl(arg___x: u128) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ilogbl(arg___x: u128) -> ::std::os::raw::c_int;
        }
        ilogbl(arg___x)
    })
}
pub unsafe fn __ilogbl(arg___x: u128) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __ilogbl(arg___x: u128) -> ::std::os::raw::c_int;
        }
        __ilogbl(arg___x)
    })
}
pub unsafe fn scalblnl(arg___x: u128, arg___n: ::std::os::raw::c_long) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalblnl(arg___x: u128, arg___n: ::std::os::raw::c_long) -> u128;
        }
        scalblnl(arg___x, arg___n)
    })
}
pub unsafe fn __scalblnl(arg___x: u128, arg___n: ::std::os::raw::c_long) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __scalblnl(arg___x: u128, arg___n: ::std::os::raw::c_long) -> u128;
        }
        __scalblnl(arg___x, arg___n)
    })
}
pub unsafe fn nearbyintl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nearbyintl(arg___x: u128) -> u128;
        }
        nearbyintl(arg___x)
    })
}
pub unsafe fn __nearbyintl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __nearbyintl(arg___x: u128) -> u128;
        }
        __nearbyintl(arg___x)
    })
}
pub unsafe fn roundl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn roundl(arg___x: u128) -> u128;
        }
        roundl(arg___x)
    })
}
pub unsafe fn __roundl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __roundl(arg___x: u128) -> u128;
        }
        __roundl(arg___x)
    })
}
pub unsafe fn truncl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn truncl(arg___x: u128) -> u128;
        }
        truncl(arg___x)
    })
}
pub unsafe fn __truncl(arg___x: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __truncl(arg___x: u128) -> u128;
        }
        __truncl(arg___x)
    })
}
pub unsafe fn remquol(arg___x: u128, arg___y: u128, arg___quo: *mut ::std::os::raw::c_int) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn remquol(arg___x: u128, arg___y: u128, arg___quo: *mut ::std::os::raw::c_int)
                -> u128;
        }
        remquol(arg___x, arg___y, arg___quo)
    })
}
pub unsafe fn __remquol(
    arg___x: u128,
    arg___y: u128,
    arg___quo: *mut ::std::os::raw::c_int,
) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __remquol(
                arg___x: u128,
                arg___y: u128,
                arg___quo: *mut ::std::os::raw::c_int,
            ) -> u128;
        }
        __remquol(arg___x, arg___y, arg___quo)
    })
}
pub unsafe fn lrintl(arg___x: u128) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lrintl(arg___x: u128) -> ::std::os::raw::c_long;
        }
        lrintl(arg___x)
    })
}
pub unsafe fn __lrintl(arg___x: u128) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __lrintl(arg___x: u128) -> ::std::os::raw::c_long;
        }
        __lrintl(arg___x)
    })
}
pub unsafe fn llrintl(arg___x: u128) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn llrintl(arg___x: u128) -> ::std::os::raw::c_longlong;
        }
        llrintl(arg___x)
    })
}
pub unsafe fn __llrintl(arg___x: u128) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __llrintl(arg___x: u128) -> ::std::os::raw::c_longlong;
        }
        __llrintl(arg___x)
    })
}
pub unsafe fn lroundl(arg___x: u128) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lroundl(arg___x: u128) -> ::std::os::raw::c_long;
        }
        lroundl(arg___x)
    })
}
pub unsafe fn __lroundl(arg___x: u128) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __lroundl(arg___x: u128) -> ::std::os::raw::c_long;
        }
        __lroundl(arg___x)
    })
}
pub unsafe fn llroundl(arg___x: u128) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn llroundl(arg___x: u128) -> ::std::os::raw::c_longlong;
        }
        llroundl(arg___x)
    })
}
pub unsafe fn __llroundl(arg___x: u128) -> ::std::os::raw::c_longlong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __llroundl(arg___x: u128) -> ::std::os::raw::c_longlong;
        }
        __llroundl(arg___x)
    })
}
pub unsafe fn fdiml(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fdiml(arg___x: u128, arg___y: u128) -> u128;
        }
        fdiml(arg___x, arg___y)
    })
}
pub unsafe fn __fdiml(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fdiml(arg___x: u128, arg___y: u128) -> u128;
        }
        __fdiml(arg___x, arg___y)
    })
}
pub unsafe fn fmaxl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmaxl(arg___x: u128, arg___y: u128) -> u128;
        }
        fmaxl(arg___x, arg___y)
    })
}
pub unsafe fn __fmaxl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fmaxl(arg___x: u128, arg___y: u128) -> u128;
        }
        __fmaxl(arg___x, arg___y)
    })
}
pub unsafe fn fminl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fminl(arg___x: u128, arg___y: u128) -> u128;
        }
        fminl(arg___x, arg___y)
    })
}
pub unsafe fn __fminl(arg___x: u128, arg___y: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fminl(arg___x: u128, arg___y: u128) -> u128;
        }
        __fminl(arg___x, arg___y)
    })
}
pub unsafe fn fmal(arg___x: u128, arg___y: u128, arg___z: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmal(arg___x: u128, arg___y: u128, arg___z: u128) -> u128;
        }
        fmal(arg___x, arg___y, arg___z)
    })
}
pub unsafe fn __fmal(arg___x: u128, arg___y: u128, arg___z: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __fmal(arg___x: u128, arg___y: u128, arg___z: u128) -> u128;
        }
        __fmal(arg___x, arg___y, arg___z)
    })
}
pub unsafe fn scalbl(arg___x: u128, arg___n: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scalbl(arg___x: u128, arg___n: u128) -> u128;
        }
        scalbl(arg___x, arg___n)
    })
}
pub unsafe fn __scalbl(arg___x: u128, arg___n: u128) -> u128 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __scalbl(arg___x: u128, arg___n: u128) -> u128;
        }
        __scalbl(arg___x, arg___n)
    })
}
extern "C" {
    pub static mut signgam: ::std::os::raw::c_int;
}
pub const FP_NAN: ::std::os::raw::c_uint = 0;
pub const FP_INFINITE: ::std::os::raw::c_uint = 1;
pub const FP_ZERO: ::std::os::raw::c_uint = 2;
pub const FP_SUBNORMAL: ::std::os::raw::c_uint = 3;
pub const FP_NORMAL: ::std::os::raw::c_uint = 4;
pub type _bindgen_ty_8 = ::std::os::raw::c_uint;
pub unsafe fn strlcat(
    arg_dst: *mut ::std::os::raw::c_char,
    arg_src: *const ::std::os::raw::c_char,
    arg_siz: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strlcat(
                arg_dst: *mut ::std::os::raw::c_char,
                arg_src: *const ::std::os::raw::c_char,
                arg_siz: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_ulong;
        }
        strlcat(arg_dst, arg_src, arg_siz)
    })
}
pub unsafe fn strlcpy(
    arg_dst: *mut ::std::os::raw::c_char,
    arg_src: *const ::std::os::raw::c_char,
    arg_siz: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strlcpy(
                arg_dst: *mut ::std::os::raw::c_char,
                arg_src: *const ::std::os::raw::c_char,
                arg_siz: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_ulong;
        }
        strlcpy(arg_dst, arg_src, arg_siz)
    })
}
pub unsafe fn pqGetpwuid(
    arg_uid: uid_t,
    arg_resultbuf: *mut passwd,
    arg_buffer: *mut ::std::os::raw::c_char,
    arg_buflen: usize,
    arg_result: *mut *mut passwd,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pqGetpwuid(
                arg_uid: uid_t,
                arg_resultbuf: *mut passwd,
                arg_buffer: *mut ::std::os::raw::c_char,
                arg_buflen: usize,
                arg_result: *mut *mut passwd,
            ) -> ::std::os::raw::c_int;
        }
        pqGetpwuid(arg_uid, arg_resultbuf, arg_buffer, arg_buflen, arg_result)
    })
}
pub unsafe fn pqGethostbyname(
    arg_name: *const ::std::os::raw::c_char,
    arg_resultbuf: *mut hostent,
    arg_buffer: *mut ::std::os::raw::c_char,
    arg_buflen: usize,
    arg_result: *mut *mut hostent,
    arg_herrno: *mut ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pqGethostbyname(
                arg_name: *const ::std::os::raw::c_char,
                arg_resultbuf: *mut hostent,
                arg_buffer: *mut ::std::os::raw::c_char,
                arg_buflen: usize,
                arg_result: *mut *mut hostent,
                arg_herrno: *mut ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        pqGethostbyname(
            arg_name,
            arg_resultbuf,
            arg_buffer,
            arg_buflen,
            arg_result,
            arg_herrno,
        )
    })
}
pub unsafe fn pg_qsort(
    arg_base: *mut ::std::os::raw::c_void,
    arg_nel: usize,
    arg_elsize: usize,
    arg_cmp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_qsort(
                arg_base: *mut ::std::os::raw::c_void,
                arg_nel: usize,
                arg_elsize: usize,
                arg_cmp: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *const ::std::os::raw::c_void,
                        arg2: *const ::std::os::raw::c_void,
                    ) -> ::std::os::raw::c_int,
                >,
            );
        }
        pg_qsort(arg_base, arg_nel, arg_elsize, arg_cmp)
    })
}
pub unsafe fn pg_qsort_strcmp(
    arg_a: *const ::std::os::raw::c_void,
    arg_b: *const ::std::os::raw::c_void,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_qsort_strcmp(
                arg_a: *const ::std::os::raw::c_void,
                arg_b: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int;
        }
        pg_qsort_strcmp(arg_a, arg_b)
    })
}
pub type qsort_arg_comparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub unsafe fn qsort_arg(
    arg_base: *mut ::std::os::raw::c_void,
    arg_nel: usize,
    arg_elsize: usize,
    arg_cmp: qsort_arg_comparator,
    arg_arg: *mut ::std::os::raw::c_void,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn qsort_arg(
                arg_base: *mut ::std::os::raw::c_void,
                arg_nel: usize,
                arg_elsize: usize,
                arg_cmp: qsort_arg_comparator,
                arg_arg: *mut ::std::os::raw::c_void,
            );
        }
        qsort_arg(arg_base, arg_nel, arg_elsize, arg_cmp, arg_arg)
    })
}
pub unsafe fn pg_get_encoding_from_locale(
    arg_ctype: *const ::std::os::raw::c_char,
    arg_write_message: bool,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_get_encoding_from_locale(
                arg_ctype: *const ::std::os::raw::c_char,
                arg_write_message: bool,
            ) -> ::std::os::raw::c_int;
        }
        pg_get_encoding_from_locale(arg_ctype, arg_write_message)
    })
}
pub unsafe fn inet_net_ntop(
    arg_af: ::std::os::raw::c_int,
    arg_src: *const ::std::os::raw::c_void,
    arg_bits: ::std::os::raw::c_int,
    arg_dst: *mut ::std::os::raw::c_char,
    arg_size: usize,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn inet_net_ntop(
                arg_af: ::std::os::raw::c_int,
                arg_src: *const ::std::os::raw::c_void,
                arg_bits: ::std::os::raw::c_int,
                arg_dst: *mut ::std::os::raw::c_char,
                arg_size: usize,
            ) -> *mut ::std::os::raw::c_char;
        }
        inet_net_ntop(arg_af, arg_src, arg_bits, arg_dst, arg_size)
    })
}
pub unsafe fn pg_strong_random(arg_buf: *mut ::std::os::raw::c_void, arg_len: usize) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strong_random(arg_buf: *mut ::std::os::raw::c_void, arg_len: usize) -> bool;
        }
        pg_strong_random(arg_buf, arg_len)
    })
}
pub unsafe fn pg_check_dir(arg_dir: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_check_dir(arg_dir: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        pg_check_dir(arg_dir)
    })
}
pub unsafe fn pg_mkdir_p(
    arg_path: *mut ::std::os::raw::c_char,
    arg_omode: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_mkdir_p(
                arg_path: *mut ::std::os::raw::c_char,
                arg_omode: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        pg_mkdir_p(arg_path, arg_omode)
    })
}
pub type pqsigfunc = ::std::option::Option<unsafe extern "C" fn(signo: ::std::os::raw::c_int)>;
pub unsafe fn pqsignal(arg_signo: ::std::os::raw::c_int, arg_func: pqsigfunc) -> pqsigfunc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pqsignal(arg_signo: ::std::os::raw::c_int, arg_func: pqsigfunc) -> pqsigfunc;
        }
        pqsignal(arg_signo, arg_func)
    })
}
pub unsafe fn escape_single_quotes_ascii(
    arg_src: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn escape_single_quotes_ascii(
                arg_src: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        escape_single_quotes_ascii(arg_src)
    })
}
pub unsafe fn wait_result_to_str(
    arg_exit_status: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wait_result_to_str(
                arg_exit_status: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        wait_result_to_str(arg_exit_status)
    })
}
pub unsafe fn wait_result_is_signal(
    arg_exit_status: ::std::os::raw::c_int,
    arg_signum: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wait_result_is_signal(
                arg_exit_status: ::std::os::raw::c_int,
                arg_signum: ::std::os::raw::c_int,
            ) -> bool;
        }
        wait_result_is_signal(arg_exit_status, arg_signum)
    })
}
pub unsafe fn wait_result_is_any_signal(
    arg_exit_status: ::std::os::raw::c_int,
    arg_include_command_not_found: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wait_result_is_any_signal(
                arg_exit_status: ::std::os::raw::c_int,
                arg_include_command_not_found: bool,
            ) -> bool;
        }
        wait_result_is_any_signal(arg_exit_status, arg_include_command_not_found)
    })
}
pub type __jmp_buf = [::std::os::raw::c_long; 8usize];
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __jmp_buf_tag {
    pub __jmpbuf: __jmp_buf,
    pub __mask_was_saved: ::std::os::raw::c_int,
    pub __saved_mask: __sigset_t,
}
pub type jmp_buf = [__jmp_buf_tag; 1usize];
pub unsafe fn setjmp(arg___env: *mut __jmp_buf_tag) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn setjmp(arg___env: *mut __jmp_buf_tag) -> ::std::os::raw::c_int;
        }
        setjmp(arg___env)
    })
}
pub unsafe fn __sigsetjmp(
    arg___env: *mut __jmp_buf_tag,
    arg___savemask: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn __sigsetjmp(
                arg___env: *mut __jmp_buf_tag,
                arg___savemask: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        __sigsetjmp(arg___env, arg___savemask)
    })
}
pub unsafe fn _setjmp(arg___env: *mut __jmp_buf_tag) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn _setjmp(arg___env: *mut __jmp_buf_tag) -> ::std::os::raw::c_int;
        }
        _setjmp(arg___env)
    })
}
pub unsafe fn longjmp(arg___env: *mut __jmp_buf_tag, arg___val: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn longjmp(arg___env: *mut __jmp_buf_tag, arg___val: ::std::os::raw::c_int);
        }
        longjmp(arg___env, arg___val)
    })
}
pub unsafe fn _longjmp(arg___env: *mut __jmp_buf_tag, arg___val: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn _longjmp(arg___env: *mut __jmp_buf_tag, arg___val: ::std::os::raw::c_int);
        }
        _longjmp(arg___env, arg___val)
    })
}
pub type sigjmp_buf = [__jmp_buf_tag; 1usize];
pub unsafe fn errstart(
    arg_elevel: ::std::os::raw::c_int,
    arg_filename: *const ::std::os::raw::c_char,
    arg_lineno: ::std::os::raw::c_int,
    arg_funcname: *const ::std::os::raw::c_char,
    arg_domain: *const ::std::os::raw::c_char,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errstart(
                arg_elevel: ::std::os::raw::c_int,
                arg_filename: *const ::std::os::raw::c_char,
                arg_lineno: ::std::os::raw::c_int,
                arg_funcname: *const ::std::os::raw::c_char,
                arg_domain: *const ::std::os::raw::c_char,
            ) -> bool;
        }
        errstart(
            arg_elevel,
            arg_filename,
            arg_lineno,
            arg_funcname,
            arg_domain,
        )
    })
}
pub unsafe fn errfinish(arg_dummy: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errfinish(arg_dummy: ::std::os::raw::c_int);
        }
        errfinish(arg_dummy)
    })
}
pub unsafe fn errcode(arg_sqlerrcode: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errcode(arg_sqlerrcode: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        errcode(arg_sqlerrcode)
    })
}
pub unsafe fn errcode_for_file_access() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errcode_for_file_access() -> ::std::os::raw::c_int;
        }
        errcode_for_file_access()
    })
}
pub unsafe fn errcode_for_socket_access() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errcode_for_socket_access() -> ::std::os::raw::c_int;
        }
        errcode_for_socket_access()
    })
}
pub unsafe fn errmsg(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errmsg(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errmsg(arg_fmt)
    })
}
pub unsafe fn errmsg_internal(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errmsg_internal(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errmsg_internal(arg_fmt)
    })
}
pub unsafe fn errmsg_plural(
    arg_fmt_singular: *const ::std::os::raw::c_char,
    arg_fmt_plural: *const ::std::os::raw::c_char,
    arg_n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errmsg_plural(
                arg_fmt_singular: *const ::std::os::raw::c_char,
                arg_fmt_plural: *const ::std::os::raw::c_char,
                arg_n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        errmsg_plural(arg_fmt_singular, arg_fmt_plural, arg_n)
    })
}
pub unsafe fn errdetail(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errdetail(arg_fmt)
    })
}
pub unsafe fn errdetail_internal(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail_internal(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errdetail_internal(arg_fmt)
    })
}
pub unsafe fn errdetail_log(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail_log(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errdetail_log(arg_fmt)
    })
}
pub unsafe fn errdetail_log_plural(
    arg_fmt_singular: *const ::std::os::raw::c_char,
    arg_fmt_plural: *const ::std::os::raw::c_char,
    arg_n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail_log_plural(
                arg_fmt_singular: *const ::std::os::raw::c_char,
                arg_fmt_plural: *const ::std::os::raw::c_char,
                arg_n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        errdetail_log_plural(arg_fmt_singular, arg_fmt_plural, arg_n)
    })
}
pub unsafe fn errdetail_plural(
    arg_fmt_singular: *const ::std::os::raw::c_char,
    arg_fmt_plural: *const ::std::os::raw::c_char,
    arg_n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail_plural(
                arg_fmt_singular: *const ::std::os::raw::c_char,
                arg_fmt_plural: *const ::std::os::raw::c_char,
                arg_n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        errdetail_plural(arg_fmt_singular, arg_fmt_plural, arg_n)
    })
}
pub unsafe fn errhint(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errhint(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errhint(arg_fmt)
    })
}
pub unsafe fn set_errcontext_domain(
    arg_domain: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_errcontext_domain(
                arg_domain: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        set_errcontext_domain(arg_domain)
    })
}
pub unsafe fn errcontext_msg(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errcontext_msg(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errcontext_msg(arg_fmt)
    })
}
pub unsafe fn errhidestmt(arg_hide_stmt: bool) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errhidestmt(arg_hide_stmt: bool) -> ::std::os::raw::c_int;
        }
        errhidestmt(arg_hide_stmt)
    })
}
pub unsafe fn errhidecontext(arg_hide_ctx: bool) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errhidecontext(arg_hide_ctx: bool) -> ::std::os::raw::c_int;
        }
        errhidecontext(arg_hide_ctx)
    })
}
pub unsafe fn errfunction(arg_funcname: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errfunction(arg_funcname: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errfunction(arg_funcname)
    })
}
pub unsafe fn errposition(arg_cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errposition(arg_cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        errposition(arg_cursorpos)
    })
}
pub unsafe fn internalerrposition(arg_cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn internalerrposition(arg_cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        internalerrposition(arg_cursorpos)
    })
}
pub unsafe fn internalerrquery(arg_query: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn internalerrquery(arg_query: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        internalerrquery(arg_query)
    })
}
pub unsafe fn err_generic_string(
    arg_field: ::std::os::raw::c_int,
    arg_str_: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn err_generic_string(
                arg_field: ::std::os::raw::c_int,
                arg_str_: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        err_generic_string(arg_field, arg_str_)
    })
}
pub unsafe fn geterrcode() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn geterrcode() -> ::std::os::raw::c_int;
        }
        geterrcode()
    })
}
pub unsafe fn geterrposition() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn geterrposition() -> ::std::os::raw::c_int;
        }
        geterrposition()
    })
}
pub unsafe fn getinternalerrposition() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getinternalerrposition() -> ::std::os::raw::c_int;
        }
        getinternalerrposition()
    })
}
pub unsafe fn elog_start(
    arg_filename: *const ::std::os::raw::c_char,
    arg_lineno: ::std::os::raw::c_int,
    arg_funcname: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn elog_start(
                arg_filename: *const ::std::os::raw::c_char,
                arg_lineno: ::std::os::raw::c_int,
                arg_funcname: *const ::std::os::raw::c_char,
            );
        }
        elog_start(arg_filename, arg_lineno, arg_funcname)
    })
}
pub unsafe fn elog_finish(
    arg_elevel: ::std::os::raw::c_int,
    arg_fmt: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn elog_finish(
                arg_elevel: ::std::os::raw::c_int,
                arg_fmt: *const ::std::os::raw::c_char,
            );
        }
        elog_finish(arg_elevel, arg_fmt)
    })
}
pub unsafe fn pre_format_elog_string(
    arg_errnumber: ::std::os::raw::c_int,
    arg_domain: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pre_format_elog_string(
                arg_errnumber: ::std::os::raw::c_int,
                arg_domain: *const ::std::os::raw::c_char,
            );
        }
        pre_format_elog_string(arg_errnumber, arg_domain)
    })
}
pub unsafe fn format_elog_string(
    arg_fmt: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn format_elog_string(
                arg_fmt: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        format_elog_string(arg_fmt)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ErrorContextCallback {
    pub previous: *mut ErrorContextCallback,
    pub callback: ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>,
    pub arg: *mut ::std::os::raw::c_void,
}
impl Default for ErrorContextCallback {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut error_context_stack: *mut ErrorContextCallback;
}
extern "C" {
    pub static mut PG_exception_stack: *mut sigjmp_buf;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ErrorData {
    pub elevel: ::std::os::raw::c_int,
    pub output_to_server: bool,
    pub output_to_client: bool,
    pub show_funcname: bool,
    pub hide_stmt: bool,
    pub hide_ctx: bool,
    pub filename: *const ::std::os::raw::c_char,
    pub lineno: ::std::os::raw::c_int,
    pub funcname: *const ::std::os::raw::c_char,
    pub domain: *const ::std::os::raw::c_char,
    pub context_domain: *const ::std::os::raw::c_char,
    pub sqlerrcode: ::std::os::raw::c_int,
    pub message: *mut ::std::os::raw::c_char,
    pub detail: *mut ::std::os::raw::c_char,
    pub detail_log: *mut ::std::os::raw::c_char,
    pub hint: *mut ::std::os::raw::c_char,
    pub context: *mut ::std::os::raw::c_char,
    pub message_id: *const ::std::os::raw::c_char,
    pub schema_name: *mut ::std::os::raw::c_char,
    pub table_name: *mut ::std::os::raw::c_char,
    pub column_name: *mut ::std::os::raw::c_char,
    pub datatype_name: *mut ::std::os::raw::c_char,
    pub constraint_name: *mut ::std::os::raw::c_char,
    pub cursorpos: ::std::os::raw::c_int,
    pub internalpos: ::std::os::raw::c_int,
    pub internalquery: *mut ::std::os::raw::c_char,
    pub saved_errno: ::std::os::raw::c_int,
    pub assoc_context: *mut MemoryContextData,
}
impl Default for ErrorData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn EmitErrorReport() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EmitErrorReport();
        }
        EmitErrorReport()
    })
}
pub unsafe fn CopyErrorData() -> *mut ErrorData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CopyErrorData() -> *mut ErrorData;
        }
        CopyErrorData()
    })
}
pub unsafe fn FreeErrorData(arg_edata: *mut ErrorData) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeErrorData(arg_edata: *mut ErrorData);
        }
        FreeErrorData(arg_edata)
    })
}
pub unsafe fn FlushErrorState() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FlushErrorState();
        }
        FlushErrorState()
    })
}
pub unsafe fn ReThrowError(arg_edata: *mut ErrorData) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReThrowError(arg_edata: *mut ErrorData);
        }
        ReThrowError(arg_edata)
    })
}
pub unsafe fn ThrowErrorData(arg_edata: *mut ErrorData) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ThrowErrorData(arg_edata: *mut ErrorData);
        }
        ThrowErrorData(arg_edata)
    })
}
pub unsafe fn GetErrorContextStack() -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetErrorContextStack() -> *mut ::std::os::raw::c_char;
        }
        GetErrorContextStack()
    })
}
pub type emit_log_hook_type = ::std::option::Option<unsafe extern "C" fn(edata: *mut ErrorData)>;
extern "C" {
    pub static mut emit_log_hook: emit_log_hook_type;
}
pub const PGErrorVerbosity_PGERROR_TERSE: PGErrorVerbosity = 0;
pub const PGErrorVerbosity_PGERROR_DEFAULT: PGErrorVerbosity = 1;
pub const PGErrorVerbosity_PGERROR_VERBOSE: PGErrorVerbosity = 2;
pub type PGErrorVerbosity = ::std::os::raw::c_uint;
extern "C" {
    pub static mut Log_error_verbosity: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut Log_line_prefix: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut Log_destination: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut Log_destination_string: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut syslog_sequence_numbers: bool;
}
extern "C" {
    pub static mut syslog_split_messages: bool;
}
pub unsafe fn DebugFileOpen() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DebugFileOpen();
        }
        DebugFileOpen()
    })
}
pub unsafe fn unpack_sql_state(
    arg_sql_state: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn unpack_sql_state(
                arg_sql_state: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        unpack_sql_state(arg_sql_state)
    })
}
pub unsafe fn in_error_recursion_trouble() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn in_error_recursion_trouble() -> bool;
        }
        in_error_recursion_trouble()
    })
}
pub unsafe fn set_syslog_parameters(
    arg_ident: *const ::std::os::raw::c_char,
    arg_facility: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_syslog_parameters(
                arg_ident: *const ::std::os::raw::c_char,
                arg_facility: ::std::os::raw::c_int,
            );
        }
        set_syslog_parameters(arg_ident, arg_facility)
    })
}
pub unsafe fn write_stderr(arg_fmt: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn write_stderr(arg_fmt: *const ::std::os::raw::c_char);
        }
        write_stderr(arg_fmt)
    })
}
pub type MemoryContext = *mut MemoryContextData;
pub type MemoryContextCallbackFunction =
    ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoryContextCallback {
    pub func: MemoryContextCallbackFunction,
    pub arg: *mut ::std::os::raw::c_void,
    pub next: *mut MemoryContextCallback,
}
impl Default for MemoryContextCallback {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut CurrentMemoryContext: MemoryContext;
}
pub unsafe fn MemoryContextAlloc(
    arg_context: MemoryContext,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAlloc(
                arg_context: MemoryContext,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAlloc(arg_context, arg_size)
    })
}
pub unsafe fn MemoryContextAllocZero(
    arg_context: MemoryContext,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAllocZero(
                arg_context: MemoryContext,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAllocZero(arg_context, arg_size)
    })
}
pub unsafe fn MemoryContextAllocZeroAligned(
    arg_context: MemoryContext,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAllocZeroAligned(
                arg_context: MemoryContext,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAllocZeroAligned(arg_context, arg_size)
    })
}
pub unsafe fn MemoryContextAllocExtended(
    arg_context: MemoryContext,
    arg_size: Size,
    arg_flags: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAllocExtended(
                arg_context: MemoryContext,
                arg_size: Size,
                arg_flags: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAllocExtended(arg_context, arg_size, arg_flags)
    })
}
pub unsafe fn palloc(arg_size: Size) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn palloc(arg_size: Size) -> *mut ::std::os::raw::c_void;
        }
        palloc(arg_size)
    })
}
pub unsafe fn palloc0(arg_size: Size) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn palloc0(arg_size: Size) -> *mut ::std::os::raw::c_void;
        }
        palloc0(arg_size)
    })
}
pub unsafe fn palloc_extended(
    arg_size: Size,
    arg_flags: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn palloc_extended(
                arg_size: Size,
                arg_flags: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_void;
        }
        palloc_extended(arg_size, arg_flags)
    })
}
pub unsafe fn repalloc(
    arg_pointer: *mut ::std::os::raw::c_void,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn repalloc(
                arg_pointer: *mut ::std::os::raw::c_void,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        repalloc(arg_pointer, arg_size)
    })
}
pub unsafe fn pfree(arg_pointer: *mut ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pfree(arg_pointer: *mut ::std::os::raw::c_void);
        }
        pfree(arg_pointer)
    })
}
pub unsafe fn MemoryContextAllocHuge(
    arg_context: MemoryContext,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAllocHuge(
                arg_context: MemoryContext,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAllocHuge(arg_context, arg_size)
    })
}
pub unsafe fn repalloc_huge(
    arg_pointer: *mut ::std::os::raw::c_void,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn repalloc_huge(
                arg_pointer: *mut ::std::os::raw::c_void,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        repalloc_huge(arg_pointer, arg_size)
    })
}
pub unsafe fn MemoryContextRegisterResetCallback(
    arg_context: MemoryContext,
    arg_cb: *mut MemoryContextCallback,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextRegisterResetCallback(
                arg_context: MemoryContext,
                arg_cb: *mut MemoryContextCallback,
            );
        }
        MemoryContextRegisterResetCallback(arg_context, arg_cb)
    })
}
pub unsafe fn MemoryContextStrdup(
    arg_context: MemoryContext,
    arg_string: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextStrdup(
                arg_context: MemoryContext,
                arg_string: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        MemoryContextStrdup(arg_context, arg_string)
    })
}
pub unsafe fn pstrdup(arg_in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pstrdup(arg_in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        pstrdup(arg_in_)
    })
}
pub unsafe fn pnstrdup(
    arg_in_: *const ::std::os::raw::c_char,
    arg_len: Size,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pnstrdup(
                arg_in_: *const ::std::os::raw::c_char,
                arg_len: Size,
            ) -> *mut ::std::os::raw::c_char;
        }
        pnstrdup(arg_in_, arg_len)
    })
}
pub unsafe fn pchomp(arg_in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pchomp(arg_in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        pchomp(arg_in_)
    })
}
pub unsafe fn psprintf(arg_fmt: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn psprintf(arg_fmt: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        psprintf(arg_fmt)
    })
}
pub unsafe fn pvsnprintf(
    arg_buf: *mut ::std::os::raw::c_char,
    arg_len: usize,
    arg_fmt: *const ::std::os::raw::c_char,
    arg_args: *mut __va_list_tag,
) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pvsnprintf(
                arg_buf: *mut ::std::os::raw::c_char,
                arg_len: usize,
                arg_fmt: *const ::std::os::raw::c_char,
                arg_args: *mut __va_list_tag,
            ) -> usize;
        }
        pvsnprintf(arg_buf, arg_len, arg_fmt, arg_args)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct varatt_external {
    pub va_rawsize: int32,
    pub va_extsize: int32,
    pub va_valueid: Oid,
    pub va_toastrelid: Oid,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct varatt_indirect {
    pub pointer: *mut varlena,
}
impl Default for varatt_indirect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct varatt_expanded {
    pub eohptr: *mut ExpandedObjectHeader,
}
impl Default for varatt_expanded {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const vartag_external_VARTAG_INDIRECT: vartag_external = 1;
pub const vartag_external_VARTAG_EXPANDED_RO: vartag_external = 2;
pub const vartag_external_VARTAG_EXPANDED_RW: vartag_external = 3;
pub const vartag_external_VARTAG_ONDISK: vartag_external = 18;
pub type vartag_external = ::std::os::raw::c_uint;
#[repr(C)]
pub struct varattrib_4b {
    pub va_4byte: __BindgenUnionField<varattrib_4b__bindgen_ty_1>,
    pub va_compressed: __BindgenUnionField<varattrib_4b__bindgen_ty_2>,
    pub bindgen_union_field: [u32; 2usize],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_4b__bindgen_ty_1 {
    pub va_header: uint32,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_4b__bindgen_ty_2 {
    pub va_header: uint32,
    pub va_rawsize: uint32,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
impl Default for varattrib_4b {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_1b {
    pub va_header: uint8,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_1b_e {
    pub va_header: uint8,
    pub va_tag: uint8,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
pub type fmNodePtr = *mut Node;
pub type fmAggrefPtr = *mut Aggref;
pub type fmExprContextCallbackFunction = ::std::option::Option<unsafe extern "C" fn(arg: Datum)>;
pub type fmStringInfo = *mut StringInfoData;
pub type FunctionCallInfo = *mut FunctionCallInfoBaseData;
pub type PGFunction =
    ::std::option::Option<unsafe extern "C" fn(fcinfo: FunctionCallInfo) -> Datum>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FmgrInfo {
    pub fn_addr: PGFunction,
    pub fn_oid: Oid,
    pub fn_nargs: ::std::os::raw::c_short,
    pub fn_strict: bool,
    pub fn_retset: bool,
    pub fn_stats: ::std::os::raw::c_uchar,
    pub fn_extra: *mut ::std::os::raw::c_void,
    pub fn_mcxt: MemoryContext,
    pub fn_expr: fmNodePtr,
}
impl Default for FmgrInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct FunctionCallInfoBaseData {
    pub flinfo: *mut FmgrInfo,
    pub context: fmNodePtr,
    pub resultinfo: fmNodePtr,
    pub fncollation: Oid,
    pub isnull: bool,
    pub nargs: ::std::os::raw::c_short,
    pub args: __IncompleteArrayField<NullableDatum>,
}
impl Default for FunctionCallInfoBaseData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn fmgr_info(arg_functionId: Oid, arg_finfo: *mut FmgrInfo) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_info(arg_functionId: Oid, arg_finfo: *mut FmgrInfo);
        }
        fmgr_info(arg_functionId, arg_finfo)
    })
}
pub unsafe fn fmgr_info_cxt(
    arg_functionId: Oid,
    arg_finfo: *mut FmgrInfo,
    arg_mcxt: MemoryContext,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_info_cxt(
                arg_functionId: Oid,
                arg_finfo: *mut FmgrInfo,
                arg_mcxt: MemoryContext,
            );
        }
        fmgr_info_cxt(arg_functionId, arg_finfo, arg_mcxt)
    })
}
pub unsafe fn fmgr_info_copy(
    arg_dstinfo: *mut FmgrInfo,
    arg_srcinfo: *mut FmgrInfo,
    arg_destcxt: MemoryContext,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_info_copy(
                arg_dstinfo: *mut FmgrInfo,
                arg_srcinfo: *mut FmgrInfo,
                arg_destcxt: MemoryContext,
            );
        }
        fmgr_info_copy(arg_dstinfo, arg_srcinfo, arg_destcxt)
    })
}
pub unsafe fn fmgr_symbol(
    arg_functionId: Oid,
    arg_mod_: *mut *mut ::std::os::raw::c_char,
    arg_fn_: *mut *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_symbol(
                arg_functionId: Oid,
                arg_mod_: *mut *mut ::std::os::raw::c_char,
                arg_fn_: *mut *mut ::std::os::raw::c_char,
            );
        }
        fmgr_symbol(arg_functionId, arg_mod_, arg_fn_)
    })
}
pub unsafe fn pg_detoast_datum(arg_datum: *mut varlena) -> *mut varlena {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_detoast_datum(arg_datum: *mut varlena) -> *mut varlena;
        }
        pg_detoast_datum(arg_datum)
    })
}
pub unsafe fn pg_detoast_datum_copy(arg_datum: *mut varlena) -> *mut varlena {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_detoast_datum_copy(arg_datum: *mut varlena) -> *mut varlena;
        }
        pg_detoast_datum_copy(arg_datum)
    })
}
pub unsafe fn pg_detoast_datum_slice(
    arg_datum: *mut varlena,
    arg_first: int32,
    arg_count: int32,
) -> *mut varlena {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_detoast_datum_slice(
                arg_datum: *mut varlena,
                arg_first: int32,
                arg_count: int32,
            ) -> *mut varlena;
        }
        pg_detoast_datum_slice(arg_datum, arg_first, arg_count)
    })
}
pub unsafe fn pg_detoast_datum_packed(arg_datum: *mut varlena) -> *mut varlena {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_detoast_datum_packed(arg_datum: *mut varlena) -> *mut varlena;
        }
        pg_detoast_datum_packed(arg_datum)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Pg_finfo_record {
    pub api_version: ::std::os::raw::c_int,
}
pub type PGFInfoFunction = ::std::option::Option<unsafe extern "C" fn() -> *const Pg_finfo_record>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Pg_magic_struct {
    pub len: ::std::os::raw::c_int,
    pub version: ::std::os::raw::c_int,
    pub funcmaxargs: ::std::os::raw::c_int,
    pub indexmaxkeys: ::std::os::raw::c_int,
    pub namedatalen: ::std::os::raw::c_int,
    pub float4byval: ::std::os::raw::c_int,
    pub float8byval: ::std::os::raw::c_int,
}
pub type PGModuleMagicFunction =
    ::std::option::Option<unsafe extern "C" fn() -> *const Pg_magic_struct>;
pub unsafe fn DirectFunctionCall1Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall1Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
            ) -> Datum;
        }
        DirectFunctionCall1Coll(arg_func, arg_collation, arg_arg1)
    })
}
pub unsafe fn DirectFunctionCall2Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall2Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
            ) -> Datum;
        }
        DirectFunctionCall2Coll(arg_func, arg_collation, arg_arg1, arg_arg2)
    })
}
pub unsafe fn DirectFunctionCall3Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall3Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
            ) -> Datum;
        }
        DirectFunctionCall3Coll(arg_func, arg_collation, arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn DirectFunctionCall4Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall4Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
            ) -> Datum;
        }
        DirectFunctionCall4Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
        )
    })
}
pub unsafe fn DirectFunctionCall5Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall5Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
            ) -> Datum;
        }
        DirectFunctionCall5Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
        )
    })
}
pub unsafe fn DirectFunctionCall6Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall6Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
            ) -> Datum;
        }
        DirectFunctionCall6Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
        )
    })
}
pub unsafe fn DirectFunctionCall7Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall7Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
            ) -> Datum;
        }
        DirectFunctionCall7Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
        )
    })
}
pub unsafe fn DirectFunctionCall8Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall8Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
            ) -> Datum;
        }
        DirectFunctionCall8Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
        )
    })
}
pub unsafe fn DirectFunctionCall9Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
    arg_arg9: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall9Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
                arg_arg9: Datum,
            ) -> Datum;
        }
        DirectFunctionCall9Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
            arg_arg9,
        )
    })
}
pub unsafe fn CallerFInfoFunctionCall1(
    arg_func: PGFunction,
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CallerFInfoFunctionCall1(
                arg_func: PGFunction,
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
            ) -> Datum;
        }
        CallerFInfoFunctionCall1(arg_func, arg_flinfo, arg_collation, arg_arg1)
    })
}
pub unsafe fn CallerFInfoFunctionCall2(
    arg_func: PGFunction,
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CallerFInfoFunctionCall2(
                arg_func: PGFunction,
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
            ) -> Datum;
        }
        CallerFInfoFunctionCall2(arg_func, arg_flinfo, arg_collation, arg_arg1, arg_arg2)
    })
}
pub unsafe fn FunctionCall0Coll(arg_flinfo: *mut FmgrInfo, arg_collation: Oid) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall0Coll(arg_flinfo: *mut FmgrInfo, arg_collation: Oid) -> Datum;
        }
        FunctionCall0Coll(arg_flinfo, arg_collation)
    })
}
pub unsafe fn FunctionCall1Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall1Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
            ) -> Datum;
        }
        FunctionCall1Coll(arg_flinfo, arg_collation, arg_arg1)
    })
}
pub unsafe fn FunctionCall2Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall2Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
            ) -> Datum;
        }
        FunctionCall2Coll(arg_flinfo, arg_collation, arg_arg1, arg_arg2)
    })
}
pub unsafe fn FunctionCall3Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall3Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
            ) -> Datum;
        }
        FunctionCall3Coll(arg_flinfo, arg_collation, arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn FunctionCall4Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall4Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
            ) -> Datum;
        }
        FunctionCall4Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
        )
    })
}
pub unsafe fn FunctionCall5Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall5Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
            ) -> Datum;
        }
        FunctionCall5Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
        )
    })
}
pub unsafe fn FunctionCall6Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall6Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
            ) -> Datum;
        }
        FunctionCall6Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
        )
    })
}
pub unsafe fn FunctionCall7Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall7Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
            ) -> Datum;
        }
        FunctionCall7Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
        )
    })
}
pub unsafe fn FunctionCall8Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall8Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
            ) -> Datum;
        }
        FunctionCall8Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
        )
    })
}
pub unsafe fn FunctionCall9Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
    arg_arg9: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall9Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
                arg_arg9: Datum,
            ) -> Datum;
        }
        FunctionCall9Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
            arg_arg9,
        )
    })
}
pub unsafe fn OidFunctionCall0Coll(arg_functionId: Oid, arg_collation: Oid) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall0Coll(arg_functionId: Oid, arg_collation: Oid) -> Datum;
        }
        OidFunctionCall0Coll(arg_functionId, arg_collation)
    })
}
pub unsafe fn OidFunctionCall1Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall1Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
            ) -> Datum;
        }
        OidFunctionCall1Coll(arg_functionId, arg_collation, arg_arg1)
    })
}
pub unsafe fn OidFunctionCall2Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall2Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
            ) -> Datum;
        }
        OidFunctionCall2Coll(arg_functionId, arg_collation, arg_arg1, arg_arg2)
    })
}
pub unsafe fn OidFunctionCall3Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall3Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
            ) -> Datum;
        }
        OidFunctionCall3Coll(arg_functionId, arg_collation, arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn OidFunctionCall4Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall4Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
            ) -> Datum;
        }
        OidFunctionCall4Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
        )
    })
}
pub unsafe fn OidFunctionCall5Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall5Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
            ) -> Datum;
        }
        OidFunctionCall5Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
        )
    })
}
pub unsafe fn OidFunctionCall6Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall6Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
            ) -> Datum;
        }
        OidFunctionCall6Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
        )
    })
}
pub unsafe fn OidFunctionCall7Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall7Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
            ) -> Datum;
        }
        OidFunctionCall7Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
        )
    })
}
pub unsafe fn OidFunctionCall8Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall8Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
            ) -> Datum;
        }
        OidFunctionCall8Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
        )
    })
}
pub unsafe fn OidFunctionCall9Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
    arg_arg9: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall9Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
                arg_arg9: Datum,
            ) -> Datum;
        }
        OidFunctionCall9Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
            arg_arg9,
        )
    })
}
pub unsafe fn InputFunctionCall(
    arg_flinfo: *mut FmgrInfo,
    arg_str_: *mut ::std::os::raw::c_char,
    arg_typioparam: Oid,
    arg_typmod: int32,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InputFunctionCall(
                arg_flinfo: *mut FmgrInfo,
                arg_str_: *mut ::std::os::raw::c_char,
                arg_typioparam: Oid,
                arg_typmod: int32,
            ) -> Datum;
        }
        InputFunctionCall(arg_flinfo, arg_str_, arg_typioparam, arg_typmod)
    })
}
pub unsafe fn OidInputFunctionCall(
    arg_functionId: Oid,
    arg_str_: *mut ::std::os::raw::c_char,
    arg_typioparam: Oid,
    arg_typmod: int32,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidInputFunctionCall(
                arg_functionId: Oid,
                arg_str_: *mut ::std::os::raw::c_char,
                arg_typioparam: Oid,
                arg_typmod: int32,
            ) -> Datum;
        }
        OidInputFunctionCall(arg_functionId, arg_str_, arg_typioparam, arg_typmod)
    })
}
pub unsafe fn OutputFunctionCall(
    arg_flinfo: *mut FmgrInfo,
    arg_val: Datum,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OutputFunctionCall(
                arg_flinfo: *mut FmgrInfo,
                arg_val: Datum,
            ) -> *mut ::std::os::raw::c_char;
        }
        OutputFunctionCall(arg_flinfo, arg_val)
    })
}
pub unsafe fn OidOutputFunctionCall(
    arg_functionId: Oid,
    arg_val: Datum,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidOutputFunctionCall(
                arg_functionId: Oid,
                arg_val: Datum,
            ) -> *mut ::std::os::raw::c_char;
        }
        OidOutputFunctionCall(arg_functionId, arg_val)
    })
}
pub unsafe fn ReceiveFunctionCall(
    arg_flinfo: *mut FmgrInfo,
    arg_buf: fmStringInfo,
    arg_typioparam: Oid,
    arg_typmod: int32,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReceiveFunctionCall(
                arg_flinfo: *mut FmgrInfo,
                arg_buf: fmStringInfo,
                arg_typioparam: Oid,
                arg_typmod: int32,
            ) -> Datum;
        }
        ReceiveFunctionCall(arg_flinfo, arg_buf, arg_typioparam, arg_typmod)
    })
}
pub unsafe fn OidReceiveFunctionCall(
    arg_functionId: Oid,
    arg_buf: fmStringInfo,
    arg_typioparam: Oid,
    arg_typmod: int32,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidReceiveFunctionCall(
                arg_functionId: Oid,
                arg_buf: fmStringInfo,
                arg_typioparam: Oid,
                arg_typmod: int32,
            ) -> Datum;
        }
        OidReceiveFunctionCall(arg_functionId, arg_buf, arg_typioparam, arg_typmod)
    })
}
pub unsafe fn SendFunctionCall(arg_flinfo: *mut FmgrInfo, arg_val: Datum) -> *mut bytea {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SendFunctionCall(arg_flinfo: *mut FmgrInfo, arg_val: Datum) -> *mut bytea;
        }
        SendFunctionCall(arg_flinfo, arg_val)
    })
}
pub unsafe fn OidSendFunctionCall(arg_functionId: Oid, arg_val: Datum) -> *mut bytea {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidSendFunctionCall(arg_functionId: Oid, arg_val: Datum) -> *mut bytea;
        }
        OidSendFunctionCall(arg_functionId, arg_val)
    })
}
pub unsafe fn fetch_finfo_record(
    arg_filehandle: *mut ::std::os::raw::c_void,
    arg_funcname: *const ::std::os::raw::c_char,
) -> *const Pg_finfo_record {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fetch_finfo_record(
                arg_filehandle: *mut ::std::os::raw::c_void,
                arg_funcname: *const ::std::os::raw::c_char,
            ) -> *const Pg_finfo_record;
        }
        fetch_finfo_record(arg_filehandle, arg_funcname)
    })
}
pub unsafe fn clear_external_function_hash(arg_filehandle: *mut ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clear_external_function_hash(arg_filehandle: *mut ::std::os::raw::c_void);
        }
        clear_external_function_hash(arg_filehandle)
    })
}
pub unsafe fn fmgr_internal_function(arg_proname: *const ::std::os::raw::c_char) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_internal_function(arg_proname: *const ::std::os::raw::c_char) -> Oid;
        }
        fmgr_internal_function(arg_proname)
    })
}
pub unsafe fn get_fn_expr_rettype(arg_flinfo: *mut FmgrInfo) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_fn_expr_rettype(arg_flinfo: *mut FmgrInfo) -> Oid;
        }
        get_fn_expr_rettype(arg_flinfo)
    })
}
pub unsafe fn get_fn_expr_argtype(
    arg_flinfo: *mut FmgrInfo,
    arg_argnum: ::std::os::raw::c_int,
) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_fn_expr_argtype(
                arg_flinfo: *mut FmgrInfo,
                arg_argnum: ::std::os::raw::c_int,
            ) -> Oid;
        }
        get_fn_expr_argtype(arg_flinfo, arg_argnum)
    })
}
pub unsafe fn get_call_expr_argtype(arg_expr: fmNodePtr, arg_argnum: ::std::os::raw::c_int) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_call_expr_argtype(arg_expr: fmNodePtr, arg_argnum: ::std::os::raw::c_int)
                -> Oid;
        }
        get_call_expr_argtype(arg_expr, arg_argnum)
    })
}
pub unsafe fn get_fn_expr_arg_stable(
    arg_flinfo: *mut FmgrInfo,
    arg_argnum: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_fn_expr_arg_stable(
                arg_flinfo: *mut FmgrInfo,
                arg_argnum: ::std::os::raw::c_int,
            ) -> bool;
        }
        get_fn_expr_arg_stable(arg_flinfo, arg_argnum)
    })
}
pub unsafe fn get_call_expr_arg_stable(
    arg_expr: fmNodePtr,
    arg_argnum: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_call_expr_arg_stable(
                arg_expr: fmNodePtr,
                arg_argnum: ::std::os::raw::c_int,
            ) -> bool;
        }
        get_call_expr_arg_stable(arg_expr, arg_argnum)
    })
}
pub unsafe fn get_fn_expr_variadic(arg_flinfo: *mut FmgrInfo) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_fn_expr_variadic(arg_flinfo: *mut FmgrInfo) -> bool;
        }
        get_fn_expr_variadic(arg_flinfo)
    })
}
pub unsafe fn CheckFunctionValidatorAccess(arg_validatorOid: Oid, arg_functionOid: Oid) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CheckFunctionValidatorAccess(arg_validatorOid: Oid, arg_functionOid: Oid) -> bool;
        }
        CheckFunctionValidatorAccess(arg_validatorOid, arg_functionOid)
    })
}
extern "C" {
    pub static mut Dynamic_library_path: *mut ::std::os::raw::c_char;
}
pub unsafe fn load_external_function(
    arg_filename: *const ::std::os::raw::c_char,
    arg_funcname: *const ::std::os::raw::c_char,
    arg_signalNotFound: bool,
    arg_filehandle: *mut *mut ::std::os::raw::c_void,
) -> PGFunction {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn load_external_function(
                arg_filename: *const ::std::os::raw::c_char,
                arg_funcname: *const ::std::os::raw::c_char,
                arg_signalNotFound: bool,
                arg_filehandle: *mut *mut ::std::os::raw::c_void,
            ) -> PGFunction;
        }
        load_external_function(
            arg_filename,
            arg_funcname,
            arg_signalNotFound,
            arg_filehandle,
        )
    })
}
pub unsafe fn lookup_external_function(
    arg_filehandle: *mut ::std::os::raw::c_void,
    arg_funcname: *const ::std::os::raw::c_char,
) -> PGFunction {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lookup_external_function(
                arg_filehandle: *mut ::std::os::raw::c_void,
                arg_funcname: *const ::std::os::raw::c_char,
            ) -> PGFunction;
        }
        lookup_external_function(arg_filehandle, arg_funcname)
    })
}
pub unsafe fn load_file(arg_filename: *const ::std::os::raw::c_char, arg_restricted: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn load_file(arg_filename: *const ::std::os::raw::c_char, arg_restricted: bool);
        }
        load_file(arg_filename, arg_restricted)
    })
}
pub unsafe fn find_rendezvous_variable(
    arg_varName: *const ::std::os::raw::c_char,
) -> *mut *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn find_rendezvous_variable(
                arg_varName: *const ::std::os::raw::c_char,
            ) -> *mut *mut ::std::os::raw::c_void;
        }
        find_rendezvous_variable(arg_varName)
    })
}
pub unsafe fn EstimateLibraryStateSpace() -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EstimateLibraryStateSpace() -> Size;
        }
        EstimateLibraryStateSpace()
    })
}
pub unsafe fn SerializeLibraryState(
    arg_maxsize: Size,
    arg_start_address: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SerializeLibraryState(
                arg_maxsize: Size,
                arg_start_address: *mut ::std::os::raw::c_char,
            );
        }
        SerializeLibraryState(arg_maxsize, arg_start_address)
    })
}
pub unsafe fn RestoreLibraryState(arg_start_address: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RestoreLibraryState(arg_start_address: *mut ::std::os::raw::c_char);
        }
        RestoreLibraryState(arg_start_address)
    })
}
pub unsafe fn AggCheckCallContext(
    arg_fcinfo: FunctionCallInfo,
    arg_aggcontext: *mut MemoryContext,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggCheckCallContext(
                arg_fcinfo: FunctionCallInfo,
                arg_aggcontext: *mut MemoryContext,
            ) -> ::std::os::raw::c_int;
        }
        AggCheckCallContext(arg_fcinfo, arg_aggcontext)
    })
}
pub unsafe fn AggGetAggref(arg_fcinfo: FunctionCallInfo) -> fmAggrefPtr {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggGetAggref(arg_fcinfo: FunctionCallInfo) -> fmAggrefPtr;
        }
        AggGetAggref(arg_fcinfo)
    })
}
pub unsafe fn AggGetTempMemoryContext(arg_fcinfo: FunctionCallInfo) -> MemoryContext {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggGetTempMemoryContext(arg_fcinfo: FunctionCallInfo) -> MemoryContext;
        }
        AggGetTempMemoryContext(arg_fcinfo)
    })
}
pub unsafe fn AggStateIsShared(arg_fcinfo: FunctionCallInfo) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggStateIsShared(arg_fcinfo: FunctionCallInfo) -> bool;
        }
        AggStateIsShared(arg_fcinfo)
    })
}
pub unsafe fn AggRegisterCallback(
    arg_fcinfo: FunctionCallInfo,
    arg_func: fmExprContextCallbackFunction,
    arg_arg: Datum,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggRegisterCallback(
                arg_fcinfo: FunctionCallInfo,
                arg_func: fmExprContextCallbackFunction,
                arg_arg: Datum,
            );
        }
        AggRegisterCallback(arg_fcinfo, arg_func, arg_arg)
    })
}
pub const FmgrHookEventType_FHET_START: FmgrHookEventType = 0;
pub const FmgrHookEventType_FHET_END: FmgrHookEventType = 1;
pub const FmgrHookEventType_FHET_ABORT: FmgrHookEventType = 2;
pub type FmgrHookEventType = ::std::os::raw::c_uint;
pub type needs_fmgr_hook_type = ::std::option::Option<unsafe extern "C" fn(fn_oid: Oid) -> bool>;
pub type fmgr_hook_type = ::std::option::Option<
    unsafe extern "C" fn(event: FmgrHookEventType, flinfo: *mut FmgrInfo, arg: *mut Datum),
>;
extern "C" {
    pub static mut needs_fmgr_hook: needs_fmgr_hook_type;
}
extern "C" {
    pub static mut fmgr_hook: fmgr_hook_type;
}
pub type AttrNumber = int16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_attribute {
    pub attrelid: Oid,
    pub attname: NameData,
    pub atttypid: Oid,
    pub attstattarget: int32,
    pub attlen: int16,
    pub attnum: int16,
    pub attndims: int32,
    pub attcacheoff: int32,
    pub atttypmod: int32,
    pub attbyval: bool,
    pub attstorage: ::std::os::raw::c_char,
    pub attalign: ::std::os::raw::c_char,
    pub attnotnull: bool,
    pub atthasdef: bool,
    pub atthasmissing: bool,
    pub attidentity: ::std::os::raw::c_char,
    pub attgenerated: ::std::os::raw::c_char,
    pub attisdropped: bool,
    pub attislocal: bool,
    pub attinhcount: int32,
    pub attcollation: Oid,
}
impl Default for FormData_pg_attribute {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_attribute = *mut FormData_pg_attribute;
pub const NodeTag_T_Invalid: NodeTag = 0;
pub const NodeTag_T_IndexInfo: NodeTag = 1;
pub const NodeTag_T_ExprContext: NodeTag = 2;
pub const NodeTag_T_ProjectionInfo: NodeTag = 3;
pub const NodeTag_T_JunkFilter: NodeTag = 4;
pub const NodeTag_T_OnConflictSetState: NodeTag = 5;
pub const NodeTag_T_ResultRelInfo: NodeTag = 6;
pub const NodeTag_T_EState: NodeTag = 7;
pub const NodeTag_T_TupleTableSlot: NodeTag = 8;
pub const NodeTag_T_Plan: NodeTag = 9;
pub const NodeTag_T_Result: NodeTag = 10;
pub const NodeTag_T_ProjectSet: NodeTag = 11;
pub const NodeTag_T_ModifyTable: NodeTag = 12;
pub const NodeTag_T_Append: NodeTag = 13;
pub const NodeTag_T_MergeAppend: NodeTag = 14;
pub const NodeTag_T_RecursiveUnion: NodeTag = 15;
pub const NodeTag_T_BitmapAnd: NodeTag = 16;
pub const NodeTag_T_BitmapOr: NodeTag = 17;
pub const NodeTag_T_Scan: NodeTag = 18;
pub const NodeTag_T_SeqScan: NodeTag = 19;
pub const NodeTag_T_SampleScan: NodeTag = 20;
pub const NodeTag_T_IndexScan: NodeTag = 21;
pub const NodeTag_T_IndexOnlyScan: NodeTag = 22;
pub const NodeTag_T_BitmapIndexScan: NodeTag = 23;
pub const NodeTag_T_BitmapHeapScan: NodeTag = 24;
pub const NodeTag_T_TidScan: NodeTag = 25;
pub const NodeTag_T_SubqueryScan: NodeTag = 26;
pub const NodeTag_T_FunctionScan: NodeTag = 27;
pub const NodeTag_T_ValuesScan: NodeTag = 28;
pub const NodeTag_T_TableFuncScan: NodeTag = 29;
pub const NodeTag_T_CteScan: NodeTag = 30;
pub const NodeTag_T_NamedTuplestoreScan: NodeTag = 31;
pub const NodeTag_T_WorkTableScan: NodeTag = 32;
pub const NodeTag_T_ForeignScan: NodeTag = 33;
pub const NodeTag_T_CustomScan: NodeTag = 34;
pub const NodeTag_T_Join: NodeTag = 35;
pub const NodeTag_T_NestLoop: NodeTag = 36;
pub const NodeTag_T_MergeJoin: NodeTag = 37;
pub const NodeTag_T_HashJoin: NodeTag = 38;
pub const NodeTag_T_Material: NodeTag = 39;
pub const NodeTag_T_Sort: NodeTag = 40;
pub const NodeTag_T_Group: NodeTag = 41;
pub const NodeTag_T_Agg: NodeTag = 42;
pub const NodeTag_T_WindowAgg: NodeTag = 43;
pub const NodeTag_T_Unique: NodeTag = 44;
pub const NodeTag_T_Gather: NodeTag = 45;
pub const NodeTag_T_GatherMerge: NodeTag = 46;
pub const NodeTag_T_Hash: NodeTag = 47;
pub const NodeTag_T_SetOp: NodeTag = 48;
pub const NodeTag_T_LockRows: NodeTag = 49;
pub const NodeTag_T_Limit: NodeTag = 50;
pub const NodeTag_T_NestLoopParam: NodeTag = 51;
pub const NodeTag_T_PlanRowMark: NodeTag = 52;
pub const NodeTag_T_PartitionPruneInfo: NodeTag = 53;
pub const NodeTag_T_PartitionedRelPruneInfo: NodeTag = 54;
pub const NodeTag_T_PartitionPruneStepOp: NodeTag = 55;
pub const NodeTag_T_PartitionPruneStepCombine: NodeTag = 56;
pub const NodeTag_T_PlanInvalItem: NodeTag = 57;
pub const NodeTag_T_PlanState: NodeTag = 58;
pub const NodeTag_T_ResultState: NodeTag = 59;
pub const NodeTag_T_ProjectSetState: NodeTag = 60;
pub const NodeTag_T_ModifyTableState: NodeTag = 61;
pub const NodeTag_T_AppendState: NodeTag = 62;
pub const NodeTag_T_MergeAppendState: NodeTag = 63;
pub const NodeTag_T_RecursiveUnionState: NodeTag = 64;
pub const NodeTag_T_BitmapAndState: NodeTag = 65;
pub const NodeTag_T_BitmapOrState: NodeTag = 66;
pub const NodeTag_T_ScanState: NodeTag = 67;
pub const NodeTag_T_SeqScanState: NodeTag = 68;
pub const NodeTag_T_SampleScanState: NodeTag = 69;
pub const NodeTag_T_IndexScanState: NodeTag = 70;
pub const NodeTag_T_IndexOnlyScanState: NodeTag = 71;
pub const NodeTag_T_BitmapIndexScanState: NodeTag = 72;
pub const NodeTag_T_BitmapHeapScanState: NodeTag = 73;
pub const NodeTag_T_TidScanState: NodeTag = 74;
pub const NodeTag_T_SubqueryScanState: NodeTag = 75;
pub const NodeTag_T_FunctionScanState: NodeTag = 76;
pub const NodeTag_T_TableFuncScanState: NodeTag = 77;
pub const NodeTag_T_ValuesScanState: NodeTag = 78;
pub const NodeTag_T_CteScanState: NodeTag = 79;
pub const NodeTag_T_NamedTuplestoreScanState: NodeTag = 80;
pub const NodeTag_T_WorkTableScanState: NodeTag = 81;
pub const NodeTag_T_ForeignScanState: NodeTag = 82;
pub const NodeTag_T_CustomScanState: NodeTag = 83;
pub const NodeTag_T_JoinState: NodeTag = 84;
pub const NodeTag_T_NestLoopState: NodeTag = 85;
pub const NodeTag_T_MergeJoinState: NodeTag = 86;
pub const NodeTag_T_HashJoinState: NodeTag = 87;
pub const NodeTag_T_MaterialState: NodeTag = 88;
pub const NodeTag_T_SortState: NodeTag = 89;
pub const NodeTag_T_GroupState: NodeTag = 90;
pub const NodeTag_T_AggState: NodeTag = 91;
pub const NodeTag_T_WindowAggState: NodeTag = 92;
pub const NodeTag_T_UniqueState: NodeTag = 93;
pub const NodeTag_T_GatherState: NodeTag = 94;
pub const NodeTag_T_GatherMergeState: NodeTag = 95;
pub const NodeTag_T_HashState: NodeTag = 96;
pub const NodeTag_T_SetOpState: NodeTag = 97;
pub const NodeTag_T_LockRowsState: NodeTag = 98;
pub const NodeTag_T_LimitState: NodeTag = 99;
pub const NodeTag_T_Alias: NodeTag = 100;
pub const NodeTag_T_RangeVar: NodeTag = 101;
pub const NodeTag_T_TableFunc: NodeTag = 102;
pub const NodeTag_T_Expr: NodeTag = 103;
pub const NodeTag_T_Var: NodeTag = 104;
pub const NodeTag_T_Const: NodeTag = 105;
pub const NodeTag_T_Param: NodeTag = 106;
pub const NodeTag_T_Aggref: NodeTag = 107;
pub const NodeTag_T_GroupingFunc: NodeTag = 108;
pub const NodeTag_T_WindowFunc: NodeTag = 109;
pub const NodeTag_T_SubscriptingRef: NodeTag = 110;
pub const NodeTag_T_FuncExpr: NodeTag = 111;
pub const NodeTag_T_NamedArgExpr: NodeTag = 112;
pub const NodeTag_T_OpExpr: NodeTag = 113;
pub const NodeTag_T_DistinctExpr: NodeTag = 114;
pub const NodeTag_T_NullIfExpr: NodeTag = 115;
pub const NodeTag_T_ScalarArrayOpExpr: NodeTag = 116;
pub const NodeTag_T_BoolExpr: NodeTag = 117;
pub const NodeTag_T_SubLink: NodeTag = 118;
pub const NodeTag_T_SubPlan: NodeTag = 119;
pub const NodeTag_T_AlternativeSubPlan: NodeTag = 120;
pub const NodeTag_T_FieldSelect: NodeTag = 121;
pub const NodeTag_T_FieldStore: NodeTag = 122;
pub const NodeTag_T_RelabelType: NodeTag = 123;
pub const NodeTag_T_CoerceViaIO: NodeTag = 124;
pub const NodeTag_T_ArrayCoerceExpr: NodeTag = 125;
pub const NodeTag_T_ConvertRowtypeExpr: NodeTag = 126;
pub const NodeTag_T_CollateExpr: NodeTag = 127;
pub const NodeTag_T_CaseExpr: NodeTag = 128;
pub const NodeTag_T_CaseWhen: NodeTag = 129;
pub const NodeTag_T_CaseTestExpr: NodeTag = 130;
pub const NodeTag_T_ArrayExpr: NodeTag = 131;
pub const NodeTag_T_RowExpr: NodeTag = 132;
pub const NodeTag_T_RowCompareExpr: NodeTag = 133;
pub const NodeTag_T_CoalesceExpr: NodeTag = 134;
pub const NodeTag_T_MinMaxExpr: NodeTag = 135;
pub const NodeTag_T_SQLValueFunction: NodeTag = 136;
pub const NodeTag_T_XmlExpr: NodeTag = 137;
pub const NodeTag_T_NullTest: NodeTag = 138;
pub const NodeTag_T_BooleanTest: NodeTag = 139;
pub const NodeTag_T_CoerceToDomain: NodeTag = 140;
pub const NodeTag_T_CoerceToDomainValue: NodeTag = 141;
pub const NodeTag_T_SetToDefault: NodeTag = 142;
pub const NodeTag_T_CurrentOfExpr: NodeTag = 143;
pub const NodeTag_T_NextValueExpr: NodeTag = 144;
pub const NodeTag_T_InferenceElem: NodeTag = 145;
pub const NodeTag_T_TargetEntry: NodeTag = 146;
pub const NodeTag_T_RangeTblRef: NodeTag = 147;
pub const NodeTag_T_JoinExpr: NodeTag = 148;
pub const NodeTag_T_FromExpr: NodeTag = 149;
pub const NodeTag_T_OnConflictExpr: NodeTag = 150;
pub const NodeTag_T_IntoClause: NodeTag = 151;
pub const NodeTag_T_ExprState: NodeTag = 152;
pub const NodeTag_T_AggrefExprState: NodeTag = 153;
pub const NodeTag_T_WindowFuncExprState: NodeTag = 154;
pub const NodeTag_T_SetExprState: NodeTag = 155;
pub const NodeTag_T_SubPlanState: NodeTag = 156;
pub const NodeTag_T_AlternativeSubPlanState: NodeTag = 157;
pub const NodeTag_T_DomainConstraintState: NodeTag = 158;
pub const NodeTag_T_PlannerInfo: NodeTag = 159;
pub const NodeTag_T_PlannerGlobal: NodeTag = 160;
pub const NodeTag_T_RelOptInfo: NodeTag = 161;
pub const NodeTag_T_IndexOptInfo: NodeTag = 162;
pub const NodeTag_T_ForeignKeyOptInfo: NodeTag = 163;
pub const NodeTag_T_ParamPathInfo: NodeTag = 164;
pub const NodeTag_T_Path: NodeTag = 165;
pub const NodeTag_T_IndexPath: NodeTag = 166;
pub const NodeTag_T_BitmapHeapPath: NodeTag = 167;
pub const NodeTag_T_BitmapAndPath: NodeTag = 168;
pub const NodeTag_T_BitmapOrPath: NodeTag = 169;
pub const NodeTag_T_TidPath: NodeTag = 170;
pub const NodeTag_T_SubqueryScanPath: NodeTag = 171;
pub const NodeTag_T_ForeignPath: NodeTag = 172;
pub const NodeTag_T_CustomPath: NodeTag = 173;
pub const NodeTag_T_NestPath: NodeTag = 174;
pub const NodeTag_T_MergePath: NodeTag = 175;
pub const NodeTag_T_HashPath: NodeTag = 176;
pub const NodeTag_T_AppendPath: NodeTag = 177;
pub const NodeTag_T_MergeAppendPath: NodeTag = 178;
pub const NodeTag_T_GroupResultPath: NodeTag = 179;
pub const NodeTag_T_MaterialPath: NodeTag = 180;
pub const NodeTag_T_UniquePath: NodeTag = 181;
pub const NodeTag_T_GatherPath: NodeTag = 182;
pub const NodeTag_T_GatherMergePath: NodeTag = 183;
pub const NodeTag_T_ProjectionPath: NodeTag = 184;
pub const NodeTag_T_ProjectSetPath: NodeTag = 185;
pub const NodeTag_T_SortPath: NodeTag = 186;
pub const NodeTag_T_GroupPath: NodeTag = 187;
pub const NodeTag_T_UpperUniquePath: NodeTag = 188;
pub const NodeTag_T_AggPath: NodeTag = 189;
pub const NodeTag_T_GroupingSetsPath: NodeTag = 190;
pub const NodeTag_T_MinMaxAggPath: NodeTag = 191;
pub const NodeTag_T_WindowAggPath: NodeTag = 192;
pub const NodeTag_T_SetOpPath: NodeTag = 193;
pub const NodeTag_T_RecursiveUnionPath: NodeTag = 194;
pub const NodeTag_T_LockRowsPath: NodeTag = 195;
pub const NodeTag_T_ModifyTablePath: NodeTag = 196;
pub const NodeTag_T_LimitPath: NodeTag = 197;
pub const NodeTag_T_EquivalenceClass: NodeTag = 198;
pub const NodeTag_T_EquivalenceMember: NodeTag = 199;
pub const NodeTag_T_PathKey: NodeTag = 200;
pub const NodeTag_T_PathTarget: NodeTag = 201;
pub const NodeTag_T_RestrictInfo: NodeTag = 202;
pub const NodeTag_T_IndexClause: NodeTag = 203;
pub const NodeTag_T_PlaceHolderVar: NodeTag = 204;
pub const NodeTag_T_SpecialJoinInfo: NodeTag = 205;
pub const NodeTag_T_AppendRelInfo: NodeTag = 206;
pub const NodeTag_T_PlaceHolderInfo: NodeTag = 207;
pub const NodeTag_T_MinMaxAggInfo: NodeTag = 208;
pub const NodeTag_T_PlannerParamItem: NodeTag = 209;
pub const NodeTag_T_RollupData: NodeTag = 210;
pub const NodeTag_T_GroupingSetData: NodeTag = 211;
pub const NodeTag_T_StatisticExtInfo: NodeTag = 212;
pub const NodeTag_T_MemoryContext: NodeTag = 213;
pub const NodeTag_T_AllocSetContext: NodeTag = 214;
pub const NodeTag_T_SlabContext: NodeTag = 215;
pub const NodeTag_T_GenerationContext: NodeTag = 216;
pub const NodeTag_T_Value: NodeTag = 217;
pub const NodeTag_T_Integer: NodeTag = 218;
pub const NodeTag_T_Float: NodeTag = 219;
pub const NodeTag_T_String: NodeTag = 220;
pub const NodeTag_T_BitString: NodeTag = 221;
pub const NodeTag_T_Null: NodeTag = 222;
pub const NodeTag_T_List: NodeTag = 223;
pub const NodeTag_T_IntList: NodeTag = 224;
pub const NodeTag_T_OidList: NodeTag = 225;
pub const NodeTag_T_ExtensibleNode: NodeTag = 226;
pub const NodeTag_T_RawStmt: NodeTag = 227;
pub const NodeTag_T_Query: NodeTag = 228;
pub const NodeTag_T_PlannedStmt: NodeTag = 229;
pub const NodeTag_T_InsertStmt: NodeTag = 230;
pub const NodeTag_T_DeleteStmt: NodeTag = 231;
pub const NodeTag_T_UpdateStmt: NodeTag = 232;
pub const NodeTag_T_SelectStmt: NodeTag = 233;
pub const NodeTag_T_AlterTableStmt: NodeTag = 234;
pub const NodeTag_T_AlterTableCmd: NodeTag = 235;
pub const NodeTag_T_AlterDomainStmt: NodeTag = 236;
pub const NodeTag_T_SetOperationStmt: NodeTag = 237;
pub const NodeTag_T_GrantStmt: NodeTag = 238;
pub const NodeTag_T_GrantRoleStmt: NodeTag = 239;
pub const NodeTag_T_AlterDefaultPrivilegesStmt: NodeTag = 240;
pub const NodeTag_T_ClosePortalStmt: NodeTag = 241;
pub const NodeTag_T_ClusterStmt: NodeTag = 242;
pub const NodeTag_T_CopyStmt: NodeTag = 243;
pub const NodeTag_T_CreateStmt: NodeTag = 244;
pub const NodeTag_T_DefineStmt: NodeTag = 245;
pub const NodeTag_T_DropStmt: NodeTag = 246;
pub const NodeTag_T_TruncateStmt: NodeTag = 247;
pub const NodeTag_T_CommentStmt: NodeTag = 248;
pub const NodeTag_T_FetchStmt: NodeTag = 249;
pub const NodeTag_T_IndexStmt: NodeTag = 250;
pub const NodeTag_T_CreateFunctionStmt: NodeTag = 251;
pub const NodeTag_T_AlterFunctionStmt: NodeTag = 252;
pub const NodeTag_T_DoStmt: NodeTag = 253;
pub const NodeTag_T_RenameStmt: NodeTag = 254;
pub const NodeTag_T_RuleStmt: NodeTag = 255;
pub const NodeTag_T_NotifyStmt: NodeTag = 256;
pub const NodeTag_T_ListenStmt: NodeTag = 257;
pub const NodeTag_T_UnlistenStmt: NodeTag = 258;
pub const NodeTag_T_TransactionStmt: NodeTag = 259;
pub const NodeTag_T_ViewStmt: NodeTag = 260;
pub const NodeTag_T_LoadStmt: NodeTag = 261;
pub const NodeTag_T_CreateDomainStmt: NodeTag = 262;
pub const NodeTag_T_CreatedbStmt: NodeTag = 263;
pub const NodeTag_T_DropdbStmt: NodeTag = 264;
pub const NodeTag_T_VacuumStmt: NodeTag = 265;
pub const NodeTag_T_ExplainStmt: NodeTag = 266;
pub const NodeTag_T_CreateTableAsStmt: NodeTag = 267;
pub const NodeTag_T_CreateSeqStmt: NodeTag = 268;
pub const NodeTag_T_AlterSeqStmt: NodeTag = 269;
pub const NodeTag_T_VariableSetStmt: NodeTag = 270;
pub const NodeTag_T_VariableShowStmt: NodeTag = 271;
pub const NodeTag_T_DiscardStmt: NodeTag = 272;
pub const NodeTag_T_CreateTrigStmt: NodeTag = 273;
pub const NodeTag_T_CreatePLangStmt: NodeTag = 274;
pub const NodeTag_T_CreateRoleStmt: NodeTag = 275;
pub const NodeTag_T_AlterRoleStmt: NodeTag = 276;
pub const NodeTag_T_DropRoleStmt: NodeTag = 277;
pub const NodeTag_T_LockStmt: NodeTag = 278;
pub const NodeTag_T_ConstraintsSetStmt: NodeTag = 279;
pub const NodeTag_T_ReindexStmt: NodeTag = 280;
pub const NodeTag_T_CheckPointStmt: NodeTag = 281;
pub const NodeTag_T_CreateSchemaStmt: NodeTag = 282;
pub const NodeTag_T_AlterDatabaseStmt: NodeTag = 283;
pub const NodeTag_T_AlterDatabaseSetStmt: NodeTag = 284;
pub const NodeTag_T_AlterRoleSetStmt: NodeTag = 285;
pub const NodeTag_T_CreateConversionStmt: NodeTag = 286;
pub const NodeTag_T_CreateCastStmt: NodeTag = 287;
pub const NodeTag_T_CreateOpClassStmt: NodeTag = 288;
pub const NodeTag_T_CreateOpFamilyStmt: NodeTag = 289;
pub const NodeTag_T_AlterOpFamilyStmt: NodeTag = 290;
pub const NodeTag_T_PrepareStmt: NodeTag = 291;
pub const NodeTag_T_ExecuteStmt: NodeTag = 292;
pub const NodeTag_T_DeallocateStmt: NodeTag = 293;
pub const NodeTag_T_DeclareCursorStmt: NodeTag = 294;
pub const NodeTag_T_CreateTableSpaceStmt: NodeTag = 295;
pub const NodeTag_T_DropTableSpaceStmt: NodeTag = 296;
pub const NodeTag_T_AlterObjectDependsStmt: NodeTag = 297;
pub const NodeTag_T_AlterObjectSchemaStmt: NodeTag = 298;
pub const NodeTag_T_AlterOwnerStmt: NodeTag = 299;
pub const NodeTag_T_AlterOperatorStmt: NodeTag = 300;
pub const NodeTag_T_DropOwnedStmt: NodeTag = 301;
pub const NodeTag_T_ReassignOwnedStmt: NodeTag = 302;
pub const NodeTag_T_CompositeTypeStmt: NodeTag = 303;
pub const NodeTag_T_CreateEnumStmt: NodeTag = 304;
pub const NodeTag_T_CreateRangeStmt: NodeTag = 305;
pub const NodeTag_T_AlterEnumStmt: NodeTag = 306;
pub const NodeTag_T_AlterTSDictionaryStmt: NodeTag = 307;
pub const NodeTag_T_AlterTSConfigurationStmt: NodeTag = 308;
pub const NodeTag_T_CreateFdwStmt: NodeTag = 309;
pub const NodeTag_T_AlterFdwStmt: NodeTag = 310;
pub const NodeTag_T_CreateForeignServerStmt: NodeTag = 311;
pub const NodeTag_T_AlterForeignServerStmt: NodeTag = 312;
pub const NodeTag_T_CreateUserMappingStmt: NodeTag = 313;
pub const NodeTag_T_AlterUserMappingStmt: NodeTag = 314;
pub const NodeTag_T_DropUserMappingStmt: NodeTag = 315;
pub const NodeTag_T_AlterTableSpaceOptionsStmt: NodeTag = 316;
pub const NodeTag_T_AlterTableMoveAllStmt: NodeTag = 317;
pub const NodeTag_T_SecLabelStmt: NodeTag = 318;
pub const NodeTag_T_CreateForeignTableStmt: NodeTag = 319;
pub const NodeTag_T_ImportForeignSchemaStmt: NodeTag = 320;
pub const NodeTag_T_CreateExtensionStmt: NodeTag = 321;
pub const NodeTag_T_AlterExtensionStmt: NodeTag = 322;
pub const NodeTag_T_AlterExtensionContentsStmt: NodeTag = 323;
pub const NodeTag_T_CreateEventTrigStmt: NodeTag = 324;
pub const NodeTag_T_AlterEventTrigStmt: NodeTag = 325;
pub const NodeTag_T_RefreshMatViewStmt: NodeTag = 326;
pub const NodeTag_T_ReplicaIdentityStmt: NodeTag = 327;
pub const NodeTag_T_AlterSystemStmt: NodeTag = 328;
pub const NodeTag_T_CreatePolicyStmt: NodeTag = 329;
pub const NodeTag_T_AlterPolicyStmt: NodeTag = 330;
pub const NodeTag_T_CreateTransformStmt: NodeTag = 331;
pub const NodeTag_T_CreateAmStmt: NodeTag = 332;
pub const NodeTag_T_CreatePublicationStmt: NodeTag = 333;
pub const NodeTag_T_AlterPublicationStmt: NodeTag = 334;
pub const NodeTag_T_CreateSubscriptionStmt: NodeTag = 335;
pub const NodeTag_T_AlterSubscriptionStmt: NodeTag = 336;
pub const NodeTag_T_DropSubscriptionStmt: NodeTag = 337;
pub const NodeTag_T_CreateStatsStmt: NodeTag = 338;
pub const NodeTag_T_AlterCollationStmt: NodeTag = 339;
pub const NodeTag_T_CallStmt: NodeTag = 340;
pub const NodeTag_T_A_Expr: NodeTag = 341;
pub const NodeTag_T_ColumnRef: NodeTag = 342;
pub const NodeTag_T_ParamRef: NodeTag = 343;
pub const NodeTag_T_A_Const: NodeTag = 344;
pub const NodeTag_T_FuncCall: NodeTag = 345;
pub const NodeTag_T_A_Star: NodeTag = 346;
pub const NodeTag_T_A_Indices: NodeTag = 347;
pub const NodeTag_T_A_Indirection: NodeTag = 348;
pub const NodeTag_T_A_ArrayExpr: NodeTag = 349;
pub const NodeTag_T_ResTarget: NodeTag = 350;
pub const NodeTag_T_MultiAssignRef: NodeTag = 351;
pub const NodeTag_T_TypeCast: NodeTag = 352;
pub const NodeTag_T_CollateClause: NodeTag = 353;
pub const NodeTag_T_SortBy: NodeTag = 354;
pub const NodeTag_T_WindowDef: NodeTag = 355;
pub const NodeTag_T_RangeSubselect: NodeTag = 356;
pub const NodeTag_T_RangeFunction: NodeTag = 357;
pub const NodeTag_T_RangeTableSample: NodeTag = 358;
pub const NodeTag_T_RangeTableFunc: NodeTag = 359;
pub const NodeTag_T_RangeTableFuncCol: NodeTag = 360;
pub const NodeTag_T_TypeName: NodeTag = 361;
pub const NodeTag_T_ColumnDef: NodeTag = 362;
pub const NodeTag_T_IndexElem: NodeTag = 363;
pub const NodeTag_T_Constraint: NodeTag = 364;
pub const NodeTag_T_DefElem: NodeTag = 365;
pub const NodeTag_T_RangeTblEntry: NodeTag = 366;
pub const NodeTag_T_RangeTblFunction: NodeTag = 367;
pub const NodeTag_T_TableSampleClause: NodeTag = 368;
pub const NodeTag_T_WithCheckOption: NodeTag = 369;
pub const NodeTag_T_SortGroupClause: NodeTag = 370;
pub const NodeTag_T_GroupingSet: NodeTag = 371;
pub const NodeTag_T_WindowClause: NodeTag = 372;
pub const NodeTag_T_ObjectWithArgs: NodeTag = 373;
pub const NodeTag_T_AccessPriv: NodeTag = 374;
pub const NodeTag_T_CreateOpClassItem: NodeTag = 375;
pub const NodeTag_T_TableLikeClause: NodeTag = 376;
pub const NodeTag_T_FunctionParameter: NodeTag = 377;
pub const NodeTag_T_LockingClause: NodeTag = 378;
pub const NodeTag_T_RowMarkClause: NodeTag = 379;
pub const NodeTag_T_XmlSerialize: NodeTag = 380;
pub const NodeTag_T_WithClause: NodeTag = 381;
pub const NodeTag_T_InferClause: NodeTag = 382;
pub const NodeTag_T_OnConflictClause: NodeTag = 383;
pub const NodeTag_T_CommonTableExpr: NodeTag = 384;
pub const NodeTag_T_RoleSpec: NodeTag = 385;
pub const NodeTag_T_TriggerTransition: NodeTag = 386;
pub const NodeTag_T_PartitionElem: NodeTag = 387;
pub const NodeTag_T_PartitionSpec: NodeTag = 388;
pub const NodeTag_T_PartitionBoundSpec: NodeTag = 389;
pub const NodeTag_T_PartitionRangeDatum: NodeTag = 390;
pub const NodeTag_T_PartitionCmd: NodeTag = 391;
pub const NodeTag_T_VacuumRelation: NodeTag = 392;
pub const NodeTag_T_IdentifySystemCmd: NodeTag = 393;
pub const NodeTag_T_BaseBackupCmd: NodeTag = 394;
pub const NodeTag_T_CreateReplicationSlotCmd: NodeTag = 395;
pub const NodeTag_T_DropReplicationSlotCmd: NodeTag = 396;
pub const NodeTag_T_StartReplicationCmd: NodeTag = 397;
pub const NodeTag_T_TimeLineHistoryCmd: NodeTag = 398;
pub const NodeTag_T_SQLCmd: NodeTag = 399;
pub const NodeTag_T_TriggerData: NodeTag = 400;
pub const NodeTag_T_EventTriggerData: NodeTag = 401;
pub const NodeTag_T_ReturnSetInfo: NodeTag = 402;
pub const NodeTag_T_WindowObjectData: NodeTag = 403;
pub const NodeTag_T_TIDBitmap: NodeTag = 404;
pub const NodeTag_T_InlineCodeBlock: NodeTag = 405;
pub const NodeTag_T_FdwRoutine: NodeTag = 406;
pub const NodeTag_T_IndexAmRoutine: NodeTag = 407;
pub const NodeTag_T_TableAmRoutine: NodeTag = 408;
pub const NodeTag_T_TsmRoutine: NodeTag = 409;
pub const NodeTag_T_ForeignKeyCacheInfo: NodeTag = 410;
pub const NodeTag_T_CallContext: NodeTag = 411;
pub const NodeTag_T_SupportRequestSimplify: NodeTag = 412;
pub const NodeTag_T_SupportRequestSelectivity: NodeTag = 413;
pub const NodeTag_T_SupportRequestCost: NodeTag = 414;
pub const NodeTag_T_SupportRequestRows: NodeTag = 415;
pub const NodeTag_T_SupportRequestIndexCondition: NodeTag = 416;
pub type NodeTag = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Node {
    pub type_: NodeTag,
}
impl Default for Node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn outNode(arg_str_: *mut StringInfoData, arg_obj: *const ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn outNode(arg_str_: *mut StringInfoData, arg_obj: *const ::std::os::raw::c_void);
        }
        outNode(arg_str_, arg_obj)
    })
}
pub unsafe fn outToken(arg_str_: *mut StringInfoData, arg_s: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn outToken(arg_str_: *mut StringInfoData, arg_s: *const ::std::os::raw::c_char);
        }
        outToken(arg_str_, arg_s)
    })
}
pub unsafe fn outBitmapset(arg_str_: *mut StringInfoData, arg_bms: *const Bitmapset) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn outBitmapset(arg_str_: *mut StringInfoData, arg_bms: *const Bitmapset);
        }
        outBitmapset(arg_str_, arg_bms)
    })
}
pub unsafe fn outDatum(
    arg_str_: *mut StringInfoData,
    arg_value: usize,
    arg_typlen: ::std::os::raw::c_int,
    arg_typbyval: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn outDatum(
                arg_str_: *mut StringInfoData,
                arg_value: usize,
                arg_typlen: ::std::os::raw::c_int,
                arg_typbyval: bool,
            );
        }
        outDatum(arg_str_, arg_value, arg_typlen, arg_typbyval)
    })
}
pub unsafe fn nodeToString(arg_obj: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nodeToString(arg_obj: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_char;
        }
        nodeToString(arg_obj)
    })
}
pub unsafe fn bmsToString(arg_bms: *const Bitmapset) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bmsToString(arg_bms: *const Bitmapset) -> *mut ::std::os::raw::c_char;
        }
        bmsToString(arg_bms)
    })
}
pub unsafe fn stringToNode(arg_str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn stringToNode(arg_str_: *const ::std::os::raw::c_char)
                -> *mut ::std::os::raw::c_void;
        }
        stringToNode(arg_str_)
    })
}
pub unsafe fn readBitmapset() -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readBitmapset() -> *mut Bitmapset;
        }
        readBitmapset()
    })
}
pub unsafe fn readDatum(arg_typbyval: bool) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readDatum(arg_typbyval: bool) -> usize;
        }
        readDatum(arg_typbyval)
    })
}
pub unsafe fn readBoolCols(arg_numCols: ::std::os::raw::c_int) -> *mut bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readBoolCols(arg_numCols: ::std::os::raw::c_int) -> *mut bool;
        }
        readBoolCols(arg_numCols)
    })
}
pub unsafe fn readIntCols(arg_numCols: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readIntCols(arg_numCols: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_int;
        }
        readIntCols(arg_numCols)
    })
}
pub unsafe fn readOidCols(arg_numCols: ::std::os::raw::c_int) -> *mut Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readOidCols(arg_numCols: ::std::os::raw::c_int) -> *mut Oid;
        }
        readOidCols(arg_numCols)
    })
}
pub unsafe fn readAttrNumberCols(arg_numCols: ::std::os::raw::c_int) -> *mut int16 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readAttrNumberCols(arg_numCols: ::std::os::raw::c_int) -> *mut int16;
        }
        readAttrNumberCols(arg_numCols)
    })
}
pub unsafe fn copyObjectImpl(
    arg_obj: *const ::std::os::raw::c_void,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn copyObjectImpl(
                arg_obj: *const ::std::os::raw::c_void,
            ) -> *mut ::std::os::raw::c_void;
        }
        copyObjectImpl(arg_obj)
    })
}
pub unsafe fn equal(
    arg_a: *const ::std::os::raw::c_void,
    arg_b: *const ::std::os::raw::c_void,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn equal(
                arg_a: *const ::std::os::raw::c_void,
                arg_b: *const ::std::os::raw::c_void,
            ) -> bool;
        }
        equal(arg_a, arg_b)
    })
}
pub type Selectivity = f64;
pub type Cost = f64;
pub const CmdType_CMD_UNKNOWN: CmdType = 0;
pub const CmdType_CMD_SELECT: CmdType = 1;
pub const CmdType_CMD_UPDATE: CmdType = 2;
pub const CmdType_CMD_INSERT: CmdType = 3;
pub const CmdType_CMD_DELETE: CmdType = 4;
pub const CmdType_CMD_UTILITY: CmdType = 5;
pub const CmdType_CMD_NOTHING: CmdType = 6;
pub type CmdType = ::std::os::raw::c_uint;
pub const JoinType_JOIN_INNER: JoinType = 0;
pub const JoinType_JOIN_LEFT: JoinType = 1;
pub const JoinType_JOIN_FULL: JoinType = 2;
pub const JoinType_JOIN_RIGHT: JoinType = 3;
pub const JoinType_JOIN_SEMI: JoinType = 4;
pub const JoinType_JOIN_ANTI: JoinType = 5;
pub const JoinType_JOIN_UNIQUE_OUTER: JoinType = 6;
pub const JoinType_JOIN_UNIQUE_INNER: JoinType = 7;
pub type JoinType = ::std::os::raw::c_uint;
pub const AggStrategy_AGG_PLAIN: AggStrategy = 0;
pub const AggStrategy_AGG_SORTED: AggStrategy = 1;
pub const AggStrategy_AGG_HASHED: AggStrategy = 2;
pub const AggStrategy_AGG_MIXED: AggStrategy = 3;
pub type AggStrategy = ::std::os::raw::c_uint;
pub const AggSplit_AGGSPLIT_SIMPLE: AggSplit = 0;
pub const AggSplit_AGGSPLIT_INITIAL_SERIAL: AggSplit = 6;
pub const AggSplit_AGGSPLIT_FINAL_DESERIAL: AggSplit = 9;
pub type AggSplit = ::std::os::raw::c_uint;
pub const SetOpCmd_SETOPCMD_INTERSECT: SetOpCmd = 0;
pub const SetOpCmd_SETOPCMD_INTERSECT_ALL: SetOpCmd = 1;
pub const SetOpCmd_SETOPCMD_EXCEPT: SetOpCmd = 2;
pub const SetOpCmd_SETOPCMD_EXCEPT_ALL: SetOpCmd = 3;
pub type SetOpCmd = ::std::os::raw::c_uint;
pub const SetOpStrategy_SETOP_SORTED: SetOpStrategy = 0;
pub const SetOpStrategy_SETOP_HASHED: SetOpStrategy = 1;
pub type SetOpStrategy = ::std::os::raw::c_uint;
pub const OnConflictAction_ONCONFLICT_NONE: OnConflictAction = 0;
pub const OnConflictAction_ONCONFLICT_NOTHING: OnConflictAction = 1;
pub const OnConflictAction_ONCONFLICT_UPDATE: OnConflictAction = 2;
pub type OnConflictAction = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct List {
    pub type_: NodeTag,
    pub length: ::std::os::raw::c_int,
    pub head: *mut ListCell,
    pub tail: *mut ListCell,
}
impl Default for List {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ListCell {
    pub data: ListCell__bindgen_ty_1,
    pub next: *mut ListCell,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ListCell__bindgen_ty_1 {
    pub ptr_value: *mut ::std::os::raw::c_void,
    pub int_value: ::std::os::raw::c_int,
    pub oid_value: Oid,
}
impl Default for ListCell__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for ListCell {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn lappend(arg_list: *mut List, arg_datum: *mut ::std::os::raw::c_void) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lappend(arg_list: *mut List, arg_datum: *mut ::std::os::raw::c_void) -> *mut List;
        }
        lappend(arg_list, arg_datum)
    })
}
pub unsafe fn lappend_int(arg_list: *mut List, arg_datum: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lappend_int(arg_list: *mut List, arg_datum: ::std::os::raw::c_int) -> *mut List;
        }
        lappend_int(arg_list, arg_datum)
    })
}
pub unsafe fn lappend_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lappend_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List;
        }
        lappend_oid(arg_list, arg_datum)
    })
}
pub unsafe fn lappend_cell(
    arg_list: *mut List,
    arg_prev: *mut ListCell,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut ListCell {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lappend_cell(
                arg_list: *mut List,
                arg_prev: *mut ListCell,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut ListCell;
        }
        lappend_cell(arg_list, arg_prev, arg_datum)
    })
}
pub unsafe fn lappend_cell_int(
    arg_list: *mut List,
    arg_prev: *mut ListCell,
    arg_datum: ::std::os::raw::c_int,
) -> *mut ListCell {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lappend_cell_int(
                arg_list: *mut List,
                arg_prev: *mut ListCell,
                arg_datum: ::std::os::raw::c_int,
            ) -> *mut ListCell;
        }
        lappend_cell_int(arg_list, arg_prev, arg_datum)
    })
}
pub unsafe fn lappend_cell_oid(
    arg_list: *mut List,
    arg_prev: *mut ListCell,
    arg_datum: Oid,
) -> *mut ListCell {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lappend_cell_oid(
                arg_list: *mut List,
                arg_prev: *mut ListCell,
                arg_datum: Oid,
            ) -> *mut ListCell;
        }
        lappend_cell_oid(arg_list, arg_prev, arg_datum)
    })
}
pub unsafe fn lcons(arg_datum: *mut ::std::os::raw::c_void, arg_list: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lcons(arg_datum: *mut ::std::os::raw::c_void, arg_list: *mut List) -> *mut List;
        }
        lcons(arg_datum, arg_list)
    })
}
pub unsafe fn lcons_int(arg_datum: ::std::os::raw::c_int, arg_list: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lcons_int(arg_datum: ::std::os::raw::c_int, arg_list: *mut List) -> *mut List;
        }
        lcons_int(arg_datum, arg_list)
    })
}
pub unsafe fn lcons_oid(arg_datum: Oid, arg_list: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lcons_oid(arg_datum: Oid, arg_list: *mut List) -> *mut List;
        }
        lcons_oid(arg_datum, arg_list)
    })
}
pub unsafe fn list_concat(arg_list1: *mut List, arg_list2: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat(arg_list1: *mut List, arg_list2: *mut List) -> *mut List;
        }
        list_concat(arg_list1, arg_list2)
    })
}
pub unsafe fn list_truncate(arg_list: *mut List, arg_new_size: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_truncate(arg_list: *mut List, arg_new_size: ::std::os::raw::c_int)
                -> *mut List;
        }
        list_truncate(arg_list, arg_new_size)
    })
}
pub unsafe fn list_nth_cell(arg_list: *const List, arg_n: ::std::os::raw::c_int) -> *mut ListCell {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_nth_cell(arg_list: *const List, arg_n: ::std::os::raw::c_int) -> *mut ListCell;
        }
        list_nth_cell(arg_list, arg_n)
    })
}
pub unsafe fn list_nth(
    arg_list: *const List,
    arg_n: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_nth(
                arg_list: *const List,
                arg_n: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_void;
        }
        list_nth(arg_list, arg_n)
    })
}
pub unsafe fn list_nth_int(
    arg_list: *const List,
    arg_n: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_nth_int(
                arg_list: *const List,
                arg_n: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        list_nth_int(arg_list, arg_n)
    })
}
pub unsafe fn list_nth_oid(arg_list: *const List, arg_n: ::std::os::raw::c_int) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_nth_oid(arg_list: *const List, arg_n: ::std::os::raw::c_int) -> Oid;
        }
        list_nth_oid(arg_list, arg_n)
    })
}
pub unsafe fn list_member(arg_list: *const List, arg_datum: *const ::std::os::raw::c_void) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_member(arg_list: *const List, arg_datum: *const ::std::os::raw::c_void)
                -> bool;
        }
        list_member(arg_list, arg_datum)
    })
}
pub unsafe fn list_member_ptr(
    arg_list: *const List,
    arg_datum: *const ::std::os::raw::c_void,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_member_ptr(
                arg_list: *const List,
                arg_datum: *const ::std::os::raw::c_void,
            ) -> bool;
        }
        list_member_ptr(arg_list, arg_datum)
    })
}
pub unsafe fn list_member_int(arg_list: *const List, arg_datum: ::std::os::raw::c_int) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_member_int(arg_list: *const List, arg_datum: ::std::os::raw::c_int) -> bool;
        }
        list_member_int(arg_list, arg_datum)
    })
}
pub unsafe fn list_member_oid(arg_list: *const List, arg_datum: Oid) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_member_oid(arg_list: *const List, arg_datum: Oid) -> bool;
        }
        list_member_oid(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete(
    arg_list: *mut List,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete(
                arg_list: *mut List,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut List;
        }
        list_delete(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete_ptr(
    arg_list: *mut List,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_ptr(
                arg_list: *mut List,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut List;
        }
        list_delete_ptr(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete_int(arg_list: *mut List, arg_datum: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_int(arg_list: *mut List, arg_datum: ::std::os::raw::c_int) -> *mut List;
        }
        list_delete_int(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List;
        }
        list_delete_oid(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete_first(arg_list: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_first(arg_list: *mut List) -> *mut List;
        }
        list_delete_first(arg_list)
    })
}
pub unsafe fn list_delete_cell(
    arg_list: *mut List,
    arg_cell: *mut ListCell,
    arg_prev: *mut ListCell,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_cell(
                arg_list: *mut List,
                arg_cell: *mut ListCell,
                arg_prev: *mut ListCell,
            ) -> *mut List;
        }
        list_delete_cell(arg_list, arg_cell, arg_prev)
    })
}
pub unsafe fn list_union(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_union(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_union(arg_list1, arg_list2)
    })
}
pub unsafe fn list_union_ptr(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_union_ptr(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_union_ptr(arg_list1, arg_list2)
    })
}
pub unsafe fn list_union_int(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_union_int(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_union_int(arg_list1, arg_list2)
    })
}
pub unsafe fn list_union_oid(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_union_oid(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_union_oid(arg_list1, arg_list2)
    })
}
pub unsafe fn list_intersection(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_intersection(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_intersection(arg_list1, arg_list2)
    })
}
pub unsafe fn list_intersection_int(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_intersection_int(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_intersection_int(arg_list1, arg_list2)
    })
}
pub unsafe fn list_difference(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_difference(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_difference(arg_list1, arg_list2)
    })
}
pub unsafe fn list_difference_ptr(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_difference_ptr(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_difference_ptr(arg_list1, arg_list2)
    })
}
pub unsafe fn list_difference_int(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_difference_int(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_difference_int(arg_list1, arg_list2)
    })
}
pub unsafe fn list_difference_oid(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_difference_oid(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_difference_oid(arg_list1, arg_list2)
    })
}
pub unsafe fn list_append_unique(
    arg_list: *mut List,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_append_unique(
                arg_list: *mut List,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut List;
        }
        list_append_unique(arg_list, arg_datum)
    })
}
pub unsafe fn list_append_unique_ptr(
    arg_list: *mut List,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_append_unique_ptr(
                arg_list: *mut List,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut List;
        }
        list_append_unique_ptr(arg_list, arg_datum)
    })
}
pub unsafe fn list_append_unique_int(
    arg_list: *mut List,
    arg_datum: ::std::os::raw::c_int,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_append_unique_int(
                arg_list: *mut List,
                arg_datum: ::std::os::raw::c_int,
            ) -> *mut List;
        }
        list_append_unique_int(arg_list, arg_datum)
    })
}
pub unsafe fn list_append_unique_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_append_unique_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List;
        }
        list_append_unique_oid(arg_list, arg_datum)
    })
}
pub unsafe fn list_concat_unique(arg_list1: *mut List, arg_list2: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat_unique(arg_list1: *mut List, arg_list2: *mut List) -> *mut List;
        }
        list_concat_unique(arg_list1, arg_list2)
    })
}
pub unsafe fn list_concat_unique_ptr(arg_list1: *mut List, arg_list2: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat_unique_ptr(arg_list1: *mut List, arg_list2: *mut List) -> *mut List;
        }
        list_concat_unique_ptr(arg_list1, arg_list2)
    })
}
pub unsafe fn list_concat_unique_int(arg_list1: *mut List, arg_list2: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat_unique_int(arg_list1: *mut List, arg_list2: *mut List) -> *mut List;
        }
        list_concat_unique_int(arg_list1, arg_list2)
    })
}
pub unsafe fn list_concat_unique_oid(arg_list1: *mut List, arg_list2: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat_unique_oid(arg_list1: *mut List, arg_list2: *mut List) -> *mut List;
        }
        list_concat_unique_oid(arg_list1, arg_list2)
    })
}
pub unsafe fn list_free(arg_list: *mut List) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_free(arg_list: *mut List);
        }
        list_free(arg_list)
    })
}
pub unsafe fn list_free_deep(arg_list: *mut List) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_free_deep(arg_list: *mut List);
        }
        list_free_deep(arg_list)
    })
}
pub unsafe fn list_copy(arg_list: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_copy(arg_list: *const List) -> *mut List;
        }
        list_copy(arg_list)
    })
}
pub unsafe fn list_copy_tail(arg_list: *const List, arg_nskip: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_copy_tail(arg_list: *const List, arg_nskip: ::std::os::raw::c_int)
                -> *mut List;
        }
        list_copy_tail(arg_list, arg_nskip)
    })
}
pub type list_qsort_comparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub unsafe fn list_qsort(arg_list: *const List, arg_cmp: list_qsort_comparator) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_qsort(arg_list: *const List, arg_cmp: list_qsort_comparator) -> *mut List;
        }
        list_qsort(arg_list, arg_cmp)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AttrDefault {
    pub adnum: AttrNumber,
    pub adbin: *mut ::std::os::raw::c_char,
}
impl Default for AttrDefault {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConstrCheck {
    pub ccname: *mut ::std::os::raw::c_char,
    pub ccbin: *mut ::std::os::raw::c_char,
    pub ccvalid: bool,
    pub ccnoinherit: bool,
}
impl Default for ConstrCheck {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleConstr {
    pub defval: *mut AttrDefault,
    pub check: *mut ConstrCheck,
    pub missing: *mut AttrMissing,
    pub num_defval: uint16,
    pub num_check: uint16,
    pub has_not_null: bool,
    pub has_generated_stored: bool,
}
impl Default for TupleConstr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct TupleDescData {
    pub natts: ::std::os::raw::c_int,
    pub tdtypeid: Oid,
    pub tdtypmod: int32,
    pub tdrefcount: ::std::os::raw::c_int,
    pub constr: *mut TupleConstr,
    pub attrs: __IncompleteArrayField<FormData_pg_attribute>,
}
impl Default for TupleDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleDesc = *mut TupleDescData;
pub unsafe fn CreateTemplateTupleDesc(arg_natts: ::std::os::raw::c_int) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateTemplateTupleDesc(arg_natts: ::std::os::raw::c_int) -> TupleDesc;
        }
        CreateTemplateTupleDesc(arg_natts)
    })
}
pub unsafe fn CreateTupleDesc(
    arg_natts: ::std::os::raw::c_int,
    arg_attrs: *mut Form_pg_attribute,
) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateTupleDesc(
                arg_natts: ::std::os::raw::c_int,
                arg_attrs: *mut Form_pg_attribute,
            ) -> TupleDesc;
        }
        CreateTupleDesc(arg_natts, arg_attrs)
    })
}
pub unsafe fn CreateTupleDescCopy(arg_tupdesc: TupleDesc) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateTupleDescCopy(arg_tupdesc: TupleDesc) -> TupleDesc;
        }
        CreateTupleDescCopy(arg_tupdesc)
    })
}
pub unsafe fn CreateTupleDescCopyConstr(arg_tupdesc: TupleDesc) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateTupleDescCopyConstr(arg_tupdesc: TupleDesc) -> TupleDesc;
        }
        CreateTupleDescCopyConstr(arg_tupdesc)
    })
}
pub unsafe fn TupleDescCopy(arg_dst: TupleDesc, arg_src: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescCopy(arg_dst: TupleDesc, arg_src: TupleDesc);
        }
        TupleDescCopy(arg_dst, arg_src)
    })
}
pub unsafe fn TupleDescCopyEntry(
    arg_dst: TupleDesc,
    arg_dstAttno: AttrNumber,
    arg_src: TupleDesc,
    arg_srcAttno: AttrNumber,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescCopyEntry(
                arg_dst: TupleDesc,
                arg_dstAttno: AttrNumber,
                arg_src: TupleDesc,
                arg_srcAttno: AttrNumber,
            );
        }
        TupleDescCopyEntry(arg_dst, arg_dstAttno, arg_src, arg_srcAttno)
    })
}
pub unsafe fn FreeTupleDesc(arg_tupdesc: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeTupleDesc(arg_tupdesc: TupleDesc);
        }
        FreeTupleDesc(arg_tupdesc)
    })
}
pub unsafe fn IncrTupleDescRefCount(arg_tupdesc: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn IncrTupleDescRefCount(arg_tupdesc: TupleDesc);
        }
        IncrTupleDescRefCount(arg_tupdesc)
    })
}
pub unsafe fn DecrTupleDescRefCount(arg_tupdesc: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DecrTupleDescRefCount(arg_tupdesc: TupleDesc);
        }
        DecrTupleDescRefCount(arg_tupdesc)
    })
}
pub unsafe fn equalTupleDescs(arg_tupdesc1: TupleDesc, arg_tupdesc2: TupleDesc) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn equalTupleDescs(arg_tupdesc1: TupleDesc, arg_tupdesc2: TupleDesc) -> bool;
        }
        equalTupleDescs(arg_tupdesc1, arg_tupdesc2)
    })
}
pub unsafe fn hashTupleDesc(arg_tupdesc: TupleDesc) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hashTupleDesc(arg_tupdesc: TupleDesc) -> uint32;
        }
        hashTupleDesc(arg_tupdesc)
    })
}
pub unsafe fn TupleDescInitEntry(
    arg_desc: TupleDesc,
    arg_attributeNumber: AttrNumber,
    arg_attributeName: *const ::std::os::raw::c_char,
    arg_oidtypeid: Oid,
    arg_typmod: int32,
    arg_attdim: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescInitEntry(
                arg_desc: TupleDesc,
                arg_attributeNumber: AttrNumber,
                arg_attributeName: *const ::std::os::raw::c_char,
                arg_oidtypeid: Oid,
                arg_typmod: int32,
                arg_attdim: ::std::os::raw::c_int,
            );
        }
        TupleDescInitEntry(
            arg_desc,
            arg_attributeNumber,
            arg_attributeName,
            arg_oidtypeid,
            arg_typmod,
            arg_attdim,
        )
    })
}
pub unsafe fn TupleDescInitBuiltinEntry(
    arg_desc: TupleDesc,
    arg_attributeNumber: AttrNumber,
    arg_attributeName: *const ::std::os::raw::c_char,
    arg_oidtypeid: Oid,
    arg_typmod: int32,
    arg_attdim: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescInitBuiltinEntry(
                arg_desc: TupleDesc,
                arg_attributeNumber: AttrNumber,
                arg_attributeName: *const ::std::os::raw::c_char,
                arg_oidtypeid: Oid,
                arg_typmod: int32,
                arg_attdim: ::std::os::raw::c_int,
            );
        }
        TupleDescInitBuiltinEntry(
            arg_desc,
            arg_attributeNumber,
            arg_attributeName,
            arg_oidtypeid,
            arg_typmod,
            arg_attdim,
        )
    })
}
pub unsafe fn TupleDescInitEntryCollation(
    arg_desc: TupleDesc,
    arg_attributeNumber: AttrNumber,
    arg_collationid: Oid,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescInitEntryCollation(
                arg_desc: TupleDesc,
                arg_attributeNumber: AttrNumber,
                arg_collationid: Oid,
            );
        }
        TupleDescInitEntryCollation(arg_desc, arg_attributeNumber, arg_collationid)
    })
}
pub unsafe fn BuildDescForRelation(arg_schema: *mut List) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BuildDescForRelation(arg_schema: *mut List) -> TupleDesc;
        }
        BuildDescForRelation(arg_schema)
    })
}
pub unsafe fn BuildDescFromLists(
    arg_names: *mut List,
    arg_types: *mut List,
    arg_typmods: *mut List,
    arg_collations: *mut List,
) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BuildDescFromLists(
                arg_names: *mut List,
                arg_types: *mut List,
                arg_typmods: *mut List,
                arg_collations: *mut List,
            ) -> TupleDesc;
        }
        BuildDescFromLists(arg_names, arg_types, arg_typmods, arg_collations)
    })
}
pub type BlockNumber = uint32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BlockIdData {
    pub bi_hi: uint16,
    pub bi_lo: uint16,
}
pub type BlockId = *mut BlockIdData;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct ItemIdData {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl ItemIdData {
    #[inline]
    pub fn lp_off(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_lp_off(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn lp_flags(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_lp_flags(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn lp_len(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_lp_len(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        lp_off: ::std::os::raw::c_uint,
        lp_flags: ::std::os::raw::c_uint,
        lp_len: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 15u8, {
            let lp_off: u32 = unsafe { ::std::mem::transmute(lp_off) };
            lp_off as u64
        });
        __bindgen_bitfield_unit.set(15usize, 2u8, {
            let lp_flags: u32 = unsafe { ::std::mem::transmute(lp_flags) };
            lp_flags as u64
        });
        __bindgen_bitfield_unit.set(17usize, 15u8, {
            let lp_len: u32 = unsafe { ::std::mem::transmute(lp_len) };
            lp_len as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type ItemId = *mut ItemIdData;
pub type ItemOffset = uint16;
pub type ItemLength = uint16;
pub type OffsetNumber = uint16;
#[repr(C, packed(2))]
#[derive(Debug, Default, Copy, Clone)]
pub struct ItemPointerData {
    pub ip_blkid: BlockIdData,
    pub ip_posid: OffsetNumber,
}
pub type ItemPointer = *mut ItemPointerData;
pub unsafe fn ItemPointerEquals(arg_pointer1: ItemPointer, arg_pointer2: ItemPointer) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ItemPointerEquals(arg_pointer1: ItemPointer, arg_pointer2: ItemPointer) -> bool;
        }
        ItemPointerEquals(arg_pointer1, arg_pointer2)
    })
}
pub unsafe fn ItemPointerCompare(arg_arg1: ItemPointer, arg_arg2: ItemPointer) -> int32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ItemPointerCompare(arg_arg1: ItemPointer, arg_arg2: ItemPointer) -> int32;
        }
        ItemPointerCompare(arg_arg1, arg_arg2)
    })
}
pub type HeapTupleHeader = *mut HeapTupleHeaderData;
pub type MinimalTuple = *mut MinimalTupleData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeapTupleData {
    pub t_len: uint32,
    pub t_self: ItemPointerData,
    pub t_tableOid: Oid,
    pub t_data: HeapTupleHeader,
}
impl Default for HeapTupleData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type HeapTuple = *mut HeapTupleData;
pub unsafe fn HeapTupleHeaderGetCmin(arg_tup: HeapTupleHeader) -> CommandId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn HeapTupleHeaderGetCmin(arg_tup: HeapTupleHeader) -> CommandId;
        }
        HeapTupleHeaderGetCmin(arg_tup)
    })
}
pub unsafe fn HeapTupleHeaderGetCmax(arg_tup: HeapTupleHeader) -> CommandId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn HeapTupleHeaderGetCmax(arg_tup: HeapTupleHeader) -> CommandId;
        }
        HeapTupleHeaderGetCmax(arg_tup)
    })
}
pub unsafe fn HeapTupleHeaderAdjustCmax(
    arg_tup: HeapTupleHeader,
    arg_cmax: *mut CommandId,
    arg_iscombo: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn HeapTupleHeaderAdjustCmax(
                arg_tup: HeapTupleHeader,
                arg_cmax: *mut CommandId,
                arg_iscombo: *mut bool,
            );
        }
        HeapTupleHeaderAdjustCmax(arg_tup, arg_cmax, arg_iscombo)
    })
}
pub unsafe fn HeapTupleGetUpdateXid(arg_tuple: HeapTupleHeader) -> TransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn HeapTupleGetUpdateXid(arg_tuple: HeapTupleHeader) -> TransactionId;
        }
        HeapTupleGetUpdateXid(arg_tuple)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct flock {
    pub l_type: ::std::os::raw::c_short,
    pub l_whence: ::std::os::raw::c_short,
    pub l_start: __off_t,
    pub l_len: __off_t,
    pub l_pid: __pid_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct stat {
    pub st_dev: __dev_t,
    pub st_ino: __ino_t,
    pub st_nlink: __nlink_t,
    pub st_mode: __mode_t,
    pub st_uid: __uid_t,
    pub st_gid: __gid_t,
    pub __pad0: ::std::os::raw::c_int,
    pub st_rdev: __dev_t,
    pub st_size: __off_t,
    pub st_blksize: __blksize_t,
    pub st_blocks: __blkcnt_t,
    pub st_atim: timespec,
    pub st_mtim: timespec,
    pub st_ctim: timespec,
    pub __glibc_reserved: [__syscall_slong_t; 3usize],
}
pub unsafe fn fcntl(
    arg___fd: ::std::os::raw::c_int,
    arg___cmd: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fcntl(
                arg___fd: ::std::os::raw::c_int,
                arg___cmd: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        fcntl(arg___fd, arg___cmd)
    })
}
pub unsafe fn open(
    arg___file: *const ::std::os::raw::c_char,
    arg___oflag: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn open(
                arg___file: *const ::std::os::raw::c_char,
                arg___oflag: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        open(arg___file, arg___oflag)
    })
}
pub unsafe fn openat(
    arg___fd: ::std::os::raw::c_int,
    arg___file: *const ::std::os::raw::c_char,
    arg___oflag: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn openat(
                arg___fd: ::std::os::raw::c_int,
                arg___file: *const ::std::os::raw::c_char,
                arg___oflag: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        openat(arg___fd, arg___file, arg___oflag)
    })
}
pub unsafe fn creat(
    arg___file: *const ::std::os::raw::c_char,
    arg___mode: mode_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn creat(
                arg___file: *const ::std::os::raw::c_char,
                arg___mode: mode_t,
            ) -> ::std::os::raw::c_int;
        }
        creat(arg___file, arg___mode)
    })
}
pub unsafe fn lockf(
    arg___fd: ::std::os::raw::c_int,
    arg___cmd: ::std::os::raw::c_int,
    arg___len: off_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lockf(
                arg___fd: ::std::os::raw::c_int,
                arg___cmd: ::std::os::raw::c_int,
                arg___len: off_t,
            ) -> ::std::os::raw::c_int;
        }
        lockf(arg___fd, arg___cmd, arg___len)
    })
}
pub unsafe fn posix_fadvise(
    arg___fd: ::std::os::raw::c_int,
    arg___offset: off_t,
    arg___len: off_t,
    arg___advise: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn posix_fadvise(
                arg___fd: ::std::os::raw::c_int,
                arg___offset: off_t,
                arg___len: off_t,
                arg___advise: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        posix_fadvise(arg___fd, arg___offset, arg___len, arg___advise)
    })
}
pub unsafe fn posix_fallocate(
    arg___fd: ::std::os::raw::c_int,
    arg___offset: off_t,
    arg___len: off_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn posix_fallocate(
                arg___fd: ::std::os::raw::c_int,
                arg___offset: off_t,
                arg___len: off_t,
            ) -> ::std::os::raw::c_int;
        }
        posix_fallocate(arg___fd, arg___offset, arg___len)
    })
}
pub type XLogRecPtr = uint64;
pub type XLogSegNo = uint64;
pub type TimeLineID = uint32;
pub type RepOriginId = uint16;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct FullTransactionId {
    pub value: uint64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct VariableCacheData {
    pub nextOid: Oid,
    pub oidCount: uint32,
    pub nextFullXid: FullTransactionId,
    pub oldestXid: TransactionId,
    pub xidVacLimit: TransactionId,
    pub xidWarnLimit: TransactionId,
    pub xidStopLimit: TransactionId,
    pub xidWrapLimit: TransactionId,
    pub oldestXidDB: Oid,
    pub oldestCommitTsXid: TransactionId,
    pub newestCommitTsXid: TransactionId,
    pub latestCompletedXid: TransactionId,
    pub oldestClogXid: TransactionId,
}
pub type VariableCache = *mut VariableCacheData;
pub unsafe fn TransactionStartedDuringRecovery() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionStartedDuringRecovery() -> bool;
        }
        TransactionStartedDuringRecovery()
    })
}
extern "C" {
    pub static mut ShmemVariableCache: VariableCache;
}
pub unsafe fn TransactionIdDidCommit(arg_transactionId: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdDidCommit(arg_transactionId: TransactionId) -> bool;
        }
        TransactionIdDidCommit(arg_transactionId)
    })
}
pub unsafe fn TransactionIdDidAbort(arg_transactionId: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdDidAbort(arg_transactionId: TransactionId) -> bool;
        }
        TransactionIdDidAbort(arg_transactionId)
    })
}
pub unsafe fn TransactionIdIsKnownCompleted(arg_transactionId: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdIsKnownCompleted(arg_transactionId: TransactionId) -> bool;
        }
        TransactionIdIsKnownCompleted(arg_transactionId)
    })
}
pub unsafe fn TransactionIdAbort(arg_transactionId: TransactionId) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdAbort(arg_transactionId: TransactionId);
        }
        TransactionIdAbort(arg_transactionId)
    })
}
pub unsafe fn TransactionIdCommitTree(
    arg_xid: TransactionId,
    arg_nxids: ::std::os::raw::c_int,
    arg_xids: *mut TransactionId,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdCommitTree(
                arg_xid: TransactionId,
                arg_nxids: ::std::os::raw::c_int,
                arg_xids: *mut TransactionId,
            );
        }
        TransactionIdCommitTree(arg_xid, arg_nxids, arg_xids)
    })
}
pub unsafe fn TransactionIdAsyncCommitTree(
    arg_xid: TransactionId,
    arg_nxids: ::std::os::raw::c_int,
    arg_xids: *mut TransactionId,
    arg_lsn: XLogRecPtr,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdAsyncCommitTree(
                arg_xid: TransactionId,
                arg_nxids: ::std::os::raw::c_int,
                arg_xids: *mut TransactionId,
                arg_lsn: XLogRecPtr,
            );
        }
        TransactionIdAsyncCommitTree(arg_xid, arg_nxids, arg_xids, arg_lsn)
    })
}
pub unsafe fn TransactionIdAbortTree(
    arg_xid: TransactionId,
    arg_nxids: ::std::os::raw::c_int,
    arg_xids: *mut TransactionId,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdAbortTree(
                arg_xid: TransactionId,
                arg_nxids: ::std::os::raw::c_int,
                arg_xids: *mut TransactionId,
            );
        }
        TransactionIdAbortTree(arg_xid, arg_nxids, arg_xids)
    })
}
pub unsafe fn TransactionIdPrecedes(arg_id1: TransactionId, arg_id2: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdPrecedes(arg_id1: TransactionId, arg_id2: TransactionId) -> bool;
        }
        TransactionIdPrecedes(arg_id1, arg_id2)
    })
}
pub unsafe fn TransactionIdPrecedesOrEquals(
    arg_id1: TransactionId,
    arg_id2: TransactionId,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdPrecedesOrEquals(
                arg_id1: TransactionId,
                arg_id2: TransactionId,
            ) -> bool;
        }
        TransactionIdPrecedesOrEquals(arg_id1, arg_id2)
    })
}
pub unsafe fn TransactionIdFollows(arg_id1: TransactionId, arg_id2: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdFollows(arg_id1: TransactionId, arg_id2: TransactionId) -> bool;
        }
        TransactionIdFollows(arg_id1, arg_id2)
    })
}
pub unsafe fn TransactionIdFollowsOrEquals(arg_id1: TransactionId, arg_id2: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdFollowsOrEquals(arg_id1: TransactionId, arg_id2: TransactionId)
                -> bool;
        }
        TransactionIdFollowsOrEquals(arg_id1, arg_id2)
    })
}
pub unsafe fn TransactionIdLatest(
    arg_mainxid: TransactionId,
    arg_nxids: ::std::os::raw::c_int,
    arg_xids: *const TransactionId,
) -> TransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdLatest(
                arg_mainxid: TransactionId,
                arg_nxids: ::std::os::raw::c_int,
                arg_xids: *const TransactionId,
            ) -> TransactionId;
        }
        TransactionIdLatest(arg_mainxid, arg_nxids, arg_xids)
    })
}
pub unsafe fn TransactionIdGetCommitLSN(arg_xid: TransactionId) -> XLogRecPtr {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdGetCommitLSN(arg_xid: TransactionId) -> XLogRecPtr;
        }
        TransactionIdGetCommitLSN(arg_xid)
    })
}
pub unsafe fn GetNewTransactionId(arg_isSubXact: bool) -> FullTransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetNewTransactionId(arg_isSubXact: bool) -> FullTransactionId;
        }
        GetNewTransactionId(arg_isSubXact)
    })
}
pub unsafe fn AdvanceNextFullTransactionIdPastXid(arg_xid: TransactionId) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AdvanceNextFullTransactionIdPastXid(arg_xid: TransactionId);
        }
        AdvanceNextFullTransactionIdPastXid(arg_xid)
    })
}
pub unsafe fn ReadNextFullTransactionId() -> FullTransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReadNextFullTransactionId() -> FullTransactionId;
        }
        ReadNextFullTransactionId()
    })
}
pub unsafe fn SetTransactionIdLimit(
    arg_oldest_datfrozenxid: TransactionId,
    arg_oldest_datoid: Oid,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SetTransactionIdLimit(
                arg_oldest_datfrozenxid: TransactionId,
                arg_oldest_datoid: Oid,
            );
        }
        SetTransactionIdLimit(arg_oldest_datfrozenxid, arg_oldest_datoid)
    })
}
pub unsafe fn AdvanceOldestClogXid(arg_oldest_datfrozenxid: TransactionId) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AdvanceOldestClogXid(arg_oldest_datfrozenxid: TransactionId);
        }
        AdvanceOldestClogXid(arg_oldest_datfrozenxid)
    })
}
pub unsafe fn ForceTransactionIdLimitUpdate() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ForceTransactionIdLimitUpdate() -> bool;
        }
        ForceTransactionIdLimitUpdate()
    })
}
pub unsafe fn GetNewObjectId() -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetNewObjectId() -> Oid;
        }
        GetNewObjectId()
    })
}
pub type Item = Pointer;
pub type Page = Pointer;
pub type LocationIndex = uint16;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PageXLogRecPtr {
    pub xlogid: uint32,
    pub xrecoff: uint32,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct PageHeaderData {
    pub pd_lsn: PageXLogRecPtr,
    pub pd_checksum: uint16,
    pub pd_flags: uint16,
    pub pd_lower: LocationIndex,
    pub pd_upper: LocationIndex,
    pub pd_special: LocationIndex,
    pub pd_pagesize_version: uint16,
    pub pd_prune_xid: TransactionId,
    pub pd_linp: __IncompleteArrayField<ItemIdData>,
}
pub type PageHeader = *mut PageHeaderData;
pub unsafe fn PageInit(arg_page: Page, arg_pageSize: Size, arg_specialSize: Size) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageInit(arg_page: Page, arg_pageSize: Size, arg_specialSize: Size);
        }
        PageInit(arg_page, arg_pageSize, arg_specialSize)
    })
}
pub unsafe fn PageIsVerified(arg_page: Page, arg_blkno: BlockNumber) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIsVerified(arg_page: Page, arg_blkno: BlockNumber) -> bool;
        }
        PageIsVerified(arg_page, arg_blkno)
    })
}
pub unsafe fn PageIsVerifiedExtended(
    arg_page: Page,
    arg_blkno: BlockNumber,
    arg_flags: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIsVerifiedExtended(
                arg_page: Page,
                arg_blkno: BlockNumber,
                arg_flags: ::std::os::raw::c_int,
            ) -> bool;
        }
        PageIsVerifiedExtended(arg_page, arg_blkno, arg_flags)
    })
}
pub unsafe fn PageAddItemExtended(
    arg_page: Page,
    arg_item: Item,
    arg_size: Size,
    arg_offsetNumber: OffsetNumber,
    arg_flags: ::std::os::raw::c_int,
) -> OffsetNumber {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageAddItemExtended(
                arg_page: Page,
                arg_item: Item,
                arg_size: Size,
                arg_offsetNumber: OffsetNumber,
                arg_flags: ::std::os::raw::c_int,
            ) -> OffsetNumber;
        }
        PageAddItemExtended(arg_page, arg_item, arg_size, arg_offsetNumber, arg_flags)
    })
}
pub unsafe fn PageGetTempPage(arg_page: Page) -> Page {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetTempPage(arg_page: Page) -> Page;
        }
        PageGetTempPage(arg_page)
    })
}
pub unsafe fn PageGetTempPageCopy(arg_page: Page) -> Page {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetTempPageCopy(arg_page: Page) -> Page;
        }
        PageGetTempPageCopy(arg_page)
    })
}
pub unsafe fn PageGetTempPageCopySpecial(arg_page: Page) -> Page {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetTempPageCopySpecial(arg_page: Page) -> Page;
        }
        PageGetTempPageCopySpecial(arg_page)
    })
}
pub unsafe fn PageRestoreTempPage(arg_tempPage: Page, arg_oldPage: Page) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageRestoreTempPage(arg_tempPage: Page, arg_oldPage: Page);
        }
        PageRestoreTempPage(arg_tempPage, arg_oldPage)
    })
}
pub unsafe fn PageRepairFragmentation(arg_page: Page) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageRepairFragmentation(arg_page: Page);
        }
        PageRepairFragmentation(arg_page)
    })
}
pub unsafe fn PageGetFreeSpace(arg_page: Page) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetFreeSpace(arg_page: Page) -> Size;
        }
        PageGetFreeSpace(arg_page)
    })
}
pub unsafe fn PageGetFreeSpaceForMultipleTuples(
    arg_page: Page,
    arg_ntups: ::std::os::raw::c_int,
) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetFreeSpaceForMultipleTuples(
                arg_page: Page,
                arg_ntups: ::std::os::raw::c_int,
            ) -> Size;
        }
        PageGetFreeSpaceForMultipleTuples(arg_page, arg_ntups)
    })
}
pub unsafe fn PageGetExactFreeSpace(arg_page: Page) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetExactFreeSpace(arg_page: Page) -> Size;
        }
        PageGetExactFreeSpace(arg_page)
    })
}
pub unsafe fn PageGetHeapFreeSpace(arg_page: Page) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetHeapFreeSpace(arg_page: Page) -> Size;
        }
        PageGetHeapFreeSpace(arg_page)
    })
}
pub unsafe fn PageIndexTupleDelete(arg_page: Page, arg_offset: OffsetNumber) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIndexTupleDelete(arg_page: Page, arg_offset: OffsetNumber);
        }
        PageIndexTupleDelete(arg_page, arg_offset)
    })
}
pub unsafe fn PageIndexMultiDelete(
    arg_page: Page,
    arg_itemnos: *mut OffsetNumber,
    arg_nitems: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIndexMultiDelete(
                arg_page: Page,
                arg_itemnos: *mut OffsetNumber,
                arg_nitems: ::std::os::raw::c_int,
            );
        }
        PageIndexMultiDelete(arg_page, arg_itemnos, arg_nitems)
    })
}
pub unsafe fn PageIndexTupleDeleteNoCompact(arg_page: Page, arg_offset: OffsetNumber) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIndexTupleDeleteNoCompact(arg_page: Page, arg_offset: OffsetNumber);
        }
        PageIndexTupleDeleteNoCompact(arg_page, arg_offset)
    })
}
pub unsafe fn PageIndexTupleOverwrite(
    arg_page: Page,
    arg_offnum: OffsetNumber,
    arg_newtup: Item,
    arg_newsize: Size,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIndexTupleOverwrite(
                arg_page: Page,
                arg_offnum: OffsetNumber,
                arg_newtup: Item,
                arg_newsize: Size,
            ) -> bool;
        }
        PageIndexTupleOverwrite(arg_page, arg_offnum, arg_newtup, arg_newsize)
    })
}
pub unsafe fn PageSetChecksumCopy(
    arg_page: Page,
    arg_blkno: BlockNumber,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageSetChecksumCopy(
                arg_page: Page,
                arg_blkno: BlockNumber,
            ) -> *mut ::std::os::raw::c_char;
        }
        PageSetChecksumCopy(arg_page, arg_blkno)
    })
}
pub unsafe fn PageSetChecksumInplace(arg_page: Page, arg_blkno: BlockNumber) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageSetChecksumInplace(arg_page: Page, arg_blkno: BlockNumber);
        }
        PageSetChecksumInplace(arg_page, arg_blkno)
    })
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct HeapTupleFields {
    pub t_xmin: TransactionId,
    pub t_xmax: TransactionId,
    pub t_field3: HeapTupleFields__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union HeapTupleFields__bindgen_ty_1 {
    pub t_cid: CommandId,
    pub t_xvac: TransactionId,
}
impl Default for HeapTupleFields__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for HeapTupleFields {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct DatumTupleFields {
    pub datum_len_: int32,
    pub datum_typmod: int32,
    pub datum_typeid: Oid,
}
#[repr(C)]
pub struct HeapTupleHeaderData {
    pub t_choice: HeapTupleHeaderData__bindgen_ty_1,
    pub t_ctid: ItemPointerData,
    pub t_infomask2: uint16,
    pub t_infomask: uint16,
    pub t_hoff: uint8,
    pub t_bits: __IncompleteArrayField<bits8>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union HeapTupleHeaderData__bindgen_ty_1 {
    pub t_heap: HeapTupleFields,
    pub t_datum: DatumTupleFields,
}
impl Default for HeapTupleHeaderData__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for HeapTupleHeaderData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct MinimalTupleData {
    pub t_len: uint32,
    pub mt_padding: [::std::os::raw::c_char; 6usize],
    pub t_infomask2: uint16,
    pub t_infomask: uint16,
    pub t_hoff: uint8,
    pub t_bits: __IncompleteArrayField<bits8>,
}
pub unsafe fn heap_compute_data_size(
    arg_tupleDesc: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_compute_data_size(
                arg_tupleDesc: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            ) -> Size;
        }
        heap_compute_data_size(arg_tupleDesc, arg_values, arg_isnull)
    })
}
pub unsafe fn heap_fill_tuple(
    arg_tupleDesc: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
    arg_data: *mut ::std::os::raw::c_char,
    arg_data_size: Size,
    arg_infomask: *mut uint16,
    arg_bit: *mut bits8,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_fill_tuple(
                arg_tupleDesc: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
                arg_data: *mut ::std::os::raw::c_char,
                arg_data_size: Size,
                arg_infomask: *mut uint16,
                arg_bit: *mut bits8,
            );
        }
        heap_fill_tuple(
            arg_tupleDesc,
            arg_values,
            arg_isnull,
            arg_data,
            arg_data_size,
            arg_infomask,
            arg_bit,
        )
    })
}
pub unsafe fn heap_attisnull(
    arg_tup: HeapTuple,
    arg_attnum: ::std::os::raw::c_int,
    arg_tupleDesc: TupleDesc,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_attisnull(
                arg_tup: HeapTuple,
                arg_attnum: ::std::os::raw::c_int,
                arg_tupleDesc: TupleDesc,
            ) -> bool;
        }
        heap_attisnull(arg_tup, arg_attnum, arg_tupleDesc)
    })
}
pub unsafe fn nocachegetattr(
    arg_tup: HeapTuple,
    arg_attnum: ::std::os::raw::c_int,
    arg_att: TupleDesc,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nocachegetattr(
                arg_tup: HeapTuple,
                arg_attnum: ::std::os::raw::c_int,
                arg_att: TupleDesc,
            ) -> Datum;
        }
        nocachegetattr(arg_tup, arg_attnum, arg_att)
    })
}
pub unsafe fn heap_getsysattr(
    arg_tup: HeapTuple,
    arg_attnum: ::std::os::raw::c_int,
    arg_tupleDesc: TupleDesc,
    arg_isnull: *mut bool,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_getsysattr(
                arg_tup: HeapTuple,
                arg_attnum: ::std::os::raw::c_int,
                arg_tupleDesc: TupleDesc,
                arg_isnull: *mut bool,
            ) -> Datum;
        }
        heap_getsysattr(arg_tup, arg_attnum, arg_tupleDesc, arg_isnull)
    })
}
pub unsafe fn getmissingattr(
    arg_tupleDesc: TupleDesc,
    arg_attnum: ::std::os::raw::c_int,
    arg_isnull: *mut bool,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getmissingattr(
                arg_tupleDesc: TupleDesc,
                arg_attnum: ::std::os::raw::c_int,
                arg_isnull: *mut bool,
            ) -> Datum;
        }
        getmissingattr(arg_tupleDesc, arg_attnum, arg_isnull)
    })
}
pub unsafe fn heap_copytuple(arg_tuple: HeapTuple) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_copytuple(arg_tuple: HeapTuple) -> HeapTuple;
        }
        heap_copytuple(arg_tuple)
    })
}
pub unsafe fn heap_copytuple_with_tuple(arg_src: HeapTuple, arg_dest: HeapTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_copytuple_with_tuple(arg_src: HeapTuple, arg_dest: HeapTuple);
        }
        heap_copytuple_with_tuple(arg_src, arg_dest)
    })
}
pub unsafe fn heap_copy_tuple_as_datum(arg_tuple: HeapTuple, arg_tupleDesc: TupleDesc) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_copy_tuple_as_datum(arg_tuple: HeapTuple, arg_tupleDesc: TupleDesc) -> Datum;
        }
        heap_copy_tuple_as_datum(arg_tuple, arg_tupleDesc)
    })
}
pub unsafe fn heap_form_tuple(
    arg_tupleDescriptor: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_form_tuple(
                arg_tupleDescriptor: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            ) -> HeapTuple;
        }
        heap_form_tuple(arg_tupleDescriptor, arg_values, arg_isnull)
    })
}
pub unsafe fn heap_modify_tuple(
    arg_tuple: HeapTuple,
    arg_tupleDesc: TupleDesc,
    arg_replValues: *mut Datum,
    arg_replIsnull: *mut bool,
    arg_doReplace: *mut bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_modify_tuple(
                arg_tuple: HeapTuple,
                arg_tupleDesc: TupleDesc,
                arg_replValues: *mut Datum,
                arg_replIsnull: *mut bool,
                arg_doReplace: *mut bool,
            ) -> HeapTuple;
        }
        heap_modify_tuple(
            arg_tuple,
            arg_tupleDesc,
            arg_replValues,
            arg_replIsnull,
            arg_doReplace,
        )
    })
}
pub unsafe fn heap_modify_tuple_by_cols(
    arg_tuple: HeapTuple,
    arg_tupleDesc: TupleDesc,
    arg_nCols: ::std::os::raw::c_int,
    arg_replCols: *mut ::std::os::raw::c_int,
    arg_replValues: *mut Datum,
    arg_replIsnull: *mut bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_modify_tuple_by_cols(
                arg_tuple: HeapTuple,
                arg_tupleDesc: TupleDesc,
                arg_nCols: ::std::os::raw::c_int,
                arg_replCols: *mut ::std::os::raw::c_int,
                arg_replValues: *mut Datum,
                arg_replIsnull: *mut bool,
            ) -> HeapTuple;
        }
        heap_modify_tuple_by_cols(
            arg_tuple,
            arg_tupleDesc,
            arg_nCols,
            arg_replCols,
            arg_replValues,
            arg_replIsnull,
        )
    })
}
pub unsafe fn heap_deform_tuple(
    arg_tuple: HeapTuple,
    arg_tupleDesc: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_deform_tuple(
                arg_tuple: HeapTuple,
                arg_tupleDesc: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            );
        }
        heap_deform_tuple(arg_tuple, arg_tupleDesc, arg_values, arg_isnull)
    })
}
pub unsafe fn heap_freetuple(arg_htup: HeapTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_freetuple(arg_htup: HeapTuple);
        }
        heap_freetuple(arg_htup)
    })
}
pub unsafe fn heap_form_minimal_tuple(
    arg_tupleDescriptor: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_form_minimal_tuple(
                arg_tupleDescriptor: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            ) -> MinimalTuple;
        }
        heap_form_minimal_tuple(arg_tupleDescriptor, arg_values, arg_isnull)
    })
}
pub unsafe fn heap_free_minimal_tuple(arg_mtup: MinimalTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_free_minimal_tuple(arg_mtup: MinimalTuple);
        }
        heap_free_minimal_tuple(arg_mtup)
    })
}
pub unsafe fn heap_copy_minimal_tuple(arg_mtup: MinimalTuple) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_copy_minimal_tuple(arg_mtup: MinimalTuple) -> MinimalTuple;
        }
        heap_copy_minimal_tuple(arg_mtup)
    })
}
pub unsafe fn heap_tuple_from_minimal_tuple(arg_mtup: MinimalTuple) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_tuple_from_minimal_tuple(arg_mtup: MinimalTuple) -> HeapTuple;
        }
        heap_tuple_from_minimal_tuple(arg_mtup)
    })
}
pub unsafe fn minimal_tuple_from_heap_tuple(arg_htup: HeapTuple) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn minimal_tuple_from_heap_tuple(arg_htup: HeapTuple) -> MinimalTuple;
        }
        minimal_tuple_from_heap_tuple(arg_htup)
    })
}
pub unsafe fn heap_expand_tuple(arg_sourceTuple: HeapTuple, arg_tupleDesc: TupleDesc) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_expand_tuple(arg_sourceTuple: HeapTuple, arg_tupleDesc: TupleDesc)
                -> HeapTuple;
        }
        heap_expand_tuple(arg_sourceTuple, arg_tupleDesc)
    })
}
pub unsafe fn minimal_expand_tuple(
    arg_sourceTuple: HeapTuple,
    arg_tupleDesc: TupleDesc,
) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn minimal_expand_tuple(
                arg_sourceTuple: HeapTuple,
                arg_tupleDesc: TupleDesc,
            ) -> MinimalTuple;
        }
        minimal_expand_tuple(arg_sourceTuple, arg_tupleDesc)
    })
}
pub type Buffer = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BufferAccessStrategyData {
    _unused: [u8; 0],
}
pub type BufferAccessStrategy = *mut BufferAccessStrategyData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleTableSlot {
    pub type_: NodeTag,
    pub tts_flags: uint16,
    pub tts_nvalid: AttrNumber,
    pub tts_ops: *const TupleTableSlotOps,
    pub tts_tupleDescriptor: TupleDesc,
    pub tts_values: *mut Datum,
    pub tts_isnull: *mut bool,
    pub tts_mcxt: MemoryContext,
    pub tts_tid: ItemPointerData,
    pub tts_tableOid: Oid,
}
impl Default for TupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TupleTableSlotOps {
    pub base_slot_size: usize,
    pub init: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub release: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub clear: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub getsomeattrs: ::std::option::Option<
        unsafe extern "C" fn(slot: *mut TupleTableSlot, natts: ::std::os::raw::c_int),
    >,
    pub getsysattr: ::std::option::Option<
        unsafe extern "C" fn(
            slot: *mut TupleTableSlot,
            attnum: ::std::os::raw::c_int,
            isnull: *mut bool,
        ) -> Datum,
    >,
    pub materialize: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub copyslot: ::std::option::Option<
        unsafe extern "C" fn(dstslot: *mut TupleTableSlot, srcslot: *mut TupleTableSlot),
    >,
    pub get_heap_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> HeapTuple>,
    pub get_minimal_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> MinimalTuple>,
    pub copy_heap_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> HeapTuple>,
    pub copy_minimal_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> MinimalTuple>,
}
extern "C" {
    pub static TTSOpsVirtual: TupleTableSlotOps;
}
extern "C" {
    pub static TTSOpsHeapTuple: TupleTableSlotOps;
}
extern "C" {
    pub static TTSOpsMinimalTuple: TupleTableSlotOps;
}
extern "C" {
    pub static TTSOpsBufferHeapTuple: TupleTableSlotOps;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VirtualTupleTableSlot {
    pub base: TupleTableSlot,
    pub data: *mut ::std::os::raw::c_char,
}
impl Default for VirtualTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeapTupleTableSlot {
    pub base: TupleTableSlot,
    pub tuple: HeapTuple,
    pub off: uint32,
    pub tupdata: HeapTupleData,
}
impl Default for HeapTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BufferHeapTupleTableSlot {
    pub base: HeapTupleTableSlot,
    pub buffer: Buffer,
}
impl Default for BufferHeapTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MinimalTupleTableSlot {
    pub base: TupleTableSlot,
    pub tuple: HeapTuple,
    pub mintuple: MinimalTuple,
    pub minhdr: HeapTupleData,
    pub off: uint32,
}
impl Default for MinimalTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn MakeTupleTableSlot(
    arg_tupleDesc: TupleDesc,
    arg_tts_ops: *const TupleTableSlotOps,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MakeTupleTableSlot(
                arg_tupleDesc: TupleDesc,
                arg_tts_ops: *const TupleTableSlotOps,
            ) -> *mut TupleTableSlot;
        }
        MakeTupleTableSlot(arg_tupleDesc, arg_tts_ops)
    })
}
pub unsafe fn ExecAllocTableSlot(
    arg_tupleTable: *mut *mut List,
    arg_desc: TupleDesc,
    arg_tts_ops: *const TupleTableSlotOps,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecAllocTableSlot(
                arg_tupleTable: *mut *mut List,
                arg_desc: TupleDesc,
                arg_tts_ops: *const TupleTableSlotOps,
            ) -> *mut TupleTableSlot;
        }
        ExecAllocTableSlot(arg_tupleTable, arg_desc, arg_tts_ops)
    })
}
pub unsafe fn ExecResetTupleTable(arg_tupleTable: *mut List, arg_shouldFree: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecResetTupleTable(arg_tupleTable: *mut List, arg_shouldFree: bool);
        }
        ExecResetTupleTable(arg_tupleTable, arg_shouldFree)
    })
}
pub unsafe fn MakeSingleTupleTableSlot(
    arg_tupdesc: TupleDesc,
    arg_tts_ops: *const TupleTableSlotOps,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MakeSingleTupleTableSlot(
                arg_tupdesc: TupleDesc,
                arg_tts_ops: *const TupleTableSlotOps,
            ) -> *mut TupleTableSlot;
        }
        MakeSingleTupleTableSlot(arg_tupdesc, arg_tts_ops)
    })
}
pub unsafe fn ExecDropSingleTupleTableSlot(arg_slot: *mut TupleTableSlot) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecDropSingleTupleTableSlot(arg_slot: *mut TupleTableSlot);
        }
        ExecDropSingleTupleTableSlot(arg_slot)
    })
}
pub unsafe fn ExecSetSlotDescriptor(arg_slot: *mut TupleTableSlot, arg_tupdesc: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecSetSlotDescriptor(arg_slot: *mut TupleTableSlot, arg_tupdesc: TupleDesc);
        }
        ExecSetSlotDescriptor(arg_slot, arg_tupdesc)
    })
}
pub unsafe fn ExecStoreHeapTuple(
    arg_tuple: HeapTuple,
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: bool,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreHeapTuple(
                arg_tuple: HeapTuple,
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: bool,
            ) -> *mut TupleTableSlot;
        }
        ExecStoreHeapTuple(arg_tuple, arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecForceStoreHeapTuple(
    arg_tuple: HeapTuple,
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecForceStoreHeapTuple(
                arg_tuple: HeapTuple,
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: bool,
            );
        }
        ExecForceStoreHeapTuple(arg_tuple, arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecStoreBufferHeapTuple(
    arg_tuple: HeapTuple,
    arg_slot: *mut TupleTableSlot,
    arg_buffer: Buffer,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreBufferHeapTuple(
                arg_tuple: HeapTuple,
                arg_slot: *mut TupleTableSlot,
                arg_buffer: Buffer,
            ) -> *mut TupleTableSlot;
        }
        ExecStoreBufferHeapTuple(arg_tuple, arg_slot, arg_buffer)
    })
}
pub unsafe fn ExecStorePinnedBufferHeapTuple(
    arg_tuple: HeapTuple,
    arg_slot: *mut TupleTableSlot,
    arg_buffer: Buffer,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStorePinnedBufferHeapTuple(
                arg_tuple: HeapTuple,
                arg_slot: *mut TupleTableSlot,
                arg_buffer: Buffer,
            ) -> *mut TupleTableSlot;
        }
        ExecStorePinnedBufferHeapTuple(arg_tuple, arg_slot, arg_buffer)
    })
}
pub unsafe fn ExecStoreMinimalTuple(
    arg_mtup: MinimalTuple,
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: bool,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreMinimalTuple(
                arg_mtup: MinimalTuple,
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: bool,
            ) -> *mut TupleTableSlot;
        }
        ExecStoreMinimalTuple(arg_mtup, arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecForceStoreMinimalTuple(
    arg_mtup: MinimalTuple,
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecForceStoreMinimalTuple(
                arg_mtup: MinimalTuple,
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: bool,
            );
        }
        ExecForceStoreMinimalTuple(arg_mtup, arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecStoreVirtualTuple(arg_slot: *mut TupleTableSlot) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreVirtualTuple(arg_slot: *mut TupleTableSlot) -> *mut TupleTableSlot;
        }
        ExecStoreVirtualTuple(arg_slot)
    })
}
pub unsafe fn ExecStoreAllNullTuple(arg_slot: *mut TupleTableSlot) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreAllNullTuple(arg_slot: *mut TupleTableSlot) -> *mut TupleTableSlot;
        }
        ExecStoreAllNullTuple(arg_slot)
    })
}
pub unsafe fn ExecStoreHeapTupleDatum(arg_data: Datum, arg_slot: *mut TupleTableSlot) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreHeapTupleDatum(arg_data: Datum, arg_slot: *mut TupleTableSlot);
        }
        ExecStoreHeapTupleDatum(arg_data, arg_slot)
    })
}
pub unsafe fn ExecFetchSlotHeapTuple(
    arg_slot: *mut TupleTableSlot,
    arg_materialize: bool,
    arg_shouldFree: *mut bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecFetchSlotHeapTuple(
                arg_slot: *mut TupleTableSlot,
                arg_materialize: bool,
                arg_shouldFree: *mut bool,
            ) -> HeapTuple;
        }
        ExecFetchSlotHeapTuple(arg_slot, arg_materialize, arg_shouldFree)
    })
}
pub unsafe fn ExecFetchSlotMinimalTuple(
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: *mut bool,
) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecFetchSlotMinimalTuple(
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: *mut bool,
            ) -> MinimalTuple;
        }
        ExecFetchSlotMinimalTuple(arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecFetchSlotHeapTupleDatum(arg_slot: *mut TupleTableSlot) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecFetchSlotHeapTupleDatum(arg_slot: *mut TupleTableSlot) -> Datum;
        }
        ExecFetchSlotHeapTupleDatum(arg_slot)
    })
}
pub unsafe fn slot_getmissingattrs(
    arg_slot: *mut TupleTableSlot,
    arg_startAttNum: ::std::os::raw::c_int,
    arg_lastAttNum: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn slot_getmissingattrs(
                arg_slot: *mut TupleTableSlot,
                arg_startAttNum: ::std::os::raw::c_int,
                arg_lastAttNum: ::std::os::raw::c_int,
            );
        }
        slot_getmissingattrs(arg_slot, arg_startAttNum, arg_lastAttNum)
    })
}
pub unsafe fn slot_getsomeattrs_int(
    arg_slot: *mut TupleTableSlot,
    arg_attnum: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn slot_getsomeattrs_int(
                arg_slot: *mut TupleTableSlot,
                arg_attnum: ::std::os::raw::c_int,
            );
        }
        slot_getsomeattrs_int(arg_slot, arg_attnum)
    })
}
pub type bitmapword = uint64;
pub type signedbitmapword = int64;
#[repr(C)]
#[derive(Debug, Default)]
pub struct Bitmapset {
    pub nwords: ::std::os::raw::c_int,
    pub words: __IncompleteArrayField<bitmapword>,
}
pub const BMS_Comparison_BMS_EQUAL: BMS_Comparison = 0;
pub const BMS_Comparison_BMS_SUBSET1: BMS_Comparison = 1;
pub const BMS_Comparison_BMS_SUBSET2: BMS_Comparison = 2;
pub const BMS_Comparison_BMS_DIFFERENT: BMS_Comparison = 3;
pub type BMS_Comparison = ::std::os::raw::c_uint;
pub const BMS_Membership_BMS_EMPTY_SET: BMS_Membership = 0;
pub const BMS_Membership_BMS_SINGLETON: BMS_Membership = 1;
pub const BMS_Membership_BMS_MULTIPLE: BMS_Membership = 2;
pub type BMS_Membership = ::std::os::raw::c_uint;
pub unsafe fn bms_copy(arg_a: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_copy(arg_a: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_copy(arg_a)
    })
}
pub unsafe fn bms_equal(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_equal(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool;
        }
        bms_equal(arg_a, arg_b)
    })
}
pub unsafe fn bms_compare(
    arg_a: *const Bitmapset,
    arg_b: *const Bitmapset,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_compare(
                arg_a: *const Bitmapset,
                arg_b: *const Bitmapset,
            ) -> ::std::os::raw::c_int;
        }
        bms_compare(arg_a, arg_b)
    })
}
pub unsafe fn bms_make_singleton(arg_x: ::std::os::raw::c_int) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_make_singleton(arg_x: ::std::os::raw::c_int) -> *mut Bitmapset;
        }
        bms_make_singleton(arg_x)
    })
}
pub unsafe fn bms_free(arg_a: *mut Bitmapset) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_free(arg_a: *mut Bitmapset);
        }
        bms_free(arg_a)
    })
}
pub unsafe fn bms_union(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_union(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_union(arg_a, arg_b)
    })
}
pub unsafe fn bms_intersect(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_intersect(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_intersect(arg_a, arg_b)
    })
}
pub unsafe fn bms_difference(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_difference(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_difference(arg_a, arg_b)
    })
}
pub unsafe fn bms_is_subset(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_is_subset(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool;
        }
        bms_is_subset(arg_a, arg_b)
    })
}
pub unsafe fn bms_subset_compare(
    arg_a: *const Bitmapset,
    arg_b: *const Bitmapset,
) -> BMS_Comparison {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_subset_compare(
                arg_a: *const Bitmapset,
                arg_b: *const Bitmapset,
            ) -> BMS_Comparison;
        }
        bms_subset_compare(arg_a, arg_b)
    })
}
pub unsafe fn bms_is_member(arg_x: ::std::os::raw::c_int, arg_a: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_is_member(arg_x: ::std::os::raw::c_int, arg_a: *const Bitmapset) -> bool;
        }
        bms_is_member(arg_x, arg_a)
    })
}
pub unsafe fn bms_member_index(
    arg_a: *mut Bitmapset,
    arg_x: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_member_index(
                arg_a: *mut Bitmapset,
                arg_x: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        bms_member_index(arg_a, arg_x)
    })
}
pub unsafe fn bms_overlap(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_overlap(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool;
        }
        bms_overlap(arg_a, arg_b)
    })
}
pub unsafe fn bms_overlap_list(arg_a: *const Bitmapset, arg_b: *const List) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_overlap_list(arg_a: *const Bitmapset, arg_b: *const List) -> bool;
        }
        bms_overlap_list(arg_a, arg_b)
    })
}
pub unsafe fn bms_nonempty_difference(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_nonempty_difference(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool;
        }
        bms_nonempty_difference(arg_a, arg_b)
    })
}
pub unsafe fn bms_singleton_member(arg_a: *const Bitmapset) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_singleton_member(arg_a: *const Bitmapset) -> ::std::os::raw::c_int;
        }
        bms_singleton_member(arg_a)
    })
}
pub unsafe fn bms_get_singleton_member(
    arg_a: *const Bitmapset,
    arg_member: *mut ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_get_singleton_member(
                arg_a: *const Bitmapset,
                arg_member: *mut ::std::os::raw::c_int,
            ) -> bool;
        }
        bms_get_singleton_member(arg_a, arg_member)
    })
}
pub unsafe fn bms_num_members(arg_a: *const Bitmapset) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_num_members(arg_a: *const Bitmapset) -> ::std::os::raw::c_int;
        }
        bms_num_members(arg_a)
    })
}
pub unsafe fn bms_membership(arg_a: *const Bitmapset) -> BMS_Membership {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_membership(arg_a: *const Bitmapset) -> BMS_Membership;
        }
        bms_membership(arg_a)
    })
}
pub unsafe fn bms_is_empty(arg_a: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_is_empty(arg_a: *const Bitmapset) -> bool;
        }
        bms_is_empty(arg_a)
    })
}
pub unsafe fn bms_add_member(
    arg_a: *mut Bitmapset,
    arg_x: ::std::os::raw::c_int,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_add_member(
                arg_a: *mut Bitmapset,
                arg_x: ::std::os::raw::c_int,
            ) -> *mut Bitmapset;
        }
        bms_add_member(arg_a, arg_x)
    })
}
pub unsafe fn bms_del_member(
    arg_a: *mut Bitmapset,
    arg_x: ::std::os::raw::c_int,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_del_member(
                arg_a: *mut Bitmapset,
                arg_x: ::std::os::raw::c_int,
            ) -> *mut Bitmapset;
        }
        bms_del_member(arg_a, arg_x)
    })
}
pub unsafe fn bms_add_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_add_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_add_members(arg_a, arg_b)
    })
}
pub unsafe fn bms_add_range(
    arg_a: *mut Bitmapset,
    arg_lower: ::std::os::raw::c_int,
    arg_upper: ::std::os::raw::c_int,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_add_range(
                arg_a: *mut Bitmapset,
                arg_lower: ::std::os::raw::c_int,
                arg_upper: ::std::os::raw::c_int,
            ) -> *mut Bitmapset;
        }
        bms_add_range(arg_a, arg_lower, arg_upper)
    })
}
pub unsafe fn bms_int_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_int_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_int_members(arg_a, arg_b)
    })
}
pub unsafe fn bms_del_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_del_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_del_members(arg_a, arg_b)
    })
}
pub unsafe fn bms_join(arg_a: *mut Bitmapset, arg_b: *mut Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_join(arg_a: *mut Bitmapset, arg_b: *mut Bitmapset) -> *mut Bitmapset;
        }
        bms_join(arg_a, arg_b)
    })
}
pub unsafe fn bms_first_member(arg_a: *mut Bitmapset) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_first_member(arg_a: *mut Bitmapset) -> ::std::os::raw::c_int;
        }
        bms_first_member(arg_a)
    })
}
pub unsafe fn bms_next_member(
    arg_a: *const Bitmapset,
    arg_prevbit: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_next_member(
                arg_a: *const Bitmapset,
                arg_prevbit: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        bms_next_member(arg_a, arg_prevbit)
    })
}
pub unsafe fn bms_prev_member(
    arg_a: *const Bitmapset,
    arg_prevbit: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_prev_member(
                arg_a: *const Bitmapset,
                arg_prevbit: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        bms_prev_member(arg_a, arg_prevbit)
    })
}
pub unsafe fn bms_hash_value(arg_a: *const Bitmapset) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_hash_value(arg_a: *const Bitmapset) -> uint32;
        }
        bms_hash_value(arg_a)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleConversionMap {
    pub indesc: TupleDesc,
    pub outdesc: TupleDesc,
    pub attrMap: *mut AttrNumber,
    pub invalues: *mut Datum,
    pub inisnull: *mut bool,
    pub outvalues: *mut Datum,
    pub outisnull: *mut bool,
}
impl Default for TupleConversionMap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn convert_tuples_by_position(
    arg_indesc: TupleDesc,
    arg_outdesc: TupleDesc,
    arg_msg: *const ::std::os::raw::c_char,
) -> *mut TupleConversionMap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn convert_tuples_by_position(
                arg_indesc: TupleDesc,
                arg_outdesc: TupleDesc,
                arg_msg: *const ::std::os::raw::c_char,
            ) -> *mut TupleConversionMap;
        }
        convert_tuples_by_position(arg_indesc, arg_outdesc, arg_msg)
    })
}
pub unsafe fn convert_tuples_by_name(
    arg_indesc: TupleDesc,
    arg_outdesc: TupleDesc,
    arg_msg: *const ::std::os::raw::c_char,
) -> *mut TupleConversionMap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn convert_tuples_by_name(
                arg_indesc: TupleDesc,
                arg_outdesc: TupleDesc,
                arg_msg: *const ::std::os::raw::c_char,
            ) -> *mut TupleConversionMap;
        }
        convert_tuples_by_name(arg_indesc, arg_outdesc, arg_msg)
    })
}
pub unsafe fn convert_tuples_by_name_map(
    arg_indesc: TupleDesc,
    arg_outdesc: TupleDesc,
    arg_msg: *const ::std::os::raw::c_char,
) -> *mut AttrNumber {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn convert_tuples_by_name_map(
                arg_indesc: TupleDesc,
                arg_outdesc: TupleDesc,
                arg_msg: *const ::std::os::raw::c_char,
            ) -> *mut AttrNumber;
        }
        convert_tuples_by_name_map(arg_indesc, arg_outdesc, arg_msg)
    })
}
pub unsafe fn convert_tuples_by_name_map_if_req(
    arg_indesc: TupleDesc,
    arg_outdesc: TupleDesc,
    arg_msg: *const ::std::os::raw::c_char,
) -> *mut AttrNumber {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn convert_tuples_by_name_map_if_req(
                arg_indesc: TupleDesc,
                arg_outdesc: TupleDesc,
                arg_msg: *const ::std::os::raw::c_char,
            ) -> *mut AttrNumber;
        }
        convert_tuples_by_name_map_if_req(arg_indesc, arg_outdesc, arg_msg)
    })
}
pub unsafe fn execute_attr_map_tuple(
    arg_tuple: HeapTuple,
    arg_map: *mut TupleConversionMap,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn execute_attr_map_tuple(
                arg_tuple: HeapTuple,
                arg_map: *mut TupleConversionMap,
            ) -> HeapTuple;
        }
        execute_attr_map_tuple(arg_tuple, arg_map)
    })
}
pub unsafe fn execute_attr_map_slot(
    arg_attrMap: *mut AttrNumber,
    arg_in_slot: *mut TupleTableSlot,
    arg_out_slot: *mut TupleTableSlot,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn execute_attr_map_slot(
                arg_attrMap: *mut AttrNumber,
                arg_in_slot: *mut TupleTableSlot,
                arg_out_slot: *mut TupleTableSlot,
            ) -> *mut TupleTableSlot;
        }
        execute_attr_map_slot(arg_attrMap, arg_in_slot, arg_out_slot)
    })
}
pub unsafe fn execute_attr_map_cols(
    arg_inbitmap: *mut Bitmapset,
    arg_map: *mut TupleConversionMap,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn execute_attr_map_cols(
                arg_inbitmap: *mut Bitmapset,
                arg_map: *mut TupleConversionMap,
            ) -> *mut Bitmapset;
        }
        execute_attr_map_cols(arg_inbitmap, arg_map)
    })
}
pub unsafe fn free_conversion_map(arg_map: *mut TupleConversionMap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn free_conversion_map(arg_map: *mut TupleConversionMap);
        }
        free_conversion_map(arg_map)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *const ::std::os::raw::c_char,
}
impl Default for tm {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct itimerspec {
    pub it_interval: timespec,
    pub it_value: timespec,
}
pub unsafe fn clock() -> clock_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clock() -> clock_t;
        }
        clock()
    })
}
pub unsafe fn time(arg___timer: *mut time_t) -> time_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn time(arg___timer: *mut time_t) -> time_t;
        }
        time(arg___timer)
    })
}
pub unsafe fn difftime(arg___time1: time_t, arg___time0: time_t) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn difftime(arg___time1: time_t, arg___time0: time_t) -> f64;
        }
        difftime(arg___time1, arg___time0)
    })
}
pub unsafe fn mktime(arg___tp: *mut tm) -> time_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mktime(arg___tp: *mut tm) -> time_t;
        }
        mktime(arg___tp)
    })
}
pub unsafe fn strftime(
    arg___s: *mut ::std::os::raw::c_char,
    arg___maxsize: usize,
    arg___format: *const ::std::os::raw::c_char,
    arg___tp: *const tm,
) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strftime(
                arg___s: *mut ::std::os::raw::c_char,
                arg___maxsize: usize,
                arg___format: *const ::std::os::raw::c_char,
                arg___tp: *const tm,
            ) -> usize;
        }
        strftime(arg___s, arg___maxsize, arg___format, arg___tp)
    })
}
pub unsafe fn strftime_l(
    arg___s: *mut ::std::os::raw::c_char,
    arg___maxsize: usize,
    arg___format: *const ::std::os::raw::c_char,
    arg___tp: *const tm,
    arg___loc: locale_t,
) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strftime_l(
                arg___s: *mut ::std::os::raw::c_char,
                arg___maxsize: usize,
                arg___format: *const ::std::os::raw::c_char,
                arg___tp: *const tm,
                arg___loc: locale_t,
            ) -> usize;
        }
        strftime_l(arg___s, arg___maxsize, arg___format, arg___tp, arg___loc)
    })
}
pub unsafe fn gmtime(arg___timer: *const time_t) -> *mut tm {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gmtime(arg___timer: *const time_t) -> *mut tm;
        }
        gmtime(arg___timer)
    })
}
pub unsafe fn localtime(arg___timer: *const time_t) -> *mut tm {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn localtime(arg___timer: *const time_t) -> *mut tm;
        }
        localtime(arg___timer)
    })
}
pub unsafe fn gmtime_r(arg___timer: *const time_t, arg___tp: *mut tm) -> *mut tm {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn gmtime_r(arg___timer: *const time_t, arg___tp: *mut tm) -> *mut tm;
        }
        gmtime_r(arg___timer, arg___tp)
    })
}
pub unsafe fn localtime_r(arg___timer: *const time_t, arg___tp: *mut tm) -> *mut tm {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn localtime_r(arg___timer: *const time_t, arg___tp: *mut tm) -> *mut tm;
        }
        localtime_r(arg___timer, arg___tp)
    })
}
pub unsafe fn asctime(arg___tp: *const tm) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asctime(arg___tp: *const tm) -> *mut ::std::os::raw::c_char;
        }
        asctime(arg___tp)
    })
}
pub unsafe fn ctime(arg___timer: *const time_t) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ctime(arg___timer: *const time_t) -> *mut ::std::os::raw::c_char;
        }
        ctime(arg___timer)
    })
}
pub unsafe fn asctime_r(
    arg___tp: *const tm,
    arg___buf: *mut ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn asctime_r(
                arg___tp: *const tm,
                arg___buf: *mut ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        asctime_r(arg___tp, arg___buf)
    })
}
pub unsafe fn ctime_r(
    arg___timer: *const time_t,
    arg___buf: *mut ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ctime_r(
                arg___timer: *const time_t,
                arg___buf: *mut ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        ctime_r(arg___timer, arg___buf)
    })
}
extern "C" {
    pub static mut __tzname: [*mut ::std::os::raw::c_char; 2usize];
}
extern "C" {
    pub static mut __daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut __timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 2usize];
}
pub unsafe fn tzset() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tzset();
        }
        tzset()
    })
}
extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut timezone: ::std::os::raw::c_long;
}
pub unsafe fn timegm(arg___tp: *mut tm) -> time_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn timegm(arg___tp: *mut tm) -> time_t;
        }
        timegm(arg___tp)
    })
}
pub unsafe fn timelocal(arg___tp: *mut tm) -> time_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn timelocal(arg___tp: *mut tm) -> time_t;
        }
        timelocal(arg___tp)
    })
}
pub unsafe fn dysize(arg___year: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dysize(arg___year: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        dysize(arg___year)
    })
}
pub unsafe fn nanosleep(
    arg___requested_time: *const timespec,
    arg___remaining: *mut timespec,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nanosleep(
                arg___requested_time: *const timespec,
                arg___remaining: *mut timespec,
            ) -> ::std::os::raw::c_int;
        }
        nanosleep(arg___requested_time, arg___remaining)
    })
}
pub unsafe fn clock_getres(
    arg___clock_id: clockid_t,
    arg___res: *mut timespec,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clock_getres(
                arg___clock_id: clockid_t,
                arg___res: *mut timespec,
            ) -> ::std::os::raw::c_int;
        }
        clock_getres(arg___clock_id, arg___res)
    })
}
pub unsafe fn clock_gettime(
    arg___clock_id: clockid_t,
    arg___tp: *mut timespec,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clock_gettime(
                arg___clock_id: clockid_t,
                arg___tp: *mut timespec,
            ) -> ::std::os::raw::c_int;
        }
        clock_gettime(arg___clock_id, arg___tp)
    })
}
pub unsafe fn clock_settime(
    arg___clock_id: clockid_t,
    arg___tp: *const timespec,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clock_settime(
                arg___clock_id: clockid_t,
                arg___tp: *const timespec,
            ) -> ::std::os::raw::c_int;
        }
        clock_settime(arg___clock_id, arg___tp)
    })
}
pub unsafe fn clock_nanosleep(
    arg___clock_id: clockid_t,
    arg___flags: ::std::os::raw::c_int,
    arg___req: *const timespec,
    arg___rem: *mut timespec,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clock_nanosleep(
                arg___clock_id: clockid_t,
                arg___flags: ::std::os::raw::c_int,
                arg___req: *const timespec,
                arg___rem: *mut timespec,
            ) -> ::std::os::raw::c_int;
        }
        clock_nanosleep(arg___clock_id, arg___flags, arg___req, arg___rem)
    })
}
pub unsafe fn clock_getcpuclockid(
    arg___pid: pid_t,
    arg___clock_id: *mut clockid_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clock_getcpuclockid(
                arg___pid: pid_t,
                arg___clock_id: *mut clockid_t,
            ) -> ::std::os::raw::c_int;
        }
        clock_getcpuclockid(arg___pid, arg___clock_id)
    })
}
pub unsafe fn timer_create(
    arg___clock_id: clockid_t,
    arg___evp: *mut sigevent,
    arg___timerid: *mut timer_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn timer_create(
                arg___clock_id: clockid_t,
                arg___evp: *mut sigevent,
                arg___timerid: *mut timer_t,
            ) -> ::std::os::raw::c_int;
        }
        timer_create(arg___clock_id, arg___evp, arg___timerid)
    })
}
pub unsafe fn timer_delete(arg___timerid: timer_t) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn timer_delete(arg___timerid: timer_t) -> ::std::os::raw::c_int;
        }
        timer_delete(arg___timerid)
    })
}
pub unsafe fn timer_settime(
    arg___timerid: timer_t,
    arg___flags: ::std::os::raw::c_int,
    arg___value: *const itimerspec,
    arg___ovalue: *mut itimerspec,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn timer_settime(
                arg___timerid: timer_t,
                arg___flags: ::std::os::raw::c_int,
                arg___value: *const itimerspec,
                arg___ovalue: *mut itimerspec,
            ) -> ::std::os::raw::c_int;
        }
        timer_settime(arg___timerid, arg___flags, arg___value, arg___ovalue)
    })
}
pub unsafe fn timer_gettime(
    arg___timerid: timer_t,
    arg___value: *mut itimerspec,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn timer_gettime(
                arg___timerid: timer_t,
                arg___value: *mut itimerspec,
            ) -> ::std::os::raw::c_int;
        }
        timer_gettime(arg___timerid, arg___value)
    })
}
pub unsafe fn timer_getoverrun(arg___timerid: timer_t) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn timer_getoverrun(arg___timerid: timer_t) -> ::std::os::raw::c_int;
        }
        timer_getoverrun(arg___timerid)
    })
}
pub unsafe fn timespec_get(
    arg___ts: *mut timespec,
    arg___base: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn timespec_get(
                arg___ts: *mut timespec,
                arg___base: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        timespec_get(arg___ts, arg___base)
    })
}
pub type instr_time = timespec;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BufferUsage {
    pub shared_blks_hit: ::std::os::raw::c_long,
    pub shared_blks_read: ::std::os::raw::c_long,
    pub shared_blks_dirtied: ::std::os::raw::c_long,
    pub shared_blks_written: ::std::os::raw::c_long,
    pub local_blks_hit: ::std::os::raw::c_long,
    pub local_blks_read: ::std::os::raw::c_long,
    pub local_blks_dirtied: ::std::os::raw::c_long,
    pub local_blks_written: ::std::os::raw::c_long,
    pub temp_blks_read: ::std::os::raw::c_long,
    pub temp_blks_written: ::std::os::raw::c_long,
    pub blk_read_time: instr_time,
    pub blk_write_time: instr_time,
}
pub const InstrumentOption_INSTRUMENT_TIMER: InstrumentOption = 1;
pub const InstrumentOption_INSTRUMENT_BUFFERS: InstrumentOption = 2;
pub const InstrumentOption_INSTRUMENT_ROWS: InstrumentOption = 4;
pub const InstrumentOption_INSTRUMENT_ALL: InstrumentOption = 2147483647;
pub type InstrumentOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Instrumentation {
    pub need_timer: bool,
    pub need_bufusage: bool,
    pub running: bool,
    pub starttime: instr_time,
    pub counter: instr_time,
    pub firsttuple: f64,
    pub tuplecount: f64,
    pub bufusage_start: BufferUsage,
    pub startup: f64,
    pub total: f64,
    pub ntuples: f64,
    pub ntuples2: f64,
    pub nloops: f64,
    pub nfiltered1: f64,
    pub nfiltered2: f64,
    pub bufusage: BufferUsage,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct WorkerInstrumentation {
    pub num_workers: ::std::os::raw::c_int,
    pub instrument: __IncompleteArrayField<Instrumentation>,
}
extern "C" {
    pub static mut pgBufferUsage: BufferUsage;
}
pub unsafe fn InstrAlloc(
    arg_n: ::std::os::raw::c_int,
    arg_instrument_options: ::std::os::raw::c_int,
) -> *mut Instrumentation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrAlloc(
                arg_n: ::std::os::raw::c_int,
                arg_instrument_options: ::std::os::raw::c_int,
            ) -> *mut Instrumentation;
        }
        InstrAlloc(arg_n, arg_instrument_options)
    })
}
pub unsafe fn InstrInit(
    arg_instr: *mut Instrumentation,
    arg_instrument_options: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrInit(
                arg_instr: *mut Instrumentation,
                arg_instrument_options: ::std::os::raw::c_int,
            );
        }
        InstrInit(arg_instr, arg_instrument_options)
    })
}
pub unsafe fn InstrStartNode(arg_instr: *mut Instrumentation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrStartNode(arg_instr: *mut Instrumentation);
        }
        InstrStartNode(arg_instr)
    })
}
pub unsafe fn InstrStopNode(arg_instr: *mut Instrumentation, arg_nTuples: f64) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrStopNode(arg_instr: *mut Instrumentation, arg_nTuples: f64);
        }
        InstrStopNode(arg_instr, arg_nTuples)
    })
}
pub unsafe fn InstrEndLoop(arg_instr: *mut Instrumentation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrEndLoop(arg_instr: *mut Instrumentation);
        }
        InstrEndLoop(arg_instr)
    })
}
pub unsafe fn InstrAggNode(arg_dst: *mut Instrumentation, arg_add: *mut Instrumentation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrAggNode(arg_dst: *mut Instrumentation, arg_add: *mut Instrumentation);
        }
        InstrAggNode(arg_dst, arg_add)
    })
}
pub unsafe fn InstrStartParallelQuery() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrStartParallelQuery();
        }
        InstrStartParallelQuery()
    })
}
pub unsafe fn InstrEndParallelQuery(arg_result: *mut BufferUsage) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrEndParallelQuery(arg_result: *mut BufferUsage);
        }
        InstrEndParallelQuery(arg_result)
    })
}
pub unsafe fn InstrAccumParallelQuery(arg_result: *mut BufferUsage) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrAccumParallelQuery(arg_result: *mut BufferUsage);
        }
        InstrAccumParallelQuery(arg_result)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StringInfoData {
    pub data: *mut ::std::os::raw::c_char,
    pub len: ::std::os::raw::c_int,
    pub maxlen: ::std::os::raw::c_int,
    pub cursor: ::std::os::raw::c_int,
}
impl Default for StringInfoData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type StringInfo = *mut StringInfoData;
pub unsafe fn makeStringInfo() -> StringInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeStringInfo() -> StringInfo;
        }
        makeStringInfo()
    })
}
pub unsafe fn initStringInfo(arg_str_: StringInfo) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn initStringInfo(arg_str_: StringInfo);
        }
        initStringInfo(arg_str_)
    })
}
pub unsafe fn resetStringInfo(arg_str_: StringInfo) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn resetStringInfo(arg_str_: StringInfo);
        }
        resetStringInfo(arg_str_)
    })
}
pub unsafe fn appendStringInfo(arg_str_: StringInfo, arg_fmt: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendStringInfo(arg_str_: StringInfo, arg_fmt: *const ::std::os::raw::c_char);
        }
        appendStringInfo(arg_str_, arg_fmt)
    })
}
pub unsafe fn appendStringInfoVA(
    arg_str_: StringInfo,
    arg_fmt: *const ::std::os::raw::c_char,
    arg_args: *mut __va_list_tag,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendStringInfoVA(
                arg_str_: StringInfo,
                arg_fmt: *const ::std::os::raw::c_char,
                arg_args: *mut __va_list_tag,
            ) -> ::std::os::raw::c_int;
        }
        appendStringInfoVA(arg_str_, arg_fmt, arg_args)
    })
}
pub unsafe fn appendStringInfoString(arg_str_: StringInfo, arg_s: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendStringInfoString(arg_str_: StringInfo, arg_s: *const ::std::os::raw::c_char);
        }
        appendStringInfoString(arg_str_, arg_s)
    })
}
pub unsafe fn appendStringInfoChar(arg_str_: StringInfo, arg_ch: ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendStringInfoChar(arg_str_: StringInfo, arg_ch: ::std::os::raw::c_char);
        }
        appendStringInfoChar(arg_str_, arg_ch)
    })
}
pub unsafe fn appendStringInfoSpaces(arg_str_: StringInfo, arg_count: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendStringInfoSpaces(arg_str_: StringInfo, arg_count: ::std::os::raw::c_int);
        }
        appendStringInfoSpaces(arg_str_, arg_count)
    })
}
pub unsafe fn appendBinaryStringInfo(
    arg_str_: StringInfo,
    arg_data: *const ::std::os::raw::c_char,
    arg_datalen: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendBinaryStringInfo(
                arg_str_: StringInfo,
                arg_data: *const ::std::os::raw::c_char,
                arg_datalen: ::std::os::raw::c_int,
            );
        }
        appendBinaryStringInfo(arg_str_, arg_data, arg_datalen)
    })
}
pub unsafe fn appendBinaryStringInfoNT(
    arg_str_: StringInfo,
    arg_data: *const ::std::os::raw::c_char,
    arg_datalen: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendBinaryStringInfoNT(
                arg_str_: StringInfo,
                arg_data: *const ::std::os::raw::c_char,
                arg_datalen: ::std::os::raw::c_int,
            );
        }
        appendBinaryStringInfoNT(arg_str_, arg_data, arg_datalen)
    })
}
pub unsafe fn enlargeStringInfo(arg_str_: StringInfo, arg_needed: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn enlargeStringInfo(arg_str_: StringInfo, arg_needed: ::std::os::raw::c_int);
        }
        enlargeStringInfo(arg_str_, arg_needed)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pairingheap_node {
    pub first_child: *mut pairingheap_node,
    pub next_sibling: *mut pairingheap_node,
    pub prev_or_parent: *mut pairingheap_node,
}
impl Default for pairingheap_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pairingheap_comparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const pairingheap_node,
        b: *const pairingheap_node,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pairingheap {
    pub ph_compare: pairingheap_comparator,
    pub ph_arg: *mut ::std::os::raw::c_void,
    pub ph_root: *mut pairingheap_node,
}
impl Default for pairingheap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn pairingheap_allocate(
    arg_compare: pairingheap_comparator,
    arg_arg: *mut ::std::os::raw::c_void,
) -> *mut pairingheap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_allocate(
                arg_compare: pairingheap_comparator,
                arg_arg: *mut ::std::os::raw::c_void,
            ) -> *mut pairingheap;
        }
        pairingheap_allocate(arg_compare, arg_arg)
    })
}
pub unsafe fn pairingheap_free(arg_heap: *mut pairingheap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_free(arg_heap: *mut pairingheap);
        }
        pairingheap_free(arg_heap)
    })
}
pub unsafe fn pairingheap_add(arg_heap: *mut pairingheap, arg_node: *mut pairingheap_node) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_add(arg_heap: *mut pairingheap, arg_node: *mut pairingheap_node);
        }
        pairingheap_add(arg_heap, arg_node)
    })
}
pub unsafe fn pairingheap_first(arg_heap: *mut pairingheap) -> *mut pairingheap_node {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_first(arg_heap: *mut pairingheap) -> *mut pairingheap_node;
        }
        pairingheap_first(arg_heap)
    })
}
pub unsafe fn pairingheap_remove_first(arg_heap: *mut pairingheap) -> *mut pairingheap_node {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_remove_first(arg_heap: *mut pairingheap) -> *mut pairingheap_node;
        }
        pairingheap_remove_first(arg_heap)
    })
}
pub unsafe fn pairingheap_remove(arg_heap: *mut pairingheap, arg_node: *mut pairingheap_node) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_remove(arg_heap: *mut pairingheap, arg_node: *mut pairingheap_node);
        }
        pairingheap_remove(arg_heap, arg_node)
    })
}
#[repr(C)]
pub struct ParamExternData {
    pub value: Datum,
    pub isnull: bool,
    pub pflags: uint16,
    pub ptype: Oid,
}
impl Default for ParamExternData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ParamListInfo = *mut ParamListInfoData;
pub type ParamFetchHook = ::std::option::Option<
    unsafe extern "C" fn(
        params: ParamListInfo,
        paramid: ::std::os::raw::c_int,
        speculative: bool,
        workspace: *mut ParamExternData,
    ) -> *mut ParamExternData,
>;
pub type ParamCompileHook = ::std::option::Option<
    unsafe extern "C" fn(
        params: ParamListInfo,
        param: *mut Param,
        state: *mut ExprState,
        resv: *mut Datum,
        resnull: *mut bool,
    ),
>;
pub type ParserSetupHook = ::std::option::Option<
    unsafe extern "C" fn(pstate: *mut ParseState, arg: *mut ::std::os::raw::c_void),
>;
#[repr(C)]
pub struct ParamListInfoData {
    pub paramFetch: ParamFetchHook,
    pub paramFetchArg: *mut ::std::os::raw::c_void,
    pub paramCompile: ParamCompileHook,
    pub paramCompileArg: *mut ::std::os::raw::c_void,
    pub parserSetup: ParserSetupHook,
    pub parserSetupArg: *mut ::std::os::raw::c_void,
    pub numParams: ::std::os::raw::c_int,
    pub params: __IncompleteArrayField<ParamExternData>,
}
impl Default for ParamListInfoData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct ParamExecData {
    pub execPlan: *mut ::std::os::raw::c_void,
    pub value: Datum,
    pub isnull: bool,
}
impl Default for ParamExecData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn makeParamList(arg_numParams: ::std::os::raw::c_int) -> ParamListInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeParamList(arg_numParams: ::std::os::raw::c_int) -> ParamListInfo;
        }
        makeParamList(arg_numParams)
    })
}
pub unsafe fn copyParamList(arg_from: ParamListInfo) -> ParamListInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn copyParamList(arg_from: ParamListInfo) -> ParamListInfo;
        }
        copyParamList(arg_from)
    })
}
pub unsafe fn EstimateParamListSpace(arg_paramLI: ParamListInfo) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EstimateParamListSpace(arg_paramLI: ParamListInfo) -> Size;
        }
        EstimateParamListSpace(arg_paramLI)
    })
}
pub unsafe fn SerializeParamList(
    arg_paramLI: ParamListInfo,
    arg_start_address: *mut *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SerializeParamList(
                arg_paramLI: ParamListInfo,
                arg_start_address: *mut *mut ::std::os::raw::c_char,
            );
        }
        SerializeParamList(arg_paramLI, arg_start_address)
    })
}
pub unsafe fn RestoreParamList(
    arg_start_address: *mut *mut ::std::os::raw::c_char,
) -> ParamListInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RestoreParamList(
                arg_start_address: *mut *mut ::std::os::raw::c_char,
            ) -> ParamListInfo;
        }
        RestoreParamList(arg_start_address)
    })
}
pub const ScanDirection_BackwardScanDirection: ScanDirection = -1;
pub const ScanDirection_NoMovementScanDirection: ScanDirection = 0;
pub const ScanDirection_ForwardScanDirection: ScanDirection = 1;
pub type ScanDirection = ::std::os::raw::c_int;
pub type StrategyNumber = uint16;
pub const LockClauseStrength_LCS_NONE: LockClauseStrength = 0;
pub const LockClauseStrength_LCS_FORKEYSHARE: LockClauseStrength = 1;
pub const LockClauseStrength_LCS_FORSHARE: LockClauseStrength = 2;
pub const LockClauseStrength_LCS_FORNOKEYUPDATE: LockClauseStrength = 3;
pub const LockClauseStrength_LCS_FORUPDATE: LockClauseStrength = 4;
pub type LockClauseStrength = ::std::os::raw::c_uint;
pub const LockWaitPolicy_LockWaitBlock: LockWaitPolicy = 0;
pub const LockWaitPolicy_LockWaitSkip: LockWaitPolicy = 1;
pub const LockWaitPolicy_LockWaitError: LockWaitPolicy = 2;
pub type LockWaitPolicy = ::std::os::raw::c_uint;
pub const LockTupleMode_LockTupleKeyShare: LockTupleMode = 0;
pub const LockTupleMode_LockTupleShare: LockTupleMode = 1;
pub const LockTupleMode_LockTupleNoKeyExclusive: LockTupleMode = 2;
pub const LockTupleMode_LockTupleExclusive: LockTupleMode = 3;
pub type LockTupleMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Alias {
    pub type_: NodeTag,
    pub aliasname: *mut ::std::os::raw::c_char,
    pub colnames: *mut List,
}
impl Default for Alias {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const OnCommitAction_ONCOMMIT_NOOP: OnCommitAction = 0;
pub const OnCommitAction_ONCOMMIT_PRESERVE_ROWS: OnCommitAction = 1;
pub const OnCommitAction_ONCOMMIT_DELETE_ROWS: OnCommitAction = 2;
pub const OnCommitAction_ONCOMMIT_DROP: OnCommitAction = 3;
pub type OnCommitAction = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeVar {
    pub type_: NodeTag,
    pub catalogname: *mut ::std::os::raw::c_char,
    pub schemaname: *mut ::std::os::raw::c_char,
    pub relname: *mut ::std::os::raw::c_char,
    pub inh: bool,
    pub relpersistence: ::std::os::raw::c_char,
    pub alias: *mut Alias,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeVar {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFunc {
    pub type_: NodeTag,
    pub ns_uris: *mut List,
    pub ns_names: *mut List,
    pub docexpr: *mut Node,
    pub rowexpr: *mut Node,
    pub colnames: *mut List,
    pub coltypes: *mut List,
    pub coltypmods: *mut List,
    pub colcollations: *mut List,
    pub colexprs: *mut List,
    pub coldefexprs: *mut List,
    pub notnulls: *mut Bitmapset,
    pub ordinalitycol: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for TableFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IntoClause {
    pub type_: NodeTag,
    pub rel: *mut RangeVar,
    pub colNames: *mut List,
    pub accessMethod: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub onCommit: OnCommitAction,
    pub tableSpaceName: *mut ::std::os::raw::c_char,
    pub viewQuery: *mut Node,
    pub skipData: bool,
}
impl Default for IntoClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Expr {
    pub type_: NodeTag,
}
impl Default for Expr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Var {
    pub xpr: Expr,
    pub varno: Index,
    pub varattno: AttrNumber,
    pub vartype: Oid,
    pub vartypmod: int32,
    pub varcollid: Oid,
    pub varlevelsup: Index,
    pub varnoold: Index,
    pub varoattno: AttrNumber,
    pub location: ::std::os::raw::c_int,
}
impl Default for Var {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct Const {
    pub xpr: Expr,
    pub consttype: Oid,
    pub consttypmod: int32,
    pub constcollid: Oid,
    pub constlen: ::std::os::raw::c_int,
    pub constvalue: Datum,
    pub constisnull: bool,
    pub constbyval: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for Const {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ParamKind_PARAM_EXTERN: ParamKind = 0;
pub const ParamKind_PARAM_EXEC: ParamKind = 1;
pub const ParamKind_PARAM_SUBLINK: ParamKind = 2;
pub const ParamKind_PARAM_MULTIEXPR: ParamKind = 3;
pub type ParamKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Param {
    pub xpr: Expr,
    pub paramkind: ParamKind,
    pub paramid: ::std::os::raw::c_int,
    pub paramtype: Oid,
    pub paramtypmod: int32,
    pub paramcollid: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for Param {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Aggref {
    pub xpr: Expr,
    pub aggfnoid: Oid,
    pub aggtype: Oid,
    pub aggcollid: Oid,
    pub inputcollid: Oid,
    pub aggtranstype: Oid,
    pub aggargtypes: *mut List,
    pub aggdirectargs: *mut List,
    pub args: *mut List,
    pub aggorder: *mut List,
    pub aggdistinct: *mut List,
    pub aggfilter: *mut Expr,
    pub aggstar: bool,
    pub aggvariadic: bool,
    pub aggkind: ::std::os::raw::c_char,
    pub agglevelsup: Index,
    pub aggsplit: AggSplit,
    pub location: ::std::os::raw::c_int,
}
impl Default for Aggref {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupingFunc {
    pub xpr: Expr,
    pub args: *mut List,
    pub refs: *mut List,
    pub cols: *mut List,
    pub agglevelsup: Index,
    pub location: ::std::os::raw::c_int,
}
impl Default for GroupingFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowFunc {
    pub xpr: Expr,
    pub winfnoid: Oid,
    pub wintype: Oid,
    pub wincollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub aggfilter: *mut Expr,
    pub winref: Index,
    pub winstar: bool,
    pub winagg: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for WindowFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubscriptingRef {
    pub xpr: Expr,
    pub refcontainertype: Oid,
    pub refelemtype: Oid,
    pub reftypmod: int32,
    pub refcollid: Oid,
    pub refupperindexpr: *mut List,
    pub reflowerindexpr: *mut List,
    pub refexpr: *mut Expr,
    pub refassgnexpr: *mut Expr,
}
impl Default for SubscriptingRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const CoercionContext_COERCION_IMPLICIT: CoercionContext = 0;
pub const CoercionContext_COERCION_ASSIGNMENT: CoercionContext = 1;
pub const CoercionContext_COERCION_EXPLICIT: CoercionContext = 2;
pub type CoercionContext = ::std::os::raw::c_uint;
pub const CoercionForm_COERCE_EXPLICIT_CALL: CoercionForm = 0;
pub const CoercionForm_COERCE_EXPLICIT_CAST: CoercionForm = 1;
pub const CoercionForm_COERCE_IMPLICIT_CAST: CoercionForm = 2;
pub type CoercionForm = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncExpr {
    pub xpr: Expr,
    pub funcid: Oid,
    pub funcresulttype: Oid,
    pub funcretset: bool,
    pub funcvariadic: bool,
    pub funcformat: CoercionForm,
    pub funccollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for FuncExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedArgExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub name: *mut ::std::os::raw::c_char,
    pub argnumber: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for NamedArgExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OpExpr {
    pub xpr: Expr,
    pub opno: Oid,
    pub opfuncid: Oid,
    pub opresulttype: Oid,
    pub opretset: bool,
    pub opcollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for OpExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type DistinctExpr = OpExpr;
pub type NullIfExpr = OpExpr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScalarArrayOpExpr {
    pub xpr: Expr,
    pub opno: Oid,
    pub opfuncid: Oid,
    pub useOr: bool,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ScalarArrayOpExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BoolExprType_AND_EXPR: BoolExprType = 0;
pub const BoolExprType_OR_EXPR: BoolExprType = 1;
pub const BoolExprType_NOT_EXPR: BoolExprType = 2;
pub type BoolExprType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BoolExpr {
    pub xpr: Expr,
    pub boolop: BoolExprType,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for BoolExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SubLinkType_EXISTS_SUBLINK: SubLinkType = 0;
pub const SubLinkType_ALL_SUBLINK: SubLinkType = 1;
pub const SubLinkType_ANY_SUBLINK: SubLinkType = 2;
pub const SubLinkType_ROWCOMPARE_SUBLINK: SubLinkType = 3;
pub const SubLinkType_EXPR_SUBLINK: SubLinkType = 4;
pub const SubLinkType_MULTIEXPR_SUBLINK: SubLinkType = 5;
pub const SubLinkType_ARRAY_SUBLINK: SubLinkType = 6;
pub const SubLinkType_CTE_SUBLINK: SubLinkType = 7;
pub type SubLinkType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubLink {
    pub xpr: Expr,
    pub subLinkType: SubLinkType,
    pub subLinkId: ::std::os::raw::c_int,
    pub testexpr: *mut Node,
    pub operName: *mut List,
    pub subselect: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for SubLink {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubPlan {
    pub xpr: Expr,
    pub subLinkType: SubLinkType,
    pub testexpr: *mut Node,
    pub paramIds: *mut List,
    pub plan_id: ::std::os::raw::c_int,
    pub plan_name: *mut ::std::os::raw::c_char,
    pub firstColType: Oid,
    pub firstColTypmod: int32,
    pub firstColCollation: Oid,
    pub useHashTable: bool,
    pub unknownEqFalse: bool,
    pub parallel_safe: bool,
    pub setParam: *mut List,
    pub parParam: *mut List,
    pub args: *mut List,
    pub startup_cost: Cost,
    pub per_call_cost: Cost,
}
impl Default for SubPlan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlternativeSubPlan {
    pub xpr: Expr,
    pub subplans: *mut List,
}
impl Default for AlternativeSubPlan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FieldSelect {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub fieldnum: AttrNumber,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
}
impl Default for FieldSelect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FieldStore {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub newvals: *mut List,
    pub fieldnums: *mut List,
    pub resulttype: Oid,
}
impl Default for FieldStore {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RelabelType {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub relabelformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for RelabelType {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceViaIO {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resultcollid: Oid,
    pub coerceformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceViaIO {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayCoerceExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub elemexpr: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub coerceformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for ArrayCoerceExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConvertRowtypeExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub convertformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for ConvertRowtypeExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollateExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub collOid: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for CollateExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseExpr {
    pub xpr: Expr,
    pub casetype: Oid,
    pub casecollid: Oid,
    pub arg: *mut Expr,
    pub args: *mut List,
    pub defresult: *mut Expr,
    pub location: ::std::os::raw::c_int,
}
impl Default for CaseExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseWhen {
    pub xpr: Expr,
    pub expr: *mut Expr,
    pub result: *mut Expr,
    pub location: ::std::os::raw::c_int,
}
impl Default for CaseWhen {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseTestExpr {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
}
impl Default for CaseTestExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayExpr {
    pub xpr: Expr,
    pub array_typeid: Oid,
    pub array_collid: Oid,
    pub element_typeid: Oid,
    pub elements: *mut List,
    pub multidims: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for ArrayExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowExpr {
    pub xpr: Expr,
    pub args: *mut List,
    pub row_typeid: Oid,
    pub row_format: CoercionForm,
    pub colnames: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for RowExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RowCompareType_ROWCOMPARE_LT: RowCompareType = 1;
pub const RowCompareType_ROWCOMPARE_LE: RowCompareType = 2;
pub const RowCompareType_ROWCOMPARE_EQ: RowCompareType = 3;
pub const RowCompareType_ROWCOMPARE_GE: RowCompareType = 4;
pub const RowCompareType_ROWCOMPARE_GT: RowCompareType = 5;
pub const RowCompareType_ROWCOMPARE_NE: RowCompareType = 6;
pub type RowCompareType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowCompareExpr {
    pub xpr: Expr,
    pub rctype: RowCompareType,
    pub opnos: *mut List,
    pub opfamilies: *mut List,
    pub inputcollids: *mut List,
    pub largs: *mut List,
    pub rargs: *mut List,
}
impl Default for RowCompareExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoalesceExpr {
    pub xpr: Expr,
    pub coalescetype: Oid,
    pub coalescecollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoalesceExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const MinMaxOp_IS_GREATEST: MinMaxOp = 0;
pub const MinMaxOp_IS_LEAST: MinMaxOp = 1;
pub type MinMaxOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MinMaxExpr {
    pub xpr: Expr,
    pub minmaxtype: Oid,
    pub minmaxcollid: Oid,
    pub inputcollid: Oid,
    pub op: MinMaxOp,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for MinMaxExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SQLValueFunctionOp_SVFOP_CURRENT_DATE: SQLValueFunctionOp = 0;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIME: SQLValueFunctionOp = 1;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIME_N: SQLValueFunctionOp = 2;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIMESTAMP: SQLValueFunctionOp = 3;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIMESTAMP_N: SQLValueFunctionOp = 4;
pub const SQLValueFunctionOp_SVFOP_LOCALTIME: SQLValueFunctionOp = 5;
pub const SQLValueFunctionOp_SVFOP_LOCALTIME_N: SQLValueFunctionOp = 6;
pub const SQLValueFunctionOp_SVFOP_LOCALTIMESTAMP: SQLValueFunctionOp = 7;
pub const SQLValueFunctionOp_SVFOP_LOCALTIMESTAMP_N: SQLValueFunctionOp = 8;
pub const SQLValueFunctionOp_SVFOP_CURRENT_ROLE: SQLValueFunctionOp = 9;
pub const SQLValueFunctionOp_SVFOP_CURRENT_USER: SQLValueFunctionOp = 10;
pub const SQLValueFunctionOp_SVFOP_USER: SQLValueFunctionOp = 11;
pub const SQLValueFunctionOp_SVFOP_SESSION_USER: SQLValueFunctionOp = 12;
pub const SQLValueFunctionOp_SVFOP_CURRENT_CATALOG: SQLValueFunctionOp = 13;
pub const SQLValueFunctionOp_SVFOP_CURRENT_SCHEMA: SQLValueFunctionOp = 14;
pub type SQLValueFunctionOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SQLValueFunction {
    pub xpr: Expr,
    pub op: SQLValueFunctionOp,
    pub type_: Oid,
    pub typmod: int32,
    pub location: ::std::os::raw::c_int,
}
impl Default for SQLValueFunction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const XmlExprOp_IS_XMLCONCAT: XmlExprOp = 0;
pub const XmlExprOp_IS_XMLELEMENT: XmlExprOp = 1;
pub const XmlExprOp_IS_XMLFOREST: XmlExprOp = 2;
pub const XmlExprOp_IS_XMLPARSE: XmlExprOp = 3;
pub const XmlExprOp_IS_XMLPI: XmlExprOp = 4;
pub const XmlExprOp_IS_XMLROOT: XmlExprOp = 5;
pub const XmlExprOp_IS_XMLSERIALIZE: XmlExprOp = 6;
pub const XmlExprOp_IS_DOCUMENT: XmlExprOp = 7;
pub type XmlExprOp = ::std::os::raw::c_uint;
pub const XmlOptionType_XMLOPTION_DOCUMENT: XmlOptionType = 0;
pub const XmlOptionType_XMLOPTION_CONTENT: XmlOptionType = 1;
pub type XmlOptionType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XmlExpr {
    pub xpr: Expr,
    pub op: XmlExprOp,
    pub name: *mut ::std::os::raw::c_char,
    pub named_args: *mut List,
    pub arg_names: *mut List,
    pub args: *mut List,
    pub xmloption: XmlOptionType,
    pub type_: Oid,
    pub typmod: int32,
    pub location: ::std::os::raw::c_int,
}
impl Default for XmlExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const NullTestType_IS_NULL: NullTestType = 0;
pub const NullTestType_IS_NOT_NULL: NullTestType = 1;
pub type NullTestType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NullTest {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub nulltesttype: NullTestType,
    pub argisrow: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for NullTest {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BoolTestType_IS_TRUE: BoolTestType = 0;
pub const BoolTestType_IS_NOT_TRUE: BoolTestType = 1;
pub const BoolTestType_IS_FALSE: BoolTestType = 2;
pub const BoolTestType_IS_NOT_FALSE: BoolTestType = 3;
pub const BoolTestType_IS_UNKNOWN: BoolTestType = 4;
pub const BoolTestType_IS_NOT_UNKNOWN: BoolTestType = 5;
pub type BoolTestType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BooleanTest {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub booltesttype: BoolTestType,
    pub location: ::std::os::raw::c_int,
}
impl Default for BooleanTest {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceToDomain {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub coercionformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceToDomain {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceToDomainValue {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceToDomainValue {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetToDefault {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for SetToDefault {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CurrentOfExpr {
    pub xpr: Expr,
    pub cvarno: Index,
    pub cursor_name: *mut ::std::os::raw::c_char,
    pub cursor_param: ::std::os::raw::c_int,
}
impl Default for CurrentOfExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NextValueExpr {
    pub xpr: Expr,
    pub seqid: Oid,
    pub typeId: Oid,
}
impl Default for NextValueExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InferenceElem {
    pub xpr: Expr,
    pub expr: *mut Node,
    pub infercollid: Oid,
    pub inferopclass: Oid,
}
impl Default for InferenceElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TargetEntry {
    pub xpr: Expr,
    pub expr: *mut Expr,
    pub resno: AttrNumber,
    pub resname: *mut ::std::os::raw::c_char,
    pub ressortgroupref: Index,
    pub resorigtbl: Oid,
    pub resorigcol: AttrNumber,
    pub resjunk: bool,
}
impl Default for TargetEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblRef {
    pub type_: NodeTag,
    pub rtindex: ::std::os::raw::c_int,
}
impl Default for RangeTblRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JoinExpr {
    pub type_: NodeTag,
    pub jointype: JoinType,
    pub isNatural: bool,
    pub larg: *mut Node,
    pub rarg: *mut Node,
    pub usingClause: *mut List,
    pub quals: *mut Node,
    pub alias: *mut Alias,
    pub rtindex: ::std::os::raw::c_int,
}
impl Default for JoinExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FromExpr {
    pub type_: NodeTag,
    pub fromlist: *mut List,
    pub quals: *mut Node,
}
impl Default for FromExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictExpr {
    pub type_: NodeTag,
    pub action: OnConflictAction,
    pub arbiterElems: *mut List,
    pub arbiterWhere: *mut Node,
    pub constraint: Oid,
    pub onConflictSet: *mut List,
    pub onConflictWhere: *mut Node,
    pub exclRelIndex: ::std::os::raw::c_int,
    pub exclRelTlist: *mut List,
}
impl Default for OnConflictExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlannedStmt {
    pub type_: NodeTag,
    pub commandType: CmdType,
    pub queryId: uint64,
    pub hasReturning: bool,
    pub hasModifyingCTE: bool,
    pub canSetTag: bool,
    pub transientPlan: bool,
    pub dependsOnRole: bool,
    pub parallelModeNeeded: bool,
    pub jitFlags: ::std::os::raw::c_int,
    pub planTree: *mut Plan,
    pub rtable: *mut List,
    pub resultRelations: *mut List,
    pub rootResultRelations: *mut List,
    pub subplans: *mut List,
    pub rewindPlanIDs: *mut Bitmapset,
    pub rowMarks: *mut List,
    pub relationOids: *mut List,
    pub invalItems: *mut List,
    pub paramExecTypes: *mut List,
    pub utilityStmt: *mut Node,
    pub stmt_location: ::std::os::raw::c_int,
    pub stmt_len: ::std::os::raw::c_int,
}
impl Default for PlannedStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Plan {
    pub type_: NodeTag,
    pub startup_cost: Cost,
    pub total_cost: Cost,
    pub plan_rows: f64,
    pub plan_width: ::std::os::raw::c_int,
    pub parallel_aware: bool,
    pub parallel_safe: bool,
    pub plan_node_id: ::std::os::raw::c_int,
    pub targetlist: *mut List,
    pub qual: *mut List,
    pub lefttree: *mut Plan,
    pub righttree: *mut Plan,
    pub initPlan: *mut List,
    pub extParam: *mut Bitmapset,
    pub allParam: *mut Bitmapset,
}
impl Default for Plan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Result {
    pub plan: Plan,
    pub resconstantqual: *mut Node,
}
impl Default for Result {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectSet {
    pub plan: Plan,
}
impl Default for ProjectSet {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ModifyTable {
    pub plan: Plan,
    pub operation: CmdType,
    pub canSetTag: bool,
    pub nominalRelation: Index,
    pub rootRelation: Index,
    pub partColsUpdated: bool,
    pub resultRelations: *mut List,
    pub resultRelIndex: ::std::os::raw::c_int,
    pub rootResultRelIndex: ::std::os::raw::c_int,
    pub plans: *mut List,
    pub withCheckOptionLists: *mut List,
    pub returningLists: *mut List,
    pub fdwPrivLists: *mut List,
    pub fdwDirectModifyPlans: *mut Bitmapset,
    pub rowMarks: *mut List,
    pub epqParam: ::std::os::raw::c_int,
    pub onConflictAction: OnConflictAction,
    pub arbiterIndexes: *mut List,
    pub onConflictSet: *mut List,
    pub onConflictWhere: *mut Node,
    pub exclRelRTI: Index,
    pub exclRelTlist: *mut List,
}
impl Default for ModifyTable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Append {
    pub plan: Plan,
    pub appendplans: *mut List,
    pub first_partial_plan: ::std::os::raw::c_int,
    pub part_prune_info: *mut PartitionPruneInfo,
}
impl Default for Append {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeAppend {
    pub plan: Plan,
    pub mergeplans: *mut List,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
    pub part_prune_info: *mut PartitionPruneInfo,
}
impl Default for MergeAppend {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RecursiveUnion {
    pub plan: Plan,
    pub wtParam: ::std::os::raw::c_int,
    pub numCols: ::std::os::raw::c_int,
    pub dupColIdx: *mut AttrNumber,
    pub dupOperators: *mut Oid,
    pub dupCollations: *mut Oid,
    pub numGroups: ::std::os::raw::c_long,
}
impl Default for RecursiveUnion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapAnd {
    pub plan: Plan,
    pub bitmapplans: *mut List,
}
impl Default for BitmapAnd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapOr {
    pub plan: Plan,
    pub isshared: bool,
    pub bitmapplans: *mut List,
}
impl Default for BitmapOr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Scan {
    pub plan: Plan,
    pub scanrelid: Index,
}
impl Default for Scan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SeqScan = Scan;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SampleScan {
    pub scan: Scan,
    pub tablesample: *mut TableSampleClause,
}
impl Default for SampleScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub indexqual: *mut List,
    pub indexqualorig: *mut List,
    pub indexorderby: *mut List,
    pub indexorderbyorig: *mut List,
    pub indexorderbyops: *mut List,
    pub indexorderdir: ScanDirection,
}
impl Default for IndexScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexOnlyScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub indexqual: *mut List,
    pub indexorderby: *mut List,
    pub indextlist: *mut List,
    pub indexorderdir: ScanDirection,
    pub recheckqual: *mut List,
}
impl Default for IndexOnlyScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapIndexScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub isshared: bool,
    pub indexqual: *mut List,
    pub indexqualorig: *mut List,
}
impl Default for BitmapIndexScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapHeapScan {
    pub scan: Scan,
    pub bitmapqualorig: *mut List,
}
impl Default for BitmapHeapScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidScan {
    pub scan: Scan,
    pub tidquals: *mut List,
}
impl Default for TidScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubqueryScan {
    pub scan: Scan,
    pub subplan: *mut Plan,
}
impl Default for SubqueryScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScan {
    pub scan: Scan,
    pub functions: *mut List,
    pub funcordinality: bool,
}
impl Default for FunctionScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValuesScan {
    pub scan: Scan,
    pub values_lists: *mut List,
}
impl Default for ValuesScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFuncScan {
    pub scan: Scan,
    pub tablefunc: *mut TableFunc,
}
impl Default for TableFuncScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CteScan {
    pub scan: Scan,
    pub ctePlanId: ::std::os::raw::c_int,
    pub cteParam: ::std::os::raw::c_int,
}
impl Default for CteScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedTuplestoreScan {
    pub scan: Scan,
    pub enrname: *mut ::std::os::raw::c_char,
}
impl Default for NamedTuplestoreScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WorkTableScan {
    pub scan: Scan,
    pub wtParam: ::std::os::raw::c_int,
}
impl Default for WorkTableScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignScan {
    pub scan: Scan,
    pub operation: CmdType,
    pub fs_server: Oid,
    pub fdw_exprs: *mut List,
    pub fdw_private: *mut List,
    pub fdw_scan_tlist: *mut List,
    pub fdw_recheck_quals: *mut List,
    pub fs_relids: *mut Bitmapset,
    pub fsSystemCol: bool,
}
impl Default for ForeignScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomScan {
    pub scan: Scan,
    pub flags: uint32,
    pub custom_plans: *mut List,
    pub custom_exprs: *mut List,
    pub custom_private: *mut List,
    pub custom_scan_tlist: *mut List,
    pub custom_relids: *mut Bitmapset,
    pub methods: *const CustomScanMethods,
}
impl Default for CustomScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Join {
    pub plan: Plan,
    pub jointype: JoinType,
    pub inner_unique: bool,
    pub joinqual: *mut List,
}
impl Default for Join {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoop {
    pub join: Join,
    pub nestParams: *mut List,
}
impl Default for NestLoop {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoopParam {
    pub type_: NodeTag,
    pub paramno: ::std::os::raw::c_int,
    pub paramval: *mut Var,
}
impl Default for NestLoopParam {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoin {
    pub join: Join,
    pub skip_mark_restore: bool,
    pub mergeclauses: *mut List,
    pub mergeFamilies: *mut Oid,
    pub mergeCollations: *mut Oid,
    pub mergeStrategies: *mut ::std::os::raw::c_int,
    pub mergeNullsFirst: *mut bool,
}
impl Default for MergeJoin {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoin {
    pub join: Join,
    pub hashclauses: *mut List,
    pub hashoperators: *mut List,
    pub hashcollations: *mut List,
    pub hashkeys: *mut List,
}
impl Default for HashJoin {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Material {
    pub plan: Plan,
}
impl Default for Material {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Sort {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
}
impl Default for Sort {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Group {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub grpColIdx: *mut AttrNumber,
    pub grpOperators: *mut Oid,
    pub grpCollations: *mut Oid,
}
impl Default for Group {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Agg {
    pub plan: Plan,
    pub aggstrategy: AggStrategy,
    pub aggsplit: AggSplit,
    pub numCols: ::std::os::raw::c_int,
    pub grpColIdx: *mut AttrNumber,
    pub grpOperators: *mut Oid,
    pub grpCollations: *mut Oid,
    pub numGroups: ::std::os::raw::c_long,
    pub aggParams: *mut Bitmapset,
    pub groupingSets: *mut List,
    pub chain: *mut List,
}
impl Default for Agg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowAgg {
    pub plan: Plan,
    pub winref: Index,
    pub partNumCols: ::std::os::raw::c_int,
    pub partColIdx: *mut AttrNumber,
    pub partOperators: *mut Oid,
    pub partCollations: *mut Oid,
    pub ordNumCols: ::std::os::raw::c_int,
    pub ordColIdx: *mut AttrNumber,
    pub ordOperators: *mut Oid,
    pub ordCollations: *mut Oid,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub startInRangeFunc: Oid,
    pub endInRangeFunc: Oid,
    pub inRangeColl: Oid,
    pub inRangeAsc: bool,
    pub inRangeNullsFirst: bool,
}
impl Default for WindowAgg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Unique {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub uniqColIdx: *mut AttrNumber,
    pub uniqOperators: *mut Oid,
    pub uniqCollations: *mut Oid,
}
impl Default for Unique {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Gather {
    pub plan: Plan,
    pub num_workers: ::std::os::raw::c_int,
    pub rescan_param: ::std::os::raw::c_int,
    pub single_copy: bool,
    pub invisible: bool,
    pub initParam: *mut Bitmapset,
}
impl Default for Gather {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherMerge {
    pub plan: Plan,
    pub num_workers: ::std::os::raw::c_int,
    pub rescan_param: ::std::os::raw::c_int,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
    pub initParam: *mut Bitmapset,
}
impl Default for GatherMerge {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Hash {
    pub plan: Plan,
    pub hashkeys: *mut List,
    pub skewTable: Oid,
    pub skewColumn: AttrNumber,
    pub skewInherit: bool,
    pub rows_total: f64,
}
impl Default for Hash {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOp {
    pub plan: Plan,
    pub cmd: SetOpCmd,
    pub strategy: SetOpStrategy,
    pub numCols: ::std::os::raw::c_int,
    pub dupColIdx: *mut AttrNumber,
    pub dupOperators: *mut Oid,
    pub dupCollations: *mut Oid,
    pub flagColIdx: AttrNumber,
    pub firstFlag: ::std::os::raw::c_int,
    pub numGroups: ::std::os::raw::c_long,
}
impl Default for SetOp {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRows {
    pub plan: Plan,
    pub rowMarks: *mut List,
    pub epqParam: ::std::os::raw::c_int,
}
impl Default for LockRows {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Limit {
    pub plan: Plan,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
}
impl Default for Limit {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RowMarkType_ROW_MARK_EXCLUSIVE: RowMarkType = 0;
pub const RowMarkType_ROW_MARK_NOKEYEXCLUSIVE: RowMarkType = 1;
pub const RowMarkType_ROW_MARK_SHARE: RowMarkType = 2;
pub const RowMarkType_ROW_MARK_KEYSHARE: RowMarkType = 3;
pub const RowMarkType_ROW_MARK_REFERENCE: RowMarkType = 4;
pub const RowMarkType_ROW_MARK_COPY: RowMarkType = 5;
pub type RowMarkType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanRowMark {
    pub type_: NodeTag,
    pub rti: Index,
    pub prti: Index,
    pub rowmarkId: Index,
    pub markType: RowMarkType,
    pub allMarkTypes: ::std::os::raw::c_int,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
    pub isParent: bool,
}
impl Default for PlanRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneInfo {
    pub type_: NodeTag,
    pub prune_infos: *mut List,
    pub other_subplans: *mut Bitmapset,
}
impl Default for PartitionPruneInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionedRelPruneInfo {
    pub type_: NodeTag,
    pub rtindex: Index,
    pub present_parts: *mut Bitmapset,
    pub nparts: ::std::os::raw::c_int,
    pub subplan_map: *mut ::std::os::raw::c_int,
    pub subpart_map: *mut ::std::os::raw::c_int,
    pub relid_map: *mut Oid,
    pub initial_pruning_steps: *mut List,
    pub exec_pruning_steps: *mut List,
    pub execparamids: *mut Bitmapset,
}
impl Default for PartitionedRelPruneInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStep {
    pub type_: NodeTag,
    pub step_id: ::std::os::raw::c_int,
}
impl Default for PartitionPruneStep {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStepOp {
    pub step: PartitionPruneStep,
    pub opstrategy: StrategyNumber,
    pub exprs: *mut List,
    pub cmpfns: *mut List,
    pub nullkeys: *mut Bitmapset,
}
impl Default for PartitionPruneStepOp {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const PartitionPruneCombineOp_PARTPRUNE_COMBINE_UNION: PartitionPruneCombineOp = 0;
pub const PartitionPruneCombineOp_PARTPRUNE_COMBINE_INTERSECT: PartitionPruneCombineOp = 1;
pub type PartitionPruneCombineOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStepCombine {
    pub step: PartitionPruneStep,
    pub combineOp: PartitionPruneCombineOp,
    pub source_stepids: *mut List,
}
impl Default for PartitionPruneStepCombine {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanInvalItem {
    pub type_: NodeTag,
    pub cacheId: ::std::os::raw::c_int,
    pub hashValue: uint32,
}
impl Default for PlanInvalItem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionBoundInfoData {
    _unused: [u8; 0],
}
pub type PartitionBoundInfo = *mut PartitionBoundInfoData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionKeyData {
    _unused: [u8; 0],
}
pub type PartitionKey = *mut PartitionKeyData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionDescData {
    _unused: [u8; 0],
}
pub type PartitionDesc = *mut PartitionDescData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionDirectoryData {
    _unused: [u8; 0],
}
pub type PartitionDirectory = *mut PartitionDirectoryData;
pub type HashValueFunc = ::std::option::Option<
    unsafe extern "C" fn(key: *const ::std::os::raw::c_void, keysize: Size) -> uint32,
>;
pub type HashCompareFunc = ::std::option::Option<
    unsafe extern "C" fn(
        key1: *const ::std::os::raw::c_void,
        key2: *const ::std::os::raw::c_void,
        keysize: Size,
    ) -> ::std::os::raw::c_int,
>;
pub type HashCopyFunc = ::std::option::Option<
    unsafe extern "C" fn(
        dest: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        keysize: Size,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type HashAllocFunc =
    ::std::option::Option<unsafe extern "C" fn(request: Size) -> *mut ::std::os::raw::c_void>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHELEMENT {
    pub link: *mut HASHELEMENT,
    pub hashvalue: uint32,
}
impl Default for HASHELEMENT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHHDR {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTAB {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHCTL {
    pub num_partitions: ::std::os::raw::c_long,
    pub ssize: ::std::os::raw::c_long,
    pub dsize: ::std::os::raw::c_long,
    pub max_dsize: ::std::os::raw::c_long,
    pub ffactor: ::std::os::raw::c_long,
    pub keysize: Size,
    pub entrysize: Size,
    pub hash: HashValueFunc,
    pub match_: HashCompareFunc,
    pub keycopy: HashCopyFunc,
    pub alloc: HashAllocFunc,
    pub hcxt: MemoryContext,
    pub hctl: *mut HASHHDR,
}
impl Default for HASHCTL {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const HASHACTION_HASH_FIND: HASHACTION = 0;
pub const HASHACTION_HASH_ENTER: HASHACTION = 1;
pub const HASHACTION_HASH_REMOVE: HASHACTION = 2;
pub const HASHACTION_HASH_ENTER_NULL: HASHACTION = 3;
pub type HASHACTION = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASH_SEQ_STATUS {
    pub hashp: *mut HTAB,
    pub curBucket: uint32,
    pub curEntry: *mut HASHELEMENT,
}
impl Default for HASH_SEQ_STATUS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn hash_create(
    arg_tabname: *const ::std::os::raw::c_char,
    arg_nelem: ::std::os::raw::c_long,
    arg_info: *mut HASHCTL,
    arg_flags: ::std::os::raw::c_int,
) -> *mut HTAB {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_create(
                arg_tabname: *const ::std::os::raw::c_char,
                arg_nelem: ::std::os::raw::c_long,
                arg_info: *mut HASHCTL,
                arg_flags: ::std::os::raw::c_int,
            ) -> *mut HTAB;
        }
        hash_create(arg_tabname, arg_nelem, arg_info, arg_flags)
    })
}
pub unsafe fn hash_destroy(arg_hashp: *mut HTAB) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_destroy(arg_hashp: *mut HTAB);
        }
        hash_destroy(arg_hashp)
    })
}
pub unsafe fn hash_stats(arg_where_: *const ::std::os::raw::c_char, arg_hashp: *mut HTAB) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_stats(arg_where_: *const ::std::os::raw::c_char, arg_hashp: *mut HTAB);
        }
        hash_stats(arg_where_, arg_hashp)
    })
}
pub unsafe fn hash_search(
    arg_hashp: *mut HTAB,
    arg_keyPtr: *const ::std::os::raw::c_void,
    arg_action: HASHACTION,
    arg_foundPtr: *mut bool,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_search(
                arg_hashp: *mut HTAB,
                arg_keyPtr: *const ::std::os::raw::c_void,
                arg_action: HASHACTION,
                arg_foundPtr: *mut bool,
            ) -> *mut ::std::os::raw::c_void;
        }
        hash_search(arg_hashp, arg_keyPtr, arg_action, arg_foundPtr)
    })
}
pub unsafe fn get_hash_value(
    arg_hashp: *mut HTAB,
    arg_keyPtr: *const ::std::os::raw::c_void,
) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_hash_value(
                arg_hashp: *mut HTAB,
                arg_keyPtr: *const ::std::os::raw::c_void,
            ) -> uint32;
        }
        get_hash_value(arg_hashp, arg_keyPtr)
    })
}
pub unsafe fn hash_search_with_hash_value(
    arg_hashp: *mut HTAB,
    arg_keyPtr: *const ::std::os::raw::c_void,
    arg_hashvalue: uint32,
    arg_action: HASHACTION,
    arg_foundPtr: *mut bool,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_search_with_hash_value(
                arg_hashp: *mut HTAB,
                arg_keyPtr: *const ::std::os::raw::c_void,
                arg_hashvalue: uint32,
                arg_action: HASHACTION,
                arg_foundPtr: *mut bool,
            ) -> *mut ::std::os::raw::c_void;
        }
        hash_search_with_hash_value(
            arg_hashp,
            arg_keyPtr,
            arg_hashvalue,
            arg_action,
            arg_foundPtr,
        )
    })
}
pub unsafe fn hash_update_hash_key(
    arg_hashp: *mut HTAB,
    arg_existingEntry: *mut ::std::os::raw::c_void,
    arg_newKeyPtr: *const ::std::os::raw::c_void,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_update_hash_key(
                arg_hashp: *mut HTAB,
                arg_existingEntry: *mut ::std::os::raw::c_void,
                arg_newKeyPtr: *const ::std::os::raw::c_void,
            ) -> bool;
        }
        hash_update_hash_key(arg_hashp, arg_existingEntry, arg_newKeyPtr)
    })
}
pub unsafe fn hash_get_num_entries(arg_hashp: *mut HTAB) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_get_num_entries(arg_hashp: *mut HTAB) -> ::std::os::raw::c_long;
        }
        hash_get_num_entries(arg_hashp)
    })
}
pub unsafe fn hash_seq_init(arg_status: *mut HASH_SEQ_STATUS, arg_hashp: *mut HTAB) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_seq_init(arg_status: *mut HASH_SEQ_STATUS, arg_hashp: *mut HTAB);
        }
        hash_seq_init(arg_status, arg_hashp)
    })
}
pub unsafe fn hash_seq_search(arg_status: *mut HASH_SEQ_STATUS) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_seq_search(arg_status: *mut HASH_SEQ_STATUS) -> *mut ::std::os::raw::c_void;
        }
        hash_seq_search(arg_status)
    })
}
pub unsafe fn hash_seq_term(arg_status: *mut HASH_SEQ_STATUS) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_seq_term(arg_status: *mut HASH_SEQ_STATUS);
        }
        hash_seq_term(arg_status)
    })
}
pub unsafe fn hash_freeze(arg_hashp: *mut HTAB) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_freeze(arg_hashp: *mut HTAB);
        }
        hash_freeze(arg_hashp)
    })
}
pub unsafe fn hash_estimate_size(
    arg_num_entries: ::std::os::raw::c_long,
    arg_entrysize: Size,
) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_estimate_size(
                arg_num_entries: ::std::os::raw::c_long,
                arg_entrysize: Size,
            ) -> Size;
        }
        hash_estimate_size(arg_num_entries, arg_entrysize)
    })
}
pub unsafe fn hash_select_dirsize(
    arg_num_entries: ::std::os::raw::c_long,
) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_select_dirsize(
                arg_num_entries: ::std::os::raw::c_long,
            ) -> ::std::os::raw::c_long;
        }
        hash_select_dirsize(arg_num_entries)
    })
}
pub unsafe fn hash_get_shared_size(
    arg_info: *mut HASHCTL,
    arg_flags: ::std::os::raw::c_int,
) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_get_shared_size(
                arg_info: *mut HASHCTL,
                arg_flags: ::std::os::raw::c_int,
            ) -> Size;
        }
        hash_get_shared_size(arg_info, arg_flags)
    })
}
pub unsafe fn AtEOXact_HashTables(arg_isCommit: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOXact_HashTables(arg_isCommit: bool);
        }
        AtEOXact_HashTables(arg_isCommit)
    })
}
pub unsafe fn AtEOSubXact_HashTables(arg_isCommit: bool, arg_nestDepth: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOSubXact_HashTables(arg_isCommit: bool, arg_nestDepth: ::std::os::raw::c_int);
        }
        AtEOSubXact_HashTables(arg_isCommit, arg_nestDepth)
    })
}
pub unsafe fn string_hash(arg_key: *const ::std::os::raw::c_void, arg_keysize: Size) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn string_hash(arg_key: *const ::std::os::raw::c_void, arg_keysize: Size) -> uint32;
        }
        string_hash(arg_key, arg_keysize)
    })
}
pub unsafe fn tag_hash(arg_key: *const ::std::os::raw::c_void, arg_keysize: Size) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tag_hash(arg_key: *const ::std::os::raw::c_void, arg_keysize: Size) -> uint32;
        }
        tag_hash(arg_key, arg_keysize)
    })
}
pub unsafe fn uint32_hash(arg_key: *const ::std::os::raw::c_void, arg_keysize: Size) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn uint32_hash(arg_key: *const ::std::os::raw::c_void, arg_keysize: Size) -> uint32;
        }
        uint32_hash(arg_key, arg_keysize)
    })
}
pub unsafe fn bitmap_hash(arg_key: *const ::std::os::raw::c_void, arg_keysize: Size) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bitmap_hash(arg_key: *const ::std::os::raw::c_void, arg_keysize: Size) -> uint32;
        }
        bitmap_hash(arg_key, arg_keysize)
    })
}
pub unsafe fn bitmap_match(
    arg_key1: *const ::std::os::raw::c_void,
    arg_key2: *const ::std::os::raw::c_void,
    arg_keysize: Size,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bitmap_match(
                arg_key1: *const ::std::os::raw::c_void,
                arg_key2: *const ::std::os::raw::c_void,
                arg_keysize: Size,
            ) -> ::std::os::raw::c_int;
        }
        bitmap_match(arg_key1, arg_key2, arg_keysize)
    })
}
pub const EphemeralNameRelationType_ENR_NAMED_TUPLESTORE: EphemeralNameRelationType = 0;
pub type EphemeralNameRelationType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EphemeralNamedRelationMetadataData {
    pub name: *mut ::std::os::raw::c_char,
    pub reliddesc: Oid,
    pub tupdesc: TupleDesc,
    pub enrtype: EphemeralNameRelationType,
    pub enrtuples: f64,
}
impl Default for EphemeralNamedRelationMetadataData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EphemeralNamedRelationMetadata = *mut EphemeralNamedRelationMetadataData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EphemeralNamedRelationData {
    pub md: EphemeralNamedRelationMetadataData,
    pub reldata: *mut ::std::os::raw::c_void,
}
impl Default for EphemeralNamedRelationData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EphemeralNamedRelation = *mut EphemeralNamedRelationData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryEnvironment {
    _unused: [u8; 0],
}
pub unsafe fn create_queryEnv() -> *mut QueryEnvironment {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn create_queryEnv() -> *mut QueryEnvironment;
        }
        create_queryEnv()
    })
}
pub unsafe fn get_visible_ENR_metadata(
    arg_queryEnv: *mut QueryEnvironment,
    arg_refname: *const ::std::os::raw::c_char,
) -> EphemeralNamedRelationMetadata {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_visible_ENR_metadata(
                arg_queryEnv: *mut QueryEnvironment,
                arg_refname: *const ::std::os::raw::c_char,
            ) -> EphemeralNamedRelationMetadata;
        }
        get_visible_ENR_metadata(arg_queryEnv, arg_refname)
    })
}
pub unsafe fn register_ENR(arg_queryEnv: *mut QueryEnvironment, arg_enr: EphemeralNamedRelation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn register_ENR(arg_queryEnv: *mut QueryEnvironment, arg_enr: EphemeralNamedRelation);
        }
        register_ENR(arg_queryEnv, arg_enr)
    })
}
pub unsafe fn unregister_ENR(
    arg_queryEnv: *mut QueryEnvironment,
    arg_name: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn unregister_ENR(
                arg_queryEnv: *mut QueryEnvironment,
                arg_name: *const ::std::os::raw::c_char,
            );
        }
        unregister_ENR(arg_queryEnv, arg_name)
    })
}
pub unsafe fn get_ENR(
    arg_queryEnv: *mut QueryEnvironment,
    arg_name: *const ::std::os::raw::c_char,
) -> EphemeralNamedRelation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_ENR(
                arg_queryEnv: *mut QueryEnvironment,
                arg_name: *const ::std::os::raw::c_char,
            ) -> EphemeralNamedRelation;
        }
        get_ENR(arg_queryEnv, arg_name)
    })
}
pub unsafe fn ENRMetadataGetTupDesc(arg_enrmd: EphemeralNamedRelationMetadata) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ENRMetadataGetTupDesc(arg_enrmd: EphemeralNamedRelationMetadata) -> TupleDesc;
        }
        ENRMetadataGetTupDesc(arg_enrmd)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Trigger {
    pub tgoid: Oid,
    pub tgname: *mut ::std::os::raw::c_char,
    pub tgfoid: Oid,
    pub tgtype: int16,
    pub tgenabled: ::std::os::raw::c_char,
    pub tgisinternal: bool,
    pub tgconstrrelid: Oid,
    pub tgconstrindid: Oid,
    pub tgconstraint: Oid,
    pub tgdeferrable: bool,
    pub tginitdeferred: bool,
    pub tgnargs: int16,
    pub tgnattr: int16,
    pub tgattr: *mut int16,
    pub tgargs: *mut *mut ::std::os::raw::c_char,
    pub tgqual: *mut ::std::os::raw::c_char,
    pub tgoldtable: *mut ::std::os::raw::c_char,
    pub tgnewtable: *mut ::std::os::raw::c_char,
}
impl Default for Trigger {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TriggerDesc {
    pub triggers: *mut Trigger,
    pub numtriggers: ::std::os::raw::c_int,
    pub trig_insert_before_row: bool,
    pub trig_insert_after_row: bool,
    pub trig_insert_instead_row: bool,
    pub trig_insert_before_statement: bool,
    pub trig_insert_after_statement: bool,
    pub trig_update_before_row: bool,
    pub trig_update_after_row: bool,
    pub trig_update_instead_row: bool,
    pub trig_update_before_statement: bool,
    pub trig_update_after_statement: bool,
    pub trig_delete_before_row: bool,
    pub trig_delete_after_row: bool,
    pub trig_delete_instead_row: bool,
    pub trig_delete_before_statement: bool,
    pub trig_delete_after_statement: bool,
    pub trig_truncate_before_statement: bool,
    pub trig_truncate_after_statement: bool,
    pub trig_insert_new_table: bool,
    pub trig_update_old_table: bool,
    pub trig_update_new_table: bool,
    pub trig_delete_old_table: bool,
}
impl Default for TriggerDesc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dirent {
    pub d_ino: __ino_t,
    pub d_off: __off_t,
    pub d_reclen: ::std::os::raw::c_ushort,
    pub d_type: ::std::os::raw::c_uchar,
    pub d_name: [::std::os::raw::c_char; 256usize],
}
impl Default for dirent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DT_UNKNOWN: ::std::os::raw::c_uint = 0;
pub const DT_FIFO: ::std::os::raw::c_uint = 1;
pub const DT_CHR: ::std::os::raw::c_uint = 2;
pub const DT_DIR: ::std::os::raw::c_uint = 4;
pub const DT_BLK: ::std::os::raw::c_uint = 6;
pub const DT_REG: ::std::os::raw::c_uint = 8;
pub const DT_LNK: ::std::os::raw::c_uint = 10;
pub const DT_SOCK: ::std::os::raw::c_uint = 12;
pub const DT_WHT: ::std::os::raw::c_uint = 14;
pub type _bindgen_ty_9 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __dirstream {
    _unused: [u8; 0],
}
pub type DIR = __dirstream;
pub unsafe fn closedir(arg___dirp: *mut DIR) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn closedir(arg___dirp: *mut DIR) -> ::std::os::raw::c_int;
        }
        closedir(arg___dirp)
    })
}
pub unsafe fn opendir(arg___name: *const ::std::os::raw::c_char) -> *mut DIR {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn opendir(arg___name: *const ::std::os::raw::c_char) -> *mut DIR;
        }
        opendir(arg___name)
    })
}
pub unsafe fn fdopendir(arg___fd: ::std::os::raw::c_int) -> *mut DIR {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fdopendir(arg___fd: ::std::os::raw::c_int) -> *mut DIR;
        }
        fdopendir(arg___fd)
    })
}
pub unsafe fn readdir(arg___dirp: *mut DIR) -> *mut dirent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readdir(arg___dirp: *mut DIR) -> *mut dirent;
        }
        readdir(arg___dirp)
    })
}
pub unsafe fn readdir_r(
    arg___dirp: *mut DIR,
    arg___entry: *mut dirent,
    arg___result: *mut *mut dirent,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readdir_r(
                arg___dirp: *mut DIR,
                arg___entry: *mut dirent,
                arg___result: *mut *mut dirent,
            ) -> ::std::os::raw::c_int;
        }
        readdir_r(arg___dirp, arg___entry, arg___result)
    })
}
pub unsafe fn rewinddir(arg___dirp: *mut DIR) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rewinddir(arg___dirp: *mut DIR);
        }
        rewinddir(arg___dirp)
    })
}
pub unsafe fn seekdir(arg___dirp: *mut DIR, arg___pos: ::std::os::raw::c_long) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn seekdir(arg___dirp: *mut DIR, arg___pos: ::std::os::raw::c_long);
        }
        seekdir(arg___dirp, arg___pos)
    })
}
pub unsafe fn telldir(arg___dirp: *mut DIR) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn telldir(arg___dirp: *mut DIR) -> ::std::os::raw::c_long;
        }
        telldir(arg___dirp)
    })
}
pub unsafe fn dirfd(arg___dirp: *mut DIR) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dirfd(arg___dirp: *mut DIR) -> ::std::os::raw::c_int;
        }
        dirfd(arg___dirp)
    })
}
pub unsafe fn scandir(
    arg___dir: *const ::std::os::raw::c_char,
    arg___namelist: *mut *mut *mut dirent,
    arg___selector: ::std::option::Option<
        unsafe extern "C" fn(arg1: *const dirent) -> ::std::os::raw::c_int,
    >,
    arg___cmp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut *const dirent,
            arg2: *mut *const dirent,
        ) -> ::std::os::raw::c_int,
    >,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn scandir(
                arg___dir: *const ::std::os::raw::c_char,
                arg___namelist: *mut *mut *mut dirent,
                arg___selector: ::std::option::Option<
                    unsafe extern "C" fn(arg1: *const dirent) -> ::std::os::raw::c_int,
                >,
                arg___cmp: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *mut *const dirent,
                        arg2: *mut *const dirent,
                    ) -> ::std::os::raw::c_int,
                >,
            ) -> ::std::os::raw::c_int;
        }
        scandir(arg___dir, arg___namelist, arg___selector, arg___cmp)
    })
}
pub unsafe fn alphasort(
    arg___e1: *mut *const dirent,
    arg___e2: *mut *const dirent,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn alphasort(
                arg___e1: *mut *const dirent,
                arg___e2: *mut *const dirent,
            ) -> ::std::os::raw::c_int;
        }
        alphasort(arg___e1, arg___e2)
    })
}
pub unsafe fn getdirentries(
    arg___fd: ::std::os::raw::c_int,
    arg___buf: *mut ::std::os::raw::c_char,
    arg___nbytes: usize,
    arg___basep: *mut __off_t,
) -> __ssize_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getdirentries(
                arg___fd: ::std::os::raw::c_int,
                arg___buf: *mut ::std::os::raw::c_char,
                arg___nbytes: usize,
                arg___basep: *mut __off_t,
            ) -> __ssize_t;
        }
        getdirentries(arg___fd, arg___buf, arg___nbytes, arg___basep)
    })
}
pub type File = ::std::os::raw::c_int;
extern "C" {
    pub static mut max_files_per_process: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut data_sync_retry: bool;
}
extern "C" {
    pub static mut max_safe_fds: ::std::os::raw::c_int;
}
pub unsafe fn PathNameOpenFile(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameOpenFile(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
            ) -> File;
        }
        PathNameOpenFile(arg_fileName, arg_fileFlags)
    })
}
pub unsafe fn PathNameOpenFilePerm(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
    arg_fileMode: mode_t,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameOpenFilePerm(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
                arg_fileMode: mode_t,
            ) -> File;
        }
        PathNameOpenFilePerm(arg_fileName, arg_fileFlags, arg_fileMode)
    })
}
pub unsafe fn OpenTemporaryFile(arg_interXact: bool) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OpenTemporaryFile(arg_interXact: bool) -> File;
        }
        OpenTemporaryFile(arg_interXact)
    })
}
pub unsafe fn FileClose(arg_file: File) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileClose(arg_file: File);
        }
        FileClose(arg_file)
    })
}
pub unsafe fn FilePrefetch(
    arg_file: File,
    arg_offset: off_t,
    arg_amount: ::std::os::raw::c_int,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FilePrefetch(
                arg_file: File,
                arg_offset: off_t,
                arg_amount: ::std::os::raw::c_int,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        FilePrefetch(arg_file, arg_offset, arg_amount, arg_wait_event_info)
    })
}
pub unsafe fn FileRead(
    arg_file: File,
    arg_buffer: *mut ::std::os::raw::c_char,
    arg_amount: ::std::os::raw::c_int,
    arg_offset: off_t,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileRead(
                arg_file: File,
                arg_buffer: *mut ::std::os::raw::c_char,
                arg_amount: ::std::os::raw::c_int,
                arg_offset: off_t,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        FileRead(
            arg_file,
            arg_buffer,
            arg_amount,
            arg_offset,
            arg_wait_event_info,
        )
    })
}
pub unsafe fn FileWrite(
    arg_file: File,
    arg_buffer: *mut ::std::os::raw::c_char,
    arg_amount: ::std::os::raw::c_int,
    arg_offset: off_t,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileWrite(
                arg_file: File,
                arg_buffer: *mut ::std::os::raw::c_char,
                arg_amount: ::std::os::raw::c_int,
                arg_offset: off_t,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        FileWrite(
            arg_file,
            arg_buffer,
            arg_amount,
            arg_offset,
            arg_wait_event_info,
        )
    })
}
pub unsafe fn FileSync(arg_file: File, arg_wait_event_info: uint32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileSync(arg_file: File, arg_wait_event_info: uint32) -> ::std::os::raw::c_int;
        }
        FileSync(arg_file, arg_wait_event_info)
    })
}
pub unsafe fn FileSize(arg_file: File) -> off_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileSize(arg_file: File) -> off_t;
        }
        FileSize(arg_file)
    })
}
pub unsafe fn FileTruncate(
    arg_file: File,
    arg_offset: off_t,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileTruncate(
                arg_file: File,
                arg_offset: off_t,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        FileTruncate(arg_file, arg_offset, arg_wait_event_info)
    })
}
pub unsafe fn FileWriteback(
    arg_file: File,
    arg_offset: off_t,
    arg_nbytes: off_t,
    arg_wait_event_info: uint32,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileWriteback(
                arg_file: File,
                arg_offset: off_t,
                arg_nbytes: off_t,
                arg_wait_event_info: uint32,
            );
        }
        FileWriteback(arg_file, arg_offset, arg_nbytes, arg_wait_event_info)
    })
}
pub unsafe fn FilePathName(arg_file: File) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FilePathName(arg_file: File) -> *mut ::std::os::raw::c_char;
        }
        FilePathName(arg_file)
    })
}
pub unsafe fn FileGetRawDesc(arg_file: File) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileGetRawDesc(arg_file: File) -> ::std::os::raw::c_int;
        }
        FileGetRawDesc(arg_file)
    })
}
pub unsafe fn FileGetRawFlags(arg_file: File) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileGetRawFlags(arg_file: File) -> ::std::os::raw::c_int;
        }
        FileGetRawFlags(arg_file)
    })
}
pub unsafe fn FileGetRawMode(arg_file: File) -> mode_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileGetRawMode(arg_file: File) -> mode_t;
        }
        FileGetRawMode(arg_file)
    })
}
pub unsafe fn PathNameCreateTemporaryFile(
    arg_name: *const ::std::os::raw::c_char,
    arg_error_on_failure: bool,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameCreateTemporaryFile(
                arg_name: *const ::std::os::raw::c_char,
                arg_error_on_failure: bool,
            ) -> File;
        }
        PathNameCreateTemporaryFile(arg_name, arg_error_on_failure)
    })
}
pub unsafe fn PathNameOpenTemporaryFile(arg_name: *const ::std::os::raw::c_char) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameOpenTemporaryFile(arg_name: *const ::std::os::raw::c_char) -> File;
        }
        PathNameOpenTemporaryFile(arg_name)
    })
}
pub unsafe fn PathNameDeleteTemporaryFile(
    arg_name: *const ::std::os::raw::c_char,
    arg_error_on_failure: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameDeleteTemporaryFile(
                arg_name: *const ::std::os::raw::c_char,
                arg_error_on_failure: bool,
            ) -> bool;
        }
        PathNameDeleteTemporaryFile(arg_name, arg_error_on_failure)
    })
}
pub unsafe fn PathNameCreateTemporaryDir(
    arg_base: *const ::std::os::raw::c_char,
    arg_name: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameCreateTemporaryDir(
                arg_base: *const ::std::os::raw::c_char,
                arg_name: *const ::std::os::raw::c_char,
            );
        }
        PathNameCreateTemporaryDir(arg_base, arg_name)
    })
}
pub unsafe fn PathNameDeleteTemporaryDir(arg_name: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameDeleteTemporaryDir(arg_name: *const ::std::os::raw::c_char);
        }
        PathNameDeleteTemporaryDir(arg_name)
    })
}
pub unsafe fn TempTablespacePath(arg_path: *mut ::std::os::raw::c_char, arg_tablespace: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TempTablespacePath(arg_path: *mut ::std::os::raw::c_char, arg_tablespace: Oid);
        }
        TempTablespacePath(arg_path, arg_tablespace)
    })
}
pub unsafe fn AllocateFile(
    arg_name: *const ::std::os::raw::c_char,
    arg_mode: *const ::std::os::raw::c_char,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AllocateFile(
                arg_name: *const ::std::os::raw::c_char,
                arg_mode: *const ::std::os::raw::c_char,
            ) -> *mut FILE;
        }
        AllocateFile(arg_name, arg_mode)
    })
}
pub unsafe fn FreeFile(arg_file: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeFile(arg_file: *mut FILE) -> ::std::os::raw::c_int;
        }
        FreeFile(arg_file)
    })
}
pub unsafe fn OpenPipeStream(
    arg_command: *const ::std::os::raw::c_char,
    arg_mode: *const ::std::os::raw::c_char,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OpenPipeStream(
                arg_command: *const ::std::os::raw::c_char,
                arg_mode: *const ::std::os::raw::c_char,
            ) -> *mut FILE;
        }
        OpenPipeStream(arg_command, arg_mode)
    })
}
pub unsafe fn ClosePipeStream(arg_file: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ClosePipeStream(arg_file: *mut FILE) -> ::std::os::raw::c_int;
        }
        ClosePipeStream(arg_file)
    })
}
pub unsafe fn AllocateDir(arg_dirname: *const ::std::os::raw::c_char) -> *mut DIR {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AllocateDir(arg_dirname: *const ::std::os::raw::c_char) -> *mut DIR;
        }
        AllocateDir(arg_dirname)
    })
}
pub unsafe fn ReadDir(
    arg_dir: *mut DIR,
    arg_dirname: *const ::std::os::raw::c_char,
) -> *mut dirent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReadDir(
                arg_dir: *mut DIR,
                arg_dirname: *const ::std::os::raw::c_char,
            ) -> *mut dirent;
        }
        ReadDir(arg_dir, arg_dirname)
    })
}
pub unsafe fn ReadDirExtended(
    arg_dir: *mut DIR,
    arg_dirname: *const ::std::os::raw::c_char,
    arg_elevel: ::std::os::raw::c_int,
) -> *mut dirent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReadDirExtended(
                arg_dir: *mut DIR,
                arg_dirname: *const ::std::os::raw::c_char,
                arg_elevel: ::std::os::raw::c_int,
            ) -> *mut dirent;
        }
        ReadDirExtended(arg_dir, arg_dirname, arg_elevel)
    })
}
pub unsafe fn FreeDir(arg_dir: *mut DIR) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeDir(arg_dir: *mut DIR) -> ::std::os::raw::c_int;
        }
        FreeDir(arg_dir)
    })
}
pub unsafe fn OpenTransientFile(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OpenTransientFile(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        OpenTransientFile(arg_fileName, arg_fileFlags)
    })
}
pub unsafe fn OpenTransientFilePerm(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
    arg_fileMode: mode_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OpenTransientFilePerm(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
                arg_fileMode: mode_t,
            ) -> ::std::os::raw::c_int;
        }
        OpenTransientFilePerm(arg_fileName, arg_fileFlags, arg_fileMode)
    })
}
pub unsafe fn CloseTransientFile(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CloseTransientFile(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        CloseTransientFile(arg_fd)
    })
}
pub unsafe fn BasicOpenFile(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BasicOpenFile(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        BasicOpenFile(arg_fileName, arg_fileFlags)
    })
}
pub unsafe fn BasicOpenFilePerm(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
    arg_fileMode: mode_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BasicOpenFilePerm(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
                arg_fileMode: mode_t,
            ) -> ::std::os::raw::c_int;
        }
        BasicOpenFilePerm(arg_fileName, arg_fileFlags, arg_fileMode)
    })
}
pub unsafe fn MakePGDirectory(
    arg_directoryName: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MakePGDirectory(
                arg_directoryName: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        MakePGDirectory(arg_directoryName)
    })
}
pub unsafe fn InitFileAccess() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitFileAccess();
        }
        InitFileAccess()
    })
}
pub unsafe fn set_max_safe_fds() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_max_safe_fds();
        }
        set_max_safe_fds()
    })
}
pub unsafe fn closeAllVfds() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn closeAllVfds();
        }
        closeAllVfds()
    })
}
pub unsafe fn SetTempTablespaces(arg_tableSpaces: *mut Oid, arg_numSpaces: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SetTempTablespaces(arg_tableSpaces: *mut Oid, arg_numSpaces: ::std::os::raw::c_int);
        }
        SetTempTablespaces(arg_tableSpaces, arg_numSpaces)
    })
}
pub unsafe fn TempTablespacesAreSet() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TempTablespacesAreSet() -> bool;
        }
        TempTablespacesAreSet()
    })
}
pub unsafe fn GetTempTablespaces(
    arg_tableSpaces: *mut Oid,
    arg_numSpaces: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetTempTablespaces(
                arg_tableSpaces: *mut Oid,
                arg_numSpaces: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        GetTempTablespaces(arg_tableSpaces, arg_numSpaces)
    })
}
pub unsafe fn GetNextTempTableSpace() -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetNextTempTableSpace() -> Oid;
        }
        GetNextTempTableSpace()
    })
}
pub unsafe fn AtEOXact_Files(arg_isCommit: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOXact_Files(arg_isCommit: bool);
        }
        AtEOXact_Files(arg_isCommit)
    })
}
pub unsafe fn AtEOSubXact_Files(
    arg_isCommit: bool,
    arg_mySubid: SubTransactionId,
    arg_parentSubid: SubTransactionId,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOSubXact_Files(
                arg_isCommit: bool,
                arg_mySubid: SubTransactionId,
                arg_parentSubid: SubTransactionId,
            );
        }
        AtEOSubXact_Files(arg_isCommit, arg_mySubid, arg_parentSubid)
    })
}
pub unsafe fn RemovePgTempFiles() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RemovePgTempFiles();
        }
        RemovePgTempFiles()
    })
}
pub unsafe fn looks_like_temp_rel_name(arg_name: *const ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn looks_like_temp_rel_name(arg_name: *const ::std::os::raw::c_char) -> bool;
        }
        looks_like_temp_rel_name(arg_name)
    })
}
pub unsafe fn pg_fsync(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fsync(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        pg_fsync(arg_fd)
    })
}
pub unsafe fn pg_fsync_no_writethrough(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fsync_no_writethrough(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        pg_fsync_no_writethrough(arg_fd)
    })
}
pub unsafe fn pg_fsync_writethrough(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fsync_writethrough(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        pg_fsync_writethrough(arg_fd)
    })
}
pub unsafe fn pg_fdatasync(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fdatasync(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        pg_fdatasync(arg_fd)
    })
}
pub unsafe fn pg_flush_data(arg_fd: ::std::os::raw::c_int, arg_offset: off_t, arg_amount: off_t) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_flush_data(arg_fd: ::std::os::raw::c_int, arg_offset: off_t, arg_amount: off_t);
        }
        pg_flush_data(arg_fd, arg_offset, arg_amount)
    })
}
pub unsafe fn fsync_fname(arg_fname: *const ::std::os::raw::c_char, arg_isdir: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fsync_fname(arg_fname: *const ::std::os::raw::c_char, arg_isdir: bool);
        }
        fsync_fname(arg_fname, arg_isdir)
    })
}
pub unsafe fn durable_rename(
    arg_oldfile: *const ::std::os::raw::c_char,
    arg_newfile: *const ::std::os::raw::c_char,
    arg_loglevel: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn durable_rename(
                arg_oldfile: *const ::std::os::raw::c_char,
                arg_newfile: *const ::std::os::raw::c_char,
                arg_loglevel: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        durable_rename(arg_oldfile, arg_newfile, arg_loglevel)
    })
}
pub unsafe fn durable_unlink(
    arg_fname: *const ::std::os::raw::c_char,
    arg_loglevel: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn durable_unlink(
                arg_fname: *const ::std::os::raw::c_char,
                arg_loglevel: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        durable_unlink(arg_fname, arg_loglevel)
    })
}
pub unsafe fn durable_link_or_rename(
    arg_oldfile: *const ::std::os::raw::c_char,
    arg_newfile: *const ::std::os::raw::c_char,
    arg_loglevel: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn durable_link_or_rename(
                arg_oldfile: *const ::std::os::raw::c_char,
                arg_newfile: *const ::std::os::raw::c_char,
                arg_loglevel: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        durable_link_or_rename(arg_oldfile, arg_newfile, arg_loglevel)
    })
}
pub unsafe fn SyncDataDirectory() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SyncDataDirectory();
        }
        SyncDataDirectory()
    })
}
pub unsafe fn data_sync_elevel(arg_elevel: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn data_sync_elevel(arg_elevel: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        data_sync_elevel(arg_elevel)
    })
}
extern "C" {
    pub static mut dynamic_shared_memory_type: ::std::os::raw::c_int;
}
pub type dsm_handle = uint32;
pub const dsm_op_DSM_OP_CREATE: dsm_op = 0;
pub const dsm_op_DSM_OP_ATTACH: dsm_op = 1;
pub const dsm_op_DSM_OP_DETACH: dsm_op = 2;
pub const dsm_op_DSM_OP_DESTROY: dsm_op = 3;
pub type dsm_op = ::std::os::raw::c_uint;
pub unsafe fn dsm_impl_op(
    arg_op: dsm_op,
    arg_handle: dsm_handle,
    arg_request_size: Size,
    arg_impl_private: *mut *mut ::std::os::raw::c_void,
    arg_mapped_address: *mut *mut ::std::os::raw::c_void,
    arg_mapped_size: *mut Size,
    arg_elevel: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_impl_op(
                arg_op: dsm_op,
                arg_handle: dsm_handle,
                arg_request_size: Size,
                arg_impl_private: *mut *mut ::std::os::raw::c_void,
                arg_mapped_address: *mut *mut ::std::os::raw::c_void,
                arg_mapped_size: *mut Size,
                arg_elevel: ::std::os::raw::c_int,
            ) -> bool;
        }
        dsm_impl_op(
            arg_op,
            arg_handle,
            arg_request_size,
            arg_impl_private,
            arg_mapped_address,
            arg_mapped_size,
            arg_elevel,
        )
    })
}
pub unsafe fn dsm_impl_pin_segment(
    arg_handle: dsm_handle,
    arg_impl_private: *mut ::std::os::raw::c_void,
    arg_impl_private_pm_handle: *mut *mut ::std::os::raw::c_void,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_impl_pin_segment(
                arg_handle: dsm_handle,
                arg_impl_private: *mut ::std::os::raw::c_void,
                arg_impl_private_pm_handle: *mut *mut ::std::os::raw::c_void,
            );
        }
        dsm_impl_pin_segment(arg_handle, arg_impl_private, arg_impl_private_pm_handle)
    })
}
pub unsafe fn dsm_impl_unpin_segment(
    arg_handle: dsm_handle,
    arg_impl_private: *mut *mut ::std::os::raw::c_void,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_impl_unpin_segment(
                arg_handle: dsm_handle,
                arg_impl_private: *mut *mut ::std::os::raw::c_void,
            );
        }
        dsm_impl_unpin_segment(arg_handle, arg_impl_private)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dsm_segment {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PGShmemHeader {
    _unused: [u8; 0],
}
pub unsafe fn dsm_cleanup_using_control_segment(arg_old_control_handle: dsm_handle) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_cleanup_using_control_segment(arg_old_control_handle: dsm_handle);
        }
        dsm_cleanup_using_control_segment(arg_old_control_handle)
    })
}
pub unsafe fn dsm_postmaster_startup(arg_arg1: *mut PGShmemHeader) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_postmaster_startup(arg_arg1: *mut PGShmemHeader);
        }
        dsm_postmaster_startup(arg_arg1)
    })
}
pub unsafe fn dsm_backend_shutdown() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_backend_shutdown();
        }
        dsm_backend_shutdown()
    })
}
pub unsafe fn dsm_detach_all() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_detach_all();
        }
        dsm_detach_all()
    })
}
pub unsafe fn dsm_create(arg_size: Size, arg_flags: ::std::os::raw::c_int) -> *mut dsm_segment {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_create(arg_size: Size, arg_flags: ::std::os::raw::c_int) -> *mut dsm_segment;
        }
        dsm_create(arg_size, arg_flags)
    })
}
pub unsafe fn dsm_attach(arg_h: dsm_handle) -> *mut dsm_segment {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_attach(arg_h: dsm_handle) -> *mut dsm_segment;
        }
        dsm_attach(arg_h)
    })
}
pub unsafe fn dsm_detach(arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_detach(arg_seg: *mut dsm_segment);
        }
        dsm_detach(arg_seg)
    })
}
pub unsafe fn dsm_pin_mapping(arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_pin_mapping(arg_seg: *mut dsm_segment);
        }
        dsm_pin_mapping(arg_seg)
    })
}
pub unsafe fn dsm_unpin_mapping(arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_unpin_mapping(arg_seg: *mut dsm_segment);
        }
        dsm_unpin_mapping(arg_seg)
    })
}
pub unsafe fn dsm_pin_segment(arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_pin_segment(arg_seg: *mut dsm_segment);
        }
        dsm_pin_segment(arg_seg)
    })
}
pub unsafe fn dsm_unpin_segment(arg_h: dsm_handle) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_unpin_segment(arg_h: dsm_handle);
        }
        dsm_unpin_segment(arg_h)
    })
}
pub unsafe fn dsm_find_mapping(arg_h: dsm_handle) -> *mut dsm_segment {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_find_mapping(arg_h: dsm_handle) -> *mut dsm_segment;
        }
        dsm_find_mapping(arg_h)
    })
}
pub unsafe fn dsm_segment_address(arg_seg: *mut dsm_segment) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_segment_address(arg_seg: *mut dsm_segment) -> *mut ::std::os::raw::c_void;
        }
        dsm_segment_address(arg_seg)
    })
}
pub unsafe fn dsm_segment_map_length(arg_seg: *mut dsm_segment) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_segment_map_length(arg_seg: *mut dsm_segment) -> Size;
        }
        dsm_segment_map_length(arg_seg)
    })
}
pub unsafe fn dsm_segment_handle(arg_seg: *mut dsm_segment) -> dsm_handle {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_segment_handle(arg_seg: *mut dsm_segment) -> dsm_handle;
        }
        dsm_segment_handle(arg_seg)
    })
}
pub type on_dsm_detach_callback =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut dsm_segment, arg: Datum)>;
pub unsafe fn on_dsm_detach(
    arg_seg: *mut dsm_segment,
    arg_function: on_dsm_detach_callback,
    arg_arg: Datum,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn on_dsm_detach(
                arg_seg: *mut dsm_segment,
                arg_function: on_dsm_detach_callback,
                arg_arg: Datum,
            );
        }
        on_dsm_detach(arg_seg, arg_function, arg_arg)
    })
}
pub unsafe fn cancel_on_dsm_detach(
    arg_seg: *mut dsm_segment,
    arg_function: on_dsm_detach_callback,
    arg_arg: Datum,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cancel_on_dsm_detach(
                arg_seg: *mut dsm_segment,
                arg_function: on_dsm_detach_callback,
                arg_arg: Datum,
            );
        }
        cancel_on_dsm_detach(arg_seg, arg_function, arg_arg)
    })
}
pub unsafe fn reset_on_dsm_detach() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn reset_on_dsm_detach();
        }
        reset_on_dsm_detach()
    })
}
pub type slock_t = ::std::os::raw::c_uchar;
extern "C" {
    pub static mut dummy_spinlock: slock_t;
}
pub unsafe fn s_lock(
    arg_lock: *mut slock_t,
    arg_file: *const ::std::os::raw::c_char,
    arg_line: ::std::os::raw::c_int,
    arg_func: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn s_lock(
                arg_lock: *mut slock_t,
                arg_file: *const ::std::os::raw::c_char,
                arg_line: ::std::os::raw::c_int,
                arg_func: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        s_lock(arg_lock, arg_file, arg_line, arg_func)
    })
}
pub unsafe fn set_spins_per_delay(arg_shared_spins_per_delay: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_spins_per_delay(arg_shared_spins_per_delay: ::std::os::raw::c_int);
        }
        set_spins_per_delay(arg_shared_spins_per_delay)
    })
}
pub unsafe fn update_spins_per_delay(
    arg_shared_spins_per_delay: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn update_spins_per_delay(
                arg_shared_spins_per_delay: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        update_spins_per_delay(arg_shared_spins_per_delay)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpinDelayStatus {
    pub spins: ::std::os::raw::c_int,
    pub delays: ::std::os::raw::c_int,
    pub cur_delay: ::std::os::raw::c_int,
    pub file: *const ::std::os::raw::c_char,
    pub line: ::std::os::raw::c_int,
    pub func: *const ::std::os::raw::c_char,
}
impl Default for SpinDelayStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn perform_spin_delay(arg_status: *mut SpinDelayStatus) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn perform_spin_delay(arg_status: *mut SpinDelayStatus);
        }
        perform_spin_delay(arg_status)
    })
}
pub unsafe fn finish_spin_delay(arg_status: *mut SpinDelayStatus) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn finish_spin_delay(arg_status: *mut SpinDelayStatus);
        }
        finish_spin_delay(arg_status)
    })
}
pub unsafe fn SpinlockSemas() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SpinlockSemas() -> ::std::os::raw::c_int;
        }
        SpinlockSemas()
    })
}
pub unsafe fn SpinlockSemaSize() -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SpinlockSemaSize() -> Size;
        }
        SpinlockSemaSize()
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct SharedFileSet {
    pub creator_pid: pid_t,
    pub number: uint32,
    pub mutex: slock_t,
    pub refcnt: ::std::os::raw::c_int,
    pub ntablespaces: ::std::os::raw::c_int,
    pub tablespaces: [Oid; 8usize],
}
pub unsafe fn SharedFileSetInit(arg_fileset: *mut SharedFileSet, arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetInit(arg_fileset: *mut SharedFileSet, arg_seg: *mut dsm_segment);
        }
        SharedFileSetInit(arg_fileset, arg_seg)
    })
}
pub unsafe fn SharedFileSetAttach(arg_fileset: *mut SharedFileSet, arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetAttach(arg_fileset: *mut SharedFileSet, arg_seg: *mut dsm_segment);
        }
        SharedFileSetAttach(arg_fileset, arg_seg)
    })
}
pub unsafe fn SharedFileSetCreate(
    arg_fileset: *mut SharedFileSet,
    arg_name: *const ::std::os::raw::c_char,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetCreate(
                arg_fileset: *mut SharedFileSet,
                arg_name: *const ::std::os::raw::c_char,
            ) -> File;
        }
        SharedFileSetCreate(arg_fileset, arg_name)
    })
}
pub unsafe fn SharedFileSetOpen(
    arg_fileset: *mut SharedFileSet,
    arg_name: *const ::std::os::raw::c_char,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetOpen(
                arg_fileset: *mut SharedFileSet,
                arg_name: *const ::std::os::raw::c_char,
            ) -> File;
        }
        SharedFileSetOpen(arg_fileset, arg_name)
    })
}
pub unsafe fn SharedFileSetDelete(
    arg_fileset: *mut SharedFileSet,
    arg_name: *const ::std::os::raw::c_char,
    arg_error_on_failure: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetDelete(
                arg_fileset: *mut SharedFileSet,
                arg_name: *const ::std::os::raw::c_char,
                arg_error_on_failure: bool,
            ) -> bool;
        }
        SharedFileSetDelete(arg_fileset, arg_name, arg_error_on_failure)
    })
}
pub unsafe fn SharedFileSetDeleteAll(arg_fileset: *mut SharedFileSet) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetDeleteAll(arg_fileset: *mut SharedFileSet);
        }
        SharedFileSetDeleteAll(arg_fileset)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedTuplestore {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedTuplestoreAccessor {
    _unused: [u8; 0],
}
pub unsafe fn sts_estimate(arg_participants: ::std::os::raw::c_int) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_estimate(arg_participants: ::std::os::raw::c_int) -> usize;
        }
        sts_estimate(arg_participants)
    })
}
pub unsafe fn sts_initialize(
    arg_sts: *mut SharedTuplestore,
    arg_participants: ::std::os::raw::c_int,
    arg_my_participant_number: ::std::os::raw::c_int,
    arg_meta_data_size: usize,
    arg_flags: ::std::os::raw::c_int,
    arg_fileset: *mut SharedFileSet,
    arg_name: *const ::std::os::raw::c_char,
) -> *mut SharedTuplestoreAccessor {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_initialize(
                arg_sts: *mut SharedTuplestore,
                arg_participants: ::std::os::raw::c_int,
                arg_my_participant_number: ::std::os::raw::c_int,
                arg_meta_data_size: usize,
                arg_flags: ::std::os::raw::c_int,
                arg_fileset: *mut SharedFileSet,
                arg_name: *const ::std::os::raw::c_char,
            ) -> *mut SharedTuplestoreAccessor;
        }
        sts_initialize(
            arg_sts,
            arg_participants,
            arg_my_participant_number,
            arg_meta_data_size,
            arg_flags,
            arg_fileset,
            arg_name,
        )
    })
}
pub unsafe fn sts_attach(
    arg_sts: *mut SharedTuplestore,
    arg_my_participant_number: ::std::os::raw::c_int,
    arg_fileset: *mut SharedFileSet,
) -> *mut SharedTuplestoreAccessor {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_attach(
                arg_sts: *mut SharedTuplestore,
                arg_my_participant_number: ::std::os::raw::c_int,
                arg_fileset: *mut SharedFileSet,
            ) -> *mut SharedTuplestoreAccessor;
        }
        sts_attach(arg_sts, arg_my_participant_number, arg_fileset)
    })
}
pub unsafe fn sts_end_write(arg_accessor: *mut SharedTuplestoreAccessor) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_end_write(arg_accessor: *mut SharedTuplestoreAccessor);
        }
        sts_end_write(arg_accessor)
    })
}
pub unsafe fn sts_reinitialize(arg_accessor: *mut SharedTuplestoreAccessor) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_reinitialize(arg_accessor: *mut SharedTuplestoreAccessor);
        }
        sts_reinitialize(arg_accessor)
    })
}
pub unsafe fn sts_begin_parallel_scan(arg_accessor: *mut SharedTuplestoreAccessor) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_begin_parallel_scan(arg_accessor: *mut SharedTuplestoreAccessor);
        }
        sts_begin_parallel_scan(arg_accessor)
    })
}
pub unsafe fn sts_end_parallel_scan(arg_accessor: *mut SharedTuplestoreAccessor) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_end_parallel_scan(arg_accessor: *mut SharedTuplestoreAccessor);
        }
        sts_end_parallel_scan(arg_accessor)
    })
}
pub unsafe fn sts_puttuple(
    arg_accessor: *mut SharedTuplestoreAccessor,
    arg_meta_data: *mut ::std::os::raw::c_void,
    arg_tuple: MinimalTuple,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_puttuple(
                arg_accessor: *mut SharedTuplestoreAccessor,
                arg_meta_data: *mut ::std::os::raw::c_void,
                arg_tuple: MinimalTuple,
            );
        }
        sts_puttuple(arg_accessor, arg_meta_data, arg_tuple)
    })
}
pub unsafe fn sts_parallel_scan_next(
    arg_accessor: *mut SharedTuplestoreAccessor,
    arg_meta_data: *mut ::std::os::raw::c_void,
) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_parallel_scan_next(
                arg_accessor: *mut SharedTuplestoreAccessor,
                arg_meta_data: *mut ::std::os::raw::c_void,
            ) -> MinimalTuple;
        }
        sts_parallel_scan_next(arg_accessor, arg_meta_data)
    })
}
pub type Timestamp = int64;
pub type TimestampTz = int64;
pub type TimeOffset = int64;
pub type fsec_t = int32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Interval {
    pub time: TimeOffset,
    pub day: int32,
    pub month: int32,
}
pub const SnapshotType_SNAPSHOT_MVCC: SnapshotType = 0;
pub const SnapshotType_SNAPSHOT_SELF: SnapshotType = 1;
pub const SnapshotType_SNAPSHOT_ANY: SnapshotType = 2;
pub const SnapshotType_SNAPSHOT_TOAST: SnapshotType = 3;
pub const SnapshotType_SNAPSHOT_DIRTY: SnapshotType = 4;
pub const SnapshotType_SNAPSHOT_HISTORIC_MVCC: SnapshotType = 5;
pub const SnapshotType_SNAPSHOT_NON_VACUUMABLE: SnapshotType = 6;
pub type SnapshotType = ::std::os::raw::c_uint;
pub type Snapshot = *mut SnapshotData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SnapshotData {
    pub snapshot_type: SnapshotType,
    pub xmin: TransactionId,
    pub xmax: TransactionId,
    pub xip: *mut TransactionId,
    pub xcnt: uint32,
    pub subxip: *mut TransactionId,
    pub subxcnt: int32,
    pub suboverflowed: bool,
    pub takenDuringRecovery: bool,
    pub copied: bool,
    pub curcid: CommandId,
    pub speculativeToken: uint32,
    pub active_count: uint32,
    pub regd_count: uint32,
    pub ph_node: pairingheap_node,
    pub whenTaken: TimestampTz,
    pub lsn: XLogRecPtr,
}
impl Default for SnapshotData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Relation = *mut RelationData;
pub type RelationPtr = *mut Relation;
pub unsafe fn RelationIdGetRelation(arg_relationId: Oid) -> Relation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationIdGetRelation(arg_relationId: Oid) -> Relation;
        }
        RelationIdGetRelation(arg_relationId)
    })
}
pub unsafe fn RelationClose(arg_relation: Relation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationClose(arg_relation: Relation);
        }
        RelationClose(arg_relation)
    })
}
pub unsafe fn RelationGetFKeyList(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetFKeyList(arg_relation: Relation) -> *mut List;
        }
        RelationGetFKeyList(arg_relation)
    })
}
pub unsafe fn RelationGetIndexList(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexList(arg_relation: Relation) -> *mut List;
        }
        RelationGetIndexList(arg_relation)
    })
}
pub unsafe fn RelationGetStatExtList(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetStatExtList(arg_relation: Relation) -> *mut List;
        }
        RelationGetStatExtList(arg_relation)
    })
}
pub unsafe fn RelationGetPrimaryKeyIndex(arg_relation: Relation) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetPrimaryKeyIndex(arg_relation: Relation) -> Oid;
        }
        RelationGetPrimaryKeyIndex(arg_relation)
    })
}
pub unsafe fn RelationGetReplicaIndex(arg_relation: Relation) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetReplicaIndex(arg_relation: Relation) -> Oid;
        }
        RelationGetReplicaIndex(arg_relation)
    })
}
pub unsafe fn RelationGetIndexExpressions(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexExpressions(arg_relation: Relation) -> *mut List;
        }
        RelationGetIndexExpressions(arg_relation)
    })
}
pub unsafe fn RelationGetDummyIndexExpressions(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetDummyIndexExpressions(arg_relation: Relation) -> *mut List;
        }
        RelationGetDummyIndexExpressions(arg_relation)
    })
}
pub unsafe fn RelationGetIndexPredicate(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexPredicate(arg_relation: Relation) -> *mut List;
        }
        RelationGetIndexPredicate(arg_relation)
    })
}
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_ALL: IndexAttrBitmapKind = 0;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_KEY: IndexAttrBitmapKind = 1;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_PRIMARY_KEY: IndexAttrBitmapKind = 2;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_IDENTITY_KEY: IndexAttrBitmapKind = 3;
pub type IndexAttrBitmapKind = ::std::os::raw::c_uint;
pub unsafe fn RelationGetIndexAttrBitmap(
    arg_relation: Relation,
    arg_keyAttrs: IndexAttrBitmapKind,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexAttrBitmap(
                arg_relation: Relation,
                arg_keyAttrs: IndexAttrBitmapKind,
            ) -> *mut Bitmapset;
        }
        RelationGetIndexAttrBitmap(arg_relation, arg_keyAttrs)
    })
}
pub unsafe fn RelationGetExclusionInfo(
    arg_indexRelation: Relation,
    arg_operators: *mut *mut Oid,
    arg_procs: *mut *mut Oid,
    arg_strategies: *mut *mut uint16,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetExclusionInfo(
                arg_indexRelation: Relation,
                arg_operators: *mut *mut Oid,
                arg_procs: *mut *mut Oid,
                arg_strategies: *mut *mut uint16,
            );
        }
        RelationGetExclusionInfo(arg_indexRelation, arg_operators, arg_procs, arg_strategies)
    })
}
pub unsafe fn RelationInitIndexAccessInfo(arg_relation: Relation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationInitIndexAccessInfo(arg_relation: Relation);
        }
        RelationInitIndexAccessInfo(arg_relation)
    })
}
pub unsafe fn GetRelationPublicationActions(arg_relation: Relation) -> *mut PublicationActions {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetRelationPublicationActions(arg_relation: Relation) -> *mut PublicationActions;
        }
        GetRelationPublicationActions(arg_relation)
    })
}
pub unsafe fn RelationInitTableAccessMethod(arg_relation: Relation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationInitTableAccessMethod(arg_relation: Relation);
        }
        RelationInitTableAccessMethod(arg_relation)
    })
}
pub unsafe fn errtable(arg_rel: Relation) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errtable(arg_rel: Relation) -> ::std::os::raw::c_int;
        }
        errtable(arg_rel)
    })
}
pub unsafe fn errtablecol(
    arg_rel: Relation,
    arg_attnum: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errtablecol(
                arg_rel: Relation,
                arg_attnum: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        errtablecol(arg_rel, arg_attnum)
    })
}
pub unsafe fn errtablecolname(
    arg_rel: Relation,
    arg_colname: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errtablecolname(
                arg_rel: Relation,
                arg_colname: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        errtablecolname(arg_rel, arg_colname)
    })
}
pub unsafe fn errtableconstraint(
    arg_rel: Relation,
    arg_conname: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errtableconstraint(
                arg_rel: Relation,
                arg_conname: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        errtableconstraint(arg_rel, arg_conname)
    })
}
pub unsafe fn RelationCacheInitialize() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitialize();
        }
        RelationCacheInitialize()
    })
}
pub unsafe fn RelationCacheInitializePhase2() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitializePhase2();
        }
        RelationCacheInitializePhase2()
    })
}
pub unsafe fn RelationCacheInitializePhase3() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitializePhase3();
        }
        RelationCacheInitializePhase3()
    })
}
pub unsafe fn RelationBuildLocalRelation(
    arg_relname: *const ::std::os::raw::c_char,
    arg_relnamespace: Oid,
    arg_tupDesc: TupleDesc,
    arg_relid: Oid,
    arg_accessmtd: Oid,
    arg_relfilenode: Oid,
    arg_reltablespace: Oid,
    arg_shared_relation: bool,
    arg_mapped_relation: bool,
    arg_relpersistence: ::std::os::raw::c_char,
    arg_relkind: ::std::os::raw::c_char,
) -> Relation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationBuildLocalRelation(
                arg_relname: *const ::std::os::raw::c_char,
                arg_relnamespace: Oid,
                arg_tupDesc: TupleDesc,
                arg_relid: Oid,
                arg_accessmtd: Oid,
                arg_relfilenode: Oid,
                arg_reltablespace: Oid,
                arg_shared_relation: bool,
                arg_mapped_relation: bool,
                arg_relpersistence: ::std::os::raw::c_char,
                arg_relkind: ::std::os::raw::c_char,
            ) -> Relation;
        }
        RelationBuildLocalRelation(
            arg_relname,
            arg_relnamespace,
            arg_tupDesc,
            arg_relid,
            arg_accessmtd,
            arg_relfilenode,
            arg_reltablespace,
            arg_shared_relation,
            arg_mapped_relation,
            arg_relpersistence,
            arg_relkind,
        )
    })
}
pub unsafe fn RelationSetNewRelfilenode(
    arg_relation: Relation,
    arg_persistence: ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationSetNewRelfilenode(
                arg_relation: Relation,
                arg_persistence: ::std::os::raw::c_char,
            );
        }
        RelationSetNewRelfilenode(arg_relation, arg_persistence)
    })
}
pub unsafe fn RelationForgetRelation(arg_rid: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationForgetRelation(arg_rid: Oid);
        }
        RelationForgetRelation(arg_rid)
    })
}
pub unsafe fn RelationCacheInvalidateEntry(arg_relationId: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInvalidateEntry(arg_relationId: Oid);
        }
        RelationCacheInvalidateEntry(arg_relationId)
    })
}
pub unsafe fn RelationCacheInvalidate(arg_debug_discard: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInvalidate(arg_debug_discard: bool);
        }
        RelationCacheInvalidate(arg_debug_discard)
    })
}
pub unsafe fn RelationCloseSmgrByOid(arg_relationId: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCloseSmgrByOid(arg_relationId: Oid);
        }
        RelationCloseSmgrByOid(arg_relationId)
    })
}
pub unsafe fn AtEOXact_RelationCache(arg_isCommit: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOXact_RelationCache(arg_isCommit: bool);
        }
        AtEOXact_RelationCache(arg_isCommit)
    })
}
pub unsafe fn AtEOSubXact_RelationCache(
    arg_isCommit: bool,
    arg_mySubid: SubTransactionId,
    arg_parentSubid: SubTransactionId,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOSubXact_RelationCache(
                arg_isCommit: bool,
                arg_mySubid: SubTransactionId,
                arg_parentSubid: SubTransactionId,
            );
        }
        AtEOSubXact_RelationCache(arg_isCommit, arg_mySubid, arg_parentSubid)
    })
}
pub unsafe fn RelationIdIsInInitFile(arg_relationId: Oid) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationIdIsInInitFile(arg_relationId: Oid) -> bool;
        }
        RelationIdIsInInitFile(arg_relationId)
    })
}
pub unsafe fn RelationCacheInitFilePreInvalidate() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitFilePreInvalidate();
        }
        RelationCacheInitFilePreInvalidate()
    })
}
pub unsafe fn RelationCacheInitFilePostInvalidate() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitFilePostInvalidate();
        }
        RelationCacheInitFilePostInvalidate()
    })
}
pub unsafe fn RelationCacheInitFileRemove() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitFileRemove();
        }
        RelationCacheInitFileRemove()
    })
}
extern "C" {
    pub static mut criticalRelcachesBuilt: bool;
}
extern "C" {
    pub static mut criticalSharedRelcachesBuilt: bool;
}
pub type SortSupport = *mut SortSupportData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortSupportData {
    pub ssup_cxt: MemoryContext,
    pub ssup_collation: Oid,
    pub ssup_reverse: bool,
    pub ssup_nulls_first: bool,
    pub ssup_attno: AttrNumber,
    pub ssup_extra: *mut ::std::os::raw::c_void,
    pub comparator: ::std::option::Option<
        unsafe extern "C" fn(x: Datum, y: Datum, ssup: SortSupport) -> ::std::os::raw::c_int,
    >,
    pub abbreviate: bool,
    pub abbrev_converter:
        ::std::option::Option<unsafe extern "C" fn(original: Datum, ssup: SortSupport) -> Datum>,
    pub abbrev_abort: ::std::option::Option<
        unsafe extern "C" fn(memtupcount: ::std::os::raw::c_int, ssup: SortSupport) -> bool,
    >,
    pub abbrev_full_comparator: ::std::option::Option<
        unsafe extern "C" fn(x: Datum, y: Datum, ssup: SortSupport) -> ::std::os::raw::c_int,
    >,
}
impl Default for SortSupportData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn PrepareSortSupportComparisonShim(arg_cmpFunc: Oid, arg_ssup: SortSupport) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PrepareSortSupportComparisonShim(arg_cmpFunc: Oid, arg_ssup: SortSupport);
        }
        PrepareSortSupportComparisonShim(arg_cmpFunc, arg_ssup)
    })
}
pub unsafe fn PrepareSortSupportFromOrderingOp(arg_orderingOp: Oid, arg_ssup: SortSupport) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PrepareSortSupportFromOrderingOp(arg_orderingOp: Oid, arg_ssup: SortSupport);
        }
        PrepareSortSupportFromOrderingOp(arg_orderingOp, arg_ssup)
    })
}
pub unsafe fn PrepareSortSupportFromIndexRel(
    arg_indexRel: Relation,
    arg_strategy: int16,
    arg_ssup: SortSupport,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PrepareSortSupportFromIndexRel(
                arg_indexRel: Relation,
                arg_strategy: int16,
                arg_ssup: SortSupport,
            );
        }
        PrepareSortSupportFromIndexRel(arg_indexRel, arg_strategy, arg_ssup)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Tuplestorestate {
    _unused: [u8; 0],
}
pub unsafe fn tuplestore_begin_heap(
    arg_randomAccess: bool,
    arg_interXact: bool,
    arg_maxKBytes: ::std::os::raw::c_int,
) -> *mut Tuplestorestate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_begin_heap(
                arg_randomAccess: bool,
                arg_interXact: bool,
                arg_maxKBytes: ::std::os::raw::c_int,
            ) -> *mut Tuplestorestate;
        }
        tuplestore_begin_heap(arg_randomAccess, arg_interXact, arg_maxKBytes)
    })
}
pub unsafe fn tuplestore_set_eflags(
    arg_state: *mut Tuplestorestate,
    arg_eflags: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_set_eflags(
                arg_state: *mut Tuplestorestate,
                arg_eflags: ::std::os::raw::c_int,
            );
        }
        tuplestore_set_eflags(arg_state, arg_eflags)
    })
}
pub unsafe fn tuplestore_puttupleslot(
    arg_state: *mut Tuplestorestate,
    arg_slot: *mut TupleTableSlot,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_puttupleslot(
                arg_state: *mut Tuplestorestate,
                arg_slot: *mut TupleTableSlot,
            );
        }
        tuplestore_puttupleslot(arg_state, arg_slot)
    })
}
pub unsafe fn tuplestore_puttuple(arg_state: *mut Tuplestorestate, arg_tuple: HeapTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_puttuple(arg_state: *mut Tuplestorestate, arg_tuple: HeapTuple);
        }
        tuplestore_puttuple(arg_state, arg_tuple)
    })
}
pub unsafe fn tuplestore_putvalues(
    arg_state: *mut Tuplestorestate,
    arg_tdesc: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_putvalues(
                arg_state: *mut Tuplestorestate,
                arg_tdesc: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            );
        }
        tuplestore_putvalues(arg_state, arg_tdesc, arg_values, arg_isnull)
    })
}
pub unsafe fn tuplestore_alloc_read_pointer(
    arg_state: *mut Tuplestorestate,
    arg_eflags: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_alloc_read_pointer(
                arg_state: *mut Tuplestorestate,
                arg_eflags: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        tuplestore_alloc_read_pointer(arg_state, arg_eflags)
    })
}
pub unsafe fn tuplestore_select_read_pointer(
    arg_state: *mut Tuplestorestate,
    arg_ptr: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_select_read_pointer(
                arg_state: *mut Tuplestorestate,
                arg_ptr: ::std::os::raw::c_int,
            );
        }
        tuplestore_select_read_pointer(arg_state, arg_ptr)
    })
}
pub unsafe fn tuplestore_copy_read_pointer(
    arg_state: *mut Tuplestorestate,
    arg_srcptr: ::std::os::raw::c_int,
    arg_destptr: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_copy_read_pointer(
                arg_state: *mut Tuplestorestate,
                arg_srcptr: ::std::os::raw::c_int,
                arg_destptr: ::std::os::raw::c_int,
            );
        }
        tuplestore_copy_read_pointer(arg_state, arg_srcptr, arg_destptr)
    })
}
pub unsafe fn tuplestore_trim(arg_state: *mut Tuplestorestate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_trim(arg_state: *mut Tuplestorestate);
        }
        tuplestore_trim(arg_state)
    })
}
pub unsafe fn tuplestore_in_memory(arg_state: *mut Tuplestorestate) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_in_memory(arg_state: *mut Tuplestorestate) -> bool;
        }
        tuplestore_in_memory(arg_state)
    })
}
pub unsafe fn tuplestore_gettupleslot(
    arg_state: *mut Tuplestorestate,
    arg_forward: bool,
    arg_copy: bool,
    arg_slot: *mut TupleTableSlot,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_gettupleslot(
                arg_state: *mut Tuplestorestate,
                arg_forward: bool,
                arg_copy: bool,
                arg_slot: *mut TupleTableSlot,
            ) -> bool;
        }
        tuplestore_gettupleslot(arg_state, arg_forward, arg_copy, arg_slot)
    })
}
pub unsafe fn tuplestore_advance(arg_state: *mut Tuplestorestate, arg_forward: bool) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_advance(arg_state: *mut Tuplestorestate, arg_forward: bool) -> bool;
        }
        tuplestore_advance(arg_state, arg_forward)
    })
}
pub unsafe fn tuplestore_skiptuples(
    arg_state: *mut Tuplestorestate,
    arg_ntuples: int64,
    arg_forward: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_skiptuples(
                arg_state: *mut Tuplestorestate,
                arg_ntuples: int64,
                arg_forward: bool,
            ) -> bool;
        }
        tuplestore_skiptuples(arg_state, arg_ntuples, arg_forward)
    })
}
pub unsafe fn tuplestore_tuple_count(arg_state: *mut Tuplestorestate) -> int64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_tuple_count(arg_state: *mut Tuplestorestate) -> int64;
        }
        tuplestore_tuple_count(arg_state)
    })
}
pub unsafe fn tuplestore_ateof(arg_state: *mut Tuplestorestate) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_ateof(arg_state: *mut Tuplestorestate) -> bool;
        }
        tuplestore_ateof(arg_state)
    })
}
pub unsafe fn tuplestore_rescan(arg_state: *mut Tuplestorestate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_rescan(arg_state: *mut Tuplestorestate);
        }
        tuplestore_rescan(arg_state)
    })
}
pub unsafe fn tuplestore_clear(arg_state: *mut Tuplestorestate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_clear(arg_state: *mut Tuplestorestate);
        }
        tuplestore_clear(arg_state)
    })
}
pub unsafe fn tuplestore_end(arg_state: *mut Tuplestorestate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_end(arg_state: *mut Tuplestorestate);
        }
        tuplestore_end(arg_state)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexTupleData {
    pub t_tid: ItemPointerData,
    pub t_info: ::std::os::raw::c_ushort,
}
pub type IndexTuple = *mut IndexTupleData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexAttributeBitMapData {
    pub bits: [bits8; 4usize],
}
pub type IndexAttributeBitMap = *mut IndexAttributeBitMapData;
pub unsafe fn index_form_tuple(
    arg_tupleDescriptor: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) -> IndexTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_form_tuple(
                arg_tupleDescriptor: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            ) -> IndexTuple;
        }
        index_form_tuple(arg_tupleDescriptor, arg_values, arg_isnull)
    })
}
pub unsafe fn nocache_index_getattr(
    arg_tup: IndexTuple,
    arg_attnum: ::std::os::raw::c_int,
    arg_tupleDesc: TupleDesc,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nocache_index_getattr(
                arg_tup: IndexTuple,
                arg_attnum: ::std::os::raw::c_int,
                arg_tupleDesc: TupleDesc,
            ) -> Datum;
        }
        nocache_index_getattr(arg_tup, arg_attnum, arg_tupleDesc)
    })
}
pub unsafe fn index_deform_tuple(
    arg_tup: IndexTuple,
    arg_tupleDescriptor: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_deform_tuple(
                arg_tup: IndexTuple,
                arg_tupleDescriptor: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            );
        }
        index_deform_tuple(arg_tup, arg_tupleDescriptor, arg_values, arg_isnull)
    })
}
pub unsafe fn CopyIndexTuple(arg_source: IndexTuple) -> IndexTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CopyIndexTuple(arg_source: IndexTuple) -> IndexTuple;
        }
        CopyIndexTuple(arg_source)
    })
}
pub unsafe fn index_truncate_tuple(
    arg_sourceDescriptor: TupleDesc,
    arg_source: IndexTuple,
    arg_leavenatts: ::std::os::raw::c_int,
) -> IndexTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_truncate_tuple(
                arg_sourceDescriptor: TupleDesc,
                arg_source: IndexTuple,
                arg_leavenatts: ::std::os::raw::c_int,
            ) -> IndexTuple;
        }
        index_truncate_tuple(arg_sourceDescriptor, arg_source, arg_leavenatts)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Tuplesortstate {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Sharedsort {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortCoordinateData {
    pub isWorker: bool,
    pub nParticipants: ::std::os::raw::c_int,
    pub sharedsort: *mut Sharedsort,
}
impl Default for SortCoordinateData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SortCoordinate = *mut SortCoordinateData;
pub const TuplesortMethod_SORT_TYPE_STILL_IN_PROGRESS: TuplesortMethod = 0;
pub const TuplesortMethod_SORT_TYPE_TOP_N_HEAPSORT: TuplesortMethod = 1;
pub const TuplesortMethod_SORT_TYPE_QUICKSORT: TuplesortMethod = 2;
pub const TuplesortMethod_SORT_TYPE_EXTERNAL_SORT: TuplesortMethod = 3;
pub const TuplesortMethod_SORT_TYPE_EXTERNAL_MERGE: TuplesortMethod = 4;
pub type TuplesortMethod = ::std::os::raw::c_uint;
pub const TuplesortSpaceType_SORT_SPACE_TYPE_DISK: TuplesortSpaceType = 0;
pub const TuplesortSpaceType_SORT_SPACE_TYPE_MEMORY: TuplesortSpaceType = 1;
pub type TuplesortSpaceType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TuplesortInstrumentation {
    pub sortMethod: TuplesortMethod,
    pub spaceType: TuplesortSpaceType,
    pub spaceUsed: ::std::os::raw::c_long,
}
impl Default for TuplesortInstrumentation {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn tuplesort_begin_heap(
    arg_tupDesc: TupleDesc,
    arg_nkeys: ::std::os::raw::c_int,
    arg_attNums: *mut AttrNumber,
    arg_sortOperators: *mut Oid,
    arg_sortCollations: *mut Oid,
    arg_nullsFirstFlags: *mut bool,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_heap(
                arg_tupDesc: TupleDesc,
                arg_nkeys: ::std::os::raw::c_int,
                arg_attNums: *mut AttrNumber,
                arg_sortOperators: *mut Oid,
                arg_sortCollations: *mut Oid,
                arg_nullsFirstFlags: *mut bool,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_heap(
            arg_tupDesc,
            arg_nkeys,
            arg_attNums,
            arg_sortOperators,
            arg_sortCollations,
            arg_nullsFirstFlags,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_begin_cluster(
    arg_tupDesc: TupleDesc,
    arg_indexRel: Relation,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_cluster(
                arg_tupDesc: TupleDesc,
                arg_indexRel: Relation,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_cluster(
            arg_tupDesc,
            arg_indexRel,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_begin_index_btree(
    arg_heapRel: Relation,
    arg_indexRel: Relation,
    arg_enforceUnique: bool,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_index_btree(
                arg_heapRel: Relation,
                arg_indexRel: Relation,
                arg_enforceUnique: bool,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_index_btree(
            arg_heapRel,
            arg_indexRel,
            arg_enforceUnique,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_begin_index_hash(
    arg_heapRel: Relation,
    arg_indexRel: Relation,
    arg_high_mask: uint32,
    arg_low_mask: uint32,
    arg_max_buckets: uint32,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_index_hash(
                arg_heapRel: Relation,
                arg_indexRel: Relation,
                arg_high_mask: uint32,
                arg_low_mask: uint32,
                arg_max_buckets: uint32,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_index_hash(
            arg_heapRel,
            arg_indexRel,
            arg_high_mask,
            arg_low_mask,
            arg_max_buckets,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_begin_datum(
    arg_datumType: Oid,
    arg_sortOperator: Oid,
    arg_sortCollation: Oid,
    arg_nullsFirstFlag: bool,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_datum(
                arg_datumType: Oid,
                arg_sortOperator: Oid,
                arg_sortCollation: Oid,
                arg_nullsFirstFlag: bool,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_datum(
            arg_datumType,
            arg_sortOperator,
            arg_sortCollation,
            arg_nullsFirstFlag,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_set_bound(arg_state: *mut Tuplesortstate, arg_bound: int64) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_set_bound(arg_state: *mut Tuplesortstate, arg_bound: int64);
        }
        tuplesort_set_bound(arg_state, arg_bound)
    })
}
pub unsafe fn tuplesort_puttupleslot(
    arg_state: *mut Tuplesortstate,
    arg_slot: *mut TupleTableSlot,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_puttupleslot(
                arg_state: *mut Tuplesortstate,
                arg_slot: *mut TupleTableSlot,
            );
        }
        tuplesort_puttupleslot(arg_state, arg_slot)
    })
}
pub unsafe fn tuplesort_putheaptuple(arg_state: *mut Tuplesortstate, arg_tup: HeapTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_putheaptuple(arg_state: *mut Tuplesortstate, arg_tup: HeapTuple);
        }
        tuplesort_putheaptuple(arg_state, arg_tup)
    })
}
pub unsafe fn tuplesort_putindextuplevalues(
    arg_state: *mut Tuplesortstate,
    arg_rel: Relation,
    arg_self_: ItemPointer,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_putindextuplevalues(
                arg_state: *mut Tuplesortstate,
                arg_rel: Relation,
                arg_self_: ItemPointer,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            );
        }
        tuplesort_putindextuplevalues(arg_state, arg_rel, arg_self_, arg_values, arg_isnull)
    })
}
pub unsafe fn tuplesort_putdatum(arg_state: *mut Tuplesortstate, arg_val: Datum, arg_isNull: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_putdatum(arg_state: *mut Tuplesortstate, arg_val: Datum, arg_isNull: bool);
        }
        tuplesort_putdatum(arg_state, arg_val, arg_isNull)
    })
}
pub unsafe fn tuplesort_performsort(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_performsort(arg_state: *mut Tuplesortstate);
        }
        tuplesort_performsort(arg_state)
    })
}
pub unsafe fn tuplesort_gettupleslot(
    arg_state: *mut Tuplesortstate,
    arg_forward: bool,
    arg_copy: bool,
    arg_slot: *mut TupleTableSlot,
    arg_abbrev: *mut Datum,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_gettupleslot(
                arg_state: *mut Tuplesortstate,
                arg_forward: bool,
                arg_copy: bool,
                arg_slot: *mut TupleTableSlot,
                arg_abbrev: *mut Datum,
            ) -> bool;
        }
        tuplesort_gettupleslot(arg_state, arg_forward, arg_copy, arg_slot, arg_abbrev)
    })
}
pub unsafe fn tuplesort_getheaptuple(
    arg_state: *mut Tuplesortstate,
    arg_forward: bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_getheaptuple(
                arg_state: *mut Tuplesortstate,
                arg_forward: bool,
            ) -> HeapTuple;
        }
        tuplesort_getheaptuple(arg_state, arg_forward)
    })
}
pub unsafe fn tuplesort_getindextuple(
    arg_state: *mut Tuplesortstate,
    arg_forward: bool,
) -> IndexTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_getindextuple(
                arg_state: *mut Tuplesortstate,
                arg_forward: bool,
            ) -> IndexTuple;
        }
        tuplesort_getindextuple(arg_state, arg_forward)
    })
}
pub unsafe fn tuplesort_getdatum(
    arg_state: *mut Tuplesortstate,
    arg_forward: bool,
    arg_val: *mut Datum,
    arg_isNull: *mut bool,
    arg_abbrev: *mut Datum,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_getdatum(
                arg_state: *mut Tuplesortstate,
                arg_forward: bool,
                arg_val: *mut Datum,
                arg_isNull: *mut bool,
                arg_abbrev: *mut Datum,
            ) -> bool;
        }
        tuplesort_getdatum(arg_state, arg_forward, arg_val, arg_isNull, arg_abbrev)
    })
}
pub unsafe fn tuplesort_skiptuples(
    arg_state: *mut Tuplesortstate,
    arg_ntuples: int64,
    arg_forward: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_skiptuples(
                arg_state: *mut Tuplesortstate,
                arg_ntuples: int64,
                arg_forward: bool,
            ) -> bool;
        }
        tuplesort_skiptuples(arg_state, arg_ntuples, arg_forward)
    })
}
pub unsafe fn tuplesort_end(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_end(arg_state: *mut Tuplesortstate);
        }
        tuplesort_end(arg_state)
    })
}
pub unsafe fn tuplesort_get_stats(
    arg_state: *mut Tuplesortstate,
    arg_stats: *mut TuplesortInstrumentation,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_get_stats(
                arg_state: *mut Tuplesortstate,
                arg_stats: *mut TuplesortInstrumentation,
            );
        }
        tuplesort_get_stats(arg_state, arg_stats)
    })
}
pub unsafe fn tuplesort_method_name(arg_m: TuplesortMethod) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_method_name(arg_m: TuplesortMethod) -> *const ::std::os::raw::c_char;
        }
        tuplesort_method_name(arg_m)
    })
}
pub unsafe fn tuplesort_space_type_name(
    arg_t: TuplesortSpaceType,
) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_space_type_name(
                arg_t: TuplesortSpaceType,
            ) -> *const ::std::os::raw::c_char;
        }
        tuplesort_space_type_name(arg_t)
    })
}
pub unsafe fn tuplesort_merge_order(arg_allowedMem: int64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_merge_order(arg_allowedMem: int64) -> ::std::os::raw::c_int;
        }
        tuplesort_merge_order(arg_allowedMem)
    })
}
pub unsafe fn tuplesort_estimate_shared(arg_nworkers: ::std::os::raw::c_int) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_estimate_shared(arg_nworkers: ::std::os::raw::c_int) -> Size;
        }
        tuplesort_estimate_shared(arg_nworkers)
    })
}
pub unsafe fn tuplesort_initialize_shared(
    arg_shared: *mut Sharedsort,
    arg_nWorkers: ::std::os::raw::c_int,
    arg_seg: *mut dsm_segment,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_initialize_shared(
                arg_shared: *mut Sharedsort,
                arg_nWorkers: ::std::os::raw::c_int,
                arg_seg: *mut dsm_segment,
            );
        }
        tuplesort_initialize_shared(arg_shared, arg_nWorkers, arg_seg)
    })
}
pub unsafe fn tuplesort_attach_shared(arg_shared: *mut Sharedsort, arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_attach_shared(arg_shared: *mut Sharedsort, arg_seg: *mut dsm_segment);
        }
        tuplesort_attach_shared(arg_shared, arg_seg)
    })
}
pub unsafe fn tuplesort_rescan(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_rescan(arg_state: *mut Tuplesortstate);
        }
        tuplesort_rescan(arg_state)
    })
}
pub unsafe fn tuplesort_markpos(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_markpos(arg_state: *mut Tuplesortstate);
        }
        tuplesort_markpos(arg_state)
    })
}
pub unsafe fn tuplesort_restorepos(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_restorepos(arg_state: *mut Tuplesortstate);
        }
        tuplesort_restorepos(arg_state)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_flag {
    pub value: ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_uint32 {
    pub value: uint32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_uint64 {
    pub value: uint64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dsa_area {
    _unused: [u8; 0],
}
pub type dsa_pointer = uint64;
pub type dsa_pointer_atomic = pg_atomic_uint64;
pub type dsa_handle = dsm_handle;
pub unsafe fn dsa_startup() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_startup();
        }
        dsa_startup()
    })
}
pub unsafe fn dsa_create(arg_tranche_id: ::std::os::raw::c_int) -> *mut dsa_area {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_create(arg_tranche_id: ::std::os::raw::c_int) -> *mut dsa_area;
        }
        dsa_create(arg_tranche_id)
    })
}
pub unsafe fn dsa_create_in_place(
    arg_place: *mut ::std::os::raw::c_void,
    arg_size: usize,
    arg_tranche_id: ::std::os::raw::c_int,
    arg_segment: *mut dsm_segment,
) -> *mut dsa_area {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_create_in_place(
                arg_place: *mut ::std::os::raw::c_void,
                arg_size: usize,
                arg_tranche_id: ::std::os::raw::c_int,
                arg_segment: *mut dsm_segment,
            ) -> *mut dsa_area;
        }
        dsa_create_in_place(arg_place, arg_size, arg_tranche_id, arg_segment)
    })
}
pub unsafe fn dsa_attach(arg_handle: dsa_handle) -> *mut dsa_area {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_attach(arg_handle: dsa_handle) -> *mut dsa_area;
        }
        dsa_attach(arg_handle)
    })
}
pub unsafe fn dsa_attach_in_place(
    arg_place: *mut ::std::os::raw::c_void,
    arg_segment: *mut dsm_segment,
) -> *mut dsa_area {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_attach_in_place(
                arg_place: *mut ::std::os::raw::c_void,
                arg_segment: *mut dsm_segment,
            ) -> *mut dsa_area;
        }
        dsa_attach_in_place(arg_place, arg_segment)
    })
}
pub unsafe fn dsa_release_in_place(arg_place: *mut ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_release_in_place(arg_place: *mut ::std::os::raw::c_void);
        }
        dsa_release_in_place(arg_place)
    })
}
pub unsafe fn dsa_on_dsm_detach_release_in_place(arg_arg1: *mut dsm_segment, arg_arg2: Datum) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_on_dsm_detach_release_in_place(arg_arg1: *mut dsm_segment, arg_arg2: Datum);
        }
        dsa_on_dsm_detach_release_in_place(arg_arg1, arg_arg2)
    })
}
pub unsafe fn dsa_on_shmem_exit_release_in_place(arg_arg1: ::std::os::raw::c_int, arg_arg2: Datum) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_on_shmem_exit_release_in_place(arg_arg1: ::std::os::raw::c_int, arg_arg2: Datum);
        }
        dsa_on_shmem_exit_release_in_place(arg_arg1, arg_arg2)
    })
}
pub unsafe fn dsa_pin_mapping(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_pin_mapping(arg_area: *mut dsa_area);
        }
        dsa_pin_mapping(arg_area)
    })
}
pub unsafe fn dsa_detach(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_detach(arg_area: *mut dsa_area);
        }
        dsa_detach(arg_area)
    })
}
pub unsafe fn dsa_pin(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_pin(arg_area: *mut dsa_area);
        }
        dsa_pin(arg_area)
    })
}
pub unsafe fn dsa_unpin(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_unpin(arg_area: *mut dsa_area);
        }
        dsa_unpin(arg_area)
    })
}
pub unsafe fn dsa_set_size_limit(arg_area: *mut dsa_area, arg_limit: usize) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_set_size_limit(arg_area: *mut dsa_area, arg_limit: usize);
        }
        dsa_set_size_limit(arg_area, arg_limit)
    })
}
pub unsafe fn dsa_minimum_size() -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_minimum_size() -> usize;
        }
        dsa_minimum_size()
    })
}
pub unsafe fn dsa_get_handle(arg_area: *mut dsa_area) -> dsa_handle {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_get_handle(arg_area: *mut dsa_area) -> dsa_handle;
        }
        dsa_get_handle(arg_area)
    })
}
pub unsafe fn dsa_allocate_extended(
    arg_area: *mut dsa_area,
    arg_size: usize,
    arg_flags: ::std::os::raw::c_int,
) -> dsa_pointer {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_allocate_extended(
                arg_area: *mut dsa_area,
                arg_size: usize,
                arg_flags: ::std::os::raw::c_int,
            ) -> dsa_pointer;
        }
        dsa_allocate_extended(arg_area, arg_size, arg_flags)
    })
}
pub unsafe fn dsa_free(arg_area: *mut dsa_area, arg_dp: dsa_pointer) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_free(arg_area: *mut dsa_area, arg_dp: dsa_pointer);
        }
        dsa_free(arg_area, arg_dp)
    })
}
pub unsafe fn dsa_get_address(
    arg_area: *mut dsa_area,
    arg_dp: dsa_pointer,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_get_address(
                arg_area: *mut dsa_area,
                arg_dp: dsa_pointer,
            ) -> *mut ::std::os::raw::c_void;
        }
        dsa_get_address(arg_area, arg_dp)
    })
}
pub unsafe fn dsa_trim(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_trim(arg_area: *mut dsa_area);
        }
        dsa_trim(arg_area)
    })
}
pub unsafe fn dsa_dump(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_dump(arg_area: *mut dsa_area);
        }
        dsa_dump(arg_area)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TIDBitmap {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TBMIterator {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TBMSharedIterator {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct TBMIterateResult {
    pub blockno: BlockNumber,
    pub ntuples: ::std::os::raw::c_int,
    pub recheck: bool,
    pub offsets: __IncompleteArrayField<OffsetNumber>,
}
pub unsafe fn tbm_create(
    arg_maxbytes: ::std::os::raw::c_long,
    arg_dsa: *mut dsa_area,
) -> *mut TIDBitmap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_create(
                arg_maxbytes: ::std::os::raw::c_long,
                arg_dsa: *mut dsa_area,
            ) -> *mut TIDBitmap;
        }
        tbm_create(arg_maxbytes, arg_dsa)
    })
}
pub unsafe fn tbm_free(arg_tbm: *mut TIDBitmap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_free(arg_tbm: *mut TIDBitmap);
        }
        tbm_free(arg_tbm)
    })
}
pub unsafe fn tbm_free_shared_area(arg_dsa: *mut dsa_area, arg_dp: dsa_pointer) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_free_shared_area(arg_dsa: *mut dsa_area, arg_dp: dsa_pointer);
        }
        tbm_free_shared_area(arg_dsa, arg_dp)
    })
}
pub unsafe fn tbm_add_tuples(
    arg_tbm: *mut TIDBitmap,
    arg_tids: ItemPointer,
    arg_ntids: ::std::os::raw::c_int,
    arg_recheck: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_add_tuples(
                arg_tbm: *mut TIDBitmap,
                arg_tids: ItemPointer,
                arg_ntids: ::std::os::raw::c_int,
                arg_recheck: bool,
            );
        }
        tbm_add_tuples(arg_tbm, arg_tids, arg_ntids, arg_recheck)
    })
}
pub unsafe fn tbm_add_page(arg_tbm: *mut TIDBitmap, arg_pageno: BlockNumber) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_add_page(arg_tbm: *mut TIDBitmap, arg_pageno: BlockNumber);
        }
        tbm_add_page(arg_tbm, arg_pageno)
    })
}
pub unsafe fn tbm_union(arg_a: *mut TIDBitmap, arg_b: *const TIDBitmap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_union(arg_a: *mut TIDBitmap, arg_b: *const TIDBitmap);
        }
        tbm_union(arg_a, arg_b)
    })
}
pub unsafe fn tbm_intersect(arg_a: *mut TIDBitmap, arg_b: *const TIDBitmap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_intersect(arg_a: *mut TIDBitmap, arg_b: *const TIDBitmap);
        }
        tbm_intersect(arg_a, arg_b)
    })
}
pub unsafe fn tbm_is_empty(arg_tbm: *const TIDBitmap) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_is_empty(arg_tbm: *const TIDBitmap) -> bool;
        }
        tbm_is_empty(arg_tbm)
    })
}
pub unsafe fn tbm_begin_iterate(arg_tbm: *mut TIDBitmap) -> *mut TBMIterator {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_begin_iterate(arg_tbm: *mut TIDBitmap) -> *mut TBMIterator;
        }
        tbm_begin_iterate(arg_tbm)
    })
}
pub unsafe fn tbm_prepare_shared_iterate(arg_tbm: *mut TIDBitmap) -> dsa_pointer {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_prepare_shared_iterate(arg_tbm: *mut TIDBitmap) -> dsa_pointer;
        }
        tbm_prepare_shared_iterate(arg_tbm)
    })
}
pub unsafe fn tbm_iterate(arg_iterator: *mut TBMIterator) -> *mut TBMIterateResult {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_iterate(arg_iterator: *mut TBMIterator) -> *mut TBMIterateResult;
        }
        tbm_iterate(arg_iterator)
    })
}
pub unsafe fn tbm_shared_iterate(arg_iterator: *mut TBMSharedIterator) -> *mut TBMIterateResult {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_shared_iterate(arg_iterator: *mut TBMSharedIterator) -> *mut TBMIterateResult;
        }
        tbm_shared_iterate(arg_iterator)
    })
}
pub unsafe fn tbm_end_iterate(arg_iterator: *mut TBMIterator) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_end_iterate(arg_iterator: *mut TBMIterator);
        }
        tbm_end_iterate(arg_iterator)
    })
}
pub unsafe fn tbm_end_shared_iterate(arg_iterator: *mut TBMSharedIterator) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_end_shared_iterate(arg_iterator: *mut TBMSharedIterator);
        }
        tbm_end_shared_iterate(arg_iterator)
    })
}
pub unsafe fn tbm_attach_shared_iterate(
    arg_dsa: *mut dsa_area,
    arg_dp: dsa_pointer,
) -> *mut TBMSharedIterator {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_attach_shared_iterate(
                arg_dsa: *mut dsa_area,
                arg_dp: dsa_pointer,
            ) -> *mut TBMSharedIterator;
        }
        tbm_attach_shared_iterate(arg_dsa, arg_dp)
    })
}
pub unsafe fn tbm_calculate_entries(arg_maxbytes: f64) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_calculate_entries(arg_maxbytes: f64) -> ::std::os::raw::c_long;
        }
        tbm_calculate_entries(arg_maxbytes)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_node {
    pub next: ::std::os::raw::c_int,
    pub prev: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_head {
    pub head: ::std::os::raw::c_int,
    pub tail: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_mutable_iter {
    pub cur: ::std::os::raw::c_int,
    pub next: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ConditionVariable {
    pub mutex: slock_t,
    pub wakeup: proclist_head,
}
pub unsafe fn ConditionVariableInit(arg_cv: *mut ConditionVariable) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableInit(arg_cv: *mut ConditionVariable);
        }
        ConditionVariableInit(arg_cv)
    })
}
pub unsafe fn ConditionVariableSleep(arg_cv: *mut ConditionVariable, arg_wait_event_info: uint32) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableSleep(arg_cv: *mut ConditionVariable, arg_wait_event_info: uint32);
        }
        ConditionVariableSleep(arg_cv, arg_wait_event_info)
    })
}
pub unsafe fn ConditionVariableCancelSleep() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableCancelSleep();
        }
        ConditionVariableCancelSleep()
    })
}
pub unsafe fn ConditionVariablePrepareToSleep(arg_cv: *mut ConditionVariable) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariablePrepareToSleep(arg_cv: *mut ConditionVariable);
        }
        ConditionVariablePrepareToSleep(arg_cv)
    })
}
pub unsafe fn ConditionVariableSignal(arg_cv: *mut ConditionVariable) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableSignal(arg_cv: *mut ConditionVariable);
        }
        ConditionVariableSignal(arg_cv)
    })
}
pub unsafe fn ConditionVariableBroadcast(arg_cv: *mut ConditionVariable) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableBroadcast(arg_cv: *mut ConditionVariable);
        }
        ConditionVariableBroadcast(arg_cv)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionRoutingInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelHashJoinState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CopyMultiInsertBuffer {
    _unused: [u8; 0],
}
pub type ExprStateEvalFunc = ::std::option::Option<
    unsafe extern "C" fn(
        expression: *mut ExprState,
        econtext: *mut ExprContext,
        isNull: *mut bool,
    ) -> Datum,
>;
#[repr(C)]
pub struct ExprState {
    pub tag: Node,
    pub flags: uint8,
    pub resnull: bool,
    pub resvalue: Datum,
    pub resultslot: *mut TupleTableSlot,
    pub steps: *mut ExprEvalStep,
    pub evalfunc: ExprStateEvalFunc,
    pub expr: *mut Expr,
    pub evalfunc_private: *mut ::std::os::raw::c_void,
    pub steps_len: ::std::os::raw::c_int,
    pub steps_alloc: ::std::os::raw::c_int,
    pub parent: *mut PlanState,
    pub ext_params: ParamListInfo,
    pub innermost_caseval: *mut Datum,
    pub innermost_casenull: *mut bool,
    pub innermost_domainval: *mut Datum,
    pub innermost_domainnull: *mut bool,
}
impl Default for ExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexInfo {
    pub type_: NodeTag,
    pub ii_NumIndexAttrs: ::std::os::raw::c_int,
    pub ii_NumIndexKeyAttrs: ::std::os::raw::c_int,
    pub ii_IndexAttrNumbers: [AttrNumber; 32usize],
    pub ii_Expressions: *mut List,
    pub ii_ExpressionsState: *mut List,
    pub ii_Predicate: *mut List,
    pub ii_PredicateState: *mut ExprState,
    pub ii_ExclusionOps: *mut Oid,
    pub ii_ExclusionProcs: *mut Oid,
    pub ii_ExclusionStrats: *mut uint16,
    pub ii_UniqueOps: *mut Oid,
    pub ii_UniqueProcs: *mut Oid,
    pub ii_UniqueStrats: *mut uint16,
    pub ii_Unique: bool,
    pub ii_ReadyForInserts: bool,
    pub ii_Concurrent: bool,
    pub ii_BrokenHotChain: bool,
    pub ii_ParallelWorkers: ::std::os::raw::c_int,
    pub ii_Am: Oid,
    pub ii_AmCache: *mut ::std::os::raw::c_void,
    pub ii_Context: MemoryContext,
}
impl Default for IndexInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExprContextCallbackFunction = ::std::option::Option<unsafe extern "C" fn(arg: Datum)>;
#[repr(C)]
pub struct ExprContext_CB {
    pub next: *mut ExprContext_CB,
    pub function: ExprContextCallbackFunction,
    pub arg: Datum,
}
impl Default for ExprContext_CB {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct ExprContext {
    pub type_: NodeTag,
    pub ecxt_scantuple: *mut TupleTableSlot,
    pub ecxt_innertuple: *mut TupleTableSlot,
    pub ecxt_outertuple: *mut TupleTableSlot,
    pub ecxt_per_query_memory: MemoryContext,
    pub ecxt_per_tuple_memory: MemoryContext,
    pub ecxt_param_exec_vals: *mut ParamExecData,
    pub ecxt_param_list_info: ParamListInfo,
    pub ecxt_aggvalues: *mut Datum,
    pub ecxt_aggnulls: *mut bool,
    pub caseValue_datum: Datum,
    pub caseValue_isNull: bool,
    pub domainValue_datum: Datum,
    pub domainValue_isNull: bool,
    pub ecxt_estate: *mut EState,
    pub ecxt_callbacks: *mut ExprContext_CB,
}
impl Default for ExprContext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ExprDoneCond_ExprSingleResult: ExprDoneCond = 0;
pub const ExprDoneCond_ExprMultipleResult: ExprDoneCond = 1;
pub const ExprDoneCond_ExprEndResult: ExprDoneCond = 2;
pub type ExprDoneCond = ::std::os::raw::c_uint;
pub const SetFunctionReturnMode_SFRM_ValuePerCall: SetFunctionReturnMode = 1;
pub const SetFunctionReturnMode_SFRM_Materialize: SetFunctionReturnMode = 2;
pub const SetFunctionReturnMode_SFRM_Materialize_Random: SetFunctionReturnMode = 4;
pub const SetFunctionReturnMode_SFRM_Materialize_Preferred: SetFunctionReturnMode = 8;
pub type SetFunctionReturnMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReturnSetInfo {
    pub type_: NodeTag,
    pub econtext: *mut ExprContext,
    pub expectedDesc: TupleDesc,
    pub allowedModes: ::std::os::raw::c_int,
    pub returnMode: SetFunctionReturnMode,
    pub isDone: ExprDoneCond,
    pub setResult: *mut Tuplestorestate,
    pub setDesc: TupleDesc,
}
impl Default for ReturnSetInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct ProjectionInfo {
    pub type_: NodeTag,
    pub pi_state: ExprState,
    pub pi_exprContext: *mut ExprContext,
}
impl Default for ProjectionInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JunkFilter {
    pub type_: NodeTag,
    pub jf_targetList: *mut List,
    pub jf_cleanTupType: TupleDesc,
    pub jf_cleanMap: *mut AttrNumber,
    pub jf_resultSlot: *mut TupleTableSlot,
    pub jf_junkAttNo: AttrNumber,
}
impl Default for JunkFilter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictSetState {
    pub type_: NodeTag,
    pub oc_Existing: *mut TupleTableSlot,
    pub oc_ProjSlot: *mut TupleTableSlot,
    pub oc_ProjInfo: *mut ProjectionInfo,
    pub oc_WhereClause: *mut ExprState,
}
impl Default for OnConflictSetState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResultRelInfo {
    pub type_: NodeTag,
    pub ri_RangeTableIndex: Index,
    pub ri_RelationDesc: Relation,
    pub ri_NumIndices: ::std::os::raw::c_int,
    pub ri_IndexRelationDescs: RelationPtr,
    pub ri_IndexRelationInfo: *mut *mut IndexInfo,
    pub ri_TrigDesc: *mut TriggerDesc,
    pub ri_TrigFunctions: *mut FmgrInfo,
    pub ri_TrigWhenExprs: *mut *mut ExprState,
    pub ri_TrigInstrument: *mut Instrumentation,
    pub ri_ReturningSlot: *mut TupleTableSlot,
    pub ri_TrigOldSlot: *mut TupleTableSlot,
    pub ri_TrigNewSlot: *mut TupleTableSlot,
    pub ri_FdwRoutine: *mut FdwRoutine,
    pub ri_FdwState: *mut ::std::os::raw::c_void,
    pub ri_usesFdwDirectModify: bool,
    pub ri_WithCheckOptions: *mut List,
    pub ri_WithCheckOptionExprs: *mut List,
    pub ri_ConstraintExprs: *mut *mut ExprState,
    pub ri_GeneratedExprs: *mut *mut ExprState,
    pub ri_junkFilter: *mut JunkFilter,
    pub ri_returningList: *mut List,
    pub ri_projectReturning: *mut ProjectionInfo,
    pub ri_onConflictArbiterIndexes: *mut List,
    pub ri_onConflict: *mut OnConflictSetState,
    pub ri_PartitionCheck: *mut List,
    pub ri_PartitionCheckExpr: *mut ExprState,
    pub ri_RootResultRelInfo: *mut ResultRelInfo,
    pub ri_PartitionInfo: *mut PartitionRoutingInfo,
    pub ri_CopyMultiInsertBuffer: *mut CopyMultiInsertBuffer,
}
impl Default for ResultRelInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EState {
    pub type_: NodeTag,
    pub es_direction: ScanDirection,
    pub es_snapshot: Snapshot,
    pub es_crosscheck_snapshot: Snapshot,
    pub es_range_table: *mut List,
    pub es_range_table_array: *mut *mut RangeTblEntry,
    pub es_range_table_size: Index,
    pub es_relations: *mut Relation,
    pub es_rowmarks: *mut *mut ExecRowMark,
    pub es_plannedstmt: *mut PlannedStmt,
    pub es_sourceText: *const ::std::os::raw::c_char,
    pub es_junkFilter: *mut JunkFilter,
    pub es_output_cid: CommandId,
    pub es_result_relations: *mut ResultRelInfo,
    pub es_num_result_relations: ::std::os::raw::c_int,
    pub es_result_relation_info: *mut ResultRelInfo,
    pub es_root_result_relations: *mut ResultRelInfo,
    pub es_num_root_result_relations: ::std::os::raw::c_int,
    pub es_partition_directory: PartitionDirectory,
    pub es_tuple_routing_result_relations: *mut List,
    pub es_trig_target_relations: *mut List,
    pub es_param_list_info: ParamListInfo,
    pub es_param_exec_vals: *mut ParamExecData,
    pub es_queryEnv: *mut QueryEnvironment,
    pub es_query_cxt: MemoryContext,
    pub es_tupleTable: *mut List,
    pub es_processed: uint64,
    pub es_top_eflags: ::std::os::raw::c_int,
    pub es_instrument: ::std::os::raw::c_int,
    pub es_finished: bool,
    pub es_exprcontexts: *mut List,
    pub es_subplanstates: *mut List,
    pub es_auxmodifytables: *mut List,
    pub es_per_tuple_exprcontext: *mut ExprContext,
    pub es_epq_active: *mut EPQState,
    pub es_use_parallel_mode: bool,
    pub es_query_dsa: *mut dsa_area,
    pub es_jit_flags: ::std::os::raw::c_int,
    pub es_jit: *mut JitContext,
    pub es_jit_worker_instr: *mut JitInstrumentation,
}
impl Default for EState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecRowMark {
    pub relation: Relation,
    pub relid: Oid,
    pub rti: Index,
    pub prti: Index,
    pub rowmarkId: Index,
    pub markType: RowMarkType,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
    pub ermActive: bool,
    pub curCtid: ItemPointerData,
    pub ermExtra: *mut ::std::os::raw::c_void,
}
impl Default for ExecRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecAuxRowMark {
    pub rowmark: *mut ExecRowMark,
    pub ctidAttNo: AttrNumber,
    pub toidAttNo: AttrNumber,
    pub wholeAttNo: AttrNumber,
}
impl Default for ExecAuxRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleHashEntry = *mut TupleHashEntryData;
pub type TupleHashTable = *mut TupleHashTableData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleHashEntryData {
    pub firstTuple: MinimalTuple,
    pub additional: *mut ::std::os::raw::c_void,
    pub status: uint32,
    pub hash: uint32,
}
impl Default for TupleHashEntryData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tuplehash_hash {
    pub size: uint64,
    pub members: uint32,
    pub sizemask: uint32,
    pub grow_threshold: uint32,
    pub data: *mut TupleHashEntryData,
    pub ctx: MemoryContext,
    pub private_data: *mut ::std::os::raw::c_void,
}
impl Default for tuplehash_hash {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const tuplehash_status_tuplehash_SH_EMPTY: tuplehash_status = 0;
pub const tuplehash_status_tuplehash_SH_IN_USE: tuplehash_status = 1;
pub type tuplehash_status = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct tuplehash_iterator {
    pub cur: uint32,
    pub end: uint32,
    pub done: bool,
}
pub unsafe fn tuplehash_create(
    arg_ctx: MemoryContext,
    arg_nelements: uint32,
    arg_private_data: *mut ::std::os::raw::c_void,
) -> *mut tuplehash_hash {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_create(
                arg_ctx: MemoryContext,
                arg_nelements: uint32,
                arg_private_data: *mut ::std::os::raw::c_void,
            ) -> *mut tuplehash_hash;
        }
        tuplehash_create(arg_ctx, arg_nelements, arg_private_data)
    })
}
pub unsafe fn tuplehash_destroy(arg_tb: *mut tuplehash_hash) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_destroy(arg_tb: *mut tuplehash_hash);
        }
        tuplehash_destroy(arg_tb)
    })
}
pub unsafe fn tuplehash_reset(arg_tb: *mut tuplehash_hash) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_reset(arg_tb: *mut tuplehash_hash);
        }
        tuplehash_reset(arg_tb)
    })
}
pub unsafe fn tuplehash_grow(arg_tb: *mut tuplehash_hash, arg_newsize: uint64) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_grow(arg_tb: *mut tuplehash_hash, arg_newsize: uint64);
        }
        tuplehash_grow(arg_tb, arg_newsize)
    })
}
pub unsafe fn tuplehash_insert(
    arg_tb: *mut tuplehash_hash,
    arg_key: MinimalTuple,
    arg_found: *mut bool,
) -> *mut TupleHashEntryData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_insert(
                arg_tb: *mut tuplehash_hash,
                arg_key: MinimalTuple,
                arg_found: *mut bool,
            ) -> *mut TupleHashEntryData;
        }
        tuplehash_insert(arg_tb, arg_key, arg_found)
    })
}
pub unsafe fn tuplehash_lookup(
    arg_tb: *mut tuplehash_hash,
    arg_key: MinimalTuple,
) -> *mut TupleHashEntryData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_lookup(
                arg_tb: *mut tuplehash_hash,
                arg_key: MinimalTuple,
            ) -> *mut TupleHashEntryData;
        }
        tuplehash_lookup(arg_tb, arg_key)
    })
}
pub unsafe fn tuplehash_delete(arg_tb: *mut tuplehash_hash, arg_key: MinimalTuple) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_delete(arg_tb: *mut tuplehash_hash, arg_key: MinimalTuple) -> bool;
        }
        tuplehash_delete(arg_tb, arg_key)
    })
}
pub unsafe fn tuplehash_start_iterate(
    arg_tb: *mut tuplehash_hash,
    arg_iter: *mut tuplehash_iterator,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_start_iterate(
                arg_tb: *mut tuplehash_hash,
                arg_iter: *mut tuplehash_iterator,
            );
        }
        tuplehash_start_iterate(arg_tb, arg_iter)
    })
}
pub unsafe fn tuplehash_start_iterate_at(
    arg_tb: *mut tuplehash_hash,
    arg_iter: *mut tuplehash_iterator,
    arg_at: uint32,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_start_iterate_at(
                arg_tb: *mut tuplehash_hash,
                arg_iter: *mut tuplehash_iterator,
                arg_at: uint32,
            );
        }
        tuplehash_start_iterate_at(arg_tb, arg_iter, arg_at)
    })
}
pub unsafe fn tuplehash_iterate(
    arg_tb: *mut tuplehash_hash,
    arg_iter: *mut tuplehash_iterator,
) -> *mut TupleHashEntryData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_iterate(
                arg_tb: *mut tuplehash_hash,
                arg_iter: *mut tuplehash_iterator,
            ) -> *mut TupleHashEntryData;
        }
        tuplehash_iterate(arg_tb, arg_iter)
    })
}
pub unsafe fn tuplehash_stat(arg_tb: *mut tuplehash_hash) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_stat(arg_tb: *mut tuplehash_hash);
        }
        tuplehash_stat(arg_tb)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleHashTableData {
    pub hashtab: *mut tuplehash_hash,
    pub numCols: ::std::os::raw::c_int,
    pub keyColIdx: *mut AttrNumber,
    pub tab_hash_funcs: *mut FmgrInfo,
    pub tab_eq_func: *mut ExprState,
    pub tab_collations: *mut Oid,
    pub tablecxt: MemoryContext,
    pub tempcxt: MemoryContext,
    pub entrysize: Size,
    pub tableslot: *mut TupleTableSlot,
    pub inputslot: *mut TupleTableSlot,
    pub in_hash_funcs: *mut FmgrInfo,
    pub cur_eq_func: *mut ExprState,
    pub hash_iv: uint32,
    pub exprcontext: *mut ExprContext,
}
impl Default for TupleHashTableData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleHashIterator = tuplehash_iterator;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggrefExprState {
    pub type_: NodeTag,
    pub aggref: *mut Aggref,
    pub aggno: ::std::os::raw::c_int,
}
impl Default for AggrefExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowFuncExprState {
    pub type_: NodeTag,
    pub wfunc: *mut WindowFunc,
    pub args: *mut List,
    pub aggfilter: *mut ExprState,
    pub wfuncno: ::std::os::raw::c_int,
}
impl Default for WindowFuncExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetExprState {
    pub type_: NodeTag,
    pub expr: *mut Expr,
    pub args: *mut List,
    pub elidedFuncState: *mut ExprState,
    pub func: FmgrInfo,
    pub funcResultStore: *mut Tuplestorestate,
    pub funcResultSlot: *mut TupleTableSlot,
    pub funcResultDesc: TupleDesc,
    pub funcReturnsTuple: bool,
    pub funcReturnsSet: bool,
    pub setArgsValid: bool,
    pub shutdown_reg: bool,
    pub fcinfo: FunctionCallInfo,
}
impl Default for SetExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct SubPlanState {
    pub type_: NodeTag,
    pub subplan: *mut SubPlan,
    pub planstate: *mut PlanState,
    pub parent: *mut PlanState,
    pub testexpr: *mut ExprState,
    pub args: *mut List,
    pub curTuple: HeapTuple,
    pub curArray: Datum,
    pub descRight: TupleDesc,
    pub projLeft: *mut ProjectionInfo,
    pub projRight: *mut ProjectionInfo,
    pub hashtable: TupleHashTable,
    pub hashnulls: TupleHashTable,
    pub havehashrows: bool,
    pub havenullrows: bool,
    pub hashtablecxt: MemoryContext,
    pub hashtempcxt: MemoryContext,
    pub innerecontext: *mut ExprContext,
    pub keyColIdx: *mut AttrNumber,
    pub tab_eq_funcoids: *mut Oid,
    pub tab_collations: *mut Oid,
    pub tab_hash_funcs: *mut FmgrInfo,
    pub tab_eq_funcs: *mut FmgrInfo,
    pub lhs_hash_funcs: *mut FmgrInfo,
    pub cur_eq_funcs: *mut FmgrInfo,
    pub cur_eq_comp: *mut ExprState,
    pub numCols: ::std::os::raw::c_int,
}
impl Default for SubPlanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlternativeSubPlanState {
    pub type_: NodeTag,
    pub subplan: *mut AlternativeSubPlan,
    pub subplans: *mut List,
    pub active: ::std::os::raw::c_int,
}
impl Default for AlternativeSubPlanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DomainConstraintType_DOM_CONSTRAINT_NOTNULL: DomainConstraintType = 0;
pub const DomainConstraintType_DOM_CONSTRAINT_CHECK: DomainConstraintType = 1;
pub type DomainConstraintType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DomainConstraintState {
    pub type_: NodeTag,
    pub constrainttype: DomainConstraintType,
    pub name: *mut ::std::os::raw::c_char,
    pub check_expr: *mut Expr,
    pub check_exprstate: *mut ExprState,
}
impl Default for DomainConstraintState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExecProcNodeMtd =
    ::std::option::Option<unsafe extern "C" fn(pstate: *mut PlanState) -> *mut TupleTableSlot>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanState {
    pub type_: NodeTag,
    pub plan: *mut Plan,
    pub state: *mut EState,
    pub ExecProcNode: ExecProcNodeMtd,
    pub ExecProcNodeReal: ExecProcNodeMtd,
    pub instrument: *mut Instrumentation,
    pub worker_instrument: *mut WorkerInstrumentation,
    pub worker_jit_instrument: *mut SharedJitInstrumentation,
    pub qual: *mut ExprState,
    pub lefttree: *mut PlanState,
    pub righttree: *mut PlanState,
    pub initPlan: *mut List,
    pub subPlan: *mut List,
    pub chgParam: *mut Bitmapset,
    pub ps_ResultTupleDesc: TupleDesc,
    pub ps_ResultTupleSlot: *mut TupleTableSlot,
    pub ps_ExprContext: *mut ExprContext,
    pub ps_ProjInfo: *mut ProjectionInfo,
    pub scandesc: TupleDesc,
    pub scanops: *const TupleTableSlotOps,
    pub outerops: *const TupleTableSlotOps,
    pub innerops: *const TupleTableSlotOps,
    pub resultops: *const TupleTableSlotOps,
    pub scanopsfixed: bool,
    pub outeropsfixed: bool,
    pub inneropsfixed: bool,
    pub resultopsfixed: bool,
    pub scanopsset: bool,
    pub outeropsset: bool,
    pub inneropsset: bool,
    pub resultopsset: bool,
}
impl Default for PlanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EPQState {
    pub parentestate: *mut EState,
    pub epqParam: ::std::os::raw::c_int,
    pub tuple_table: *mut List,
    pub relsubs_slot: *mut *mut TupleTableSlot,
    pub plan: *mut Plan,
    pub arowMarks: *mut List,
    pub origslot: *mut TupleTableSlot,
    pub recheckestate: *mut EState,
    pub relsubs_rowmark: *mut *mut ExecAuxRowMark,
    pub relsubs_done: *mut bool,
    pub recheckplanstate: *mut PlanState,
}
impl Default for EPQState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResultState {
    pub ps: PlanState,
    pub resconstantqual: *mut ExprState,
    pub rs_done: bool,
    pub rs_checkqual: bool,
}
impl Default for ResultState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectSetState {
    pub ps: PlanState,
    pub elems: *mut *mut Node,
    pub elemdone: *mut ExprDoneCond,
    pub nelems: ::std::os::raw::c_int,
    pub pending_srf_tuples: bool,
    pub argcontext: MemoryContext,
}
impl Default for ProjectSetState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ModifyTableState {
    pub ps: PlanState,
    pub operation: CmdType,
    pub canSetTag: bool,
    pub mt_done: bool,
    pub mt_plans: *mut *mut PlanState,
    pub mt_nplans: ::std::os::raw::c_int,
    pub mt_whichplan: ::std::os::raw::c_int,
    pub mt_scans: *mut *mut TupleTableSlot,
    pub resultRelInfo: *mut ResultRelInfo,
    pub rootResultRelInfo: *mut ResultRelInfo,
    pub mt_arowmarks: *mut *mut List,
    pub mt_epqstate: EPQState,
    pub fireBSTriggers: bool,
    pub mt_excludedtlist: *mut List,
    pub mt_root_tuple_slot: *mut TupleTableSlot,
    pub mt_partition_tuple_routing: *mut PartitionTupleRouting,
    pub mt_transition_capture: *mut TransitionCaptureState,
    pub mt_oc_transition_capture: *mut TransitionCaptureState,
    pub mt_per_subplan_tupconv_maps: *mut *mut TupleConversionMap,
}
impl Default for ModifyTableState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelAppendState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AppendState {
    pub ps: PlanState,
    pub appendplans: *mut *mut PlanState,
    pub as_nplans: ::std::os::raw::c_int,
    pub as_whichplan: ::std::os::raw::c_int,
    pub as_first_partial_plan: ::std::os::raw::c_int,
    pub as_pstate: *mut ParallelAppendState,
    pub pstate_len: Size,
    pub as_prune_state: *mut PartitionPruneState,
    pub as_valid_subplans: *mut Bitmapset,
    pub choose_next_subplan:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut AppendState) -> bool>,
}
impl Default for AppendState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeAppendState {
    pub ps: PlanState,
    pub mergeplans: *mut *mut PlanState,
    pub ms_nplans: ::std::os::raw::c_int,
    pub ms_nkeys: ::std::os::raw::c_int,
    pub ms_sortkeys: SortSupport,
    pub ms_slots: *mut *mut TupleTableSlot,
    pub ms_heap: *mut binaryheap,
    pub ms_initialized: bool,
    pub ms_noopscan: bool,
    pub ms_prune_state: *mut PartitionPruneState,
    pub ms_valid_subplans: *mut Bitmapset,
}
impl Default for MergeAppendState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RecursiveUnionState {
    pub ps: PlanState,
    pub recursing: bool,
    pub intermediate_empty: bool,
    pub working_table: *mut Tuplestorestate,
    pub intermediate_table: *mut Tuplestorestate,
    pub eqfuncoids: *mut Oid,
    pub hashfunctions: *mut FmgrInfo,
    pub tempContext: MemoryContext,
    pub hashtable: TupleHashTable,
    pub tableContext: MemoryContext,
}
impl Default for RecursiveUnionState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapAndState {
    pub ps: PlanState,
    pub bitmapplans: *mut *mut PlanState,
    pub nplans: ::std::os::raw::c_int,
}
impl Default for BitmapAndState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapOrState {
    pub ps: PlanState,
    pub bitmapplans: *mut *mut PlanState,
    pub nplans: ::std::os::raw::c_int,
}
impl Default for BitmapOrState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScanState {
    pub ps: PlanState,
    pub ss_currentRelation: Relation,
    pub ss_currentScanDesc: *mut TableScanDescData,
    pub ss_ScanTupleSlot: *mut TupleTableSlot,
}
impl Default for ScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SeqScanState {
    pub ss: ScanState,
    pub pscan_len: Size,
}
impl Default for SeqScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SampleScanState {
    pub ss: ScanState,
    pub args: *mut List,
    pub repeatable: *mut ExprState,
    pub tsmroutine: *mut TsmRoutine,
    pub tsm_state: *mut ::std::os::raw::c_void,
    pub use_bulkread: bool,
    pub use_pagemode: bool,
    pub begun: bool,
    pub seed: uint32,
    pub donetuples: int64,
    pub haveblock: bool,
    pub done: bool,
}
impl Default for SampleScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexRuntimeKeyInfo {
    pub scan_key: *mut ScanKeyData,
    pub key_expr: *mut ExprState,
    pub key_toastable: bool,
}
impl Default for IndexRuntimeKeyInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexArrayKeyInfo {
    pub scan_key: *mut ScanKeyData,
    pub array_expr: *mut ExprState,
    pub next_elem: ::std::os::raw::c_int,
    pub num_elems: ::std::os::raw::c_int,
    pub elem_values: *mut Datum,
    pub elem_nulls: *mut bool,
}
impl Default for IndexArrayKeyInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScanState {
    pub ss: ScanState,
    pub indexqualorig: *mut ExprState,
    pub indexorderbyorig: *mut List,
    pub iss_ScanKeys: *mut ScanKeyData,
    pub iss_NumScanKeys: ::std::os::raw::c_int,
    pub iss_OrderByKeys: *mut ScanKeyData,
    pub iss_NumOrderByKeys: ::std::os::raw::c_int,
    pub iss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub iss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub iss_RuntimeKeysReady: bool,
    pub iss_RuntimeContext: *mut ExprContext,
    pub iss_RelationDesc: Relation,
    pub iss_ScanDesc: *mut IndexScanDescData,
    pub iss_ReorderQueue: *mut pairingheap,
    pub iss_ReachedEnd: bool,
    pub iss_OrderByValues: *mut Datum,
    pub iss_OrderByNulls: *mut bool,
    pub iss_SortSupport: SortSupport,
    pub iss_OrderByTypByVals: *mut bool,
    pub iss_OrderByTypLens: *mut int16,
    pub iss_PscanLen: Size,
}
impl Default for IndexScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexOnlyScanState {
    pub ss: ScanState,
    pub recheckqual: *mut ExprState,
    pub ioss_ScanKeys: *mut ScanKeyData,
    pub ioss_NumScanKeys: ::std::os::raw::c_int,
    pub ioss_OrderByKeys: *mut ScanKeyData,
    pub ioss_NumOrderByKeys: ::std::os::raw::c_int,
    pub ioss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub ioss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub ioss_RuntimeKeysReady: bool,
    pub ioss_RuntimeContext: *mut ExprContext,
    pub ioss_RelationDesc: Relation,
    pub ioss_ScanDesc: *mut IndexScanDescData,
    pub ioss_TableSlot: *mut TupleTableSlot,
    pub ioss_VMBuffer: Buffer,
    pub ioss_PscanLen: Size,
}
impl Default for IndexOnlyScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapIndexScanState {
    pub ss: ScanState,
    pub biss_result: *mut TIDBitmap,
    pub biss_ScanKeys: *mut ScanKeyData,
    pub biss_NumScanKeys: ::std::os::raw::c_int,
    pub biss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub biss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub biss_ArrayKeys: *mut IndexArrayKeyInfo,
    pub biss_NumArrayKeys: ::std::os::raw::c_int,
    pub biss_RuntimeKeysReady: bool,
    pub biss_RuntimeContext: *mut ExprContext,
    pub biss_RelationDesc: Relation,
    pub biss_ScanDesc: *mut IndexScanDescData,
}
impl Default for BitmapIndexScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SharedBitmapState_BM_INITIAL: SharedBitmapState = 0;
pub const SharedBitmapState_BM_INPROGRESS: SharedBitmapState = 1;
pub const SharedBitmapState_BM_FINISHED: SharedBitmapState = 2;
pub type SharedBitmapState = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct ParallelBitmapHeapState {
    pub tbmiterator: dsa_pointer,
    pub prefetch_iterator: dsa_pointer,
    pub mutex: slock_t,
    pub prefetch_pages: ::std::os::raw::c_int,
    pub prefetch_target: ::std::os::raw::c_int,
    pub state: SharedBitmapState,
    pub cv: ConditionVariable,
    pub phs_snapshot_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
impl Default for ParallelBitmapHeapState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapHeapScanState {
    pub ss: ScanState,
    pub bitmapqualorig: *mut ExprState,
    pub tbm: *mut TIDBitmap,
    pub tbmiterator: *mut TBMIterator,
    pub tbmres: *mut TBMIterateResult,
    pub can_skip_fetch: bool,
    pub return_empty_tuples: ::std::os::raw::c_int,
    pub vmbuffer: Buffer,
    pub pvmbuffer: Buffer,
    pub exact_pages: ::std::os::raw::c_long,
    pub lossy_pages: ::std::os::raw::c_long,
    pub prefetch_iterator: *mut TBMIterator,
    pub prefetch_pages: ::std::os::raw::c_int,
    pub prefetch_target: ::std::os::raw::c_int,
    pub prefetch_maximum: ::std::os::raw::c_int,
    pub pscan_len: Size,
    pub initialized: bool,
    pub shared_tbmiterator: *mut TBMSharedIterator,
    pub shared_prefetch_iterator: *mut TBMSharedIterator,
    pub pstate: *mut ParallelBitmapHeapState,
}
impl Default for BitmapHeapScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidScanState {
    pub ss: ScanState,
    pub tss_tidexprs: *mut List,
    pub tss_isCurrentOf: bool,
    pub tss_NumTids: ::std::os::raw::c_int,
    pub tss_TidPtr: ::std::os::raw::c_int,
    pub tss_TidList: *mut ItemPointerData,
    pub tss_htup: HeapTupleData,
}
impl Default for TidScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubqueryScanState {
    pub ss: ScanState,
    pub subplan: *mut PlanState,
}
impl Default for SubqueryScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScanPerFuncState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScanState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub ordinality: bool,
    pub simple: bool,
    pub ordinal: int64,
    pub nfuncs: ::std::os::raw::c_int,
    pub funcstates: *mut FunctionScanPerFuncState,
    pub argcontext: MemoryContext,
}
impl Default for FunctionScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValuesScanState {
    pub ss: ScanState,
    pub rowcontext: *mut ExprContext,
    pub exprlists: *mut *mut List,
    pub array_len: ::std::os::raw::c_int,
    pub curr_idx: ::std::os::raw::c_int,
    pub exprstatelists: *mut *mut List,
}
impl Default for ValuesScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFuncScanState {
    pub ss: ScanState,
    pub docexpr: *mut ExprState,
    pub rowexpr: *mut ExprState,
    pub colexprs: *mut List,
    pub coldefexprs: *mut List,
    pub ns_names: *mut List,
    pub ns_uris: *mut List,
    pub notnulls: *mut Bitmapset,
    pub opaque: *mut ::std::os::raw::c_void,
    pub routine: *mut TableFuncRoutine,
    pub in_functions: *mut FmgrInfo,
    pub typioparams: *mut Oid,
    pub ordinal: int64,
    pub perTableCxt: MemoryContext,
    pub tupstore: *mut Tuplestorestate,
}
impl Default for TableFuncScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CteScanState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub readptr: ::std::os::raw::c_int,
    pub cteplanstate: *mut PlanState,
    pub leader: *mut CteScanState,
    pub cte_table: *mut Tuplestorestate,
    pub eof_cte: bool,
}
impl Default for CteScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedTuplestoreScanState {
    pub ss: ScanState,
    pub readptr: ::std::os::raw::c_int,
    pub tupdesc: TupleDesc,
    pub relation: *mut Tuplestorestate,
}
impl Default for NamedTuplestoreScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WorkTableScanState {
    pub ss: ScanState,
    pub rustate: *mut RecursiveUnionState,
}
impl Default for WorkTableScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignScanState {
    pub ss: ScanState,
    pub fdw_recheck_quals: *mut ExprState,
    pub pscan_len: Size,
    pub fdwroutine: *mut FdwRoutine,
    pub fdw_state: *mut ::std::os::raw::c_void,
}
impl Default for ForeignScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomScanState {
    pub ss: ScanState,
    pub flags: uint32,
    pub custom_ps: *mut List,
    pub pscan_len: Size,
    pub methods: *const CustomExecMethods,
}
impl Default for CustomScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JoinState {
    pub ps: PlanState,
    pub jointype: JoinType,
    pub single_match: bool,
    pub joinqual: *mut ExprState,
}
impl Default for JoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoopState {
    pub js: JoinState,
    pub nl_NeedNewOuter: bool,
    pub nl_MatchedOuter: bool,
    pub nl_NullInnerTupleSlot: *mut TupleTableSlot,
}
impl Default for NestLoopState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoinClauseData {
    _unused: [u8; 0],
}
pub type MergeJoinClause = *mut MergeJoinClauseData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoinState {
    pub js: JoinState,
    pub mj_NumClauses: ::std::os::raw::c_int,
    pub mj_Clauses: MergeJoinClause,
    pub mj_JoinState: ::std::os::raw::c_int,
    pub mj_SkipMarkRestore: bool,
    pub mj_ExtraMarks: bool,
    pub mj_ConstFalseJoin: bool,
    pub mj_FillOuter: bool,
    pub mj_FillInner: bool,
    pub mj_MatchedOuter: bool,
    pub mj_MatchedInner: bool,
    pub mj_OuterTupleSlot: *mut TupleTableSlot,
    pub mj_InnerTupleSlot: *mut TupleTableSlot,
    pub mj_MarkedTupleSlot: *mut TupleTableSlot,
    pub mj_NullOuterTupleSlot: *mut TupleTableSlot,
    pub mj_NullInnerTupleSlot: *mut TupleTableSlot,
    pub mj_OuterEContext: *mut ExprContext,
    pub mj_InnerEContext: *mut ExprContext,
}
impl Default for MergeJoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinTupleData {
    _unused: [u8; 0],
}
pub type HashJoinTuple = *mut HashJoinTupleData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinTableData {
    _unused: [u8; 0],
}
pub type HashJoinTable = *mut HashJoinTableData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinState {
    pub js: JoinState,
    pub hashclauses: *mut ExprState,
    pub hj_OuterHashKeys: *mut List,
    pub hj_HashOperators: *mut List,
    pub hj_Collations: *mut List,
    pub hj_HashTable: HashJoinTable,
    pub hj_CurHashValue: uint32,
    pub hj_CurBucketNo: ::std::os::raw::c_int,
    pub hj_CurSkewBucketNo: ::std::os::raw::c_int,
    pub hj_CurTuple: HashJoinTuple,
    pub hj_OuterTupleSlot: *mut TupleTableSlot,
    pub hj_HashTupleSlot: *mut TupleTableSlot,
    pub hj_NullOuterTupleSlot: *mut TupleTableSlot,
    pub hj_NullInnerTupleSlot: *mut TupleTableSlot,
    pub hj_FirstOuterTupleSlot: *mut TupleTableSlot,
    pub hj_JoinState: ::std::os::raw::c_int,
    pub hj_MatchedOuter: bool,
    pub hj_OuterNotEmpty: bool,
}
impl Default for HashJoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MaterialState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub eof_underlying: bool,
    pub tuplestorestate: *mut Tuplestorestate,
}
impl Default for MaterialState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SharedSortInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub sinstrument: __IncompleteArrayField<TuplesortInstrumentation>,
}
impl Default for SharedSortInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortState {
    pub ss: ScanState,
    pub randomAccess: bool,
    pub bounded: bool,
    pub bound: int64,
    pub sort_Done: bool,
    pub bounded_Done: bool,
    pub bound_Done: int64,
    pub tuplesortstate: *mut ::std::os::raw::c_void,
    pub am_worker: bool,
    pub shared_info: *mut SharedSortInfo,
}
impl Default for SortState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupState {
    pub ss: ScanState,
    pub eqfunction: *mut ExprState,
    pub grp_done: bool,
}
impl Default for GroupState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerAggData {
    _unused: [u8; 0],
}
pub type AggStatePerAgg = *mut AggStatePerAggData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerTransData {
    _unused: [u8; 0],
}
pub type AggStatePerTrans = *mut AggStatePerTransData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerGroupData {
    _unused: [u8; 0],
}
pub type AggStatePerGroup = *mut AggStatePerGroupData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerPhaseData {
    _unused: [u8; 0],
}
pub type AggStatePerPhase = *mut AggStatePerPhaseData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerHashData {
    _unused: [u8; 0],
}
pub type AggStatePerHash = *mut AggStatePerHashData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggState {
    pub ss: ScanState,
    pub aggs: *mut List,
    pub numaggs: ::std::os::raw::c_int,
    pub numtrans: ::std::os::raw::c_int,
    pub aggstrategy: AggStrategy,
    pub aggsplit: AggSplit,
    pub phase: AggStatePerPhase,
    pub numphases: ::std::os::raw::c_int,
    pub current_phase: ::std::os::raw::c_int,
    pub peragg: AggStatePerAgg,
    pub pertrans: AggStatePerTrans,
    pub hashcontext: *mut ExprContext,
    pub aggcontexts: *mut *mut ExprContext,
    pub tmpcontext: *mut ExprContext,
    pub curaggcontext: *mut ExprContext,
    pub curperagg: AggStatePerAgg,
    pub curpertrans: AggStatePerTrans,
    pub input_done: bool,
    pub agg_done: bool,
    pub projected_set: ::std::os::raw::c_int,
    pub current_set: ::std::os::raw::c_int,
    pub grouped_cols: *mut Bitmapset,
    pub all_grouped_cols: *mut List,
    pub maxsets: ::std::os::raw::c_int,
    pub phases: AggStatePerPhase,
    pub sort_in: *mut Tuplesortstate,
    pub sort_out: *mut Tuplesortstate,
    pub sort_slot: *mut TupleTableSlot,
    pub pergroups: *mut AggStatePerGroup,
    pub grp_firstTuple: HeapTuple,
    pub table_filled: bool,
    pub num_hashes: ::std::os::raw::c_int,
    pub perhash: AggStatePerHash,
    pub hash_pergroup: *mut AggStatePerGroup,
    pub all_pergroups: *mut AggStatePerGroup,
    pub combinedproj: *mut ProjectionInfo,
}
impl Default for AggState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowStatePerFuncData {
    _unused: [u8; 0],
}
pub type WindowStatePerFunc = *mut WindowStatePerFuncData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowStatePerAggData {
    _unused: [u8; 0],
}
pub type WindowStatePerAgg = *mut WindowStatePerAggData;
#[repr(C)]
pub struct WindowAggState {
    pub ss: ScanState,
    pub funcs: *mut List,
    pub numfuncs: ::std::os::raw::c_int,
    pub numaggs: ::std::os::raw::c_int,
    pub perfunc: WindowStatePerFunc,
    pub peragg: WindowStatePerAgg,
    pub partEqfunction: *mut ExprState,
    pub ordEqfunction: *mut ExprState,
    pub buffer: *mut Tuplestorestate,
    pub current_ptr: ::std::os::raw::c_int,
    pub framehead_ptr: ::std::os::raw::c_int,
    pub frametail_ptr: ::std::os::raw::c_int,
    pub grouptail_ptr: ::std::os::raw::c_int,
    pub spooled_rows: int64,
    pub currentpos: int64,
    pub frameheadpos: int64,
    pub frametailpos: int64,
    pub agg_winobj: *mut WindowObjectData,
    pub aggregatedbase: int64,
    pub aggregatedupto: int64,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut ExprState,
    pub endOffset: *mut ExprState,
    pub startOffsetValue: Datum,
    pub endOffsetValue: Datum,
    pub startInRangeFunc: FmgrInfo,
    pub endInRangeFunc: FmgrInfo,
    pub inRangeColl: Oid,
    pub inRangeAsc: bool,
    pub inRangeNullsFirst: bool,
    pub currentgroup: int64,
    pub frameheadgroup: int64,
    pub frametailgroup: int64,
    pub groupheadpos: int64,
    pub grouptailpos: int64,
    pub partcontext: MemoryContext,
    pub aggcontext: MemoryContext,
    pub curaggcontext: MemoryContext,
    pub tmpcontext: *mut ExprContext,
    pub all_first: bool,
    pub all_done: bool,
    pub partition_spooled: bool,
    pub more_partitions: bool,
    pub framehead_valid: bool,
    pub frametail_valid: bool,
    pub grouptail_valid: bool,
    pub first_part_slot: *mut TupleTableSlot,
    pub framehead_slot: *mut TupleTableSlot,
    pub frametail_slot: *mut TupleTableSlot,
    pub agg_row_slot: *mut TupleTableSlot,
    pub temp_slot_1: *mut TupleTableSlot,
    pub temp_slot_2: *mut TupleTableSlot,
}
impl Default for WindowAggState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UniqueState {
    pub ps: PlanState,
    pub eqfunction: *mut ExprState,
}
impl Default for UniqueState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherState {
    pub ps: PlanState,
    pub initialized: bool,
    pub need_to_scan_locally: bool,
    pub tuples_needed: int64,
    pub funnel_slot: *mut TupleTableSlot,
    pub pei: *mut ParallelExecutorInfo,
    pub nworkers_launched: ::std::os::raw::c_int,
    pub nreaders: ::std::os::raw::c_int,
    pub nextreader: ::std::os::raw::c_int,
    pub reader: *mut *mut TupleQueueReader,
}
impl Default for GatherState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GMReaderTupleBuffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherMergeState {
    pub ps: PlanState,
    pub initialized: bool,
    pub gm_initialized: bool,
    pub need_to_scan_locally: bool,
    pub tuples_needed: int64,
    pub tupDesc: TupleDesc,
    pub gm_nkeys: ::std::os::raw::c_int,
    pub gm_sortkeys: SortSupport,
    pub pei: *mut ParallelExecutorInfo,
    pub nworkers_launched: ::std::os::raw::c_int,
    pub nreaders: ::std::os::raw::c_int,
    pub gm_slots: *mut *mut TupleTableSlot,
    pub reader: *mut *mut TupleQueueReader,
    pub gm_tuple_buffers: *mut GMReaderTupleBuffer,
    pub gm_heap: *mut binaryheap,
}
impl Default for GatherMergeState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct HashInstrumentation {
    pub nbuckets: ::std::os::raw::c_int,
    pub nbuckets_original: ::std::os::raw::c_int,
    pub nbatch: ::std::os::raw::c_int,
    pub nbatch_original: ::std::os::raw::c_int,
    pub space_peak: usize,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedHashInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub hinstrument: __IncompleteArrayField<HashInstrumentation>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashState {
    pub ps: PlanState,
    pub hashtable: HashJoinTable,
    pub hashkeys: *mut List,
    pub shared_info: *mut SharedHashInfo,
    pub hinstrument: *mut HashInstrumentation,
    pub parallel_state: *mut ParallelHashJoinState,
}
impl Default for HashState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOpStatePerGroupData {
    _unused: [u8; 0],
}
pub type SetOpStatePerGroup = *mut SetOpStatePerGroupData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOpState {
    pub ps: PlanState,
    pub eqfunction: *mut ExprState,
    pub eqfuncoids: *mut Oid,
    pub hashfunctions: *mut FmgrInfo,
    pub setop_done: bool,
    pub numOutput: ::std::os::raw::c_long,
    pub pergroup: SetOpStatePerGroup,
    pub grp_firstTuple: HeapTuple,
    pub hashtable: TupleHashTable,
    pub tableContext: MemoryContext,
    pub table_filled: bool,
    pub hashiter: TupleHashIterator,
}
impl Default for SetOpState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRowsState {
    pub ps: PlanState,
    pub lr_arowMarks: *mut List,
    pub lr_epqstate: EPQState,
}
impl Default for LockRowsState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const LimitStateCond_LIMIT_INITIAL: LimitStateCond = 0;
pub const LimitStateCond_LIMIT_RESCAN: LimitStateCond = 1;
pub const LimitStateCond_LIMIT_EMPTY: LimitStateCond = 2;
pub const LimitStateCond_LIMIT_INWINDOW: LimitStateCond = 3;
pub const LimitStateCond_LIMIT_SUBPLANEOF: LimitStateCond = 4;
pub const LimitStateCond_LIMIT_WINDOWEND: LimitStateCond = 5;
pub const LimitStateCond_LIMIT_WINDOWSTART: LimitStateCond = 6;
pub type LimitStateCond = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LimitState {
    pub ps: PlanState,
    pub limitOffset: *mut ExprState,
    pub limitCount: *mut ExprState,
    pub offset: int64,
    pub count: int64,
    pub noCount: bool,
    pub lstate: LimitStateCond,
    pub position: int64,
    pub subSlot: *mut TupleTableSlot,
}
impl Default for LimitState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const CommandDest_DestNone: CommandDest = 0;
pub const CommandDest_DestDebug: CommandDest = 1;
pub const CommandDest_DestRemote: CommandDest = 2;
pub const CommandDest_DestRemoteExecute: CommandDest = 3;
pub const CommandDest_DestRemoteSimple: CommandDest = 4;
pub const CommandDest_DestSPI: CommandDest = 5;
pub const CommandDest_DestTuplestore: CommandDest = 6;
pub const CommandDest_DestIntoRel: CommandDest = 7;
pub const CommandDest_DestCopyOut: CommandDest = 8;
pub const CommandDest_DestSQLFunction: CommandDest = 9;
pub const CommandDest_DestTransientRel: CommandDest = 10;
pub const CommandDest_DestTupleQueue: CommandDest = 11;
pub type CommandDest = ::std::os::raw::c_uint;
pub type DestReceiver = _DestReceiver;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _DestReceiver {
    pub receiveSlot: ::std::option::Option<
        unsafe extern "C" fn(slot: *mut TupleTableSlot, self_: *mut DestReceiver) -> bool,
    >,
    pub rStartup: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut DestReceiver,
            operation: ::std::os::raw::c_int,
            typeinfo: TupleDesc,
        ),
    >,
    pub rShutdown: ::std::option::Option<unsafe extern "C" fn(self_: *mut DestReceiver)>,
    pub rDestroy: ::std::option::Option<unsafe extern "C" fn(self_: *mut DestReceiver)>,
    pub mydest: CommandDest,
}
impl Default for _DestReceiver {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut None_Receiver: *mut DestReceiver;
}
pub unsafe fn BeginCommand(arg_commandTag: *const ::std::os::raw::c_char, arg_dest: CommandDest) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BeginCommand(arg_commandTag: *const ::std::os::raw::c_char, arg_dest: CommandDest);
        }
        BeginCommand(arg_commandTag, arg_dest)
    })
}
pub unsafe fn CreateDestReceiver(arg_dest: CommandDest) -> *mut DestReceiver {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateDestReceiver(arg_dest: CommandDest) -> *mut DestReceiver;
        }
        CreateDestReceiver(arg_dest)
    })
}
pub unsafe fn EndCommand(arg_commandTag: *const ::std::os::raw::c_char, arg_dest: CommandDest) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EndCommand(arg_commandTag: *const ::std::os::raw::c_char, arg_dest: CommandDest);
        }
        EndCommand(arg_commandTag, arg_dest)
    })
}
pub unsafe fn NullCommand(arg_dest: CommandDest) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn NullCommand(arg_dest: CommandDest);
        }
        NullCommand(arg_dest)
    })
}
pub unsafe fn ReadyForQuery(arg_dest: CommandDest) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReadyForQuery(arg_dest: CommandDest);
        }
        ReadyForQuery(arg_dest)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryDesc {
    pub operation: CmdType,
    pub plannedstmt: *mut PlannedStmt,
    pub sourceText: *const ::std::os::raw::c_char,
    pub snapshot: Snapshot,
    pub crosscheck_snapshot: Snapshot,
    pub dest: *mut DestReceiver,
    pub params: ParamListInfo,
    pub queryEnv: *mut QueryEnvironment,
    pub instrument_options: ::std::os::raw::c_int,
    pub tupDesc: TupleDesc,
    pub estate: *mut EState,
    pub planstate: *mut PlanState,
    pub already_executed: bool,
    pub totaltime: *mut Instrumentation,
}
impl Default for QueryDesc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn CreateQueryDesc(
    arg_plannedstmt: *mut PlannedStmt,
    arg_sourceText: *const ::std::os::raw::c_char,
    arg_snapshot: Snapshot,
    arg_crosscheck_snapshot: Snapshot,
    arg_dest: *mut DestReceiver,
    arg_params: ParamListInfo,
    arg_queryEnv: *mut QueryEnvironment,
    arg_instrument_options: ::std::os::raw::c_int,
) -> *mut QueryDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateQueryDesc(
                arg_plannedstmt: *mut PlannedStmt,
                arg_sourceText: *const ::std::os::raw::c_char,
                arg_snapshot: Snapshot,
                arg_crosscheck_snapshot: Snapshot,
                arg_dest: *mut DestReceiver,
                arg_params: ParamListInfo,
                arg_queryEnv: *mut QueryEnvironment,
                arg_instrument_options: ::std::os::raw::c_int,
            ) -> *mut QueryDesc;
        }
        CreateQueryDesc(
            arg_plannedstmt,
            arg_sourceText,
            arg_snapshot,
            arg_crosscheck_snapshot,
            arg_dest,
            arg_params,
            arg_queryEnv,
            arg_instrument_options,
        )
    })
}
pub unsafe fn FreeQueryDesc(arg_qdesc: *mut QueryDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeQueryDesc(arg_qdesc: *mut QueryDesc);
        }
        FreeQueryDesc(arg_qdesc)
    })
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Value {
    pub type_: NodeTag,
    pub val: Value_ValUnion,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union Value_ValUnion {
    pub ival: ::std::os::raw::c_int,
    pub str_: *mut ::std::os::raw::c_char,
}
impl Default for Value_ValUnion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for Value {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn makeInteger(arg_i: ::std::os::raw::c_int) -> *mut Value {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeInteger(arg_i: ::std::os::raw::c_int) -> *mut Value;
        }
        makeInteger(arg_i)
    })
}
pub unsafe fn makeFloat(arg_numericStr: *mut ::std::os::raw::c_char) -> *mut Value {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeFloat(arg_numericStr: *mut ::std::os::raw::c_char) -> *mut Value;
        }
        makeFloat(arg_numericStr)
    })
}
pub unsafe fn makeString(arg_str_: *mut ::std::os::raw::c_char) -> *mut Value {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeString(arg_str_: *mut ::std::os::raw::c_char) -> *mut Value;
        }
        makeString(arg_str_)
    })
}
pub unsafe fn makeBitString(arg_str_: *mut ::std::os::raw::c_char) -> *mut Value {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeBitString(arg_str_: *mut ::std::os::raw::c_char) -> *mut Value;
        }
        makeBitString(arg_str_)
    })
}
pub const OverridingKind_OVERRIDING_NOT_SET: OverridingKind = 0;
pub const OverridingKind_OVERRIDING_USER_VALUE: OverridingKind = 1;
pub const OverridingKind_OVERRIDING_SYSTEM_VALUE: OverridingKind = 2;
pub type OverridingKind = ::std::os::raw::c_uint;
pub const QuerySource_QSRC_ORIGINAL: QuerySource = 0;
pub const QuerySource_QSRC_PARSER: QuerySource = 1;
pub const QuerySource_QSRC_INSTEAD_RULE: QuerySource = 2;
pub const QuerySource_QSRC_QUAL_INSTEAD_RULE: QuerySource = 3;
pub const QuerySource_QSRC_NON_INSTEAD_RULE: QuerySource = 4;
pub type QuerySource = ::std::os::raw::c_uint;
pub const SortByDir_SORTBY_DEFAULT: SortByDir = 0;
pub const SortByDir_SORTBY_ASC: SortByDir = 1;
pub const SortByDir_SORTBY_DESC: SortByDir = 2;
pub const SortByDir_SORTBY_USING: SortByDir = 3;
pub type SortByDir = ::std::os::raw::c_uint;
pub const SortByNulls_SORTBY_NULLS_DEFAULT: SortByNulls = 0;
pub const SortByNulls_SORTBY_NULLS_FIRST: SortByNulls = 1;
pub const SortByNulls_SORTBY_NULLS_LAST: SortByNulls = 2;
pub type SortByNulls = ::std::os::raw::c_uint;
pub type AclMode = uint32;
#[doc = "\tQuery Tree"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Query {
    pub type_: NodeTag,
    pub commandType: CmdType,
    pub querySource: QuerySource,
    pub queryId: uint64,
    pub canSetTag: bool,
    pub utilityStmt: *mut Node,
    pub resultRelation: ::std::os::raw::c_int,
    pub hasAggs: bool,
    pub hasWindowFuncs: bool,
    pub hasTargetSRFs: bool,
    pub hasSubLinks: bool,
    pub hasDistinctOn: bool,
    pub hasRecursive: bool,
    pub hasModifyingCTE: bool,
    pub hasForUpdate: bool,
    pub hasRowSecurity: bool,
    pub cteList: *mut List,
    pub rtable: *mut List,
    pub jointree: *mut FromExpr,
    pub targetList: *mut List,
    pub override_: OverridingKind,
    pub onConflict: *mut OnConflictExpr,
    pub returningList: *mut List,
    pub groupClause: *mut List,
    pub groupingSets: *mut List,
    pub havingQual: *mut Node,
    pub windowClause: *mut List,
    pub distinctClause: *mut List,
    pub sortClause: *mut List,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub rowMarks: *mut List,
    pub setOperations: *mut Node,
    pub constraintDeps: *mut List,
    pub withCheckOptions: *mut List,
    pub stmt_location: ::std::os::raw::c_int,
    pub stmt_len: ::std::os::raw::c_int,
}
impl Default for Query {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\tSupporting data structures for Parse Trees"]
#[doc = ""]
#[doc = "\tMost of these node types appear in raw parsetrees output by the grammar,"]
#[doc = "\tand get transformed to something else by the analyzer.  A few of them"]
#[doc = "\tare used as-is in transformed querytrees."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeName {
    pub type_: NodeTag,
    pub names: *mut List,
    pub typeOid: Oid,
    pub setof: bool,
    pub pct_type: bool,
    pub typmods: *mut List,
    pub typemod: int32,
    pub arrayBounds: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for TypeName {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ColumnRef {
    pub type_: NodeTag,
    pub fields: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ColumnRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamRef {
    pub type_: NodeTag,
    pub number: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for ParamRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const A_Expr_Kind_AEXPR_OP: A_Expr_Kind = 0;
pub const A_Expr_Kind_AEXPR_OP_ANY: A_Expr_Kind = 1;
pub const A_Expr_Kind_AEXPR_OP_ALL: A_Expr_Kind = 2;
pub const A_Expr_Kind_AEXPR_DISTINCT: A_Expr_Kind = 3;
pub const A_Expr_Kind_AEXPR_NOT_DISTINCT: A_Expr_Kind = 4;
pub const A_Expr_Kind_AEXPR_NULLIF: A_Expr_Kind = 5;
pub const A_Expr_Kind_AEXPR_OF: A_Expr_Kind = 6;
pub const A_Expr_Kind_AEXPR_IN: A_Expr_Kind = 7;
pub const A_Expr_Kind_AEXPR_LIKE: A_Expr_Kind = 8;
pub const A_Expr_Kind_AEXPR_ILIKE: A_Expr_Kind = 9;
pub const A_Expr_Kind_AEXPR_SIMILAR: A_Expr_Kind = 10;
pub const A_Expr_Kind_AEXPR_BETWEEN: A_Expr_Kind = 11;
pub const A_Expr_Kind_AEXPR_NOT_BETWEEN: A_Expr_Kind = 12;
pub const A_Expr_Kind_AEXPR_BETWEEN_SYM: A_Expr_Kind = 13;
pub const A_Expr_Kind_AEXPR_NOT_BETWEEN_SYM: A_Expr_Kind = 14;
pub const A_Expr_Kind_AEXPR_PAREN: A_Expr_Kind = 15;
pub type A_Expr_Kind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Expr {
    pub type_: NodeTag,
    pub kind: A_Expr_Kind,
    pub name: *mut List,
    pub lexpr: *mut Node,
    pub rexpr: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_Expr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct A_Const {
    pub type_: NodeTag,
    pub val: Value,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_Const {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeCast {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub typeName: *mut TypeName,
    pub location: ::std::os::raw::c_int,
}
impl Default for TypeCast {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollateClause {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub collname: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for CollateClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RoleSpecType_ROLESPEC_CSTRING: RoleSpecType = 0;
pub const RoleSpecType_ROLESPEC_CURRENT_USER: RoleSpecType = 1;
pub const RoleSpecType_ROLESPEC_SESSION_USER: RoleSpecType = 2;
pub const RoleSpecType_ROLESPEC_PUBLIC: RoleSpecType = 3;
pub type RoleSpecType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RoleSpec {
    pub type_: NodeTag,
    pub roletype: RoleSpecType,
    pub rolename: *mut ::std::os::raw::c_char,
    pub location: ::std::os::raw::c_int,
}
impl Default for RoleSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncCall {
    pub type_: NodeTag,
    pub funcname: *mut List,
    pub args: *mut List,
    pub agg_order: *mut List,
    pub agg_filter: *mut Node,
    pub agg_within_group: bool,
    pub agg_star: bool,
    pub agg_distinct: bool,
    pub func_variadic: bool,
    pub over: *mut WindowDef,
    pub location: ::std::os::raw::c_int,
}
impl Default for FuncCall {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Star {
    pub type_: NodeTag,
}
impl Default for A_Star {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Indices {
    pub type_: NodeTag,
    pub is_slice: bool,
    pub lidx: *mut Node,
    pub uidx: *mut Node,
}
impl Default for A_Indices {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Indirection {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub indirection: *mut List,
}
impl Default for A_Indirection {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_ArrayExpr {
    pub type_: NodeTag,
    pub elements: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_ArrayExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResTarget {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub indirection: *mut List,
    pub val: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for ResTarget {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MultiAssignRef {
    pub type_: NodeTag,
    pub source: *mut Node,
    pub colno: ::std::os::raw::c_int,
    pub ncolumns: ::std::os::raw::c_int,
}
impl Default for MultiAssignRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortBy {
    pub type_: NodeTag,
    pub node: *mut Node,
    pub sortby_dir: SortByDir,
    pub sortby_nulls: SortByNulls,
    pub useOp: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for SortBy {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowDef {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub refname: *mut ::std::os::raw::c_char,
    pub partitionClause: *mut List,
    pub orderClause: *mut List,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for WindowDef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeSubselect {
    pub type_: NodeTag,
    pub lateral: bool,
    pub subquery: *mut Node,
    pub alias: *mut Alias,
}
impl Default for RangeSubselect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeFunction {
    pub type_: NodeTag,
    pub lateral: bool,
    pub ordinality: bool,
    pub is_rowsfrom: bool,
    pub functions: *mut List,
    pub alias: *mut Alias,
    pub coldeflist: *mut List,
}
impl Default for RangeFunction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableFunc {
    pub type_: NodeTag,
    pub lateral: bool,
    pub docexpr: *mut Node,
    pub rowexpr: *mut Node,
    pub namespaces: *mut List,
    pub columns: *mut List,
    pub alias: *mut Alias,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableFuncCol {
    pub type_: NodeTag,
    pub colname: *mut ::std::os::raw::c_char,
    pub typeName: *mut TypeName,
    pub for_ordinality: bool,
    pub is_not_null: bool,
    pub colexpr: *mut Node,
    pub coldefexpr: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableFuncCol {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableSample {
    pub type_: NodeTag,
    pub relation: *mut Node,
    pub method: *mut List,
    pub args: *mut List,
    pub repeatable: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableSample {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ColumnDef {
    pub type_: NodeTag,
    pub colname: *mut ::std::os::raw::c_char,
    pub typeName: *mut TypeName,
    pub inhcount: ::std::os::raw::c_int,
    pub is_local: bool,
    pub is_not_null: bool,
    pub is_from_type: bool,
    pub storage: ::std::os::raw::c_char,
    pub raw_default: *mut Node,
    pub cooked_default: *mut Node,
    pub identity: ::std::os::raw::c_char,
    pub identitySequence: *mut RangeVar,
    pub generated: ::std::os::raw::c_char,
    pub collClause: *mut CollateClause,
    pub collOid: Oid,
    pub constraints: *mut List,
    pub fdwoptions: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ColumnDef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableLikeClause {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub options: bits32,
    pub relationOid: Oid,
}
impl Default for TableLikeClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const TableLikeOption_CREATE_TABLE_LIKE_COMMENTS: TableLikeOption = 1;
pub const TableLikeOption_CREATE_TABLE_LIKE_CONSTRAINTS: TableLikeOption = 2;
pub const TableLikeOption_CREATE_TABLE_LIKE_DEFAULTS: TableLikeOption = 4;
pub const TableLikeOption_CREATE_TABLE_LIKE_GENERATED: TableLikeOption = 8;
pub const TableLikeOption_CREATE_TABLE_LIKE_IDENTITY: TableLikeOption = 16;
pub const TableLikeOption_CREATE_TABLE_LIKE_INDEXES: TableLikeOption = 32;
pub const TableLikeOption_CREATE_TABLE_LIKE_STATISTICS: TableLikeOption = 64;
pub const TableLikeOption_CREATE_TABLE_LIKE_STORAGE: TableLikeOption = 128;
pub const TableLikeOption_CREATE_TABLE_LIKE_ALL: TableLikeOption = 2147483647;
pub type TableLikeOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexElem {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub expr: *mut Node,
    pub indexcolname: *mut ::std::os::raw::c_char,
    pub collation: *mut List,
    pub opclass: *mut List,
    pub ordering: SortByDir,
    pub nulls_ordering: SortByNulls,
}
impl Default for IndexElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DefElemAction_DEFELEM_UNSPEC: DefElemAction = 0;
pub const DefElemAction_DEFELEM_SET: DefElemAction = 1;
pub const DefElemAction_DEFELEM_ADD: DefElemAction = 2;
pub const DefElemAction_DEFELEM_DROP: DefElemAction = 3;
pub type DefElemAction = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DefElem {
    pub type_: NodeTag,
    pub defnamespace: *mut ::std::os::raw::c_char,
    pub defname: *mut ::std::os::raw::c_char,
    pub arg: *mut Node,
    pub defaction: DefElemAction,
    pub location: ::std::os::raw::c_int,
}
impl Default for DefElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockingClause {
    pub type_: NodeTag,
    pub lockedRels: *mut List,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
}
impl Default for LockingClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XmlSerialize {
    pub type_: NodeTag,
    pub xmloption: XmlOptionType,
    pub expr: *mut Node,
    pub typeName: *mut TypeName,
    pub location: ::std::os::raw::c_int,
}
impl Default for XmlSerialize {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionElem {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub expr: *mut Node,
    pub collation: *mut List,
    pub opclass: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionSpec {
    pub type_: NodeTag,
    pub strategy: *mut ::std::os::raw::c_char,
    pub partParams: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionBoundSpec {
    pub type_: NodeTag,
    pub strategy: ::std::os::raw::c_char,
    pub is_default: bool,
    pub modulus: ::std::os::raw::c_int,
    pub remainder: ::std::os::raw::c_int,
    pub listdatums: *mut List,
    pub lowerdatums: *mut List,
    pub upperdatums: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionBoundSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_MINVALUE: PartitionRangeDatumKind = -1;
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_VALUE: PartitionRangeDatumKind = 0;
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_MAXVALUE: PartitionRangeDatumKind = 1;
pub type PartitionRangeDatumKind = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionRangeDatum {
    pub type_: NodeTag,
    pub kind: PartitionRangeDatumKind,
    pub value: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionRangeDatum {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionCmd {
    pub type_: NodeTag,
    pub name: *mut RangeVar,
    pub bound: *mut PartitionBoundSpec,
}
impl Default for PartitionCmd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RTEKind_RTE_RELATION: RTEKind = 0;
pub const RTEKind_RTE_SUBQUERY: RTEKind = 1;
pub const RTEKind_RTE_JOIN: RTEKind = 2;
pub const RTEKind_RTE_FUNCTION: RTEKind = 3;
pub const RTEKind_RTE_TABLEFUNC: RTEKind = 4;
pub const RTEKind_RTE_VALUES: RTEKind = 5;
pub const RTEKind_RTE_CTE: RTEKind = 6;
pub const RTEKind_RTE_NAMEDTUPLESTORE: RTEKind = 7;
pub const RTEKind_RTE_RESULT: RTEKind = 8;
pub type RTEKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblEntry {
    pub type_: NodeTag,
    pub rtekind: RTEKind,
    pub relid: Oid,
    pub relkind: ::std::os::raw::c_char,
    pub rellockmode: ::std::os::raw::c_int,
    pub tablesample: *mut TableSampleClause,
    pub subquery: *mut Query,
    pub security_barrier: bool,
    pub jointype: JoinType,
    pub joinaliasvars: *mut List,
    pub functions: *mut List,
    pub funcordinality: bool,
    pub tablefunc: *mut TableFunc,
    pub values_lists: *mut List,
    pub ctename: *mut ::std::os::raw::c_char,
    pub ctelevelsup: Index,
    pub self_reference: bool,
    pub coltypes: *mut List,
    pub coltypmods: *mut List,
    pub colcollations: *mut List,
    pub enrname: *mut ::std::os::raw::c_char,
    pub enrtuples: f64,
    pub alias: *mut Alias,
    pub eref: *mut Alias,
    pub lateral: bool,
    pub inh: bool,
    pub inFromCl: bool,
    pub requiredPerms: AclMode,
    pub checkAsUser: Oid,
    pub selectedCols: *mut Bitmapset,
    pub insertedCols: *mut Bitmapset,
    pub updatedCols: *mut Bitmapset,
    pub extraUpdatedCols: *mut Bitmapset,
    pub securityQuals: *mut List,
}
impl Default for RangeTblEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblFunction {
    pub type_: NodeTag,
    pub funcexpr: *mut Node,
    pub funccolcount: ::std::os::raw::c_int,
    pub funccolnames: *mut List,
    pub funccoltypes: *mut List,
    pub funccoltypmods: *mut List,
    pub funccolcollations: *mut List,
    pub funcparams: *mut Bitmapset,
}
impl Default for RangeTblFunction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableSampleClause {
    pub type_: NodeTag,
    pub tsmhandler: Oid,
    pub args: *mut List,
    pub repeatable: *mut Expr,
}
impl Default for TableSampleClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const WCOKind_WCO_VIEW_CHECK: WCOKind = 0;
pub const WCOKind_WCO_RLS_INSERT_CHECK: WCOKind = 1;
pub const WCOKind_WCO_RLS_UPDATE_CHECK: WCOKind = 2;
pub const WCOKind_WCO_RLS_CONFLICT_CHECK: WCOKind = 3;
pub type WCOKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WithCheckOption {
    pub type_: NodeTag,
    pub kind: WCOKind,
    pub relname: *mut ::std::os::raw::c_char,
    pub polname: *mut ::std::os::raw::c_char,
    pub qual: *mut Node,
    pub cascaded: bool,
}
impl Default for WithCheckOption {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortGroupClause {
    pub type_: NodeTag,
    pub tleSortGroupRef: Index,
    pub eqop: Oid,
    pub sortop: Oid,
    pub nulls_first: bool,
    pub hashable: bool,
}
impl Default for SortGroupClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const GroupingSetKind_GROUPING_SET_EMPTY: GroupingSetKind = 0;
pub const GroupingSetKind_GROUPING_SET_SIMPLE: GroupingSetKind = 1;
pub const GroupingSetKind_GROUPING_SET_ROLLUP: GroupingSetKind = 2;
pub const GroupingSetKind_GROUPING_SET_CUBE: GroupingSetKind = 3;
pub const GroupingSetKind_GROUPING_SET_SETS: GroupingSetKind = 4;
pub type GroupingSetKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupingSet {
    pub type_: NodeTag,
    pub kind: GroupingSetKind,
    pub content: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for GroupingSet {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowClause {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub refname: *mut ::std::os::raw::c_char,
    pub partitionClause: *mut List,
    pub orderClause: *mut List,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub startInRangeFunc: Oid,
    pub endInRangeFunc: Oid,
    pub inRangeColl: Oid,
    pub inRangeAsc: bool,
    pub inRangeNullsFirst: bool,
    pub winref: Index,
    pub copiedOrder: bool,
}
impl Default for WindowClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowMarkClause {
    pub type_: NodeTag,
    pub rti: Index,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
    pub pushedDown: bool,
}
impl Default for RowMarkClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WithClause {
    pub type_: NodeTag,
    pub ctes: *mut List,
    pub recursive: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for WithClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InferClause {
    pub type_: NodeTag,
    pub indexElems: *mut List,
    pub whereClause: *mut Node,
    pub conname: *mut ::std::os::raw::c_char,
    pub location: ::std::os::raw::c_int,
}
impl Default for InferClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictClause {
    pub type_: NodeTag,
    pub action: OnConflictAction,
    pub infer: *mut InferClause,
    pub targetList: *mut List,
    pub whereClause: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for OnConflictClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const CTEMaterialize_CTEMaterializeDefault: CTEMaterialize = 0;
pub const CTEMaterialize_CTEMaterializeAlways: CTEMaterialize = 1;
pub const CTEMaterialize_CTEMaterializeNever: CTEMaterialize = 2;
pub type CTEMaterialize = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommonTableExpr {
    pub type_: NodeTag,
    pub ctename: *mut ::std::os::raw::c_char,
    pub aliascolnames: *mut List,
    pub ctematerialized: CTEMaterialize,
    pub ctequery: *mut Node,
    pub location: ::std::os::raw::c_int,
    pub cterecursive: bool,
    pub cterefcount: ::std::os::raw::c_int,
    pub ctecolnames: *mut List,
    pub ctecoltypes: *mut List,
    pub ctecoltypmods: *mut List,
    pub ctecolcollations: *mut List,
}
impl Default for CommonTableExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TriggerTransition {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub isNew: bool,
    pub isTable: bool,
}
impl Default for TriggerTransition {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\t\tRaw Grammar Output Statements"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RawStmt {
    pub type_: NodeTag,
    pub stmt: *mut Node,
    pub stmt_location: ::std::os::raw::c_int,
    pub stmt_len: ::std::os::raw::c_int,
}
impl Default for RawStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\t\tOptimizable Statements"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InsertStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub cols: *mut List,
    pub selectStmt: *mut Node,
    pub onConflictClause: *mut OnConflictClause,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
    pub override_: OverridingKind,
}
impl Default for InsertStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeleteStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub usingClause: *mut List,
    pub whereClause: *mut Node,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
}
impl Default for DeleteStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UpdateStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub targetList: *mut List,
    pub whereClause: *mut Node,
    pub fromClause: *mut List,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
}
impl Default for UpdateStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SetOperation_SETOP_NONE: SetOperation = 0;
pub const SetOperation_SETOP_UNION: SetOperation = 1;
pub const SetOperation_SETOP_INTERSECT: SetOperation = 2;
pub const SetOperation_SETOP_EXCEPT: SetOperation = 3;
pub type SetOperation = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SelectStmt {
    pub type_: NodeTag,
    pub distinctClause: *mut List,
    pub intoClause: *mut IntoClause,
    pub targetList: *mut List,
    pub fromClause: *mut List,
    pub whereClause: *mut Node,
    pub groupClause: *mut List,
    pub havingClause: *mut Node,
    pub windowClause: *mut List,
    pub valuesLists: *mut List,
    pub sortClause: *mut List,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub lockingClause: *mut List,
    pub withClause: *mut WithClause,
    pub op: SetOperation,
    pub all: bool,
    pub larg: *mut SelectStmt,
    pub rarg: *mut SelectStmt,
}
impl Default for SelectStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOperationStmt {
    pub type_: NodeTag,
    pub op: SetOperation,
    pub all: bool,
    pub larg: *mut Node,
    pub rarg: *mut Node,
    pub colTypes: *mut List,
    pub colTypmods: *mut List,
    pub colCollations: *mut List,
    pub groupClauses: *mut List,
}
impl Default for SetOperationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ObjectType_OBJECT_ACCESS_METHOD: ObjectType = 0;
pub const ObjectType_OBJECT_AGGREGATE: ObjectType = 1;
pub const ObjectType_OBJECT_AMOP: ObjectType = 2;
pub const ObjectType_OBJECT_AMPROC: ObjectType = 3;
pub const ObjectType_OBJECT_ATTRIBUTE: ObjectType = 4;
pub const ObjectType_OBJECT_CAST: ObjectType = 5;
pub const ObjectType_OBJECT_COLUMN: ObjectType = 6;
pub const ObjectType_OBJECT_COLLATION: ObjectType = 7;
pub const ObjectType_OBJECT_CONVERSION: ObjectType = 8;
pub const ObjectType_OBJECT_DATABASE: ObjectType = 9;
pub const ObjectType_OBJECT_DEFAULT: ObjectType = 10;
pub const ObjectType_OBJECT_DEFACL: ObjectType = 11;
pub const ObjectType_OBJECT_DOMAIN: ObjectType = 12;
pub const ObjectType_OBJECT_DOMCONSTRAINT: ObjectType = 13;
pub const ObjectType_OBJECT_EVENT_TRIGGER: ObjectType = 14;
pub const ObjectType_OBJECT_EXTENSION: ObjectType = 15;
pub const ObjectType_OBJECT_FDW: ObjectType = 16;
pub const ObjectType_OBJECT_FOREIGN_SERVER: ObjectType = 17;
pub const ObjectType_OBJECT_FOREIGN_TABLE: ObjectType = 18;
pub const ObjectType_OBJECT_FUNCTION: ObjectType = 19;
pub const ObjectType_OBJECT_INDEX: ObjectType = 20;
pub const ObjectType_OBJECT_LANGUAGE: ObjectType = 21;
pub const ObjectType_OBJECT_LARGEOBJECT: ObjectType = 22;
pub const ObjectType_OBJECT_MATVIEW: ObjectType = 23;
pub const ObjectType_OBJECT_OPCLASS: ObjectType = 24;
pub const ObjectType_OBJECT_OPERATOR: ObjectType = 25;
pub const ObjectType_OBJECT_OPFAMILY: ObjectType = 26;
pub const ObjectType_OBJECT_POLICY: ObjectType = 27;
pub const ObjectType_OBJECT_PROCEDURE: ObjectType = 28;
pub const ObjectType_OBJECT_PUBLICATION: ObjectType = 29;
pub const ObjectType_OBJECT_PUBLICATION_REL: ObjectType = 30;
pub const ObjectType_OBJECT_ROLE: ObjectType = 31;
pub const ObjectType_OBJECT_ROUTINE: ObjectType = 32;
pub const ObjectType_OBJECT_RULE: ObjectType = 33;
pub const ObjectType_OBJECT_SCHEMA: ObjectType = 34;
pub const ObjectType_OBJECT_SEQUENCE: ObjectType = 35;
pub const ObjectType_OBJECT_SUBSCRIPTION: ObjectType = 36;
pub const ObjectType_OBJECT_STATISTIC_EXT: ObjectType = 37;
pub const ObjectType_OBJECT_TABCONSTRAINT: ObjectType = 38;
pub const ObjectType_OBJECT_TABLE: ObjectType = 39;
pub const ObjectType_OBJECT_TABLESPACE: ObjectType = 40;
pub const ObjectType_OBJECT_TRANSFORM: ObjectType = 41;
pub const ObjectType_OBJECT_TRIGGER: ObjectType = 42;
pub const ObjectType_OBJECT_TSCONFIGURATION: ObjectType = 43;
pub const ObjectType_OBJECT_TSDICTIONARY: ObjectType = 44;
pub const ObjectType_OBJECT_TSPARSER: ObjectType = 45;
pub const ObjectType_OBJECT_TSTEMPLATE: ObjectType = 46;
pub const ObjectType_OBJECT_TYPE: ObjectType = 47;
pub const ObjectType_OBJECT_USER_MAPPING: ObjectType = 48;
pub const ObjectType_OBJECT_VIEW: ObjectType = 49;
#[doc = "\t\tOther Statements (no optimizations required)"]
#[doc = ""]
#[doc = "\t\tThese are not touched by parser/analyze.c except to put them into"]
#[doc = "\t\tthe utilityStmt field of a Query.  This is eventually passed to"]
#[doc = "\t\tProcessUtility (by-passing rewriting and planning).  Some of the"]
#[doc = "\t\tstatements do need attention from parse analysis, and this is"]
#[doc = "\t\tdone by routines in parser/parse_utilcmd.c after ProcessUtility"]
#[doc = "\t\treceives the command for execution."]
#[doc = "\t\tDECLARE CURSOR, EXPLAIN, and CREATE TABLE AS are special cases:"]
#[doc = "\t\tthey contain optimizable statements, which get processed normally"]
#[doc = "\t\tby parser/analyze.c."]
pub type ObjectType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateSchemaStmt {
    pub type_: NodeTag,
    pub schemaname: *mut ::std::os::raw::c_char,
    pub authrole: *mut RoleSpec,
    pub schemaElts: *mut List,
    pub if_not_exists: bool,
}
impl Default for CreateSchemaStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DropBehavior_DROP_RESTRICT: DropBehavior = 0;
pub const DropBehavior_DROP_CASCADE: DropBehavior = 1;
pub type DropBehavior = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub cmds: *mut List,
    pub relkind: ObjectType,
    pub missing_ok: bool,
}
impl Default for AlterTableStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const AlterTableType_AT_AddColumn: AlterTableType = 0;
pub const AlterTableType_AT_AddColumnRecurse: AlterTableType = 1;
pub const AlterTableType_AT_AddColumnToView: AlterTableType = 2;
pub const AlterTableType_AT_ColumnDefault: AlterTableType = 3;
pub const AlterTableType_AT_DropNotNull: AlterTableType = 4;
pub const AlterTableType_AT_SetNotNull: AlterTableType = 5;
pub const AlterTableType_AT_CheckNotNull: AlterTableType = 6;
pub const AlterTableType_AT_SetStatistics: AlterTableType = 7;
pub const AlterTableType_AT_SetOptions: AlterTableType = 8;
pub const AlterTableType_AT_ResetOptions: AlterTableType = 9;
pub const AlterTableType_AT_SetStorage: AlterTableType = 10;
pub const AlterTableType_AT_DropColumn: AlterTableType = 11;
pub const AlterTableType_AT_DropColumnRecurse: AlterTableType = 12;
pub const AlterTableType_AT_AddIndex: AlterTableType = 13;
pub const AlterTableType_AT_ReAddIndex: AlterTableType = 14;
pub const AlterTableType_AT_AddConstraint: AlterTableType = 15;
pub const AlterTableType_AT_AddConstraintRecurse: AlterTableType = 16;
pub const AlterTableType_AT_ReAddConstraint: AlterTableType = 17;
pub const AlterTableType_AT_ReAddDomainConstraint: AlterTableType = 18;
pub const AlterTableType_AT_AlterConstraint: AlterTableType = 19;
pub const AlterTableType_AT_ValidateConstraint: AlterTableType = 20;
pub const AlterTableType_AT_ValidateConstraintRecurse: AlterTableType = 21;
pub const AlterTableType_AT_ProcessedConstraint: AlterTableType = 22;
pub const AlterTableType_AT_AddIndexConstraint: AlterTableType = 23;
pub const AlterTableType_AT_DropConstraint: AlterTableType = 24;
pub const AlterTableType_AT_DropConstraintRecurse: AlterTableType = 25;
pub const AlterTableType_AT_ReAddComment: AlterTableType = 26;
pub const AlterTableType_AT_AlterColumnType: AlterTableType = 27;
pub const AlterTableType_AT_AlterColumnGenericOptions: AlterTableType = 28;
pub const AlterTableType_AT_ChangeOwner: AlterTableType = 29;
pub const AlterTableType_AT_ClusterOn: AlterTableType = 30;
pub const AlterTableType_AT_DropCluster: AlterTableType = 31;
pub const AlterTableType_AT_SetLogged: AlterTableType = 32;
pub const AlterTableType_AT_SetUnLogged: AlterTableType = 33;
pub const AlterTableType_AT_DropOids: AlterTableType = 34;
pub const AlterTableType_AT_SetTableSpace: AlterTableType = 35;
pub const AlterTableType_AT_SetRelOptions: AlterTableType = 36;
pub const AlterTableType_AT_ResetRelOptions: AlterTableType = 37;
pub const AlterTableType_AT_ReplaceRelOptions: AlterTableType = 38;
pub const AlterTableType_AT_EnableTrig: AlterTableType = 39;
pub const AlterTableType_AT_EnableAlwaysTrig: AlterTableType = 40;
pub const AlterTableType_AT_EnableReplicaTrig: AlterTableType = 41;
pub const AlterTableType_AT_DisableTrig: AlterTableType = 42;
pub const AlterTableType_AT_EnableTrigAll: AlterTableType = 43;
pub const AlterTableType_AT_DisableTrigAll: AlterTableType = 44;
pub const AlterTableType_AT_EnableTrigUser: AlterTableType = 45;
pub const AlterTableType_AT_DisableTrigUser: AlterTableType = 46;
pub const AlterTableType_AT_EnableRule: AlterTableType = 47;
pub const AlterTableType_AT_EnableAlwaysRule: AlterTableType = 48;
pub const AlterTableType_AT_EnableReplicaRule: AlterTableType = 49;
pub const AlterTableType_AT_DisableRule: AlterTableType = 50;
pub const AlterTableType_AT_AddInherit: AlterTableType = 51;
pub const AlterTableType_AT_DropInherit: AlterTableType = 52;
pub const AlterTableType_AT_AddOf: AlterTableType = 53;
pub const AlterTableType_AT_DropOf: AlterTableType = 54;
pub const AlterTableType_AT_ReplicaIdentity: AlterTableType = 55;
pub const AlterTableType_AT_EnableRowSecurity: AlterTableType = 56;
pub const AlterTableType_AT_DisableRowSecurity: AlterTableType = 57;
pub const AlterTableType_AT_ForceRowSecurity: AlterTableType = 58;
pub const AlterTableType_AT_NoForceRowSecurity: AlterTableType = 59;
pub const AlterTableType_AT_GenericOptions: AlterTableType = 60;
pub const AlterTableType_AT_AttachPartition: AlterTableType = 61;
pub const AlterTableType_AT_DetachPartition: AlterTableType = 62;
pub const AlterTableType_AT_AddIdentity: AlterTableType = 63;
pub const AlterTableType_AT_SetIdentity: AlterTableType = 64;
pub const AlterTableType_AT_DropIdentity: AlterTableType = 65;
pub const AlterTableType_AT_CookedColumnDefault: AlterTableType = 66;
pub type AlterTableType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReplicaIdentityStmt {
    pub type_: NodeTag,
    pub identity_type: ::std::os::raw::c_char,
    pub name: *mut ::std::os::raw::c_char,
}
impl Default for ReplicaIdentityStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableCmd {
    pub type_: NodeTag,
    pub subtype: AlterTableType,
    pub name: *mut ::std::os::raw::c_char,
    pub num: int16,
    pub newowner: *mut RoleSpec,
    pub def: *mut Node,
    pub behavior: DropBehavior,
    pub missing_ok: bool,
    pub recurse: bool,
}
impl Default for AlterTableCmd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterCollationStmt {
    pub type_: NodeTag,
    pub collname: *mut List,
}
impl Default for AlterCollationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDomainStmt {
    pub type_: NodeTag,
    pub subtype: ::std::os::raw::c_char,
    pub typeName: *mut List,
    pub name: *mut ::std::os::raw::c_char,
    pub def: *mut Node,
    pub behavior: DropBehavior,
    pub missing_ok: bool,
}
impl Default for AlterDomainStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const GrantTargetType_ACL_TARGET_OBJECT: GrantTargetType = 0;
pub const GrantTargetType_ACL_TARGET_ALL_IN_SCHEMA: GrantTargetType = 1;
pub const GrantTargetType_ACL_TARGET_DEFAULTS: GrantTargetType = 2;
pub type GrantTargetType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrantStmt {
    pub type_: NodeTag,
    pub is_grant: bool,
    pub targtype: GrantTargetType,
    pub objtype: ObjectType,
    pub objects: *mut List,
    pub privileges: *mut List,
    pub grantees: *mut List,
    pub grant_option: bool,
    pub behavior: DropBehavior,
}
impl Default for GrantStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectWithArgs {
    pub type_: NodeTag,
    pub objname: *mut List,
    pub objargs: *mut List,
    pub args_unspecified: bool,
}
impl Default for ObjectWithArgs {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AccessPriv {
    pub type_: NodeTag,
    pub priv_name: *mut ::std::os::raw::c_char,
    pub cols: *mut List,
}
impl Default for AccessPriv {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrantRoleStmt {
    pub type_: NodeTag,
    pub granted_roles: *mut List,
    pub grantee_roles: *mut List,
    pub is_grant: bool,
    pub admin_opt: bool,
    pub grantor: *mut RoleSpec,
    pub behavior: DropBehavior,
}
impl Default for GrantRoleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDefaultPrivilegesStmt {
    pub type_: NodeTag,
    pub options: *mut List,
    pub action: *mut GrantStmt,
}
impl Default for AlterDefaultPrivilegesStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CopyStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub query: *mut Node,
    pub attlist: *mut List,
    pub is_from: bool,
    pub is_program: bool,
    pub filename: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub whereClause: *mut Node,
}
impl Default for CopyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const VariableSetKind_VAR_SET_VALUE: VariableSetKind = 0;
pub const VariableSetKind_VAR_SET_DEFAULT: VariableSetKind = 1;
pub const VariableSetKind_VAR_SET_CURRENT: VariableSetKind = 2;
pub const VariableSetKind_VAR_SET_MULTI: VariableSetKind = 3;
pub const VariableSetKind_VAR_RESET: VariableSetKind = 4;
pub const VariableSetKind_VAR_RESET_ALL: VariableSetKind = 5;
pub type VariableSetKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VariableSetStmt {
    pub type_: NodeTag,
    pub kind: VariableSetKind,
    pub name: *mut ::std::os::raw::c_char,
    pub args: *mut List,
    pub is_local: bool,
}
impl Default for VariableSetStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VariableShowStmt {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
}
impl Default for VariableShowStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub tableElts: *mut List,
    pub inhRelations: *mut List,
    pub partbound: *mut PartitionBoundSpec,
    pub partspec: *mut PartitionSpec,
    pub ofTypename: *mut TypeName,
    pub constraints: *mut List,
    pub options: *mut List,
    pub oncommit: OnCommitAction,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub accessMethod: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
}
impl Default for CreateStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ConstrType_CONSTR_NULL: ConstrType = 0;
pub const ConstrType_CONSTR_NOTNULL: ConstrType = 1;
pub const ConstrType_CONSTR_DEFAULT: ConstrType = 2;
pub const ConstrType_CONSTR_IDENTITY: ConstrType = 3;
pub const ConstrType_CONSTR_GENERATED: ConstrType = 4;
pub const ConstrType_CONSTR_CHECK: ConstrType = 5;
pub const ConstrType_CONSTR_PRIMARY: ConstrType = 6;
pub const ConstrType_CONSTR_UNIQUE: ConstrType = 7;
pub const ConstrType_CONSTR_EXCLUSION: ConstrType = 8;
pub const ConstrType_CONSTR_FOREIGN: ConstrType = 9;
pub const ConstrType_CONSTR_ATTR_DEFERRABLE: ConstrType = 10;
pub const ConstrType_CONSTR_ATTR_NOT_DEFERRABLE: ConstrType = 11;
pub const ConstrType_CONSTR_ATTR_DEFERRED: ConstrType = 12;
pub const ConstrType_CONSTR_ATTR_IMMEDIATE: ConstrType = 13;
pub type ConstrType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Constraint {
    pub type_: NodeTag,
    pub contype: ConstrType,
    pub conname: *mut ::std::os::raw::c_char,
    pub deferrable: bool,
    pub initdeferred: bool,
    pub location: ::std::os::raw::c_int,
    pub is_no_inherit: bool,
    pub raw_expr: *mut Node,
    pub cooked_expr: *mut ::std::os::raw::c_char,
    pub generated_when: ::std::os::raw::c_char,
    pub keys: *mut List,
    pub including: *mut List,
    pub exclusions: *mut List,
    pub options: *mut List,
    pub indexname: *mut ::std::os::raw::c_char,
    pub indexspace: *mut ::std::os::raw::c_char,
    pub reset_default_tblspc: bool,
    pub access_method: *mut ::std::os::raw::c_char,
    pub where_clause: *mut Node,
    pub pktable: *mut RangeVar,
    pub fk_attrs: *mut List,
    pub pk_attrs: *mut List,
    pub fk_matchtype: ::std::os::raw::c_char,
    pub fk_upd_action: ::std::os::raw::c_char,
    pub fk_del_action: ::std::os::raw::c_char,
    pub old_conpfeqop: *mut List,
    pub old_pktable_oid: Oid,
    pub skip_validation: bool,
    pub initially_valid: bool,
}
impl Default for Constraint {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTableSpaceStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub owner: *mut RoleSpec,
    pub location: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for CreateTableSpaceStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropTableSpaceStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
}
impl Default for DropTableSpaceStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableSpaceOptionsStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub isReset: bool,
}
impl Default for AlterTableSpaceOptionsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableMoveAllStmt {
    pub type_: NodeTag,
    pub orig_tablespacename: *mut ::std::os::raw::c_char,
    pub objtype: ObjectType,
    pub roles: *mut List,
    pub new_tablespacename: *mut ::std::os::raw::c_char,
    pub nowait: bool,
}
impl Default for AlterTableMoveAllStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateExtensionStmt {
    pub type_: NodeTag,
    pub extname: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
    pub options: *mut List,
}
impl Default for CreateExtensionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterExtensionStmt {
    pub type_: NodeTag,
    pub extname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for AlterExtensionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterExtensionContentsStmt