% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_make_clustermq.R
\name{tar_make_clustermq}
\alias{tar_make_clustermq}
\title{Superseded. Run a pipeline with persistent \code{clustermq} workers.}
\usage{
tar_make_clustermq(
  names = NULL,
  shortcut = targets::tar_config_get("shortcut"),
  reporter = targets::tar_config_get("reporter_make"),
  seconds_meta_append = targets::tar_config_get("seconds_meta_append"),
  seconds_meta_upload = targets::tar_config_get("seconds_meta_upload"),
  seconds_reporter = targets::tar_config_get("seconds_reporter"),
  seconds_interval = targets::tar_config_get("seconds_interval"),
  workers = targets::tar_config_get("workers"),
  log_worker = FALSE,
  callr_function = callr::r,
  callr_arguments = targets::tar_callr_args_default(callr_function, reporter),
  envir = parent.frame(),
  script = targets::tar_config_get("script"),
  store = targets::tar_config_get("store"),
  garbage_collection = NULL
)
}
\arguments{
\item{names}{Names of the targets to run or check. Set to \code{NULL} to
check/run all the targets (default).
The object supplied to \code{names} should be a
\code{tidyselect} expression like \code{\link[=any_of]{any_of()}} or \code{\link[=starts_with]{starts_with()}}
from \code{tidyselect} itself, or \code{\link[=tar_described_as]{tar_described_as()}} to select target names
based on their descriptions.}

\item{shortcut}{Logical of length 1, how to interpret the \code{names} argument.
If \code{shortcut} is \code{FALSE} (default) then the function checks
all targets upstream of \code{names} as far back as the dependency graph goes.
\code{shortcut = TRUE} increases speed if there are a lot of
up-to-date targets, but it assumes all the dependencies
are up to date, so please use with caution.
It relies on stored metadata for information about upstream dependencies.
\code{shortcut = TRUE} only works if you set \code{names}.}

\item{reporter}{Character of length 1, name of the reporter to user.
Controls how messages are printed as targets run in the pipeline.
Defaults to \code{tar_config_get("reporter_make")}. Choices:
\itemize{
\item \code{"balanced"} (default): a reporter that balances efficiency
with informative detail. Uses a \code{cli} progress bar.
To the right of the progress bar is a text string like
"22.6s, 4510+, 124-" (22.6 seconds elapsed, 4510 targets
completed successfully so far, 124 targets skipped so far).

For best results with the balanced reporter, you may need to
adjust your \code{cli} settings. See global options \code{cli.num_colors}
and \code{cli.dynamic} at
\url{https://cli.r-lib.org/reference/cli-config.html}.
On that page is also the \code{CLI_TICK_TIME} environment variable
which controls the time delay between progress bar updates.
If the delay is too low, then overhead from printing to the console
may slow down the pipeline.
\item \code{"silent"}: print nothing.
\item \code{"timestamp"}: same as the \code{"verbose"} reporter except that each
message begins with a time stamp.
\item \code{"verbose"}: print messages for individual targets
as they dispatch or complete. Each individual
target-specific time (e.g. "3.487 seconds") is strictly the
elapsed runtime of the target and does not include
steps like data retrieval and output storage.
}}

\item{seconds_meta_append}{Positive numeric of length 1 with the minimum
number of seconds between saves to the local metadata and progress files
in the data store.
his is an aggressive optimization setting not recommended
for most users:
higher values generally make the pipeline run faster, but unsaved
work (in the event of a crash) is not up to date.
When the pipeline ends,
all the metadata and progress data is saved immediately,
regardless of \code{seconds_meta_append}.

When the pipeline is just skipping targets, the actual interval
between saves is \code{max(1, seconds_meta_append)} to reduce
overhead.}

\item{seconds_meta_upload}{Positive numeric of length 1 with the minimum
number of seconds between uploads of the metadata and progress data
to the cloud
(see \url{https://books.ropensci.org/targets/cloud-storage.html}).
Higher values generally make the pipeline run faster, but unsaved
work (in the event of a crash) may not be backed up to the cloud.
When the pipeline ends,
all the metadata and progress data is uploaded immediately,
regardless of \code{seconds_meta_upload}.}

\item{seconds_reporter}{Deprecated on 2025-03-31
(\code{targets} version 1.10.1.9010).}

\item{seconds_interval}{Deprecated on 2023-08-24
(targets version 1.2.2.9001).
Use \code{seconds_meta_append} and \code{seconds_meta_upload} instead.}

\item{workers}{Positive integer, number of persistent \code{clustermq} workers
to create.}

\item{log_worker}{Logical, whether to write a log file for each worker.
Same as the \code{log_worker} argument of \code{clustermq::Q()}
and \code{clustermq::workers()}.}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}

\item{envir}{An environment, where to run the target R script
(default: \verb{_targets.R}) if \code{callr_function} is \code{NULL}.
Ignored if \code{callr_function} is anything other than \code{NULL}.
\code{callr_function} should only be \code{NULL} for debugging and
testing purposes, not for serious runs of a pipeline, etc.

The \code{envir} argument of \code{\link[=tar_make]{tar_make()}} and related
functions always overrides
the current value of \code{tar_option_get("envir")} in the current R session
just before running the target script file,
so whenever you need to set an alternative \code{envir}, you should always set
it with \code{tar_option_set()} from within the target script file.
In other words, if you call \code{tar_option_set(envir = envir1)} in an
interactive session and then
\code{tar_make(envir = envir2, callr_function = NULL)},
then \code{envir2} will be used.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}

\item{garbage_collection}{Deprecated. Use the \code{garbage_collection}
argument of \code{\link[=tar_option_set]{tar_option_set()}} instead to run garbage collection
at regular intervals in a pipeline, or use the argument of the same
name in \code{\link[=tar_target]{tar_target()}} to activate garbage collection for
a specific target.}
}
\value{
\code{NULL} except if \code{callr_function = callr::r_bg()}, in which case
a handle to the \code{callr} background process is returned. Either way,
the value is invisibly returned.
}
\description{
Superseded. Use \code{\link[=tar_make]{tar_make()}} with \code{crew}:
\url{https://books.ropensci.org/targets/crew.html}.
}
\details{
\code{tar_make_clustermq()} is like \code{\link[=tar_make]{tar_make()}} except that targets
run in parallel on persistent workers. A persistent worker is an
R process that runs for a long time and runs multiple
targets during its lifecycle. Persistent
workers launch as soon as the pipeline reaches an outdated
target with \code{deployment = "worker"}, and they keep running
until the pipeline starts to wind down.

To configure \code{tar_make_clustermq()}, you must configure
the \code{clustermq} package. To do this, set global options
\code{clustermq.scheduler} and \code{clustermq.template}
inside the target script file (default: \verb{_targets.R}).
To read more about configuring \code{clustermq} for your scheduler, visit
\url{https://mschubert.github.io/clustermq/articles/userguide.html#configuration} # nolint
or \url{https://books.ropensci.org/targets/hpc.html}.
\code{clustermq} is not a strict dependency of \code{targets},
so you must install \code{clustermq} yourself.
}
\section{Storage access}{

Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.
}

\examples{
if (!identical(tolower(Sys.info()[["sysname"]]), "windows")) {
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  library(targets)
  library(tarchetypes)
  options(clustermq.scheduler = "multiprocess") # Does not work on Windows.
  tar_option_set()
  list(tar_target(x, 1 + 1))
}, ask = FALSE)
tar_make_clustermq()
})
}
}
}
\seealso{
Other pipeline: 
\code{\link{tar_make}()},
\code{\link{tar_make_future}()}
}
\concept{pipeline}
