% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_seed_create.R
\name{tar_seed_create}
\alias{tar_seed_create}
\title{Create a seed for a target.}
\usage{
tar_seed_create(name, global_seed = NULL)
}
\arguments{
\item{name}{Character of length 1, target name.}

\item{global_seed}{Integer of length 1, the overarching global
pipeline seed which governs the seeds of all the targets.
Set to \code{NULL} to default to \code{tar_option_get("seed")}.
Set to \code{NA} to disable seed setting in \code{targets} and make
\code{\link[=tar_seed_create]{tar_seed_create()}} return \code{NA_integer_}.}
}
\value{
Integer of length 1, the target seed.
}
\description{
Create a seed for a target.
}
\section{Seeds}{

A target's random number generator seed
is a deterministic function of its name and the global pipeline seed
from \code{tar_option_get("seed")}. Consequently,

\if{html}{\out{<div class="sourceCode">}}\preformatted{1. Each target runs with a reproducible seed so that
   different runs of the same pipeline in the same computing
   environment produce identical results.
2. No two targets in the same pipeline share the same seed.
   Even dynamic branches have different names and thus different seeds.
}\if{html}{\out{</div>}}

You can retrieve the seed of a completed target
with \code{tar_meta(your_target, seed)}
and run \code{\link[=tar_seed_set]{tar_seed_set()}} on the result to locally
recreate the target's initial RNG state. \code{\link[=tar_workspace]{tar_workspace()}}
does this automatically as part of recovering a workspace.
}

\section{RNG overlap}{

In theory, there is a risk that the pseudo-random number generator
streams of different targets will overlap and produce statistically
correlated results. (For a discussion of the motivating problem,
see the Section 6: "Random-number generation" in the \code{parallel}
package vignette: \code{vignette(topic = "parallel", package = "parallel")}.)
However, this risk is extremely small in practice, as shown by
L'Ecuyer et al. (2017) \doi{10.1016/j.matcom.2016.05.005}
under "A single RNG with a 'random' seed for each stream" (Section 4:
under "How to produce parallel streams and substreams").
\code{targets} and \code{tarchetypes} take the approach discussed in the
aforementioned section of the paper using the
\code{secretbase} package by Charlie Gao (2024) \doi{10.5281/zenodo.10553140}.
To generate the 32-bit integer \code{seed} argument of \code{set.seed()}
for each target, \code{secretbase} generates a cryptographic hash using the
SHAKE256 extendable output function (XOF). \code{secretbase} uses algorithms
from the \verb{Mbed TLS} C library.
}

\references{
\itemize{
\item Gao C (2024). \code{secretbase}: Cryptographic Hash and
Extendable-Output Functions. R package version 0.1.0,
\doi{10.5281/zenodo.10553140}.
\item Pierre L'Ecuyer, David Munger, Boris Oreshkin, and Richard Simard
(2017). Random numbers for parallel computers: Requirements and methods,
with emphasis on GPUs. Mathematics and Computers in Simulation,
135, 3-17. \doi{10.1016/j.matcom.2016.05.005}.
}
}
\seealso{
Other pseudo-random number generation: 
\code{\link{tar_seed_get}()},
\code{\link{tar_seed_set}()}
}
\concept{pseudo-random number generation}
